"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getManifestQueriesPackagesSync = void 0;
const fs = __importStar(require("fs"));
const expo_build_properties_1 = require("expo-build-properties");
/**
 * Handles for edge case when LSApplicationQueriesSchemes is an object or undefined.
 */
const getIOSQuerySchemes = (config) => {
    return Array.isArray(config.ios?.infoPlist?.LSApplicationQueriesSchemes)
        ? config.ios?.infoPlist?.LSApplicationQueriesSchemes ?? []
        : [];
};
/**
 * Currently there are noway to get manifest queries config directly
 * So we parse AndroidManifest.xml to get the queries packages.
 */
function getManifestQueriesPackagesSync(manifestPath) {
    if (!fs.existsSync(manifestPath))
        return [];
    const xml = fs.readFileSync(manifestPath, 'utf8');
    const queriesSection = xml.match(/<queries>[\s\S]*?<\/queries>/);
    if (!queriesSection)
        return [];
    const matches = [...queriesSection[0].matchAll(/<package[^>]*android:name="([^"]+)"[^>]*\/>/g)];
    return matches.map((m) => m[1]);
}
exports.getManifestQueriesPackagesSync = getManifestQueriesPackagesSync;
exports.default = (config, props) => {
    let manifestPath = './android/app/src/main/AndroidManifest.xml';
    if (config.android?.publishManifestPath) {
        manifestPath = config.android.publishManifestPath;
    }
    const currentManifestQueries = getManifestQueriesPackagesSync(manifestPath);
    const updatedManifestQueries = (props.android ?? []).filter((p) => !currentManifestQueries.includes(p));
    const propConfig = {
        android: {},
    };
    /**
     * manifestQueries.package = [] would crashes the prebuild
     */
    if (updatedManifestQueries.length > 0) {
        propConfig.android = {
            manifestQueries: {
                package: updatedManifestQueries,
            },
        };
    }
    return (0, expo_build_properties_1.withBuildProperties)({
        ...config,
        android: {
            ...config.android,
            ...(props.enableBase64ShareAndroid
                ? {
                    permissions: [
                        ...new Set([
                            ...(config.android?.permissions ?? []),
                            'android.permission.WRITE_EXTERNAL_STORAGE',
                        ]),
                    ],
                }
                : {}),
        },
        ios: {
            ...config.ios,
            infoPlist: {
                ...config.ios?.infoPlist,
                LSApplicationQueriesSchemes: [...getIOSQuerySchemes(config), ...(props?.ios ?? [])],
            },
        },
    }, propConfig);
};
