// Implementation adapted from `react-native-safe-area-context`:
// https://github.com/AppAndFlow/react-native-safe-area-context/tree/v5.6.1
package com.swmansion.rnscreens.safearea

import androidx.core.graphics.Insets
import kotlin.math.max

data class EdgeInsets(
    val left: Float,
    val top: Float,
    val right: Float,
    val bottom: Float,
) {
    companion object {
        val ZERO: EdgeInsets = EdgeInsets(0.0f, 0.0f, 0.0f, 0.0f)

        fun fromInsets(insets: Insets) =
            EdgeInsets(
                insets.left.toFloat(),
                insets.top.toFloat(),
                insets.right.toFloat(),
                insets.bottom.toFloat(),
            )

        fun max(
            i1: EdgeInsets,
            i2: EdgeInsets,
        ) = EdgeInsets(
            max(i1.left, i2.left),
            max(i1.top, i2.top),
            max(i1.right, i2.right),
            max(i1.bottom, i2.bottom),
        )
    }
}
