"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Buffer = exports.extend = exports.PathComponent = exports.ScriptExpressions = exports.MultiKey = exports.CryptoPSBT = exports.CryptoOutput = exports.CryptoECKey = exports.CryptoCoinInfoNetwork = exports.CryptoCoinInfoType = exports.CryptoCoinInfo = exports.CryptoKeypath = exports.CryptoMultiAccounts = exports.CryptoHDKey = exports.CryptoAccount = exports.Bytes = exports.URRegistryDecoder = exports.DataItem = void 0;
const tslib_1 = require("tslib");
require("./patchCBOR");
const buffer_1 = require("buffer/");
Object.defineProperty(exports, "Buffer", { enumerable: true, get: function () { return buffer_1.Buffer; } });
const CryptoHDKey_1 = require("./CryptoHDKey");
Object.defineProperty(exports, "CryptoHDKey", { enumerable: true, get: function () { return CryptoHDKey_1.CryptoHDKey; } });
const CryptoKeypath_1 = require("./CryptoKeypath");
Object.defineProperty(exports, "CryptoKeypath", { enumerable: true, get: function () { return CryptoKeypath_1.CryptoKeypath; } });
const CryptoCoinInfo_1 = require("./CryptoCoinInfo");
Object.defineProperty(exports, "CryptoCoinInfo", { enumerable: true, get: function () { return CryptoCoinInfo_1.CryptoCoinInfo; } });
Object.defineProperty(exports, "CryptoCoinInfoType", { enumerable: true, get: function () { return CryptoCoinInfo_1.Type; } });
Object.defineProperty(exports, "CryptoCoinInfoNetwork", { enumerable: true, get: function () { return CryptoCoinInfo_1.Network; } });
const CryptoECKey_1 = require("./CryptoECKey");
Object.defineProperty(exports, "CryptoECKey", { enumerable: true, get: function () { return CryptoECKey_1.CryptoECKey; } });
const Bytes_1 = require("./Bytes");
Object.defineProperty(exports, "Bytes", { enumerable: true, get: function () { return Bytes_1.Bytes; } });
const CryptoOutput_1 = require("./CryptoOutput");
Object.defineProperty(exports, "CryptoOutput", { enumerable: true, get: function () { return CryptoOutput_1.CryptoOutput; } });
const CryptoPSBT_1 = require("./CryptoPSBT");
Object.defineProperty(exports, "CryptoPSBT", { enumerable: true, get: function () { return CryptoPSBT_1.CryptoPSBT; } });
const CryptoAccount_1 = require("./CryptoAccount");
Object.defineProperty(exports, "CryptoAccount", { enumerable: true, get: function () { return CryptoAccount_1.CryptoAccount; } });
const Decoder_1 = require("./Decoder");
Object.defineProperty(exports, "URRegistryDecoder", { enumerable: true, get: function () { return Decoder_1.URRegistryDecoder; } });
const MultiKey_1 = require("./MultiKey");
Object.defineProperty(exports, "MultiKey", { enumerable: true, get: function () { return MultiKey_1.MultiKey; } });
const ScriptExpression_1 = require("./ScriptExpression");
Object.defineProperty(exports, "ScriptExpressions", { enumerable: true, get: function () { return ScriptExpression_1.ScriptExpressions; } });
const PathComponent_1 = require("./PathComponent");
Object.defineProperty(exports, "PathComponent", { enumerable: true, get: function () { return PathComponent_1.PathComponent; } });
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
const lib_1 = require("./lib");
var lib_2 = require("./lib");
Object.defineProperty(exports, "DataItem", { enumerable: true, get: function () { return lib_2.DataItem; } });
const utils_1 = require("./utils");
const CryptoMultiAccounts_1 = require("./extended/CryptoMultiAccounts");
Object.defineProperty(exports, "CryptoMultiAccounts", { enumerable: true, get: function () { return CryptoMultiAccounts_1.CryptoMultiAccounts; } });
const URlib = {
    URRegistryDecoder: Decoder_1.URRegistryDecoder,
    Bytes: Bytes_1.Bytes,
    CryptoAccount: CryptoAccount_1.CryptoAccount,
    CryptoHDKey: CryptoHDKey_1.CryptoHDKey,
    CryptoMultiAccounts: CryptoMultiAccounts_1.CryptoMultiAccounts,
    CryptoKeypath: CryptoKeypath_1.CryptoKeypath,
    CryptoCoinInfo: CryptoCoinInfo_1.CryptoCoinInfo,
    CryptoCoinInfoType: CryptoCoinInfo_1.Type,
    CryptoCoinInfoNetwork: CryptoCoinInfo_1.Network,
    CryptoECKey: CryptoECKey_1.CryptoECKey,
    CryptoOutput: CryptoOutput_1.CryptoOutput,
    CryptoPSBT: CryptoPSBT_1.CryptoPSBT,
    MultiKey: MultiKey_1.MultiKey,
    ScriptExpressions: ScriptExpression_1.ScriptExpressions,
    PathComponent: PathComponent_1.PathComponent,
};
const cbor = {
    addReader: lib_1.addReader,
    addSemanticDecode: lib_1.addSemanticDecode,
    addSemanticEncode: lib_1.addSemanticEncode,
    addWriter: lib_1.addWriter,
    patchTags: utils_1.patchTags,
};
const extend = {
    RegistryTypes: RegistryType_1.RegistryTypes,
    RegistryItem: RegistryItem_1.RegistryItem,
    RegistryType: RegistryType_1.RegistryType,
    decodeToDataItem: lib_1.decodeToDataItem,
    encodeDataItem: lib_1.encodeDataItem,
    cbor,
};
exports.extend = extend;
(0, tslib_1.__exportStar)(require("./errors"), exports);
(0, tslib_1.__exportStar)(require("./Decoder"), exports);
(0, tslib_1.__exportStar)(require("./lib"), exports);
(0, tslib_1.__exportStar)(require("./CryptoAccount"), exports);
(0, tslib_1.__exportStar)(require("./CryptoPSBT"), exports);
(0, tslib_1.__exportStar)(require("./CryptoHDKey"), exports);
(0, tslib_1.__exportStar)(require("./extended/CryptoMultiAccounts"), exports);
(0, tslib_1.__exportStar)(require("./extended/QRHardwareCall"), exports);
(0, tslib_1.__exportStar)(require("./extended/KeyDerivation"), exports);
(0, tslib_1.__exportStar)(require("./extended/DerivationSchema"), exports);
(0, tslib_1.__exportStar)(require("./CryptoOutput"), exports);
(0, tslib_1.__exportStar)(require("./CryptoCoinInfo"), exports);
(0, tslib_1.__exportStar)(require("./CryptoECKey"), exports);
(0, tslib_1.__exportStar)(require("./MultiKey"), exports);
(0, tslib_1.__exportStar)(require("./CryptoKeypath"), exports);
(0, tslib_1.__exportStar)(require("./patchCBOR"), exports);
(0, tslib_1.__exportStar)(require("./PathComponent"), exports);
(0, tslib_1.__exportStar)(require("./RegistryItem"), exports);
(0, tslib_1.__exportStar)(require("./RegistryType"), exports);
(0, tslib_1.__exportStar)(require("./types"), exports);
(0, tslib_1.__exportStar)(require("./utils"), exports);
exports.default = URlib;
//# sourceMappingURL=index.js.map