import './patchCBOR';
import { Buffer } from 'buffer/';
import { CryptoHDKey } from './CryptoHDKey';
import { CryptoKeypath } from './CryptoKeypath';
import { CryptoCoinInfo, Type as CryptoCoinInfoType, Network as CryptoCoinInfoNetwork } from './CryptoCoinInfo';
import { CryptoECKey } from './CryptoECKey';
import { Bytes } from './Bytes';
import { CryptoOutput } from './CryptoOutput';
import { CryptoPSBT } from './CryptoPSBT';
import { CryptoAccount } from './CryptoAccount';
import { URRegistryDecoder } from './Decoder';
import { MultiKey } from './MultiKey';
import { ScriptExpressions } from './ScriptExpression';
import { PathComponent } from './PathComponent';
import { RegistryItem } from './RegistryItem';
import { RegistryType } from './RegistryType';
import { addReader, addSemanticDecode, addSemanticEncode, addWriter, decodeToDataItem, encodeDataItem } from './lib';
export { DataItem } from './lib';
import { CryptoMultiAccounts } from "./extended/CryptoMultiAccounts";
declare const URlib: {
    URRegistryDecoder: typeof URRegistryDecoder;
    Bytes: typeof Bytes;
    CryptoAccount: typeof CryptoAccount;
    CryptoHDKey: typeof CryptoHDKey;
    CryptoMultiAccounts: typeof CryptoMultiAccounts;
    CryptoKeypath: typeof CryptoKeypath;
    CryptoCoinInfo: typeof CryptoCoinInfo;
    CryptoCoinInfoType: typeof CryptoCoinInfoType;
    CryptoCoinInfoNetwork: typeof CryptoCoinInfoNetwork;
    CryptoECKey: typeof CryptoECKey;
    CryptoOutput: typeof CryptoOutput;
    CryptoPSBT: typeof CryptoPSBT;
    MultiKey: typeof MultiKey;
    ScriptExpressions: {
        SCRIPT_HASH: import("./ScriptExpression").ScriptExpression;
        WITNESS_SCRIPT_HASH: import("./ScriptExpression").ScriptExpression;
        PUBLIC_KEY: import("./ScriptExpression").ScriptExpression;
        PUBLIC_KEY_HASH: import("./ScriptExpression").ScriptExpression;
        WITNESS_PUBLIC_KEY_HASH: import("./ScriptExpression").ScriptExpression;
        COMBO: import("./ScriptExpression").ScriptExpression;
        MULTISIG: import("./ScriptExpression").ScriptExpression;
        SORTED_MULTISIG: import("./ScriptExpression").ScriptExpression;
        ADDRESS: import("./ScriptExpression").ScriptExpression;
        RAW_SCRIPT: import("./ScriptExpression").ScriptExpression;
    };
    PathComponent: typeof PathComponent;
};
declare const extend: {
    RegistryTypes: {
        UUID: RegistryType;
        BYTES: RegistryType;
        CRYPTO_HDKEY: RegistryType;
        CRYPTO_KEYPATH: RegistryType;
        CRYPTO_COIN_INFO: RegistryType;
        CRYPTO_ECKEY: RegistryType;
        CRYPTO_OUTPUT: RegistryType;
        CRYPTO_PSBT: RegistryType;
        CRYPTO_ACCOUNT: RegistryType;
        CRYPTO_MULTI_ACCOUNTS: RegistryType;
        QR_HARDWARE_CALL: RegistryType;
        KEY_DERIVATION_CALL: RegistryType;
        KEY_DERIVATION_SCHEMA: RegistryType;
    };
    RegistryItem: typeof RegistryItem;
    RegistryType: typeof RegistryType;
    decodeToDataItem: typeof decodeToDataItem;
    encodeDataItem: typeof encodeDataItem;
    cbor: {
        addReader: typeof addReader;
        addSemanticDecode: typeof addSemanticDecode;
        addSemanticEncode: typeof addSemanticEncode;
        addWriter: typeof addWriter;
        patchTags: (tags: number[]) => void;
    };
};
export { URRegistryDecoder, Bytes, CryptoAccount, CryptoHDKey, CryptoMultiAccounts, CryptoKeypath, CryptoCoinInfo, CryptoCoinInfoType, CryptoCoinInfoNetwork, CryptoECKey, CryptoOutput, CryptoPSBT, MultiKey, ScriptExpressions, PathComponent, extend, Buffer };
export * from './errors';
export * from './Decoder';
export * from './lib';
export * from './CryptoAccount';
export * from './CryptoPSBT';
export * from './CryptoHDKey';
export * from './extended/CryptoMultiAccounts';
export * from './extended/QRHardwareCall';
export * from './extended/KeyDerivation';
export * from './extended/DerivationSchema';
export * from './CryptoOutput';
export * from './CryptoCoinInfo';
export * from './CryptoECKey';
export * from './MultiKey';
export * from './CryptoKeypath';
export * from './patchCBOR';
export * from './PathComponent';
export * from './RegistryItem';
export * from './RegistryType';
export * from './types';
export * from './utils';
export default URlib;
