"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CryptoMultiAccounts = void 0;
const _1 = require(".");
const lib_1 = require("./lib");
const RegistryItem_1 = require("./RegistryItem");
const RegistryType_1 = require("./RegistryType");
const buffer_1 = require("buffer");
var Keys;
(function (Keys) {
    Keys[Keys["masterFingerprint"] = 1] = "masterFingerprint";
    Keys[Keys["keys"] = 2] = "keys";
    Keys[Keys["origin"] = 3] = "origin";
})(Keys || (Keys = {}));
class CryptoMultiAccounts extends RegistryItem_1.RegistryItem {
    constructor(masterFingerprint, keys, origin) {
        super();
        this.masterFingerprint = masterFingerprint;
        this.keys = keys;
        this.origin = origin;
        this.getRegistryType = () => {
            return RegistryType_1.RegistryTypes.CRYPTO_ACCOUNT;
        };
        this.getMasterFingerprint = () => this.masterFingerprint;
        this.getOrigin = () => this.origin;
        this.toDataItem = () => {
            const map = {};
            map[Keys.masterFingerprint] = this.masterFingerprint.readUInt32BE(0);
            map[Keys.keys] = this.keys.map((key) => key.toDataItem());
            if (this.origin !== undefined) {
                map[Keys.origin] = this.origin;
            }
            return new lib_1.DataItem(map);
        };
    }
}
exports.CryptoMultiAccounts = CryptoMultiAccounts;
CryptoMultiAccounts.fromDataItem = (dataItem) => {
    const map = dataItem.getData();
    const masterFingerprint = buffer_1.Buffer.alloc(4);
    const _masterFingerprint = map[Keys.masterFingerprint];
    masterFingerprint.writeUInt32BE(_masterFingerprint, 0);
    const keys = map[Keys.keys];
    const cryptoHDKeys = keys.map((key) => _1.CryptoHDKey.fromDataItem(key));
    const origin = map[Keys.origin];
    return new CryptoMultiAccounts(masterFingerprint, cryptoHDKeys, origin);
};
CryptoMultiAccounts.fromCBOR = (_cborPayload) => {
    const dataItem = lib_1.decodeToDataItem(_cborPayload);
    return CryptoMultiAccounts.fromDataItem(dataItem);
};
//# sourceMappingURL=CryptoMultiAccounts.js.map