/// <reference types="node" />
import { CryptoKeypath, DataItem, RegistryItem } from "@keystonehq/bc-ur-registry";
export declare enum DataType {
    message = 1
}
declare type signRequestProps = {
    requestId: Buffer;
    signData: Buffer;
    dataType: DataType;
    derivationPaths: CryptoKeypath[];
    addresses?: string[];
    origin?: string;
};
export declare class BtcSignRequest extends RegistryItem {
    private requestId;
    private signData;
    private dataType;
    private derivationPaths;
    private addresses?;
    private origin?;
    getRegistryType: () => import("@keystonehq/bc-ur-registry").RegistryType;
    constructor(args: signRequestProps);
    getRequestId: () => Buffer;
    getSignData: () => Buffer;
    getDataype: () => DataType;
    getDerivationPaths: () => string[];
    getAddress: () => string[] | undefined;
    getOrigin: () => string | undefined;
    toDataItem: () => DataItem;
    static fromDataItem: (dataItem: DataItem) => BtcSignRequest;
    static fromCBOR: (_cborPayload: Buffer) => BtcSignRequest;
    static constructBtcRequest(uuidString: string, xfps: string[], signData: Buffer, dataType: DataType, derivationHDPaths: string[], addresses?: string[], origin?: string): BtcSignRequest;
}
export {};
