/**
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow strict
 * @noformat
 * @generated by scripts/releases/set-version.js
 */

/**
 * Object containing the current React Native version.
 *
 * Specifically, this is the source of truth for the resolved `react-native`
 * package in the JavaScript bundle. Apps and libraries can use this to
 * determine compatibility or enable version-specific features.
 *
 * @example
 * ```js
 * // Get the full version string
 * const version = ReactNativeVersion.getVersionString();
 *
 * // Access individual version components
 * const major = ReactNativeVersion.major;
 * ```
 */
export default class ReactNativeVersion {
  static major: number = 0;
  static minor: number = 82;
  static patch: number = 1;
  static prerelease: string | null = null;

  static getVersionString(): string {
    return `${this.major}.${this.minor}.${this.patch}${this.prerelease != null ? `-${this.prerelease}` : ''}`;
  }
}

/**
 * @deprecated Compatibility export — please import `ReactNativeVersion` from
 *   `react-native`.
 * See https://github.com/react-native-community/discussions-and-proposals/pull/894.
 */
export const version = {
  major: ReactNativeVersion.major,
  minor: ReactNativeVersion.minor,
  patch: ReactNativeVersion.patch,
  prerelease: ReactNativeVersion.prerelease,
};
