"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.prepareHeaderBarButtonItems = void 0;
var _reactNative = require("react-native");
const prepareMenu = (menu, index, side) => {
  return {
    ...menu,
    items: menu.items.map((menuItem, menuIndex) => {
      const sfSymbolName = menuItem.icon?.type === 'sfSymbol' ? menuItem.icon.name : undefined;
      if (menuItem.type === 'submenu') {
        return {
          ...menuItem,
          sfSymbolName,
          ...prepareMenu(menuItem, menuIndex, side)
        };
      }
      return {
        ...menuItem,
        sfSymbolName,
        menuId: `${menuIndex}-${index}-${side}`
      };
    })
  };
};
const prepareHeaderBarButtonItems = (barButtonItems, side) => {
  return barButtonItems?.map((item, index) => {
    if ('spacing' in item) {
      return item;
    }
    let imageSource;
    if (item.icon?.type === 'imageSource') {
      imageSource = _reactNative.Image.resolveAssetSource(item.icon.imageSource);
    } else if (item.icon?.type === 'templateSource') {
      imageSource = _reactNative.Image.resolveAssetSource(item.icon.templateSource);
    }
    const labelStyle = item.labelStyle ? {
      ...item.labelStyle,
      color: (0, _reactNative.processColor)(item.labelStyle.color)
    } : undefined;
    const tintColor = item.tintColor ? (0, _reactNative.processColor)(item.tintColor) : undefined;
    const badge = item.badge ? {
      ...item.badge,
      style: {
        ...item.badge.style,
        color: (0, _reactNative.processColor)(item.badge.style?.color),
        backgroundColor: (0, _reactNative.processColor)(item.badge.style?.backgroundColor)
      }
    } : undefined;
    const processedItem = {
      ...item,
      imageSource,
      sfSymbolName: item.icon?.type === 'sfSymbol' ? item.icon.name : undefined,
      labelStyle,
      tintColor,
      badge
    };
    if ('onPress' in item) {
      return {
        ...processedItem,
        buttonId: `${index}-${side}`
      };
    }
    if ('menu' in item) {
      return {
        ...processedItem,
        menu: prepareMenu(item.menu, index, side)
      };
    }
    return null;
  });
};
exports.prepareHeaderBarButtonItems = prepareHeaderBarButtonItems;
//# sourceMappingURL=prepareHeaderBarButtonItems.js.map