declare enum Network {
    mainnet = "mainnet",
    testnet = "testnet",
    regtest = "regtest",
    signet = "signet"
}
declare enum AddressType {
    p2pkh = "p2pkh",
    p2sh = "p2sh",
    p2wpkh = "p2wpkh",
    p2wsh = "p2wsh",
    p2tr = "p2tr"
}
type AddressInfo = {
    bech32: boolean;
    network: Network;
    address: string;
    type: AddressType;
};
type Options = {
    castTestnetTo?: Network.regtest | Network.signet;
};
declare const getAddressInfo: (address: string, options?: Options) => AddressInfo;
declare const validate: (address: string, network?: Network, options?: Options) => boolean;
export { getAddressInfo, Network, AddressType, validate };
export type { AddressInfo };
export default validate;
//# sourceMappingURL=index.d.ts.map