/// <reference types="node" />
import { RegistryItem } from '../RegistryItem';
import { DataItem } from '../lib';
import { KeyDerivation } from './KeyDerivation';
export declare enum QRHardwareCallType {
    KeyDerivation = 0
}
declare type QRHardwareCallParams = KeyDerivation;
export declare class QRHardwareCall extends RegistryItem {
    private type;
    private params;
    private origin?;
    getRegistryType: () => import("../RegistryType").RegistryType;
    constructor(type: QRHardwareCallType, params: QRHardwareCallParams, origin?: string);
    getType: () => number;
    getParams: () => QRHardwareCallParams;
    getOrigin: () => string | undefined;
    toDataItem: () => DataItem;
    static fromDataItem: (dataItem: DataItem) => QRHardwareCall;
    static fromCBOR: (_cborPayload: Buffer) => QRHardwareCall;
}
export {};
