import {
  ImageStyle,
  Platform,
  StyleSheet,
  TextStyle,
  ViewStyle,
} from 'react-native';

export interface Theme {
  colors: {
    background: string;
    cardBackground: string;
    primary: string;
    subPrimary: string;
    secondary: string;
    accent: string;
    danger: string;
    text: string;
    textSecondary: string;
    textOnPrimary: string;
    white: string;
    border: string;
    disabled: string;
    sent: string;
    received: string;
    buttonText: string;
    disabledText: string;
    modalBackdrop: string;
    lightGray: string;
    mediumGray: string;
    shadowColor: string;
  };
  fontSizes?: {
    xs: number;
    sm: number;
    base: number;
    md: number;
    lg: number;
    xl: number;
    '2xl': number;
    '3xl': number;
    small?: number;
    medium?: number;
    large?: number;
    extraLarge?: number;
  };
  fontWeights?: {
    normal: string;
    medium: string;
    semibold: string;
    bold: string;
  };
  fontFamilies?: {
    regular: string;
    monospace: string;
  };
}

export interface Styles {
  actionButton: ViewStyle;
  settingsButton: ViewStyle;
  headerTitleContainer: ViewStyle;
  headerLogo: ImageStyle;
  headerTitleText: TextStyle;
  container: ViewStyle;
  contentContainer: ViewStyle;
  walletHeader: ViewStyle;
  headerTop: ViewStyle;
  btcLogo: ImageStyle;
  settingsLogo: ImageStyle;
  priceContainer: ViewStyle;
  btcPrice: TextStyle;
  currencyBadge: TextStyle;
  balanceContainer: ViewStyle;
  balanceHeaderRow: ViewStyle;
  balanceRow: ViewStyle;
  balanceRowWithMargin: ViewStyle;
  balanceBTC: TextStyle;
  balanceFiat: TextStyle;
  balanceIcon: ImageStyle;
  blurredText: TextStyle;
  balanceHint: TextStyle;
  balanceTouchable: ViewStyle;
  balanceLoadingIndicator: ViewStyle;
  balanceErrorContainer: ViewStyle;
  balanceErrorText: TextStyle;
  providerValueCompact: TextStyle;
  qrContainer: ViewStyle;
  address: TextStyle;
  partyContainer: ViewStyle;
  partyLeft: ViewStyle;
  partyCenter: ViewStyle;
  partyRight: ViewStyle;
  party: TextStyle;
  partyText: TextStyle;
  partyLabel: TextStyle;
  partyValue: TextStyle;
  actions: ViewStyle;
  sendButton: ViewStyle;
  sendButtonText: TextStyle;
  sendButtonDisabled: ViewStyle;
  addressTypeModalButton: ViewStyle;
  addressTypeButtonText: TextStyle;
  addressTypeButtonIcon: ImageStyle;
  receiveButton: ViewStyle;
  receiveButtonText: TextStyle;
  modalOverlay: ViewStyle;
  modalContent: ViewStyle;
  modalText: TextStyle;
  actionButtonText: TextStyle;
  addressTypeButton: ViewStyle;
  addressTypeButtonSelected: ViewStyle;
  addressTypeLabel: TextStyle;
  addressTypeValue: TextStyle;
  addressTypeIcon: ImageStyle;
  modalAddressTypeIcon: ImageStyle;
  addressTypeContent: ViewStyle;
  modalTitle: TextStyle;
  scrollView: ViewStyle;
  cacheIndicator: ViewStyle;
  refreshText: TextStyle;
  refreshIcon: ImageStyle;
  cacheText: TextStyle;
  shimmerContainer: ViewStyle;
  shimmer: ViewStyle;
  disabled: ViewStyle;
  transactionListContainer: ViewStyle;
  sectionHeader: ViewStyle;
  sectionTitle: TextStyle;
  sectionSubtitle: TextStyle;
  emptyStateContainer: ViewStyle;
  emptyStateText: TextStyle;
  emptyStateIcon: ImageStyle;
  actionButtonIcon: ImageStyle;
  addressTypeContainer: ViewStyle;
  addressTypeClickable: ViewStyle;
  networkRow: ViewStyle;
  networkIcon: ImageStyle;
  rowCenter: ViewStyle;
  rowFullWidth: ViewStyle;
  columnCenter: ViewStyle;
  rowCenterMarginTop2: ViewStyle;
  flexOneMinWidthZero: ViewStyle;
  partyGap: ViewStyle;
  modalGoSettingsButton: ViewStyle;
  modalCloseButton: ViewStyle;
  modalCloseButtonText: TextStyle;
  modalBoldText: TextStyle;
  modalTextLeft: TextStyle;
  modalInfoIcon: ImageStyle;
  modalActionButtonText: TextStyle;
  modalParagraph: ViewStyle;
  modalHeaderRow: ViewStyle;
  modalHeaderIcon: ImageStyle;
  modalHeaderTitle: TextStyle;
  modalActionsRow: ViewStyle;
  modalActionLeft: ViewStyle;
  modalActionRight: ViewStyle;
  linkText: TextStyle;
  apiDisplayContainer: ViewStyle;
  apiDisplayButton: ViewStyle;
  apiDisplayContent: ViewStyle;
  apiDisplayIcon: ImageStyle;
  apiDisplayLabel: TextStyle;
  apiDisplayValue: TextStyle;
  providerRow: ViewStyle;
  providerItem: ViewStyle;
  providerLeft: ViewStyle;
  providerIcon: ImageStyle;
  providerLabel: TextStyle;
  providerValue: TextStyle;
  networkBadge: ViewStyle;
  networkBadgeText: TextStyle;
  warningBox: ViewStyle;
  warningText: TextStyle;
  backupButton: ViewStyle;
  backupButtonText: TextStyle;
  modalOptionCheckIcon: ImageStyle;
  addressTypeLabelRow: ViewStyle;
  recommendBadge: ViewStyle;
  recommendBadgeText: TextStyle;
  warningBoxWithMargin: ViewStyle;
  modalTipText: TextStyle;
  backupButtonWithMargin: ViewStyle;
  modalContentCompact: ViewStyle;
  modalHeaderRowCompact: ViewStyle;
  modalHeaderIconCompact: ImageStyle;
  modalHeaderTitleCompact: TextStyle;
  modalTextCompact: TextStyle;
  modalBoldTextCompact: TextStyle;
  warningBoxCompact: ViewStyle;
  warningTextCompact: TextStyle;
  modalTipTextCompact: TextStyle;
  backupButtonCompact: ViewStyle;
  backupButtonTextCompact: TextStyle;
  keyshareModalCloseButton: ViewStyle;
  keyshareModalCloseText: TextStyle;
  keyshareModalContent: ViewStyle;
  keyshareInfoRow: ViewStyle;
  keyshareTable: ViewStyle;
  keyshareTableRow: ViewStyle;
  keyshareTableKey: TextStyle;
  keyshareTableValue: TextStyle;
  keyshareTableValueContainer: ViewStyle;
  keyshareTableValueKey: TextStyle;
  keyshareTableValueSuccess: TextStyle;
  keyshareTableValueDisabled: TextStyle;
  keyshareInfoLabel: TextStyle;
  keyshareInfoValue: TextStyle;
  keyshareInfoValueSuccess: TextStyle;
  keyshareInfoValueDisabled: TextStyle;
  keyshareKeySection: ViewStyle;
  keyshareKeyContainer: ViewStyle;
  keyshareKeyText: TextStyle;
  keyshareCopyButton: ViewStyle;
  keyshareCopyButtonText: TextStyle;
  keyshareCopyIcon: ImageStyle;
  keyshareButtonsRow: ViewStyle;
  qrModalContent: ViewStyle;
  qrModalTitle: TextStyle;
  qrModalSubtitle: TextStyle;
  qrCodeContainer: ViewStyle;
  qrModalHint: TextStyle;
  qrModalCloseButton: ViewStyle;
  qrModalCloseButtonText: TextStyle;
  keyshareLoadingContainer: ViewStyle;
  keyshareBackupButtonMargin: ViewStyle;
  keyshareButtonsContainer: ViewStyle;
  keyshareCloseButton: ViewStyle;
  keyshareBackupButton: ViewStyle;
  keyshareModalBody: ViewStyle;
  keyshareModalBodyContent: ViewStyle;
  keyshareInfoCard: ViewStyle;
  keyshareSectionTitle: TextStyle;
  keyshareDetailRow: ViewStyle;
  keyshareDetailLabel: TextStyle;
  keyshareDetailValue: TextStyle;
  keyshareBadge: ViewStyle;
  keyshareBadgeText: TextStyle;
  keyshareBadgeTrio: ViewStyle;
  keyshareBadgeDuo: ViewStyle;
  keyshareStatusBadge: ViewStyle;
  keyshareStatusBadgeText: TextStyle;
  keyshareStatusBadgeSuccess: ViewStyle;
  keyshareStatusBadgeDisabled: ViewStyle;
  keyshareStatusBadgeTextSuccess: TextStyle;
  keyshareStatusBadgeTextDisabled: TextStyle;
  keyshareKeyItem: ViewStyle;
  keyshareKeyLabel: TextStyle;
  watchWalletHeader: ViewStyle;
  keyshareInfoHeader: TextStyle;
  watchWalletTitle: TextStyle;
  watchWalletDescription: TextStyle;
  watchWalletWarning: TextStyle;
  watchWalletItem: ViewStyle;
  watchWalletItemLabel: TextStyle;
  watchWalletItemValue: TextStyle;
  watchWalletItemValueContainer: ViewStyle;
  clickableTextContainer: ViewStyle;
  clickableText: TextStyle;
  qrModalButtonsContainer: ViewStyle;
  qrModalShareButton: ViewStyle;
  qrModalShareIcon: ImageStyle;
  qrModalCloseButtonWithMargin: ViewStyle;
  toastContainer: ViewStyle;
  qrModalHeader: ViewStyle;
  qrModalHeaderTitle: TextStyle;
  qrModalTopRightCloseButton: ViewStyle;
  qrModalTopRightCloseText: TextStyle;
  qrModalShareButtonSingle: ViewStyle;
  qrModalButtonsContainerCentered: ViewStyle;
}

export const createStyles = (theme: Theme): Styles => ({
  actionButton: {
    paddingVertical: 12,
    marginBottom: 4,
    borderRadius: 8,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
  },
  settingsButton: {
    marginBottom: 0,
    marginHorizontal: 0,
    borderRadius: 10,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    width: 36,
    height: 36,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(0, 0, 0, 0.06)'
      : theme.colors.cardBackground,
    borderWidth: 1,
    borderColor: theme.colors.background === '#ffffff'
      ? 'rgba(0, 0, 0, 0.1)'
      : theme.colors.border + '80',
    padding: 0,
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 1},
    shadowOpacity: 0.05,
    shadowRadius: 3,
    elevation: Platform.OS === 'android' ? 0 : 1,
  },
  settingsLogo: {
    marginTop: 0,
    height: 20,
    width: 20,
    tintColor: theme.colors.text,
    opacity: 0.8,
    resizeMode: 'contain',
  },
  headerTitleContainer: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'flex-start' as const,
    marginLeft: 0,
    paddingLeft: 8,
    minWidth: 0,
  },
  headerLogo: {
    width: 40,
    height: 40,
    resizeMode: 'contain' as const,
    marginRight: 8,
  },
  headerTitleText: {
    fontSize: theme.fontSizes?.xl || 18,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text, // Use theme text color for both light and dark mode
  },
  container: {
    flex: 1,
    backgroundColor: theme.colors.background,
  },
  contentContainer: {
    paddingTop: 12,
    paddingLeft: 16,
    paddingRight: 16,
    paddingBottom: 0,
    // Keep header above siblings (CacheIndicator/TransactionList)
    position: 'relative' as const,
    zIndex: 2,
  },
  walletHeader: {
    padding: 12,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(26, 43, 60, 0.95)' // Increased opacity for better contrast in light mode
      : 'rgba(255, 255, 255, 0.15)', // Brighter glassy overlay for better contrast in dark mode
    borderRadius: 12,
    alignItems: 'stretch' as const, // Changed from 'center' to allow marginHorizontal to work
    marginBottom: 0,
    borderWidth: 1,
    borderColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.3)' // More visible border for better contrast in light mode
      : 'rgba(255, 255, 255, 0.3)', // More visible border for better contrast in dark mode
    // Explicit stacking context so action buttons stay on top on Android
    position: 'relative',
    zIndex: 3,
    elevation: 6,
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 3},
    shadowOpacity: 0.15,
    shadowRadius: 6,
    overflow: 'visible' as const, // Changed from 'hidden' to allow proper touch handling
  },
  headerTop: {
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    width: '100%',
    marginBottom: 12,
  },
  btcLogo: {
    width: 32,
    height: 32,
    resizeMode: 'contain' as const,
  },
  priceContainer: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.2)' // Increased opacity for better contrast in light mode
      : 'rgba(255, 255, 255, 0.2)', // Increased opacity for better contrast in dark mode
    paddingHorizontal: 10,
    paddingVertical: 4,
    borderRadius: 6,
  },
  btcPrice: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
    marginRight: 6,
  },
  currencyBadge: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.25)' // Increased opacity for better contrast in light mode
      : 'rgba(255, 255, 255, 0.25)', // Increased opacity for better contrast in dark mode
    paddingHorizontal: 6,
    paddingVertical: 2,
    borderRadius: 4,
  },
  balanceContainer: {
    alignItems: 'center' as const,
    paddingVertical: 8,
    paddingHorizontal: 8,
    marginTop: 4,
    marginBottom: 6,
    marginHorizontal: 0, // Match actionButton marginHorizontal to align with send/receive buttons
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.12)' // Increased opacity for better contrast in light mode
      : 'rgba(255, 255, 255, 0.18)', // Increased opacity for better contrast in dark mode
    borderRadius: 10,
    borderWidth: 1,
    borderColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.25)' // More visible border for better contrast in light mode
      : 'rgba(255, 255, 255, 0.3)', // More visible border for better contrast in dark mode
    overflow: 'hidden' as const,
  },
  balanceHeaderRow: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'space-between' as const,
    width: '100%',
    marginBottom: 6,
    paddingBottom: 6,
    borderBottomWidth: StyleSheet.hairlineWidth,
    borderBottomColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.2)' // More visible divider in light mode
      : 'rgba(255, 255, 255, 0.2)', // More visible divider in dark mode
  },
  providerValueCompact: {
    fontSize: theme.fontSizes?.xs || 10,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
    flex: 1,
    textAlign: 'right' as const,
    marginLeft: 8,
  },
  balanceTouchable: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    width: '100%',
  },
  balanceLoadingIndicator: {
    marginRight: 8,
  },
  balanceErrorContainer: {
    paddingVertical: 8,
    paddingHorizontal: 12,
    alignItems: 'center' as const,
  },
  balanceErrorText: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.danger,
    textAlign: 'center' as const,
  },
  balanceRow: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 6,
    minHeight: 32,
    paddingHorizontal: 12,
    paddingVertical: 4,
    borderRadius: 8,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.12)' // Original glassy white overlay from commit abc07a5e
      : 'rgba(255, 255, 255, 0.08)', // Glassy white overlay in dark mode
    width: '100%',
    justifyContent: 'center' as const,
  },
  balanceRowWithMargin: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 6,
    height: 32,
    borderRadius: 8,
    backgroundColor: 'transparent',
    width: '100%',
    justifyContent: 'center' as const,
    marginTop: 0,
    // Ensure Animated.View doesn't block touches
    pointerEvents: 'box-none' as const,
  },
  balanceBTC: {
    fontSize: theme.fontSizes?.['3xl'] || 24,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.monospace || (Platform.OS === 'ios' ? 'Menlo' : 'monospace'),
    color: theme.colors.white,
    textShadowColor: theme.colors.shadowColor + '33', // 20% opacity
    textShadowOffset: {width: 0, height: 1},
    textShadowRadius: 2,
  },
  balanceFiat: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.monospace || (Platform.OS === 'ios' ? 'Menlo' : 'monospace'),
    color: theme.colors.white,
    textShadowColor: theme.colors.shadowColor + '26', // 15% opacity
    textShadowOffset: {width: 0, height: 1},
    textShadowRadius: 1,
  },
  balanceIcon: {
    width: 18,
    height: 18,
    tintColor: theme.colors.white,
    marginLeft: 12,
    opacity: 0.9,
  },
  blurredText: {
    opacity: 0.7,
    letterSpacing: 2,
  },
  balanceHint: {
    fontSize: theme.fontSizes?.xs || 10,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
    opacity: 0.7,
    marginTop: 4,
    textTransform: 'uppercase' as const,
    letterSpacing: 0.5,
  },
  qrContainer: {
    padding: 8,
    backgroundColor: theme.colors.white,
    borderRadius: 4,
    elevation: 4,
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: 0.2,
    shadowRadius: 4,
  },
  address: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
    marginTop: 8,
    textAlign: 'center' as const,
  },
  partyContainer: {
    flexDirection: 'row' as const,
    width: '100%',
    marginTop: 0,
    marginBottom: 8,
    borderRadius: 8,
    flexWrap: 'nowrap' as const,
    gap: 8,
  },
  partyLeft: {
    flex: 1,
    alignItems: 'flex-start' as const,
  },
  partyCenter: {
    flex: 1,
    alignItems: 'center' as const,
  },
  partyRight: {
    flex: 1,
    alignItems: 'flex-end' as const,
  },
  party: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
  },
  partyText: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
    opacity: 0.9,
  },
  partyLabel: {
    fontSize: theme.fontSizes?.xs || 10,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
    opacity: 0.7,
    marginBottom: 1,
    textTransform: 'uppercase' as const,
    letterSpacing: 0.2,
  },
  partyValue: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
    paddingHorizontal: 6,
  },
  actions: {
    flexDirection: 'row' as const,
    marginTop: 8,
    width: '100%',
    gap: 8,
    alignItems: 'stretch' as const,
    // Ensure buttons are above everything else
    zIndex: 100,
    elevation: Platform.OS === 'android' ? 10 : 0,
    position: 'relative',
  },
  sendButton: {
    flex: 1,
    backgroundColor: theme.colors.accent,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    gap: 8,
    minHeight: 48,
    // Ensure button is clickable on both platforms
    zIndex: 101,
    elevation: Platform.OS === 'android' ? 11 : 0,
  },
  addressTypeModalButton: {
    width: 56,
    minHeight: 48,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.15)' // Glassy white overlay in light mode
      : 'rgba(255, 255, 255, 0.1)', // Glassy white overlay in dark mode
    borderWidth: 1,
    borderColor: theme.colors.background === '#ffffff'
      ? 'rgba(255, 255, 255, 0.25)'
      : 'rgba(255, 255, 255, 0.15)', // Glassy border in dark mode
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    gap: 4,
    borderRadius: 10,
    // Ensure button is clickable on both platforms
    zIndex: 101,
    elevation: Platform.OS === 'android' ? 0 : 11,
  },
  addressTypeButtonText: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
  },
  addressTypeButtonIcon: {
    width: 20,
    height: 20,
    tintColor: theme.colors.textOnPrimary,
    opacity: 0.9,
  },
  receiveButton: {
    flex: 1,
    backgroundColor: theme.colors.secondary,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    gap: 8,
    minHeight: 48,
    // Ensure button is clickable on both platforms
    zIndex: 101,
    elevation: Platform.OS === 'android' ? 11 : 0,
  },
  modalOverlay: {
    ...StyleSheet.absoluteFillObject,
    backgroundColor: theme.colors.modalBackdrop,
    justifyContent: 'center' as const,
    alignItems: 'center' as const,
    zIndex: 100,
  },
  modalContent: {
    backgroundColor: theme.colors.background,
    borderRadius: 12,
    padding: 20,
    width: '80%',
    alignItems: 'center' as const,
    borderWidth: 1,
    borderColor: theme.colors.border + '40', // Add border to match other modals
  },
  modalText: {
    fontSize: theme.fontSizes?.xl || 18,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    marginBottom: 10,
    textAlign: 'center' as const,
    color: theme.colors.text,
  },
  receiveButtonText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
  },
  sendButtonText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
  },
  actionButtonText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.buttonText || theme.colors.white,
  },
  addressTypeButton: {
    backgroundColor: theme.colors.cardBackground,
    padding: 12,
    borderRadius: 8,
    marginVertical: 8,
    width: '100%',
    borderWidth: 1,
    borderColor: theme.colors.border,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 8,
    position: 'relative',
    minHeight: 68,
  },
  addressTypeButtonSelected: {
    borderColor: theme.colors.accent,
    borderWidth: 2,
  },
  addressTypeLabel: {
    fontSize: theme.fontSizes?.md || 15,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    marginBottom: 4,
    flexShrink: 1,
    marginRight: 6,
  },
  addressTypeValue: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.monospace || (Platform.OS === 'ios' ? 'Menlo' : 'monospace'),
    color: theme.colors.textSecondary,
    textAlign: 'left' as const,
    marginTop: 4,
    flexShrink: 1,
    marginRight: 6,
  },
  recommendBadge: {
    backgroundColor: theme.colors.received + '1F', // 12% opacity
    borderColor: theme.colors.received + '59', // 35% opacity
    borderWidth: 1,
    borderRadius: 10,
    padding: 4,
    marginTop: 4,
    alignSelf: 'auto',
  },
  recommendBadgeText: {
    fontSize: theme.fontSizes?.xs || 9,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.received,
    letterSpacing: 0.2,
  },
  addressTypeIcon: {
    width: 16,
    height: 16,
    marginLeft: 8,
    tintColor: theme.colors.white,
    opacity: 0.9,
  },
  modalAddressTypeIcon: {
    width: 22,
    height: 22,
    tintColor: theme.colors.text,
    opacity: 0.9,
  },
  modalOptionCheckIcon: {
    width: 18,
    height: 18,
    tintColor: theme.colors.accent,
    opacity: 0.9,
    marginLeft: 4,
  },
  addressTypeContent: {
    flex: 1,
    paddingRight: 8,
  },
  addressTypeLabelRow: {
    flexDirection: 'row',
    alignItems: 'center',
    justifyContent: 'flex-start',
    flexWrap: 'nowrap',
  },
  modalTitle: {
    fontSize: theme.fontSizes?.['2xl'] || 20,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    marginBottom: 16,
  },
  scrollView: {
    flex: 1,
  },
  cacheIndicator: {
    padding: 12,
    marginHorizontal: 16,
    marginTop: 8,
    marginBottom: 8,
    borderRadius: 8,
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    backgroundColor: theme.colors.background === '#ffffff'
      ? theme.colors.background // Transparent/background in light mode
      : 'rgba(255, 255, 255, 0.08)', // Glassy white overlay in dark mode
    elevation: Platform.OS === 'android' ? 0 : 1,
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 1},
    shadowOpacity: 0.1,
    shadowRadius: 1,
    borderWidth: 1,
    borderColor: theme.colors.background === '#121212' || theme.colors.background.includes('12')
      ? 'rgba(255, 255, 255, 0.15)' // Glassy border in dark mode
      : 'rgba(0, 0, 0, 0.05)', // Original light mode border
  },
  refreshText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    textAlign: 'left' as const,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 6,
  },
  refreshIcon: {
    width: 16,
    height: 16,
    tintColor: theme.colors.accent,
    opacity: 0.9,
  },
  cacheText: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    marginBottom: 0,
    marginTop: 0,
    textAlign: 'right' as const,
    opacity: 0.7,
  },
  shimmerContainer: {
    position: 'absolute' as const,
    top: 0,
    left: 0,
    right: 0,
    bottom: 0,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(0, 0, 0, 0.02)'
      : theme.colors.shadowColor + '05',
    borderRadius: 8,
    overflow: 'hidden',
  },
  shimmer: {
    position: 'absolute' as const,
    top: 0,
    left: 0,
    right: 0,
    bottom: 0,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(0, 0, 0, 0.04)'
      : theme.colors.shadowColor + '0A',
    transform: [{translateX: -100}],
  },
  disabled: {
    opacity: 0.7,
  },
  transactionListContainer: {
    flex: 1,
    marginBottom: 0,
    padding: 16,
    paddingTop: 0,
    backgroundColor: theme.colors.background,
    position: 'relative',
    zIndex: 1,
  },
  sectionHeader: {
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    paddingHorizontal: 0,
    paddingVertical: 12,
    marginBottom: 4,
  },
  sectionTitle: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    opacity: 0.9,
  },
  sectionSubtitle: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
  },
  emptyStateContainer: {
    flex: 1,
    justifyContent: 'center' as const,
    alignItems: 'center' as const,
    padding: 20,
    marginTop: 20,
  },
  emptyStateText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    textAlign: 'center' as const,
    marginTop: 8,
  },
  emptyStateIcon: {
    width: 48,
    height: 48,
    opacity: 0.5,
    marginBottom: 8,
  },
  actionButtonIcon: {
    width: 18,
    height: 18,
    tintColor: theme.colors.white,
  },
  addressTypeContainer: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 4,
    backgroundColor: theme.colors.background === '#ffffff'
      ? 'rgba(255,255,255,0.18)' // glassy
      : 'rgba(255, 255, 255, 0.12)', // Glassy white overlay in dark mode
    borderRadius: 10,
    paddingHorizontal: 10,
    paddingVertical: 8,
    borderWidth: 1,
    borderColor: theme.colors.background === '#ffffff'
      ? 'rgba(255,255,255,0.25)'
      : 'rgba(255, 255, 255, 0.2)', // Glassy border in dark mode
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 2},
    shadowOpacity: 0.08,
    shadowRadius: 6,
    // Add elevation for Android
    elevation: 2,
    minWidth: 0,
    flex: 1,
    flexShrink: 1,
  },
  addressTypeClickable: {
    // For extra visual feedback if needed
    opacity: 0.96,
  },
  sendButtonDisabled: {
    opacity: 0.6,
  },
  networkRow: {
    flexDirection: 'row',
    alignItems: 'center',
  },
  networkIcon: {
    width: 16,
    height: 16,
    tintColor: theme.colors.white,
  },
  rowCenter: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
  },
  rowFullWidth: {
    flexDirection: 'row' as const,
    width: '100%',
  },
  columnCenter: {
    flex: 1,
    flexDirection: 'column' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    paddingHorizontal: 4,
  },
  rowCenterMarginTop2: {
    flexDirection: 'row' as const,
    justifyContent: 'center' as const,
    alignItems: 'center' as const,
    marginTop: 2,
  },
  flexOneMinWidthZero: {
    flex: 1,
    minWidth: 0,
  },
  partyGap: {
    marginHorizontal: 4,
  },
  modalGoSettingsButton: {
    marginTop: 16,
  },
  modalCloseButton: {
    marginTop: 8,
    backgroundColor: 'transparent',
    borderWidth: 0,
  },
  modalCloseButtonText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.accent,
  },
  modalBoldText: {
    fontSize: theme.fontSizes?.md || 15,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
  },
  modalTextLeft: {
    fontSize: theme.fontSizes?.md || 15,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    textAlign: 'left' as const,
    color: theme.colors.text,
    marginBottom: 12,
  },
  modalInfoIcon: {
    width: 36,
    height: 36,
    marginBottom: 12,
    tintColor: theme.colors.accent,
    alignSelf: 'center' as const,
  },
  modalActionButtonText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.primary,
    letterSpacing: 0.2,
  },
  modalParagraph: {
    marginBottom: 10,
  },
  modalHeaderRow: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    marginBottom: 12,
  },
  modalHeaderIcon: {
    width: 24,
    height: 24,
    tintColor: theme.colors.primary,
    marginRight: 10,
  },
  modalHeaderTitle: {
    fontSize: theme.fontSizes?.['2xl'] || 20,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    flex: 1,
    textAlign: 'left' as const,
  },
  modalActionsRow: {
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    marginTop: 16,
    width: '100%',
    gap: 8,
  },
  modalActionLeft: {
    flex: 1,
    alignItems: 'flex-start' as const,
  },
  modalActionRight: {
    flex: 1,
    alignItems: 'flex-end' as const,
  },
  linkText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.accent,
  },
  apiDisplayContainer: {
    paddingHorizontal: 16,
    alignItems: 'center' as const,
  },
  apiDisplayButton: {
    backgroundColor: 'transparent',
    paddingHorizontal: 8,
    paddingVertical: 8,
    width: '100%',
    opacity: 0.8,
  },
  apiDisplayContent: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    height: 16,
    gap: 2,
  },
  apiDisplayIcon: {
    width: 14,
    height: 14,
    marginRight: 6,
    tintColor: theme.colors.textSecondary,
    opacity: 0.7,
  },
  apiDisplayLabel: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginRight: 4,
  },
  apiDisplayValue: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    flex: 1,
    textAlign: 'right' as const,
  },
  providerRow: {
    marginHorizontal: 16,
    marginVertical: 4,
    paddingHorizontal: 8,
    paddingVertical: 6,
  },
  providerItem: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'space-between' as const,
  },
  providerLeft: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    flex: 1,
  },
  providerIcon: {
    width: 14,
    height: 14,
    marginRight: 6,
    tintColor: theme.colors.textSecondary,
    opacity: 0.8,
  },
  providerLabel: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    letterSpacing: 0.2,
  },
  providerValue: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    letterSpacing: 0.1,
    flex: 1,
    textAlign: 'right' as const,
    opacity: 0.8,
  },
  networkBadge: {
    backgroundColor: theme.colors.background === '#ffffff'
      ? theme.colors.primary + '40' // Increased opacity for better contrast in light mode
      : 'rgba(255, 255, 255, 0.15)', // Glassy background in dark mode
    paddingHorizontal: 6,
    paddingVertical: 2,
    borderRadius: 4,
    marginRight: 0, // No margin needed in compact layout
  },
  networkBadgeText: {
    fontSize: theme.fontSizes?.xs || 9,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.background === '#ffffff'
      ? theme.colors.white // White text for better contrast on dark badge in light mode
      : theme.colors.text, // Use theme text color in dark mode
    letterSpacing: 0.5,
  },
  warningBox: {
    backgroundColor: theme.colors.accent + '1A', // 10% opacity
    borderRadius: 8,
    padding: 12,
    marginVertical: 8,
    borderLeftWidth: 4,
    borderLeftColor: theme.colors.accent,
  },
  warningText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.danger,
    lineHeight: 20,
  },
  backupButton: {
    backgroundColor: theme.colors.primary,
    borderRadius: 8,
    paddingVertical: 14,
    paddingHorizontal: 20,
    marginTop: 12,
    alignItems: 'center' as const,
  },
  backupButtonText: {
    fontSize: theme.fontSizes?.lg || 16,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
  },
  warningBoxWithMargin: {
    backgroundColor: theme.colors.accent + '1A', // 10% opacity
    borderRadius: 8,
    padding: 12,
    marginVertical: 8,
    marginTop: 10,
    borderLeftWidth: 4,
    borderLeftColor: theme.colors.accent,
  },
  modalTipText: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginTop: 12,
    textAlign: 'left' as const,
  },
  backupButtonWithMargin: {
    backgroundColor: theme.colors.secondary,
    borderRadius: 8,
    paddingVertical: 14,
    paddingHorizontal: 20,
    marginTop: 18,
    alignItems: 'center' as const,
  },
  modalContentCompact: {
    backgroundColor: theme.colors.cardBackground,
    borderRadius: 16,
    padding: 16,
    width: '90%',
    maxHeight: '100%',
    alignSelf: 'center' as const,
    elevation: 8,
    shadowColor: theme.colors.shadowColor,
    shadowOffset: {width: 0, height: 4},
    shadowOpacity: 0.15,
    shadowRadius: 10,
    borderWidth: 0, // Remove border to match other modals
    flexDirection: 'column' as const,
    justifyContent: 'flex-start' as const,
    overflow: 'hidden' as const,
    minHeight: 500,
  },
  modalHeaderRowCompact: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    marginBottom: 12,
    paddingBottom: 12,
    borderBottomWidth: 1,
    borderBottomColor: theme.colors.border + '60',
    flexShrink: 0,
    height: 48,
  },
  modalHeaderIconCompact: {
    width: 24,
    height: 24,
    tintColor: theme.colors.text,
    marginRight: 10,
  },
  modalHeaderTitleCompact: {
    fontSize: theme.fontSizes?.['2xl'] || 20,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    flex: 1,
  },
  modalTextCompact: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    lineHeight: 20,
    color: theme.colors.text,
    marginBottom: 12,
    textAlign: 'left' as const,
    includeFontPadding: false,
  },
  modalBoldTextCompact: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    includeFontPadding: false,
    lineHeight: 20,
  },
  warningBoxCompact: {
    backgroundColor: theme.colors.accent + '14', // 8% opacity
    borderRadius: 6,
    padding: 10,
    marginBottom: 10,
    borderLeftWidth: 3,
    borderLeftColor: theme.colors.accent,
  },
  warningTextCompact: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.danger,
    lineHeight: 18,
  },
  modalTipTextCompact: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginBottom: 14,
    textAlign: 'left' as const,
    lineHeight: 16,
  },
  backupButtonCompact: {
    backgroundColor: theme.colors.secondary,
    borderRadius: 8,
    paddingVertical: 10,
    paddingHorizontal: 16,
    alignItems: 'center' as const,
  },
  backupButtonTextCompact: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
  },
  keyshareModalCloseButton: {
    marginLeft: 'auto' as const,
    backgroundColor: theme.colors.cardBackground,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    width: 36,
    height: 36,
    marginTop: 4,
  },
  keyshareModalCloseText: {
    fontSize: theme.fontSizes?.['2xl'] || 22,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    lineHeight: 22,
  },
  keyshareModalContent: {
    paddingTop: 4,
    paddingBottom: 8,
    paddingHorizontal: 4,
  },
  keyshareInfoRow: {
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    gap: 16,
    marginBottom: 6,
    minHeight: 24,
  },
  keyshareInfoLabel: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    flexShrink: 0,
    minWidth: 150,
    textAlign: 'left' as const,
    includeFontPadding: false,
    textAlignVertical: 'center' as const,
  },
  keyshareInfoValue: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    flex: 1,
    flexShrink: 1,
    textAlign: 'right' as const,
    includeFontPadding: false,
    textAlignVertical: 'center' as const,
  },
  keyshareInfoValueSuccess: {
    color: theme.colors.received,
  },
  keyshareInfoValueDisabled: {
    color: theme.colors.disabledText,
  },
  keyshareKeySection: {
    gap: 8,
  },
  keyshareKeyContainer: {
    flex: 1,
    flexShrink: 1,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 8,
    minWidth: 0,
  },
  keyshareKeyText: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.monospace || 'monospace',
    flex: 1,
    flexShrink: 1,
    color: theme.colors.text,
    minWidth: 0,
    textAlign: 'right' as const,
  },
  keyshareCopyButton: {
    padding: 8,
    backgroundColor: theme.colors.primary,
    borderRadius: 6,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
  },
  keyshareCopyButtonText: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
  },
  keyshareCopyIcon: {
    width: 16,
    height: 16,
    tintColor:
      theme.colors.background === '#ffffff'
        ? theme.colors.white
        : theme.colors.text,
  },
  keyshareButtonsRow: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 6,
  },
  qrModalContent: {
    backgroundColor: theme.colors.cardBackground,
    borderRadius: 16,
    padding: 24,
    alignItems: 'center' as const,
    minWidth: 280,
    maxWidth: 320,
  },
  qrModalTitle: {
    fontSize: theme.fontSizes?.xl || 18,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    marginBottom: 4,
  },
  qrModalSubtitle: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginBottom: 20,
  },
  qrCodeContainer: {
    backgroundColor: 'white',
    padding: 16,
    borderRadius: 12,
    marginBottom: 16,
  },
  qrModalHint: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginBottom: 16,
    fontStyle: 'italic' as const,
  },
  qrModalCloseButton: {
    backgroundColor: theme.colors.primary,
    paddingVertical: 12,
    paddingHorizontal: 32,
    borderRadius: 8,
  },
  qrModalCloseButtonText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textOnPrimary,
  },
  keyshareLoadingContainer: {
    padding: 16,
  },
  keyshareBackupButtonMargin: {
    marginTop: 12,
    flexShrink: 0,
  },
  keyshareButtonsContainer: {
    flexDirection: 'row' as const,
    gap: 8,
    width: '100%',
  },
  keyshareCloseButton: {
    flex: 1,
  },
  keyshareBackupButton: {
    flex: 1,
  },
  keyshareModalBody: {
    width: '100%',
  },
  keyshareModalBodyContent: {
    paddingVertical: 8,
    paddingBottom: 16,
  },
  keyshareInfoCard: {
    backgroundColor: theme.colors.background,
    borderRadius: 10,
    padding: 14,
    marginBottom: 12,
    borderWidth: 1,
    borderColor: theme.colors.border + '50',
  },
  keyshareSectionTitle: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    marginBottom: 10,
    letterSpacing: 0.2,
  },
  keyshareDetailRow: {
    flexDirection: 'row' as const,
    justifyContent: 'space-between' as const,
    alignItems: 'center' as const,
    paddingVertical: 8,
    borderBottomWidth: 1,
    borderBottomColor: theme.colors.border + '30',
  },
  keyshareDetailLabel: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    flex: 1,
  },
  keyshareDetailValue: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    flex: 1,
    textAlign: 'right' as const,
  },
  keyshareBadge: {
    paddingHorizontal: 12,
    paddingVertical: 6,
    borderRadius: 12,
    alignSelf: 'flex-end' as const,
  },
  keyshareBadgeText: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.white,
  },
  keyshareBadgeTrio: {
    backgroundColor: theme.colors.primary,
  },
  keyshareBadgeDuo: {
    backgroundColor: theme.colors.secondary ,
  },
  keyshareStatusBadge: {
    paddingHorizontal: 10,
    paddingVertical: 5,
    borderRadius: 10,
    alignSelf: 'flex-end' as const,
  },
  keyshareStatusBadgeText: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
  },
  keyshareStatusBadgeSuccess: {
    backgroundColor: theme.colors.received + '33', // 20% opacity
  },
  keyshareStatusBadgeDisabled: {
    backgroundColor: theme.colors.disabledText + '33', // 20% opacity
  },
  keyshareStatusBadgeTextSuccess: {
    color: theme.colors.received,
  },
  keyshareStatusBadgeTextDisabled: {
    color: theme.colors.disabledText,
  },
  keyshareKeyItem: {
    flexDirection: 'row' as const,
    paddingVertical: 6,
    paddingHorizontal: 2,
    borderBottomWidth: 1,
    borderBottomColor: theme.colors.border + '40',
    alignItems: 'center' as const,
    width: '100%',
  },
  keyshareKeyLabel: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    width: 130,
    flexShrink: 0,
    marginRight: 12,
    letterSpacing: 0.1,
  },
  keyshareTable: {
    width: '100%',
  },
  keyshareTableRow: {
    flexDirection: 'row' as const,
    paddingVertical: 6,
    paddingHorizontal: 2,
    borderBottomWidth: 1,
    borderBottomColor: theme.colors.border + '40',
    alignItems: 'center' as const,
    width: '100%',
  },
  keyshareTableKey: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    width: 130,
    flexShrink: 0,
    marginRight: 12,
  },
  keyshareTableValue: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.medium || '500') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    flex: 1,
    flexShrink: 1,
    textAlign: 'left' as const,
    minWidth: 0,
  },
  keyshareTableValueContainer: {
    flex: 1,
    flexShrink: 1,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 8,
    minWidth: 0,
  },
  keyshareTableValueKey: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.monospace || 'monospace',
    flex: 1,
    flexShrink: 1,
    color: theme.colors.text,
    textAlign: 'left' as const,
    minWidth: 0,
  },
  keyshareTableValueSuccess: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.received,
  },
  keyshareTableValueDisabled: {
    color: theme.colors.disabledText,
  },
  keyshareInfoHeader: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
  },
  watchWalletHeader: {
    marginTop: 12,
    backgroundColor: theme.colors.background,
    borderRadius: 10,
    padding: 14,
    borderWidth: 1,
    borderColor: theme.colors.border + '40',
  },
  watchWalletTitle: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
  },
  watchWalletDescription: {
    fontSize: theme.fontSizes?.sm || 12,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    lineHeight: 18,
    color: theme.colors.text,
    marginTop: 4,
    marginBottom: 12,
  },
  watchWalletWarning: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    lineHeight: 16,
    color: theme.colors.textSecondary,
    marginTop: 8,
    marginBottom: 12,
    fontStyle: 'italic' as const,
  },
  watchWalletItem: {
    marginTop: 12,
    paddingTop: 12,
    borderTopWidth: 1,
    borderTopColor: theme.colors.border + '40',
  },
  watchWalletItemLabel: {
    fontSize: theme.fontSizes?.base || 13,
    fontWeight: (theme.fontWeights?.semibold || '600') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.textSecondary,
    marginBottom: 8,
  },
  watchWalletItemValue: {
    fontSize: theme.fontSizes?.sm || 11,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.monospace || 'monospace',
    flex: 1,
    flexShrink: 1,
    textAlign: 'left' as const,
    minWidth: 0,
    color: theme.colors.text, // Fix dark mode readability
  },
  watchWalletItemValueContainer: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    gap: 8,
    minWidth: 0,
  },
  clickableTextContainer: {
    flex: 1,
    flexShrink: 1,
    minWidth: 0,
  },
  clickableText: {
    fontSize: theme.fontSizes?.base || 14,
    fontWeight: (theme.fontWeights?.normal || '400') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.primary,
    textDecorationLine: 'underline' as const,
  },
  qrModalButtonsContainer: {
    flexDirection: 'row' as const,
    width: '100%',
    paddingHorizontal: 20,
    marginTop: 12,
  },
  qrModalShareButton: {
    flex: 1,
    backgroundColor: theme.colors.primary,
    marginRight: 6,
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
  },
  qrModalShareIcon: {
    width: 18,
    height: 18,
    tintColor: theme.colors.white,
    marginRight: 6,
  },
  qrModalCloseButtonWithMargin: {
    flex: 1,
    backgroundColor: theme.colors.border,
    marginLeft: 6,
  },
  toastContainer: {
    position: 'absolute' as const,
    top: 0,
    left: 0,
    right: 0,
    bottom: 0,
    zIndex: 9999,
    pointerEvents: 'box-none' as const,
  },
  qrModalHeader: {
    flexDirection: 'row' as const,
    alignItems: 'center' as const,
    justifyContent: 'space-between' as const,
    width: '100%',
    marginBottom: 16,
  },
  qrModalHeaderTitle: {
    fontSize: theme.fontSizes?.xl || 18,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    flex: 1,
  },
  qrModalTopRightCloseButton: {
    marginLeft: 'auto' as const,
    backgroundColor: theme.colors.cardBackground,
    alignItems: 'center' as const,
    justifyContent: 'center' as const,
    width: 36,
    height: 36,
    borderRadius: 18,
  },
  qrModalTopRightCloseText: {
    fontSize: theme.fontSizes?.['2xl'] || 22,
    fontWeight: (theme.fontWeights?.bold || '700') as any,
    fontFamily: theme.fontFamilies?.regular,
    color: theme.colors.text,
    lineHeight: 22,
  },
  qrModalShareButtonSingle: {
    flex: 0,
    marginRight: 0,
    paddingHorizontal: 24,
  },
  qrModalButtonsContainerCentered: {
    justifyContent: 'center' as const,
    alignItems: 'center' as const,
  },
});
