/*
 * This file is part of Metronome.
 * Copyright (C) 2025 Philipp Bobek <philipp.bobek@mailbox.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Metronome is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.bobek.metronome.preference

object PreferenceConstants {

    const val BEATS = "beats"

    const val SUBDIVISIONS = "subdivisions"

    const val GAPS = "gaps"

    const val TEMPO = "tempo"

    const val EMPHASIZE_FIRST_BEAT = "emphasize_first_beat"

    const val SOUND = "sound"
    const val SOUND_VALUE_SQUARE_WAVE = "square_wave"
    const val SOUND_VALUE_SINE_WAVE = "sine_wave"
    const val SOUND_VALUE_RISSET_DRUM = "risset_drum"
    const val SOUND_VALUE_PLUCK = "pluck"

    const val NIGHT_MODE = "night_mode"
    const val NIGHT_MODE_VALUE_FOLLOW_SYSTEM = "follow_system"
    const val NIGHT_MODE_VALUE_NO = "no"
    const val NIGHT_MODE_VALUE_YES = "yes"

    const val POST_NOTIFICATIONS_PERMISSION_REQUESTED = "post_notifications_permission_requested"

    const val THIRD_PARTY_LICENSES = "third_party_licenses"

    const val VERSION = "version"
}
