<!-- ---------- Header ---------- -->
<div align="center">
  <img width="200" height="200"src="fastlane/metadata/android/en-US/images/icon.png">
  <h1>Translate You</h1>
<p>Privacy focused translator app built with MD3.</p>

<!-- ---------- Badges ---------- -->
  <div align="center">
    <img alt="License" src="https://img.shields.io/github/license/you-apps/TranslateYou?color=c3e7ff&style=flat-square">
    <img alt="Downloads" src="https://img.shields.io/github/downloads/you-apps/TranslateYou/total.svg?color=c3e7ff&style=flat-square">
    <img alt="Last commit" src="https://img.shields.io/github/last-commit/you-apps/TranslateYou?color=c3e7ff&style=flat-square">
    <img alt="Repo size" src="https://img.shields.io/github/repo-size/you-apps/TranslateYou?color=c3e7ff&style=flat-square">
    <img alt="Stars" src="https://img.shields.io/github/stars/you-apps/TranslateYou?color=c3e7ff&style=flat-square">
    <br>
</div>
</div>

<!-- ---------- Description ---------- -->
## Features

- [x] more than 150 supported languages
- [x] 9 different translation engines
- [x] Material Design 3 (You)
- [x] Dark and light theme
- [x] Support for Android sharing system
- [x] Multilingual interface
- [x] Translation from images
- [x] Translation history
- [x] Entirely Open Source
- [X] Written in Jetpack Compose 

<!-- ---------- Download ---------- -->
## Download

[<img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png" alt="Get it on F-Droid" height="80">](https://f-droid.org/packages/com.bnyro.translate/)
[<img src="https://gitlab.com/IzzyOnDroid/repo/-/raw/master/assets/IzzyOnDroid.png" alt="Get it on IzzyOnDroid" height="80">](https://apt.izzysoft.de/fdroid/index/apk/com.bnyro.translate)
[<img src="ghbadge.png" alt="Get it on GitHub" height="80">](https://github.com/you-apps/translateyou/releases)

<!-- ---------- Supported translation engines ---------- -->
## Supported translation engines

### Open Source / Self-hostable
* <a href="https://github.com/LibreTranslate/LibreTranslate">LibreTranslate</a> _which requires an API key or alternatively has to be self-hosted._
* <a href="https://github.com/thedaviddelta/lingva-translate">LingvaTranslate</a> _which uses Google Translate® to fetch translations._
* <a href="https://simple-web.org/projects/simplytranslate.html">SimplyTranslate</a>
* <a href="https://codeberg.org/aryak/mozhi">Mozhi</a>
* <a href="https://translate.wmcloud.org">Wikimedia MinT</a>
* <a href="https://apertium.org/">Apertium</a>
* <a href="https://github.com/janvarev/OneRingTranslator">OneRingTranslator</a>

### Proprietary
* <a href="https://www.deepl.com/translator">DeepL translator®</a>.
* <a href="https://mymemory.translated.net/">MyMemory translator®</a>.
* <a href="https://translate.yandex.com/">Yandex®</a>
* <a href="https://en.pons.com/translate">PONS®</a>
* <a href="https://glosbe.com/">Glosbe®</a>
* <a href="https://laratranslate.com/translate">LaraTranslate®</a>
* <a href="https://translate.kagi.com">Kagi Translate®</a>

<!-- ---------- Screenshots [Plus version] ---------- -->
## Screenshots

<div style="display: flex;">
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/1-translate.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/2-translate.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/3-details.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/4-settings.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/5-history.png" width=30%>
  <img src="fastlane/metadata/android/en-US/images/phoneScreenshots/6-about.png" width=30%>
</div>

<!-- ---------- Contribution ---------- -->
## Feedback and contributions
***All contributions are very welcome!***

* Feel free to join the [Matrix room](https://matrix.to/#/#you-apps:matrix.org) for discussions about the app.
* Bug reports and feature requests can be submitted [here](https://github.com/you-apps/TranslateYou/issues) (please make sure to fill out all the requested information properly!).
* If you are a developer and wish to contribute to the app, please **fork** the project and submit a [**pull request**](https://help.github.com/articles/about-pull-requests/).

## Translation
<a href="https://hosted.weblate.org/projects/you-apps/translate-you/">
<img src="https://hosted.weblate.org/widgets/you-apps/-/translate-you/287x66-grey.png" alt="Translation status" />
</a>

**Translations are greatly appreciated.** \
If **Translate You** is not in your language, feel free to participate by:
* Translating the application interface, via [**pull request**](https://help.github.com/articles/about-pull-requests/) or more simply by [**Weblate**](https://hosted.weblate.org/projects/you-apps/translate-you/).
* **Check** and **update** the [**pre-existing translations on Github**](https://github.com/you-apps/TranslateYou/tree/master/app/src/main/res) or more simply via [**Weblate**](https://hosted.weblate.org/projects/you-apps/translate-you/).

<!-- ---------- Privacy Policy and License ---------- -->
## Privacy Policy

**Translate You's privacy policy is available** [**here**](https://github.com/you-apps/TranslateYou/blob/master/PRIVACY%20POLICY.md)

## Credits
* Icon design by [M00NJ](https://github.com/M00NJ)

## License

Translate You is licensed under the [**GNU General Public License**](https://www.gnu.org/licenses/gpl.html): You can use, study and share it as you want.
