// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'R'.
class PartR {
  /// Applies the REM font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/REM
  static TextStyle rem({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c27a7474ddacb2e529146819a795e041ed58a315f8e836b4a9a99c62afd3adb',
        70860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1617f1348b143674c6b732e5884255e141b0a477905ecaeca6613903454e5c99',
        70976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '144110b7cbbe6d75b44464d2ed2db6096ccd119f18418277e6e4a80d58f6e634',
        70940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '72f250e5c05cb54f9a63c4592dd0a8dc38e96aa8ceea40bcb591649f9102f657',
        70876,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04f09dcff9e3dcde49a6c69764761e7bb8a44db95749c1a1c8d17859a72d6174',
        70836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a52c3f08d2879982aca0483ea8799c0047127ceac68bf620bf2f043d981d9e55',
        72124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ae30e4cb5df9e661fd0ff2ffe2c6e8515fb1578961a1f4089adc73a1da262e5',
        72072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9580ed4527705c0542f1dbc4412ca0b54871ac3d2bc7e263d23272e206487c96',
        73096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '251b6aaa2ffafbe52064be05b1e1a43f034f9c949612a862561a2188863d4edb',
        72980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd0be4a539f2645e9b24ef891561e56cf74b460501eb28a0000607b4dbc339720',
        72180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f808fb6b0d48ff08444d5defbfc5ef0ac1aaeade126eda4a7f1b17163a9c798',
        72316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fbcc57d34778054a760a198350313f136849a2379c43e842929e005126602529',
        72264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '94b906ba250fd1b74ef38cd9cdb711376d4db0a2ba0e78da8fbb7fea21059e7c',
        72144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1a0ff8af7b88e980799bc55e395a1cc777230e50c4fce4e74f87376b5c002b76',
        72224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac10b9a47ed577e6d7aff1573b36c5d2106e0239e29d2f327e5bbcf2ea7a24ad',
        73520,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b42bf8546fe9a63fba2f97febc5ca47b10f182f999db742a7ec3a9f81d1e4f91',
        73432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '312afe79cf96870f09f65bfa695a7b3b835f85afa4656821b6dcf88145532bf2',
        74496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05161a797c845260fee7d53de97200669108001b366d63f11605ac4fb0b0c3fc',
        74328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'REM',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the REM font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/REM
  static TextTheme remTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rem(textStyle: textTheme.displayLarge),
      displayMedium: rem(textStyle: textTheme.displayMedium),
      displaySmall: rem(textStyle: textTheme.displaySmall),
      headlineLarge: rem(textStyle: textTheme.headlineLarge),
      headlineMedium: rem(textStyle: textTheme.headlineMedium),
      headlineSmall: rem(textStyle: textTheme.headlineSmall),
      titleLarge: rem(textStyle: textTheme.titleLarge),
      titleMedium: rem(textStyle: textTheme.titleMedium),
      titleSmall: rem(textStyle: textTheme.titleSmall),
      bodyLarge: rem(textStyle: textTheme.bodyLarge),
      bodyMedium: rem(textStyle: textTheme.bodyMedium),
      bodySmall: rem(textStyle: textTheme.bodySmall),
      labelLarge: rem(textStyle: textTheme.labelLarge),
      labelMedium: rem(textStyle: textTheme.labelMedium),
      labelSmall: rem(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Racing Sans One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Racing+Sans+One
  static TextStyle racingSansOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6492db146d419a7d6762601db2fb05ccb0ab668746577e29448986ba403b451',
        75196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RacingSansOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Racing Sans One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Racing+Sans+One
  static TextTheme racingSansOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: racingSansOne(textStyle: textTheme.displayLarge),
      displayMedium: racingSansOne(textStyle: textTheme.displayMedium),
      displaySmall: racingSansOne(textStyle: textTheme.displaySmall),
      headlineLarge: racingSansOne(textStyle: textTheme.headlineLarge),
      headlineMedium: racingSansOne(textStyle: textTheme.headlineMedium),
      headlineSmall: racingSansOne(textStyle: textTheme.headlineSmall),
      titleLarge: racingSansOne(textStyle: textTheme.titleLarge),
      titleMedium: racingSansOne(textStyle: textTheme.titleMedium),
      titleSmall: racingSansOne(textStyle: textTheme.titleSmall),
      bodyLarge: racingSansOne(textStyle: textTheme.bodyLarge),
      bodyMedium: racingSansOne(textStyle: textTheme.bodyMedium),
      bodySmall: racingSansOne(textStyle: textTheme.bodySmall),
      labelLarge: racingSansOne(textStyle: textTheme.labelLarge),
      labelMedium: racingSansOne(textStyle: textTheme.labelMedium),
      labelSmall: racingSansOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Radio Canada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada
  static TextStyle radioCanada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32257abdedd7c86b2a543c1e858519793222f5da20ef2b84900c319d05c5d36a',
        126584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14af91ccbde862456321fed42b9c8bbc390ab7937404a2f2577190031dc7ca9d',
        126892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '368137944448577c0e3788bf4c5cdf4ebde73e3d3a28b25b2b5732397cad1420',
        127668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '674d2d64f0ccff3d714349dd27e205e8168e4fbc0f7bf1fb261da978181489be',
        127636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e695540eed85b5a1353eff2d8294ba7d091804efaacd28d10551f347642be304',
        127388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc74e4ca34d6d1ea27808ce28a5cd4c7cfff8b6158e2f47d38792da19ea6bdd4',
        130016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c7939b540846137e75d73ca4c2252faee9c87778847a983c3774a114eb03279',
        130272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9da5155c675d5c6ddcc68e1dbb9ee8716f5bb77f30b0b891dd686c7896a780d',
        131044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '70ef578c70112c7ba0b5a0678afec6f5e87b378bf8dad30efdcf24ca4b570d7b',
        131020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ef6c7927b971da5675ce08c0785ec55c81e9e4c6fa44f3b8bf978fe73b5e24c',
        130776,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RadioCanada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Radio Canada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada
  static TextTheme radioCanadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: radioCanada(textStyle: textTheme.displayLarge),
      displayMedium: radioCanada(textStyle: textTheme.displayMedium),
      displaySmall: radioCanada(textStyle: textTheme.displaySmall),
      headlineLarge: radioCanada(textStyle: textTheme.headlineLarge),
      headlineMedium: radioCanada(textStyle: textTheme.headlineMedium),
      headlineSmall: radioCanada(textStyle: textTheme.headlineSmall),
      titleLarge: radioCanada(textStyle: textTheme.titleLarge),
      titleMedium: radioCanada(textStyle: textTheme.titleMedium),
      titleSmall: radioCanada(textStyle: textTheme.titleSmall),
      bodyLarge: radioCanada(textStyle: textTheme.bodyLarge),
      bodyMedium: radioCanada(textStyle: textTheme.bodyMedium),
      bodySmall: radioCanada(textStyle: textTheme.bodySmall),
      labelLarge: radioCanada(textStyle: textTheme.labelLarge),
      labelMedium: radioCanada(textStyle: textTheme.labelMedium),
      labelSmall: radioCanada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Radio Canada Big font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada+Big
  static TextStyle radioCanadaBig({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db23304404b863fb77e9a0eee4fc92524d57074850157d9dbcf32447db727ffb',
        44932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19c18925d764f5b13db14e46eb71f7c962fc04f2b226b267dbb001b144daaa8f',
        45592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7a0016be510da16a0039641c883e1b68cb3f5e5cec7438722563a482b4bd0b0',
        45560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9417767604273b99c9fbb5c45a231b05b719ebbbe84f79ad58dc056d9a287cd4',
        45480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a43088313acb288d14ecd7debd46ce14c595f2eb8b8a7be5dc61b646f530ac8f',
        47012,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a82a07e55080d5aa78f4179bfafd82fd652a66b3bf20fb781f21a10dce5d1513',
        47120,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e630cd9e61499ac0f0284983de3e18ef5d7beba07121114caf0590247e7b84c3',
        47208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3cb205b44400d7a6b9e26f6ed8eab3e2dc6807ab9faa5ba8a3ba117676b5bf76',
        46960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RadioCanadaBig',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Radio Canada Big font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radio+Canada+Big
  static TextTheme radioCanadaBigTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: radioCanadaBig(textStyle: textTheme.displayLarge),
      displayMedium: radioCanadaBig(textStyle: textTheme.displayMedium),
      displaySmall: radioCanadaBig(textStyle: textTheme.displaySmall),
      headlineLarge: radioCanadaBig(textStyle: textTheme.headlineLarge),
      headlineMedium: radioCanadaBig(textStyle: textTheme.headlineMedium),
      headlineSmall: radioCanadaBig(textStyle: textTheme.headlineSmall),
      titleLarge: radioCanadaBig(textStyle: textTheme.titleLarge),
      titleMedium: radioCanadaBig(textStyle: textTheme.titleMedium),
      titleSmall: radioCanadaBig(textStyle: textTheme.titleSmall),
      bodyLarge: radioCanadaBig(textStyle: textTheme.bodyLarge),
      bodyMedium: radioCanadaBig(textStyle: textTheme.bodyMedium),
      bodySmall: radioCanadaBig(textStyle: textTheme.bodySmall),
      labelLarge: radioCanadaBig(textStyle: textTheme.labelLarge),
      labelMedium: radioCanadaBig(textStyle: textTheme.labelMedium),
      labelSmall: radioCanadaBig(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Radley font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radley
  static TextStyle radley({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2fceb10b6e99ab5c511ebbc946bbe5d9d990e077bf378c9b0a1407343487a29b',
        52080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f32bb11fb764c9e5794b8f9fb5c4b914545a85abd6afbfc417c15e71bb7399a',
        46560,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Radley',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Radley font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Radley
  static TextTheme radleyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: radley(textStyle: textTheme.displayLarge),
      displayMedium: radley(textStyle: textTheme.displayMedium),
      displaySmall: radley(textStyle: textTheme.displaySmall),
      headlineLarge: radley(textStyle: textTheme.headlineLarge),
      headlineMedium: radley(textStyle: textTheme.headlineMedium),
      headlineSmall: radley(textStyle: textTheme.headlineSmall),
      titleLarge: radley(textStyle: textTheme.titleLarge),
      titleMedium: radley(textStyle: textTheme.titleMedium),
      titleSmall: radley(textStyle: textTheme.titleSmall),
      bodyLarge: radley(textStyle: textTheme.bodyLarge),
      bodyMedium: radley(textStyle: textTheme.bodyMedium),
      bodySmall: radley(textStyle: textTheme.bodySmall),
      labelLarge: radley(textStyle: textTheme.labelLarge),
      labelMedium: radley(textStyle: textTheme.labelMedium),
      labelSmall: radley(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rajdhani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rajdhani
  static TextStyle rajdhani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '192b606d14e81260b70011c0b0c5112d9a3e9c65afa4f26b77ad0c86b40d5898',
        217500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff6e72fe9cf36e9a1c242b9bfd96b5428d8fffa2f1e051aedb763e7541541cd1',
        216760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aaaec9e0132fad7581bc52138b8093c83ba03a319a3c304e6c011afbbf789b6d',
        214792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f91a9ceab5666fd1bce81d641f74b66cf748a3d4c71d3ff448c4e68d15a738',
        214296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9daa5a92fd35dd5dacf143f23fe31b929d06731e83fb82f5e2890ba9dd642111',
        216528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rajdhani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rajdhani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rajdhani
  static TextTheme rajdhaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rajdhani(textStyle: textTheme.displayLarge),
      displayMedium: rajdhani(textStyle: textTheme.displayMedium),
      displaySmall: rajdhani(textStyle: textTheme.displaySmall),
      headlineLarge: rajdhani(textStyle: textTheme.headlineLarge),
      headlineMedium: rajdhani(textStyle: textTheme.headlineMedium),
      headlineSmall: rajdhani(textStyle: textTheme.headlineSmall),
      titleLarge: rajdhani(textStyle: textTheme.titleLarge),
      titleMedium: rajdhani(textStyle: textTheme.titleMedium),
      titleSmall: rajdhani(textStyle: textTheme.titleSmall),
      bodyLarge: rajdhani(textStyle: textTheme.bodyLarge),
      bodyMedium: rajdhani(textStyle: textTheme.bodyMedium),
      bodySmall: rajdhani(textStyle: textTheme.bodySmall),
      labelLarge: rajdhani(textStyle: textTheme.labelLarge),
      labelMedium: rajdhani(textStyle: textTheme.labelMedium),
      labelSmall: rajdhani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rakkas font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rakkas
  static TextStyle rakkas({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a0251e564daba93e12cd57ba0f8d690c2c184c5dde185fca3839466a065ff45',
        92700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rakkas',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rakkas font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rakkas
  static TextTheme rakkasTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rakkas(textStyle: textTheme.displayLarge),
      displayMedium: rakkas(textStyle: textTheme.displayMedium),
      displaySmall: rakkas(textStyle: textTheme.displaySmall),
      headlineLarge: rakkas(textStyle: textTheme.headlineLarge),
      headlineMedium: rakkas(textStyle: textTheme.headlineMedium),
      headlineSmall: rakkas(textStyle: textTheme.headlineSmall),
      titleLarge: rakkas(textStyle: textTheme.titleLarge),
      titleMedium: rakkas(textStyle: textTheme.titleMedium),
      titleSmall: rakkas(textStyle: textTheme.titleSmall),
      bodyLarge: rakkas(textStyle: textTheme.bodyLarge),
      bodyMedium: rakkas(textStyle: textTheme.bodyMedium),
      bodySmall: rakkas(textStyle: textTheme.bodySmall),
      labelLarge: rakkas(textStyle: textTheme.labelLarge),
      labelMedium: rakkas(textStyle: textTheme.labelMedium),
      labelSmall: rakkas(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Raleway font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway
  static TextStyle raleway({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ccc7b8daf7d97f2eaf289fd8ee09d672ec03de726998d4a11064ce96cb5b091',
        117396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6928262c4b87773391cfe3978b20afec91fc36187677dc1dd7be7d7be435b81',
        117600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6fc88a772653bb6e2da18224e1be9ea55375862d7d1a8cf22dca233c85ef5c1',
        117516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac661aaf9fd351bf269b871099dbb39f71d05bd7cb7f3a969a680bc9362d5077',
        117472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ac0ef1bba490a426db33eea67509cd267d3e7809b4ff3f63e02eb234d61f8f9b',
        117484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c2fabac50d8c6fc6bf27277551c5292af421c4db70c1f3218808e8abb1c97f1',
        117516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0ed9e7247d8eacd6dc5f109f679db5113330139cfa9af99b68cf2070448a4c8',
        117428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3caf4682aee118526e994c0e7afed34611443bbdcbf0a313eac443244eacf48d',
        117516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a3345e74eaaf01d50b4b444f03b32e86cb7baf1a67ae29ac64935f0c7735aa8',
        117224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b9337ffa4805ec2761c292e5f310b0dfedb10d2a458af33ed9cf087b39bab19b',
        115240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45246a436cb9ab1dabd0a3ab897458a367a507aa9bdc74e23c8ce2463b9beb30',
        115348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '142491ef06d7400bd3ff5525b6ecf4832bbe36a8048d8d6486737d3a09045c33',
        115332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0f95401f0bd840aaf0071de3cde3159e005de76242d83b5ce225175a194123da',
        115148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '33fb4727d5f5e485ea9ff532bb3ab575b16299f9ffda65709a66f781d9e925f1',
        115248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9c4e2c99125fcffeaf04be63348c0849446d1cbe712e435e9eb9b16978285f7c',
        115360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a4043cb5acad18d4b32f93603d2d8b02b0b9b848b13fcd9dda6cc2f5f35b7f63',
        115232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05f61fa837f419ab5ece7b8df587d4caf90dd7c29b7eb0b1f75c641d79407041',
        115508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c256726b95d50d31485baadd4e8999ad2b1f0b6ef7b344c31f3360f808c85412',
        115136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Raleway',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Raleway font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway
  static TextTheme ralewayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: raleway(textStyle: textTheme.displayLarge),
      displayMedium: raleway(textStyle: textTheme.displayMedium),
      displaySmall: raleway(textStyle: textTheme.displaySmall),
      headlineLarge: raleway(textStyle: textTheme.headlineLarge),
      headlineMedium: raleway(textStyle: textTheme.headlineMedium),
      headlineSmall: raleway(textStyle: textTheme.headlineSmall),
      titleLarge: raleway(textStyle: textTheme.titleLarge),
      titleMedium: raleway(textStyle: textTheme.titleMedium),
      titleSmall: raleway(textStyle: textTheme.titleSmall),
      bodyLarge: raleway(textStyle: textTheme.bodyLarge),
      bodyMedium: raleway(textStyle: textTheme.bodyMedium),
      bodySmall: raleway(textStyle: textTheme.bodySmall),
      labelLarge: raleway(textStyle: textTheme.labelLarge),
      labelMedium: raleway(textStyle: textTheme.labelMedium),
      labelSmall: raleway(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Raleway Dots font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway+Dots
  static TextStyle ralewayDots({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d5cbeee558af619a3f7f0d4a5fa151b91eb94d076f17741c493350d35d3a9e2',
        188964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RalewayDots',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Raleway Dots font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Raleway+Dots
  static TextTheme ralewayDotsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ralewayDots(textStyle: textTheme.displayLarge),
      displayMedium: ralewayDots(textStyle: textTheme.displayMedium),
      displaySmall: ralewayDots(textStyle: textTheme.displaySmall),
      headlineLarge: ralewayDots(textStyle: textTheme.headlineLarge),
      headlineMedium: ralewayDots(textStyle: textTheme.headlineMedium),
      headlineSmall: ralewayDots(textStyle: textTheme.headlineSmall),
      titleLarge: ralewayDots(textStyle: textTheme.titleLarge),
      titleMedium: ralewayDots(textStyle: textTheme.titleMedium),
      titleSmall: ralewayDots(textStyle: textTheme.titleSmall),
      bodyLarge: ralewayDots(textStyle: textTheme.bodyLarge),
      bodyMedium: ralewayDots(textStyle: textTheme.bodyMedium),
      bodySmall: ralewayDots(textStyle: textTheme.bodySmall),
      labelLarge: ralewayDots(textStyle: textTheme.labelLarge),
      labelMedium: ralewayDots(textStyle: textTheme.labelMedium),
      labelSmall: ralewayDots(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ramabhadra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramabhadra
  static TextStyle ramabhadra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b475183d7a82e6754bbfebdeadda687af1ee9a3223b405314dfba9236a5acf3d',
        319564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ramabhadra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ramabhadra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramabhadra
  static TextTheme ramabhadraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ramabhadra(textStyle: textTheme.displayLarge),
      displayMedium: ramabhadra(textStyle: textTheme.displayMedium),
      displaySmall: ramabhadra(textStyle: textTheme.displaySmall),
      headlineLarge: ramabhadra(textStyle: textTheme.headlineLarge),
      headlineMedium: ramabhadra(textStyle: textTheme.headlineMedium),
      headlineSmall: ramabhadra(textStyle: textTheme.headlineSmall),
      titleLarge: ramabhadra(textStyle: textTheme.titleLarge),
      titleMedium: ramabhadra(textStyle: textTheme.titleMedium),
      titleSmall: ramabhadra(textStyle: textTheme.titleSmall),
      bodyLarge: ramabhadra(textStyle: textTheme.bodyLarge),
      bodyMedium: ramabhadra(textStyle: textTheme.bodyMedium),
      bodySmall: ramabhadra(textStyle: textTheme.bodySmall),
      labelLarge: ramabhadra(textStyle: textTheme.labelLarge),
      labelMedium: ramabhadra(textStyle: textTheme.labelMedium),
      labelSmall: ramabhadra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ramaraja font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramaraja
  static TextStyle ramaraja({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17595caf1dbf5c3235c44859d0b4543d12923808268604b0967ecc4fa1e7dff8',
        440392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ramaraja',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ramaraja font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ramaraja
  static TextTheme ramarajaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ramaraja(textStyle: textTheme.displayLarge),
      displayMedium: ramaraja(textStyle: textTheme.displayMedium),
      displaySmall: ramaraja(textStyle: textTheme.displaySmall),
      headlineLarge: ramaraja(textStyle: textTheme.headlineLarge),
      headlineMedium: ramaraja(textStyle: textTheme.headlineMedium),
      headlineSmall: ramaraja(textStyle: textTheme.headlineSmall),
      titleLarge: ramaraja(textStyle: textTheme.titleLarge),
      titleMedium: ramaraja(textStyle: textTheme.titleMedium),
      titleSmall: ramaraja(textStyle: textTheme.titleSmall),
      bodyLarge: ramaraja(textStyle: textTheme.bodyLarge),
      bodyMedium: ramaraja(textStyle: textTheme.bodyMedium),
      bodySmall: ramaraja(textStyle: textTheme.bodySmall),
      labelLarge: ramaraja(textStyle: textTheme.labelLarge),
      labelMedium: ramaraja(textStyle: textTheme.labelMedium),
      labelSmall: ramaraja(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rambla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rambla
  static TextStyle rambla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '445f78a8f5be7d9ef22efa54929a0e53c95c5212fd40e5323bc5ee27ff263adc',
        32208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f8559dd68b1e4ec33ea8e82aef88e2ac65b5208e90aedcc3570b9e258dde3858',
        34992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd2ab0095a5821055695a33234b3576af18a07613dcc2864526bb1c5c6e4fecbc',
        32248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4595e357da22bc7ae81a691962b115024e2cfc624fda09673d4785f4761d7f9b',
        34820,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rambla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rambla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rambla
  static TextTheme ramblaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rambla(textStyle: textTheme.displayLarge),
      displayMedium: rambla(textStyle: textTheme.displayMedium),
      displaySmall: rambla(textStyle: textTheme.displaySmall),
      headlineLarge: rambla(textStyle: textTheme.headlineLarge),
      headlineMedium: rambla(textStyle: textTheme.headlineMedium),
      headlineSmall: rambla(textStyle: textTheme.headlineSmall),
      titleLarge: rambla(textStyle: textTheme.titleLarge),
      titleMedium: rambla(textStyle: textTheme.titleMedium),
      titleSmall: rambla(textStyle: textTheme.titleSmall),
      bodyLarge: rambla(textStyle: textTheme.bodyLarge),
      bodyMedium: rambla(textStyle: textTheme.bodyMedium),
      bodySmall: rambla(textStyle: textTheme.bodySmall),
      labelLarge: rambla(textStyle: textTheme.labelLarge),
      labelMedium: rambla(textStyle: textTheme.labelMedium),
      labelSmall: rambla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rammetto One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rammetto+One
  static TextStyle rammettoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ced30bf0a7149475d29152a23843562b27006a44dfe84486fb0daea5a625d9d',
        38756,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RammettoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rammetto One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rammetto+One
  static TextTheme rammettoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rammettoOne(textStyle: textTheme.displayLarge),
      displayMedium: rammettoOne(textStyle: textTheme.displayMedium),
      displaySmall: rammettoOne(textStyle: textTheme.displaySmall),
      headlineLarge: rammettoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rammettoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rammettoOne(textStyle: textTheme.headlineSmall),
      titleLarge: rammettoOne(textStyle: textTheme.titleLarge),
      titleMedium: rammettoOne(textStyle: textTheme.titleMedium),
      titleSmall: rammettoOne(textStyle: textTheme.titleSmall),
      bodyLarge: rammettoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rammettoOne(textStyle: textTheme.bodyMedium),
      bodySmall: rammettoOne(textStyle: textTheme.bodySmall),
      labelLarge: rammettoOne(textStyle: textTheme.labelLarge),
      labelMedium: rammettoOne(textStyle: textTheme.labelMedium),
      labelSmall: rammettoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rampart One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rampart+One
  static TextStyle rampartOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df668f90decf9f8af77d5e3d28d925a74b7dce3d8a9972daa5a42f350d308292',
        3404536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RampartOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rampart One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rampart+One
  static TextTheme rampartOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rampartOne(textStyle: textTheme.displayLarge),
      displayMedium: rampartOne(textStyle: textTheme.displayMedium),
      displaySmall: rampartOne(textStyle: textTheme.displaySmall),
      headlineLarge: rampartOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rampartOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rampartOne(textStyle: textTheme.headlineSmall),
      titleLarge: rampartOne(textStyle: textTheme.titleLarge),
      titleMedium: rampartOne(textStyle: textTheme.titleMedium),
      titleSmall: rampartOne(textStyle: textTheme.titleSmall),
      bodyLarge: rampartOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rampartOne(textStyle: textTheme.bodyMedium),
      bodySmall: rampartOne(textStyle: textTheme.bodySmall),
      labelLarge: rampartOne(textStyle: textTheme.labelLarge),
      labelMedium: rampartOne(textStyle: textTheme.labelMedium),
      labelSmall: rampartOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ranchers font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranchers
  static TextStyle ranchers({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30959d0aee674a57c2064a0453d3568bf69f436b1add896dc68f5c563c752806',
        90044,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ranchers',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ranchers font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranchers
  static TextTheme ranchersTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ranchers(textStyle: textTheme.displayLarge),
      displayMedium: ranchers(textStyle: textTheme.displayMedium),
      displaySmall: ranchers(textStyle: textTheme.displaySmall),
      headlineLarge: ranchers(textStyle: textTheme.headlineLarge),
      headlineMedium: ranchers(textStyle: textTheme.headlineMedium),
      headlineSmall: ranchers(textStyle: textTheme.headlineSmall),
      titleLarge: ranchers(textStyle: textTheme.titleLarge),
      titleMedium: ranchers(textStyle: textTheme.titleMedium),
      titleSmall: ranchers(textStyle: textTheme.titleSmall),
      bodyLarge: ranchers(textStyle: textTheme.bodyLarge),
      bodyMedium: ranchers(textStyle: textTheme.bodyMedium),
      bodySmall: ranchers(textStyle: textTheme.bodySmall),
      labelLarge: ranchers(textStyle: textTheme.labelLarge),
      labelMedium: ranchers(textStyle: textTheme.labelMedium),
      labelSmall: ranchers(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rancho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rancho
  static TextStyle rancho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3447da70ebae60ab0ecbfc27349188fe3a9de380aab5dd639760493c9493966',
        43096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rancho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rancho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rancho
  static TextTheme ranchoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rancho(textStyle: textTheme.displayLarge),
      displayMedium: rancho(textStyle: textTheme.displayMedium),
      displaySmall: rancho(textStyle: textTheme.displaySmall),
      headlineLarge: rancho(textStyle: textTheme.headlineLarge),
      headlineMedium: rancho(textStyle: textTheme.headlineMedium),
      headlineSmall: rancho(textStyle: textTheme.headlineSmall),
      titleLarge: rancho(textStyle: textTheme.titleLarge),
      titleMedium: rancho(textStyle: textTheme.titleMedium),
      titleSmall: rancho(textStyle: textTheme.titleSmall),
      bodyLarge: rancho(textStyle: textTheme.bodyLarge),
      bodyMedium: rancho(textStyle: textTheme.bodyMedium),
      bodySmall: rancho(textStyle: textTheme.bodySmall),
      labelLarge: rancho(textStyle: textTheme.labelLarge),
      labelMedium: rancho(textStyle: textTheme.labelMedium),
      labelSmall: rancho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ranga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranga
  static TextStyle ranga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c63c0af4da5a4e20b84dbfdb056c7ac1c61d5e48372906d8cf76ce80ce5c9af',
        105756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '961432ef0728647b8fb1733b50f24f6fd6be11f65a4c8970d4726fd301f83c9a',
        113056,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ranga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ranga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ranga
  static TextTheme rangaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ranga(textStyle: textTheme.displayLarge),
      displayMedium: ranga(textStyle: textTheme.displayMedium),
      displaySmall: ranga(textStyle: textTheme.displaySmall),
      headlineLarge: ranga(textStyle: textTheme.headlineLarge),
      headlineMedium: ranga(textStyle: textTheme.headlineMedium),
      headlineSmall: ranga(textStyle: textTheme.headlineSmall),
      titleLarge: ranga(textStyle: textTheme.titleLarge),
      titleMedium: ranga(textStyle: textTheme.titleMedium),
      titleSmall: ranga(textStyle: textTheme.titleSmall),
      bodyLarge: ranga(textStyle: textTheme.bodyLarge),
      bodyMedium: ranga(textStyle: textTheme.bodyMedium),
      bodySmall: ranga(textStyle: textTheme.bodySmall),
      labelLarge: ranga(textStyle: textTheme.labelLarge),
      labelMedium: ranga(textStyle: textTheme.labelMedium),
      labelSmall: ranga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rasa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rasa
  static TextStyle rasa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '218c26c408884cf1d34d09427a58a6e59f7d24b5f2bd1f49910bab2722dea657',
        244980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a5271399da41e8b1e31e915c0b98acc0ed864f38d5773e65df4e626178664df',
        245792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc178c509ac3fd0e8da2aa46a983a36f11e5847a95bbdcb7f26a56787e53466d',
        245796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8f96b681ebe3e8d196e877a542fde58d2abf66d21ed43c61de8c535062219235',
        245912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbb33fcde96fe046c617cc97b1cde74d43ccd00636219162c2163b139b50fc43',
        245080,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec02d2a4b0891757dc252b2f8c78c7bb252cbeb33b8c5bb3b668600a61a56199',
        148584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b43c1f80404deff3892b0dacc848c5d1edb3b5d4493f8affcec5820c5ee0874c',
        148504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '799ccf0289a2e612c150f688e18b9fc39238e3c9873b88fd5feb78487e012391',
        148580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0c5dd074640c478bbc91d3ed8cd1da24c4c65cec8b31b3983f5b47c3b366c27e',
        148704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66faaec965d4b628821c26b2b410dde57bf45eea186843f9de6fc11511ea50c4',
        147832,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rasa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rasa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rasa
  static TextTheme rasaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rasa(textStyle: textTheme.displayLarge),
      displayMedium: rasa(textStyle: textTheme.displayMedium),
      displaySmall: rasa(textStyle: textTheme.displaySmall),
      headlineLarge: rasa(textStyle: textTheme.headlineLarge),
      headlineMedium: rasa(textStyle: textTheme.headlineMedium),
      headlineSmall: rasa(textStyle: textTheme.headlineSmall),
      titleLarge: rasa(textStyle: textTheme.titleLarge),
      titleMedium: rasa(textStyle: textTheme.titleMedium),
      titleSmall: rasa(textStyle: textTheme.titleSmall),
      bodyLarge: rasa(textStyle: textTheme.bodyLarge),
      bodyMedium: rasa(textStyle: textTheme.bodyMedium),
      bodySmall: rasa(textStyle: textTheme.bodySmall),
      labelLarge: rasa(textStyle: textTheme.labelLarge),
      labelMedium: rasa(textStyle: textTheme.labelMedium),
      labelSmall: rasa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rationale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rationale
  static TextStyle rationale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ca296c443dbda669330e89426f990de63efe15a7521771226bb4158e3aef57f',
        24460,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rationale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rationale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rationale
  static TextTheme rationaleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rationale(textStyle: textTheme.displayLarge),
      displayMedium: rationale(textStyle: textTheme.displayMedium),
      displaySmall: rationale(textStyle: textTheme.displaySmall),
      headlineLarge: rationale(textStyle: textTheme.headlineLarge),
      headlineMedium: rationale(textStyle: textTheme.headlineMedium),
      headlineSmall: rationale(textStyle: textTheme.headlineSmall),
      titleLarge: rationale(textStyle: textTheme.titleLarge),
      titleMedium: rationale(textStyle: textTheme.titleMedium),
      titleSmall: rationale(textStyle: textTheme.titleSmall),
      bodyLarge: rationale(textStyle: textTheme.bodyLarge),
      bodyMedium: rationale(textStyle: textTheme.bodyMedium),
      bodySmall: rationale(textStyle: textTheme.bodySmall),
      labelLarge: rationale(textStyle: textTheme.labelLarge),
      labelMedium: rationale(textStyle: textTheme.labelMedium),
      labelSmall: rationale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ravi Prakash font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ravi+Prakash
  static TextStyle raviPrakash({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c5f4ae0672f4c453482ad920569bda880a2e8f64f9569606544cba6be6463a2',
        214764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RaviPrakash',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ravi Prakash font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ravi+Prakash
  static TextTheme raviPrakashTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: raviPrakash(textStyle: textTheme.displayLarge),
      displayMedium: raviPrakash(textStyle: textTheme.displayMedium),
      displaySmall: raviPrakash(textStyle: textTheme.displaySmall),
      headlineLarge: raviPrakash(textStyle: textTheme.headlineLarge),
      headlineMedium: raviPrakash(textStyle: textTheme.headlineMedium),
      headlineSmall: raviPrakash(textStyle: textTheme.headlineSmall),
      titleLarge: raviPrakash(textStyle: textTheme.titleLarge),
      titleMedium: raviPrakash(textStyle: textTheme.titleMedium),
      titleSmall: raviPrakash(textStyle: textTheme.titleSmall),
      bodyLarge: raviPrakash(textStyle: textTheme.bodyLarge),
      bodyMedium: raviPrakash(textStyle: textTheme.bodyMedium),
      bodySmall: raviPrakash(textStyle: textTheme.bodySmall),
      labelLarge: raviPrakash(textStyle: textTheme.labelLarge),
      labelMedium: raviPrakash(textStyle: textTheme.labelMedium),
      labelSmall: raviPrakash(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Readex Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Readex+Pro
  static TextStyle readexPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '870a3330a3749a6f77ae6869705a73e7cac177a535bebe60323fc706f632267c',
        93952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38b0632b8ef49efc7781f129be6231d9e8f2191fe9522a7af3c63f514a1db7c8',
        94064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7782ff7d5dea5d731043a6a9485f9c129227a140122a8d5b066a4139b6db2dcb',
        93604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd123b1e15265f38bb1e7ea3130a5b50529e1dd2701fd815a7a2c5ebd773cbf7',
        94112,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6416f2670653f40b5d522b959fa9cef26de93f1eb07383cd74add81cd540223',
        94252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ea6ca5c476dff3996be03d6f357b8fc79d536b3324a74a2b8cd8d95b0c2d7cec',
        94224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReadexPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Readex Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Readex+Pro
  static TextTheme readexProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: readexPro(textStyle: textTheme.displayLarge),
      displayMedium: readexPro(textStyle: textTheme.displayMedium),
      displaySmall: readexPro(textStyle: textTheme.displaySmall),
      headlineLarge: readexPro(textStyle: textTheme.headlineLarge),
      headlineMedium: readexPro(textStyle: textTheme.headlineMedium),
      headlineSmall: readexPro(textStyle: textTheme.headlineSmall),
      titleLarge: readexPro(textStyle: textTheme.titleLarge),
      titleMedium: readexPro(textStyle: textTheme.titleMedium),
      titleSmall: readexPro(textStyle: textTheme.titleSmall),
      bodyLarge: readexPro(textStyle: textTheme.bodyLarge),
      bodyMedium: readexPro(textStyle: textTheme.bodyMedium),
      bodySmall: readexPro(textStyle: textTheme.bodySmall),
      labelLarge: readexPro(textStyle: textTheme.labelLarge),
      labelMedium: readexPro(textStyle: textTheme.labelMedium),
      labelSmall: readexPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Recursive font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Recursive
  static TextStyle recursive({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7748f5ad9ae66852acd16989b9cd847a6eafb62b8f66e1e183ac01b21a09fb27',
        129608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f04641c5d68e90e8fba5c44ff79e2a7258c9cba7d2cbedf9a2fff84a9d4aa0f',
        129728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4be68625480f8d889efc77667b28bcf207fcf6862ab835c35a40059256f760c',
        129728,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6440e56b8d6cfab8e502434eed812dedb8f9c0f51e299973e232dd634f6fae1',
        129736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a49d0f7791d769955cd2ca09fc039d3d8af2469bc5115ceb6912f9f9ae98e5d3',
        129588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3e66b82425c799169d68adb073004b8bb074465649b35fd140728288e728657',
        129540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93551aa5f9bdb177c1fff934cc64692099d6e6711ce69f988257af6e42c1e57e',
        129660,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Recursive',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Recursive font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Recursive
  static TextTheme recursiveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: recursive(textStyle: textTheme.displayLarge),
      displayMedium: recursive(textStyle: textTheme.displayMedium),
      displaySmall: recursive(textStyle: textTheme.displaySmall),
      headlineLarge: recursive(textStyle: textTheme.headlineLarge),
      headlineMedium: recursive(textStyle: textTheme.headlineMedium),
      headlineSmall: recursive(textStyle: textTheme.headlineSmall),
      titleLarge: recursive(textStyle: textTheme.titleLarge),
      titleMedium: recursive(textStyle: textTheme.titleMedium),
      titleSmall: recursive(textStyle: textTheme.titleSmall),
      bodyLarge: recursive(textStyle: textTheme.bodyLarge),
      bodyMedium: recursive(textStyle: textTheme.bodyMedium),
      bodySmall: recursive(textStyle: textTheme.bodySmall),
      labelLarge: recursive(textStyle: textTheme.labelLarge),
      labelMedium: recursive(textStyle: textTheme.labelMedium),
      labelSmall: recursive(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Display
  static TextStyle redHatDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '70007905adda13fc218dd33a3346c0a7652b31466a4de2af4626e5329f10f3c9',
        43332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6cb14e9f56379700f63f32e6e6a324c1f31d34c43af28a494cfbe291331c098d',
        43284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1741b1542ec8a72dc07ecb6346eaba419c6771e44af1c6659e4c9773c1391da7',
        43320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09db67258b0f12c485007d0dac9a2e0f8455a2e2212ab026630be6fc21cdfecc',
        43332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f3fc7776a329d45c9ec8c3a7f7e5e8db3f9647173add45cb6c7223d7a64aac4',
        43248,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c5d508d39bc9caee10223ae430a6957408f494cdc3befbf03cd77fc70d37c5d5',
        43324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3d11cbf79abbbcfd4b540ba92077aa17b7a6b3e75d238c81f3db9ad9957a1b4',
        43252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13df11daa17b3a82abb58237406b14fa34fdcca54bbf4688e6feeceededd5632',
        44824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fdd4fcae1c5a1deba31b1652e0066f0cbbf35bd74a48856a0f91f8d6c48f009d',
        44676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4797f8d11c5e0f71f591f47d81d95ef7ee23cb14a91986793dee9e6b5dcde1e3',
        44808,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c35a172652686b30739abbb39e7193c8f810712557057a5b874b8d1f09564f45',
        44832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f49fe81d7560d659456be7794d51e26a60ca73436a9e51b5f1f952c16c7d1c9f',
        44700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47c9e8ccf897a70c057b655fdc90a8fb0fbe2ebe0e61474b29a079b1c0912d4f',
        44824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f792d930567c8220f54cbd036a945acae43a7bfdd32b64540995a21dcf72acc',
        44764,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Display
  static TextTheme redHatDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatDisplay(textStyle: textTheme.displayLarge),
      displayMedium: redHatDisplay(textStyle: textTheme.displayMedium),
      displaySmall: redHatDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: redHatDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: redHatDisplay(textStyle: textTheme.titleLarge),
      titleMedium: redHatDisplay(textStyle: textTheme.titleMedium),
      titleSmall: redHatDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: redHatDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: redHatDisplay(textStyle: textTheme.bodySmall),
      labelLarge: redHatDisplay(textStyle: textTheme.labelLarge),
      labelMedium: redHatDisplay(textStyle: textTheme.labelMedium),
      labelSmall: redHatDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Mono
  static TextStyle redHatMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '239e258e764c1b9060615eaa7cfbf3778aa83f7a5ec72c1c5a346d78c87e28ef',
        29048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b0194738ce0c9c8896840d9c0dcaf728cbd2eab49b9e9755c860a001a7ff8ff4',
        28996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebf8b22e4be78548f2aa36b9aff1e7db1bac94acd26fb142d134f3615325f5a2',
        28972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28e75eaf8dfd4d9e17f314592cabb2bba162c33bea65e97d4146e093b9ba7d18',
        28988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc1d359c43674ff0a1ba0a9500e6cf7ecf0fae1797092b364742598dc73f8896',
        28888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dbb09ab855171dab295771515814d4ef8aa30df4c873b5f402a93268e0731417',
        30564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f85e6038eb2f82b4d42b9337782e37cc9c8d1fafa878d7bfc201820b5d6a48fb',
        30388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0f5f2b1f4d6e73c2a84c548c4f034df2148f7026d3a974554e78188bce8b45f4',
        30492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '47652a68e076418443f4c808f58c1a45a911eef65f092b687c605d44b6523fb4',
        30516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '880ea27e962f8ddc50209cf3dab5296baf422cf62882f9e01d6beff4093a0e5d',
        30412,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Mono
  static TextTheme redHatMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatMono(textStyle: textTheme.displayLarge),
      displayMedium: redHatMono(textStyle: textTheme.displayMedium),
      displaySmall: redHatMono(textStyle: textTheme.displaySmall),
      headlineLarge: redHatMono(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatMono(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatMono(textStyle: textTheme.headlineSmall),
      titleLarge: redHatMono(textStyle: textTheme.titleLarge),
      titleMedium: redHatMono(textStyle: textTheme.titleMedium),
      titleSmall: redHatMono(textStyle: textTheme.titleSmall),
      bodyLarge: redHatMono(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatMono(textStyle: textTheme.bodyMedium),
      bodySmall: redHatMono(textStyle: textTheme.bodySmall),
      labelLarge: redHatMono(textStyle: textTheme.labelLarge),
      labelMedium: redHatMono(textStyle: textTheme.labelMedium),
      labelSmall: redHatMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Hat Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Text
  static TextStyle redHatText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '639b0873e37eaf867d9593dda1547868e2861ce95a66e72118d52baa83d9dee0',
        43364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c094403ff667ba77467e5c43dfaebc6a373241c7c621a3d252c357b3be4b3ce',
        43352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87e8dda078e0470e440f837ae95d67e9a7761ba2f3a50e486e0ae4636838feff',
        43360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c1d104bb5e6983ac7cbbcb4c8affb207396fe193d1c21864f32a5239f923c198',
        43376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2cdb1b5da7eda78e1766b23e9ced576f4ae00d3a33a4239c06d9f00a1a69ead2',
        43272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97634e9b16bd3f34266e71ca833878c49e7227068834ea0f7637c123cecc0d81',
        45004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ba2604821e3be26674e3f4ec9f8ffbdba7f405e9f2a9338bc598352f5aa49979',
        44900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7d682c154876a792660c03a5ee31979b5609209d68e8445d63151a19812d804c',
        45040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'befd02765e7b3c597527f8c382d846c08e94cc7005b8bd70543fd7cbc39ad09b',
        45064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6f7d5000167510ed510def7274eaf79095eb9e29b8707316f3a19ff0cc6bf16a',
        44932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedHatText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Hat Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Hat+Text
  static TextTheme redHatTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redHatText(textStyle: textTheme.displayLarge),
      displayMedium: redHatText(textStyle: textTheme.displayMedium),
      displaySmall: redHatText(textStyle: textTheme.displaySmall),
      headlineLarge: redHatText(textStyle: textTheme.headlineLarge),
      headlineMedium: redHatText(textStyle: textTheme.headlineMedium),
      headlineSmall: redHatText(textStyle: textTheme.headlineSmall),
      titleLarge: redHatText(textStyle: textTheme.titleLarge),
      titleMedium: redHatText(textStyle: textTheme.titleMedium),
      titleSmall: redHatText(textStyle: textTheme.titleSmall),
      bodyLarge: redHatText(textStyle: textTheme.bodyLarge),
      bodyMedium: redHatText(textStyle: textTheme.bodyMedium),
      bodySmall: redHatText(textStyle: textTheme.bodySmall),
      labelLarge: redHatText(textStyle: textTheme.labelLarge),
      labelMedium: redHatText(textStyle: textTheme.labelMedium),
      labelSmall: redHatText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Red Rose font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Rose
  static TextStyle redRose({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46c14c3e0ff65c270e74f12d703c9342654ba7569cc691865ed95d4d3bad8c45',
        62016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '978beaa148a6104947ae25c087fa6751b40720f1319b22440a3e17b2451801de',
        62060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '490deaed68387998fb55ab8a1ea94b2417c79d9a8ad36ceb151f2702be3399a2',
        62104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f10a411a2b5cdac67cf96d6fd27c22aabc2cb2658e57ae87f65e9fe7675f0942',
        62132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e188bda7580dcc1ab6915b5fb16d6125d2f765979166be1883a24e71b3ca89dc',
        62052,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedRose',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Red Rose font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Red+Rose
  static TextTheme redRoseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redRose(textStyle: textTheme.displayLarge),
      displayMedium: redRose(textStyle: textTheme.displayMedium),
      displaySmall: redRose(textStyle: textTheme.displaySmall),
      headlineLarge: redRose(textStyle: textTheme.headlineLarge),
      headlineMedium: redRose(textStyle: textTheme.headlineMedium),
      headlineSmall: redRose(textStyle: textTheme.headlineSmall),
      titleLarge: redRose(textStyle: textTheme.titleLarge),
      titleMedium: redRose(textStyle: textTheme.titleMedium),
      titleSmall: redRose(textStyle: textTheme.titleSmall),
      bodyLarge: redRose(textStyle: textTheme.bodyLarge),
      bodyMedium: redRose(textStyle: textTheme.bodyMedium),
      bodySmall: redRose(textStyle: textTheme.bodySmall),
      labelLarge: redRose(textStyle: textTheme.labelLarge),
      labelMedium: redRose(textStyle: textTheme.labelMedium),
      labelSmall: redRose(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redacted font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted
  static TextStyle redacted({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '181d9572bd91a3e91087f45a2c8846a80bf92ec73cc0911e082031377e412d34',
        11404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Redacted',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redacted font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted
  static TextTheme redactedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redacted(textStyle: textTheme.displayLarge),
      displayMedium: redacted(textStyle: textTheme.displayMedium),
      displaySmall: redacted(textStyle: textTheme.displaySmall),
      headlineLarge: redacted(textStyle: textTheme.headlineLarge),
      headlineMedium: redacted(textStyle: textTheme.headlineMedium),
      headlineSmall: redacted(textStyle: textTheme.headlineSmall),
      titleLarge: redacted(textStyle: textTheme.titleLarge),
      titleMedium: redacted(textStyle: textTheme.titleMedium),
      titleSmall: redacted(textStyle: textTheme.titleSmall),
      bodyLarge: redacted(textStyle: textTheme.bodyLarge),
      bodyMedium: redacted(textStyle: textTheme.bodyMedium),
      bodySmall: redacted(textStyle: textTheme.bodySmall),
      labelLarge: redacted(textStyle: textTheme.labelLarge),
      labelMedium: redacted(textStyle: textTheme.labelMedium),
      labelSmall: redacted(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redacted Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted+Script
  static TextStyle redactedScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e7784827341a4a812e71d0aa01a7325fc0b8c1eef709d744657c17f7781c926',
        70708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd8a8e3c46fa17ed6e1ea768d109b1309bf6174c5a8e64e9bcdab61fcb47370c',
        70188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e7045615530585024ca8f4b1b4d1ddfa1b4191836087d820c27af41939d9842',
        68168,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedactedScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redacted Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redacted+Script
  static TextTheme redactedScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redactedScript(textStyle: textTheme.displayLarge),
      displayMedium: redactedScript(textStyle: textTheme.displayMedium),
      displaySmall: redactedScript(textStyle: textTheme.displaySmall),
      headlineLarge: redactedScript(textStyle: textTheme.headlineLarge),
      headlineMedium: redactedScript(textStyle: textTheme.headlineMedium),
      headlineSmall: redactedScript(textStyle: textTheme.headlineSmall),
      titleLarge: redactedScript(textStyle: textTheme.titleLarge),
      titleMedium: redactedScript(textStyle: textTheme.titleMedium),
      titleSmall: redactedScript(textStyle: textTheme.titleSmall),
      bodyLarge: redactedScript(textStyle: textTheme.bodyLarge),
      bodyMedium: redactedScript(textStyle: textTheme.bodyMedium),
      bodySmall: redactedScript(textStyle: textTheme.bodySmall),
      labelLarge: redactedScript(textStyle: textTheme.labelLarge),
      labelMedium: redactedScript(textStyle: textTheme.labelMedium),
      labelSmall: redactedScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reddit Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Mono
  static TextStyle redditMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80f51aa17f375318ed8bc72d59f175e7b2d8b5093ae8036c29f39579beeda294',
        79576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef4da64f7478c7e71e260432dc25f2713a3891b93bf1b7090afbc5eaf4c7954b',
        79920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1851dcf37dcc6d724c8a98d4c19a5015c3f605e1bb4920abc5758e7d1889658b',
        79608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8539b7a6d80e1ba66e69e4e14c0391674516e86bcca7f2aaeaddbd01f27c1ae8',
        79828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51dd3ded3f84d09aad38987501418b7ced04478e40472411e7e5313f6b617f82',
        79720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91b197ad8e055eb83573976eaf07f10fa104e74ea9add6feacfec375fb6019d6',
        79760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ce84b7b08bed99f121d75d60db39a23f3b315f2f88a457353137ea871f6d9f8f',
        80152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0be357b40aec49ae663c0d73b11d755c516dff2334d794168d3f0f5d8a9a2c7c',
        79800,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedditMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reddit Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Mono
  static TextTheme redditMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redditMono(textStyle: textTheme.displayLarge),
      displayMedium: redditMono(textStyle: textTheme.displayMedium),
      displaySmall: redditMono(textStyle: textTheme.displaySmall),
      headlineLarge: redditMono(textStyle: textTheme.headlineLarge),
      headlineMedium: redditMono(textStyle: textTheme.headlineMedium),
      headlineSmall: redditMono(textStyle: textTheme.headlineSmall),
      titleLarge: redditMono(textStyle: textTheme.titleLarge),
      titleMedium: redditMono(textStyle: textTheme.titleMedium),
      titleSmall: redditMono(textStyle: textTheme.titleSmall),
      bodyLarge: redditMono(textStyle: textTheme.bodyLarge),
      bodyMedium: redditMono(textStyle: textTheme.bodyMedium),
      bodySmall: redditMono(textStyle: textTheme.bodySmall),
      labelLarge: redditMono(textStyle: textTheme.labelLarge),
      labelMedium: redditMono(textStyle: textTheme.labelMedium),
      labelSmall: redditMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reddit Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Sans
  static TextStyle redditSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a26c075c2060ab702da9fd840c5f21efefe8723760820e8c56c59d15a7be7c5',
        100020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ff532913127ba003987867db4af81a0d37d8816cb399b08adb5d597fc1a06770',
        100456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a7f9f70325df2127b998495279958cb9e8dc33c3d44ce01c6813a9e6c0c767d',
        100164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d8604b55ce80f5533f6f24ca9ab9c5f7d5c6e7804f8a9b6d54e0412a89680aa',
        100460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c4a244b448901be148f3c4e04a5e8bf101242d3c64fb0daa8837f85ecf9b636',
        100556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6337b419fa06b998c83dd558a23399308fdd32f604065d85daa20ac1cbecea5',
        100636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85bbfc45e53b257af9a876c63ae147f6f40b5f9ffa4e9b087db9994e00fd00e4',
        101076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00262512548588845c51f2761ad923a5ca2868320d80421efb4d7be5474c0a44',
        100732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c1a70a94cf151538f463b1b04422e8b3190ab0f8cc59e940134c57fb109bbefb',
        95244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f0c8201bcb6e52c0a9e609959c3eb8f8176be3e89d95de6cd9530d83afd22fbd',
        95284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18444fb8962d3a0aa52dc8155675f73d6515781e2a04ce5d1dfa694ec070f234',
        95064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e28a7d3822dc702925f62808479400728ea7fe2c514dd7a620312b631a548040',
        95288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5509a63b09c77c18709c3572ffcebe454502fed84f17d3d44bf826afb14de223',
        95296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a5352db31a43f655d6b12892cd435113294917bf3043b131a3623b8d6c6348d6',
        95360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'dfa0e660849c5c9491a50693be0a1f1f22d121a08218cc2172b73f31765d313e',
        95668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5f0b605902a8bc900158ba09eafa9fafe21414c1dbbe71fcef24a8b632a440c2',
        95524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedditSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reddit Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Sans
  static TextTheme redditSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redditSans(textStyle: textTheme.displayLarge),
      displayMedium: redditSans(textStyle: textTheme.displayMedium),
      displaySmall: redditSans(textStyle: textTheme.displaySmall),
      headlineLarge: redditSans(textStyle: textTheme.headlineLarge),
      headlineMedium: redditSans(textStyle: textTheme.headlineMedium),
      headlineSmall: redditSans(textStyle: textTheme.headlineSmall),
      titleLarge: redditSans(textStyle: textTheme.titleLarge),
      titleMedium: redditSans(textStyle: textTheme.titleMedium),
      titleSmall: redditSans(textStyle: textTheme.titleSmall),
      bodyLarge: redditSans(textStyle: textTheme.bodyLarge),
      bodyMedium: redditSans(textStyle: textTheme.bodyMedium),
      bodySmall: redditSans(textStyle: textTheme.bodySmall),
      labelLarge: redditSans(textStyle: textTheme.labelLarge),
      labelMedium: redditSans(textStyle: textTheme.labelMedium),
      labelSmall: redditSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reddit Sans Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Sans+Condensed
  static TextStyle redditSansCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bea3e940424dfedb7573e207d3f929597ad62ff581488cffcf73638bd87a749c',
        98772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc0d31b04c55829bee3350ba74f0e56dcd86e121d72a2c67de71ee81a2387e36',
        99160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b290e264492e98974ebf84ce72dbfed712f30623930cf8e389a3c1e0a140cae',
        98924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c7e318b3af8aae171c8376d1cca67a6abd21fb61524b79ffecfd93ff48c22e9e',
        99180,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b471a6eb5c69ff97f942c7a754b72daa4a81a05349bbba3fd53c45423cfd08be',
        99328,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1425098cf99cbd74ca0866b784a1fa58bfa11c4a333e3f859cea82efe664577d',
        99276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '552cc942c31a36397adba545d4546be26044349c45cafb5288458a5ec1c956a1',
        99752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e7c78cc7bf9ad6778a6d69b09aceb60580179d034392cfd7e28181e87a3112e',
        99544,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RedditSansCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reddit Sans Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reddit+Sans+Condensed
  static TextTheme redditSansCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redditSansCondensed(textStyle: textTheme.displayLarge),
      displayMedium: redditSansCondensed(textStyle: textTheme.displayMedium),
      displaySmall: redditSansCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: redditSansCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: redditSansCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: redditSansCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: redditSansCondensed(textStyle: textTheme.titleLarge),
      titleMedium: redditSansCondensed(textStyle: textTheme.titleMedium),
      titleSmall: redditSansCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: redditSansCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: redditSansCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: redditSansCondensed(textStyle: textTheme.bodySmall),
      labelLarge: redditSansCondensed(textStyle: textTheme.labelLarge),
      labelMedium: redditSansCondensed(textStyle: textTheme.labelMedium),
      labelSmall: redditSansCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Redressed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redressed
  static TextStyle redressed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcac3ad9bff550045d438a43282a4eb3a20ee265d660ff104f1a9f427dc5000e',
        64388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Redressed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Redressed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Redressed
  static TextTheme redressedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: redressed(textStyle: textTheme.displayLarge),
      displayMedium: redressed(textStyle: textTheme.displayMedium),
      displaySmall: redressed(textStyle: textTheme.displaySmall),
      headlineLarge: redressed(textStyle: textTheme.headlineLarge),
      headlineMedium: redressed(textStyle: textTheme.headlineMedium),
      headlineSmall: redressed(textStyle: textTheme.headlineSmall),
      titleLarge: redressed(textStyle: textTheme.titleLarge),
      titleMedium: redressed(textStyle: textTheme.titleMedium),
      titleSmall: redressed(textStyle: textTheme.titleSmall),
      bodyLarge: redressed(textStyle: textTheme.bodyLarge),
      bodyMedium: redressed(textStyle: textTheme.bodyMedium),
      bodySmall: redressed(textStyle: textTheme.bodySmall),
      labelLarge: redressed(textStyle: textTheme.labelLarge),
      labelMedium: redressed(textStyle: textTheme.labelMedium),
      labelSmall: redressed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi
  static TextStyle reemKufi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a5b8b5f58a79cc986db5a9c15215e976094ec505584d284fc02d2431dd4c60b',
        83008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d33f891f20e7b33b9ca107fdf9271d3e2853348b0013c67e280831d4695dc7a',
        83144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc55d20dc3021a57df574aac667c16399f5c0a1081b7c53dd45c50f38bf7e35b',
        83184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0833380f9df4600275f44023ced1da54efb880cb6eb2bca0dd9ec660ab60da9e',
        82920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi
  static TextTheme reemKufiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufi(textStyle: textTheme.displayLarge),
      displayMedium: reemKufi(textStyle: textTheme.displayMedium),
      displaySmall: reemKufi(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufi(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufi(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufi(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufi(textStyle: textTheme.titleLarge),
      titleMedium: reemKufi(textStyle: textTheme.titleMedium),
      titleSmall: reemKufi(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufi(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufi(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufi(textStyle: textTheme.bodySmall),
      labelLarge: reemKufi(textStyle: textTheme.labelLarge),
      labelMedium: reemKufi(textStyle: textTheme.labelMedium),
      labelSmall: reemKufi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi Fun font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Fun
  static TextStyle reemKufiFun({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e41a7b66d21d31c96fae5c92413012f5095b315b654dea7cf12f898dacb9b64a',
        93284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2c38eb5f04435c89a859e4066dae197b702b1a03f2f17621905675cc90ac618',
        93404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c430d0353d9ba16c242c257c157cff186361dcb724b5c4f184d0346418ae5b3d',
        93444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f1225852aaf4e8d4c39aa2a843cbcc5c29c14ec231aa1ffc9bd90d6d1515ca',
        93184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufiFun',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi Fun font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Fun
  static TextTheme reemKufiFunTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufiFun(textStyle: textTheme.displayLarge),
      displayMedium: reemKufiFun(textStyle: textTheme.displayMedium),
      displaySmall: reemKufiFun(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufiFun(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufiFun(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufiFun(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufiFun(textStyle: textTheme.titleLarge),
      titleMedium: reemKufiFun(textStyle: textTheme.titleMedium),
      titleSmall: reemKufiFun(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufiFun(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufiFun(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufiFun(textStyle: textTheme.bodySmall),
      labelLarge: reemKufiFun(textStyle: textTheme.labelLarge),
      labelMedium: reemKufiFun(textStyle: textTheme.labelMedium),
      labelSmall: reemKufiFun(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reem Kufi Ink font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Ink
  static TextStyle reemKufiInk({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb4fb620ee225e201cb8abf3a6edfa0836617a372e390956d059a8eb1553bcac',
        233828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReemKufiInk',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reem Kufi Ink font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reem+Kufi+Ink
  static TextTheme reemKufiInkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reemKufiInk(textStyle: textTheme.displayLarge),
      displayMedium: reemKufiInk(textStyle: textTheme.displayMedium),
      displaySmall: reemKufiInk(textStyle: textTheme.displaySmall),
      headlineLarge: reemKufiInk(textStyle: textTheme.headlineLarge),
      headlineMedium: reemKufiInk(textStyle: textTheme.headlineMedium),
      headlineSmall: reemKufiInk(textStyle: textTheme.headlineSmall),
      titleLarge: reemKufiInk(textStyle: textTheme.titleLarge),
      titleMedium: reemKufiInk(textStyle: textTheme.titleMedium),
      titleSmall: reemKufiInk(textStyle: textTheme.titleSmall),
      bodyLarge: reemKufiInk(textStyle: textTheme.bodyLarge),
      bodyMedium: reemKufiInk(textStyle: textTheme.bodyMedium),
      bodySmall: reemKufiInk(textStyle: textTheme.bodySmall),
      labelLarge: reemKufiInk(textStyle: textTheme.labelLarge),
      labelMedium: reemKufiInk(textStyle: textTheme.labelMedium),
      labelSmall: reemKufiInk(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reenie Beanie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reenie+Beanie
  static TextStyle reenieBeanie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03a88319ca67ab7296033210507a7cea6f5cdb6b2c53958a9546934fdcaf5d29',
        74092,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReenieBeanie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reenie Beanie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reenie+Beanie
  static TextTheme reenieBeanieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reenieBeanie(textStyle: textTheme.displayLarge),
      displayMedium: reenieBeanie(textStyle: textTheme.displayMedium),
      displaySmall: reenieBeanie(textStyle: textTheme.displaySmall),
      headlineLarge: reenieBeanie(textStyle: textTheme.headlineLarge),
      headlineMedium: reenieBeanie(textStyle: textTheme.headlineMedium),
      headlineSmall: reenieBeanie(textStyle: textTheme.headlineSmall),
      titleLarge: reenieBeanie(textStyle: textTheme.titleLarge),
      titleMedium: reenieBeanie(textStyle: textTheme.titleMedium),
      titleSmall: reenieBeanie(textStyle: textTheme.titleSmall),
      bodyLarge: reenieBeanie(textStyle: textTheme.bodyLarge),
      bodyMedium: reenieBeanie(textStyle: textTheme.bodyMedium),
      bodySmall: reenieBeanie(textStyle: textTheme.bodySmall),
      labelLarge: reenieBeanie(textStyle: textTheme.labelLarge),
      labelMedium: reenieBeanie(textStyle: textTheme.labelMedium),
      labelSmall: reenieBeanie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Reggae One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reggae+One
  static TextStyle reggaeOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '02517b6ae44f0449c2e10bce7c730d395b316647a6a5f18fef2239b58029edcc',
        1967072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ReggaeOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Reggae One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Reggae+One
  static TextTheme reggaeOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: reggaeOne(textStyle: textTheme.displayLarge),
      displayMedium: reggaeOne(textStyle: textTheme.displayMedium),
      displaySmall: reggaeOne(textStyle: textTheme.displaySmall),
      headlineLarge: reggaeOne(textStyle: textTheme.headlineLarge),
      headlineMedium: reggaeOne(textStyle: textTheme.headlineMedium),
      headlineSmall: reggaeOne(textStyle: textTheme.headlineSmall),
      titleLarge: reggaeOne(textStyle: textTheme.titleLarge),
      titleMedium: reggaeOne(textStyle: textTheme.titleMedium),
      titleSmall: reggaeOne(textStyle: textTheme.titleSmall),
      bodyLarge: reggaeOne(textStyle: textTheme.bodyLarge),
      bodyMedium: reggaeOne(textStyle: textTheme.bodyMedium),
      bodySmall: reggaeOne(textStyle: textTheme.bodySmall),
      labelLarge: reggaeOne(textStyle: textTheme.labelLarge),
      labelMedium: reggaeOne(textStyle: textTheme.labelMedium),
      labelSmall: reggaeOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rethink Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rethink+Sans
  static TextStyle rethinkSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c74a177189c30b5606aa29db8edf7f9d5e93ea74774d0278e7a5a57b4b7cdd51',
        58980,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b7814d00b7b55fd9845575e97e1f4862b4aef36203aa3cff2486d06864b88c3',
        59168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '95675c78901ed67841b217158e9a5497e689207bb94dc475ea1d4a9c42e4ee5f',
        59056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd49fa053a67a9fb0b256aed4a1de6f10b24b3b3272bb652cbedca3f8910f8b1a',
        59032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47e26c879855d4414815a7fb43ae15fb11f34a0cf90928250079e5d4e1332346',
        59192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bc5fd65360d879f7eb2091875bd4ec9e0d54a6bd555e6882ace70530c669a167',
        57796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '752fb6d0ef57416a7200551e542537f66986c92e24aa24c43c2d0aecb8790bfd',
        58036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d372350acf573cc0a8265a35a0da9a71877db3d15b77bd2c7ca541aa5a43ba5',
        57940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '75d10879830dd72723f01079bb778d1a3e379b2da0236b1047c3afb589d3292f',
        57880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2be85ed83bc8d02987bb490c98c38a93a4df5217e4d6b8625530ec3b912811de',
        58064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RethinkSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rethink Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rethink+Sans
  static TextTheme rethinkSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rethinkSans(textStyle: textTheme.displayLarge),
      displayMedium: rethinkSans(textStyle: textTheme.displayMedium),
      displaySmall: rethinkSans(textStyle: textTheme.displaySmall),
      headlineLarge: rethinkSans(textStyle: textTheme.headlineLarge),
      headlineMedium: rethinkSans(textStyle: textTheme.headlineMedium),
      headlineSmall: rethinkSans(textStyle: textTheme.headlineSmall),
      titleLarge: rethinkSans(textStyle: textTheme.titleLarge),
      titleMedium: rethinkSans(textStyle: textTheme.titleMedium),
      titleSmall: rethinkSans(textStyle: textTheme.titleSmall),
      bodyLarge: rethinkSans(textStyle: textTheme.bodyLarge),
      bodyMedium: rethinkSans(textStyle: textTheme.bodyMedium),
      bodySmall: rethinkSans(textStyle: textTheme.bodySmall),
      labelLarge: rethinkSans(textStyle: textTheme.labelLarge),
      labelMedium: rethinkSans(textStyle: textTheme.labelMedium),
      labelSmall: rethinkSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Revalia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Revalia
  static TextStyle revalia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c6913ffe382b2840e368ae186f438a8d34616ca662839b936acb9f85f19422bc',
        32240,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Revalia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Revalia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Revalia
  static TextTheme revaliaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: revalia(textStyle: textTheme.displayLarge),
      displayMedium: revalia(textStyle: textTheme.displayMedium),
      displaySmall: revalia(textStyle: textTheme.displaySmall),
      headlineLarge: revalia(textStyle: textTheme.headlineLarge),
      headlineMedium: revalia(textStyle: textTheme.headlineMedium),
      headlineSmall: revalia(textStyle: textTheme.headlineSmall),
      titleLarge: revalia(textStyle: textTheme.titleLarge),
      titleMedium: revalia(textStyle: textTheme.titleMedium),
      titleSmall: revalia(textStyle: textTheme.titleSmall),
      bodyLarge: revalia(textStyle: textTheme.bodyLarge),
      bodyMedium: revalia(textStyle: textTheme.bodyMedium),
      bodySmall: revalia(textStyle: textTheme.bodySmall),
      labelLarge: revalia(textStyle: textTheme.labelLarge),
      labelMedium: revalia(textStyle: textTheme.labelMedium),
      labelSmall: revalia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rhodium Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rhodium+Libre
  static TextStyle rhodiumLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8141e124491cb47820dd1b5f6ec1b32890a202f60c996db7d769a5287d1a34e',
        141492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RhodiumLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rhodium Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rhodium+Libre
  static TextTheme rhodiumLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rhodiumLibre(textStyle: textTheme.displayLarge),
      displayMedium: rhodiumLibre(textStyle: textTheme.displayMedium),
      displaySmall: rhodiumLibre(textStyle: textTheme.displaySmall),
      headlineLarge: rhodiumLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: rhodiumLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: rhodiumLibre(textStyle: textTheme.headlineSmall),
      titleLarge: rhodiumLibre(textStyle: textTheme.titleLarge),
      titleMedium: rhodiumLibre(textStyle: textTheme.titleMedium),
      titleSmall: rhodiumLibre(textStyle: textTheme.titleSmall),
      bodyLarge: rhodiumLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: rhodiumLibre(textStyle: textTheme.bodyMedium),
      bodySmall: rhodiumLibre(textStyle: textTheme.bodySmall),
      labelLarge: rhodiumLibre(textStyle: textTheme.labelLarge),
      labelMedium: rhodiumLibre(textStyle: textTheme.labelMedium),
      labelSmall: rhodiumLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ribeye font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye
  static TextStyle ribeye({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c828bd1f5213ab0a7470cb4b16b50c5c5da647bb41f9aed5cb6f04de7dbbd63b',
        75984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ribeye',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ribeye font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye
  static TextTheme ribeyeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ribeye(textStyle: textTheme.displayLarge),
      displayMedium: ribeye(textStyle: textTheme.displayMedium),
      displaySmall: ribeye(textStyle: textTheme.displaySmall),
      headlineLarge: ribeye(textStyle: textTheme.headlineLarge),
      headlineMedium: ribeye(textStyle: textTheme.headlineMedium),
      headlineSmall: ribeye(textStyle: textTheme.headlineSmall),
      titleLarge: ribeye(textStyle: textTheme.titleLarge),
      titleMedium: ribeye(textStyle: textTheme.titleMedium),
      titleSmall: ribeye(textStyle: textTheme.titleSmall),
      bodyLarge: ribeye(textStyle: textTheme.bodyLarge),
      bodyMedium: ribeye(textStyle: textTheme.bodyMedium),
      bodySmall: ribeye(textStyle: textTheme.bodySmall),
      labelLarge: ribeye(textStyle: textTheme.labelLarge),
      labelMedium: ribeye(textStyle: textTheme.labelMedium),
      labelSmall: ribeye(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ribeye Marrow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye+Marrow
  static TextStyle ribeyeMarrow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '337d7a1e2971cbd62bc80377bc5c68bbd22d303ca2fd111a110678d011fab8b0',
        73628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RibeyeMarrow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ribeye Marrow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ribeye+Marrow
  static TextTheme ribeyeMarrowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ribeyeMarrow(textStyle: textTheme.displayLarge),
      displayMedium: ribeyeMarrow(textStyle: textTheme.displayMedium),
      displaySmall: ribeyeMarrow(textStyle: textTheme.displaySmall),
      headlineLarge: ribeyeMarrow(textStyle: textTheme.headlineLarge),
      headlineMedium: ribeyeMarrow(textStyle: textTheme.headlineMedium),
      headlineSmall: ribeyeMarrow(textStyle: textTheme.headlineSmall),
      titleLarge: ribeyeMarrow(textStyle: textTheme.titleLarge),
      titleMedium: ribeyeMarrow(textStyle: textTheme.titleMedium),
      titleSmall: ribeyeMarrow(textStyle: textTheme.titleSmall),
      bodyLarge: ribeyeMarrow(textStyle: textTheme.bodyLarge),
      bodyMedium: ribeyeMarrow(textStyle: textTheme.bodyMedium),
      bodySmall: ribeyeMarrow(textStyle: textTheme.bodySmall),
      labelLarge: ribeyeMarrow(textStyle: textTheme.labelLarge),
      labelMedium: ribeyeMarrow(textStyle: textTheme.labelMedium),
      labelSmall: ribeyeMarrow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Righteous font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Righteous
  static TextStyle righteous({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40569bf6a851892a48f3108cf90ab6573b3b3974a3578cfc221e25f868268ca2',
        38828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Righteous',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Righteous font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Righteous
  static TextTheme righteousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: righteous(textStyle: textTheme.displayLarge),
      displayMedium: righteous(textStyle: textTheme.displayMedium),
      displaySmall: righteous(textStyle: textTheme.displaySmall),
      headlineLarge: righteous(textStyle: textTheme.headlineLarge),
      headlineMedium: righteous(textStyle: textTheme.headlineMedium),
      headlineSmall: righteous(textStyle: textTheme.headlineSmall),
      titleLarge: righteous(textStyle: textTheme.titleLarge),
      titleMedium: righteous(textStyle: textTheme.titleMedium),
      titleSmall: righteous(textStyle: textTheme.titleSmall),
      bodyLarge: righteous(textStyle: textTheme.bodyLarge),
      bodyMedium: righteous(textStyle: textTheme.bodyMedium),
      bodySmall: righteous(textStyle: textTheme.bodySmall),
      labelLarge: righteous(textStyle: textTheme.labelLarge),
      labelMedium: righteous(textStyle: textTheme.labelMedium),
      labelSmall: righteous(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Risque font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Risque
  static TextStyle risque({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e50df4434dbf73404d5e26334f71ac8959d1be599d98ea908dc8b585542f943',
        56472,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Risque',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Risque font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Risque
  static TextTheme risqueTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: risque(textStyle: textTheme.displayLarge),
      displayMedium: risque(textStyle: textTheme.displayMedium),
      displaySmall: risque(textStyle: textTheme.displaySmall),
      headlineLarge: risque(textStyle: textTheme.headlineLarge),
      headlineMedium: risque(textStyle: textTheme.headlineMedium),
      headlineSmall: risque(textStyle: textTheme.headlineSmall),
      titleLarge: risque(textStyle: textTheme.titleLarge),
      titleMedium: risque(textStyle: textTheme.titleMedium),
      titleSmall: risque(textStyle: textTheme.titleSmall),
      bodyLarge: risque(textStyle: textTheme.bodyLarge),
      bodyMedium: risque(textStyle: textTheme.bodyMedium),
      bodySmall: risque(textStyle: textTheme.bodySmall),
      labelLarge: risque(textStyle: textTheme.labelLarge),
      labelMedium: risque(textStyle: textTheme.labelMedium),
      labelSmall: risque(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Road Rage font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Road+Rage
  static TextStyle roadRage({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e1fa5681ec36690c7fc65e4a74279998ff907d9b426e9d887f41001caf8ea17',
        425896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RoadRage',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Road Rage font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Road+Rage
  static TextTheme roadRageTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: roadRage(textStyle: textTheme.displayLarge),
      displayMedium: roadRage(textStyle: textTheme.displayMedium),
      displaySmall: roadRage(textStyle: textTheme.displaySmall),
      headlineLarge: roadRage(textStyle: textTheme.headlineLarge),
      headlineMedium: roadRage(textStyle: textTheme.headlineMedium),
      headlineSmall: roadRage(textStyle: textTheme.headlineSmall),
      titleLarge: roadRage(textStyle: textTheme.titleLarge),
      titleMedium: roadRage(textStyle: textTheme.titleMedium),
      titleSmall: roadRage(textStyle: textTheme.titleSmall),
      bodyLarge: roadRage(textStyle: textTheme.bodyLarge),
      bodyMedium: roadRage(textStyle: textTheme.bodyMedium),
      bodySmall: roadRage(textStyle: textTheme.bodySmall),
      labelLarge: roadRage(textStyle: textTheme.labelLarge),
      labelMedium: roadRage(textStyle: textTheme.labelMedium),
      labelSmall: roadRage(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto
  static TextStyle roboto({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef133d43418a8f7f3ff94acf0d988529de27cb6cb23930482ea51a550df693c5',
        82272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd2a7927713af0acbdc77ab152426a365a2eacd8d9c5af8037961cee2862e4719',
        87224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bbec9513a9c2e908ad0daf806d486b5d81670e0cb6e048d90c526c39c7226986',
        81704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f351e28c00d79a9aeb2372efa5626827f4e6a1b7401321dc578fe9917ac40a83',
        86944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1d7c5f4500eeb1a09e051781906c3642015a3f6c9b69046b905c8bf34c6ad60',
        81044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02323a7160fcc356c056f7167dc9fdea07b9573ec2e8720914c6c2128be051f0',
        86224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ec3a64e46e2ee5f546845582e1d5409107780cef55bc43b052ee962f9807aee6',
        82628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18b1d7709525b550b77288cfa86d25c90744384cb3158eeafb24e61211beee59',
        87948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '05b2d0935046846efe2c8786ad1c5d909a11c3431787eea52f2fc70f2a8a6edf',
        82928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ac35b475460fbf9d94b44ba54ee3d3e7e208c75705f4c6acb7781d0d94cdeb63',
        88076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b1839e6182fe1be6a6f6ae74edaa1aa16d27b9787ff44aeef04baa0ba2404a9d',
        82956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4d7232f96ac551205759111c413af725e706eacab3477e429b72b66c74ecdf0a',
        88160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Roboto',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto
  static TextTheme robotoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: roboto(textStyle: textTheme.displayLarge),
      displayMedium: roboto(textStyle: textTheme.displayMedium),
      displaySmall: roboto(textStyle: textTheme.displaySmall),
      headlineLarge: roboto(textStyle: textTheme.headlineLarge),
      headlineMedium: roboto(textStyle: textTheme.headlineMedium),
      headlineSmall: roboto(textStyle: textTheme.headlineSmall),
      titleLarge: roboto(textStyle: textTheme.titleLarge),
      titleMedium: roboto(textStyle: textTheme.titleMedium),
      titleSmall: roboto(textStyle: textTheme.titleSmall),
      bodyLarge: roboto(textStyle: textTheme.bodyLarge),
      bodyMedium: roboto(textStyle: textTheme.bodyMedium),
      bodySmall: roboto(textStyle: textTheme.bodySmall),
      labelLarge: roboto(textStyle: textTheme.labelLarge),
      labelMedium: roboto(textStyle: textTheme.labelMedium),
      labelSmall: roboto(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Condensed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Condensed
  static TextStyle robotoCondensed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f94c0ff2d341c4c6533e828199343c80668cb5728c0936d2f32823d55540686b',
        80904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5d3383a4476bc585ab3a2d122966fc3ac2156372f18f97749f5bf2caf55bf39f',
        86504,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7580458a2610261a73df8676e738eb2640d45953d64b6ac206aa7fc591755538',
        80400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0cfb77c93d4ae6a534a1f4a50ea2be208c1821f62b53cf759febb79d0b0c7c56',
        85968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4828d8acdd8e41a0230d63f2359c5e243e9d2a3f36149c647f1e6aa3c9e64fe9',
        82280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6d54207482d2128d951b3ead9fcec3d75eeae3c7405952e364b41564a92d4832',
        87508,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoCondensed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Condensed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Condensed
  static TextTheme robotoCondensedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoCondensed(textStyle: textTheme.displayLarge),
      displayMedium: robotoCondensed(textStyle: textTheme.displayMedium),
      displaySmall: robotoCondensed(textStyle: textTheme.displaySmall),
      headlineLarge: robotoCondensed(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoCondensed(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoCondensed(textStyle: textTheme.headlineSmall),
      titleLarge: robotoCondensed(textStyle: textTheme.titleLarge),
      titleMedium: robotoCondensed(textStyle: textTheme.titleMedium),
      titleSmall: robotoCondensed(textStyle: textTheme.titleSmall),
      bodyLarge: robotoCondensed(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoCondensed(textStyle: textTheme.bodyMedium),
      bodySmall: robotoCondensed(textStyle: textTheme.bodySmall),
      labelLarge: robotoCondensed(textStyle: textTheme.labelLarge),
      labelMedium: robotoCondensed(textStyle: textTheme.labelMedium),
      labelSmall: robotoCondensed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Flex font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Flex
  static TextStyle robotoFlex({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4228a9a43f59ce22ab3e227767abc42526c5a851290395d09847306586c95fbd',
        88888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoFlex',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Flex font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Flex
  static TextTheme robotoFlexTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoFlex(textStyle: textTheme.displayLarge),
      displayMedium: robotoFlex(textStyle: textTheme.displayMedium),
      displaySmall: robotoFlex(textStyle: textTheme.displaySmall),
      headlineLarge: robotoFlex(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoFlex(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoFlex(textStyle: textTheme.headlineSmall),
      titleLarge: robotoFlex(textStyle: textTheme.titleLarge),
      titleMedium: robotoFlex(textStyle: textTheme.titleMedium),
      titleSmall: robotoFlex(textStyle: textTheme.titleSmall),
      bodyLarge: robotoFlex(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoFlex(textStyle: textTheme.bodyMedium),
      bodySmall: robotoFlex(textStyle: textTheme.bodySmall),
      labelLarge: robotoFlex(textStyle: textTheme.labelLarge),
      labelMedium: robotoFlex(textStyle: textTheme.labelMedium),
      labelSmall: robotoFlex(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Mono
  static TextStyle robotoMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c143970b9f2e250fcf4caf9cf62f6b3b47c62efe1e162ac256338db8d0f798c3',
        80016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93efc2bd39f8d8ee242082e7257b52e5d3a1186a8048a8d5501eba74b365a77c',
        79924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fe25b3d13b147927ceabb850b05d171758aa325f6941ca11448fd9b3fdd00774',
        79716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98e94e15e13718555a10299bb96017f6e50a69f47ff61899b1d9e1a86b5fac7f',
        78968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acdfbf353c42d04ec7e1e2cf8d5eb7709dee60939030102d07f8623e0ad72973',
        78944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '77a88f0807b9af22ca1caa4c3ab778f5c2513c60fde26c1701f80cb473262294',
        79188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10e89cd69daf71a7c64dbcc00f694dbbff3c234f4d4aaf12709e67f4d1b0e8d7',
        79132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '938b70df0e223daf3b21075cdf2863eef241074f020dbbad099f49cde2e6dd19',
        84948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8c19993c14f6cc7604b31efdcd983aa495c199c1e628aa3ca5561734c4b1697c',
        85276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f56f980d8bd43f21e09ba36ad248cc05f092484d5c2b02f23c3129fe5ba474b1',
        85596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '07884a6dc8021a2eef997774bf83e0c67f13985e3f61797ce0eaa38d672c9038',
        85676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '088f51f1cfd499a79da475a3d01f3b4f2f2649fa3f187556bde578bc88dddb32',
        85752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2427ed57d03c2d128127429ef4de10ba21826a6992de2bb7b096ed45387876f7',
        85752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4110df6eb9855f4b1b509dee1597dce8a7beb522ab4fc46cc317e88d76dc45d2',
        85932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Mono
  static TextTheme robotoMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoMono(textStyle: textTheme.displayLarge),
      displayMedium: robotoMono(textStyle: textTheme.displayMedium),
      displaySmall: robotoMono(textStyle: textTheme.displaySmall),
      headlineLarge: robotoMono(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoMono(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoMono(textStyle: textTheme.headlineSmall),
      titleLarge: robotoMono(textStyle: textTheme.titleLarge),
      titleMedium: robotoMono(textStyle: textTheme.titleMedium),
      titleSmall: robotoMono(textStyle: textTheme.titleSmall),
      bodyLarge: robotoMono(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoMono(textStyle: textTheme.bodyMedium),
      bodySmall: robotoMono(textStyle: textTheme.bodySmall),
      labelLarge: robotoMono(textStyle: textTheme.labelLarge),
      labelMedium: robotoMono(textStyle: textTheme.labelMedium),
      labelSmall: robotoMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Serif font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Serif
  static TextStyle robotoSerif({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e2e2cf3ffd3d81cbf08a033c97c8deb37be639d761e285beb4e7b45e6027b861',
        215352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97cd6e8fc29891932cb635632c959d60c91b8175a501bcb868d43dfe1cf75ae1',
        215584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4fa36908daa0094bdfb5caf5e1a90e36906ebcd0d477288bdf7c1f3a56a35ab',
        215600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '69021861aa51e4e568f4018fbeb92955b63c9333bc20e9d51a0e8a6e8b0e6eac',
        215648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a56c48dccc823c4268ca8ac1a84e29c11963759f6ffef7d0cdde9b81d9afa9b',
        216028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf6132ef1170917cd69c5c78a7e1e90687395c98c53f14584c3d72c2ad128430',
        216056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e6b9347e365c57ae79fee47b058a3fbf35af9796d92cc8d4793b0de4d3a0d450',
        216100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ead326923215959a53ba13206bf2536e1674fe82cab40f4d897f6f83d2d7f57',
        216192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '21c4ab92088db8b86a40f6b23f4c241d825cde6f6041216f1acf16cab263f345',
        216144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab610e6fa570a097e91e8e2ba3d7ebc960593a5c72c27ca84acacd75d6112fc4',
        220092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a623a13d833f9afd4497f3944ad4dbe34135b9edeb03544af3f25d7a968e59a',
        221052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c441d489398491c43e293fc4f3b6e8554b9a3906a4834377ca496bc701d2a029',
        221044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a9fcb5f638e1316794a3396ff440440609a77bc187848f6ba7763dd78626abbd',
        220952,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '622e1e61a788d30a752f69bf784764153236ee810b7f7af3afedadb6678d970e',
        221664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e35463558f701e8eef05c68cd9565d0ac15f030bc2a4db486ca1a656b683f1d1',
        221768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cacc545a15a73e6b4ee8981dcb95c6ce6d4d4e358c9f9946ca8f5b4534c78d11',
        221668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ec05008dd4c1c2d3ffa451c90a36610d76456d9ea5abdb0ab16d035dc4b8f877',
        221860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '97f7abff9df24acce90c57a399bbb39bcf542f55236da352b6ed2d0f934949fc',
        220208,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoSerif',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Serif font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Serif
  static TextTheme robotoSerifTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoSerif(textStyle: textTheme.displayLarge),
      displayMedium: robotoSerif(textStyle: textTheme.displayMedium),
      displaySmall: robotoSerif(textStyle: textTheme.displaySmall),
      headlineLarge: robotoSerif(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoSerif(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoSerif(textStyle: textTheme.headlineSmall),
      titleLarge: robotoSerif(textStyle: textTheme.titleLarge),
      titleMedium: robotoSerif(textStyle: textTheme.titleMedium),
      titleSmall: robotoSerif(textStyle: textTheme.titleSmall),
      bodyLarge: robotoSerif(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoSerif(textStyle: textTheme.bodyMedium),
      bodySmall: robotoSerif(textStyle: textTheme.bodySmall),
      labelLarge: robotoSerif(textStyle: textTheme.labelLarge),
      labelMedium: robotoSerif(textStyle: textTheme.labelMedium),
      labelSmall: robotoSerif(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Roboto Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Slab
  static TextStyle robotoSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66684ae4627e57b538a3f2ef991602395361dab2b134d8cd1ee80ded74b9c524',
        101128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0dcc77f4037c276b075b5cf7ba64b27b420e4f903963615a81af41b6b9b30d01',
        102152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d2efa99207f3314344f4b57c327c56bf4a0044d27e50eb4c7d482e681fd57e1',
        102136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84836899abf5c11c7cc937dec2f56eced0ca39f0c270b00da8f451a18dd0737e',
        101712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6add046171bb50d28cc4fed3d1a83913bb2fdd84e29d59e4e3212bc5f2075a60',
        102408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b69a580c8309467b4cc3049e6f9b5fe82ed23db97f68d48e9918ba4238fa73a5',
        102532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68b617f418fd8250d6d4968544b19ca75e4ea120002624d14c2ea7dcc3c46779',
        102380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4da815235d542bf399ab651967e29101a58af22391d37f2931c945e00f39eca7',
        102560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d1674b906f6528b9b901d35b77cc5606c466d754af95026c37292c01324984a',
        102620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RobotoSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Roboto Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Roboto+Slab
  static TextTheme robotoSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: robotoSlab(textStyle: textTheme.displayLarge),
      displayMedium: robotoSlab(textStyle: textTheme.displayMedium),
      displaySmall: robotoSlab(textStyle: textTheme.displaySmall),
      headlineLarge: robotoSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: robotoSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: robotoSlab(textStyle: textTheme.headlineSmall),
      titleLarge: robotoSlab(textStyle: textTheme.titleLarge),
      titleMedium: robotoSlab(textStyle: textTheme.titleMedium),
      titleSmall: robotoSlab(textStyle: textTheme.titleSmall),
      bodyLarge: robotoSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: robotoSlab(textStyle: textTheme.bodyMedium),
      bodySmall: robotoSlab(textStyle: textTheme.bodySmall),
      labelLarge: robotoSlab(textStyle: textTheme.labelLarge),
      labelMedium: robotoSlab(textStyle: textTheme.labelMedium),
      labelSmall: robotoSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rochester font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rochester
  static TextStyle rochester({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '809cdfa7b0c9ea45e05fdc97f3c6eae321187df5bdb3e31aacec8e2fe113cfc8',
        35504,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rochester',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rochester font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rochester
  static TextTheme rochesterTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rochester(textStyle: textTheme.displayLarge),
      displayMedium: rochester(textStyle: textTheme.displayMedium),
      displaySmall: rochester(textStyle: textTheme.displaySmall),
      headlineLarge: rochester(textStyle: textTheme.headlineLarge),
      headlineMedium: rochester(textStyle: textTheme.headlineMedium),
      headlineSmall: rochester(textStyle: textTheme.headlineSmall),
      titleLarge: rochester(textStyle: textTheme.titleLarge),
      titleMedium: rochester(textStyle: textTheme.titleMedium),
      titleSmall: rochester(textStyle: textTheme.titleSmall),
      bodyLarge: rochester(textStyle: textTheme.bodyLarge),
      bodyMedium: rochester(textStyle: textTheme.bodyMedium),
      bodySmall: rochester(textStyle: textTheme.bodySmall),
      labelLarge: rochester(textStyle: textTheme.labelLarge),
      labelMedium: rochester(textStyle: textTheme.labelMedium),
      labelSmall: rochester(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rock 3D font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+3D
  static TextStyle rock3d({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '257929ed9f965f1453c094a5a17977ff0a4c6330b00c29c890d256f80b67c24b',
        443884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rock3D',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rock 3D font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+3D
  static TextTheme rock3dTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rock3d(textStyle: textTheme.displayLarge),
      displayMedium: rock3d(textStyle: textTheme.displayMedium),
      displaySmall: rock3d(textStyle: textTheme.displaySmall),
      headlineLarge: rock3d(textStyle: textTheme.headlineLarge),
      headlineMedium: rock3d(textStyle: textTheme.headlineMedium),
      headlineSmall: rock3d(textStyle: textTheme.headlineSmall),
      titleLarge: rock3d(textStyle: textTheme.titleLarge),
      titleMedium: rock3d(textStyle: textTheme.titleMedium),
      titleSmall: rock3d(textStyle: textTheme.titleSmall),
      bodyLarge: rock3d(textStyle: textTheme.bodyLarge),
      bodyMedium: rock3d(textStyle: textTheme.bodyMedium),
      bodySmall: rock3d(textStyle: textTheme.bodySmall),
      labelLarge: rock3d(textStyle: textTheme.labelLarge),
      labelMedium: rock3d(textStyle: textTheme.labelMedium),
      labelSmall: rock3d(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rock Salt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+Salt
  static TextStyle rockSalt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e396fb1212e462672f50c76ad6efb72862fc49db710720edc57a273147151aaa',
        103688,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RockSalt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rock Salt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rock+Salt
  static TextTheme rockSaltTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rockSalt(textStyle: textTheme.displayLarge),
      displayMedium: rockSalt(textStyle: textTheme.displayMedium),
      displaySmall: rockSalt(textStyle: textTheme.displaySmall),
      headlineLarge: rockSalt(textStyle: textTheme.headlineLarge),
      headlineMedium: rockSalt(textStyle: textTheme.headlineMedium),
      headlineSmall: rockSalt(textStyle: textTheme.headlineSmall),
      titleLarge: rockSalt(textStyle: textTheme.titleLarge),
      titleMedium: rockSalt(textStyle: textTheme.titleMedium),
      titleSmall: rockSalt(textStyle: textTheme.titleSmall),
      bodyLarge: rockSalt(textStyle: textTheme.bodyLarge),
      bodyMedium: rockSalt(textStyle: textTheme.bodyMedium),
      bodySmall: rockSalt(textStyle: textTheme.bodySmall),
      labelLarge: rockSalt(textStyle: textTheme.labelLarge),
      labelMedium: rockSalt(textStyle: textTheme.labelMedium),
      labelSmall: rockSalt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the RocknRoll One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/RocknRoll+One
  static TextStyle rocknRollOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd6d20f137ba1f73bb182163bceb16b48b79d5e958ef38024d67224aca4ad780',
        2463552,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RocknRollOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the RocknRoll One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/RocknRoll+One
  static TextTheme rocknRollOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rocknRollOne(textStyle: textTheme.displayLarge),
      displayMedium: rocknRollOne(textStyle: textTheme.displayMedium),
      displaySmall: rocknRollOne(textStyle: textTheme.displaySmall),
      headlineLarge: rocknRollOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rocknRollOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rocknRollOne(textStyle: textTheme.headlineSmall),
      titleLarge: rocknRollOne(textStyle: textTheme.titleLarge),
      titleMedium: rocknRollOne(textStyle: textTheme.titleMedium),
      titleSmall: rocknRollOne(textStyle: textTheme.titleSmall),
      bodyLarge: rocknRollOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rocknRollOne(textStyle: textTheme.bodyMedium),
      bodySmall: rocknRollOne(textStyle: textTheme.bodySmall),
      labelLarge: rocknRollOne(textStyle: textTheme.labelLarge),
      labelMedium: rocknRollOne(textStyle: textTheme.labelMedium),
      labelSmall: rocknRollOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rokkitt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rokkitt
  static TextStyle rokkitt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a141804c9ba42ba3bacca29d245d1d5744a80d164722026b57765b68130e95d0',
        68480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '499fa815eb6692b21301706a6e2681ee16ce68681e0cd62747f92aa0b65d697b',
        68668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd63ee870e492d78c9d8ecf89e879cbfeba5f0d04e15e30d825273dc316dd6994',
        68704,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9b3871a1da9022fd88c178fb46309f344464e64dae030115950737830937e4ea',
        68644,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9cc3b5a89df1ef73e9453ce7461b66467bfa51c8340f6b03e5919e3295ed4aae',
        68620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed971d1478387568d94ecde369e2260a2c833fb45d49c4d51057a78a9888f34f',
        69124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'abf6f746a8c6d164b9e9b5fb3d342991fc0764bb1f173c222954dab21426c24f',
        69092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6dc7f2353cd254f7c3089702a61cec0b7dc1c02fc6fa57f9bc5d5fa7e9e538e1',
        69172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8da8d96b154b2857b323822a29b8a01065a93889d9bcb595d595206fa0bb60b3',
        68844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2f417e22d9fdf622d8cd12e2639c433e866949d23fba87fa6afedcda9114eb87',
        69812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3b38f5ceebd1cbdf256c759547454665625f10ee5ece4608f7fd9319bccb783e',
        70060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a7ec778d131e5ea97e013ea6d32a29546e216b3be30cbc86e8ab6919f2d6a836',
        70064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '04ada1396bba9789f6d068cdf3dc33b0f9a4a4cc1581495f6a4868c3ca2daf78',
        69884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c183c221f7b5148448b0ba65f7f3558f0477ade84fa0ed980ff1f52ec6f54ccb',
        69972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '24c2616e906ccca2f46ec87944e574f070bbffc619734dfc8b4277e03ddbc1d6',
        70240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8426e9f8aeae1e595c3dc8377d4780be32babaddffe80cb6547eb5e507284f4c',
        70160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4eea94355a617e3e26758b77d3457db345bc29557d0b61ba598cf9d1f601ebc5',
        70260,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f4ef17d7b0f58e8f17352058edf7446d2f76f2ed8c64cde3924945dd92200901',
        70096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rokkitt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rokkitt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rokkitt
  static TextTheme rokkittTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rokkitt(textStyle: textTheme.displayLarge),
      displayMedium: rokkitt(textStyle: textTheme.displayMedium),
      displaySmall: rokkitt(textStyle: textTheme.displaySmall),
      headlineLarge: rokkitt(textStyle: textTheme.headlineLarge),
      headlineMedium: rokkitt(textStyle: textTheme.headlineMedium),
      headlineSmall: rokkitt(textStyle: textTheme.headlineSmall),
      titleLarge: rokkitt(textStyle: textTheme.titleLarge),
      titleMedium: rokkitt(textStyle: textTheme.titleMedium),
      titleSmall: rokkitt(textStyle: textTheme.titleSmall),
      bodyLarge: rokkitt(textStyle: textTheme.bodyLarge),
      bodyMedium: rokkitt(textStyle: textTheme.bodyMedium),
      bodySmall: rokkitt(textStyle: textTheme.bodySmall),
      labelLarge: rokkitt(textStyle: textTheme.labelLarge),
      labelMedium: rokkitt(textStyle: textTheme.labelMedium),
      labelSmall: rokkitt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Romanesco font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Romanesco
  static TextStyle romanesco({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '51cf475bd5f0d3bca83e619f8d8b0a01713278046bc338656b09a991d21d85e5',
        49464,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Romanesco',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Romanesco font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Romanesco
  static TextTheme romanescoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: romanesco(textStyle: textTheme.displayLarge),
      displayMedium: romanesco(textStyle: textTheme.displayMedium),
      displaySmall: romanesco(textStyle: textTheme.displaySmall),
      headlineLarge: romanesco(textStyle: textTheme.headlineLarge),
      headlineMedium: romanesco(textStyle: textTheme.headlineMedium),
      headlineSmall: romanesco(textStyle: textTheme.headlineSmall),
      titleLarge: romanesco(textStyle: textTheme.titleLarge),
      titleMedium: romanesco(textStyle: textTheme.titleMedium),
      titleSmall: romanesco(textStyle: textTheme.titleSmall),
      bodyLarge: romanesco(textStyle: textTheme.bodyLarge),
      bodyMedium: romanesco(textStyle: textTheme.bodyMedium),
      bodySmall: romanesco(textStyle: textTheme.bodySmall),
      labelLarge: romanesco(textStyle: textTheme.labelLarge),
      labelMedium: romanesco(textStyle: textTheme.labelMedium),
      labelSmall: romanesco(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ropa Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ropa+Sans
  static TextStyle ropaSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7447bcf763f63367b00ad78056e47d4e249957010495be3af2c6b441d216f119',
        36216,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f20e8ccf3c3940aa615a0e83d84e9fb8fa82ac6ab399be628da543281d61725b',
        39000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RopaSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ropa Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ropa+Sans
  static TextTheme ropaSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ropaSans(textStyle: textTheme.displayLarge),
      displayMedium: ropaSans(textStyle: textTheme.displayMedium),
      displaySmall: ropaSans(textStyle: textTheme.displaySmall),
      headlineLarge: ropaSans(textStyle: textTheme.headlineLarge),
      headlineMedium: ropaSans(textStyle: textTheme.headlineMedium),
      headlineSmall: ropaSans(textStyle: textTheme.headlineSmall),
      titleLarge: ropaSans(textStyle: textTheme.titleLarge),
      titleMedium: ropaSans(textStyle: textTheme.titleMedium),
      titleSmall: ropaSans(textStyle: textTheme.titleSmall),
      bodyLarge: ropaSans(textStyle: textTheme.bodyLarge),
      bodyMedium: ropaSans(textStyle: textTheme.bodyMedium),
      bodySmall: ropaSans(textStyle: textTheme.bodySmall),
      labelLarge: ropaSans(textStyle: textTheme.labelLarge),
      labelMedium: ropaSans(textStyle: textTheme.labelMedium),
      labelSmall: ropaSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rosario font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosario
  static TextStyle rosario({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2bfb456f16e63ed0f5f6ee1f3d0f7bb5daa07805e506fa3c09ceb46a2f4e4fbd',
        72908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55beb6c3ffe2617b27bc64f13a919f30d4cca04294d29a7b3e474708aa016623',
        73144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9bebee7de2ae7c9d3da09acd2d39f851343b0cf211c063cd3a35eceb20f51ed',
        73228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cfe0469ab4d7c9308be727a2e18e44e8f0fd93a371088c47406eba02c659900',
        73152,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '489162b219a48715c2845edac6e0393959d5ed5f99ca87cb3187e0c10a39b797',
        70964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4acc1b268c60ccbf26e080573556752cd903bd4dfb622f198fdd65c068a046d6',
        71472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c851d42c43231c83e4d879332fbd55d9f39f962a189754e14451a3246b9c9001',
        71336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ebcf9ad33497c7843f37d1213aeea31195cb6dc4c189f630f7550bc797e8f9e3',
        71508,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82a5ff33aecbdc48e6d905cae10510ee93cc453905095daee50ee2c6495b9632',
        71556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3ca97411b8cf5bddb170e9fd43a23b5783a00657fab65df5e4a3588df683a52c',
        71160,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rosario',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rosario font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosario
  static TextTheme rosarioTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rosario(textStyle: textTheme.displayLarge),
      displayMedium: rosario(textStyle: textTheme.displayMedium),
      displaySmall: rosario(textStyle: textTheme.displaySmall),
      headlineLarge: rosario(textStyle: textTheme.headlineLarge),
      headlineMedium: rosario(textStyle: textTheme.headlineMedium),
      headlineSmall: rosario(textStyle: textTheme.headlineSmall),
      titleLarge: rosario(textStyle: textTheme.titleLarge),
      titleMedium: rosario(textStyle: textTheme.titleMedium),
      titleSmall: rosario(textStyle: textTheme.titleSmall),
      bodyLarge: rosario(textStyle: textTheme.bodyLarge),
      bodyMedium: rosario(textStyle: textTheme.bodyMedium),
      bodySmall: rosario(textStyle: textTheme.bodySmall),
      labelLarge: rosario(textStyle: textTheme.labelLarge),
      labelMedium: rosario(textStyle: textTheme.labelMedium),
      labelSmall: rosario(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rosarivo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosarivo
  static TextStyle rosarivo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a6dc1d7c2af32069889e6508773856318819c5e30b77cb4170fc4473aa0a7828',
        39448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45d9f8625f2f385eb227a40b5a24007951e8401774a6d9b990ef24502412e60a',
        37444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rosarivo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rosarivo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rosarivo
  static TextTheme rosarivoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rosarivo(textStyle: textTheme.displayLarge),
      displayMedium: rosarivo(textStyle: textTheme.displayMedium),
      displaySmall: rosarivo(textStyle: textTheme.displaySmall),
      headlineLarge: rosarivo(textStyle: textTheme.headlineLarge),
      headlineMedium: rosarivo(textStyle: textTheme.headlineMedium),
      headlineSmall: rosarivo(textStyle: textTheme.headlineSmall),
      titleLarge: rosarivo(textStyle: textTheme.titleLarge),
      titleMedium: rosarivo(textStyle: textTheme.titleMedium),
      titleSmall: rosarivo(textStyle: textTheme.titleSmall),
      bodyLarge: rosarivo(textStyle: textTheme.bodyLarge),
      bodyMedium: rosarivo(textStyle: textTheme.bodyMedium),
      bodySmall: rosarivo(textStyle: textTheme.bodySmall),
      labelLarge: rosarivo(textStyle: textTheme.labelLarge),
      labelMedium: rosarivo(textStyle: textTheme.labelMedium),
      labelSmall: rosarivo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rouge Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rouge+Script
  static TextStyle rougeScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ca8ace28ef95357bf51311d130cb35ba6aacf16846f657d7e5a53424714eccdd',
        45028,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RougeScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rouge Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rouge+Script
  static TextTheme rougeScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rougeScript(textStyle: textTheme.displayLarge),
      displayMedium: rougeScript(textStyle: textTheme.displayMedium),
      displaySmall: rougeScript(textStyle: textTheme.displaySmall),
      headlineLarge: rougeScript(textStyle: textTheme.headlineLarge),
      headlineMedium: rougeScript(textStyle: textTheme.headlineMedium),
      headlineSmall: rougeScript(textStyle: textTheme.headlineSmall),
      titleLarge: rougeScript(textStyle: textTheme.titleLarge),
      titleMedium: rougeScript(textStyle: textTheme.titleMedium),
      titleSmall: rougeScript(textStyle: textTheme.titleSmall),
      bodyLarge: rougeScript(textStyle: textTheme.bodyLarge),
      bodyMedium: rougeScript(textStyle: textTheme.bodyMedium),
      bodySmall: rougeScript(textStyle: textTheme.bodySmall),
      labelLarge: rougeScript(textStyle: textTheme.labelLarge),
      labelMedium: rougeScript(textStyle: textTheme.labelMedium),
      labelSmall: rougeScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rowdies font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rowdies
  static TextStyle rowdies({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '94e80a79987dc227d8e37111629725d1631d5c29df43fc61a7bf1bf3ef618710',
        50672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82cb14b5f4880f3fc710bf7bec932930d482ecd38736eba5c6c76b5179a6a129',
        50388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cfb7468910a71cefbb498fe38fa3bb548aef73c2881fdbc6577ffbc46f2997bc',
        50324,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rowdies',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rowdies font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rowdies
  static TextTheme rowdiesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rowdies(textStyle: textTheme.displayLarge),
      displayMedium: rowdies(textStyle: textTheme.displayMedium),
      displaySmall: rowdies(textStyle: textTheme.displaySmall),
      headlineLarge: rowdies(textStyle: textTheme.headlineLarge),
      headlineMedium: rowdies(textStyle: textTheme.headlineMedium),
      headlineSmall: rowdies(textStyle: textTheme.headlineSmall),
      titleLarge: rowdies(textStyle: textTheme.titleLarge),
      titleMedium: rowdies(textStyle: textTheme.titleMedium),
      titleSmall: rowdies(textStyle: textTheme.titleSmall),
      bodyLarge: rowdies(textStyle: textTheme.bodyLarge),
      bodyMedium: rowdies(textStyle: textTheme.bodyMedium),
      bodySmall: rowdies(textStyle: textTheme.bodySmall),
      labelLarge: rowdies(textStyle: textTheme.labelLarge),
      labelMedium: rowdies(textStyle: textTheme.labelMedium),
      labelSmall: rowdies(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rozha One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rozha+One
  static TextStyle rozhaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8b564a2294dd0a0864362778ed014526075e307adbec370e860ff6ef7baa846',
        187760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RozhaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rozha One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rozha+One
  static TextTheme rozhaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rozhaOne(textStyle: textTheme.displayLarge),
      displayMedium: rozhaOne(textStyle: textTheme.displayMedium),
      displaySmall: rozhaOne(textStyle: textTheme.displaySmall),
      headlineLarge: rozhaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rozhaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rozhaOne(textStyle: textTheme.headlineSmall),
      titleLarge: rozhaOne(textStyle: textTheme.titleLarge),
      titleMedium: rozhaOne(textStyle: textTheme.titleMedium),
      titleSmall: rozhaOne(textStyle: textTheme.titleSmall),
      bodyLarge: rozhaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rozhaOne(textStyle: textTheme.bodyMedium),
      bodySmall: rozhaOne(textStyle: textTheme.bodySmall),
      labelLarge: rozhaOne(textStyle: textTheme.labelLarge),
      labelMedium: rozhaOne(textStyle: textTheme.labelMedium),
      labelSmall: rozhaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik
  static TextStyle rubik({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82d91bde3707f47d5a45bd3363bf22d57699bb0dfd0caeeb1579b56b26f42ea7',
        174128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '588e33f0e1e07d1853b33b2a610ba613a4d096edfe06e45f31a785ce315d9234',
        174968,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f341ec62d7f8662cb57c4d637699f8bd012b4d692be97112640d003eb4c6063',
        175572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '513fd3927d7b4ed8b65d75159743aa77d93c9a14777848d99da607defe2913df',
        175576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9e02f783fd3c8e13818d1c3f276c7108a2feb35ee086b478092833f5ccafb5bb',
        175604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1aca64f1e87e2319783c7572ac8664212508aa65404b31a7cb051d534e67b636',
        175500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80e707a3a8d26d7ae3d4e0560c25089e7385066132a34d638cc9b77e35ae690b',
        175172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ab4e304a7169529c6348d55fa50234807144dfbdc96ed3cba179f597a35b5412',
        172544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd8ef973f3fb7d491e801cf05d9adb9a468bbacc19173b03e19463958d413a775',
        173124,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7413b40f011cd947609a6e0764a8a09ba4dd20c5470862909e14a93281698c1a',
        173868,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd363acbc92f7b0c997b01208ac3fbfcd80934494f3474fef4ed6c7c35700fb2d',
        173996,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '168be2ed8556f674539dcd4326501538d5de3fb49a24190520f3da5f7a8dd202',
        173944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8fbf087b7c73f65c884eae9330e52900e5ded3dd8eb306242ea8e05e9af83de',
        174084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6e91e39e0cd5a223a73d447cf2d34a74018c586568d85816d7afbfddc4e5c562',
        173740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rubik',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik
  static TextTheme rubikTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubik(textStyle: textTheme.displayLarge),
      displayMedium: rubik(textStyle: textTheme.displayMedium),
      displaySmall: rubik(textStyle: textTheme.displaySmall),
      headlineLarge: rubik(textStyle: textTheme.headlineLarge),
      headlineMedium: rubik(textStyle: textTheme.headlineMedium),
      headlineSmall: rubik(textStyle: textTheme.headlineSmall),
      titleLarge: rubik(textStyle: textTheme.titleLarge),
      titleMedium: rubik(textStyle: textTheme.titleMedium),
      titleSmall: rubik(textStyle: textTheme.titleSmall),
      bodyLarge: rubik(textStyle: textTheme.bodyLarge),
      bodyMedium: rubik(textStyle: textTheme.bodyMedium),
      bodySmall: rubik(textStyle: textTheme.bodySmall),
      labelLarge: rubik(textStyle: textTheme.labelLarge),
      labelMedium: rubik(textStyle: textTheme.labelMedium),
      labelSmall: rubik(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik 80s Fade font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+80s+Fade
  static TextStyle rubik80sFade({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bfc4a936e506f6df6ef9463fe886f610c6ee30cf359672df886a139c82215d56',
        3300676,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rubik80sFade',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik 80s Fade font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+80s+Fade
  static TextTheme rubik80sFadeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubik80sFade(textStyle: textTheme.displayLarge),
      displayMedium: rubik80sFade(textStyle: textTheme.displayMedium),
      displaySmall: rubik80sFade(textStyle: textTheme.displaySmall),
      headlineLarge: rubik80sFade(textStyle: textTheme.headlineLarge),
      headlineMedium: rubik80sFade(textStyle: textTheme.headlineMedium),
      headlineSmall: rubik80sFade(textStyle: textTheme.headlineSmall),
      titleLarge: rubik80sFade(textStyle: textTheme.titleLarge),
      titleMedium: rubik80sFade(textStyle: textTheme.titleMedium),
      titleSmall: rubik80sFade(textStyle: textTheme.titleSmall),
      bodyLarge: rubik80sFade(textStyle: textTheme.bodyLarge),
      bodyMedium: rubik80sFade(textStyle: textTheme.bodyMedium),
      bodySmall: rubik80sFade(textStyle: textTheme.bodySmall),
      labelLarge: rubik80sFade(textStyle: textTheme.labelLarge),
      labelMedium: rubik80sFade(textStyle: textTheme.labelMedium),
      labelSmall: rubik80sFade(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Beastly font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Beastly
  static TextStyle rubikBeastly({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a72ae3f6cf91fe781a049aaa8a201fbf5e073a297b34776cbc3d3c210692b886',
        486848,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBeastly',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Beastly font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Beastly
  static TextTheme rubikBeastlyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBeastly(textStyle: textTheme.displayLarge),
      displayMedium: rubikBeastly(textStyle: textTheme.displayMedium),
      displaySmall: rubikBeastly(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBeastly(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBeastly(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBeastly(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBeastly(textStyle: textTheme.titleLarge),
      titleMedium: rubikBeastly(textStyle: textTheme.titleMedium),
      titleSmall: rubikBeastly(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBeastly(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBeastly(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBeastly(textStyle: textTheme.bodySmall),
      labelLarge: rubikBeastly(textStyle: textTheme.labelLarge),
      labelMedium: rubikBeastly(textStyle: textTheme.labelMedium),
      labelSmall: rubikBeastly(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Broken Fax font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Broken+Fax
  static TextStyle rubikBrokenFax({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0bdf2e35c6593662d2173f7d5eb98bf15b44bb32c8806011958f4c04a139048b',
        471264,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBrokenFax',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Broken Fax font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Broken+Fax
  static TextTheme rubikBrokenFaxTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBrokenFax(textStyle: textTheme.displayLarge),
      displayMedium: rubikBrokenFax(textStyle: textTheme.displayMedium),
      displaySmall: rubikBrokenFax(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBrokenFax(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBrokenFax(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBrokenFax(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBrokenFax(textStyle: textTheme.titleLarge),
      titleMedium: rubikBrokenFax(textStyle: textTheme.titleMedium),
      titleSmall: rubikBrokenFax(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBrokenFax(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBrokenFax(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBrokenFax(textStyle: textTheme.bodySmall),
      labelLarge: rubikBrokenFax(textStyle: textTheme.labelLarge),
      labelMedium: rubikBrokenFax(textStyle: textTheme.labelMedium),
      labelSmall: rubikBrokenFax(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Bubbles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Bubbles
  static TextStyle rubikBubbles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '141da16469353130fd351e7733bf9eac9ccff14273f519bb744143fbca48400f',
        207396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBubbles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Bubbles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Bubbles
  static TextTheme rubikBubblesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBubbles(textStyle: textTheme.displayLarge),
      displayMedium: rubikBubbles(textStyle: textTheme.displayMedium),
      displaySmall: rubikBubbles(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBubbles(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBubbles(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBubbles(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBubbles(textStyle: textTheme.titleLarge),
      titleMedium: rubikBubbles(textStyle: textTheme.titleMedium),
      titleSmall: rubikBubbles(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBubbles(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBubbles(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBubbles(textStyle: textTheme.bodySmall),
      labelLarge: rubikBubbles(textStyle: textTheme.labelLarge),
      labelMedium: rubikBubbles(textStyle: textTheme.labelMedium),
      labelSmall: rubikBubbles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Burned font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Burned
  static TextStyle rubikBurned({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33d672af860a647803b8bc3f8ebd52e5e6e46b52d6a44df0811ed693ea34dc54',
        574084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikBurned',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Burned font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Burned
  static TextTheme rubikBurnedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikBurned(textStyle: textTheme.displayLarge),
      displayMedium: rubikBurned(textStyle: textTheme.displayMedium),
      displaySmall: rubikBurned(textStyle: textTheme.displaySmall),
      headlineLarge: rubikBurned(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikBurned(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikBurned(textStyle: textTheme.headlineSmall),
      titleLarge: rubikBurned(textStyle: textTheme.titleLarge),
      titleMedium: rubikBurned(textStyle: textTheme.titleMedium),
      titleSmall: rubikBurned(textStyle: textTheme.titleSmall),
      bodyLarge: rubikBurned(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikBurned(textStyle: textTheme.bodyMedium),
      bodySmall: rubikBurned(textStyle: textTheme.bodySmall),
      labelLarge: rubikBurned(textStyle: textTheme.labelLarge),
      labelMedium: rubikBurned(textStyle: textTheme.labelMedium),
      labelSmall: rubikBurned(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Dirt font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Dirt
  static TextStyle rubikDirt({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14b8e518b32bf5856d1813e0b5bd6f8eceab9b942cc3c1de9cac773901c44b27',
        1429136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDirt',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Dirt font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Dirt
  static TextTheme rubikDirtTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDirt(textStyle: textTheme.displayLarge),
      displayMedium: rubikDirt(textStyle: textTheme.displayMedium),
      displaySmall: rubikDirt(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDirt(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDirt(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDirt(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDirt(textStyle: textTheme.titleLarge),
      titleMedium: rubikDirt(textStyle: textTheme.titleMedium),
      titleSmall: rubikDirt(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDirt(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDirt(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDirt(textStyle: textTheme.bodySmall),
      labelLarge: rubikDirt(textStyle: textTheme.labelLarge),
      labelMedium: rubikDirt(textStyle: textTheme.labelMedium),
      labelSmall: rubikDirt(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Distressed font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Distressed
  static TextStyle rubikDistressed({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '281b14e112a7b7f9a304e10b3b18f0c823a6848327d96b41a37d2baf17fc31cc',
        851792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDistressed',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Distressed font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Distressed
  static TextTheme rubikDistressedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDistressed(textStyle: textTheme.displayLarge),
      displayMedium: rubikDistressed(textStyle: textTheme.displayMedium),
      displaySmall: rubikDistressed(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDistressed(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDistressed(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDistressed(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDistressed(textStyle: textTheme.titleLarge),
      titleMedium: rubikDistressed(textStyle: textTheme.titleMedium),
      titleSmall: rubikDistressed(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDistressed(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDistressed(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDistressed(textStyle: textTheme.bodySmall),
      labelLarge: rubikDistressed(textStyle: textTheme.labelLarge),
      labelMedium: rubikDistressed(textStyle: textTheme.labelMedium),
      labelSmall: rubikDistressed(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Doodle Shadow font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Doodle+Shadow
  static TextStyle rubikDoodleShadow({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fb09d3e59213ab258d375366345b835280d394f4760f0d08633f63f7e638e07c',
        1291876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDoodleShadow',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Doodle Shadow font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Doodle+Shadow
  static TextTheme rubikDoodleShadowTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDoodleShadow(textStyle: textTheme.displayLarge),
      displayMedium: rubikDoodleShadow(textStyle: textTheme.displayMedium),
      displaySmall: rubikDoodleShadow(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDoodleShadow(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDoodleShadow(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDoodleShadow(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDoodleShadow(textStyle: textTheme.titleLarge),
      titleMedium: rubikDoodleShadow(textStyle: textTheme.titleMedium),
      titleSmall: rubikDoodleShadow(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDoodleShadow(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDoodleShadow(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDoodleShadow(textStyle: textTheme.bodySmall),
      labelLarge: rubikDoodleShadow(textStyle: textTheme.labelLarge),
      labelMedium: rubikDoodleShadow(textStyle: textTheme.labelMedium),
      labelSmall: rubikDoodleShadow(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Doodle Triangles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Doodle+Triangles
  static TextStyle rubikDoodleTriangles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25737c62666acc865b4be4f450096ca82464d17ad8c10039226eb47119ef8ab3',
        1303484,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikDoodleTriangles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Doodle Triangles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Doodle+Triangles
  static TextTheme rubikDoodleTrianglesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikDoodleTriangles(textStyle: textTheme.displayLarge),
      displayMedium: rubikDoodleTriangles(textStyle: textTheme.displayMedium),
      displaySmall: rubikDoodleTriangles(textStyle: textTheme.displaySmall),
      headlineLarge: rubikDoodleTriangles(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikDoodleTriangles(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikDoodleTriangles(textStyle: textTheme.headlineSmall),
      titleLarge: rubikDoodleTriangles(textStyle: textTheme.titleLarge),
      titleMedium: rubikDoodleTriangles(textStyle: textTheme.titleMedium),
      titleSmall: rubikDoodleTriangles(textStyle: textTheme.titleSmall),
      bodyLarge: rubikDoodleTriangles(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikDoodleTriangles(textStyle: textTheme.bodyMedium),
      bodySmall: rubikDoodleTriangles(textStyle: textTheme.bodySmall),
      labelLarge: rubikDoodleTriangles(textStyle: textTheme.labelLarge),
      labelMedium: rubikDoodleTriangles(textStyle: textTheme.labelMedium),
      labelSmall: rubikDoodleTriangles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Gemstones font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Gemstones
  static TextStyle rubikGemstones({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd122d18f80622014ad72d93271fe4e9842bfd5026b83014194fe4751657b7c7',
        250204,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikGemstones',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Gemstones font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Gemstones
  static TextTheme rubikGemstonesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikGemstones(textStyle: textTheme.displayLarge),
      displayMedium: rubikGemstones(textStyle: textTheme.displayMedium),
      displaySmall: rubikGemstones(textStyle: textTheme.displaySmall),
      headlineLarge: rubikGemstones(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikGemstones(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikGemstones(textStyle: textTheme.headlineSmall),
      titleLarge: rubikGemstones(textStyle: textTheme.titleLarge),
      titleMedium: rubikGemstones(textStyle: textTheme.titleMedium),
      titleSmall: rubikGemstones(textStyle: textTheme.titleSmall),
      bodyLarge: rubikGemstones(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikGemstones(textStyle: textTheme.bodyMedium),
      bodySmall: rubikGemstones(textStyle: textTheme.bodySmall),
      labelLarge: rubikGemstones(textStyle: textTheme.labelLarge),
      labelMedium: rubikGemstones(textStyle: textTheme.labelMedium),
      labelSmall: rubikGemstones(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Glitch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch
  static TextStyle rubikGlitch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f37e1d94da8a99f0c8789fd8a6183fa6de6bdfcbc171d094ffd25aedb614be73',
        384280,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikGlitch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Glitch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch
  static TextTheme rubikGlitchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikGlitch(textStyle: textTheme.displayLarge),
      displayMedium: rubikGlitch(textStyle: textTheme.displayMedium),
      displaySmall: rubikGlitch(textStyle: textTheme.displaySmall),
      headlineLarge: rubikGlitch(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikGlitch(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikGlitch(textStyle: textTheme.headlineSmall),
      titleLarge: rubikGlitch(textStyle: textTheme.titleLarge),
      titleMedium: rubikGlitch(textStyle: textTheme.titleMedium),
      titleSmall: rubikGlitch(textStyle: textTheme.titleSmall),
      bodyLarge: rubikGlitch(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikGlitch(textStyle: textTheme.bodyMedium),
      bodySmall: rubikGlitch(textStyle: textTheme.bodySmall),
      labelLarge: rubikGlitch(textStyle: textTheme.labelLarge),
      labelMedium: rubikGlitch(textStyle: textTheme.labelMedium),
      labelSmall: rubikGlitch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Glitch Pop font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch+Pop
  static TextStyle rubikGlitchPop({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5a69ee9d13e70e0d333c0bba7a999d2c508d35398b389878d962555d8adbaa5',
        1878116,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikGlitchPop',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Glitch Pop font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Glitch+Pop
  static TextTheme rubikGlitchPopTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikGlitchPop(textStyle: textTheme.displayLarge),
      displayMedium: rubikGlitchPop(textStyle: textTheme.displayMedium),
      displaySmall: rubikGlitchPop(textStyle: textTheme.displaySmall),
      headlineLarge: rubikGlitchPop(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikGlitchPop(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikGlitchPop(textStyle: textTheme.headlineSmall),
      titleLarge: rubikGlitchPop(textStyle: textTheme.titleLarge),
      titleMedium: rubikGlitchPop(textStyle: textTheme.titleMedium),
      titleSmall: rubikGlitchPop(textStyle: textTheme.titleSmall),
      bodyLarge: rubikGlitchPop(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikGlitchPop(textStyle: textTheme.bodyMedium),
      bodySmall: rubikGlitchPop(textStyle: textTheme.bodySmall),
      labelLarge: rubikGlitchPop(textStyle: textTheme.labelLarge),
      labelMedium: rubikGlitchPop(textStyle: textTheme.labelMedium),
      labelSmall: rubikGlitchPop(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Iso font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Iso
  static TextStyle rubikIso({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cfb5518ff076bcf860a3ed14421b4a7ba5e794cd9ca305c550135316057583a',
        124120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikIso',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Iso font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Iso
  static TextTheme rubikIsoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikIso(textStyle: textTheme.displayLarge),
      displayMedium: rubikIso(textStyle: textTheme.displayMedium),
      displaySmall: rubikIso(textStyle: textTheme.displaySmall),
      headlineLarge: rubikIso(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikIso(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikIso(textStyle: textTheme.headlineSmall),
      titleLarge: rubikIso(textStyle: textTheme.titleLarge),
      titleMedium: rubikIso(textStyle: textTheme.titleMedium),
      titleSmall: rubikIso(textStyle: textTheme.titleSmall),
      bodyLarge: rubikIso(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikIso(textStyle: textTheme.bodyMedium),
      bodySmall: rubikIso(textStyle: textTheme.bodySmall),
      labelLarge: rubikIso(textStyle: textTheme.labelLarge),
      labelMedium: rubikIso(textStyle: textTheme.labelMedium),
      labelSmall: rubikIso(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Lines font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Lines
  static TextStyle rubikLines({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef74fe97733237825d3655b7f15e06216fe8fe2e89750f37817d2da477f38479',
        1259124,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikLines',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Lines font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Lines
  static TextTheme rubikLinesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikLines(textStyle: textTheme.displayLarge),
      displayMedium: rubikLines(textStyle: textTheme.displayMedium),
      displaySmall: rubikLines(textStyle: textTheme.displaySmall),
      headlineLarge: rubikLines(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikLines(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikLines(textStyle: textTheme.headlineSmall),
      titleLarge: rubikLines(textStyle: textTheme.titleLarge),
      titleMedium: rubikLines(textStyle: textTheme.titleMedium),
      titleSmall: rubikLines(textStyle: textTheme.titleSmall),
      bodyLarge: rubikLines(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikLines(textStyle: textTheme.bodyMedium),
      bodySmall: rubikLines(textStyle: textTheme.bodySmall),
      labelLarge: rubikLines(textStyle: textTheme.labelLarge),
      labelMedium: rubikLines(textStyle: textTheme.labelMedium),
      labelSmall: rubikLines(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Maps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maps
  static TextStyle rubikMaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'adccc07743a8d622c58c5e571f05ab60f87cc01d620f516b43aa99ce18748379',
        2171380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Maps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maps
  static TextTheme rubikMapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMaps(textStyle: textTheme.displayLarge),
      displayMedium: rubikMaps(textStyle: textTheme.displayMedium),
      displaySmall: rubikMaps(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMaps(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMaps(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMaps(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMaps(textStyle: textTheme.titleLarge),
      titleMedium: rubikMaps(textStyle: textTheme.titleMedium),
      titleSmall: rubikMaps(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMaps(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMaps(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMaps(textStyle: textTheme.bodySmall),
      labelLarge: rubikMaps(textStyle: textTheme.labelLarge),
      labelMedium: rubikMaps(textStyle: textTheme.labelMedium),
      labelSmall: rubikMaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Marker Hatch font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Marker+Hatch
  static TextStyle rubikMarkerHatch({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9f0e19305760e393ee283a6fbb507f336119a6b1b9e281bd65a4be0112f5129',
        344528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMarkerHatch',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Marker Hatch font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Marker+Hatch
  static TextTheme rubikMarkerHatchTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMarkerHatch(textStyle: textTheme.displayLarge),
      displayMedium: rubikMarkerHatch(textStyle: textTheme.displayMedium),
      displaySmall: rubikMarkerHatch(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMarkerHatch(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMarkerHatch(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMarkerHatch(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMarkerHatch(textStyle: textTheme.titleLarge),
      titleMedium: rubikMarkerHatch(textStyle: textTheme.titleMedium),
      titleSmall: rubikMarkerHatch(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMarkerHatch(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMarkerHatch(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMarkerHatch(textStyle: textTheme.bodySmall),
      labelLarge: rubikMarkerHatch(textStyle: textTheme.labelLarge),
      labelMedium: rubikMarkerHatch(textStyle: textTheme.labelMedium),
      labelSmall: rubikMarkerHatch(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Maze font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maze
  static TextStyle rubikMaze({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c1d40420fdece1420472a7821524b3bd3cb316b21d7c129b927e00dc1e86cc0',
        437212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMaze',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Maze font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Maze
  static TextTheme rubikMazeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMaze(textStyle: textTheme.displayLarge),
      displayMedium: rubikMaze(textStyle: textTheme.displayMedium),
      displaySmall: rubikMaze(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMaze(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMaze(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMaze(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMaze(textStyle: textTheme.titleLarge),
      titleMedium: rubikMaze(textStyle: textTheme.titleMedium),
      titleSmall: rubikMaze(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMaze(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMaze(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMaze(textStyle: textTheme.bodySmall),
      labelLarge: rubikMaze(textStyle: textTheme.labelLarge),
      labelMedium: rubikMaze(textStyle: textTheme.labelMedium),
      labelSmall: rubikMaze(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Microbe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Microbe
  static TextStyle rubikMicrobe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '96fccd0700788940f07716f384a505025a90b9d91e1e8d1e610887b459d47a04',
        1379152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMicrobe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Microbe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Microbe
  static TextTheme rubikMicrobeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMicrobe(textStyle: textTheme.displayLarge),
      displayMedium: rubikMicrobe(textStyle: textTheme.displayMedium),
      displaySmall: rubikMicrobe(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMicrobe(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMicrobe(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMicrobe(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMicrobe(textStyle: textTheme.titleLarge),
      titleMedium: rubikMicrobe(textStyle: textTheme.titleMedium),
      titleSmall: rubikMicrobe(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMicrobe(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMicrobe(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMicrobe(textStyle: textTheme.bodySmall),
      labelLarge: rubikMicrobe(textStyle: textTheme.labelLarge),
      labelMedium: rubikMicrobe(textStyle: textTheme.labelMedium),
      labelSmall: rubikMicrobe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Mono One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Mono+One
  static TextStyle rubikMonoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3bfd8e7a9f4144c65fe25715c8afe67596fc3c2b58e5544c9662702d988df8c0',
        73488,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMonoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Mono One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Mono+One
  static TextTheme rubikMonoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMonoOne(textStyle: textTheme.displayLarge),
      displayMedium: rubikMonoOne(textStyle: textTheme.displayMedium),
      displaySmall: rubikMonoOne(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMonoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMonoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMonoOne(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMonoOne(textStyle: textTheme.titleLarge),
      titleMedium: rubikMonoOne(textStyle: textTheme.titleMedium),
      titleSmall: rubikMonoOne(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMonoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMonoOne(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMonoOne(textStyle: textTheme.bodySmall),
      labelLarge: rubikMonoOne(textStyle: textTheme.labelLarge),
      labelMedium: rubikMonoOne(textStyle: textTheme.labelMedium),
      labelSmall: rubikMonoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Moonrocks font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Moonrocks
  static TextStyle rubikMoonrocks({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '46ce2bf69dfb5a43e2242fbfddd3e1690e59c9ca169e3bb4dcd1d231a58e055f',
        382604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikMoonrocks',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Moonrocks font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Moonrocks
  static TextTheme rubikMoonrocksTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikMoonrocks(textStyle: textTheme.displayLarge),
      displayMedium: rubikMoonrocks(textStyle: textTheme.displayMedium),
      displaySmall: rubikMoonrocks(textStyle: textTheme.displaySmall),
      headlineLarge: rubikMoonrocks(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikMoonrocks(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikMoonrocks(textStyle: textTheme.headlineSmall),
      titleLarge: rubikMoonrocks(textStyle: textTheme.titleLarge),
      titleMedium: rubikMoonrocks(textStyle: textTheme.titleMedium),
      titleSmall: rubikMoonrocks(textStyle: textTheme.titleSmall),
      bodyLarge: rubikMoonrocks(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikMoonrocks(textStyle: textTheme.bodyMedium),
      bodySmall: rubikMoonrocks(textStyle: textTheme.bodySmall),
      labelLarge: rubikMoonrocks(textStyle: textTheme.labelLarge),
      labelMedium: rubikMoonrocks(textStyle: textTheme.labelMedium),
      labelSmall: rubikMoonrocks(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Pixels font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Pixels
  static TextStyle rubikPixels({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cd7f7aa7710b19f46b74f1ee468e64d4ae8c322bec0bb2adbaf0eb546a5ab3a',
        5425804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikPixels',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Pixels font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Pixels
  static TextTheme rubikPixelsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikPixels(textStyle: textTheme.displayLarge),
      displayMedium: rubikPixels(textStyle: textTheme.displayMedium),
      displaySmall: rubikPixels(textStyle: textTheme.displaySmall),
      headlineLarge: rubikPixels(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikPixels(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikPixels(textStyle: textTheme.headlineSmall),
      titleLarge: rubikPixels(textStyle: textTheme.titleLarge),
      titleMedium: rubikPixels(textStyle: textTheme.titleMedium),
      titleSmall: rubikPixels(textStyle: textTheme.titleSmall),
      bodyLarge: rubikPixels(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikPixels(textStyle: textTheme.bodyMedium),
      bodySmall: rubikPixels(textStyle: textTheme.bodySmall),
      labelLarge: rubikPixels(textStyle: textTheme.labelLarge),
      labelMedium: rubikPixels(textStyle: textTheme.labelMedium),
      labelSmall: rubikPixels(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Puddles font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Puddles
  static TextStyle rubikPuddles({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'df67a7b7f72916e11460cfc15bd08226f90bc05462d2040bfe75fef5c57c52da',
        383712,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikPuddles',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Puddles font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Puddles
  static TextTheme rubikPuddlesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikPuddles(textStyle: textTheme.displayLarge),
      displayMedium: rubikPuddles(textStyle: textTheme.displayMedium),
      displaySmall: rubikPuddles(textStyle: textTheme.displaySmall),
      headlineLarge: rubikPuddles(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikPuddles(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikPuddles(textStyle: textTheme.headlineSmall),
      titleLarge: rubikPuddles(textStyle: textTheme.titleLarge),
      titleMedium: rubikPuddles(textStyle: textTheme.titleMedium),
      titleSmall: rubikPuddles(textStyle: textTheme.titleSmall),
      bodyLarge: rubikPuddles(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikPuddles(textStyle: textTheme.bodyMedium),
      bodySmall: rubikPuddles(textStyle: textTheme.bodySmall),
      labelLarge: rubikPuddles(textStyle: textTheme.labelLarge),
      labelMedium: rubikPuddles(textStyle: textTheme.labelMedium),
      labelSmall: rubikPuddles(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Scribble font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Scribble
  static TextStyle rubikScribble({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '39437185c9e1267a0426568781150efa32a57647d628c1be0a07aa574e4af496',
        554432,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikScribble',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Scribble font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Scribble
  static TextTheme rubikScribbleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikScribble(textStyle: textTheme.displayLarge),
      displayMedium: rubikScribble(textStyle: textTheme.displayMedium),
      displaySmall: rubikScribble(textStyle: textTheme.displaySmall),
      headlineLarge: rubikScribble(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikScribble(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikScribble(textStyle: textTheme.headlineSmall),
      titleLarge: rubikScribble(textStyle: textTheme.titleLarge),
      titleMedium: rubikScribble(textStyle: textTheme.titleMedium),
      titleSmall: rubikScribble(textStyle: textTheme.titleSmall),
      bodyLarge: rubikScribble(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikScribble(textStyle: textTheme.bodyMedium),
      bodySmall: rubikScribble(textStyle: textTheme.bodySmall),
      labelLarge: rubikScribble(textStyle: textTheme.labelLarge),
      labelMedium: rubikScribble(textStyle: textTheme.labelMedium),
      labelSmall: rubikScribble(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Spray Paint font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Spray+Paint
  static TextStyle rubikSprayPaint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e6c34931f1175681ffc0a17994fea2ab0c6aec0e7537638808ce9de17ab4048',
        893604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikSprayPaint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Spray Paint font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Spray+Paint
  static TextTheme rubikSprayPaintTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikSprayPaint(textStyle: textTheme.displayLarge),
      displayMedium: rubikSprayPaint(textStyle: textTheme.displayMedium),
      displaySmall: rubikSprayPaint(textStyle: textTheme.displaySmall),
      headlineLarge: rubikSprayPaint(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikSprayPaint(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikSprayPaint(textStyle: textTheme.headlineSmall),
      titleLarge: rubikSprayPaint(textStyle: textTheme.titleLarge),
      titleMedium: rubikSprayPaint(textStyle: textTheme.titleMedium),
      titleSmall: rubikSprayPaint(textStyle: textTheme.titleSmall),
      bodyLarge: rubikSprayPaint(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikSprayPaint(textStyle: textTheme.bodyMedium),
      bodySmall: rubikSprayPaint(textStyle: textTheme.bodySmall),
      labelLarge: rubikSprayPaint(textStyle: textTheme.labelLarge),
      labelMedium: rubikSprayPaint(textStyle: textTheme.labelMedium),
      labelSmall: rubikSprayPaint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Storm font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Storm
  static TextStyle rubikStorm({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '73646e66c570b0ca3d747faecc59fe1f925990894b1dc4e10deb1e8181ae65bc',
        758672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikStorm',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Storm font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Storm
  static TextTheme rubikStormTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikStorm(textStyle: textTheme.displayLarge),
      displayMedium: rubikStorm(textStyle: textTheme.displayMedium),
      displaySmall: rubikStorm(textStyle: textTheme.displaySmall),
      headlineLarge: rubikStorm(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikStorm(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikStorm(textStyle: textTheme.headlineSmall),
      titleLarge: rubikStorm(textStyle: textTheme.titleLarge),
      titleMedium: rubikStorm(textStyle: textTheme.titleMedium),
      titleSmall: rubikStorm(textStyle: textTheme.titleSmall),
      bodyLarge: rubikStorm(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikStorm(textStyle: textTheme.bodyMedium),
      bodySmall: rubikStorm(textStyle: textTheme.bodySmall),
      labelLarge: rubikStorm(textStyle: textTheme.labelLarge),
      labelMedium: rubikStorm(textStyle: textTheme.labelMedium),
      labelSmall: rubikStorm(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Vinyl font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Vinyl
  static TextStyle rubikVinyl({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4b866ec0a1a399a86cd5bffe45885d125ef186c05337b11fa114c57cbdb18bba',
        392768,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikVinyl',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Vinyl font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Vinyl
  static TextTheme rubikVinylTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikVinyl(textStyle: textTheme.displayLarge),
      displayMedium: rubikVinyl(textStyle: textTheme.displayMedium),
      displaySmall: rubikVinyl(textStyle: textTheme.displaySmall),
      headlineLarge: rubikVinyl(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikVinyl(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikVinyl(textStyle: textTheme.headlineSmall),
      titleLarge: rubikVinyl(textStyle: textTheme.titleLarge),
      titleMedium: rubikVinyl(textStyle: textTheme.titleMedium),
      titleSmall: rubikVinyl(textStyle: textTheme.titleSmall),
      bodyLarge: rubikVinyl(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikVinyl(textStyle: textTheme.bodyMedium),
      bodySmall: rubikVinyl(textStyle: textTheme.bodySmall),
      labelLarge: rubikVinyl(textStyle: textTheme.labelLarge),
      labelMedium: rubikVinyl(textStyle: textTheme.labelMedium),
      labelSmall: rubikVinyl(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rubik Wet Paint font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Wet+Paint
  static TextStyle rubikWetPaint({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '164e4e6c0d015fc8205770ed061ec3a44a72a50b0bbfcb4f6081c8e3de5a1451',
        418376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RubikWetPaint',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rubik Wet Paint font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rubik+Wet+Paint
  static TextTheme rubikWetPaintTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rubikWetPaint(textStyle: textTheme.displayLarge),
      displayMedium: rubikWetPaint(textStyle: textTheme.displayMedium),
      displaySmall: rubikWetPaint(textStyle: textTheme.displaySmall),
      headlineLarge: rubikWetPaint(textStyle: textTheme.headlineLarge),
      headlineMedium: rubikWetPaint(textStyle: textTheme.headlineMedium),
      headlineSmall: rubikWetPaint(textStyle: textTheme.headlineSmall),
      titleLarge: rubikWetPaint(textStyle: textTheme.titleLarge),
      titleMedium: rubikWetPaint(textStyle: textTheme.titleMedium),
      titleSmall: rubikWetPaint(textStyle: textTheme.titleSmall),
      bodyLarge: rubikWetPaint(textStyle: textTheme.bodyLarge),
      bodyMedium: rubikWetPaint(textStyle: textTheme.bodyMedium),
      bodySmall: rubikWetPaint(textStyle: textTheme.bodySmall),
      labelLarge: rubikWetPaint(textStyle: textTheme.labelLarge),
      labelMedium: rubikWetPaint(textStyle: textTheme.labelMedium),
      labelSmall: rubikWetPaint(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruda
  static TextStyle ruda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5160954ed3e99328d4f57e8dcbbce8d5ce671c5658b3b54c7a7ec6d456715379',
        50532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d22ae597994012cf84d05074c5ef310304e5c22508f3f4a032a85933e94b312',
        50584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eca3c23a94fa4fe860f2539ca728f7143fcac8135491f5f1ccc2896b681fc78d',
        50592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d978bf3411e84c919026ecb67f04a8ead743c8f102238239ae5fecb787c3f72',
        50512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c6bb64e2b513f21f1bd9ee422ad0e7e9f32db9aab125ecb3c56eee3a6e5a827',
        50600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'edf1273c26595739b8a5799e447af2a23ef30eb024bf54afdffe72ecfeaaecae',
        50424,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruda
  static TextTheme rudaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruda(textStyle: textTheme.displayLarge),
      displayMedium: ruda(textStyle: textTheme.displayMedium),
      displaySmall: ruda(textStyle: textTheme.displaySmall),
      headlineLarge: ruda(textStyle: textTheme.headlineLarge),
      headlineMedium: ruda(textStyle: textTheme.headlineMedium),
      headlineSmall: ruda(textStyle: textTheme.headlineSmall),
      titleLarge: ruda(textStyle: textTheme.titleLarge),
      titleMedium: ruda(textStyle: textTheme.titleMedium),
      titleSmall: ruda(textStyle: textTheme.titleSmall),
      bodyLarge: ruda(textStyle: textTheme.bodyLarge),
      bodyMedium: ruda(textStyle: textTheme.bodyMedium),
      bodySmall: ruda(textStyle: textTheme.bodySmall),
      labelLarge: ruda(textStyle: textTheme.labelLarge),
      labelMedium: ruda(textStyle: textTheme.labelMedium),
      labelSmall: ruda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rufina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rufina
  static TextStyle rufina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '37d67263c3c798e24449037fea8bbe577cf785a89e309ba3b36fe02be8513068',
        38092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e69e1fbcebf9b2b0d4e1e35b6120545d45e453f952d590ea9d81d256f5fdb44b',
        38156,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rufina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rufina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rufina
  static TextTheme rufinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rufina(textStyle: textTheme.displayLarge),
      displayMedium: rufina(textStyle: textTheme.displayMedium),
      displaySmall: rufina(textStyle: textTheme.displaySmall),
      headlineLarge: rufina(textStyle: textTheme.headlineLarge),
      headlineMedium: rufina(textStyle: textTheme.headlineMedium),
      headlineSmall: rufina(textStyle: textTheme.headlineSmall),
      titleLarge: rufina(textStyle: textTheme.titleLarge),
      titleMedium: rufina(textStyle: textTheme.titleMedium),
      titleSmall: rufina(textStyle: textTheme.titleSmall),
      bodyLarge: rufina(textStyle: textTheme.bodyLarge),
      bodyMedium: rufina(textStyle: textTheme.bodyMedium),
      bodySmall: rufina(textStyle: textTheme.bodySmall),
      labelLarge: rufina(textStyle: textTheme.labelLarge),
      labelMedium: rufina(textStyle: textTheme.labelMedium),
      labelSmall: rufina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruge Boogie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruge+Boogie
  static TextStyle rugeBoogie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9a5a0be81e802cf1f78141f183e7a7ebc5805cabff1f9020e311f75f85b141a',
        107976,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RugeBoogie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruge Boogie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruge+Boogie
  static TextTheme rugeBoogieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rugeBoogie(textStyle: textTheme.displayLarge),
      displayMedium: rugeBoogie(textStyle: textTheme.displayMedium),
      displaySmall: rugeBoogie(textStyle: textTheme.displaySmall),
      headlineLarge: rugeBoogie(textStyle: textTheme.headlineLarge),
      headlineMedium: rugeBoogie(textStyle: textTheme.headlineMedium),
      headlineSmall: rugeBoogie(textStyle: textTheme.headlineSmall),
      titleLarge: rugeBoogie(textStyle: textTheme.titleLarge),
      titleMedium: rugeBoogie(textStyle: textTheme.titleMedium),
      titleSmall: rugeBoogie(textStyle: textTheme.titleSmall),
      bodyLarge: rugeBoogie(textStyle: textTheme.bodyLarge),
      bodyMedium: rugeBoogie(textStyle: textTheme.bodyMedium),
      bodySmall: rugeBoogie(textStyle: textTheme.bodySmall),
      labelLarge: rugeBoogie(textStyle: textTheme.labelLarge),
      labelMedium: rugeBoogie(textStyle: textTheme.labelMedium),
      labelSmall: rugeBoogie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruluko font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruluko
  static TextStyle ruluko({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27f8111a1cf185145e375de9da3f6ceec5d1f9a01d17e92e0caa30e36fd5154d',
        24612,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruluko',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruluko font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruluko
  static TextTheme rulukoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruluko(textStyle: textTheme.displayLarge),
      displayMedium: ruluko(textStyle: textTheme.displayMedium),
      displaySmall: ruluko(textStyle: textTheme.displaySmall),
      headlineLarge: ruluko(textStyle: textTheme.headlineLarge),
      headlineMedium: ruluko(textStyle: textTheme.headlineMedium),
      headlineSmall: ruluko(textStyle: textTheme.headlineSmall),
      titleLarge: ruluko(textStyle: textTheme.titleLarge),
      titleMedium: ruluko(textStyle: textTheme.titleMedium),
      titleSmall: ruluko(textStyle: textTheme.titleSmall),
      bodyLarge: ruluko(textStyle: textTheme.bodyLarge),
      bodyMedium: ruluko(textStyle: textTheme.bodyMedium),
      bodySmall: ruluko(textStyle: textTheme.bodySmall),
      labelLarge: ruluko(textStyle: textTheme.labelLarge),
      labelMedium: ruluko(textStyle: textTheme.labelMedium),
      labelSmall: ruluko(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rum Raisin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rum+Raisin
  static TextStyle rumRaisin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5e470839ddd1433527d204e91bbc888f96b4059ff273a81c4de5cd31a43d553',
        59228,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RumRaisin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rum Raisin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rum+Raisin
  static TextTheme rumRaisinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rumRaisin(textStyle: textTheme.displayLarge),
      displayMedium: rumRaisin(textStyle: textTheme.displayMedium),
      displaySmall: rumRaisin(textStyle: textTheme.displaySmall),
      headlineLarge: rumRaisin(textStyle: textTheme.headlineLarge),
      headlineMedium: rumRaisin(textStyle: textTheme.headlineMedium),
      headlineSmall: rumRaisin(textStyle: textTheme.headlineSmall),
      titleLarge: rumRaisin(textStyle: textTheme.titleLarge),
      titleMedium: rumRaisin(textStyle: textTheme.titleMedium),
      titleSmall: rumRaisin(textStyle: textTheme.titleSmall),
      bodyLarge: rumRaisin(textStyle: textTheme.bodyLarge),
      bodyMedium: rumRaisin(textStyle: textTheme.bodyMedium),
      bodySmall: rumRaisin(textStyle: textTheme.bodySmall),
      labelLarge: rumRaisin(textStyle: textTheme.labelLarge),
      labelMedium: rumRaisin(textStyle: textTheme.labelMedium),
      labelSmall: rumRaisin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruslan Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruslan+Display
  static TextStyle ruslanDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb29ca1f7cc0c1b120e4aa45beaabf2a5666f13b83324456eb275ae05cddd132',
        54064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RuslanDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruslan Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruslan+Display
  static TextTheme ruslanDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruslanDisplay(textStyle: textTheme.displayLarge),
      displayMedium: ruslanDisplay(textStyle: textTheme.displayMedium),
      displaySmall: ruslanDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: ruslanDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: ruslanDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: ruslanDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: ruslanDisplay(textStyle: textTheme.titleLarge),
      titleMedium: ruslanDisplay(textStyle: textTheme.titleMedium),
      titleSmall: ruslanDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: ruslanDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: ruslanDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: ruslanDisplay(textStyle: textTheme.bodySmall),
      labelLarge: ruslanDisplay(textStyle: textTheme.labelLarge),
      labelMedium: ruslanDisplay(textStyle: textTheme.labelMedium),
      labelSmall: ruslanDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Russo One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Russo+One
  static TextStyle russoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd9548de02480e52ed86ab9c683758262f2dddd3030e60b0113141a4703fb7af',
        36792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'RussoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Russo One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Russo+One
  static TextTheme russoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: russoOne(textStyle: textTheme.displayLarge),
      displayMedium: russoOne(textStyle: textTheme.displayMedium),
      displaySmall: russoOne(textStyle: textTheme.displaySmall),
      headlineLarge: russoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: russoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: russoOne(textStyle: textTheme.headlineSmall),
      titleLarge: russoOne(textStyle: textTheme.titleLarge),
      titleMedium: russoOne(textStyle: textTheme.titleMedium),
      titleSmall: russoOne(textStyle: textTheme.titleSmall),
      bodyLarge: russoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: russoOne(textStyle: textTheme.bodyMedium),
      bodySmall: russoOne(textStyle: textTheme.bodySmall),
      labelLarge: russoOne(textStyle: textTheme.labelLarge),
      labelMedium: russoOne(textStyle: textTheme.labelMedium),
      labelSmall: russoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruthie font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruthie
  static TextStyle ruthie({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10734c830bccb48db397efd020d2a54458d5242f571fa84d9a13bf5e1988abb0',
        69948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruthie',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruthie font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruthie
  static TextTheme ruthieTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruthie(textStyle: textTheme.displayLarge),
      displayMedium: ruthie(textStyle: textTheme.displayMedium),
      displaySmall: ruthie(textStyle: textTheme.displaySmall),
      headlineLarge: ruthie(textStyle: textTheme.headlineLarge),
      headlineMedium: ruthie(textStyle: textTheme.headlineMedium),
      headlineSmall: ruthie(textStyle: textTheme.headlineSmall),
      titleLarge: ruthie(textStyle: textTheme.titleLarge),
      titleMedium: ruthie(textStyle: textTheme.titleMedium),
      titleSmall: ruthie(textStyle: textTheme.titleSmall),
      bodyLarge: ruthie(textStyle: textTheme.bodyLarge),
      bodyMedium: ruthie(textStyle: textTheme.bodyMedium),
      bodySmall: ruthie(textStyle: textTheme.bodySmall),
      labelLarge: ruthie(textStyle: textTheme.labelLarge),
      labelMedium: ruthie(textStyle: textTheme.labelMedium),
      labelSmall: ruthie(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ruwudu font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruwudu
  static TextStyle ruwudu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '777449cf3ce3920c07bce90e1d63a37a96908bc2b83d98a18ccff6e94575437a',
        103376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50421dc388cdc40b4dd66ee457fee5836df8c2a2478a7363fdc3109c1b7e63b9',
        104228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '619f44113cffb1b9944127f25eb38a9f7c9224eb2b4f83c8b5d255d545d66a9c',
        104700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c2c5c9d03128ed5d07b1bae58c62e94684107ff3fd7a6144eafcc51c1b8f878',
        105100,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Ruwudu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ruwudu font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ruwudu
  static TextTheme ruwuduTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: ruwudu(textStyle: textTheme.displayLarge),
      displayMedium: ruwudu(textStyle: textTheme.displayMedium),
      displaySmall: ruwudu(textStyle: textTheme.displaySmall),
      headlineLarge: ruwudu(textStyle: textTheme.headlineLarge),
      headlineMedium: ruwudu(textStyle: textTheme.headlineMedium),
      headlineSmall: ruwudu(textStyle: textTheme.headlineSmall),
      titleLarge: ruwudu(textStyle: textTheme.titleLarge),
      titleMedium: ruwudu(textStyle: textTheme.titleMedium),
      titleSmall: ruwudu(textStyle: textTheme.titleSmall),
      bodyLarge: ruwudu(textStyle: textTheme.bodyLarge),
      bodyMedium: ruwudu(textStyle: textTheme.bodyMedium),
      bodySmall: ruwudu(textStyle: textTheme.bodySmall),
      labelLarge: ruwudu(textStyle: textTheme.labelLarge),
      labelMedium: ruwudu(textStyle: textTheme.labelMedium),
      labelSmall: ruwudu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Rye font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rye
  static TextStyle rye({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c0463aeec976dc75715e765a815de8e99e823c41f0be0cf9f303ffce874fbac',
        80784,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Rye',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Rye font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Rye
  static TextTheme ryeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: rye(textStyle: textTheme.displayLarge),
      displayMedium: rye(textStyle: textTheme.displayMedium),
      displaySmall: rye(textStyle: textTheme.displaySmall),
      headlineLarge: rye(textStyle: textTheme.headlineLarge),
      headlineMedium: rye(textStyle: textTheme.headlineMedium),
      headlineSmall: rye(textStyle: textTheme.headlineSmall),
      titleLarge: rye(textStyle: textTheme.titleLarge),
      titleMedium: rye(textStyle: textTheme.titleMedium),
      titleSmall: rye(textStyle: textTheme.titleSmall),
      bodyLarge: rye(textStyle: textTheme.bodyLarge),
      bodyMedium: rye(textStyle: textTheme.bodyMedium),
      bodySmall: rye(textStyle: textTheme.bodySmall),
      labelLarge: rye(textStyle: textTheme.labelLarge),
      labelMedium: rye(textStyle: textTheme.labelMedium),
      labelSmall: rye(textStyle: textTheme.labelSmall),
    );
  }
}
