// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'M'.
class PartM {
  /// Applies the M PLUS 1 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1
  static TextStyle mPlus1({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '109fe380b4307ec0baad01098e3112eefad628c8d36a3a60dd8ae6cccb0265b0',
        1712020,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6db9890555358c993b72aae3f54a23737abf5c20f8ac42258ae36910600ff8c',
        1723908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '83173fde95f070acf1d2a9b9fbb87714ab9a08d1bc32411bbadba9c45099098b',
        1723224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef0790a184670a70916735967abe50caad06460a8067a20f979d0d786cc4b1c6',
        1723896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fec246679f72a16e8140f3a3ca5734de7bbfd90d99717b37db07ca09f12d323c',
        1729420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bad32170ea3965d60cd6e86ea1eae4811894310e0192a186a989fe208488ce37',
        1728576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '603184e186b0bd828f0a75c9513b448a098ee52afa06f81f28a065daa4d82393',
        1730088,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '787d538c20a2f71c63291a35c1e9f0067b156c73e2a8c7fe89015a1d0701b013',
        1730036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79806e2eaea0c6281277f511d8cadd1a76655b4963f362489d39b3090e60bf74',
        1723684,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUS1',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS 1 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1
  static TextTheme mPlus1TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlus1(textStyle: textTheme.displayLarge),
      displayMedium: mPlus1(textStyle: textTheme.displayMedium),
      displaySmall: mPlus1(textStyle: textTheme.displaySmall),
      headlineLarge: mPlus1(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlus1(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlus1(textStyle: textTheme.headlineSmall),
      titleLarge: mPlus1(textStyle: textTheme.titleLarge),
      titleMedium: mPlus1(textStyle: textTheme.titleMedium),
      titleSmall: mPlus1(textStyle: textTheme.titleSmall),
      bodyLarge: mPlus1(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlus1(textStyle: textTheme.bodyMedium),
      bodySmall: mPlus1(textStyle: textTheme.bodySmall),
      labelLarge: mPlus1(textStyle: textTheme.labelLarge),
      labelMedium: mPlus1(textStyle: textTheme.labelMedium),
      labelSmall: mPlus1(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the M PLUS 1 Code font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1+Code
  static TextStyle mPlus1Code({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '78d51dfe5c07b9139d84f3c8a4cb0c6b7267adfce2e576b77015964c9734c602',
        1681964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8ccc81c1ff88ef01e5930b46f4b15ed602550c78f9483fa43e81b1500b603cd',
        1681648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0996969382d38cf9d788bffd31a2706445b52a078892fbd3fa54ef5f490d4802',
        1680956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ad8341b109703ced2a1fa61e0fea6358951632c18eaca5f650352129f51ddfaa',
        1693292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7dfc4bd7f472b8ba2ce86c875c2aa420dc00a9fd2689f18b6778e874ee9ccb2f',
        1700004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ba9408001bbbd35d709dae28460e6c23f289beb5bcfe0fd80e3df55ab7c88fc',
        1698264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc30ef11c43e079ee26d2ea10352276aa75f79a609015b79dddad8ffe1978e08',
        1699108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUS1Code',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS 1 Code font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1+Code
  static TextTheme mPlus1CodeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlus1Code(textStyle: textTheme.displayLarge),
      displayMedium: mPlus1Code(textStyle: textTheme.displayMedium),
      displaySmall: mPlus1Code(textStyle: textTheme.displaySmall),
      headlineLarge: mPlus1Code(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlus1Code(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlus1Code(textStyle: textTheme.headlineSmall),
      titleLarge: mPlus1Code(textStyle: textTheme.titleLarge),
      titleMedium: mPlus1Code(textStyle: textTheme.titleMedium),
      titleSmall: mPlus1Code(textStyle: textTheme.titleSmall),
      bodyLarge: mPlus1Code(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlus1Code(textStyle: textTheme.bodyMedium),
      bodySmall: mPlus1Code(textStyle: textTheme.bodySmall),
      labelLarge: mPlus1Code(textStyle: textTheme.labelLarge),
      labelMedium: mPlus1Code(textStyle: textTheme.labelMedium),
      labelSmall: mPlus1Code(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the M PLUS 1p font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1p
  static TextStyle mPlus1p({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aa9b61369f183571496a480c98bdf9a44f61419c2ccf0740e0d8b5d03bf6bae0',
        1766568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ca019a6f25ed771c5391a191bd2b2eefe6f9b1c08bfa695cbe603980f4647e3',
        1762092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e97abdba17f7de7b88b860a1dd16e7d03e3bb4c75982d71471f7f8efd27d9197',
        1753660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd47efc2873264bb6b404aefe8a48a18f6496c0f8c69a038923ff983f7b6f4207',
        1753776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddfe21a5f8a9dc313a5c3f56ca83843fd87454d8f3890b10dafd5afd4db198a6',
        1761476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0844ccf86b00c8cd26fc82c8a354aeb7332fb0a2a368b03db257fde4fd7232d6',
        1768708,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '06a1c0be782dce577800a992bb8e2353a70ddf478f97aaf36a9eab4fcd5e9be3',
        1769104,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUS1p',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS 1p font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+1p
  static TextTheme mPlus1pTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlus1p(textStyle: textTheme.displayLarge),
      displayMedium: mPlus1p(textStyle: textTheme.displayMedium),
      displaySmall: mPlus1p(textStyle: textTheme.displaySmall),
      headlineLarge: mPlus1p(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlus1p(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlus1p(textStyle: textTheme.headlineSmall),
      titleLarge: mPlus1p(textStyle: textTheme.titleLarge),
      titleMedium: mPlus1p(textStyle: textTheme.titleMedium),
      titleSmall: mPlus1p(textStyle: textTheme.titleSmall),
      bodyLarge: mPlus1p(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlus1p(textStyle: textTheme.bodyMedium),
      bodySmall: mPlus1p(textStyle: textTheme.bodySmall),
      labelLarge: mPlus1p(textStyle: textTheme.labelLarge),
      labelMedium: mPlus1p(textStyle: textTheme.labelMedium),
      labelSmall: mPlus1p(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the M PLUS 2 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+2
  static TextStyle mPlus2({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c69f6e7282ff3622cf827c8d02a0078484341c33ea956b1306d91bd4854bfac',
        1714636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd3af29cad50a635bb09005f1c55995416e52d1dafc7b24ffd17da4dc9ccaaadc',
        1726524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'baf3911f73cfba7c98948dc32e296ab4b9c4593035e95e594b6b7c95ae9e1c5b',
        1725864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c8c14a6860cc2ddd995ccc0ac1f6c19314fec32d7e6829dd28efe68dcd9a66b',
        1726500,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd03cbbc3274f5205e63e7f19f421856047086ecad1f38fbe6728208c7c594534',
        1731604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41073589bd28e5269d4ec9df3213c7a3c514c42631ab0e48ade45316529d237a',
        1730740,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82aa929622d3e6baac492963209c3242152d222ad600b5bafabe20fcab8e9849',
        1732332,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e9d2b57bc6be5627b813184880fa12a9c2ff3320695b3a45d69feabf69389af9',
        1732324,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a52199c16b790277fde4e4909500f5085c3e0c847bb7eccefa97e3a429f0baac',
        1725972,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUS2',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS 2 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+2
  static TextTheme mPlus2TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlus2(textStyle: textTheme.displayLarge),
      displayMedium: mPlus2(textStyle: textTheme.displayMedium),
      displaySmall: mPlus2(textStyle: textTheme.displaySmall),
      headlineLarge: mPlus2(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlus2(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlus2(textStyle: textTheme.headlineSmall),
      titleLarge: mPlus2(textStyle: textTheme.titleLarge),
      titleMedium: mPlus2(textStyle: textTheme.titleMedium),
      titleSmall: mPlus2(textStyle: textTheme.titleSmall),
      bodyLarge: mPlus2(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlus2(textStyle: textTheme.bodyMedium),
      bodySmall: mPlus2(textStyle: textTheme.bodySmall),
      labelLarge: mPlus2(textStyle: textTheme.labelLarge),
      labelMedium: mPlus2(textStyle: textTheme.labelMedium),
      labelSmall: mPlus2(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the M PLUS Code Latin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+Code+Latin
  static TextStyle mPlusCodeLatin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4cd830e45152371aec7b6b5cabec297ab0e9f917e0cf78bece37813ef4af7ad',
        45668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '620ac99fbdf817e7ede523fc55f11d42a15b9edd6aac3c1cb14dbea1e4800a77',
        45896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f446811d19cb6da1fe7e3230c39644e0ae56791237d7306cd3064e66a2c9cfd4',
        45844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a36adebb89a27e239270bb7e627454aeabd4f10456f4235433a9ba0657c71534',
        46588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b61da0cf54f668c5846ddbec8f5331b0eb606e9f382f25559bbc08364b099b4',
        47244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c74374e31ee345e5c6c91c6fb3c2d811ebcab2b6e7c5666681cfa5c020e9c4c1',
        47256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c45304e24a96753a27e2da37917ad5ec246c668d41b4acdfafc08aa47a50960f',
        47088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUSCodeLatin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS Code Latin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+Code+Latin
  static TextTheme mPlusCodeLatinTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlusCodeLatin(textStyle: textTheme.displayLarge),
      displayMedium: mPlusCodeLatin(textStyle: textTheme.displayMedium),
      displaySmall: mPlusCodeLatin(textStyle: textTheme.displaySmall),
      headlineLarge: mPlusCodeLatin(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlusCodeLatin(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlusCodeLatin(textStyle: textTheme.headlineSmall),
      titleLarge: mPlusCodeLatin(textStyle: textTheme.titleLarge),
      titleMedium: mPlusCodeLatin(textStyle: textTheme.titleMedium),
      titleSmall: mPlusCodeLatin(textStyle: textTheme.titleSmall),
      bodyLarge: mPlusCodeLatin(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlusCodeLatin(textStyle: textTheme.bodyMedium),
      bodySmall: mPlusCodeLatin(textStyle: textTheme.bodySmall),
      labelLarge: mPlusCodeLatin(textStyle: textTheme.labelLarge),
      labelMedium: mPlusCodeLatin(textStyle: textTheme.labelMedium),
      labelSmall: mPlusCodeLatin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the M PLUS Rounded 1c font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+Rounded+1c
  static TextStyle mPlusRounded1c({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e077690563917ec1f5b937a2674ebe43b44707df00dbc2df99da7fc6bbf1f9db',
        2899200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dfdc1a721f186bcd57e50f1bc228a5d93cede477a9cff430b194de5c85477799',
        3284736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e30fa1b6bfbb0a32efa620039763ecf4155c425078e5946aabab3e869776b5c3',
        3379736,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0a1d8fc54e3d396c30c265597945feb97bf3a2b90c6ff8c6bda98e433cd54825',
        3422384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '329a8ed11bfe4054de884fcf8692759a19bde914a47d470a0b93fc4ed45d2d1c',
        3532232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9dc19977e1ea631f1492200fcf63e450fb93ae2c93ad54f8d5b26a1052940767',
        3617848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdaee2302dacdb2017f355a3383f92093b9da749d13c2eeb2706fa8a15dd447f',
        3624724,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MPLUSRounded1c',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the M PLUS Rounded 1c font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/M+PLUS+Rounded+1c
  static TextTheme mPlusRounded1cTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mPlusRounded1c(textStyle: textTheme.displayLarge),
      displayMedium: mPlusRounded1c(textStyle: textTheme.displayMedium),
      displaySmall: mPlusRounded1c(textStyle: textTheme.displaySmall),
      headlineLarge: mPlusRounded1c(textStyle: textTheme.headlineLarge),
      headlineMedium: mPlusRounded1c(textStyle: textTheme.headlineMedium),
      headlineSmall: mPlusRounded1c(textStyle: textTheme.headlineSmall),
      titleLarge: mPlusRounded1c(textStyle: textTheme.titleLarge),
      titleMedium: mPlusRounded1c(textStyle: textTheme.titleMedium),
      titleSmall: mPlusRounded1c(textStyle: textTheme.titleSmall),
      bodyLarge: mPlusRounded1c(textStyle: textTheme.bodyLarge),
      bodyMedium: mPlusRounded1c(textStyle: textTheme.bodyMedium),
      bodySmall: mPlusRounded1c(textStyle: textTheme.bodySmall),
      labelLarge: mPlusRounded1c(textStyle: textTheme.labelLarge),
      labelMedium: mPlusRounded1c(textStyle: textTheme.labelMedium),
      labelSmall: mPlusRounded1c(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ma Shan Zheng font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ma+Shan+Zheng
  static TextStyle maShanZheng({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '18689b524ea22916a760249127fd63dba37af537b071668c06b7fc7357e98b9b',
        5855516,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MaShanZheng',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ma Shan Zheng font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ma+Shan+Zheng
  static TextTheme maShanZhengTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: maShanZheng(textStyle: textTheme.displayLarge),
      displayMedium: maShanZheng(textStyle: textTheme.displayMedium),
      displaySmall: maShanZheng(textStyle: textTheme.displaySmall),
      headlineLarge: maShanZheng(textStyle: textTheme.headlineLarge),
      headlineMedium: maShanZheng(textStyle: textTheme.headlineMedium),
      headlineSmall: maShanZheng(textStyle: textTheme.headlineSmall),
      titleLarge: maShanZheng(textStyle: textTheme.titleLarge),
      titleMedium: maShanZheng(textStyle: textTheme.titleMedium),
      titleSmall: maShanZheng(textStyle: textTheme.titleSmall),
      bodyLarge: maShanZheng(textStyle: textTheme.bodyLarge),
      bodyMedium: maShanZheng(textStyle: textTheme.bodyMedium),
      bodySmall: maShanZheng(textStyle: textTheme.bodySmall),
      labelLarge: maShanZheng(textStyle: textTheme.labelLarge),
      labelMedium: maShanZheng(textStyle: textTheme.labelMedium),
      labelSmall: maShanZheng(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Macondo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Macondo
  static TextStyle macondo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74de73a4aec59094258486126f30f3bf4d13c4b5260f9964a17a955764c6373d',
        46408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Macondo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Macondo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Macondo
  static TextTheme macondoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: macondo(textStyle: textTheme.displayLarge),
      displayMedium: macondo(textStyle: textTheme.displayMedium),
      displaySmall: macondo(textStyle: textTheme.displaySmall),
      headlineLarge: macondo(textStyle: textTheme.headlineLarge),
      headlineMedium: macondo(textStyle: textTheme.headlineMedium),
      headlineSmall: macondo(textStyle: textTheme.headlineSmall),
      titleLarge: macondo(textStyle: textTheme.titleLarge),
      titleMedium: macondo(textStyle: textTheme.titleMedium),
      titleSmall: macondo(textStyle: textTheme.titleSmall),
      bodyLarge: macondo(textStyle: textTheme.bodyLarge),
      bodyMedium: macondo(textStyle: textTheme.bodyMedium),
      bodySmall: macondo(textStyle: textTheme.bodySmall),
      labelLarge: macondo(textStyle: textTheme.labelLarge),
      labelMedium: macondo(textStyle: textTheme.labelMedium),
      labelSmall: macondo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Macondo Swash Caps font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Macondo+Swash+Caps
  static TextStyle macondoSwashCaps({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ac3ccff3148d04a4d1ec6853179f15dca2ed2c40cd12449b73210eacdaf00f0',
        31072,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MacondoSwashCaps',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Macondo Swash Caps font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Macondo+Swash+Caps
  static TextTheme macondoSwashCapsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: macondoSwashCaps(textStyle: textTheme.displayLarge),
      displayMedium: macondoSwashCaps(textStyle: textTheme.displayMedium),
      displaySmall: macondoSwashCaps(textStyle: textTheme.displaySmall),
      headlineLarge: macondoSwashCaps(textStyle: textTheme.headlineLarge),
      headlineMedium: macondoSwashCaps(textStyle: textTheme.headlineMedium),
      headlineSmall: macondoSwashCaps(textStyle: textTheme.headlineSmall),
      titleLarge: macondoSwashCaps(textStyle: textTheme.titleLarge),
      titleMedium: macondoSwashCaps(textStyle: textTheme.titleMedium),
      titleSmall: macondoSwashCaps(textStyle: textTheme.titleSmall),
      bodyLarge: macondoSwashCaps(textStyle: textTheme.bodyLarge),
      bodyMedium: macondoSwashCaps(textStyle: textTheme.bodyMedium),
      bodySmall: macondoSwashCaps(textStyle: textTheme.bodySmall),
      labelLarge: macondoSwashCaps(textStyle: textTheme.labelLarge),
      labelMedium: macondoSwashCaps(textStyle: textTheme.labelMedium),
      labelSmall: macondoSwashCaps(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mada
  static TextStyle mada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f49ccbfac6fb7c393010351761c2a8d105c81a6b59abc1d61b62a2e202ef0086',
        96128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d0aefbc2c52fc07e1942ed55c214b5ce896db0a378d8f9fe45e24115cc7e2a3',
        96492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fec6e4c2c5a109a0b668ab3a0c5eb810830eb62911305a2d829481cd40671543',
        96464,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd26f78967f7d49a01f7297fe87b54404696f9bb61197e3c65cb9e991d5c88599',
        96528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '56aec0107040f86163e0f2b1306588d911cfd5bf9c9725f22be1f047cdd38696',
        96636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ae684aec0edc744111ab8b81693f2e18011d506f427b05b20bca903ef71a11d',
        96576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '34ca1215540bbc54f67d3ed0390f18069cfbd7caaa7c7e690ad01fdfb3ff303e',
        96612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24a6920e8a38adccfa1b5044ab7ad01a0a95a11063465d7a81a88d724d62d49a',
        96292,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mada
  static TextTheme madaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mada(textStyle: textTheme.displayLarge),
      displayMedium: mada(textStyle: textTheme.displayMedium),
      displaySmall: mada(textStyle: textTheme.displaySmall),
      headlineLarge: mada(textStyle: textTheme.headlineLarge),
      headlineMedium: mada(textStyle: textTheme.headlineMedium),
      headlineSmall: mada(textStyle: textTheme.headlineSmall),
      titleLarge: mada(textStyle: textTheme.titleLarge),
      titleMedium: mada(textStyle: textTheme.titleMedium),
      titleSmall: mada(textStyle: textTheme.titleSmall),
      bodyLarge: mada(textStyle: textTheme.bodyLarge),
      bodyMedium: mada(textStyle: textTheme.bodyMedium),
      bodySmall: mada(textStyle: textTheme.bodySmall),
      labelLarge: mada(textStyle: textTheme.labelLarge),
      labelMedium: mada(textStyle: textTheme.labelMedium),
      labelSmall: mada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Madimi One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Madimi+One
  static TextStyle madimiOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c99bfc920cf3248615c1e9f9d9770efcb3c3085856654bad2327cda3c15dd79',
        77004,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MadimiOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Madimi One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Madimi+One
  static TextTheme madimiOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: madimiOne(textStyle: textTheme.displayLarge),
      displayMedium: madimiOne(textStyle: textTheme.displayMedium),
      displaySmall: madimiOne(textStyle: textTheme.displaySmall),
      headlineLarge: madimiOne(textStyle: textTheme.headlineLarge),
      headlineMedium: madimiOne(textStyle: textTheme.headlineMedium),
      headlineSmall: madimiOne(textStyle: textTheme.headlineSmall),
      titleLarge: madimiOne(textStyle: textTheme.titleLarge),
      titleMedium: madimiOne(textStyle: textTheme.titleMedium),
      titleSmall: madimiOne(textStyle: textTheme.titleSmall),
      bodyLarge: madimiOne(textStyle: textTheme.bodyLarge),
      bodyMedium: madimiOne(textStyle: textTheme.bodyMedium),
      bodySmall: madimiOne(textStyle: textTheme.bodySmall),
      labelLarge: madimiOne(textStyle: textTheme.labelLarge),
      labelMedium: madimiOne(textStyle: textTheme.labelMedium),
      labelSmall: madimiOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Magra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Magra
  static TextStyle magra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14a31502baa6bc3d1d533ffcb22ed85a1432cccae9de9aaceab7f9613d5a42e6',
        40800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c9a0a85f1365e79e0be3858bfa5565709d6b041fbe2c94fdc07078addb09e0d',
        39872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Magra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Magra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Magra
  static TextTheme magraTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: magra(textStyle: textTheme.displayLarge),
      displayMedium: magra(textStyle: textTheme.displayMedium),
      displaySmall: magra(textStyle: textTheme.displaySmall),
      headlineLarge: magra(textStyle: textTheme.headlineLarge),
      headlineMedium: magra(textStyle: textTheme.headlineMedium),
      headlineSmall: magra(textStyle: textTheme.headlineSmall),
      titleLarge: magra(textStyle: textTheme.titleLarge),
      titleMedium: magra(textStyle: textTheme.titleMedium),
      titleSmall: magra(textStyle: textTheme.titleSmall),
      bodyLarge: magra(textStyle: textTheme.bodyLarge),
      bodyMedium: magra(textStyle: textTheme.bodyMedium),
      bodySmall: magra(textStyle: textTheme.bodySmall),
      labelLarge: magra(textStyle: textTheme.labelLarge),
      labelMedium: magra(textStyle: textTheme.labelMedium),
      labelSmall: magra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Maiden Orange font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maiden+Orange
  static TextStyle maidenOrange({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d69a68816aa3d4a4cfd7a863f00dc239d211a994fb1afa3c29eaf4f01acc7f4',
        45632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MaidenOrange',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Maiden Orange font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maiden+Orange
  static TextTheme maidenOrangeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: maidenOrange(textStyle: textTheme.displayLarge),
      displayMedium: maidenOrange(textStyle: textTheme.displayMedium),
      displaySmall: maidenOrange(textStyle: textTheme.displaySmall),
      headlineLarge: maidenOrange(textStyle: textTheme.headlineLarge),
      headlineMedium: maidenOrange(textStyle: textTheme.headlineMedium),
      headlineSmall: maidenOrange(textStyle: textTheme.headlineSmall),
      titleLarge: maidenOrange(textStyle: textTheme.titleLarge),
      titleMedium: maidenOrange(textStyle: textTheme.titleMedium),
      titleSmall: maidenOrange(textStyle: textTheme.titleSmall),
      bodyLarge: maidenOrange(textStyle: textTheme.bodyLarge),
      bodyMedium: maidenOrange(textStyle: textTheme.bodyMedium),
      bodySmall: maidenOrange(textStyle: textTheme.bodySmall),
      labelLarge: maidenOrange(textStyle: textTheme.labelLarge),
      labelMedium: maidenOrange(textStyle: textTheme.labelMedium),
      labelSmall: maidenOrange(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Maitree font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maitree
  static TextStyle maitree({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e5c26dcf50490bad8ece46b251341b794626dbcc2b447d6462719adb0a30a669',
        119800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a860e0d712863c7d1f48caa196c01d06c07440ba997240dc35222116b887315',
        117100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7e182c9f3ff383aecf89007408c82c2fe421c7bd1c0d26a2c589d650858c242',
        118484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c443b9e40e75884e57ea3274551ea6e929e48c5f606f0e493de21535255416ea',
        119964,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1ae61877eb99327c96f0881800d7ff67ed333496734a176a044f61aecd50785',
        121252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b68c27287653802a934b53c52097b15931a570dd2b1252cfc6716301f7c79c48',
        123064,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Maitree',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Maitree font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maitree
  static TextTheme maitreeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: maitree(textStyle: textTheme.displayLarge),
      displayMedium: maitree(textStyle: textTheme.displayMedium),
      displaySmall: maitree(textStyle: textTheme.displaySmall),
      headlineLarge: maitree(textStyle: textTheme.headlineLarge),
      headlineMedium: maitree(textStyle: textTheme.headlineMedium),
      headlineSmall: maitree(textStyle: textTheme.headlineSmall),
      titleLarge: maitree(textStyle: textTheme.titleLarge),
      titleMedium: maitree(textStyle: textTheme.titleMedium),
      titleSmall: maitree(textStyle: textTheme.titleSmall),
      bodyLarge: maitree(textStyle: textTheme.bodyLarge),
      bodyMedium: maitree(textStyle: textTheme.bodyMedium),
      bodySmall: maitree(textStyle: textTheme.bodySmall),
      labelLarge: maitree(textStyle: textTheme.labelLarge),
      labelMedium: maitree(textStyle: textTheme.labelMedium),
      labelSmall: maitree(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Major Mono Display font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Major+Mono+Display
  static TextStyle majorMonoDisplay({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a7396fa62aae1e0c350e023060775f55da68cccfd74b3c7d4f5f7eee87c94cd9',
        73668,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MajorMonoDisplay',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Major Mono Display font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Major+Mono+Display
  static TextTheme majorMonoDisplayTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: majorMonoDisplay(textStyle: textTheme.displayLarge),
      displayMedium: majorMonoDisplay(textStyle: textTheme.displayMedium),
      displaySmall: majorMonoDisplay(textStyle: textTheme.displaySmall),
      headlineLarge: majorMonoDisplay(textStyle: textTheme.headlineLarge),
      headlineMedium: majorMonoDisplay(textStyle: textTheme.headlineMedium),
      headlineSmall: majorMonoDisplay(textStyle: textTheme.headlineSmall),
      titleLarge: majorMonoDisplay(textStyle: textTheme.titleLarge),
      titleMedium: majorMonoDisplay(textStyle: textTheme.titleMedium),
      titleSmall: majorMonoDisplay(textStyle: textTheme.titleSmall),
      bodyLarge: majorMonoDisplay(textStyle: textTheme.bodyLarge),
      bodyMedium: majorMonoDisplay(textStyle: textTheme.bodyMedium),
      bodySmall: majorMonoDisplay(textStyle: textTheme.bodySmall),
      labelLarge: majorMonoDisplay(textStyle: textTheme.labelLarge),
      labelMedium: majorMonoDisplay(textStyle: textTheme.labelMedium),
      labelSmall: majorMonoDisplay(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mako font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mako
  static TextStyle mako({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '91373a28f9c4eb37f5c0cc92813eb4f33500ef24712ce3d16d254424608ae91e',
        50928,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mako',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mako font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mako
  static TextTheme makoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mako(textStyle: textTheme.displayLarge),
      displayMedium: mako(textStyle: textTheme.displayMedium),
      displaySmall: mako(textStyle: textTheme.displaySmall),
      headlineLarge: mako(textStyle: textTheme.headlineLarge),
      headlineMedium: mako(textStyle: textTheme.headlineMedium),
      headlineSmall: mako(textStyle: textTheme.headlineSmall),
      titleLarge: mako(textStyle: textTheme.titleLarge),
      titleMedium: mako(textStyle: textTheme.titleMedium),
      titleSmall: mako(textStyle: textTheme.titleSmall),
      bodyLarge: mako(textStyle: textTheme.bodyLarge),
      bodyMedium: mako(textStyle: textTheme.bodyMedium),
      bodySmall: mako(textStyle: textTheme.bodySmall),
      labelLarge: mako(textStyle: textTheme.labelLarge),
      labelMedium: mako(textStyle: textTheme.labelMedium),
      labelSmall: mako(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mali font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mali
  static TextStyle mali({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa023b84089dddd968aaa8a9af85114b2432be3eb6172f99789a3ae7bd543ee2',
        104272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2a579f4d12bff42168479a54a31095f70747a8973a57b69b936e27633189406b',
        107164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c59426069511ffc36bdd5bb3670a0e38378f6b3397f5ffb79ef914af620f6012',
        104480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a39afa524102532b9d18e19fee097806158a1701105a9943d917977833baa598',
        107336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aaadb63184a80bb24d7816775c2dca9190123a18d7a83af532328184f2ea7f32',
        104556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3d26f3cfa8067a8d6e86dd94e2264b68f4d17e23c9ce3c527d354c7ed39567dd',
        107620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19a953272fdd4907ed7edf681c73df68a70870017f72fd1374142feca6c166b0',
        104600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2396956ede92acd1819c0bb780574f281f94863dea661b8a635e09e6a3717962',
        107608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '478cc94d5111b74f569e558686104f2c27e6ead432329e143a34240adb5f7b6a',
        104640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b338a71cf893f3f34734911899abf29613f579a3fca432cf5443bcdfde1a417f',
        107596,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2945ab4ffbe01953a44ed5a1c249edd40c649ef9be29fc9b035ae184867dc813',
        104032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7a0ee262e2e1a053633d5bfc8e6b4af7beb7da72f1419dc3e08dc55a25a6d398',
        107456,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mali',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mali font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mali
  static TextTheme maliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mali(textStyle: textTheme.displayLarge),
      displayMedium: mali(textStyle: textTheme.displayMedium),
      displaySmall: mali(textStyle: textTheme.displaySmall),
      headlineLarge: mali(textStyle: textTheme.headlineLarge),
      headlineMedium: mali(textStyle: textTheme.headlineMedium),
      headlineSmall: mali(textStyle: textTheme.headlineSmall),
      titleLarge: mali(textStyle: textTheme.titleLarge),
      titleMedium: mali(textStyle: textTheme.titleMedium),
      titleSmall: mali(textStyle: textTheme.titleSmall),
      bodyLarge: mali(textStyle: textTheme.bodyLarge),
      bodyMedium: mali(textStyle: textTheme.bodyMedium),
      bodySmall: mali(textStyle: textTheme.bodySmall),
      labelLarge: mali(textStyle: textTheme.labelLarge),
      labelMedium: mali(textStyle: textTheme.labelMedium),
      labelSmall: mali(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mallanna font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mallanna
  static TextStyle mallanna({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87f24c359879c49fb9820d515b40484641bd2851002fa1ef61afe060fe8aa0a2',
        350548,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mallanna',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mallanna font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mallanna
  static TextTheme mallannaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mallanna(textStyle: textTheme.displayLarge),
      displayMedium: mallanna(textStyle: textTheme.displayMedium),
      displaySmall: mallanna(textStyle: textTheme.displaySmall),
      headlineLarge: mallanna(textStyle: textTheme.headlineLarge),
      headlineMedium: mallanna(textStyle: textTheme.headlineMedium),
      headlineSmall: mallanna(textStyle: textTheme.headlineSmall),
      titleLarge: mallanna(textStyle: textTheme.titleLarge),
      titleMedium: mallanna(textStyle: textTheme.titleMedium),
      titleSmall: mallanna(textStyle: textTheme.titleSmall),
      bodyLarge: mallanna(textStyle: textTheme.bodyLarge),
      bodyMedium: mallanna(textStyle: textTheme.bodyMedium),
      bodySmall: mallanna(textStyle: textTheme.bodySmall),
      labelLarge: mallanna(textStyle: textTheme.labelLarge),
      labelMedium: mallanna(textStyle: textTheme.labelMedium),
      labelSmall: mallanna(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Maname font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maname
  static TextStyle maname({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f4f8b45497e2b8e5380737d40ddc9bb4301fe9a5e1ec4fc4c9fc97859165db0',
        245828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Maname',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Maname font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maname
  static TextTheme manameTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: maname(textStyle: textTheme.displayLarge),
      displayMedium: maname(textStyle: textTheme.displayMedium),
      displaySmall: maname(textStyle: textTheme.displaySmall),
      headlineLarge: maname(textStyle: textTheme.headlineLarge),
      headlineMedium: maname(textStyle: textTheme.headlineMedium),
      headlineSmall: maname(textStyle: textTheme.headlineSmall),
      titleLarge: maname(textStyle: textTheme.titleLarge),
      titleMedium: maname(textStyle: textTheme.titleMedium),
      titleSmall: maname(textStyle: textTheme.titleSmall),
      bodyLarge: maname(textStyle: textTheme.bodyLarge),
      bodyMedium: maname(textStyle: textTheme.bodyMedium),
      bodySmall: maname(textStyle: textTheme.bodySmall),
      labelLarge: maname(textStyle: textTheme.labelLarge),
      labelMedium: maname(textStyle: textTheme.labelMedium),
      labelSmall: maname(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mandali font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mandali
  static TextStyle mandali({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b547a68a72360554fae63a56f9cb4aadb6f734a81981a69390cab5c81558264e',
        360000,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mandali',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mandali font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mandali
  static TextTheme mandaliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mandali(textStyle: textTheme.displayLarge),
      displayMedium: mandali(textStyle: textTheme.displayMedium),
      displaySmall: mandali(textStyle: textTheme.displaySmall),
      headlineLarge: mandali(textStyle: textTheme.headlineLarge),
      headlineMedium: mandali(textStyle: textTheme.headlineMedium),
      headlineSmall: mandali(textStyle: textTheme.headlineSmall),
      titleLarge: mandali(textStyle: textTheme.titleLarge),
      titleMedium: mandali(textStyle: textTheme.titleMedium),
      titleSmall: mandali(textStyle: textTheme.titleSmall),
      bodyLarge: mandali(textStyle: textTheme.bodyLarge),
      bodyMedium: mandali(textStyle: textTheme.bodyMedium),
      bodySmall: mandali(textStyle: textTheme.bodySmall),
      labelLarge: mandali(textStyle: textTheme.labelLarge),
      labelMedium: mandali(textStyle: textTheme.labelMedium),
      labelSmall: mandali(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Manjari font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manjari
  static TextStyle manjari({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '912dd96e0a4f620b091ddf0e154220a191455b2d2500f8081f4a5d2bf81d9f4e',
        150024,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b730261f430d77bbc874d87833cc835f746bdb385e26074d70155749f4033af9',
        148744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ddd0cc5aebc7972bc4729f41527b85ebb63bd559b74d773ad92b4848e0f6f00f',
        148388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Manjari',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Manjari font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manjari
  static TextTheme manjariTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: manjari(textStyle: textTheme.displayLarge),
      displayMedium: manjari(textStyle: textTheme.displayMedium),
      displaySmall: manjari(textStyle: textTheme.displaySmall),
      headlineLarge: manjari(textStyle: textTheme.headlineLarge),
      headlineMedium: manjari(textStyle: textTheme.headlineMedium),
      headlineSmall: manjari(textStyle: textTheme.headlineSmall),
      titleLarge: manjari(textStyle: textTheme.titleLarge),
      titleMedium: manjari(textStyle: textTheme.titleMedium),
      titleSmall: manjari(textStyle: textTheme.titleSmall),
      bodyLarge: manjari(textStyle: textTheme.bodyLarge),
      bodyMedium: manjari(textStyle: textTheme.bodyMedium),
      bodySmall: manjari(textStyle: textTheme.bodySmall),
      labelLarge: manjari(textStyle: textTheme.labelLarge),
      labelMedium: manjari(textStyle: textTheme.labelMedium),
      labelSmall: manjari(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Manrope font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manrope
  static TextStyle manrope({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c4e536af6f237f3d6628bffc40fdb3cc118fcf8c2d3884d116c96cdc3990123a',
        94848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0eb7e6d332784315d565e6c1f4e39bfb0d9b9a6de73503619697d172b532607e',
        94856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1ddeeeff9fe3d294f709f2239557278930f56dab89db1fe535dc5c35cd67e0ee',
        94948,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'acdd0ae608f0e024750c98bb1c4e76c13e31ad2b848eb8da7fcd783c051abafa',
        95036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8791ca409cf36b8b2842e40b6b1cd5b42cca064b4fdf24e30f5611536793429d',
        95072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7793683898d8a0e4c97ec50116fc021d053f2f72113982076a50a9048f101b5',
        94904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6b753fbbbefcdfd17909197147c199d6ebc1cd79742e853bc1e732bc9f49831b',
        95664,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Manrope',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Manrope font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manrope
  static TextTheme manropeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: manrope(textStyle: textTheme.displayLarge),
      displayMedium: manrope(textStyle: textTheme.displayMedium),
      displaySmall: manrope(textStyle: textTheme.displaySmall),
      headlineLarge: manrope(textStyle: textTheme.headlineLarge),
      headlineMedium: manrope(textStyle: textTheme.headlineMedium),
      headlineSmall: manrope(textStyle: textTheme.headlineSmall),
      titleLarge: manrope(textStyle: textTheme.titleLarge),
      titleMedium: manrope(textStyle: textTheme.titleMedium),
      titleSmall: manrope(textStyle: textTheme.titleSmall),
      bodyLarge: manrope(textStyle: textTheme.bodyLarge),
      bodyMedium: manrope(textStyle: textTheme.bodyMedium),
      bodySmall: manrope(textStyle: textTheme.bodySmall),
      labelLarge: manrope(textStyle: textTheme.labelLarge),
      labelMedium: manrope(textStyle: textTheme.labelMedium),
      labelSmall: manrope(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mansalva font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mansalva
  static TextStyle mansalva({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b7d3dd68f1a6df3e9c3c1194ace764159fee2498338d3b8af8d4fdb7e52767b',
        252920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mansalva',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mansalva font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mansalva
  static TextTheme mansalvaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mansalva(textStyle: textTheme.displayLarge),
      displayMedium: mansalva(textStyle: textTheme.displayMedium),
      displaySmall: mansalva(textStyle: textTheme.displaySmall),
      headlineLarge: mansalva(textStyle: textTheme.headlineLarge),
      headlineMedium: mansalva(textStyle: textTheme.headlineMedium),
      headlineSmall: mansalva(textStyle: textTheme.headlineSmall),
      titleLarge: mansalva(textStyle: textTheme.titleLarge),
      titleMedium: mansalva(textStyle: textTheme.titleMedium),
      titleSmall: mansalva(textStyle: textTheme.titleSmall),
      bodyLarge: mansalva(textStyle: textTheme.bodyLarge),
      bodyMedium: mansalva(textStyle: textTheme.bodyMedium),
      bodySmall: mansalva(textStyle: textTheme.bodySmall),
      labelLarge: mansalva(textStyle: textTheme.labelLarge),
      labelMedium: mansalva(textStyle: textTheme.labelMedium),
      labelSmall: mansalva(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Manuale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manuale
  static TextStyle manuale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b6da7c1c212dbfcb71ad3dd44341b13fd54afbe4a7a34f98fc52d86d49602f28',
        74956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c885b9f20d8346e5588747e207fd286ba0a28edf5f077c03c3eaa8f2ffbf263c',
        74784,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '435319e8023dc7cc4313894af87bda5112cfb48c89d5e6b0136194f6bdccb0bf',
        75444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c61ce6e57adb89b67ed50deaa2eb60f7c87749d54c91d6ab2d2e21f6d2b9df72',
        75532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6f9f56542a5004d0b878c20967c2edeb817a8cce8e15ab10fc54ce13d0018d2',
        75376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11f2f937d9729a4afdbf443ec0675386e7eeb1e0fb62e18736273715c528dfba',
        75488,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f5de4826304296707efc5837bb471a204812429e27d8072921a3694615d42583',
        81672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '38e8c4553e9c440264325ff129711b490cb63481941c6e030a836b921c131f37',
        81400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ef1ad858b85fb1e2c93d14752e384ea1a7808ffa9df94581cf9fe11466e7129c',
        81632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bab07681c9ea17f95ee63d6b9f4ed0be6cce8b7a5d268ae7c8aab323d909de0d',
        81608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f6e37a4ff988049634bcecf17052618654ff44505f32e131f8bf960fe9cbacd0',
        81484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd533674a678fea81f2543129aee800f3eeb4b76a533d9f5ad57d86e4672ea543',
        81948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Manuale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Manuale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Manuale
  static TextTheme manualeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: manuale(textStyle: textTheme.displayLarge),
      displayMedium: manuale(textStyle: textTheme.displayMedium),
      displaySmall: manuale(textStyle: textTheme.displaySmall),
      headlineLarge: manuale(textStyle: textTheme.headlineLarge),
      headlineMedium: manuale(textStyle: textTheme.headlineMedium),
      headlineSmall: manuale(textStyle: textTheme.headlineSmall),
      titleLarge: manuale(textStyle: textTheme.titleLarge),
      titleMedium: manuale(textStyle: textTheme.titleMedium),
      titleSmall: manuale(textStyle: textTheme.titleSmall),
      bodyLarge: manuale(textStyle: textTheme.bodyLarge),
      bodyMedium: manuale(textStyle: textTheme.bodyMedium),
      bodySmall: manuale(textStyle: textTheme.bodySmall),
      labelLarge: manuale(textStyle: textTheme.labelLarge),
      labelMedium: manuale(textStyle: textTheme.labelMedium),
      labelSmall: manuale(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marcellus font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marcellus
  static TextStyle marcellus({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6f05260db1b8d311fbfd6c413618fe64261ff8d19d00b6415bf01cb211363f9',
        42760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Marcellus',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marcellus font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marcellus
  static TextTheme marcellusTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marcellus(textStyle: textTheme.displayLarge),
      displayMedium: marcellus(textStyle: textTheme.displayMedium),
      displaySmall: marcellus(textStyle: textTheme.displaySmall),
      headlineLarge: marcellus(textStyle: textTheme.headlineLarge),
      headlineMedium: marcellus(textStyle: textTheme.headlineMedium),
      headlineSmall: marcellus(textStyle: textTheme.headlineSmall),
      titleLarge: marcellus(textStyle: textTheme.titleLarge),
      titleMedium: marcellus(textStyle: textTheme.titleMedium),
      titleSmall: marcellus(textStyle: textTheme.titleSmall),
      bodyLarge: marcellus(textStyle: textTheme.bodyLarge),
      bodyMedium: marcellus(textStyle: textTheme.bodyMedium),
      bodySmall: marcellus(textStyle: textTheme.bodySmall),
      labelLarge: marcellus(textStyle: textTheme.labelLarge),
      labelMedium: marcellus(textStyle: textTheme.labelMedium),
      labelSmall: marcellus(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marcellus SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marcellus+SC
  static TextStyle marcellusSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0b9db8e80985afac4ce5a8a218672d0e819465ec4bea036f50c65f0400f32d32',
        43936,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MarcellusSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marcellus SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marcellus+SC
  static TextTheme marcellusScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marcellusSc(textStyle: textTheme.displayLarge),
      displayMedium: marcellusSc(textStyle: textTheme.displayMedium),
      displaySmall: marcellusSc(textStyle: textTheme.displaySmall),
      headlineLarge: marcellusSc(textStyle: textTheme.headlineLarge),
      headlineMedium: marcellusSc(textStyle: textTheme.headlineMedium),
      headlineSmall: marcellusSc(textStyle: textTheme.headlineSmall),
      titleLarge: marcellusSc(textStyle: textTheme.titleLarge),
      titleMedium: marcellusSc(textStyle: textTheme.titleMedium),
      titleSmall: marcellusSc(textStyle: textTheme.titleSmall),
      bodyLarge: marcellusSc(textStyle: textTheme.bodyLarge),
      bodyMedium: marcellusSc(textStyle: textTheme.bodyMedium),
      bodySmall: marcellusSc(textStyle: textTheme.bodySmall),
      labelLarge: marcellusSc(textStyle: textTheme.labelLarge),
      labelMedium: marcellusSc(textStyle: textTheme.labelMedium),
      labelSmall: marcellusSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marck Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marck+Script
  static TextStyle marckScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4cea442ff203ca3e590f00f4f98c1e879742979974df977735cd658c1452219d',
        81184,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MarckScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marck Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marck+Script
  static TextTheme marckScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marckScript(textStyle: textTheme.displayLarge),
      displayMedium: marckScript(textStyle: textTheme.displayMedium),
      displaySmall: marckScript(textStyle: textTheme.displaySmall),
      headlineLarge: marckScript(textStyle: textTheme.headlineLarge),
      headlineMedium: marckScript(textStyle: textTheme.headlineMedium),
      headlineSmall: marckScript(textStyle: textTheme.headlineSmall),
      titleLarge: marckScript(textStyle: textTheme.titleLarge),
      titleMedium: marckScript(textStyle: textTheme.titleMedium),
      titleSmall: marckScript(textStyle: textTheme.titleSmall),
      bodyLarge: marckScript(textStyle: textTheme.bodyLarge),
      bodyMedium: marckScript(textStyle: textTheme.bodyMedium),
      bodySmall: marckScript(textStyle: textTheme.bodySmall),
      labelLarge: marckScript(textStyle: textTheme.labelLarge),
      labelMedium: marckScript(textStyle: textTheme.labelMedium),
      labelSmall: marckScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Margarine font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Margarine
  static TextStyle margarine({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '27203d30148332203ac274969146d0317fcf010676d440870055be319a2f8dde',
        146292,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Margarine',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Margarine font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Margarine
  static TextTheme margarineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: margarine(textStyle: textTheme.displayLarge),
      displayMedium: margarine(textStyle: textTheme.displayMedium),
      displaySmall: margarine(textStyle: textTheme.displaySmall),
      headlineLarge: margarine(textStyle: textTheme.headlineLarge),
      headlineMedium: margarine(textStyle: textTheme.headlineMedium),
      headlineSmall: margarine(textStyle: textTheme.headlineSmall),
      titleLarge: margarine(textStyle: textTheme.titleLarge),
      titleMedium: margarine(textStyle: textTheme.titleMedium),
      titleSmall: margarine(textStyle: textTheme.titleSmall),
      bodyLarge: margarine(textStyle: textTheme.bodyLarge),
      bodyMedium: margarine(textStyle: textTheme.bodyMedium),
      bodySmall: margarine(textStyle: textTheme.bodySmall),
      labelLarge: margarine(textStyle: textTheme.labelLarge),
      labelMedium: margarine(textStyle: textTheme.labelMedium),
      labelSmall: margarine(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marhey font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marhey
  static TextStyle marhey({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7472ca5f9dea40b389363347ee6fd3983c1847066c8e62f76a010f28f917f4b7',
        87732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98d1392297a778029859c22f1baa745a94813f7e0222dd17ef9e091fff906ead',
        87988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6f0210f4d3200dbaea6000e79718eff9a7362e79d3ce6349016fd2f2d8f9e27a',
        88028,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '129db27c74bc18afd66bd089086274343977f05d57a98db0ac544db509cbd09b',
        87992,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f6ed41362777f37de14979b6ffc20f353009e17a6d5638df864e1aace36c9d4',
        87564,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Marhey',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marhey font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marhey
  static TextTheme marheyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marhey(textStyle: textTheme.displayLarge),
      displayMedium: marhey(textStyle: textTheme.displayMedium),
      displaySmall: marhey(textStyle: textTheme.displaySmall),
      headlineLarge: marhey(textStyle: textTheme.headlineLarge),
      headlineMedium: marhey(textStyle: textTheme.headlineMedium),
      headlineSmall: marhey(textStyle: textTheme.headlineSmall),
      titleLarge: marhey(textStyle: textTheme.titleLarge),
      titleMedium: marhey(textStyle: textTheme.titleMedium),
      titleSmall: marhey(textStyle: textTheme.titleSmall),
      bodyLarge: marhey(textStyle: textTheme.bodyLarge),
      bodyMedium: marhey(textStyle: textTheme.bodyMedium),
      bodySmall: marhey(textStyle: textTheme.bodySmall),
      labelLarge: marhey(textStyle: textTheme.labelLarge),
      labelMedium: marhey(textStyle: textTheme.labelMedium),
      labelSmall: marhey(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Markazi Text font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Markazi+Text
  static TextStyle markaziText({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6d2bc5bd4968b56eb52180a8a8339ee3d3e1ad45959346d21aaf60c77efbb3e',
        181652,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '04650079edb659a98f59bd049e61bdab5b6ee308bf37395da939def2e89078b7',
        182228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '314d9938abb40f310dd0692e85357cd469aacd90c7ced9a3671e4716ea7d1d36',
        182384,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c095094dfedb6ad1ea57c8160cffc87f04e8dc21868cdc0bc85c0299c97a69ba',
        181896,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MarkaziText',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Markazi Text font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Markazi+Text
  static TextTheme markaziTextTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: markaziText(textStyle: textTheme.displayLarge),
      displayMedium: markaziText(textStyle: textTheme.displayMedium),
      displaySmall: markaziText(textStyle: textTheme.displaySmall),
      headlineLarge: markaziText(textStyle: textTheme.headlineLarge),
      headlineMedium: markaziText(textStyle: textTheme.headlineMedium),
      headlineSmall: markaziText(textStyle: textTheme.headlineSmall),
      titleLarge: markaziText(textStyle: textTheme.titleLarge),
      titleMedium: markaziText(textStyle: textTheme.titleMedium),
      titleSmall: markaziText(textStyle: textTheme.titleSmall),
      bodyLarge: markaziText(textStyle: textTheme.bodyLarge),
      bodyMedium: markaziText(textStyle: textTheme.bodyMedium),
      bodySmall: markaziText(textStyle: textTheme.bodySmall),
      labelLarge: markaziText(textStyle: textTheme.labelLarge),
      labelMedium: markaziText(textStyle: textTheme.labelMedium),
      labelSmall: markaziText(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marko One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marko+One
  static TextStyle markoOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f5c2204df5073443754f4a94242b8156011db717d3fb4d5f787e92377f4425dc',
        31400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MarkoOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marko One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marko+One
  static TextTheme markoOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: markoOne(textStyle: textTheme.displayLarge),
      displayMedium: markoOne(textStyle: textTheme.displayMedium),
      displaySmall: markoOne(textStyle: textTheme.displaySmall),
      headlineLarge: markoOne(textStyle: textTheme.headlineLarge),
      headlineMedium: markoOne(textStyle: textTheme.headlineMedium),
      headlineSmall: markoOne(textStyle: textTheme.headlineSmall),
      titleLarge: markoOne(textStyle: textTheme.titleLarge),
      titleMedium: markoOne(textStyle: textTheme.titleMedium),
      titleSmall: markoOne(textStyle: textTheme.titleSmall),
      bodyLarge: markoOne(textStyle: textTheme.bodyLarge),
      bodyMedium: markoOne(textStyle: textTheme.bodyMedium),
      bodySmall: markoOne(textStyle: textTheme.bodySmall),
      labelLarge: markoOne(textStyle: textTheme.labelLarge),
      labelMedium: markoOne(textStyle: textTheme.labelMedium),
      labelSmall: markoOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marmelad font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marmelad
  static TextStyle marmelad({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bdab526e548c546c6e74f16e1ddf6ba4165b2b209338fe76365f1432e1c75461',
        102584,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Marmelad',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marmelad font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marmelad
  static TextTheme marmeladTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marmelad(textStyle: textTheme.displayLarge),
      displayMedium: marmelad(textStyle: textTheme.displayMedium),
      displaySmall: marmelad(textStyle: textTheme.displaySmall),
      headlineLarge: marmelad(textStyle: textTheme.headlineLarge),
      headlineMedium: marmelad(textStyle: textTheme.headlineMedium),
      headlineSmall: marmelad(textStyle: textTheme.headlineSmall),
      titleLarge: marmelad(textStyle: textTheme.titleLarge),
      titleMedium: marmelad(textStyle: textTheme.titleMedium),
      titleSmall: marmelad(textStyle: textTheme.titleSmall),
      bodyLarge: marmelad(textStyle: textTheme.bodyLarge),
      bodyMedium: marmelad(textStyle: textTheme.bodyMedium),
      bodySmall: marmelad(textStyle: textTheme.bodySmall),
      labelLarge: marmelad(textStyle: textTheme.labelLarge),
      labelMedium: marmelad(textStyle: textTheme.labelMedium),
      labelSmall: marmelad(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Martel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martel
  static TextStyle martel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5aedff049f47432d5bc55609bd160c14fddfc4e7bce3b99ab66c513944d2f5f2',
        116348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c1251c4a8136bedaa31d989e2cda1a560e456d2057e91de1d204ab98b1c6463',
        117716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8adbf3fa5b35501a50259ab0c6e6020f00e47e0d97c05056489e035ecd1baedd',
        117388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5d76e2da471f54a8c54a7e3a9febc2654e89662413637194b3a3e0d8bb12ff4d',
        116792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e4e26aa98302344d9038fcca7cafb7c53f045fcc3a62735bc8659e5031e6bb4',
        117084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2f9c046a570d0136e3b46a7b526e199ee97813b795cc1954ac9d46dce261191a',
        117668,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd193d53d55ba7eef6866c0c460860547b6067f7e5c81641280eaeeae03cc764e',
        111108,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Martel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Martel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martel
  static TextTheme martelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: martel(textStyle: textTheme.displayLarge),
      displayMedium: martel(textStyle: textTheme.displayMedium),
      displaySmall: martel(textStyle: textTheme.displaySmall),
      headlineLarge: martel(textStyle: textTheme.headlineLarge),
      headlineMedium: martel(textStyle: textTheme.headlineMedium),
      headlineSmall: martel(textStyle: textTheme.headlineSmall),
      titleLarge: martel(textStyle: textTheme.titleLarge),
      titleMedium: martel(textStyle: textTheme.titleMedium),
      titleSmall: martel(textStyle: textTheme.titleSmall),
      bodyLarge: martel(textStyle: textTheme.bodyLarge),
      bodyMedium: martel(textStyle: textTheme.bodyMedium),
      bodySmall: martel(textStyle: textTheme.bodySmall),
      labelLarge: martel(textStyle: textTheme.labelLarge),
      labelMedium: martel(textStyle: textTheme.labelMedium),
      labelSmall: martel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Martel Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martel+Sans
  static TextStyle martelSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '946a77a7d247e32a867bb2bf78b60f8f508316ec538db0bfd64404f1cf348a2e',
        103364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eff28d226dce152ac6d813d98dafd3a4c61e48c2488f3ec8733e619a95cd3149',
        103164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c2e9e43aa4c4eeeb72156224cc974c76aea6bfc823fbe06cba43ee0a68d7c83',
        103204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7cc76f594b6a70a789a3033dae000253f17bee5520916d58844f757e9eccad77',
        102412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e891003a14a61306190e57c296d138bb1e82d6d5b0e0d16ddd77014c051c258',
        102480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '22000a4ef8aeefb782118341587a66ff946bed19ca74f6772abe15cd4d3f4052',
        102276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90b518ae39d6e75cdd97395592da90c6e586768e291de0b616459432194f52f2',
        101916,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MartelSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Martel Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martel+Sans
  static TextTheme martelSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: martelSans(textStyle: textTheme.displayLarge),
      displayMedium: martelSans(textStyle: textTheme.displayMedium),
      displaySmall: martelSans(textStyle: textTheme.displaySmall),
      headlineLarge: martelSans(textStyle: textTheme.headlineLarge),
      headlineMedium: martelSans(textStyle: textTheme.headlineMedium),
      headlineSmall: martelSans(textStyle: textTheme.headlineSmall),
      titleLarge: martelSans(textStyle: textTheme.titleLarge),
      titleMedium: martelSans(textStyle: textTheme.titleMedium),
      titleSmall: martelSans(textStyle: textTheme.titleSmall),
      bodyLarge: martelSans(textStyle: textTheme.bodyLarge),
      bodyMedium: martelSans(textStyle: textTheme.bodyMedium),
      bodySmall: martelSans(textStyle: textTheme.bodySmall),
      labelLarge: martelSans(textStyle: textTheme.labelLarge),
      labelMedium: martelSans(textStyle: textTheme.labelMedium),
      labelSmall: martelSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Martian Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martian+Mono
  static TextStyle martianMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee3a1e93a190bb35c840b40e2b0c3f49be8add837fd39fae07000b16bb1d002b',
        45720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1672bd8247b8b1f8bb653bdd644661dbcf8cb8cf0327629af3432194c115f5d2',
        45820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8088bad5d5d8a0c275863dd4b70e1f68292709dfd8a1fd625328e2abed89e737',
        45792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e1ceec8c702ae07952ac8b8c5210cfc87330d5a6b3212dd2b1095fe791986168',
        45760,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '128a24312a4b778dae8a5a104b64b440173abda479d48b7af7c881c5663dcc54',
        46228,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7ed9dc3b074b82dc879a55323546bdbbca30c556c4f161012cc438deca9eeceb',
        46240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e88fce9ffe5848513fa2dda3ca197461e41e81c8445bcc7ee71d49393db9274',
        46212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55403a5aaad859a75ee49da8f522c8f7229e0428f3f08dbfeaeb774c54217746',
        46232,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MartianMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Martian Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Martian+Mono
  static TextTheme martianMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: martianMono(textStyle: textTheme.displayLarge),
      displayMedium: martianMono(textStyle: textTheme.displayMedium),
      displaySmall: martianMono(textStyle: textTheme.displaySmall),
      headlineLarge: martianMono(textStyle: textTheme.headlineLarge),
      headlineMedium: martianMono(textStyle: textTheme.headlineMedium),
      headlineSmall: martianMono(textStyle: textTheme.headlineSmall),
      titleLarge: martianMono(textStyle: textTheme.titleLarge),
      titleMedium: martianMono(textStyle: textTheme.titleMedium),
      titleSmall: martianMono(textStyle: textTheme.titleSmall),
      bodyLarge: martianMono(textStyle: textTheme.bodyLarge),
      bodyMedium: martianMono(textStyle: textTheme.bodyMedium),
      bodySmall: martianMono(textStyle: textTheme.bodySmall),
      labelLarge: martianMono(textStyle: textTheme.labelLarge),
      labelMedium: martianMono(textStyle: textTheme.labelMedium),
      labelSmall: martianMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Marvel font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marvel
  static TextStyle marvel({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c812f7eb4c1e4f8d0fad441726d98c747de375ad22895470ebcd413c1416b19',
        36432,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '77c0d261c2da1b6153219577e19c4032946322cd5d66cf6f4002dae08b49bfc4',
        38864,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e4e4978487b15aaf06db92d917a56779cc283820422b7c1402dfd9fee556a91c',
        35184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1cd2737de4cf25ab72fef57ffe64b3c7de8b40269accd99e4d9976dd7522bda5',
        38252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Marvel',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Marvel font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Marvel
  static TextTheme marvelTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: marvel(textStyle: textTheme.displayLarge),
      displayMedium: marvel(textStyle: textTheme.displayMedium),
      displaySmall: marvel(textStyle: textTheme.displaySmall),
      headlineLarge: marvel(textStyle: textTheme.headlineLarge),
      headlineMedium: marvel(textStyle: textTheme.headlineMedium),
      headlineSmall: marvel(textStyle: textTheme.headlineSmall),
      titleLarge: marvel(textStyle: textTheme.titleLarge),
      titleMedium: marvel(textStyle: textTheme.titleMedium),
      titleSmall: marvel(textStyle: textTheme.titleSmall),
      bodyLarge: marvel(textStyle: textTheme.bodyLarge),
      bodyMedium: marvel(textStyle: textTheme.bodyMedium),
      bodySmall: marvel(textStyle: textTheme.bodySmall),
      labelLarge: marvel(textStyle: textTheme.labelLarge),
      labelMedium: marvel(textStyle: textTheme.labelMedium),
      labelSmall: marvel(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mate font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mate
  static TextStyle mate({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fd3304dc2b1dd4c326f05e442c40eb17607a1adda9a11e994081456a638d5a8e',
        42956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5b6664851984aa4850b4333b116c2a85227e83000b6eee0f25e16bad054a26e3',
        43224,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mate',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mate font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mate
  static TextTheme mateTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mate(textStyle: textTheme.displayLarge),
      displayMedium: mate(textStyle: textTheme.displayMedium),
      displaySmall: mate(textStyle: textTheme.displaySmall),
      headlineLarge: mate(textStyle: textTheme.headlineLarge),
      headlineMedium: mate(textStyle: textTheme.headlineMedium),
      headlineSmall: mate(textStyle: textTheme.headlineSmall),
      titleLarge: mate(textStyle: textTheme.titleLarge),
      titleMedium: mate(textStyle: textTheme.titleMedium),
      titleSmall: mate(textStyle: textTheme.titleSmall),
      bodyLarge: mate(textStyle: textTheme.bodyLarge),
      bodyMedium: mate(textStyle: textTheme.bodyMedium),
      bodySmall: mate(textStyle: textTheme.bodySmall),
      labelLarge: mate(textStyle: textTheme.labelLarge),
      labelMedium: mate(textStyle: textTheme.labelMedium),
      labelSmall: mate(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mate SC font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mate+SC
  static TextStyle mateSc({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd092c6f116320499fb1deb7f4a8c8a61a3460bf81cf0aec509bbf0d773d9b2c6',
        46196,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MateSC',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mate SC font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mate+SC
  static TextTheme mateScTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mateSc(textStyle: textTheme.displayLarge),
      displayMedium: mateSc(textStyle: textTheme.displayMedium),
      displaySmall: mateSc(textStyle: textTheme.displaySmall),
      headlineLarge: mateSc(textStyle: textTheme.headlineLarge),
      headlineMedium: mateSc(textStyle: textTheme.headlineMedium),
      headlineSmall: mateSc(textStyle: textTheme.headlineSmall),
      titleLarge: mateSc(textStyle: textTheme.titleLarge),
      titleMedium: mateSc(textStyle: textTheme.titleMedium),
      titleSmall: mateSc(textStyle: textTheme.titleSmall),
      bodyLarge: mateSc(textStyle: textTheme.bodyLarge),
      bodyMedium: mateSc(textStyle: textTheme.bodyMedium),
      bodySmall: mateSc(textStyle: textTheme.bodySmall),
      labelLarge: mateSc(textStyle: textTheme.labelLarge),
      labelMedium: mateSc(textStyle: textTheme.labelMedium),
      labelSmall: mateSc(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Maven Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maven+Pro
  static TextStyle mavenPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cff6d2faab4e1443c98ab65dbd46e7a4cdb95c7b878e05133e87d1d7ee1eaa9b',
        55108,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6aabf01e4ab29617eccfa33ad2dcc824748fdb2d48dc942faaf00dd714d2ea11',
        55372,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0f5674fc63985fd29a6ed673d481601bea3f6dcb73c3c3fe7181d56cce36306c',
        55532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '197f84b13c8d13b767e420a5f6614ec71bab53082e6c3e32ed20b49aba27aaf8',
        55424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eb06ab3ba78bcd2c455d522c684995a312593f327cc227050cd22b8f698b6001',
        55536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4fa0953f17de65bfe3ddae2e0eb9a0ae57e915b7f04e81361cf6f7b3b7bac2a2',
        55448,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MavenPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Maven Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Maven+Pro
  static TextTheme mavenProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mavenPro(textStyle: textTheme.displayLarge),
      displayMedium: mavenPro(textStyle: textTheme.displayMedium),
      displaySmall: mavenPro(textStyle: textTheme.displaySmall),
      headlineLarge: mavenPro(textStyle: textTheme.headlineLarge),
      headlineMedium: mavenPro(textStyle: textTheme.headlineMedium),
      headlineSmall: mavenPro(textStyle: textTheme.headlineSmall),
      titleLarge: mavenPro(textStyle: textTheme.titleLarge),
      titleMedium: mavenPro(textStyle: textTheme.titleMedium),
      titleSmall: mavenPro(textStyle: textTheme.titleSmall),
      bodyLarge: mavenPro(textStyle: textTheme.bodyLarge),
      bodyMedium: mavenPro(textStyle: textTheme.bodyMedium),
      bodySmall: mavenPro(textStyle: textTheme.bodySmall),
      labelLarge: mavenPro(textStyle: textTheme.labelLarge),
      labelMedium: mavenPro(textStyle: textTheme.labelMedium),
      labelSmall: mavenPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the McLaren font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/McLaren
  static TextStyle mcLaren({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bc647b683dd86f7af168e13748ced9571415848d658b82879f2c6c33be0b5b60',
        52032,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'McLaren',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the McLaren font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/McLaren
  static TextTheme mcLarenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mcLaren(textStyle: textTheme.displayLarge),
      displayMedium: mcLaren(textStyle: textTheme.displayMedium),
      displaySmall: mcLaren(textStyle: textTheme.displaySmall),
      headlineLarge: mcLaren(textStyle: textTheme.headlineLarge),
      headlineMedium: mcLaren(textStyle: textTheme.headlineMedium),
      headlineSmall: mcLaren(textStyle: textTheme.headlineSmall),
      titleLarge: mcLaren(textStyle: textTheme.titleLarge),
      titleMedium: mcLaren(textStyle: textTheme.titleMedium),
      titleSmall: mcLaren(textStyle: textTheme.titleSmall),
      bodyLarge: mcLaren(textStyle: textTheme.bodyLarge),
      bodyMedium: mcLaren(textStyle: textTheme.bodyMedium),
      bodySmall: mcLaren(textStyle: textTheme.bodySmall),
      labelLarge: mcLaren(textStyle: textTheme.labelLarge),
      labelMedium: mcLaren(textStyle: textTheme.labelMedium),
      labelSmall: mcLaren(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mea Culpa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mea+Culpa
  static TextStyle meaCulpa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6c1c4b0c2a33c0b9edb5884159ec560686a2cde9a1687d82c8931dfd1c33af4',
        108468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MeaCulpa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mea Culpa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mea+Culpa
  static TextTheme meaCulpaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: meaCulpa(textStyle: textTheme.displayLarge),
      displayMedium: meaCulpa(textStyle: textTheme.displayMedium),
      displaySmall: meaCulpa(textStyle: textTheme.displaySmall),
      headlineLarge: meaCulpa(textStyle: textTheme.headlineLarge),
      headlineMedium: meaCulpa(textStyle: textTheme.headlineMedium),
      headlineSmall: meaCulpa(textStyle: textTheme.headlineSmall),
      titleLarge: meaCulpa(textStyle: textTheme.titleLarge),
      titleMedium: meaCulpa(textStyle: textTheme.titleMedium),
      titleSmall: meaCulpa(textStyle: textTheme.titleSmall),
      bodyLarge: meaCulpa(textStyle: textTheme.bodyLarge),
      bodyMedium: meaCulpa(textStyle: textTheme.bodyMedium),
      bodySmall: meaCulpa(textStyle: textTheme.bodySmall),
      labelLarge: meaCulpa(textStyle: textTheme.labelLarge),
      labelMedium: meaCulpa(textStyle: textTheme.labelMedium),
      labelSmall: meaCulpa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Meddon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meddon
  static TextStyle meddon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4ce0174bf339e2ccbb3f546b3fa0b6493a519905a7e56652159e57bcbbf45821',
        63120,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Meddon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Meddon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meddon
  static TextTheme meddonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: meddon(textStyle: textTheme.displayLarge),
      displayMedium: meddon(textStyle: textTheme.displayMedium),
      displaySmall: meddon(textStyle: textTheme.displaySmall),
      headlineLarge: meddon(textStyle: textTheme.headlineLarge),
      headlineMedium: meddon(textStyle: textTheme.headlineMedium),
      headlineSmall: meddon(textStyle: textTheme.headlineSmall),
      titleLarge: meddon(textStyle: textTheme.titleLarge),
      titleMedium: meddon(textStyle: textTheme.titleMedium),
      titleSmall: meddon(textStyle: textTheme.titleSmall),
      bodyLarge: meddon(textStyle: textTheme.bodyLarge),
      bodyMedium: meddon(textStyle: textTheme.bodyMedium),
      bodySmall: meddon(textStyle: textTheme.bodySmall),
      labelLarge: meddon(textStyle: textTheme.labelLarge),
      labelMedium: meddon(textStyle: textTheme.labelMedium),
      labelSmall: meddon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the MedievalSharp font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MedievalSharp
  static TextStyle medievalSharp({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09581df75e93630b414ee30b25281e4a961596987ad4cdd162f3e8c05442baf8',
        48248,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MedievalSharp',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the MedievalSharp font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MedievalSharp
  static TextTheme medievalSharpTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: medievalSharp(textStyle: textTheme.displayLarge),
      displayMedium: medievalSharp(textStyle: textTheme.displayMedium),
      displaySmall: medievalSharp(textStyle: textTheme.displaySmall),
      headlineLarge: medievalSharp(textStyle: textTheme.headlineLarge),
      headlineMedium: medievalSharp(textStyle: textTheme.headlineMedium),
      headlineSmall: medievalSharp(textStyle: textTheme.headlineSmall),
      titleLarge: medievalSharp(textStyle: textTheme.titleLarge),
      titleMedium: medievalSharp(textStyle: textTheme.titleMedium),
      titleSmall: medievalSharp(textStyle: textTheme.titleSmall),
      bodyLarge: medievalSharp(textStyle: textTheme.bodyLarge),
      bodyMedium: medievalSharp(textStyle: textTheme.bodyMedium),
      bodySmall: medievalSharp(textStyle: textTheme.bodySmall),
      labelLarge: medievalSharp(textStyle: textTheme.labelLarge),
      labelMedium: medievalSharp(textStyle: textTheme.labelMedium),
      labelSmall: medievalSharp(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Medula One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Medula+One
  static TextStyle medulaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c14d4658cacf3a579c80cfc423df8e6941dd1eca33fe74d9004b9bd9b2cb34a',
        31792,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MedulaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Medula One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Medula+One
  static TextTheme medulaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: medulaOne(textStyle: textTheme.displayLarge),
      displayMedium: medulaOne(textStyle: textTheme.displayMedium),
      displaySmall: medulaOne(textStyle: textTheme.displaySmall),
      headlineLarge: medulaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: medulaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: medulaOne(textStyle: textTheme.headlineSmall),
      titleLarge: medulaOne(textStyle: textTheme.titleLarge),
      titleMedium: medulaOne(textStyle: textTheme.titleMedium),
      titleSmall: medulaOne(textStyle: textTheme.titleSmall),
      bodyLarge: medulaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: medulaOne(textStyle: textTheme.bodyMedium),
      bodySmall: medulaOne(textStyle: textTheme.bodySmall),
      labelLarge: medulaOne(textStyle: textTheme.labelLarge),
      labelMedium: medulaOne(textStyle: textTheme.labelMedium),
      labelSmall: medulaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Meera Inimai font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meera+Inimai
  static TextStyle meeraInimai({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '40a06b1e0bf3b4a399c40716a6dd04acc5d0d5d416f6310ec45c3b8efa4d8352',
        70828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MeeraInimai',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Meera Inimai font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meera+Inimai
  static TextTheme meeraInimaiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: meeraInimai(textStyle: textTheme.displayLarge),
      displayMedium: meeraInimai(textStyle: textTheme.displayMedium),
      displaySmall: meeraInimai(textStyle: textTheme.displaySmall),
      headlineLarge: meeraInimai(textStyle: textTheme.headlineLarge),
      headlineMedium: meeraInimai(textStyle: textTheme.headlineMedium),
      headlineSmall: meeraInimai(textStyle: textTheme.headlineSmall),
      titleLarge: meeraInimai(textStyle: textTheme.titleLarge),
      titleMedium: meeraInimai(textStyle: textTheme.titleMedium),
      titleSmall: meeraInimai(textStyle: textTheme.titleSmall),
      bodyLarge: meeraInimai(textStyle: textTheme.bodyLarge),
      bodyMedium: meeraInimai(textStyle: textTheme.bodyMedium),
      bodySmall: meeraInimai(textStyle: textTheme.bodySmall),
      labelLarge: meeraInimai(textStyle: textTheme.labelLarge),
      labelMedium: meeraInimai(textStyle: textTheme.labelMedium),
      labelSmall: meeraInimai(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Megrim font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Megrim
  static TextStyle megrim({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1329617d0583eddd45a722377ffbe312d6ac084943ddfd923025eea820980c1c',
        30136,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Megrim',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Megrim font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Megrim
  static TextTheme megrimTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: megrim(textStyle: textTheme.displayLarge),
      displayMedium: megrim(textStyle: textTheme.displayMedium),
      displaySmall: megrim(textStyle: textTheme.displaySmall),
      headlineLarge: megrim(textStyle: textTheme.headlineLarge),
      headlineMedium: megrim(textStyle: textTheme.headlineMedium),
      headlineSmall: megrim(textStyle: textTheme.headlineSmall),
      titleLarge: megrim(textStyle: textTheme.titleLarge),
      titleMedium: megrim(textStyle: textTheme.titleMedium),
      titleSmall: megrim(textStyle: textTheme.titleSmall),
      bodyLarge: megrim(textStyle: textTheme.bodyLarge),
      bodyMedium: megrim(textStyle: textTheme.bodyMedium),
      bodySmall: megrim(textStyle: textTheme.bodySmall),
      labelLarge: megrim(textStyle: textTheme.labelLarge),
      labelMedium: megrim(textStyle: textTheme.labelMedium),
      labelSmall: megrim(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Meie Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meie+Script
  static TextStyle meieScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f475b7a7297bda996a975870f9696e21f31d4c1048ac19d6b456c901867769e',
        52328,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MeieScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Meie Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meie+Script
  static TextTheme meieScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: meieScript(textStyle: textTheme.displayLarge),
      displayMedium: meieScript(textStyle: textTheme.displayMedium),
      displaySmall: meieScript(textStyle: textTheme.displaySmall),
      headlineLarge: meieScript(textStyle: textTheme.headlineLarge),
      headlineMedium: meieScript(textStyle: textTheme.headlineMedium),
      headlineSmall: meieScript(textStyle: textTheme.headlineSmall),
      titleLarge: meieScript(textStyle: textTheme.titleLarge),
      titleMedium: meieScript(textStyle: textTheme.titleMedium),
      titleSmall: meieScript(textStyle: textTheme.titleSmall),
      bodyLarge: meieScript(textStyle: textTheme.bodyLarge),
      bodyMedium: meieScript(textStyle: textTheme.bodyMedium),
      bodySmall: meieScript(textStyle: textTheme.bodySmall),
      labelLarge: meieScript(textStyle: textTheme.labelLarge),
      labelMedium: meieScript(textStyle: textTheme.labelMedium),
      labelSmall: meieScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Meow Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meow+Script
  static TextStyle meowScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1efb4e3f7d02119a4e3ae8a858cedb1187379d54d09c2944e9010796a913f129',
        101276,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MeowScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Meow Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Meow+Script
  static TextTheme meowScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: meowScript(textStyle: textTheme.displayLarge),
      displayMedium: meowScript(textStyle: textTheme.displayMedium),
      displaySmall: meowScript(textStyle: textTheme.displaySmall),
      headlineLarge: meowScript(textStyle: textTheme.headlineLarge),
      headlineMedium: meowScript(textStyle: textTheme.headlineMedium),
      headlineSmall: meowScript(textStyle: textTheme.headlineSmall),
      titleLarge: meowScript(textStyle: textTheme.titleLarge),
      titleMedium: meowScript(textStyle: textTheme.titleMedium),
      titleSmall: meowScript(textStyle: textTheme.titleSmall),
      bodyLarge: meowScript(textStyle: textTheme.bodyLarge),
      bodyMedium: meowScript(textStyle: textTheme.bodyMedium),
      bodySmall: meowScript(textStyle: textTheme.bodySmall),
      labelLarge: meowScript(textStyle: textTheme.labelLarge),
      labelMedium: meowScript(textStyle: textTheme.labelMedium),
      labelSmall: meowScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Merienda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merienda
  static TextStyle merienda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '973c851f8366eab47ff4866ad952412e0fe056e82d9cd13be8e97613125ff94c',
        85304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90f10cac7a7d3aca2f838e74e7e6c87b48195c0376dadbf0c2a46249f9bb1bec',
        85244,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '177313e827c6d4a1c2ca7b71c81971d75044f387d5a92c2d5f4156c3703451f4',
        85280,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c8ca5a866e81962090f6d3e656744b14c8f0a889cd5749b20614bfa787d6029c',
        85288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b29437136f583497052318a85ad9af036e3ec017ab1259220ab4232d95a6d9e',
        87844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09ef324455a8cbcc32a8c881fb97b498f063b78f49258298f10d4f2be087de77',
        88256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10059eb15378f73ec0c9cd3f06d762078f0930ef52ac731bb34ca50c107eca09',
        88016,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Merienda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Merienda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merienda
  static TextTheme meriendaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: merienda(textStyle: textTheme.displayLarge),
      displayMedium: merienda(textStyle: textTheme.displayMedium),
      displaySmall: merienda(textStyle: textTheme.displaySmall),
      headlineLarge: merienda(textStyle: textTheme.headlineLarge),
      headlineMedium: merienda(textStyle: textTheme.headlineMedium),
      headlineSmall: merienda(textStyle: textTheme.headlineSmall),
      titleLarge: merienda(textStyle: textTheme.titleLarge),
      titleMedium: merienda(textStyle: textTheme.titleMedium),
      titleSmall: merienda(textStyle: textTheme.titleSmall),
      bodyLarge: merienda(textStyle: textTheme.bodyLarge),
      bodyMedium: merienda(textStyle: textTheme.bodyMedium),
      bodySmall: merienda(textStyle: textTheme.bodySmall),
      labelLarge: merienda(textStyle: textTheme.labelLarge),
      labelMedium: merienda(textStyle: textTheme.labelMedium),
      labelSmall: merienda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Merriweather font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merriweather
  static TextStyle merriweather({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1391d9ac253f0609fc463ed7cf7c7f8ac16ac148535eab73f9e6ed568be7ed6c',
        94096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4f7010dc410bfdc0e5a335d9a26304fe2445f5b6540b1018c852de17816b07ac',
        96632,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17eea3c23dedc67e39cc162b4f95c5927f415be23f01181d6441a821401f2e40',
        94360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a01ca4baf4746b17b8c5c2e403ac0943ad6e2af8451c1651ea770f16cf8c06e0',
        96368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5ffd149f337f5b52c2f4fcc0de5d543697fceac78b416e230def6b7c02c81ea9',
        94016,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ba796e3f7bbbf053447975f5e4e72ae4a8c01a0c109a688bc7d80836c6270344',
        96204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0c0a81948fc4e537d93d6b935abe73b2a89ec9cfd6d9c48bf9787c8627aaf16c',
        94052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ddc6eda15dc3b4c34cf815954a5ee4af26282332b5baf09c8a938143d7ae956b',
        95804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Merriweather',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Merriweather font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merriweather
  static TextTheme merriweatherTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: merriweather(textStyle: textTheme.displayLarge),
      displayMedium: merriweather(textStyle: textTheme.displayMedium),
      displaySmall: merriweather(textStyle: textTheme.displaySmall),
      headlineLarge: merriweather(textStyle: textTheme.headlineLarge),
      headlineMedium: merriweather(textStyle: textTheme.headlineMedium),
      headlineSmall: merriweather(textStyle: textTheme.headlineSmall),
      titleLarge: merriweather(textStyle: textTheme.titleLarge),
      titleMedium: merriweather(textStyle: textTheme.titleMedium),
      titleSmall: merriweather(textStyle: textTheme.titleSmall),
      bodyLarge: merriweather(textStyle: textTheme.bodyLarge),
      bodyMedium: merriweather(textStyle: textTheme.bodyMedium),
      bodySmall: merriweather(textStyle: textTheme.bodySmall),
      labelLarge: merriweather(textStyle: textTheme.labelLarge),
      labelMedium: merriweather(textStyle: textTheme.labelMedium),
      labelSmall: merriweather(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Merriweather Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merriweather+Sans
  static TextStyle merriweatherSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b564199cc15670ea9c92d2dfe33ae17d15c7f7653cc03dc7ac144a3ceb21c9c9',
        90984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7235ec430595023c3a5de6533be2be11132a1d39a8fc5e10d7906ab2c997e646',
        91132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d33c5f3a9a4563288d26cdbdc0ad773a5a56655c52ce2918ddcbece4f264229',
        91132,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebb7f592714fd85ec4e493146e45e1c447b51ef66c4456c74efe1dca2ffd3b6f',
        91292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ee87dd589179b4f6975eb114a4edf724af5c31c87ba77bbab3b8e433ddf36b88',
        91224,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ebd96d3571e8b1daae4334b2cc890a4b69506ae4b82e34773d68d650a38b4b3f',
        91188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '56ffc23c38f799def2d167383e4ab1cd74d4fad8a7661c42849010c115889f0d',
        79872,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8f85bdb130da9e6fc59715c46a87b2fa8f145ba984adb931abfb582e4b4a28b9',
        79788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '49d997f7fd3a37940fbe85c6fd86d130ad7ad90fd9e258a7cb5f5f25ad703a7e',
        79920,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '205028f9db92e4b50f4cab9c038bb95b176f0bc781645e3a35e1818522d17cbc',
        79988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '370ff2a6479065e9b92a4020ba5460c520433f6f4aed30d55a20b4a9f280f026',
        79976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fc796dc395d9867478b803258c955636a6b709710059749695818ed9fcd6edd4',
        80084,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MerriweatherSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Merriweather Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Merriweather+Sans
  static TextTheme merriweatherSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: merriweatherSans(textStyle: textTheme.displayLarge),
      displayMedium: merriweatherSans(textStyle: textTheme.displayMedium),
      displaySmall: merriweatherSans(textStyle: textTheme.displaySmall),
      headlineLarge: merriweatherSans(textStyle: textTheme.headlineLarge),
      headlineMedium: merriweatherSans(textStyle: textTheme.headlineMedium),
      headlineSmall: merriweatherSans(textStyle: textTheme.headlineSmall),
      titleLarge: merriweatherSans(textStyle: textTheme.titleLarge),
      titleMedium: merriweatherSans(textStyle: textTheme.titleMedium),
      titleSmall: merriweatherSans(textStyle: textTheme.titleSmall),
      bodyLarge: merriweatherSans(textStyle: textTheme.bodyLarge),
      bodyMedium: merriweatherSans(textStyle: textTheme.bodyMedium),
      bodySmall: merriweatherSans(textStyle: textTheme.bodySmall),
      labelLarge: merriweatherSans(textStyle: textTheme.labelLarge),
      labelMedium: merriweatherSans(textStyle: textTheme.labelMedium),
      labelSmall: merriweatherSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Metal font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metal
  static TextStyle metal({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2976291ccca91f54e948221ac8bf1d64f04e11209a5ec31ed792f8a80cf2acaf',
        97388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Metal',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Metal font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metal
  static TextTheme metalTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: metal(textStyle: textTheme.displayLarge),
      displayMedium: metal(textStyle: textTheme.displayMedium),
      displaySmall: metal(textStyle: textTheme.displaySmall),
      headlineLarge: metal(textStyle: textTheme.headlineLarge),
      headlineMedium: metal(textStyle: textTheme.headlineMedium),
      headlineSmall: metal(textStyle: textTheme.headlineSmall),
      titleLarge: metal(textStyle: textTheme.titleLarge),
      titleMedium: metal(textStyle: textTheme.titleMedium),
      titleSmall: metal(textStyle: textTheme.titleSmall),
      bodyLarge: metal(textStyle: textTheme.bodyLarge),
      bodyMedium: metal(textStyle: textTheme.bodyMedium),
      bodySmall: metal(textStyle: textTheme.bodySmall),
      labelLarge: metal(textStyle: textTheme.labelLarge),
      labelMedium: metal(textStyle: textTheme.labelMedium),
      labelSmall: metal(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Metal Mania font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metal+Mania
  static TextStyle metalMania({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d4503a6087a6180b1d58db0994d6883a20a70cbfd00db57454ce722c23167d6',
        207960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MetalMania',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Metal Mania font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metal+Mania
  static TextTheme metalManiaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: metalMania(textStyle: textTheme.displayLarge),
      displayMedium: metalMania(textStyle: textTheme.displayMedium),
      displaySmall: metalMania(textStyle: textTheme.displaySmall),
      headlineLarge: metalMania(textStyle: textTheme.headlineLarge),
      headlineMedium: metalMania(textStyle: textTheme.headlineMedium),
      headlineSmall: metalMania(textStyle: textTheme.headlineSmall),
      titleLarge: metalMania(textStyle: textTheme.titleLarge),
      titleMedium: metalMania(textStyle: textTheme.titleMedium),
      titleSmall: metalMania(textStyle: textTheme.titleSmall),
      bodyLarge: metalMania(textStyle: textTheme.bodyLarge),
      bodyMedium: metalMania(textStyle: textTheme.bodyMedium),
      bodySmall: metalMania(textStyle: textTheme.bodySmall),
      labelLarge: metalMania(textStyle: textTheme.labelLarge),
      labelMedium: metalMania(textStyle: textTheme.labelMedium),
      labelSmall: metalMania(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Metamorphous font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metamorphous
  static TextStyle metamorphous({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24545f706312cbba7740c627e8fc6d5bce78826c8bb4518789c26a6d042f608e',
        63740,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Metamorphous',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Metamorphous font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metamorphous
  static TextTheme metamorphousTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: metamorphous(textStyle: textTheme.displayLarge),
      displayMedium: metamorphous(textStyle: textTheme.displayMedium),
      displaySmall: metamorphous(textStyle: textTheme.displaySmall),
      headlineLarge: metamorphous(textStyle: textTheme.headlineLarge),
      headlineMedium: metamorphous(textStyle: textTheme.headlineMedium),
      headlineSmall: metamorphous(textStyle: textTheme.headlineSmall),
      titleLarge: metamorphous(textStyle: textTheme.titleLarge),
      titleMedium: metamorphous(textStyle: textTheme.titleMedium),
      titleSmall: metamorphous(textStyle: textTheme.titleSmall),
      bodyLarge: metamorphous(textStyle: textTheme.bodyLarge),
      bodyMedium: metamorphous(textStyle: textTheme.bodyMedium),
      bodySmall: metamorphous(textStyle: textTheme.bodySmall),
      labelLarge: metamorphous(textStyle: textTheme.labelLarge),
      labelMedium: metamorphous(textStyle: textTheme.labelMedium),
      labelSmall: metamorphous(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Metrophobic font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metrophobic
  static TextStyle metrophobic({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cd53fb289615b83816543371563bcb44f7d97811b40805b0df924eceb85791e',
        53212,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Metrophobic',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Metrophobic font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Metrophobic
  static TextTheme metrophobicTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: metrophobic(textStyle: textTheme.displayLarge),
      displayMedium: metrophobic(textStyle: textTheme.displayMedium),
      displaySmall: metrophobic(textStyle: textTheme.displaySmall),
      headlineLarge: metrophobic(textStyle: textTheme.headlineLarge),
      headlineMedium: metrophobic(textStyle: textTheme.headlineMedium),
      headlineSmall: metrophobic(textStyle: textTheme.headlineSmall),
      titleLarge: metrophobic(textStyle: textTheme.titleLarge),
      titleMedium: metrophobic(textStyle: textTheme.titleMedium),
      titleSmall: metrophobic(textStyle: textTheme.titleSmall),
      bodyLarge: metrophobic(textStyle: textTheme.bodyLarge),
      bodyMedium: metrophobic(textStyle: textTheme.bodyMedium),
      bodySmall: metrophobic(textStyle: textTheme.bodySmall),
      labelLarge: metrophobic(textStyle: textTheme.labelLarge),
      labelMedium: metrophobic(textStyle: textTheme.labelMedium),
      labelSmall: metrophobic(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Michroma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Michroma
  static TextStyle michroma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0d1ea1ca814a899cc37ee9911e002839364050784edb274f98c587ebbb7364ad',
        40968,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Michroma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Michroma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Michroma
  static TextTheme michromaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: michroma(textStyle: textTheme.displayLarge),
      displayMedium: michroma(textStyle: textTheme.displayMedium),
      displaySmall: michroma(textStyle: textTheme.displaySmall),
      headlineLarge: michroma(textStyle: textTheme.headlineLarge),
      headlineMedium: michroma(textStyle: textTheme.headlineMedium),
      headlineSmall: michroma(textStyle: textTheme.headlineSmall),
      titleLarge: michroma(textStyle: textTheme.titleLarge),
      titleMedium: michroma(textStyle: textTheme.titleMedium),
      titleSmall: michroma(textStyle: textTheme.titleSmall),
      bodyLarge: michroma(textStyle: textTheme.bodyLarge),
      bodyMedium: michroma(textStyle: textTheme.bodyMedium),
      bodySmall: michroma(textStyle: textTheme.bodySmall),
      labelLarge: michroma(textStyle: textTheme.labelLarge),
      labelMedium: michroma(textStyle: textTheme.labelMedium),
      labelSmall: michroma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Micro 5 font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Micro+5
  static TextStyle micro5({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d6a10e6f6e482711ca62d3ad933005b8dd9aa33c1bbe6a3dd04fe49109a46b0',
        37096,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Micro5',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Micro 5 font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Micro+5
  static TextTheme micro5TextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: micro5(textStyle: textTheme.displayLarge),
      displayMedium: micro5(textStyle: textTheme.displayMedium),
      displaySmall: micro5(textStyle: textTheme.displaySmall),
      headlineLarge: micro5(textStyle: textTheme.headlineLarge),
      headlineMedium: micro5(textStyle: textTheme.headlineMedium),
      headlineSmall: micro5(textStyle: textTheme.headlineSmall),
      titleLarge: micro5(textStyle: textTheme.titleLarge),
      titleMedium: micro5(textStyle: textTheme.titleMedium),
      titleSmall: micro5(textStyle: textTheme.titleSmall),
      bodyLarge: micro5(textStyle: textTheme.bodyLarge),
      bodyMedium: micro5(textStyle: textTheme.bodyMedium),
      bodySmall: micro5(textStyle: textTheme.bodySmall),
      labelLarge: micro5(textStyle: textTheme.labelLarge),
      labelMedium: micro5(textStyle: textTheme.labelMedium),
      labelSmall: micro5(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Micro 5 Charted font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Micro+5+Charted
  static TextStyle micro5Charted({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5291e426ab7d3a332f6d0f3541740a5dfa1e9c077f35ffabd7104b242dd65a8e',
        92512,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Micro5Charted',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Micro 5 Charted font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Micro+5+Charted
  static TextTheme micro5ChartedTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: micro5Charted(textStyle: textTheme.displayLarge),
      displayMedium: micro5Charted(textStyle: textTheme.displayMedium),
      displaySmall: micro5Charted(textStyle: textTheme.displaySmall),
      headlineLarge: micro5Charted(textStyle: textTheme.headlineLarge),
      headlineMedium: micro5Charted(textStyle: textTheme.headlineMedium),
      headlineSmall: micro5Charted(textStyle: textTheme.headlineSmall),
      titleLarge: micro5Charted(textStyle: textTheme.titleLarge),
      titleMedium: micro5Charted(textStyle: textTheme.titleMedium),
      titleSmall: micro5Charted(textStyle: textTheme.titleSmall),
      bodyLarge: micro5Charted(textStyle: textTheme.bodyLarge),
      bodyMedium: micro5Charted(textStyle: textTheme.bodyMedium),
      bodySmall: micro5Charted(textStyle: textTheme.bodySmall),
      labelLarge: micro5Charted(textStyle: textTheme.labelLarge),
      labelMedium: micro5Charted(textStyle: textTheme.labelMedium),
      labelSmall: micro5Charted(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Milonga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Milonga
  static TextStyle milonga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9500dc1f81dda0985dc9350b611732af23024ce21b28836c1dd49c6cb7e4cd8',
        120176,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Milonga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Milonga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Milonga
  static TextTheme milongaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: milonga(textStyle: textTheme.displayLarge),
      displayMedium: milonga(textStyle: textTheme.displayMedium),
      displaySmall: milonga(textStyle: textTheme.displaySmall),
      headlineLarge: milonga(textStyle: textTheme.headlineLarge),
      headlineMedium: milonga(textStyle: textTheme.headlineMedium),
      headlineSmall: milonga(textStyle: textTheme.headlineSmall),
      titleLarge: milonga(textStyle: textTheme.titleLarge),
      titleMedium: milonga(textStyle: textTheme.titleMedium),
      titleSmall: milonga(textStyle: textTheme.titleSmall),
      bodyLarge: milonga(textStyle: textTheme.bodyLarge),
      bodyMedium: milonga(textStyle: textTheme.bodyMedium),
      bodySmall: milonga(textStyle: textTheme.bodySmall),
      labelLarge: milonga(textStyle: textTheme.labelLarge),
      labelMedium: milonga(textStyle: textTheme.labelMedium),
      labelSmall: milonga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Miltonian font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miltonian
  static TextStyle miltonian({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '058e31c550d73076d28f8265333b1d0c9836babb5cb97c4faa388d60ddb19575',
        90836,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Miltonian',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Miltonian font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miltonian
  static TextTheme miltonianTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: miltonian(textStyle: textTheme.displayLarge),
      displayMedium: miltonian(textStyle: textTheme.displayMedium),
      displaySmall: miltonian(textStyle: textTheme.displaySmall),
      headlineLarge: miltonian(textStyle: textTheme.headlineLarge),
      headlineMedium: miltonian(textStyle: textTheme.headlineMedium),
      headlineSmall: miltonian(textStyle: textTheme.headlineSmall),
      titleLarge: miltonian(textStyle: textTheme.titleLarge),
      titleMedium: miltonian(textStyle: textTheme.titleMedium),
      titleSmall: miltonian(textStyle: textTheme.titleSmall),
      bodyLarge: miltonian(textStyle: textTheme.bodyLarge),
      bodyMedium: miltonian(textStyle: textTheme.bodyMedium),
      bodySmall: miltonian(textStyle: textTheme.bodySmall),
      labelLarge: miltonian(textStyle: textTheme.labelLarge),
      labelMedium: miltonian(textStyle: textTheme.labelMedium),
      labelSmall: miltonian(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Miltonian Tattoo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miltonian+Tattoo
  static TextStyle miltonianTattoo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2db2078ee159402807f5b24f63faa4089b7805c704cb3ec289b8fec2115cc171',
        68524,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MiltonianTattoo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Miltonian Tattoo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miltonian+Tattoo
  static TextTheme miltonianTattooTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: miltonianTattoo(textStyle: textTheme.displayLarge),
      displayMedium: miltonianTattoo(textStyle: textTheme.displayMedium),
      displaySmall: miltonianTattoo(textStyle: textTheme.displaySmall),
      headlineLarge: miltonianTattoo(textStyle: textTheme.headlineLarge),
      headlineMedium: miltonianTattoo(textStyle: textTheme.headlineMedium),
      headlineSmall: miltonianTattoo(textStyle: textTheme.headlineSmall),
      titleLarge: miltonianTattoo(textStyle: textTheme.titleLarge),
      titleMedium: miltonianTattoo(textStyle: textTheme.titleMedium),
      titleSmall: miltonianTattoo(textStyle: textTheme.titleSmall),
      bodyLarge: miltonianTattoo(textStyle: textTheme.bodyLarge),
      bodyMedium: miltonianTattoo(textStyle: textTheme.bodyMedium),
      bodySmall: miltonianTattoo(textStyle: textTheme.bodySmall),
      labelLarge: miltonianTattoo(textStyle: textTheme.labelLarge),
      labelMedium: miltonianTattoo(textStyle: textTheme.labelMedium),
      labelSmall: miltonianTattoo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mina
  static TextStyle mina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '308655f148986df4abc69e3d2ed7b9dc68a2da9a2775b23ed5b770001c17d52d',
        147136,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b36a41caeb6d32dd48fb88879056a737b272ab418000ab399b5dfb12696d62b',
        148492,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mina
  static TextTheme minaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mina(textStyle: textTheme.displayLarge),
      displayMedium: mina(textStyle: textTheme.displayMedium),
      displaySmall: mina(textStyle: textTheme.displaySmall),
      headlineLarge: mina(textStyle: textTheme.headlineLarge),
      headlineMedium: mina(textStyle: textTheme.headlineMedium),
      headlineSmall: mina(textStyle: textTheme.headlineSmall),
      titleLarge: mina(textStyle: textTheme.titleLarge),
      titleMedium: mina(textStyle: textTheme.titleMedium),
      titleSmall: mina(textStyle: textTheme.titleSmall),
      bodyLarge: mina(textStyle: textTheme.bodyLarge),
      bodyMedium: mina(textStyle: textTheme.bodyMedium),
      bodySmall: mina(textStyle: textTheme.bodySmall),
      labelLarge: mina(textStyle: textTheme.labelLarge),
      labelMedium: mina(textStyle: textTheme.labelMedium),
      labelSmall: mina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mingzat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mingzat
  static TextStyle mingzat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dc664cbe60ea241e8c160c2fc5fa296c014fb5efbc2dcf37b0cb709ffc75f20b',
        155536,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mingzat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mingzat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mingzat
  static TextTheme mingzatTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mingzat(textStyle: textTheme.displayLarge),
      displayMedium: mingzat(textStyle: textTheme.displayMedium),
      displaySmall: mingzat(textStyle: textTheme.displaySmall),
      headlineLarge: mingzat(textStyle: textTheme.headlineLarge),
      headlineMedium: mingzat(textStyle: textTheme.headlineMedium),
      headlineSmall: mingzat(textStyle: textTheme.headlineSmall),
      titleLarge: mingzat(textStyle: textTheme.titleLarge),
      titleMedium: mingzat(textStyle: textTheme.titleMedium),
      titleSmall: mingzat(textStyle: textTheme.titleSmall),
      bodyLarge: mingzat(textStyle: textTheme.bodyLarge),
      bodyMedium: mingzat(textStyle: textTheme.bodyMedium),
      bodySmall: mingzat(textStyle: textTheme.bodySmall),
      labelLarge: mingzat(textStyle: textTheme.labelLarge),
      labelMedium: mingzat(textStyle: textTheme.labelMedium),
      labelSmall: mingzat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Miniver font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miniver
  static TextStyle miniver({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48e1c5e1dbc02887953fba2bd3b26589614ad9db10ee89318c74548242cb3588',
        43804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Miniver',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Miniver font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miniver
  static TextTheme miniverTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: miniver(textStyle: textTheme.displayLarge),
      displayMedium: miniver(textStyle: textTheme.displayMedium),
      displaySmall: miniver(textStyle: textTheme.displaySmall),
      headlineLarge: miniver(textStyle: textTheme.headlineLarge),
      headlineMedium: miniver(textStyle: textTheme.headlineMedium),
      headlineSmall: miniver(textStyle: textTheme.headlineSmall),
      titleLarge: miniver(textStyle: textTheme.titleLarge),
      titleMedium: miniver(textStyle: textTheme.titleMedium),
      titleSmall: miniver(textStyle: textTheme.titleSmall),
      bodyLarge: miniver(textStyle: textTheme.bodyLarge),
      bodyMedium: miniver(textStyle: textTheme.bodyMedium),
      bodySmall: miniver(textStyle: textTheme.bodySmall),
      labelLarge: miniver(textStyle: textTheme.labelLarge),
      labelMedium: miniver(textStyle: textTheme.labelMedium),
      labelSmall: miniver(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Miriam Libre font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miriam+Libre
  static TextStyle miriamLibre({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '516dc4ec0e287fbb605d4fd5425c2cde6e1340231003c8d0a776d0692bef39f8',
        67072,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b084a6d235b628f1aa766d8ddb381504ec1a3cd0f24caa5671cebb766ae498be',
        64540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MiriamLibre',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Miriam Libre font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miriam+Libre
  static TextTheme miriamLibreTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: miriamLibre(textStyle: textTheme.displayLarge),
      displayMedium: miriamLibre(textStyle: textTheme.displayMedium),
      displaySmall: miriamLibre(textStyle: textTheme.displaySmall),
      headlineLarge: miriamLibre(textStyle: textTheme.headlineLarge),
      headlineMedium: miriamLibre(textStyle: textTheme.headlineMedium),
      headlineSmall: miriamLibre(textStyle: textTheme.headlineSmall),
      titleLarge: miriamLibre(textStyle: textTheme.titleLarge),
      titleMedium: miriamLibre(textStyle: textTheme.titleMedium),
      titleSmall: miriamLibre(textStyle: textTheme.titleSmall),
      bodyLarge: miriamLibre(textStyle: textTheme.bodyLarge),
      bodyMedium: miriamLibre(textStyle: textTheme.bodyMedium),
      bodySmall: miriamLibre(textStyle: textTheme.bodySmall),
      labelLarge: miriamLibre(textStyle: textTheme.labelLarge),
      labelMedium: miriamLibre(textStyle: textTheme.labelMedium),
      labelSmall: miriamLibre(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mirza font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mirza
  static TextStyle mirza({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eae426c67e83ab76ff813bcb8277c2032de3f535d2c325dc99073e33b4875eb6',
        153264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13eb0fc1138f944931041705dcc627d5d569e4ec61971fe134569d6390420b70',
        152660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '84ca43ddb7a330d4247623340902550c45041cb2719ae6c48dc6ec7926823de4',
        152604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf098fb2f3cffe9f8b3c35353c0d4fbc121a814de8ab8dbe2e1358498a52e740',
        152580,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mirza',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mirza font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mirza
  static TextTheme mirzaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mirza(textStyle: textTheme.displayLarge),
      displayMedium: mirza(textStyle: textTheme.displayMedium),
      displaySmall: mirza(textStyle: textTheme.displaySmall),
      headlineLarge: mirza(textStyle: textTheme.headlineLarge),
      headlineMedium: mirza(textStyle: textTheme.headlineMedium),
      headlineSmall: mirza(textStyle: textTheme.headlineSmall),
      titleLarge: mirza(textStyle: textTheme.titleLarge),
      titleMedium: mirza(textStyle: textTheme.titleMedium),
      titleSmall: mirza(textStyle: textTheme.titleSmall),
      bodyLarge: mirza(textStyle: textTheme.bodyLarge),
      bodyMedium: mirza(textStyle: textTheme.bodyMedium),
      bodySmall: mirza(textStyle: textTheme.bodySmall),
      labelLarge: mirza(textStyle: textTheme.labelLarge),
      labelMedium: mirza(textStyle: textTheme.labelMedium),
      labelSmall: mirza(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Miss Fajardose font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miss+Fajardose
  static TextStyle missFajardose({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a443fa63baa6db77fd9443bb2e2f84e00fb587b7426ccbfa6d6f21c18f739cb0',
        56960,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MissFajardose',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Miss Fajardose font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Miss+Fajardose
  static TextTheme missFajardoseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: missFajardose(textStyle: textTheme.displayLarge),
      displayMedium: missFajardose(textStyle: textTheme.displayMedium),
      displaySmall: missFajardose(textStyle: textTheme.displaySmall),
      headlineLarge: missFajardose(textStyle: textTheme.headlineLarge),
      headlineMedium: missFajardose(textStyle: textTheme.headlineMedium),
      headlineSmall: missFajardose(textStyle: textTheme.headlineSmall),
      titleLarge: missFajardose(textStyle: textTheme.titleLarge),
      titleMedium: missFajardose(textStyle: textTheme.titleMedium),
      titleSmall: missFajardose(textStyle: textTheme.titleSmall),
      bodyLarge: missFajardose(textStyle: textTheme.bodyLarge),
      bodyMedium: missFajardose(textStyle: textTheme.bodyMedium),
      bodySmall: missFajardose(textStyle: textTheme.bodySmall),
      labelLarge: missFajardose(textStyle: textTheme.labelLarge),
      labelMedium: missFajardose(textStyle: textTheme.labelMedium),
      labelSmall: missFajardose(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mitr font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mitr
  static TextStyle mitr({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3e51272f85885d89720e6be6248fe926d8e56fcc75d9e0d2f5abb6ead1a069f',
        136672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a087f2046c85d59cc4dab8d23cbb70924839fea7e0f7c13e5be48c9257ab37d6',
        142208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8fb9bdc5d1b4552c91499f31580f422a7e13c6c2f160e34173455b7aaa3391a3',
        144096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aad7c67032d0ab210555ee83b104b760f291514f625fa4911979acbafcda0359',
        144076,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9147e12fdb9ec1ea4d1981a343e92386c4e39fd77f16781187bdbde63bebea9',
        143588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6b0c518c8a9dc001751fc9c6ea3126832e28513061b5bf9c24f730a9ae3d0e6',
        144164,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mitr',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mitr font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mitr
  static TextTheme mitrTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mitr(textStyle: textTheme.displayLarge),
      displayMedium: mitr(textStyle: textTheme.displayMedium),
      displaySmall: mitr(textStyle: textTheme.displaySmall),
      headlineLarge: mitr(textStyle: textTheme.headlineLarge),
      headlineMedium: mitr(textStyle: textTheme.headlineMedium),
      headlineSmall: mitr(textStyle: textTheme.headlineSmall),
      titleLarge: mitr(textStyle: textTheme.titleLarge),
      titleMedium: mitr(textStyle: textTheme.titleMedium),
      titleSmall: mitr(textStyle: textTheme.titleSmall),
      bodyLarge: mitr(textStyle: textTheme.bodyLarge),
      bodyMedium: mitr(textStyle: textTheme.bodyMedium),
      bodySmall: mitr(textStyle: textTheme.bodySmall),
      labelLarge: mitr(textStyle: textTheme.labelLarge),
      labelMedium: mitr(textStyle: textTheme.labelMedium),
      labelSmall: mitr(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mochiy Pop One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mochiy+Pop+One
  static TextStyle mochiyPopOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b3e446e96fc83a039c20a4a232c8c086ae025aabceaf4088f6f66455d38b9eab',
        4607440,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MochiyPopOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mochiy Pop One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mochiy+Pop+One
  static TextTheme mochiyPopOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mochiyPopOne(textStyle: textTheme.displayLarge),
      displayMedium: mochiyPopOne(textStyle: textTheme.displayMedium),
      displaySmall: mochiyPopOne(textStyle: textTheme.displaySmall),
      headlineLarge: mochiyPopOne(textStyle: textTheme.headlineLarge),
      headlineMedium: mochiyPopOne(textStyle: textTheme.headlineMedium),
      headlineSmall: mochiyPopOne(textStyle: textTheme.headlineSmall),
      titleLarge: mochiyPopOne(textStyle: textTheme.titleLarge),
      titleMedium: mochiyPopOne(textStyle: textTheme.titleMedium),
      titleSmall: mochiyPopOne(textStyle: textTheme.titleSmall),
      bodyLarge: mochiyPopOne(textStyle: textTheme.bodyLarge),
      bodyMedium: mochiyPopOne(textStyle: textTheme.bodyMedium),
      bodySmall: mochiyPopOne(textStyle: textTheme.bodySmall),
      labelLarge: mochiyPopOne(textStyle: textTheme.labelLarge),
      labelMedium: mochiyPopOne(textStyle: textTheme.labelMedium),
      labelSmall: mochiyPopOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mochiy Pop P One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mochiy+Pop+P+One
  static TextStyle mochiyPopPOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a62cb893321b7a9fa9aae8222bac95585340c5ba1092a41736ca9241dc631284',
        4608112,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MochiyPopPOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mochiy Pop P One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mochiy+Pop+P+One
  static TextTheme mochiyPopPOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mochiyPopPOne(textStyle: textTheme.displayLarge),
      displayMedium: mochiyPopPOne(textStyle: textTheme.displayMedium),
      displaySmall: mochiyPopPOne(textStyle: textTheme.displaySmall),
      headlineLarge: mochiyPopPOne(textStyle: textTheme.headlineLarge),
      headlineMedium: mochiyPopPOne(textStyle: textTheme.headlineMedium),
      headlineSmall: mochiyPopPOne(textStyle: textTheme.headlineSmall),
      titleLarge: mochiyPopPOne(textStyle: textTheme.titleLarge),
      titleMedium: mochiyPopPOne(textStyle: textTheme.titleMedium),
      titleSmall: mochiyPopPOne(textStyle: textTheme.titleSmall),
      bodyLarge: mochiyPopPOne(textStyle: textTheme.bodyLarge),
      bodyMedium: mochiyPopPOne(textStyle: textTheme.bodyMedium),
      bodySmall: mochiyPopPOne(textStyle: textTheme.bodySmall),
      labelLarge: mochiyPopPOne(textStyle: textTheme.labelLarge),
      labelMedium: mochiyPopPOne(textStyle: textTheme.labelMedium),
      labelSmall: mochiyPopPOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Modak font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Modak
  static TextStyle modak({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e0f471287dec95da2ab0508270c51a4d89b5956f8395ed46026e3e8cdeaeb03',
        358468,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Modak',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Modak font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Modak
  static TextTheme modakTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: modak(textStyle: textTheme.displayLarge),
      displayMedium: modak(textStyle: textTheme.displayMedium),
      displaySmall: modak(textStyle: textTheme.displaySmall),
      headlineLarge: modak(textStyle: textTheme.headlineLarge),
      headlineMedium: modak(textStyle: textTheme.headlineMedium),
      headlineSmall: modak(textStyle: textTheme.headlineSmall),
      titleLarge: modak(textStyle: textTheme.titleLarge),
      titleMedium: modak(textStyle: textTheme.titleMedium),
      titleSmall: modak(textStyle: textTheme.titleSmall),
      bodyLarge: modak(textStyle: textTheme.bodyLarge),
      bodyMedium: modak(textStyle: textTheme.bodyMedium),
      bodySmall: modak(textStyle: textTheme.bodySmall),
      labelLarge: modak(textStyle: textTheme.labelLarge),
      labelMedium: modak(textStyle: textTheme.labelMedium),
      labelSmall: modak(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Modern Antiqua font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Modern+Antiqua
  static TextStyle modernAntiqua({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '089a98f06685302f94c23de4663caf7928f2e6f9752e90741a16eb70f37815e1',
        67772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'ModernAntiqua',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Modern Antiqua font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Modern+Antiqua
  static TextTheme modernAntiquaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: modernAntiqua(textStyle: textTheme.displayLarge),
      displayMedium: modernAntiqua(textStyle: textTheme.displayMedium),
      displaySmall: modernAntiqua(textStyle: textTheme.displaySmall),
      headlineLarge: modernAntiqua(textStyle: textTheme.headlineLarge),
      headlineMedium: modernAntiqua(textStyle: textTheme.headlineMedium),
      headlineSmall: modernAntiqua(textStyle: textTheme.headlineSmall),
      titleLarge: modernAntiqua(textStyle: textTheme.titleLarge),
      titleMedium: modernAntiqua(textStyle: textTheme.titleMedium),
      titleSmall: modernAntiqua(textStyle: textTheme.titleSmall),
      bodyLarge: modernAntiqua(textStyle: textTheme.bodyLarge),
      bodyMedium: modernAntiqua(textStyle: textTheme.bodyMedium),
      bodySmall: modernAntiqua(textStyle: textTheme.bodySmall),
      labelLarge: modernAntiqua(textStyle: textTheme.labelLarge),
      labelMedium: modernAntiqua(textStyle: textTheme.labelMedium),
      labelSmall: modernAntiqua(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mogra font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mogra
  static TextStyle mogra({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '68ef6f3c83efa3823e9cd4fd64392022ef1df04760a65d5592a93e800fe39a01',
        227352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mogra',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mogra font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mogra
  static TextTheme mograTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mogra(textStyle: textTheme.displayLarge),
      displayMedium: mogra(textStyle: textTheme.displayMedium),
      displaySmall: mogra(textStyle: textTheme.displaySmall),
      headlineLarge: mogra(textStyle: textTheme.headlineLarge),
      headlineMedium: mogra(textStyle: textTheme.headlineMedium),
      headlineSmall: mogra(textStyle: textTheme.headlineSmall),
      titleLarge: mogra(textStyle: textTheme.titleLarge),
      titleMedium: mogra(textStyle: textTheme.titleMedium),
      titleSmall: mogra(textStyle: textTheme.titleSmall),
      bodyLarge: mogra(textStyle: textTheme.bodyLarge),
      bodyMedium: mogra(textStyle: textTheme.bodyMedium),
      bodySmall: mogra(textStyle: textTheme.bodySmall),
      labelLarge: mogra(textStyle: textTheme.labelLarge),
      labelMedium: mogra(textStyle: textTheme.labelMedium),
      labelSmall: mogra(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mohave font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mohave
  static TextStyle mohave({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a49baf64c2f19b778f995fdfc8881974d0840078ca7da464693c812af3a62e85',
        36972,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b71a8b88f96dc407415eca82c0e0b78ef01a7ebf486966ffa524ec430a1211f6',
        36940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bede2a22a623afd2f551719276ca1b36a107f69d16a2c749cb20febae3cdd78b',
        36956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbc38e1f970a0f65a464bff1fb4a88cdf546291ac15b6fad6ba8565693dc5ac8',
        36984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5faab54689f4357850f9847d89a7c486253ca3ceaed970063bd9f8144d15fe44',
        37100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5c6e1e49fa95a8f1cff64c64e3f9e8deb23eb76133ec3790a128e2416fa6ba9e',
        38768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '13cf06c5d9f6fa0d6853e2f96e0979cd97387acfaaf8fa108372121bd9ae9851',
        38656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c08c76f85c364231343ffce03810afbf1b7d4cb037b0479e9971fd0742f37a36',
        38764,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '1bd2002a329b978b03c7d4ce4149bb94a799586338a1f4fdf2bc79418efdeb8b',
        38796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c66e56532d160bcfebb0945efc8842bde566289d426dfb62275cb1411cf04ef1',
        38868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mohave',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mohave font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mohave
  static TextTheme mohaveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mohave(textStyle: textTheme.displayLarge),
      displayMedium: mohave(textStyle: textTheme.displayMedium),
      displaySmall: mohave(textStyle: textTheme.displaySmall),
      headlineLarge: mohave(textStyle: textTheme.headlineLarge),
      headlineMedium: mohave(textStyle: textTheme.headlineMedium),
      headlineSmall: mohave(textStyle: textTheme.headlineSmall),
      titleLarge: mohave(textStyle: textTheme.titleLarge),
      titleMedium: mohave(textStyle: textTheme.titleMedium),
      titleSmall: mohave(textStyle: textTheme.titleSmall),
      bodyLarge: mohave(textStyle: textTheme.bodyLarge),
      bodyMedium: mohave(textStyle: textTheme.bodyMedium),
      bodySmall: mohave(textStyle: textTheme.bodySmall),
      labelLarge: mohave(textStyle: textTheme.labelLarge),
      labelMedium: mohave(textStyle: textTheme.labelMedium),
      labelSmall: mohave(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Moirai One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moirai+One
  static TextStyle moiraiOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '90f7414971617a32485873ee82a91846c3dfb665d9fbbd86efa20c8a56091add',
        1376360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MoiraiOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Moirai One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moirai+One
  static TextTheme moiraiOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: moiraiOne(textStyle: textTheme.displayLarge),
      displayMedium: moiraiOne(textStyle: textTheme.displayMedium),
      displaySmall: moiraiOne(textStyle: textTheme.displaySmall),
      headlineLarge: moiraiOne(textStyle: textTheme.headlineLarge),
      headlineMedium: moiraiOne(textStyle: textTheme.headlineMedium),
      headlineSmall: moiraiOne(textStyle: textTheme.headlineSmall),
      titleLarge: moiraiOne(textStyle: textTheme.titleLarge),
      titleMedium: moiraiOne(textStyle: textTheme.titleMedium),
      titleSmall: moiraiOne(textStyle: textTheme.titleSmall),
      bodyLarge: moiraiOne(textStyle: textTheme.bodyLarge),
      bodyMedium: moiraiOne(textStyle: textTheme.bodyMedium),
      bodySmall: moiraiOne(textStyle: textTheme.bodySmall),
      labelLarge: moiraiOne(textStyle: textTheme.labelLarge),
      labelMedium: moiraiOne(textStyle: textTheme.labelMedium),
      labelSmall: moiraiOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Molengo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Molengo
  static TextStyle molengo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '944e1051ca81381376eb8e67e8ebe10e8ea1fd3fe9f1c032c0dddcc12a403ea8',
        32528,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Molengo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Molengo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Molengo
  static TextTheme molengoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: molengo(textStyle: textTheme.displayLarge),
      displayMedium: molengo(textStyle: textTheme.displayMedium),
      displaySmall: molengo(textStyle: textTheme.displaySmall),
      headlineLarge: molengo(textStyle: textTheme.headlineLarge),
      headlineMedium: molengo(textStyle: textTheme.headlineMedium),
      headlineSmall: molengo(textStyle: textTheme.headlineSmall),
      titleLarge: molengo(textStyle: textTheme.titleLarge),
      titleMedium: molengo(textStyle: textTheme.titleMedium),
      titleSmall: molengo(textStyle: textTheme.titleSmall),
      bodyLarge: molengo(textStyle: textTheme.bodyLarge),
      bodyMedium: molengo(textStyle: textTheme.bodyMedium),
      bodySmall: molengo(textStyle: textTheme.bodySmall),
      labelLarge: molengo(textStyle: textTheme.labelLarge),
      labelMedium: molengo(textStyle: textTheme.labelMedium),
      labelSmall: molengo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Molle font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Molle
  static TextStyle molle({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '18a53fab2687215001080ee2122268dcdb2e60977bbcc11a720d565b0a81609b',
        33600,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Molle',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Molle font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Molle
  static TextTheme molleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: molle(textStyle: textTheme.displayLarge),
      displayMedium: molle(textStyle: textTheme.displayMedium),
      displaySmall: molle(textStyle: textTheme.displaySmall),
      headlineLarge: molle(textStyle: textTheme.headlineLarge),
      headlineMedium: molle(textStyle: textTheme.headlineMedium),
      headlineSmall: molle(textStyle: textTheme.headlineSmall),
      titleLarge: molle(textStyle: textTheme.titleLarge),
      titleMedium: molle(textStyle: textTheme.titleMedium),
      titleSmall: molle(textStyle: textTheme.titleSmall),
      bodyLarge: molle(textStyle: textTheme.bodyLarge),
      bodyMedium: molle(textStyle: textTheme.bodyMedium),
      bodySmall: molle(textStyle: textTheme.bodySmall),
      labelLarge: molle(textStyle: textTheme.labelLarge),
      labelMedium: molle(textStyle: textTheme.labelMedium),
      labelSmall: molle(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Monda font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monda
  static TextStyle monda({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c9567d0d5f0258199d59666d6b27175b1b23eaa7cbab0b4bd5b32a4c0761c6e',
        84852,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ddd5400c894a0a4489aaa4821521dc5f08936442a17cb2340cc5d570562d29d',
        84804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a8d9aadf90bccf80385466de7756916877d4e8d478d2c05cabd0803e5a5c10f3',
        85140,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e16ebc35d763f9e01097a8f509af98611e0af06958dc29a6f8a9c7e4ac41b2f9',
        84984,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Monda',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Monda font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monda
  static TextTheme mondaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monda(textStyle: textTheme.displayLarge),
      displayMedium: monda(textStyle: textTheme.displayMedium),
      displaySmall: monda(textStyle: textTheme.displaySmall),
      headlineLarge: monda(textStyle: textTheme.headlineLarge),
      headlineMedium: monda(textStyle: textTheme.headlineMedium),
      headlineSmall: monda(textStyle: textTheme.headlineSmall),
      titleLarge: monda(textStyle: textTheme.titleLarge),
      titleMedium: monda(textStyle: textTheme.titleMedium),
      titleSmall: monda(textStyle: textTheme.titleSmall),
      bodyLarge: monda(textStyle: textTheme.bodyLarge),
      bodyMedium: monda(textStyle: textTheme.bodyMedium),
      bodySmall: monda(textStyle: textTheme.bodySmall),
      labelLarge: monda(textStyle: textTheme.labelLarge),
      labelMedium: monda(textStyle: textTheme.labelMedium),
      labelSmall: monda(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Monofett font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monofett
  static TextStyle monofett({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ede18c3fd31791c52437d1d4059369dfa46d368bd19450bf131c19fe0504d0b',
        47652,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Monofett',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Monofett font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monofett
  static TextTheme monofettTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monofett(textStyle: textTheme.displayLarge),
      displayMedium: monofett(textStyle: textTheme.displayMedium),
      displaySmall: monofett(textStyle: textTheme.displaySmall),
      headlineLarge: monofett(textStyle: textTheme.headlineLarge),
      headlineMedium: monofett(textStyle: textTheme.headlineMedium),
      headlineSmall: monofett(textStyle: textTheme.headlineSmall),
      titleLarge: monofett(textStyle: textTheme.titleLarge),
      titleMedium: monofett(textStyle: textTheme.titleMedium),
      titleSmall: monofett(textStyle: textTheme.titleSmall),
      bodyLarge: monofett(textStyle: textTheme.bodyLarge),
      bodyMedium: monofett(textStyle: textTheme.bodyMedium),
      bodySmall: monofett(textStyle: textTheme.bodySmall),
      labelLarge: monofett(textStyle: textTheme.labelLarge),
      labelMedium: monofett(textStyle: textTheme.labelMedium),
      labelSmall: monofett(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Monomaniac One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monomaniac+One
  static TextStyle monomaniacOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd92e587ba4213fd8eea4b26493060fb5af37cee384048446b99bb2c926ed46a4',
        89884,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MonomaniacOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Monomaniac One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monomaniac+One
  static TextTheme monomaniacOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monomaniacOne(textStyle: textTheme.displayLarge),
      displayMedium: monomaniacOne(textStyle: textTheme.displayMedium),
      displaySmall: monomaniacOne(textStyle: textTheme.displaySmall),
      headlineLarge: monomaniacOne(textStyle: textTheme.headlineLarge),
      headlineMedium: monomaniacOne(textStyle: textTheme.headlineMedium),
      headlineSmall: monomaniacOne(textStyle: textTheme.headlineSmall),
      titleLarge: monomaniacOne(textStyle: textTheme.titleLarge),
      titleMedium: monomaniacOne(textStyle: textTheme.titleMedium),
      titleSmall: monomaniacOne(textStyle: textTheme.titleSmall),
      bodyLarge: monomaniacOne(textStyle: textTheme.bodyLarge),
      bodyMedium: monomaniacOne(textStyle: textTheme.bodyMedium),
      bodySmall: monomaniacOne(textStyle: textTheme.bodySmall),
      labelLarge: monomaniacOne(textStyle: textTheme.labelLarge),
      labelMedium: monomaniacOne(textStyle: textTheme.labelMedium),
      labelSmall: monomaniacOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Monoton font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monoton
  static TextStyle monoton({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f0f5db59ecf86dcd9955e90a9b9f81da2365381d9c163f15f3eca10af799784c',
        49744,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Monoton',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Monoton font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monoton
  static TextTheme monotonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monoton(textStyle: textTheme.displayLarge),
      displayMedium: monoton(textStyle: textTheme.displayMedium),
      displaySmall: monoton(textStyle: textTheme.displaySmall),
      headlineLarge: monoton(textStyle: textTheme.headlineLarge),
      headlineMedium: monoton(textStyle: textTheme.headlineMedium),
      headlineSmall: monoton(textStyle: textTheme.headlineSmall),
      titleLarge: monoton(textStyle: textTheme.titleLarge),
      titleMedium: monoton(textStyle: textTheme.titleMedium),
      titleSmall: monoton(textStyle: textTheme.titleSmall),
      bodyLarge: monoton(textStyle: textTheme.bodyLarge),
      bodyMedium: monoton(textStyle: textTheme.bodyMedium),
      bodySmall: monoton(textStyle: textTheme.bodySmall),
      labelLarge: monoton(textStyle: textTheme.labelLarge),
      labelMedium: monoton(textStyle: textTheme.labelMedium),
      labelSmall: monoton(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Monsieur La Doulaise font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monsieur+La+Doulaise
  static TextStyle monsieurLaDoulaise({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd93913127f449891ea28354153dd4f9822e5eac88838c6efef5cdc98a4352395',
        52308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MonsieurLaDoulaise',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Monsieur La Doulaise font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Monsieur+La+Doulaise
  static TextTheme monsieurLaDoulaiseTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monsieurLaDoulaise(textStyle: textTheme.displayLarge),
      displayMedium: monsieurLaDoulaise(textStyle: textTheme.displayMedium),
      displaySmall: monsieurLaDoulaise(textStyle: textTheme.displaySmall),
      headlineLarge: monsieurLaDoulaise(textStyle: textTheme.headlineLarge),
      headlineMedium: monsieurLaDoulaise(textStyle: textTheme.headlineMedium),
      headlineSmall: monsieurLaDoulaise(textStyle: textTheme.headlineSmall),
      titleLarge: monsieurLaDoulaise(textStyle: textTheme.titleLarge),
      titleMedium: monsieurLaDoulaise(textStyle: textTheme.titleMedium),
      titleSmall: monsieurLaDoulaise(textStyle: textTheme.titleSmall),
      bodyLarge: monsieurLaDoulaise(textStyle: textTheme.bodyLarge),
      bodyMedium: monsieurLaDoulaise(textStyle: textTheme.bodyMedium),
      bodySmall: monsieurLaDoulaise(textStyle: textTheme.bodySmall),
      labelLarge: monsieurLaDoulaise(textStyle: textTheme.labelLarge),
      labelMedium: monsieurLaDoulaise(textStyle: textTheme.labelMedium),
      labelSmall: monsieurLaDoulaise(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montaga font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montaga
  static TextStyle montaga({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4805f79b3926b5f56e9bf99a0b83f937b3f44b850e82acbc9dd40d73ae5f49bf',
        31744,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Montaga',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montaga font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montaga
  static TextTheme montagaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montaga(textStyle: textTheme.displayLarge),
      displayMedium: montaga(textStyle: textTheme.displayMedium),
      displaySmall: montaga(textStyle: textTheme.displaySmall),
      headlineLarge: montaga(textStyle: textTheme.headlineLarge),
      headlineMedium: montaga(textStyle: textTheme.headlineMedium),
      headlineSmall: montaga(textStyle: textTheme.headlineSmall),
      titleLarge: montaga(textStyle: textTheme.titleLarge),
      titleMedium: montaga(textStyle: textTheme.titleMedium),
      titleSmall: montaga(textStyle: textTheme.titleSmall),
      bodyLarge: montaga(textStyle: textTheme.bodyLarge),
      bodyMedium: montaga(textStyle: textTheme.bodyMedium),
      bodySmall: montaga(textStyle: textTheme.bodySmall),
      labelLarge: montaga(textStyle: textTheme.labelLarge),
      labelMedium: montaga(textStyle: textTheme.labelMedium),
      labelSmall: montaga(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montagu Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montagu+Slab
  static TextStyle montaguSlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f78adc50c40deed3b19eaab9b46df78afb57d6d9a65d70903de00dd9a4a76e68',
        132460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2c100bdad1a8b9797c402d27a3d0113fac680a02b6c132e5e6709f8a4d57ac7b',
        133188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '206fdb7fb48c2232352a629a360f9ecc3229bf911c2749e3df5edeb862a19385',
        133336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e676210d770ce40c127b1ea4ea8bef007a6c49f0522b2c605fcca38d466c8f8a',
        133340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b2ba75b7e6a1c5f2b3029ccf757127f57041fe1a2095a19188533aa8e118c03e',
        133240,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1160302c7e3d77d5d02f1c83a6280b153cd60548081c8f9a141910fcaede5f8',
        133312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '08abbd082c7498fa416caf63f218077799308a547fd75ec8d3373a730e694a00',
        133284,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MontaguSlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montagu Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montagu+Slab
  static TextTheme montaguSlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montaguSlab(textStyle: textTheme.displayLarge),
      displayMedium: montaguSlab(textStyle: textTheme.displayMedium),
      displaySmall: montaguSlab(textStyle: textTheme.displaySmall),
      headlineLarge: montaguSlab(textStyle: textTheme.headlineLarge),
      headlineMedium: montaguSlab(textStyle: textTheme.headlineMedium),
      headlineSmall: montaguSlab(textStyle: textTheme.headlineSmall),
      titleLarge: montaguSlab(textStyle: textTheme.titleLarge),
      titleMedium: montaguSlab(textStyle: textTheme.titleMedium),
      titleSmall: montaguSlab(textStyle: textTheme.titleSmall),
      bodyLarge: montaguSlab(textStyle: textTheme.bodyLarge),
      bodyMedium: montaguSlab(textStyle: textTheme.bodyMedium),
      bodySmall: montaguSlab(textStyle: textTheme.bodySmall),
      labelLarge: montaguSlab(textStyle: textTheme.labelLarge),
      labelMedium: montaguSlab(textStyle: textTheme.labelMedium),
      labelSmall: montaguSlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the MonteCarlo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MonteCarlo
  static TextStyle monteCarlo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '401369aabb4c1dc598bda326aa11438074d4494665c3f2e2977c723588222aff',
        270604,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MonteCarlo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the MonteCarlo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MonteCarlo
  static TextTheme monteCarloTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: monteCarlo(textStyle: textTheme.displayLarge),
      displayMedium: monteCarlo(textStyle: textTheme.displayMedium),
      displaySmall: monteCarlo(textStyle: textTheme.displaySmall),
      headlineLarge: monteCarlo(textStyle: textTheme.headlineLarge),
      headlineMedium: monteCarlo(textStyle: textTheme.headlineMedium),
      headlineSmall: monteCarlo(textStyle: textTheme.headlineSmall),
      titleLarge: monteCarlo(textStyle: textTheme.titleLarge),
      titleMedium: monteCarlo(textStyle: textTheme.titleMedium),
      titleSmall: monteCarlo(textStyle: textTheme.titleSmall),
      bodyLarge: monteCarlo(textStyle: textTheme.bodyLarge),
      bodyMedium: monteCarlo(textStyle: textTheme.bodyMedium),
      bodySmall: monteCarlo(textStyle: textTheme.bodySmall),
      labelLarge: monteCarlo(textStyle: textTheme.labelLarge),
      labelMedium: monteCarlo(textStyle: textTheme.labelMedium),
      labelSmall: monteCarlo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montez font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montez
  static TextStyle montez({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be95682d583207e7889ae9d7b6a684f4eed3c3333dea2522ba7d8cd2570f93bf',
        60868,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Montez',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montez font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montez
  static TextTheme montezTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montez(textStyle: textTheme.displayLarge),
      displayMedium: montez(textStyle: textTheme.displayMedium),
      displaySmall: montez(textStyle: textTheme.displaySmall),
      headlineLarge: montez(textStyle: textTheme.headlineLarge),
      headlineMedium: montez(textStyle: textTheme.headlineMedium),
      headlineSmall: montez(textStyle: textTheme.headlineSmall),
      titleLarge: montez(textStyle: textTheme.titleLarge),
      titleMedium: montez(textStyle: textTheme.titleMedium),
      titleSmall: montez(textStyle: textTheme.titleSmall),
      bodyLarge: montez(textStyle: textTheme.bodyLarge),
      bodyMedium: montez(textStyle: textTheme.bodyMedium),
      bodySmall: montez(textStyle: textTheme.bodySmall),
      labelLarge: montez(textStyle: textTheme.labelLarge),
      labelMedium: montez(textStyle: textTheme.labelMedium),
      labelSmall: montez(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montserrat font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat
  static TextStyle montserrat({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd468d39b3ea7b338020a8fca3c4aca59844459c3d66c5be87e3d1809b5378556',
        108396,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b56e195db4f3803ad25dc26cbbc9d424562e5431968d4124e2435aeae5e936c4',
        108664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '183ed747f881d6f8f1a560896b19e79b1db5ad3be1e8a022e6626591ba674b01',
        108804,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e3bb63f2cd246ff159b0841c2bd55d0914291a93487340cfa27574cc8d1861dd',
        108744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0640b607f11322748abad42219ea40d3c9d15736374ac53a8117a58dd7d0edb0',
        108824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7f24ab0c0148c4c2160552a4d8676977204aabee088a0f3fa71eb44250b89a8c',
        109060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d4074869afb39d444728a57fe9d7dd18321cd8b7f94f014e8429c7a7b95c96',
        109200,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fa9123659daabc277ebd7bcb2f89ab70ac25e0d6a4094689998885f3ad504a30',
        110068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0130a08a68975f07adfa07ca5b2e7aa2799af9b46d2b3b108fb90169b77c8d13',
        109900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4467a52fdbe28dc122eab1b01684811d12c9780507a4574404956632c4cd676c',
        109160,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '82a79a93609641a98f023a63f295568260be8d322830ab00bdd617eb87217f86',
        109516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9bd892a4f02a73ddfe3f0c0751b8b4102b71dff1c2747a3daf1ba1522f9ab49d',
        109540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c33ff345dd6b33c01890010990c475be1e2791e2aec0320160bdfdfe50df97f8',
        109484,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '15acc744431f3bdc2dcaeab381fe50c4cb5fbe0ed7824b71095b97dbcaf05ae2',
        109604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e8e759503464f76a2a932af802a6f61fc3b7d6d58754cf758d51d32725c58dea',
        109832,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '091a994866ca5994bc4d8954b7eacf09d415fb7faded21f1621b13c57baa0299',
        110048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '40f3e816d9eb207e54b484fd7e103f652aeb0e4189c47ec0a45725225f092866',
        110844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9ebd0a4ee149e91df28fd70baaaaef3b81a16f762044a5bfeb3c126ec887ef71',
        110756,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Montserrat',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montserrat font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat
  static TextTheme montserratTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montserrat(textStyle: textTheme.displayLarge),
      displayMedium: montserrat(textStyle: textTheme.displayMedium),
      displaySmall: montserrat(textStyle: textTheme.displaySmall),
      headlineLarge: montserrat(textStyle: textTheme.headlineLarge),
      headlineMedium: montserrat(textStyle: textTheme.headlineMedium),
      headlineSmall: montserrat(textStyle: textTheme.headlineSmall),
      titleLarge: montserrat(textStyle: textTheme.titleLarge),
      titleMedium: montserrat(textStyle: textTheme.titleMedium),
      titleSmall: montserrat(textStyle: textTheme.titleSmall),
      bodyLarge: montserrat(textStyle: textTheme.bodyLarge),
      bodyMedium: montserrat(textStyle: textTheme.bodyMedium),
      bodySmall: montserrat(textStyle: textTheme.bodySmall),
      labelLarge: montserrat(textStyle: textTheme.labelLarge),
      labelMedium: montserrat(textStyle: textTheme.labelMedium),
      labelSmall: montserrat(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montserrat Alternates font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat+Alternates
  static TextStyle montserratAlternates({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4d7a5df2f9a2cd1f31e412e5ce15022025bc9554edd38d598c80922739d83c28',
        117000,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a6f86268c0464a107b9bdcaa373889d7d241102993fd3b8daf1189920b7445b0',
        118780,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '915c276f838dff1c7a10b2466686586f6fc6ab606f4d50e65a5d140a1eb2d188',
        118480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cc7a9d8ca5a1f7385088f3465ed82ea6e7a5deee6b456ee6e70a063bead570bf',
        120212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '134d8da4906a6638829a22a421d9d7a4698e14cfadf42ae695d6a84e91cea7fd',
        118364,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0fbed38ef00c725f05e1db3a52afd3fe4ded80e5b8d3c2543aa36609fb404666',
        120188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0191e70fccf382d5f2baae22fac7516a4addedd92f1badea57ac43a6e549053c',
        118320,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '99f2905b3610f3be886719d9528a6afa0becde610933e6a2e79eff60144d61eb',
        119984,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '922b398949897f1364e4d3996e400387febd63dd3c5311ab4b30c70569b45a1a',
        118064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '26447bb414605a3e7be79f9df697ef4f656eeb199dc2e5be581ca4aef5f5292f',
        119800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c3861279f8ac6ccf52e5874c97c35d6dfc55221e7f0d1b4dd269637b63645f38',
        117640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8e69508eeab8d357ae04515ca19a0731fdcaf4ee5525e8779079f23b20b06948',
        119476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a268672df8af1cf4762f05c4f294af1a1b41341ba4bb979e031b6d57ca59e64d',
        117292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5c9e7c31631e7f5295b5ac166a81a2e0eb6fbf217725c916a98ff925af433766',
        119176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d14c3f1bd4fb94a986cbd90280d1f02dea18244e24a6dfeba17309ce3861a4c',
        116976,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '81957ea032fbd2241c5b9bbce9b88ff101d09556a3878e26ce17f327ec986348',
        118788,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3f6dcec9e7992a2029a6a8a3f9bcfb24fc0e66e1db34ebfc77058c6b00f53df8',
        114528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '931456a594815d5e2b1c4b00561970721fbcf9f272d54651e57f35cd3403549f',
        116576,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MontserratAlternates',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montserrat Alternates font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat+Alternates
  static TextTheme montserratAlternatesTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montserratAlternates(textStyle: textTheme.displayLarge),
      displayMedium: montserratAlternates(textStyle: textTheme.displayMedium),
      displaySmall: montserratAlternates(textStyle: textTheme.displaySmall),
      headlineLarge: montserratAlternates(textStyle: textTheme.headlineLarge),
      headlineMedium: montserratAlternates(textStyle: textTheme.headlineMedium),
      headlineSmall: montserratAlternates(textStyle: textTheme.headlineSmall),
      titleLarge: montserratAlternates(textStyle: textTheme.titleLarge),
      titleMedium: montserratAlternates(textStyle: textTheme.titleMedium),
      titleSmall: montserratAlternates(textStyle: textTheme.titleSmall),
      bodyLarge: montserratAlternates(textStyle: textTheme.bodyLarge),
      bodyMedium: montserratAlternates(textStyle: textTheme.bodyMedium),
      bodySmall: montserratAlternates(textStyle: textTheme.bodySmall),
      labelLarge: montserratAlternates(textStyle: textTheme.labelLarge),
      labelMedium: montserratAlternates(textStyle: textTheme.labelMedium),
      labelSmall: montserratAlternates(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Montserrat Subrayada font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat+Subrayada
  static TextStyle montserratSubrayada({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb1c9064114c62cd83d30feeeda2a22762f31997c6440ce789a7ab6d401d15a4',
        22512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5caabab45b310d81ebda07c0fb74ce7155f8cea3c5aaf6db7b39a4b64a22bba3',
        22548,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MontserratSubrayada',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Montserrat Subrayada font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Montserrat+Subrayada
  static TextTheme montserratSubrayadaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: montserratSubrayada(textStyle: textTheme.displayLarge),
      displayMedium: montserratSubrayada(textStyle: textTheme.displayMedium),
      displaySmall: montserratSubrayada(textStyle: textTheme.displaySmall),
      headlineLarge: montserratSubrayada(textStyle: textTheme.headlineLarge),
      headlineMedium: montserratSubrayada(textStyle: textTheme.headlineMedium),
      headlineSmall: montserratSubrayada(textStyle: textTheme.headlineSmall),
      titleLarge: montserratSubrayada(textStyle: textTheme.titleLarge),
      titleMedium: montserratSubrayada(textStyle: textTheme.titleMedium),
      titleSmall: montserratSubrayada(textStyle: textTheme.titleSmall),
      bodyLarge: montserratSubrayada(textStyle: textTheme.bodyLarge),
      bodyMedium: montserratSubrayada(textStyle: textTheme.bodyMedium),
      bodySmall: montserratSubrayada(textStyle: textTheme.bodySmall),
      labelLarge: montserratSubrayada(textStyle: textTheme.labelLarge),
      labelMedium: montserratSubrayada(textStyle: textTheme.labelMedium),
      labelSmall: montserratSubrayada(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Moo Lah Lah font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moo+Lah+Lah
  static TextStyle mooLahLah({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c57052e89f2da3b6021a518867b47c2d6365ef77e1688a48fdd165b5c4a293f2',
        178860,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MooLahLah',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Moo Lah Lah font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moo+Lah+Lah
  static TextTheme mooLahLahTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mooLahLah(textStyle: textTheme.displayLarge),
      displayMedium: mooLahLah(textStyle: textTheme.displayMedium),
      displaySmall: mooLahLah(textStyle: textTheme.displaySmall),
      headlineLarge: mooLahLah(textStyle: textTheme.headlineLarge),
      headlineMedium: mooLahLah(textStyle: textTheme.headlineMedium),
      headlineSmall: mooLahLah(textStyle: textTheme.headlineSmall),
      titleLarge: mooLahLah(textStyle: textTheme.titleLarge),
      titleMedium: mooLahLah(textStyle: textTheme.titleMedium),
      titleSmall: mooLahLah(textStyle: textTheme.titleSmall),
      bodyLarge: mooLahLah(textStyle: textTheme.bodyLarge),
      bodyMedium: mooLahLah(textStyle: textTheme.bodyMedium),
      bodySmall: mooLahLah(textStyle: textTheme.bodySmall),
      labelLarge: mooLahLah(textStyle: textTheme.labelLarge),
      labelMedium: mooLahLah(textStyle: textTheme.labelMedium),
      labelSmall: mooLahLah(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mooli font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mooli
  static TextStyle mooli({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd66582c068aa9aab1401520824b4bd4e3d0fc0e9bceffee79c2d9d8988d51df',
        38920,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mooli',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mooli font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mooli
  static TextTheme mooliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mooli(textStyle: textTheme.displayLarge),
      displayMedium: mooli(textStyle: textTheme.displayMedium),
      displaySmall: mooli(textStyle: textTheme.displaySmall),
      headlineLarge: mooli(textStyle: textTheme.headlineLarge),
      headlineMedium: mooli(textStyle: textTheme.headlineMedium),
      headlineSmall: mooli(textStyle: textTheme.headlineSmall),
      titleLarge: mooli(textStyle: textTheme.titleLarge),
      titleMedium: mooli(textStyle: textTheme.titleMedium),
      titleSmall: mooli(textStyle: textTheme.titleSmall),
      bodyLarge: mooli(textStyle: textTheme.bodyLarge),
      bodyMedium: mooli(textStyle: textTheme.bodyMedium),
      bodySmall: mooli(textStyle: textTheme.bodySmall),
      labelLarge: mooli(textStyle: textTheme.labelLarge),
      labelMedium: mooli(textStyle: textTheme.labelMedium),
      labelSmall: mooli(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Moon Dance font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moon+Dance
  static TextStyle moonDance({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7596f490f5db497186c8db36ef25d1cefd6f78ee3eb7042a743c9ae72d580150',
        128632,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MoonDance',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Moon Dance font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moon+Dance
  static TextTheme moonDanceTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: moonDance(textStyle: textTheme.displayLarge),
      displayMedium: moonDance(textStyle: textTheme.displayMedium),
      displaySmall: moonDance(textStyle: textTheme.displaySmall),
      headlineLarge: moonDance(textStyle: textTheme.headlineLarge),
      headlineMedium: moonDance(textStyle: textTheme.headlineMedium),
      headlineSmall: moonDance(textStyle: textTheme.headlineSmall),
      titleLarge: moonDance(textStyle: textTheme.titleLarge),
      titleMedium: moonDance(textStyle: textTheme.titleMedium),
      titleSmall: moonDance(textStyle: textTheme.titleSmall),
      bodyLarge: moonDance(textStyle: textTheme.bodyLarge),
      bodyMedium: moonDance(textStyle: textTheme.bodyMedium),
      bodySmall: moonDance(textStyle: textTheme.bodySmall),
      labelLarge: moonDance(textStyle: textTheme.labelLarge),
      labelMedium: moonDance(textStyle: textTheme.labelMedium),
      labelSmall: moonDance(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Moul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moul
  static TextStyle moul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4986c3663ee887a952d1c8c803346ef872955304ec63dfc4156611c0f9c37f5b',
        84252,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Moul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Moul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moul
  static TextTheme moulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: moul(textStyle: textTheme.displayLarge),
      displayMedium: moul(textStyle: textTheme.displayMedium),
      displaySmall: moul(textStyle: textTheme.displaySmall),
      headlineLarge: moul(textStyle: textTheme.headlineLarge),
      headlineMedium: moul(textStyle: textTheme.headlineMedium),
      headlineSmall: moul(textStyle: textTheme.headlineSmall),
      titleLarge: moul(textStyle: textTheme.titleLarge),
      titleMedium: moul(textStyle: textTheme.titleMedium),
      titleSmall: moul(textStyle: textTheme.titleSmall),
      bodyLarge: moul(textStyle: textTheme.bodyLarge),
      bodyMedium: moul(textStyle: textTheme.bodyMedium),
      bodySmall: moul(textStyle: textTheme.bodySmall),
      labelLarge: moul(textStyle: textTheme.labelLarge),
      labelMedium: moul(textStyle: textTheme.labelMedium),
      labelSmall: moul(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Moulpali font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moulpali
  static TextStyle moulpali({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2ec0ad574752722e1746a8c7bd1d71bddd0845daba262c1eeb11ddf5b77e60bd',
        66372,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Moulpali',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Moulpali font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Moulpali
  static TextTheme moulpaliTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: moulpali(textStyle: textTheme.displayLarge),
      displayMedium: moulpali(textStyle: textTheme.displayMedium),
      displaySmall: moulpali(textStyle: textTheme.displaySmall),
      headlineLarge: moulpali(textStyle: textTheme.headlineLarge),
      headlineMedium: moulpali(textStyle: textTheme.headlineMedium),
      headlineSmall: moulpali(textStyle: textTheme.headlineSmall),
      titleLarge: moulpali(textStyle: textTheme.titleLarge),
      titleMedium: moulpali(textStyle: textTheme.titleMedium),
      titleSmall: moulpali(textStyle: textTheme.titleSmall),
      bodyLarge: moulpali(textStyle: textTheme.bodyLarge),
      bodyMedium: moulpali(textStyle: textTheme.bodyMedium),
      bodySmall: moulpali(textStyle: textTheme.bodySmall),
      labelLarge: moulpali(textStyle: textTheme.labelLarge),
      labelMedium: moulpali(textStyle: textTheme.labelMedium),
      labelSmall: moulpali(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mountains of Christmas font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mountains+of+Christmas
  static TextStyle mountainsOfChristmas({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4e02d438d9120d6852ace98f62e701b22b46674672f194c7885e00b517a589a8',
        120264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fcd730c29322a1e85ac0a1862ed56030f29821e8cf8a91f6de07a8aa74b8aede',
        121060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MountainsofChristmas',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mountains of Christmas font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mountains+of+Christmas
  static TextTheme mountainsOfChristmasTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mountainsOfChristmas(textStyle: textTheme.displayLarge),
      displayMedium: mountainsOfChristmas(textStyle: textTheme.displayMedium),
      displaySmall: mountainsOfChristmas(textStyle: textTheme.displaySmall),
      headlineLarge: mountainsOfChristmas(textStyle: textTheme.headlineLarge),
      headlineMedium: mountainsOfChristmas(textStyle: textTheme.headlineMedium),
      headlineSmall: mountainsOfChristmas(textStyle: textTheme.headlineSmall),
      titleLarge: mountainsOfChristmas(textStyle: textTheme.titleLarge),
      titleMedium: mountainsOfChristmas(textStyle: textTheme.titleMedium),
      titleSmall: mountainsOfChristmas(textStyle: textTheme.titleSmall),
      bodyLarge: mountainsOfChristmas(textStyle: textTheme.bodyLarge),
      bodyMedium: mountainsOfChristmas(textStyle: textTheme.bodyMedium),
      bodySmall: mountainsOfChristmas(textStyle: textTheme.bodySmall),
      labelLarge: mountainsOfChristmas(textStyle: textTheme.labelLarge),
      labelMedium: mountainsOfChristmas(textStyle: textTheme.labelMedium),
      labelSmall: mountainsOfChristmas(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mouse Memoirs font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mouse+Memoirs
  static TextStyle mouseMemoirs({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '410c464b22cb468c6dc7dbb09824f4ca74dacf62fbc4e5334278fbe5831c351d',
        53368,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MouseMemoirs',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mouse Memoirs font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mouse+Memoirs
  static TextTheme mouseMemoirsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mouseMemoirs(textStyle: textTheme.displayLarge),
      displayMedium: mouseMemoirs(textStyle: textTheme.displayMedium),
      displaySmall: mouseMemoirs(textStyle: textTheme.displaySmall),
      headlineLarge: mouseMemoirs(textStyle: textTheme.headlineLarge),
      headlineMedium: mouseMemoirs(textStyle: textTheme.headlineMedium),
      headlineSmall: mouseMemoirs(textStyle: textTheme.headlineSmall),
      titleLarge: mouseMemoirs(textStyle: textTheme.titleLarge),
      titleMedium: mouseMemoirs(textStyle: textTheme.titleMedium),
      titleSmall: mouseMemoirs(textStyle: textTheme.titleSmall),
      bodyLarge: mouseMemoirs(textStyle: textTheme.bodyLarge),
      bodyMedium: mouseMemoirs(textStyle: textTheme.bodyMedium),
      bodySmall: mouseMemoirs(textStyle: textTheme.bodySmall),
      labelLarge: mouseMemoirs(textStyle: textTheme.labelLarge),
      labelMedium: mouseMemoirs(textStyle: textTheme.labelMedium),
      labelSmall: mouseMemoirs(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mr Bedfort font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+Bedfort
  static TextStyle mrBedfort({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '941d5fbc7be444275ec42fd3da1a7d15a3277289126b8c52ec391e25fb7a38e3',
        35540,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MrBedfort',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mr Bedfort font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+Bedfort
  static TextTheme mrBedfortTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mrBedfort(textStyle: textTheme.displayLarge),
      displayMedium: mrBedfort(textStyle: textTheme.displayMedium),
      displaySmall: mrBedfort(textStyle: textTheme.displaySmall),
      headlineLarge: mrBedfort(textStyle: textTheme.headlineLarge),
      headlineMedium: mrBedfort(textStyle: textTheme.headlineMedium),
      headlineSmall: mrBedfort(textStyle: textTheme.headlineSmall),
      titleLarge: mrBedfort(textStyle: textTheme.titleLarge),
      titleMedium: mrBedfort(textStyle: textTheme.titleMedium),
      titleSmall: mrBedfort(textStyle: textTheme.titleSmall),
      bodyLarge: mrBedfort(textStyle: textTheme.bodyLarge),
      bodyMedium: mrBedfort(textStyle: textTheme.bodyMedium),
      bodySmall: mrBedfort(textStyle: textTheme.bodySmall),
      labelLarge: mrBedfort(textStyle: textTheme.labelLarge),
      labelMedium: mrBedfort(textStyle: textTheme.labelMedium),
      labelSmall: mrBedfort(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mr Dafoe font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+Dafoe
  static TextStyle mrDafoe({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7dc607a2d1d302d517fdfe880ffbcafee12d51324aa21d588170ec9d975cc1a8',
        46076,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MrDafoe',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mr Dafoe font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+Dafoe
  static TextTheme mrDafoeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mrDafoe(textStyle: textTheme.displayLarge),
      displayMedium: mrDafoe(textStyle: textTheme.displayMedium),
      displaySmall: mrDafoe(textStyle: textTheme.displaySmall),
      headlineLarge: mrDafoe(textStyle: textTheme.headlineLarge),
      headlineMedium: mrDafoe(textStyle: textTheme.headlineMedium),
      headlineSmall: mrDafoe(textStyle: textTheme.headlineSmall),
      titleLarge: mrDafoe(textStyle: textTheme.titleLarge),
      titleMedium: mrDafoe(textStyle: textTheme.titleMedium),
      titleSmall: mrDafoe(textStyle: textTheme.titleSmall),
      bodyLarge: mrDafoe(textStyle: textTheme.bodyLarge),
      bodyMedium: mrDafoe(textStyle: textTheme.bodyMedium),
      bodySmall: mrDafoe(textStyle: textTheme.bodySmall),
      labelLarge: mrDafoe(textStyle: textTheme.labelLarge),
      labelMedium: mrDafoe(textStyle: textTheme.labelMedium),
      labelSmall: mrDafoe(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mr De Haviland font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+De+Haviland
  static TextStyle mrDeHaviland({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd1baafc9c65c5e9ff4da63ad3257a06d8579fba605b0d6bf7e541d59c1f7f5ab',
        42704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MrDeHaviland',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mr De Haviland font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mr+De+Haviland
  static TextTheme mrDeHavilandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mrDeHaviland(textStyle: textTheme.displayLarge),
      displayMedium: mrDeHaviland(textStyle: textTheme.displayMedium),
      displaySmall: mrDeHaviland(textStyle: textTheme.displaySmall),
      headlineLarge: mrDeHaviland(textStyle: textTheme.headlineLarge),
      headlineMedium: mrDeHaviland(textStyle: textTheme.headlineMedium),
      headlineSmall: mrDeHaviland(textStyle: textTheme.headlineSmall),
      titleLarge: mrDeHaviland(textStyle: textTheme.titleLarge),
      titleMedium: mrDeHaviland(textStyle: textTheme.titleMedium),
      titleSmall: mrDeHaviland(textStyle: textTheme.titleSmall),
      bodyLarge: mrDeHaviland(textStyle: textTheme.bodyLarge),
      bodyMedium: mrDeHaviland(textStyle: textTheme.bodyMedium),
      bodySmall: mrDeHaviland(textStyle: textTheme.bodySmall),
      labelLarge: mrDeHaviland(textStyle: textTheme.labelLarge),
      labelMedium: mrDeHaviland(textStyle: textTheme.labelMedium),
      labelSmall: mrDeHaviland(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mrs Saint Delafield font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mrs+Saint+Delafield
  static TextStyle mrsSaintDelafield({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7c9be601ffc496d996d3497e3aaaf914f4de814322a0bc88ea62b391d59ee3d4',
        47368,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MrsSaintDelafield',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mrs Saint Delafield font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mrs+Saint+Delafield
  static TextTheme mrsSaintDelafieldTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mrsSaintDelafield(textStyle: textTheme.displayLarge),
      displayMedium: mrsSaintDelafield(textStyle: textTheme.displayMedium),
      displaySmall: mrsSaintDelafield(textStyle: textTheme.displaySmall),
      headlineLarge: mrsSaintDelafield(textStyle: textTheme.headlineLarge),
      headlineMedium: mrsSaintDelafield(textStyle: textTheme.headlineMedium),
      headlineSmall: mrsSaintDelafield(textStyle: textTheme.headlineSmall),
      titleLarge: mrsSaintDelafield(textStyle: textTheme.titleLarge),
      titleMedium: mrsSaintDelafield(textStyle: textTheme.titleMedium),
      titleSmall: mrsSaintDelafield(textStyle: textTheme.titleSmall),
      bodyLarge: mrsSaintDelafield(textStyle: textTheme.bodyLarge),
      bodyMedium: mrsSaintDelafield(textStyle: textTheme.bodyMedium),
      bodySmall: mrsSaintDelafield(textStyle: textTheme.bodySmall),
      labelLarge: mrsSaintDelafield(textStyle: textTheme.labelLarge),
      labelMedium: mrsSaintDelafield(textStyle: textTheme.labelMedium),
      labelSmall: mrsSaintDelafield(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mrs Sheppards font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mrs+Sheppards
  static TextStyle mrsSheppards({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2d0cf7a213f868f390f7e26e3cf8dfcbe63e502691a239c87f11aa3d57c6ba7c',
        40396,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MrsSheppards',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mrs Sheppards font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mrs+Sheppards
  static TextTheme mrsSheppardsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mrsSheppards(textStyle: textTheme.displayLarge),
      displayMedium: mrsSheppards(textStyle: textTheme.displayMedium),
      displaySmall: mrsSheppards(textStyle: textTheme.displaySmall),
      headlineLarge: mrsSheppards(textStyle: textTheme.headlineLarge),
      headlineMedium: mrsSheppards(textStyle: textTheme.headlineMedium),
      headlineSmall: mrsSheppards(textStyle: textTheme.headlineSmall),
      titleLarge: mrsSheppards(textStyle: textTheme.titleLarge),
      titleMedium: mrsSheppards(textStyle: textTheme.titleMedium),
      titleSmall: mrsSheppards(textStyle: textTheme.titleSmall),
      bodyLarge: mrsSheppards(textStyle: textTheme.bodyLarge),
      bodyMedium: mrsSheppards(textStyle: textTheme.bodyMedium),
      bodySmall: mrsSheppards(textStyle: textTheme.bodySmall),
      labelLarge: mrsSheppards(textStyle: textTheme.labelLarge),
      labelMedium: mrsSheppards(textStyle: textTheme.labelMedium),
      labelSmall: mrsSheppards(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Ms Madi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ms+Madi
  static TextStyle msMadi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c15d79c8f570fc41ba1007b1976bde2828e53614e3ed642b0af06c4eb070a893',
        95452,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MsMadi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Ms Madi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Ms+Madi
  static TextTheme msMadiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: msMadi(textStyle: textTheme.displayLarge),
      displayMedium: msMadi(textStyle: textTheme.displayMedium),
      displaySmall: msMadi(textStyle: textTheme.displaySmall),
      headlineLarge: msMadi(textStyle: textTheme.headlineLarge),
      headlineMedium: msMadi(textStyle: textTheme.headlineMedium),
      headlineSmall: msMadi(textStyle: textTheme.headlineSmall),
      titleLarge: msMadi(textStyle: textTheme.titleLarge),
      titleMedium: msMadi(textStyle: textTheme.titleMedium),
      titleSmall: msMadi(textStyle: textTheme.titleSmall),
      bodyLarge: msMadi(textStyle: textTheme.bodyLarge),
      bodyMedium: msMadi(textStyle: textTheme.bodyMedium),
      bodySmall: msMadi(textStyle: textTheme.bodySmall),
      labelLarge: msMadi(textStyle: textTheme.labelLarge),
      labelMedium: msMadi(textStyle: textTheme.labelMedium),
      labelSmall: msMadi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mukta font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta
  static TextStyle mukta({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '689ed83e8b4894f9069d2853baac87ae4735976b5a7e8bd0e78118a906cb3131',
        292048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '79cf11b92bc111c68976e513ae8f1507445985a5376d7f3011b5b941c039b679',
        288812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dcbbb86472f2ca059cec1c441ea46fdd4d1e7a8167956cf98f4fe261021fc74a',
        292960,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2951d04b7aa5e776f37106d144d5fefb50445776e6ccc7ac624e3452e1ce5c5c',
        286752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '25ae58ed46d40da267073512294e4a09d35fb3db0e3697a116f295f0fe4af8aa',
        282580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '981ab5d0ad952878450477b867e2a05823b15725afc6c0558b561b7b579e2243',
        284164,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3e67c0697120dc90c20c81f0ecb82e09dc9a216fd8a57587aed16571fbc71c8a',
        283888,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mukta',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mukta font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta
  static TextTheme muktaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mukta(textStyle: textTheme.displayLarge),
      displayMedium: mukta(textStyle: textTheme.displayMedium),
      displaySmall: mukta(textStyle: textTheme.displaySmall),
      headlineLarge: mukta(textStyle: textTheme.headlineLarge),
      headlineMedium: mukta(textStyle: textTheme.headlineMedium),
      headlineSmall: mukta(textStyle: textTheme.headlineSmall),
      titleLarge: mukta(textStyle: textTheme.titleLarge),
      titleMedium: mukta(textStyle: textTheme.titleMedium),
      titleSmall: mukta(textStyle: textTheme.titleSmall),
      bodyLarge: mukta(textStyle: textTheme.bodyLarge),
      bodyMedium: mukta(textStyle: textTheme.bodyMedium),
      bodySmall: mukta(textStyle: textTheme.bodySmall),
      labelLarge: mukta(textStyle: textTheme.labelLarge),
      labelMedium: mukta(textStyle: textTheme.labelMedium),
      labelSmall: mukta(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mukta Mahee font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Mahee
  static TextStyle muktaMahee({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2791187e05e318398af61e232b6df043996565aea0deae5e82aaed81262f60a',
        118688,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dd10477a2c19fcd65d9a11ec160f99b7d1fa67dded579f1c65a8a6ff135c52bd',
        117752,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e582c07788f9c8a965d9633c3af6c44900b76e341f1da0021e729f6fb535a8ad',
        120004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '798b55ab584e2440da5fc3bc0ca5ce95b152383c17bc4de6fc9251d7a56a136e',
        116444,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8853dcb5cc9d2a2bfca12c175f6e30f9940d1a7099f43ece5fd7ed5ef320500e',
        116176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '38d299d4354f22d6c5b058cc5ebc6b3553501c5062eeb112c7a56200864457bd',
        116516,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '455f62dba08ef482189298be69c7f2e4e66fdb6a14dcc4e4f497c69e8a7b716b',
        116288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MuktaMahee',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mukta Mahee font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Mahee
  static TextTheme muktaMaheeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: muktaMahee(textStyle: textTheme.displayLarge),
      displayMedium: muktaMahee(textStyle: textTheme.displayMedium),
      displaySmall: muktaMahee(textStyle: textTheme.displaySmall),
      headlineLarge: muktaMahee(textStyle: textTheme.headlineLarge),
      headlineMedium: muktaMahee(textStyle: textTheme.headlineMedium),
      headlineSmall: muktaMahee(textStyle: textTheme.headlineSmall),
      titleLarge: muktaMahee(textStyle: textTheme.titleLarge),
      titleMedium: muktaMahee(textStyle: textTheme.titleMedium),
      titleSmall: muktaMahee(textStyle: textTheme.titleSmall),
      bodyLarge: muktaMahee(textStyle: textTheme.bodyLarge),
      bodyMedium: muktaMahee(textStyle: textTheme.bodyMedium),
      bodySmall: muktaMahee(textStyle: textTheme.bodySmall),
      labelLarge: muktaMahee(textStyle: textTheme.labelLarge),
      labelMedium: muktaMahee(textStyle: textTheme.labelMedium),
      labelSmall: muktaMahee(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mukta Malar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Malar
  static TextStyle muktaMalar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f8d6692feb9aaced43e8e1e84f7bb519244a3a8df677498efebec0f317a67726',
        135256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed32ffc4383d437cacae095cf7caa5a2dcb165000962c61983da0b4e787e5ade',
        134292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a56b4621b82c1482e38a72403cb4399545aa59653042b01e34df08a380542e97',
        136540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1b776252fc2124e27580cbe3afd4c3d3376a7e0f21dbc152a3a12f0cc15fc95a',
        132828,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9bcb8006796590dafafde68ab3a6a81532ae2c439bcbc27b871a1da4050ec71e',
        132844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '16ebf60380b9fec07b7898fff10b017d3ef53dd8a9f314ca1e9f6a184618d1e0',
        133168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cbb2945a1ec58b2c09a366d43855970662bf2e029171e8a36842e42aef2838e6',
        133520,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MuktaMalar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mukta Malar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Malar
  static TextTheme muktaMalarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: muktaMalar(textStyle: textTheme.displayLarge),
      displayMedium: muktaMalar(textStyle: textTheme.displayMedium),
      displaySmall: muktaMalar(textStyle: textTheme.displaySmall),
      headlineLarge: muktaMalar(textStyle: textTheme.headlineLarge),
      headlineMedium: muktaMalar(textStyle: textTheme.headlineMedium),
      headlineSmall: muktaMalar(textStyle: textTheme.headlineSmall),
      titleLarge: muktaMalar(textStyle: textTheme.titleLarge),
      titleMedium: muktaMalar(textStyle: textTheme.titleMedium),
      titleSmall: muktaMalar(textStyle: textTheme.titleSmall),
      bodyLarge: muktaMalar(textStyle: textTheme.bodyLarge),
      bodyMedium: muktaMalar(textStyle: textTheme.bodyMedium),
      bodySmall: muktaMalar(textStyle: textTheme.bodySmall),
      labelLarge: muktaMalar(textStyle: textTheme.labelLarge),
      labelMedium: muktaMalar(textStyle: textTheme.labelMedium),
      labelSmall: muktaMalar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mukta Vaani font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Vaani
  static TextStyle muktaVaani({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0eb1523a117624d4dd42a592f2233691bcbf88ed94ff3cddde0e97981dc0d907',
        319568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cd7363eca7da62f426163fe8a1ee26b859156b50dc38e8bdbc6824155fede72c',
        323308,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '135cd622088ee6ab3d9c86da49aa70bc01957c180e491db27780a3de335a5bb7',
        316912,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b94ac054cddf4fbf34b2f6f1bb58cd17754fcc17236884b11a29358ea1c11446',
        322084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a9961793b69f1d949b4d2afb84a6c85e9c862af8a6eaff6ec5edcd60d126d9e',
        320284,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6767c2e83821b1add71c9761808480c87bd0816275d156ffeb23f930626fdb3e',
        320380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4232bbe2ce6dc4e4dc08e433e47b0fe6ab5eea9f6772d573619375c79f32da41',
        317952,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MuktaVaani',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mukta Vaani font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mukta+Vaani
  static TextTheme muktaVaaniTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: muktaVaani(textStyle: textTheme.displayLarge),
      displayMedium: muktaVaani(textStyle: textTheme.displayMedium),
      displaySmall: muktaVaani(textStyle: textTheme.displaySmall),
      headlineLarge: muktaVaani(textStyle: textTheme.headlineLarge),
      headlineMedium: muktaVaani(textStyle: textTheme.headlineMedium),
      headlineSmall: muktaVaani(textStyle: textTheme.headlineSmall),
      titleLarge: muktaVaani(textStyle: textTheme.titleLarge),
      titleMedium: muktaVaani(textStyle: textTheme.titleMedium),
      titleSmall: muktaVaani(textStyle: textTheme.titleSmall),
      bodyLarge: muktaVaani(textStyle: textTheme.bodyLarge),
      bodyMedium: muktaVaani(textStyle: textTheme.bodyMedium),
      bodySmall: muktaVaani(textStyle: textTheme.bodySmall),
      labelLarge: muktaVaani(textStyle: textTheme.labelLarge),
      labelMedium: muktaVaani(textStyle: textTheme.labelMedium),
      labelSmall: muktaVaani(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mulish font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mulish
  static TextStyle mulish({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bd490a31a031fbc8019c0bd369d8dd3fbf4b0408c147f919763b4c2a2e6a6293',
        103212,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e91588ab1198d430ba75a8485780801e4af2a8d4b7724a34580b22a502f6c21f',
        103392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0e1d70a8c7c79c6bca286cddd5d802ad65e4d6bd8264890066c8bed0934a2be9',
        103340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '19682bd8a3dde15abe5d218d40aa8e7d3ef367ceb5f41c46c9a0fa570f4d30bf',
        103392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '668dce7b3a8f7c86462f1b8411aabef997ede60e81110a12cf9c78b0246ab656',
        103336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '41decbe258c36160a57f902bc75d5faf870cb89d51ae13e5e00954a02a3d36b2',
        103380,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '14da9531616b5aed5b3f282f47777595ec74bfa8b1120e0d70b56c8d82faf00b',
        103368,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3c6e1e67617beaa68c176399b43a1ba3aac05201bf463ee03905df6697544bdb',
        103400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45ea4b6e863bc7620a857c1a2f147e554207570cb1b446ec349f59a59a23ad84',
        106456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '11ef95515b632c67e704cf38008342012a1ba793c644c69f9221ba9a7d3b1bbc',
        106628,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c614da711652e08b8098561bef9b657fe9e347b8acdc39320f19d96ba314f74d',
        106480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '444d21415e181e5229a400ea8e94067091ea7b840e05c6140045b588e438527f',
        106604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9cf8b660d576af64b053ec6c295ae8b26d12a7c0d15fafa09cde125b832cccf1',
        106572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6238472e5d035ae798295b5a26ed507fec7ed73ce0d55606505a978b84cbb1a8',
        106696,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '834b84e6243a4088cdfdac601f9ea7c24485f9983086eaaf8065cfbb5acf5468',
        106716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'a8e779feed149fdb2ea23e5bb9643908c2eaaddb15eb793be694a1eb4f121140',
        106644,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mulish',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mulish font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mulish
  static TextTheme mulishTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mulish(textStyle: textTheme.displayLarge),
      displayMedium: mulish(textStyle: textTheme.displayMedium),
      displaySmall: mulish(textStyle: textTheme.displaySmall),
      headlineLarge: mulish(textStyle: textTheme.headlineLarge),
      headlineMedium: mulish(textStyle: textTheme.headlineMedium),
      headlineSmall: mulish(textStyle: textTheme.headlineSmall),
      titleLarge: mulish(textStyle: textTheme.titleLarge),
      titleMedium: mulish(textStyle: textTheme.titleMedium),
      titleSmall: mulish(textStyle: textTheme.titleSmall),
      bodyLarge: mulish(textStyle: textTheme.bodyLarge),
      bodyMedium: mulish(textStyle: textTheme.bodyMedium),
      bodySmall: mulish(textStyle: textTheme.bodySmall),
      labelLarge: mulish(textStyle: textTheme.labelLarge),
      labelMedium: mulish(textStyle: textTheme.labelMedium),
      labelSmall: mulish(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Murecho font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Murecho
  static TextStyle murecho({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bf78ca8f10a708a62783fe7cb1f4414b8c3192c258e049fff6db8fb9be00fab0',
        884276,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de06957edba58434f8808541a2c8dc6a54145b5b989fddfbd8f7efc130d7c4ff',
        885004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2b5b476a721f52561d07a8f5f49f6f455e0cc7683f51ff47d3ba0cbe11a2b89b',
        884700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '43c9554a53c1fe2d57af41ad3ddc2bd4165c962615d22a6f5e1eff6a22626310',
        884376,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6ce6bba3511442fbdd3a289ea22014dfdd04223ff4ce50b669975a6b7e5c6eca',
        883636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'af5dbfc3af43c76517f027a3d1b14fec903a982c7f7724f217dc6d717d3c5b0d',
        883336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '74ac1ac7e8798892542536bad103f80a5862614fffeecb2f9ba4a6f46cec7356',
        882856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'db129b5fb292e7bfb9f1a09cb736c300e3d4ca51a5f571037f29c512af02f8fd',
        882560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bcdf8f7f547078e8fe735ba3d279073d225d84973d16a02dc4991dbecfafe609',
        882128,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Murecho',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Murecho font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Murecho
  static TextTheme murechoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: murecho(textStyle: textTheme.displayLarge),
      displayMedium: murecho(textStyle: textTheme.displayMedium),
      displaySmall: murecho(textStyle: textTheme.displaySmall),
      headlineLarge: murecho(textStyle: textTheme.headlineLarge),
      headlineMedium: murecho(textStyle: textTheme.headlineMedium),
      headlineSmall: murecho(textStyle: textTheme.headlineSmall),
      titleLarge: murecho(textStyle: textTheme.titleLarge),
      titleMedium: murecho(textStyle: textTheme.titleMedium),
      titleSmall: murecho(textStyle: textTheme.titleSmall),
      bodyLarge: murecho(textStyle: textTheme.bodyLarge),
      bodyMedium: murecho(textStyle: textTheme.bodyMedium),
      bodySmall: murecho(textStyle: textTheme.bodySmall),
      labelLarge: murecho(textStyle: textTheme.labelLarge),
      labelMedium: murecho(textStyle: textTheme.labelMedium),
      labelSmall: murecho(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the MuseoModerno font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MuseoModerno
  static TextStyle museoModerno({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3ebc1cad1116197ee555770bcc4a326dbd68ded905a6007db352df724624f095',
        54816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b88e0076be97d85251f946d6d9238897de01c3678ed8698652c337a74fd56c13',
        54820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '00d74371cefc337a60214f567780a8ca763b0c1f9b3af474cfeebe3417b52894',
        54776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '85b9474ca512f29e2a5ef75965d1b1f9602fdbd5944661021d44b7fd7bce4e0a',
        54732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '66ea62eb985ed67501338ab89476043f8a44962527e5860506447bb80639d5b5',
        54724,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5c076d1ff4d813c580ad7e780446f2de15d0d9baa44a716f40e3d8c4e90bffe1',
        54908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f322b3b044dcd5cb2d471a21d312480b1bc448b0a288d068b4ca78d5c09c981',
        54880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '50c359c2f0c67009707c9b491db45ef8695b372c717a373bc6da57232fdec53f',
        54620,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '82ec29a1b8f5b834d363b8bfb8de2e8262882292bfd5d9a66af260e332b2a16e',
        54568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9f5505476ad9be36b3dad902482a3670c45707bdcd390e07fe7e8a7e9dd4c55a',
        64348,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '0bba017a43ed72f22f52d4e1ceae4c30ddd71bf5c68c264ab068c30eb3a077a4',
        64560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c0df11682fcfb98be8ab14b2606cdbcef4a7f2b9678ea229e4788572e47a3091',
        64572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b4347007eaaa7bd7aeb3c75f530998bf2e2c7fa8bbaca9916e3a8bbf48a3806d',
        64424,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'bd121268a3464120ac15f34c02be934271c4abc9cb73d4ae1405d30dd407baa3',
        64576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7d7058e5d99082242c8e5d91b159109f9d36cc8e6147447f02e7b0d940ad89ab',
        64732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e9ee12afc655f2ee40b941bcb49441aebefe64278d71e5242a72cab174a94763',
        64720,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '525c6a501ec5a2e3dee09a7c082a50b28bf403fa430e612654360951c06416f4',
        64420,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c426610a3ec276f00cd4d0115e789e89f91f85ea9aa75244442929ecd822b1a7',
        64320,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MuseoModerno',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the MuseoModerno font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/MuseoModerno
  static TextTheme museoModernoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: museoModerno(textStyle: textTheme.displayLarge),
      displayMedium: museoModerno(textStyle: textTheme.displayMedium),
      displaySmall: museoModerno(textStyle: textTheme.displaySmall),
      headlineLarge: museoModerno(textStyle: textTheme.headlineLarge),
      headlineMedium: museoModerno(textStyle: textTheme.headlineMedium),
      headlineSmall: museoModerno(textStyle: textTheme.headlineSmall),
      titleLarge: museoModerno(textStyle: textTheme.titleLarge),
      titleMedium: museoModerno(textStyle: textTheme.titleMedium),
      titleSmall: museoModerno(textStyle: textTheme.titleSmall),
      bodyLarge: museoModerno(textStyle: textTheme.bodyLarge),
      bodyMedium: museoModerno(textStyle: textTheme.bodyMedium),
      bodySmall: museoModerno(textStyle: textTheme.bodySmall),
      labelLarge: museoModerno(textStyle: textTheme.labelLarge),
      labelMedium: museoModerno(textStyle: textTheme.labelMedium),
      labelSmall: museoModerno(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the My Soul font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/My+Soul
  static TextStyle mySoul({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6fe94a4de3bc693b613094ff51dabc944d0d50684df27df4e09391de1952b81d',
        100732,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MySoul',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the My Soul font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/My+Soul
  static TextTheme mySoulTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mySoul(textStyle: textTheme.displayLarge),
      displayMedium: mySoul(textStyle: textTheme.displayMedium),
      displaySmall: mySoul(textStyle: textTheme.displaySmall),
      headlineLarge: mySoul(textStyle: textTheme.headlineLarge),
      headlineMedium: mySoul(textStyle: textTheme.headlineMedium),
      headlineSmall: mySoul(textStyle: textTheme.headlineSmall),
      titleLarge: mySoul(textStyle: textTheme.titleLarge),
      titleMedium: mySoul(textStyle: textTheme.titleMedium),
      titleSmall: mySoul(textStyle: textTheme.titleSmall),
      bodyLarge: mySoul(textStyle: textTheme.bodyLarge),
      bodyMedium: mySoul(textStyle: textTheme.bodyMedium),
      bodySmall: mySoul(textStyle: textTheme.bodySmall),
      labelLarge: mySoul(textStyle: textTheme.labelLarge),
      labelMedium: mySoul(textStyle: textTheme.labelMedium),
      labelSmall: mySoul(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mynerve font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mynerve
  static TextStyle mynerve({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8d3ffed3e31bde32bc03248e7d9c0b9fa49b7955c17aba2818a7ba253591503e',
        216816,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Mynerve',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mynerve font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mynerve
  static TextTheme mynerveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mynerve(textStyle: textTheme.displayLarge),
      displayMedium: mynerve(textStyle: textTheme.displayMedium),
      displaySmall: mynerve(textStyle: textTheme.displaySmall),
      headlineLarge: mynerve(textStyle: textTheme.headlineLarge),
      headlineMedium: mynerve(textStyle: textTheme.headlineMedium),
      headlineSmall: mynerve(textStyle: textTheme.headlineSmall),
      titleLarge: mynerve(textStyle: textTheme.titleLarge),
      titleMedium: mynerve(textStyle: textTheme.titleMedium),
      titleSmall: mynerve(textStyle: textTheme.titleSmall),
      bodyLarge: mynerve(textStyle: textTheme.bodyLarge),
      bodyMedium: mynerve(textStyle: textTheme.bodyMedium),
      bodySmall: mynerve(textStyle: textTheme.bodySmall),
      labelLarge: mynerve(textStyle: textTheme.labelLarge),
      labelMedium: mynerve(textStyle: textTheme.labelMedium),
      labelSmall: mynerve(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Mystery Quest font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mystery+Quest
  static TextStyle mysteryQuest({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'edb020d290543d608a6f8c488e694b9b5ada227c5c78b7036676f7645d6687b9',
        39812,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'MysteryQuest',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Mystery Quest font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Mystery+Quest
  static TextTheme mysteryQuestTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: mysteryQuest(textStyle: textTheme.displayLarge),
      displayMedium: mysteryQuest(textStyle: textTheme.displayMedium),
      displaySmall: mysteryQuest(textStyle: textTheme.displaySmall),
      headlineLarge: mysteryQuest(textStyle: textTheme.headlineLarge),
      headlineMedium: mysteryQuest(textStyle: textTheme.headlineMedium),
      headlineSmall: mysteryQuest(textStyle: textTheme.headlineSmall),
      titleLarge: mysteryQuest(textStyle: textTheme.titleLarge),
      titleMedium: mysteryQuest(textStyle: textTheme.titleMedium),
      titleSmall: mysteryQuest(textStyle: textTheme.titleSmall),
      bodyLarge: mysteryQuest(textStyle: textTheme.bodyLarge),
      bodyMedium: mysteryQuest(textStyle: textTheme.bodyMedium),
      bodySmall: mysteryQuest(textStyle: textTheme.bodySmall),
      labelLarge: mysteryQuest(textStyle: textTheme.labelLarge),
      labelMedium: mysteryQuest(textStyle: textTheme.labelMedium),
      labelSmall: mysteryQuest(textStyle: textTheme.labelSmall),
    );
  }
}
