// GENERATED CODE - DO NOT EDIT

// Copyright 2019 The Flutter team. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import 'dart:ui' as ui;
import 'package:flutter/material.dart';
import '../google_fonts_base.dart';
import '../google_fonts_descriptor.dart';
import '../google_fonts_variant.dart';

/// Methods for fonts starting with 'K'.
class PartK {
  /// Applies the K2D font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/K2D
  static TextStyle k2d({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '03d04f680ab9aec61fa325a77850919a960cd20870e06e6d7c0d05a46e7829da',
        90944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8644c0791e1d1a109e3eba20851f6e7959bcfd4a67d8e8f1444daf5db66eec7d',
        94844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '28f486663323e2bd208bf682f76178ff9978cb264b94f504a7e9dacb715ee335',
        90768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cd1de6f64dea5a641ffca2aa1c1e458e347908aa2da906c53c903381836e688c',
        94904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61b8b9f9390338f5092d2fa2324b2c99bbbd88cc1dbef00e664f391f10420ccb',
        90812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2e2f02d1d18e989201213f5aed8d532ae491acc8e8a7449177a7c59078c30c95',
        94892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b074f3588be99d7cc2fbd25efac9933759917f08410a5ee3711f3c63d3de07bb',
        91056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f6fe24132b17c4b8279fbe2f9009fffadf230275f6961cf24a95c82c7dcce00d',
        95148,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '17eaf000ca0187a0eff7658641378d5664cd2ce06f8d6bef14b398af0b9653e3',
        91436,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b44f6ffad85082379da59b955a624e1f6aff2c8e8c379aa294f6aae0dd18063',
        95536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93e70d239d6f7d22aaf8b6d7214ded57337970072666adcd713308256e2627f7',
        91572,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '05b63b4c7ac1dfd7728ce6e5900d298b3e71448d53de9806a829ee573e753c5f',
        95676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7d38bae129f3d636173c819f299a177459ef24dfa5acd1578310accd1e293ef',
        91580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '69debd15379aa77b8540f28a78070ed9b269fd09fb1056d4c340249555cecceb',
        95776,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3cf96c83585bc41b03dededa237eed03f51296a958a9fc62cba76f2126118dd3',
        91576,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ca850f027c7553ae4382d9ffe1d8ea6b25f8faf5cc77138fc92e3cc040da225d',
        95872,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'K2D',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the K2D font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/K2D
  static TextTheme k2dTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: k2d(textStyle: textTheme.displayLarge),
      displayMedium: k2d(textStyle: textTheme.displayMedium),
      displaySmall: k2d(textStyle: textTheme.displaySmall),
      headlineLarge: k2d(textStyle: textTheme.headlineLarge),
      headlineMedium: k2d(textStyle: textTheme.headlineMedium),
      headlineSmall: k2d(textStyle: textTheme.headlineSmall),
      titleLarge: k2d(textStyle: textTheme.titleLarge),
      titleMedium: k2d(textStyle: textTheme.titleMedium),
      titleSmall: k2d(textStyle: textTheme.titleSmall),
      bodyLarge: k2d(textStyle: textTheme.bodyLarge),
      bodyMedium: k2d(textStyle: textTheme.bodyMedium),
      bodySmall: k2d(textStyle: textTheme.bodySmall),
      labelLarge: k2d(textStyle: textTheme.labelLarge),
      labelMedium: k2d(textStyle: textTheme.labelMedium),
      labelSmall: k2d(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kablammo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kablammo
  static TextStyle kablammo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a0d2b81bb2e24a2442fd9fbc222436da0c211f5256a837aa53f7112193894bb5',
        584036,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kablammo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kablammo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kablammo
  static TextTheme kablammoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kablammo(textStyle: textTheme.displayLarge),
      displayMedium: kablammo(textStyle: textTheme.displayMedium),
      displaySmall: kablammo(textStyle: textTheme.displaySmall),
      headlineLarge: kablammo(textStyle: textTheme.headlineLarge),
      headlineMedium: kablammo(textStyle: textTheme.headlineMedium),
      headlineSmall: kablammo(textStyle: textTheme.headlineSmall),
      titleLarge: kablammo(textStyle: textTheme.titleLarge),
      titleMedium: kablammo(textStyle: textTheme.titleMedium),
      titleSmall: kablammo(textStyle: textTheme.titleSmall),
      bodyLarge: kablammo(textStyle: textTheme.bodyLarge),
      bodyMedium: kablammo(textStyle: textTheme.bodyMedium),
      bodySmall: kablammo(textStyle: textTheme.bodySmall),
      labelLarge: kablammo(textStyle: textTheme.labelLarge),
      labelMedium: kablammo(textStyle: textTheme.labelMedium),
      labelSmall: kablammo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kadwa font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kadwa
  static TextStyle kadwa({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2c763ec1e0c4882c631072fe5ac032dd107fb4e180e2dd705811dc31323e8aa',
        148896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07d8d7119e2ee9657f081ab3a42cbe55676c7deebf4a34b332917fb60e686ae0',
        141008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kadwa',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kadwa font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kadwa
  static TextTheme kadwaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kadwa(textStyle: textTheme.displayLarge),
      displayMedium: kadwa(textStyle: textTheme.displayMedium),
      displaySmall: kadwa(textStyle: textTheme.displaySmall),
      headlineLarge: kadwa(textStyle: textTheme.headlineLarge),
      headlineMedium: kadwa(textStyle: textTheme.headlineMedium),
      headlineSmall: kadwa(textStyle: textTheme.headlineSmall),
      titleLarge: kadwa(textStyle: textTheme.titleLarge),
      titleMedium: kadwa(textStyle: textTheme.titleMedium),
      titleSmall: kadwa(textStyle: textTheme.titleSmall),
      bodyLarge: kadwa(textStyle: textTheme.bodyLarge),
      bodyMedium: kadwa(textStyle: textTheme.bodyMedium),
      bodySmall: kadwa(textStyle: textTheme.bodySmall),
      labelLarge: kadwa(textStyle: textTheme.labelLarge),
      labelMedium: kadwa(textStyle: textTheme.labelMedium),
      labelSmall: kadwa(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kaisei Decol font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Decol
  static TextStyle kaiseiDecol({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae8676268347f3f666e023fce2288b1becca0acaec604c754503c3ddabf502e8',
        4162272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '32091b8f3d69899426f26c7ba9a7379e44fcffc1a3657ade6e5da268b7cf0f9d',
        3965292,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0ad73d25293ba4387b4df23d6c1e9d360c35b5dda236c9bd2d4f9923fc402968',
        3954772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KaiseiDecol',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kaisei Decol font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Decol
  static TextTheme kaiseiDecolTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kaiseiDecol(textStyle: textTheme.displayLarge),
      displayMedium: kaiseiDecol(textStyle: textTheme.displayMedium),
      displaySmall: kaiseiDecol(textStyle: textTheme.displaySmall),
      headlineLarge: kaiseiDecol(textStyle: textTheme.headlineLarge),
      headlineMedium: kaiseiDecol(textStyle: textTheme.headlineMedium),
      headlineSmall: kaiseiDecol(textStyle: textTheme.headlineSmall),
      titleLarge: kaiseiDecol(textStyle: textTheme.titleLarge),
      titleMedium: kaiseiDecol(textStyle: textTheme.titleMedium),
      titleSmall: kaiseiDecol(textStyle: textTheme.titleSmall),
      bodyLarge: kaiseiDecol(textStyle: textTheme.bodyLarge),
      bodyMedium: kaiseiDecol(textStyle: textTheme.bodyMedium),
      bodySmall: kaiseiDecol(textStyle: textTheme.bodySmall),
      labelLarge: kaiseiDecol(textStyle: textTheme.labelLarge),
      labelMedium: kaiseiDecol(textStyle: textTheme.labelMedium),
      labelSmall: kaiseiDecol(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kaisei HarunoUmi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+HarunoUmi
  static TextStyle kaiseiHarunoUmi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8a6fa5812f88f851ff77aba5f29fb010c38edd23b3af21d28e5dff037465ecc',
        4208568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0c1437ad15cc9376a947e61e4e0db54e13daa3790150461fd267bbde64f5909',
        4009888,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1aa7ea08df69d80950ea9f5214a797a06c1ea66e180dd7f26c2c9b4111f80cad',
        4000392,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KaiseiHarunoUmi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kaisei HarunoUmi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+HarunoUmi
  static TextTheme kaiseiHarunoUmiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kaiseiHarunoUmi(textStyle: textTheme.displayLarge),
      displayMedium: kaiseiHarunoUmi(textStyle: textTheme.displayMedium),
      displaySmall: kaiseiHarunoUmi(textStyle: textTheme.displaySmall),
      headlineLarge: kaiseiHarunoUmi(textStyle: textTheme.headlineLarge),
      headlineMedium: kaiseiHarunoUmi(textStyle: textTheme.headlineMedium),
      headlineSmall: kaiseiHarunoUmi(textStyle: textTheme.headlineSmall),
      titleLarge: kaiseiHarunoUmi(textStyle: textTheme.titleLarge),
      titleMedium: kaiseiHarunoUmi(textStyle: textTheme.titleMedium),
      titleSmall: kaiseiHarunoUmi(textStyle: textTheme.titleSmall),
      bodyLarge: kaiseiHarunoUmi(textStyle: textTheme.bodyLarge),
      bodyMedium: kaiseiHarunoUmi(textStyle: textTheme.bodyMedium),
      bodySmall: kaiseiHarunoUmi(textStyle: textTheme.bodySmall),
      labelLarge: kaiseiHarunoUmi(textStyle: textTheme.labelLarge),
      labelMedium: kaiseiHarunoUmi(textStyle: textTheme.labelMedium),
      labelSmall: kaiseiHarunoUmi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kaisei Opti font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Opti
  static TextStyle kaiseiOpti({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '47395621672a90047f82385473ab4cb145432ab40cd597ae4928f9e71c4c3aa7',
        4162144,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e82b9f62169233a376c7c5d36eced32168859574142e70065137381adb06ce18',
        3965476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '551de8f3873b1b4b0924d176fd10ccdd229febaf4496c03356176813dfa28812',
        3955376,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KaiseiOpti',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kaisei Opti font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Opti
  static TextTheme kaiseiOptiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kaiseiOpti(textStyle: textTheme.displayLarge),
      displayMedium: kaiseiOpti(textStyle: textTheme.displayMedium),
      displaySmall: kaiseiOpti(textStyle: textTheme.displaySmall),
      headlineLarge: kaiseiOpti(textStyle: textTheme.headlineLarge),
      headlineMedium: kaiseiOpti(textStyle: textTheme.headlineMedium),
      headlineSmall: kaiseiOpti(textStyle: textTheme.headlineSmall),
      titleLarge: kaiseiOpti(textStyle: textTheme.titleLarge),
      titleMedium: kaiseiOpti(textStyle: textTheme.titleMedium),
      titleSmall: kaiseiOpti(textStyle: textTheme.titleSmall),
      bodyLarge: kaiseiOpti(textStyle: textTheme.bodyLarge),
      bodyMedium: kaiseiOpti(textStyle: textTheme.bodyMedium),
      bodySmall: kaiseiOpti(textStyle: textTheme.bodySmall),
      labelLarge: kaiseiOpti(textStyle: textTheme.labelLarge),
      labelMedium: kaiseiOpti(textStyle: textTheme.labelMedium),
      labelSmall: kaiseiOpti(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kaisei Tokumin font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Tokumin
  static TextStyle kaiseiTokumin({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '790ce97811960a925ea4c0b5a0ed84e08a6a4f9cef5d49f18f71d3d3e7bb8360',
        4215052,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6d1259427a9099137280a32061bb0fb25d991904acffd82b81fb6dcef41bd289',
        4009556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ed3767bd60bc3b37cc8358a63734d1ee6691dad4cb8ef5835cd19f9baf1854f4',
        4010064,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e375908fdfe08cce90ba3e1cbf6f79df7ece586c0127a7bc971228da33d91992',
        4192728,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KaiseiTokumin',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kaisei Tokumin font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaisei+Tokumin
  static TextTheme kaiseiTokuminTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kaiseiTokumin(textStyle: textTheme.displayLarge),
      displayMedium: kaiseiTokumin(textStyle: textTheme.displayMedium),
      displaySmall: kaiseiTokumin(textStyle: textTheme.displaySmall),
      headlineLarge: kaiseiTokumin(textStyle: textTheme.headlineLarge),
      headlineMedium: kaiseiTokumin(textStyle: textTheme.headlineMedium),
      headlineSmall: kaiseiTokumin(textStyle: textTheme.headlineSmall),
      titleLarge: kaiseiTokumin(textStyle: textTheme.titleLarge),
      titleMedium: kaiseiTokumin(textStyle: textTheme.titleMedium),
      titleSmall: kaiseiTokumin(textStyle: textTheme.titleSmall),
      bodyLarge: kaiseiTokumin(textStyle: textTheme.bodyLarge),
      bodyMedium: kaiseiTokumin(textStyle: textTheme.bodyMedium),
      bodySmall: kaiseiTokumin(textStyle: textTheme.bodySmall),
      labelLarge: kaiseiTokumin(textStyle: textTheme.labelLarge),
      labelMedium: kaiseiTokumin(textStyle: textTheme.labelMedium),
      labelSmall: kaiseiTokumin(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kalam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalam
  static TextStyle kalam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98f38ed0ef0b7668d21ed9406906b6eb81450ab5212678e0b80243cbaea29db4',
        219580,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a37213f7be6a7e2f00eb6fae84583c0c0a9ff0c5bb397d63d7a6b6dac21ab8c4',
        219924,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '92cacefeee21ccdcb89245c9ab7e5ea7edd569703d5e493403d62a54e5c7534e',
        222188,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kalam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kalam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalam
  static TextTheme kalamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kalam(textStyle: textTheme.displayLarge),
      displayMedium: kalam(textStyle: textTheme.displayMedium),
      displaySmall: kalam(textStyle: textTheme.displaySmall),
      headlineLarge: kalam(textStyle: textTheme.headlineLarge),
      headlineMedium: kalam(textStyle: textTheme.headlineMedium),
      headlineSmall: kalam(textStyle: textTheme.headlineSmall),
      titleLarge: kalam(textStyle: textTheme.titleLarge),
      titleMedium: kalam(textStyle: textTheme.titleMedium),
      titleSmall: kalam(textStyle: textTheme.titleSmall),
      bodyLarge: kalam(textStyle: textTheme.bodyLarge),
      bodyMedium: kalam(textStyle: textTheme.bodyMedium),
      bodySmall: kalam(textStyle: textTheme.bodySmall),
      labelLarge: kalam(textStyle: textTheme.labelLarge),
      labelMedium: kalam(textStyle: textTheme.labelMedium),
      labelSmall: kalam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kalnia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalnia
  static TextStyle kalnia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '33f2d79021707d9f3c379a6a89292b219e4d1d812adc0a643ae7a21f9c64ce5b',
        42608,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5dbc9ca69d9efb59741dc0e80eb55d8bcd3bc673bf69f82c6e7447d77dd3951f',
        42848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb03b481ea18c787e6153fdfc680e0d70c8427e54f29c2889420c16dd31212b3',
        42904,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8b218dc5767df65e0d58be151fd2d6d896df52b990a9db860d098592796ec3fc',
        42844,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1f872124b877ab6501d657e3cbb79560d6c87c2afdfa6b08f6c5097943998549',
        42940,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09bd1c45692ebba43d2b98b14d3771cba2e5b62107003a30cd425dfd00f403c0',
        42944,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a965faa7488fdfc79bd5612c87f45ac406c3e512c43b910e0ef33193e2f246d',
        42804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kalnia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kalnia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalnia
  static TextTheme kalniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kalnia(textStyle: textTheme.displayLarge),
      displayMedium: kalnia(textStyle: textTheme.displayMedium),
      displaySmall: kalnia(textStyle: textTheme.displaySmall),
      headlineLarge: kalnia(textStyle: textTheme.headlineLarge),
      headlineMedium: kalnia(textStyle: textTheme.headlineMedium),
      headlineSmall: kalnia(textStyle: textTheme.headlineSmall),
      titleLarge: kalnia(textStyle: textTheme.titleLarge),
      titleMedium: kalnia(textStyle: textTheme.titleMedium),
      titleSmall: kalnia(textStyle: textTheme.titleSmall),
      bodyLarge: kalnia(textStyle: textTheme.bodyLarge),
      bodyMedium: kalnia(textStyle: textTheme.bodyMedium),
      bodySmall: kalnia(textStyle: textTheme.bodySmall),
      labelLarge: kalnia(textStyle: textTheme.labelLarge),
      labelMedium: kalnia(textStyle: textTheme.labelMedium),
      labelSmall: kalnia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kalnia Glaze font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalnia+Glaze
  static TextStyle kalniaGlaze({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a92c49cc39868aa26f1f252b6c81f27575ed20014c91d9dd0bbc04cb03db8ca6',
        111068,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '30f428f0d5be3d7fc98613966b5ed850ad229e97bf2e4657dce17a7329db1999',
        111636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0edaf1b542826a904bfbdaee4d384e829cde3cef40906d4f4907581090ffe5c9',
        111676,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'be4974ba22d1e073503393f954cfad81499eaf3fd4e420aeb622055f7dc7d51b',
        111716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d80568ae654f369c19ea3b955a29a9265380003c59c435b37ba6b284d1d5aed',
        111812,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9431fa2c3d86c4033cfd5b3acd4549f4d1a85803a487b1af9b4006a28e9910d1',
        111772,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '15feb91c80633d47093a5385559b5c0f089f5f75c896dd1d490c43bdefc99b82',
        111360,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KalniaGlaze',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kalnia Glaze font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kalnia+Glaze
  static TextTheme kalniaGlazeTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kalniaGlaze(textStyle: textTheme.displayLarge),
      displayMedium: kalniaGlaze(textStyle: textTheme.displayMedium),
      displaySmall: kalniaGlaze(textStyle: textTheme.displaySmall),
      headlineLarge: kalniaGlaze(textStyle: textTheme.headlineLarge),
      headlineMedium: kalniaGlaze(textStyle: textTheme.headlineMedium),
      headlineSmall: kalniaGlaze(textStyle: textTheme.headlineSmall),
      titleLarge: kalniaGlaze(textStyle: textTheme.titleLarge),
      titleMedium: kalniaGlaze(textStyle: textTheme.titleMedium),
      titleSmall: kalniaGlaze(textStyle: textTheme.titleSmall),
      bodyLarge: kalniaGlaze(textStyle: textTheme.bodyLarge),
      bodyMedium: kalniaGlaze(textStyle: textTheme.bodyMedium),
      bodySmall: kalniaGlaze(textStyle: textTheme.bodySmall),
      labelLarge: kalniaGlaze(textStyle: textTheme.labelLarge),
      labelMedium: kalniaGlaze(textStyle: textTheme.labelMedium),
      labelSmall: kalniaGlaze(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kameron font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kameron
  static TextStyle kameron({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4222eb989aafbc27fc823fef2d3d2e46cf914e6f5f86b15520aa3a98ae751c6',
        47672,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '98fd62af66bf09aa2cbc2f57f589e840e42f002407fef3371b16799057cb8e78',
        48044,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e666742a06748d5511c2418d407a31d17ca61bb524c857e331674cfcf6bb8903',
        48272,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd301f825fa28a8bdc0eca291114536dcf0ae46b3e0a3150fe7c8333d99f3aa33',
        48180,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kameron',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kameron font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kameron
  static TextTheme kameronTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kameron(textStyle: textTheme.displayLarge),
      displayMedium: kameron(textStyle: textTheme.displayMedium),
      displaySmall: kameron(textStyle: textTheme.displaySmall),
      headlineLarge: kameron(textStyle: textTheme.headlineLarge),
      headlineMedium: kameron(textStyle: textTheme.headlineMedium),
      headlineSmall: kameron(textStyle: textTheme.headlineSmall),
      titleLarge: kameron(textStyle: textTheme.titleLarge),
      titleMedium: kameron(textStyle: textTheme.titleMedium),
      titleSmall: kameron(textStyle: textTheme.titleSmall),
      bodyLarge: kameron(textStyle: textTheme.bodyLarge),
      bodyMedium: kameron(textStyle: textTheme.bodyMedium),
      bodySmall: kameron(textStyle: textTheme.bodySmall),
      labelLarge: kameron(textStyle: textTheme.labelLarge),
      labelMedium: kameron(textStyle: textTheme.labelMedium),
      labelSmall: kameron(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kanit font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kanit
  static TextStyle kanit({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '89abc17b0270f8e2a3e8e6efef2ed937be803454ca283ef6c0ac212dccd5db27',
        89304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b62cc67c0f311b3b9f1f073fbee7969853ff2bb99a291f88779b2b5ecbb8d507',
        93928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b5ce00d37fe417f5c949eea8241c961cee2b6817824a5785bd29fb21029a5cad',
        88592,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '9e1117c3aa8a5ac0f7af89e69c9a707781e81805cd16825bf68c6d868604b6d1',
        93544,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '939503d3fc352e4ab852aeec3f49ac199b6e566cb447b88bc75460552ee42916',
        88744,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f622bca8d685ec98edf87c6326188e9ccd13012b6b1e3337cdfbcd1b1c976bca',
        93564,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'aeb8034dc3581ee3c5a3248fcd40691d7bc26199ea13caf373d1c2c7028a549d',
        88056,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4cf4b527c73aae5724289c2f394075210c27a9f6545fc8c9b2d9f459b013a457',
        93008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1d33e5da88a4724c9539c98de6e378fc8ae32d5b961142efedd7961cd486915a',
        87548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '098a8e7b3e2a73f7ea59df49dfd5ff666a7fe5a6d952137edf4a889725738a87',
        92712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '57ca406a73b67768f40cce3167e5bdb469c9bc59bd174a51c52730b860966f54',
        87732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '02191a49bca560c28140f3d620b09922ea3fdb64854dfb83eae7ec5da773d13b',
        92928,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '868f32e8214dff27a45b9d442e65aa6efbe8e3568b4669fe1197da7bfbbfe92b',
        87448,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'ff779ef7a17d68f144141d0b928be0ab41905980cc43e950d113163335b3fcf0',
        98732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '144413a901c2e7192425dd321a9fd1fcfc2d1fb5045247b76f8cdac74c7a24c0',
        87604,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7eb9141ce91ce0562610f9b1260deb759b07d6d73030d86efbdad41d93e6dc36',
        98916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4c1baf318dd15b2200b6656edc8444e26930ae1a44b1fcbb3a5457cd9d394136',
        87400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '913792ab374a0576e0f15440efccb10677be9a4aa23cbf667671a63c69799a8e',
        98380,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kanit',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kanit font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kanit
  static TextTheme kanitTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kanit(textStyle: textTheme.displayLarge),
      displayMedium: kanit(textStyle: textTheme.displayMedium),
      displaySmall: kanit(textStyle: textTheme.displaySmall),
      headlineLarge: kanit(textStyle: textTheme.headlineLarge),
      headlineMedium: kanit(textStyle: textTheme.headlineMedium),
      headlineSmall: kanit(textStyle: textTheme.headlineSmall),
      titleLarge: kanit(textStyle: textTheme.titleLarge),
      titleMedium: kanit(textStyle: textTheme.titleMedium),
      titleSmall: kanit(textStyle: textTheme.titleSmall),
      bodyLarge: kanit(textStyle: textTheme.bodyLarge),
      bodyMedium: kanit(textStyle: textTheme.bodyMedium),
      bodySmall: kanit(textStyle: textTheme.bodySmall),
      labelLarge: kanit(textStyle: textTheme.labelLarge),
      labelMedium: kanit(textStyle: textTheme.labelMedium),
      labelSmall: kanit(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kantumruy Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kantumruy+Pro
  static TextStyle kantumruyPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8774d6ba403909ddd54e6b2e18e43867d19f5363f3d27a11b61c88ef94494566',
        91600,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e0d148fdc7758a4e3ecc0e958ed200fafc1f009283073f1859ab2cd82d75db3a',
        91880,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '868b091147e9811670db2b58f8ae50f2b60112ed7b43d8c0687364c97c4f818e',
        91836,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a43f29e793b554abd46f7b17ea4e024d31e4e66b46d82fbe9cdb2f3490ecbfc7',
        91584,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd6a13f77034f52ced78b80437b1a61da765ed4559a0a59c778faa4b01ec12647',
        91796,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e49bc2a253cff8663b397c50189fc753fe3f87078d2d4f56c7e9e72d9b116e78',
        91848,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55ba36f9e41641f7e5c87dbb8c40afb7e08c5bf52c3bbfa49a76aff022b9c73a',
        91560,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b8694b855d10b467b45350f282252dda65b806e363f2e88a7ad331c85ef6ef33',
        100300,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '7ac72cb43a3800d9d18876d2df901537b57d930814560b3f73b1aede89ce4a30',
        100540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'd5beebfa09ceeeb2b5e09ac8e51a9d46da1f4a34586b37eb85cf34079111c5e0',
        100388,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4e4273bbbdebab2c5bb900193b92e3be9fd9f489c50dcc436331fd3e9bfa52df',
        100096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5ab197ec2cc52eec84b8a1045f3f75189f760fd35c2ac13451e92e72f8db679f',
        100428,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f5116a9ab443e7e9961067c379fb18c3960ef6e0e9a61848a411ecf29e889924',
        100456,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b2f6940aaa990eb5667f97fe50cb8611a95fb58a205d1a37b25d1309f8680d46',
        100152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KantumruyPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kantumruy Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kantumruy+Pro
  static TextTheme kantumruyProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kantumruyPro(textStyle: textTheme.displayLarge),
      displayMedium: kantumruyPro(textStyle: textTheme.displayMedium),
      displaySmall: kantumruyPro(textStyle: textTheme.displaySmall),
      headlineLarge: kantumruyPro(textStyle: textTheme.headlineLarge),
      headlineMedium: kantumruyPro(textStyle: textTheme.headlineMedium),
      headlineSmall: kantumruyPro(textStyle: textTheme.headlineSmall),
      titleLarge: kantumruyPro(textStyle: textTheme.titleLarge),
      titleMedium: kantumruyPro(textStyle: textTheme.titleMedium),
      titleSmall: kantumruyPro(textStyle: textTheme.titleSmall),
      bodyLarge: kantumruyPro(textStyle: textTheme.bodyLarge),
      bodyMedium: kantumruyPro(textStyle: textTheme.bodyMedium),
      bodySmall: kantumruyPro(textStyle: textTheme.bodySmall),
      labelLarge: kantumruyPro(textStyle: textTheme.labelLarge),
      labelMedium: kantumruyPro(textStyle: textTheme.labelMedium),
      labelSmall: kantumruyPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Karantina font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karantina
  static TextStyle karantina({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3a2ce17238047c9964df1863ddd90832959eaad256b36a297a61eabd0cfa1ef6',
        34184,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2375b1a0b5b75fbe05d9015edc9fcd67315c8b2c444b0c18d2e71c8b9efedfca',
        33360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '100bfec07d150200573f5b94e85af38ab6b9a91d7232e5d3f6e8a0af6c742c2a',
        29964,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Karantina',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Karantina font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karantina
  static TextTheme karantinaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: karantina(textStyle: textTheme.displayLarge),
      displayMedium: karantina(textStyle: textTheme.displayMedium),
      displaySmall: karantina(textStyle: textTheme.displaySmall),
      headlineLarge: karantina(textStyle: textTheme.headlineLarge),
      headlineMedium: karantina(textStyle: textTheme.headlineMedium),
      headlineSmall: karantina(textStyle: textTheme.headlineSmall),
      titleLarge: karantina(textStyle: textTheme.titleLarge),
      titleMedium: karantina(textStyle: textTheme.titleMedium),
      titleSmall: karantina(textStyle: textTheme.titleSmall),
      bodyLarge: karantina(textStyle: textTheme.bodyLarge),
      bodyMedium: karantina(textStyle: textTheme.bodyMedium),
      bodySmall: karantina(textStyle: textTheme.bodySmall),
      labelLarge: karantina(textStyle: textTheme.labelLarge),
      labelMedium: karantina(textStyle: textTheme.labelMedium),
      labelSmall: karantina(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Karla font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karla
  static TextStyle karla({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'bb778259075f5f3b007e9d7c03b1fe89164f27ffe5e0abd87d843cd7dc5d5e0b',
        41552,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0e37bd693a3f097c4592f4a2a1b31599db8bf3193c6722a1aac8df0be7c9ac8',
        41568,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dddc66a219388caace4969be4b8255b423a0d3ce64504ca3fe36df0503039c0f',
        41492,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f2e2d3ab86931d8cc9aa5702de6a3f60e64107c5c9bef8f59984693f30d5d9cd',
        41536,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'de8560df108e22a3a3e24f3bcf9fa2d9085614b4985c69bb85279499384e6e45',
        41588,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '10a218af3d65a3b1509029fcaf4f7d93be6037364d7e0ad8a6ee337928dbf690',
        41556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e8d5e69bd4e1e0bb2dcdf9eba86795c4d5110e749e4bea382c1513926561248d',
        41916,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3f6c960b60f75df2289e30389bc36213360701fcfcb269be1485266afe59fdbf',
        42556,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '4aea1c9ef816984793d05feeb7b70745e06344f0e1ce706df8331d934ead0dfc',
        42480,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '3a593133135e6b3610919577290740ed884dca5b231c0ba59569c35296740d4a',
        42336,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fd9b9781f2be0edcfe7477b355cb6e2ef449f96abd474cebc2be06b89b2ad294',
        42452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'fed9f68891d1fc44735e42f240d9cbcfc0f92d8450213b914560eebbc7c5a2ff',
        42476,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '45096fcf46f5e1d830139e939b7c585a67a289a503b8ebf528cc287df29bb983',
        42360,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '930b530da6a0687c7eabab484f4fdaa22cff00e15e0cac2884a6227cbcceca86',
        42772,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Karla',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Karla font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karla
  static TextTheme karlaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: karla(textStyle: textTheme.displayLarge),
      displayMedium: karla(textStyle: textTheme.displayMedium),
      displaySmall: karla(textStyle: textTheme.displaySmall),
      headlineLarge: karla(textStyle: textTheme.headlineLarge),
      headlineMedium: karla(textStyle: textTheme.headlineMedium),
      headlineSmall: karla(textStyle: textTheme.headlineSmall),
      titleLarge: karla(textStyle: textTheme.titleLarge),
      titleMedium: karla(textStyle: textTheme.titleMedium),
      titleSmall: karla(textStyle: textTheme.titleSmall),
      bodyLarge: karla(textStyle: textTheme.bodyLarge),
      bodyMedium: karla(textStyle: textTheme.bodyMedium),
      bodySmall: karla(textStyle: textTheme.bodySmall),
      labelLarge: karla(textStyle: textTheme.labelLarge),
      labelMedium: karla(textStyle: textTheme.labelMedium),
      labelSmall: karla(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Karma font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karma
  static TextStyle karma({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '344164aebe4f1ed23545de9d615aecda387c6216d5e056ba687875387b087fce',
        196104,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dee431fbbb1fd0a05c527b683771e37db53f426ea405a5effa61ad24f0839d3e',
        196176,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd82009628e6e241bf62bfecac5e636220686e8c1758e6ca6269f11372f302f0e',
        195092,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '23cbb1312f4c9a9f9b23e9b43628a09e46c72a96ca6ce8e6424ea37d6aee0bdf',
        196008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '080acbea749b811f412e88a59438d51825433cb70fb2c2d42daae10bfba0f851',
        196568,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Karma',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Karma font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Karma
  static TextTheme karmaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: karma(textStyle: textTheme.displayLarge),
      displayMedium: karma(textStyle: textTheme.displayMedium),
      displaySmall: karma(textStyle: textTheme.displaySmall),
      headlineLarge: karma(textStyle: textTheme.headlineLarge),
      headlineMedium: karma(textStyle: textTheme.headlineMedium),
      headlineSmall: karma(textStyle: textTheme.headlineSmall),
      titleLarge: karma(textStyle: textTheme.titleLarge),
      titleMedium: karma(textStyle: textTheme.titleMedium),
      titleSmall: karma(textStyle: textTheme.titleSmall),
      bodyLarge: karma(textStyle: textTheme.bodyLarge),
      bodyMedium: karma(textStyle: textTheme.bodyMedium),
      bodySmall: karma(textStyle: textTheme.bodySmall),
      labelLarge: karma(textStyle: textTheme.labelLarge),
      labelMedium: karma(textStyle: textTheme.labelMedium),
      labelSmall: karma(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Katibeh font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Katibeh
  static TextStyle katibeh({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cc9edd52cf618871ffcb70c91b553efb9edfadf5dd68594776bc50d2c2a64aa7',
        160044,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Katibeh',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Katibeh font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Katibeh
  static TextTheme katibehTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: katibeh(textStyle: textTheme.displayLarge),
      displayMedium: katibeh(textStyle: textTheme.displayMedium),
      displaySmall: katibeh(textStyle: textTheme.displaySmall),
      headlineLarge: katibeh(textStyle: textTheme.headlineLarge),
      headlineMedium: katibeh(textStyle: textTheme.headlineMedium),
      headlineSmall: katibeh(textStyle: textTheme.headlineSmall),
      titleLarge: katibeh(textStyle: textTheme.titleLarge),
      titleMedium: katibeh(textStyle: textTheme.titleMedium),
      titleSmall: katibeh(textStyle: textTheme.titleSmall),
      bodyLarge: katibeh(textStyle: textTheme.bodyLarge),
      bodyMedium: katibeh(textStyle: textTheme.bodyMedium),
      bodySmall: katibeh(textStyle: textTheme.bodySmall),
      labelLarge: katibeh(textStyle: textTheme.labelLarge),
      labelMedium: katibeh(textStyle: textTheme.labelMedium),
      labelSmall: katibeh(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kaushan Script font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaushan+Script
  static TextStyle kaushanScript({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a9057b41728a3e9df253e4c23e7189096e50c2d144370801f524d727a741d76',
        108288,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KaushanScript',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kaushan Script font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kaushan+Script
  static TextTheme kaushanScriptTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kaushanScript(textStyle: textTheme.displayLarge),
      displayMedium: kaushanScript(textStyle: textTheme.displayMedium),
      displaySmall: kaushanScript(textStyle: textTheme.displaySmall),
      headlineLarge: kaushanScript(textStyle: textTheme.headlineLarge),
      headlineMedium: kaushanScript(textStyle: textTheme.headlineMedium),
      headlineSmall: kaushanScript(textStyle: textTheme.headlineSmall),
      titleLarge: kaushanScript(textStyle: textTheme.titleLarge),
      titleMedium: kaushanScript(textStyle: textTheme.titleMedium),
      titleSmall: kaushanScript(textStyle: textTheme.titleSmall),
      bodyLarge: kaushanScript(textStyle: textTheme.bodyLarge),
      bodyMedium: kaushanScript(textStyle: textTheme.bodyMedium),
      bodySmall: kaushanScript(textStyle: textTheme.bodySmall),
      labelLarge: kaushanScript(textStyle: textTheme.labelLarge),
      labelMedium: kaushanScript(textStyle: textTheme.labelMedium),
      labelSmall: kaushanScript(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kavivanar font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kavivanar
  static TextStyle kavivanar({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07e301f9748840e7500eb928d7c88907c1db864022fedc098a3d713435392bcb',
        64672,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kavivanar',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kavivanar font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kavivanar
  static TextTheme kavivanarTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kavivanar(textStyle: textTheme.displayLarge),
      displayMedium: kavivanar(textStyle: textTheme.displayMedium),
      displaySmall: kavivanar(textStyle: textTheme.displaySmall),
      headlineLarge: kavivanar(textStyle: textTheme.headlineLarge),
      headlineMedium: kavivanar(textStyle: textTheme.headlineMedium),
      headlineSmall: kavivanar(textStyle: textTheme.headlineSmall),
      titleLarge: kavivanar(textStyle: textTheme.titleLarge),
      titleMedium: kavivanar(textStyle: textTheme.titleMedium),
      titleSmall: kavivanar(textStyle: textTheme.titleSmall),
      bodyLarge: kavivanar(textStyle: textTheme.bodyLarge),
      bodyMedium: kavivanar(textStyle: textTheme.bodyMedium),
      bodySmall: kavivanar(textStyle: textTheme.bodySmall),
      labelLarge: kavivanar(textStyle: textTheme.labelLarge),
      labelMedium: kavivanar(textStyle: textTheme.labelMedium),
      labelSmall: kavivanar(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kavoon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kavoon
  static TextStyle kavoon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a24b6a315e06da5cb836ab6e0349c9a384e2d5fd70e12ef82dc29e51f402d997',
        48948,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kavoon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kavoon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kavoon
  static TextTheme kavoonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kavoon(textStyle: textTheme.displayLarge),
      displayMedium: kavoon(textStyle: textTheme.displayMedium),
      displaySmall: kavoon(textStyle: textTheme.displaySmall),
      headlineLarge: kavoon(textStyle: textTheme.headlineLarge),
      headlineMedium: kavoon(textStyle: textTheme.headlineMedium),
      headlineSmall: kavoon(textStyle: textTheme.headlineSmall),
      titleLarge: kavoon(textStyle: textTheme.titleLarge),
      titleMedium: kavoon(textStyle: textTheme.titleMedium),
      titleSmall: kavoon(textStyle: textTheme.titleSmall),
      bodyLarge: kavoon(textStyle: textTheme.bodyLarge),
      bodyMedium: kavoon(textStyle: textTheme.bodyMedium),
      bodySmall: kavoon(textStyle: textTheme.bodySmall),
      labelLarge: kavoon(textStyle: textTheme.labelLarge),
      labelMedium: kavoon(textStyle: textTheme.labelMedium),
      labelSmall: kavoon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kay Pho Du font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kay+Pho+Du
  static TextStyle kayPhoDu({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '63ceb6f96a6519c8efddd85e998b9793ed73079ec5f468169148b97e5231b84e',
        34660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9f0cdb1abfa202e949a90ea4c131139e2bddfffa42bb946912f185c44b8a8bb',
        34408,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f4b5c6db44c3286978b45fde5c8f657c25fd98972d0ced5dd63ffe1ea339ba35',
        33800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'deebd6d1ce28923c6c9562c5bd5e596992efb8265482e05ecfe3563da56c3422',
        33704,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KayPhoDu',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kay Pho Du font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kay+Pho+Du
  static TextTheme kayPhoDuTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kayPhoDu(textStyle: textTheme.displayLarge),
      displayMedium: kayPhoDu(textStyle: textTheme.displayMedium),
      displaySmall: kayPhoDu(textStyle: textTheme.displaySmall),
      headlineLarge: kayPhoDu(textStyle: textTheme.headlineLarge),
      headlineMedium: kayPhoDu(textStyle: textTheme.headlineMedium),
      headlineSmall: kayPhoDu(textStyle: textTheme.headlineSmall),
      titleLarge: kayPhoDu(textStyle: textTheme.titleLarge),
      titleMedium: kayPhoDu(textStyle: textTheme.titleMedium),
      titleSmall: kayPhoDu(textStyle: textTheme.titleSmall),
      bodyLarge: kayPhoDu(textStyle: textTheme.bodyLarge),
      bodyMedium: kayPhoDu(textStyle: textTheme.bodyMedium),
      bodySmall: kayPhoDu(textStyle: textTheme.bodySmall),
      labelLarge: kayPhoDu(textStyle: textTheme.labelLarge),
      labelMedium: kayPhoDu(textStyle: textTheme.labelMedium),
      labelSmall: kayPhoDu(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kdam Thmor Pro font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kdam+Thmor+Pro
  static TextStyle kdamThmorPro({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '48dc205f7b2d71ca0519e72e19cafe8a8f14ccc1e46f08f3e17c446feacf33fa',
        51388,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KdamThmorPro',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kdam Thmor Pro font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kdam+Thmor+Pro
  static TextTheme kdamThmorProTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kdamThmorPro(textStyle: textTheme.displayLarge),
      displayMedium: kdamThmorPro(textStyle: textTheme.displayMedium),
      displaySmall: kdamThmorPro(textStyle: textTheme.displaySmall),
      headlineLarge: kdamThmorPro(textStyle: textTheme.headlineLarge),
      headlineMedium: kdamThmorPro(textStyle: textTheme.headlineMedium),
      headlineSmall: kdamThmorPro(textStyle: textTheme.headlineSmall),
      titleLarge: kdamThmorPro(textStyle: textTheme.titleLarge),
      titleMedium: kdamThmorPro(textStyle: textTheme.titleMedium),
      titleSmall: kdamThmorPro(textStyle: textTheme.titleSmall),
      bodyLarge: kdamThmorPro(textStyle: textTheme.bodyLarge),
      bodyMedium: kdamThmorPro(textStyle: textTheme.bodyMedium),
      bodySmall: kdamThmorPro(textStyle: textTheme.bodySmall),
      labelLarge: kdamThmorPro(textStyle: textTheme.labelLarge),
      labelMedium: kdamThmorPro(textStyle: textTheme.labelMedium),
      labelSmall: kdamThmorPro(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Keania One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Keania+One
  static TextStyle keaniaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c0eff4508a85967e2255b9ebe3ec7c91dc5cca10aac289f6c49a6c9e208ccc4b',
        35804,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KeaniaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Keania One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Keania+One
  static TextTheme keaniaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: keaniaOne(textStyle: textTheme.displayLarge),
      displayMedium: keaniaOne(textStyle: textTheme.displayMedium),
      displaySmall: keaniaOne(textStyle: textTheme.displaySmall),
      headlineLarge: keaniaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: keaniaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: keaniaOne(textStyle: textTheme.headlineSmall),
      titleLarge: keaniaOne(textStyle: textTheme.titleLarge),
      titleMedium: keaniaOne(textStyle: textTheme.titleMedium),
      titleSmall: keaniaOne(textStyle: textTheme.titleSmall),
      bodyLarge: keaniaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: keaniaOne(textStyle: textTheme.bodyMedium),
      bodySmall: keaniaOne(textStyle: textTheme.bodySmall),
      labelLarge: keaniaOne(textStyle: textTheme.labelLarge),
      labelMedium: keaniaOne(textStyle: textTheme.labelMedium),
      labelSmall: keaniaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kelly Slab font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kelly+Slab
  static TextStyle kellySlab({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1eb8624150c82edb34257144bc2454cfe28712b5d7bdf33c59f85d4cf1edf696',
        75408,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KellySlab',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kelly Slab font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kelly+Slab
  static TextTheme kellySlabTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kellySlab(textStyle: textTheme.displayLarge),
      displayMedium: kellySlab(textStyle: textTheme.displayMedium),
      displaySmall: kellySlab(textStyle: textTheme.displaySmall),
      headlineLarge: kellySlab(textStyle: textTheme.headlineLarge),
      headlineMedium: kellySlab(textStyle: textTheme.headlineMedium),
      headlineSmall: kellySlab(textStyle: textTheme.headlineSmall),
      titleLarge: kellySlab(textStyle: textTheme.titleLarge),
      titleMedium: kellySlab(textStyle: textTheme.titleMedium),
      titleSmall: kellySlab(textStyle: textTheme.titleSmall),
      bodyLarge: kellySlab(textStyle: textTheme.bodyLarge),
      bodyMedium: kellySlab(textStyle: textTheme.bodyMedium),
      bodySmall: kellySlab(textStyle: textTheme.bodySmall),
      labelLarge: kellySlab(textStyle: textTheme.labelLarge),
      labelMedium: kellySlab(textStyle: textTheme.labelMedium),
      labelSmall: kellySlab(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kenia font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kenia
  static TextStyle kenia({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b829019713cb82f54bbec80f1215b84900f68d5b66ee454ee0da12068e0053c3',
        35048,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kenia',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kenia font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kenia
  static TextTheme keniaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kenia(textStyle: textTheme.displayLarge),
      displayMedium: kenia(textStyle: textTheme.displayMedium),
      displaySmall: kenia(textStyle: textTheme.displaySmall),
      headlineLarge: kenia(textStyle: textTheme.headlineLarge),
      headlineMedium: kenia(textStyle: textTheme.headlineMedium),
      headlineSmall: kenia(textStyle: textTheme.headlineSmall),
      titleLarge: kenia(textStyle: textTheme.titleLarge),
      titleMedium: kenia(textStyle: textTheme.titleMedium),
      titleSmall: kenia(textStyle: textTheme.titleSmall),
      bodyLarge: kenia(textStyle: textTheme.bodyLarge),
      bodyMedium: kenia(textStyle: textTheme.bodyMedium),
      bodySmall: kenia(textStyle: textTheme.bodySmall),
      labelLarge: kenia(textStyle: textTheme.labelLarge),
      labelMedium: kenia(textStyle: textTheme.labelMedium),
      labelSmall: kenia(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Khand font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khand
  static TextStyle khand({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f91ee4572d5e011bece18be58aa213f8df1b51909d58d7acdfe0f09814b37e99',
        158712,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a47d69b6378a1099767ddc94911d4929aae181216a25a76d4a0f7e397b984938',
        158896,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8ecf733da2551e610629921af56f339ce4b82f7f1309dec8e0bef958b130fce2',
        158288,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fbadc108638950541c578e8a3af9827ba0ab5a8257bc564d0d088fdf761ea216',
        158528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '61ff54a9ccca365f2467e070f8480e48ddb093670d8af922a9c8ea960834955a',
        158060,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Khand',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Khand font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khand
  static TextTheme khandTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: khand(textStyle: textTheme.displayLarge),
      displayMedium: khand(textStyle: textTheme.displayMedium),
      displaySmall: khand(textStyle: textTheme.displaySmall),
      headlineLarge: khand(textStyle: textTheme.headlineLarge),
      headlineMedium: khand(textStyle: textTheme.headlineMedium),
      headlineSmall: khand(textStyle: textTheme.headlineSmall),
      titleLarge: khand(textStyle: textTheme.titleLarge),
      titleMedium: khand(textStyle: textTheme.titleMedium),
      titleSmall: khand(textStyle: textTheme.titleSmall),
      bodyLarge: khand(textStyle: textTheme.bodyLarge),
      bodyMedium: khand(textStyle: textTheme.bodyMedium),
      bodySmall: khand(textStyle: textTheme.bodySmall),
      labelLarge: khand(textStyle: textTheme.labelLarge),
      labelMedium: khand(textStyle: textTheme.labelMedium),
      labelSmall: khand(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Khmer font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khmer
  static TextStyle khmer({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a3cc399a50aba5db352582739c4a4b26a3ad8a3d61b655afca404e89345eb5f9',
        57876,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Khmer',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Khmer font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khmer
  static TextTheme khmerTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: khmer(textStyle: textTheme.displayLarge),
      displayMedium: khmer(textStyle: textTheme.displayMedium),
      displaySmall: khmer(textStyle: textTheme.displaySmall),
      headlineLarge: khmer(textStyle: textTheme.headlineLarge),
      headlineMedium: khmer(textStyle: textTheme.headlineMedium),
      headlineSmall: khmer(textStyle: textTheme.headlineSmall),
      titleLarge: khmer(textStyle: textTheme.titleLarge),
      titleMedium: khmer(textStyle: textTheme.titleMedium),
      titleSmall: khmer(textStyle: textTheme.titleSmall),
      bodyLarge: khmer(textStyle: textTheme.bodyLarge),
      bodyMedium: khmer(textStyle: textTheme.bodyMedium),
      bodySmall: khmer(textStyle: textTheme.bodySmall),
      labelLarge: khmer(textStyle: textTheme.labelLarge),
      labelMedium: khmer(textStyle: textTheme.labelMedium),
      labelSmall: khmer(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Khula font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khula
  static TextStyle khula({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f7131a5b8a11c092417a02236d6c3456b7bdc31339747aa5e8c12a56b368d323',
        98400,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9f87a8f1d35ec22b66d2b3d6ad93e8c2045429e01dc9f2dc4df29fdb3355c55c',
        96640,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd8c6f6c1f32156e2e300a740b793d254b91c7976cf565c3776321cb0e6ab8f6d',
        96524,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4f4c3d7045d8dfedf2a529510d1a62710f938486b8b5f4123f4a6244421950ea',
        96956,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f09091305f7583a00c809c0281eeb7371602f06278b403bba96edf90d442ca76',
        97932,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Khula',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Khula font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Khula
  static TextTheme khulaTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: khula(textStyle: textTheme.displayLarge),
      displayMedium: khula(textStyle: textTheme.displayMedium),
      displaySmall: khula(textStyle: textTheme.displaySmall),
      headlineLarge: khula(textStyle: textTheme.headlineLarge),
      headlineMedium: khula(textStyle: textTheme.headlineMedium),
      headlineSmall: khula(textStyle: textTheme.headlineSmall),
      titleLarge: khula(textStyle: textTheme.titleLarge),
      titleMedium: khula(textStyle: textTheme.titleMedium),
      titleSmall: khula(textStyle: textTheme.titleSmall),
      bodyLarge: khula(textStyle: textTheme.bodyLarge),
      bodyMedium: khula(textStyle: textTheme.bodyMedium),
      bodySmall: khula(textStyle: textTheme.bodySmall),
      labelLarge: khula(textStyle: textTheme.labelLarge),
      labelMedium: khula(textStyle: textTheme.labelMedium),
      labelSmall: khula(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kings font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kings
  static TextStyle kings({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '87b3bf25e34c066b975353d079ac48cb15f843a34d93def72ed2fd434d28fc76',
        115616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kings',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kings font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kings
  static TextTheme kingsTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kings(textStyle: textTheme.displayLarge),
      displayMedium: kings(textStyle: textTheme.displayMedium),
      displaySmall: kings(textStyle: textTheme.displaySmall),
      headlineLarge: kings(textStyle: textTheme.headlineLarge),
      headlineMedium: kings(textStyle: textTheme.headlineMedium),
      headlineSmall: kings(textStyle: textTheme.headlineSmall),
      titleLarge: kings(textStyle: textTheme.titleLarge),
      titleMedium: kings(textStyle: textTheme.titleMedium),
      titleSmall: kings(textStyle: textTheme.titleSmall),
      bodyLarge: kings(textStyle: textTheme.bodyLarge),
      bodyMedium: kings(textStyle: textTheme.bodyMedium),
      bodySmall: kings(textStyle: textTheme.bodySmall),
      labelLarge: kings(textStyle: textTheme.labelLarge),
      labelMedium: kings(textStyle: textTheme.labelMedium),
      labelSmall: kings(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kirang Haerang font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kirang+Haerang
  static TextStyle kirangHaerang({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'c2711563585c8e2a2ca6c9b4380b832e4c280cdb5bc8f78e8e406769c8d7a9b6',
        3555352,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KirangHaerang',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kirang Haerang font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kirang+Haerang
  static TextTheme kirangHaerangTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kirangHaerang(textStyle: textTheme.displayLarge),
      displayMedium: kirangHaerang(textStyle: textTheme.displayMedium),
      displaySmall: kirangHaerang(textStyle: textTheme.displaySmall),
      headlineLarge: kirangHaerang(textStyle: textTheme.headlineLarge),
      headlineMedium: kirangHaerang(textStyle: textTheme.headlineMedium),
      headlineSmall: kirangHaerang(textStyle: textTheme.headlineSmall),
      titleLarge: kirangHaerang(textStyle: textTheme.titleLarge),
      titleMedium: kirangHaerang(textStyle: textTheme.titleMedium),
      titleSmall: kirangHaerang(textStyle: textTheme.titleSmall),
      bodyLarge: kirangHaerang(textStyle: textTheme.bodyLarge),
      bodyMedium: kirangHaerang(textStyle: textTheme.bodyMedium),
      bodySmall: kirangHaerang(textStyle: textTheme.bodySmall),
      labelLarge: kirangHaerang(textStyle: textTheme.labelLarge),
      labelMedium: kirangHaerang(textStyle: textTheme.labelMedium),
      labelSmall: kirangHaerang(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kite One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kite+One
  static TextStyle kiteOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'e7605dc3b893ff72233157a71e08f00bb50bb0c108f25a84f5e4a6691f3adbc7',
        46404,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KiteOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kite One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kite+One
  static TextTheme kiteOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kiteOne(textStyle: textTheme.displayLarge),
      displayMedium: kiteOne(textStyle: textTheme.displayMedium),
      displaySmall: kiteOne(textStyle: textTheme.displaySmall),
      headlineLarge: kiteOne(textStyle: textTheme.headlineLarge),
      headlineMedium: kiteOne(textStyle: textTheme.headlineMedium),
      headlineSmall: kiteOne(textStyle: textTheme.headlineSmall),
      titleLarge: kiteOne(textStyle: textTheme.titleLarge),
      titleMedium: kiteOne(textStyle: textTheme.titleMedium),
      titleSmall: kiteOne(textStyle: textTheme.titleSmall),
      bodyLarge: kiteOne(textStyle: textTheme.bodyLarge),
      bodyMedium: kiteOne(textStyle: textTheme.bodyMedium),
      bodySmall: kiteOne(textStyle: textTheme.bodySmall),
      labelLarge: kiteOne(textStyle: textTheme.labelLarge),
      labelMedium: kiteOne(textStyle: textTheme.labelMedium),
      labelSmall: kiteOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kiwi Maru font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kiwi+Maru
  static TextStyle kiwiMaru({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b9c9c3046fc810f9faddaf1b1c96685d40d2572e9769ab05aa05a9c0b58301a6',
        4630528,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '4548a439adfba60c426ceaab63f6adb8b02e3f4624370b59d30ac8a691d750d2',
        4708932,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7a7dfa489c8b1e3869dd15c1260b2956f89e8c290f78d7bc63bef5d380eb2978',
        4765088,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KiwiMaru',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kiwi Maru font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kiwi+Maru
  static TextTheme kiwiMaruTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kiwiMaru(textStyle: textTheme.displayLarge),
      displayMedium: kiwiMaru(textStyle: textTheme.displayMedium),
      displaySmall: kiwiMaru(textStyle: textTheme.displaySmall),
      headlineLarge: kiwiMaru(textStyle: textTheme.headlineLarge),
      headlineMedium: kiwiMaru(textStyle: textTheme.headlineMedium),
      headlineSmall: kiwiMaru(textStyle: textTheme.headlineSmall),
      titleLarge: kiwiMaru(textStyle: textTheme.titleLarge),
      titleMedium: kiwiMaru(textStyle: textTheme.titleMedium),
      titleSmall: kiwiMaru(textStyle: textTheme.titleSmall),
      bodyLarge: kiwiMaru(textStyle: textTheme.bodyLarge),
      bodyMedium: kiwiMaru(textStyle: textTheme.bodyMedium),
      bodySmall: kiwiMaru(textStyle: textTheme.bodySmall),
      labelLarge: kiwiMaru(textStyle: textTheme.labelLarge),
      labelMedium: kiwiMaru(textStyle: textTheme.labelMedium),
      labelSmall: kiwiMaru(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Klee One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Klee+One
  static TextStyle kleeOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '8c307a4574ab7ef8cf7a859d7ea760d7e70644f72577dcd8e762ca364cd104b2',
        6649824,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6c0c75277d4d6e298dfc4b0910a4bba5b6f0b228887531a34855427250d4f284',
        6798992,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KleeOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Klee One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Klee+One
  static TextTheme kleeOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kleeOne(textStyle: textTheme.displayLarge),
      displayMedium: kleeOne(textStyle: textTheme.displayMedium),
      displaySmall: kleeOne(textStyle: textTheme.displaySmall),
      headlineLarge: kleeOne(textStyle: textTheme.headlineLarge),
      headlineMedium: kleeOne(textStyle: textTheme.headlineMedium),
      headlineSmall: kleeOne(textStyle: textTheme.headlineSmall),
      titleLarge: kleeOne(textStyle: textTheme.titleLarge),
      titleMedium: kleeOne(textStyle: textTheme.titleMedium),
      titleSmall: kleeOne(textStyle: textTheme.titleSmall),
      bodyLarge: kleeOne(textStyle: textTheme.bodyLarge),
      bodyMedium: kleeOne(textStyle: textTheme.bodyMedium),
      bodySmall: kleeOne(textStyle: textTheme.bodySmall),
      labelLarge: kleeOne(textStyle: textTheme.labelLarge),
      labelMedium: kleeOne(textStyle: textTheme.labelMedium),
      labelSmall: kleeOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Knewave font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Knewave
  static TextStyle knewave({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd7a5d36996861440a7323bce635cba068a2abe33e203bc805bca465a7719c663',
        30828,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Knewave',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Knewave font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Knewave
  static TextTheme knewaveTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: knewave(textStyle: textTheme.displayLarge),
      displayMedium: knewave(textStyle: textTheme.displayMedium),
      displaySmall: knewave(textStyle: textTheme.displaySmall),
      headlineLarge: knewave(textStyle: textTheme.headlineLarge),
      headlineMedium: knewave(textStyle: textTheme.headlineMedium),
      headlineSmall: knewave(textStyle: textTheme.headlineSmall),
      titleLarge: knewave(textStyle: textTheme.titleLarge),
      titleMedium: knewave(textStyle: textTheme.titleMedium),
      titleSmall: knewave(textStyle: textTheme.titleSmall),
      bodyLarge: knewave(textStyle: textTheme.bodyLarge),
      bodyMedium: knewave(textStyle: textTheme.bodyMedium),
      bodySmall: knewave(textStyle: textTheme.bodySmall),
      labelLarge: knewave(textStyle: textTheme.labelLarge),
      labelMedium: knewave(textStyle: textTheme.labelMedium),
      labelSmall: knewave(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the KoHo font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/KoHo
  static TextStyle koHo({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3af7e48182d135d3bb3e694d1bd1e756c0dd23789f6ec5bc4f190532f1f4ab0',
        86716,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '03a317cdb0a6d89bcf5915b807d68a83916da8944091be1f2fab50b3afa9e9b4',
        90908,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cb924b0326b4c7311dd7331997e56735defa6b8fea8a1cd66f468ee2b063d37d',
        86412,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '371abb61eba423b208a21f317aa7ab8e0c6c35adaf47aad7b34b8a573301d0cd',
        90612,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '12e86a898aa933872b903c05385001479bc487ae9ca49766bd087bd240f5e8f5',
        86204,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5c4abc652d2044eb37097b3095e92a154f5f5a1d048993e4dc1091c1c64b3960',
        90532,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '262f653a554a905e20a4164cc571d9dad94f7028709bb75eaf0c7b118ee55483',
        85892,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f61caf1f627e11ae12e26fb522e3487756c27e76a259444449da492b43ec1dc6',
        90208,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2e340654b3773ca71ef3c3c702534b94b484762e690b3e00d561e1b1d22634f5',
        85700,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '2b001656996bca2587f64d6e6cde03c4e46e182f95ab1006b3e9b0138c1e1d3e',
        89800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '60866577b16bc41cff442f77847cca4dda2e06692c998c33f2cd6cc8052e1cf6',
        85128,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '40289fb01fd35c9113cc32a856b1c7108a05e4a5c9fa22588690da6d49d7c180',
        88844,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KoHo',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the KoHo font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/KoHo
  static TextTheme koHoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: koHo(textStyle: textTheme.displayLarge),
      displayMedium: koHo(textStyle: textTheme.displayMedium),
      displaySmall: koHo(textStyle: textTheme.displaySmall),
      headlineLarge: koHo(textStyle: textTheme.headlineLarge),
      headlineMedium: koHo(textStyle: textTheme.headlineMedium),
      headlineSmall: koHo(textStyle: textTheme.headlineSmall),
      titleLarge: koHo(textStyle: textTheme.titleLarge),
      titleMedium: koHo(textStyle: textTheme.titleMedium),
      titleSmall: koHo(textStyle: textTheme.titleSmall),
      bodyLarge: koHo(textStyle: textTheme.bodyLarge),
      bodyMedium: koHo(textStyle: textTheme.bodyMedium),
      bodySmall: koHo(textStyle: textTheme.bodySmall),
      labelLarge: koHo(textStyle: textTheme.labelLarge),
      labelMedium: koHo(textStyle: textTheme.labelMedium),
      labelSmall: koHo(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kodchasan font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kodchasan
  static TextStyle kodchasan({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b270c7a489a5e44987f76a7b7d8accc87b471a8b004aaa8d83363137b3f6a365',
        95636,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'df29b5ef8f9da30bafce1d35099319f33b5917b56a39f109a5d31bc1d9e020be',
        99936,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'cf7944ad2e715c3460140920c250ccffb04691d8ea1f6bd0fa92959af995dc02',
        96820,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '42eccc5ca7e9bdb31d56573963ca7a3710c128b508e415c564e037ee9e66acf5',
        101004,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '09bf85551831dbcba6ceae4210541baebe2be421d66e6a09be21a8663805f73d',
        97096,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'f7c82ba32c901d2ab4e7463bcd399a6f390f4e95766c425b398fbd9631850f4c',
        101792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '24ead6b564b209dacdac3b7a48be912f91afcafa3ea02b63232c6896ef6e73c9',
        97392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b8fa788a4a9a77e3b3c29f4928f90b59acd6fa11398628543fc24ba8b1f46d80',
        102188,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c318eb6648061ae90ca7b0a6f952980d3411277bcdba04ce45edd4554d29f93',
        97472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5013884ecbb7de0139a887a21d0378830ab3b3fb248367c243743f3fb52b4733',
        102656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'fc324575d01cbc90492b2dae368b851eb8f4020f4e555d1fb4367a8b9b046c95',
        97304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'cb61abbecb64b62f331b34b8e87aa62a6f35a838ee0264154aa8c89bea0340b3',
        102752,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kodchasan',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kodchasan font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kodchasan
  static TextTheme kodchasanTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kodchasan(textStyle: textTheme.displayLarge),
      displayMedium: kodchasan(textStyle: textTheme.displayMedium),
      displaySmall: kodchasan(textStyle: textTheme.displaySmall),
      headlineLarge: kodchasan(textStyle: textTheme.headlineLarge),
      headlineMedium: kodchasan(textStyle: textTheme.headlineMedium),
      headlineSmall: kodchasan(textStyle: textTheme.headlineSmall),
      titleLarge: kodchasan(textStyle: textTheme.titleLarge),
      titleMedium: kodchasan(textStyle: textTheme.titleMedium),
      titleSmall: kodchasan(textStyle: textTheme.titleSmall),
      bodyLarge: kodchasan(textStyle: textTheme.bodyLarge),
      bodyMedium: kodchasan(textStyle: textTheme.bodyMedium),
      bodySmall: kodchasan(textStyle: textTheme.bodySmall),
      labelLarge: kodchasan(textStyle: textTheme.labelLarge),
      labelMedium: kodchasan(textStyle: textTheme.labelMedium),
      labelSmall: kodchasan(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kode Mono font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kode+Mono
  static TextStyle kodeMono({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6261ece2db7c0ce519f62a9cba501e50b3eed789c91436a955e4bc4a37ee3e3e',
        43452,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '509ceb17546005254d0b54de01ffe15dc4d7eb65b016516907212d43fa6d38b1',
        43548,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6df8ebd4dd045decffe4dc464e6a2690fd2f668a54c3071e1bf5829b88f04718',
        43540,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '917df0a9dfdb2f0c6a28a7770c5b92ad29fe443d40ef4d862cb62305c6060afd',
        43444,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KodeMono',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kode Mono font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kode+Mono
  static TextTheme kodeMonoTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kodeMono(textStyle: textTheme.displayLarge),
      displayMedium: kodeMono(textStyle: textTheme.displayMedium),
      displaySmall: kodeMono(textStyle: textTheme.displaySmall),
      headlineLarge: kodeMono(textStyle: textTheme.headlineLarge),
      headlineMedium: kodeMono(textStyle: textTheme.headlineMedium),
      headlineSmall: kodeMono(textStyle: textTheme.headlineSmall),
      titleLarge: kodeMono(textStyle: textTheme.titleLarge),
      titleMedium: kodeMono(textStyle: textTheme.titleMedium),
      titleSmall: kodeMono(textStyle: textTheme.titleSmall),
      bodyLarge: kodeMono(textStyle: textTheme.bodyLarge),
      bodyMedium: kodeMono(textStyle: textTheme.bodyMedium),
      bodySmall: kodeMono(textStyle: textTheme.bodySmall),
      labelLarge: kodeMono(textStyle: textTheme.labelLarge),
      labelMedium: kodeMono(textStyle: textTheme.labelMedium),
      labelSmall: kodeMono(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Koh Santepheap font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Koh+Santepheap
  static TextStyle kohSantepheap({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '07e6b24a5ae5c0c9b9af9ac83d8e1b316721e751136820f6c2b5df2fa5db10a1',
        96060,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7815c4bfbdb23de63068b0119dd7a3de19448b2354ef9970c6f89a561ff220f5',
        89816,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1c770bfdc8ac0f1db2bb1e8176b8ff1e512605918f87dc1f4dc58f419c40f1a9',
        85232,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '80323b05db54d11f7497cfe834e70bae1e8424ac5900d5ae40e6a8c2a2aaf35f',
        81884,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7522dbc3efbefd21d645bff17e5eb1945b145bfe8cf42ab0fea2b66ec0b79bdd',
        74620,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KohSantepheap',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Koh Santepheap font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Koh+Santepheap
  static TextTheme kohSantepheapTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kohSantepheap(textStyle: textTheme.displayLarge),
      displayMedium: kohSantepheap(textStyle: textTheme.displayMedium),
      displaySmall: kohSantepheap(textStyle: textTheme.displaySmall),
      headlineLarge: kohSantepheap(textStyle: textTheme.headlineLarge),
      headlineMedium: kohSantepheap(textStyle: textTheme.headlineMedium),
      headlineSmall: kohSantepheap(textStyle: textTheme.headlineSmall),
      titleLarge: kohSantepheap(textStyle: textTheme.titleLarge),
      titleMedium: kohSantepheap(textStyle: textTheme.titleMedium),
      titleSmall: kohSantepheap(textStyle: textTheme.titleSmall),
      bodyLarge: kohSantepheap(textStyle: textTheme.bodyLarge),
      bodyMedium: kohSantepheap(textStyle: textTheme.bodyMedium),
      bodySmall: kohSantepheap(textStyle: textTheme.bodySmall),
      labelLarge: kohSantepheap(textStyle: textTheme.labelLarge),
      labelMedium: kohSantepheap(textStyle: textTheme.labelMedium),
      labelSmall: kohSantepheap(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kolker Brush font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kolker+Brush
  static TextStyle kolkerBrush({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6a6a5187f43fc1f2087946d2eee44d9ed95454bef8460fbcbcdd4ea42a443bdc',
        180044,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KolkerBrush',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kolker Brush font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kolker+Brush
  static TextTheme kolkerBrushTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kolkerBrush(textStyle: textTheme.displayLarge),
      displayMedium: kolkerBrush(textStyle: textTheme.displayMedium),
      displaySmall: kolkerBrush(textStyle: textTheme.displaySmall),
      headlineLarge: kolkerBrush(textStyle: textTheme.headlineLarge),
      headlineMedium: kolkerBrush(textStyle: textTheme.headlineMedium),
      headlineSmall: kolkerBrush(textStyle: textTheme.headlineSmall),
      titleLarge: kolkerBrush(textStyle: textTheme.titleLarge),
      titleMedium: kolkerBrush(textStyle: textTheme.titleMedium),
      titleSmall: kolkerBrush(textStyle: textTheme.titleSmall),
      bodyLarge: kolkerBrush(textStyle: textTheme.bodyLarge),
      bodyMedium: kolkerBrush(textStyle: textTheme.bodyMedium),
      bodySmall: kolkerBrush(textStyle: textTheme.bodySmall),
      labelLarge: kolkerBrush(textStyle: textTheme.labelLarge),
      labelMedium: kolkerBrush(textStyle: textTheme.labelMedium),
      labelSmall: kolkerBrush(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Konkhmer Sleokchher font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Konkhmer+Sleokchher
  static TextStyle konkhmerSleokchher({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '88810d497c4e73f06c06fc3fa51e0e88bff8f12ac8e2248f11a860b776bc4068',
        566576,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KonkhmerSleokchher',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Konkhmer Sleokchher font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Konkhmer+Sleokchher
  static TextTheme konkhmerSleokchherTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: konkhmerSleokchher(textStyle: textTheme.displayLarge),
      displayMedium: konkhmerSleokchher(textStyle: textTheme.displayMedium),
      displaySmall: konkhmerSleokchher(textStyle: textTheme.displaySmall),
      headlineLarge: konkhmerSleokchher(textStyle: textTheme.headlineLarge),
      headlineMedium: konkhmerSleokchher(textStyle: textTheme.headlineMedium),
      headlineSmall: konkhmerSleokchher(textStyle: textTheme.headlineSmall),
      titleLarge: konkhmerSleokchher(textStyle: textTheme.titleLarge),
      titleMedium: konkhmerSleokchher(textStyle: textTheme.titleMedium),
      titleSmall: konkhmerSleokchher(textStyle: textTheme.titleSmall),
      bodyLarge: konkhmerSleokchher(textStyle: textTheme.bodyLarge),
      bodyMedium: konkhmerSleokchher(textStyle: textTheme.bodyMedium),
      bodySmall: konkhmerSleokchher(textStyle: textTheme.bodySmall),
      labelLarge: konkhmerSleokchher(textStyle: textTheme.labelLarge),
      labelMedium: konkhmerSleokchher(textStyle: textTheme.labelMedium),
      labelSmall: konkhmerSleokchher(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kosugi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kosugi
  static TextStyle kosugi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3d0d7ceb5b74fc05170b69189955572c79f856e53eaf8e403f417fbe805aae3e',
        2286760,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kosugi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kosugi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kosugi
  static TextTheme kosugiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kosugi(textStyle: textTheme.displayLarge),
      displayMedium: kosugi(textStyle: textTheme.displayMedium),
      displaySmall: kosugi(textStyle: textTheme.displaySmall),
      headlineLarge: kosugi(textStyle: textTheme.headlineLarge),
      headlineMedium: kosugi(textStyle: textTheme.headlineMedium),
      headlineSmall: kosugi(textStyle: textTheme.headlineSmall),
      titleLarge: kosugi(textStyle: textTheme.titleLarge),
      titleMedium: kosugi(textStyle: textTheme.titleMedium),
      titleSmall: kosugi(textStyle: textTheme.titleSmall),
      bodyLarge: kosugi(textStyle: textTheme.bodyLarge),
      bodyMedium: kosugi(textStyle: textTheme.bodyMedium),
      bodySmall: kosugi(textStyle: textTheme.bodySmall),
      labelLarge: kosugi(textStyle: textTheme.labelLarge),
      labelMedium: kosugi(textStyle: textTheme.labelMedium),
      labelSmall: kosugi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kosugi Maru font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kosugi+Maru
  static TextStyle kosugiMaru({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '1a90c857da87ed71b82528569fe9da02b7743228a973168640a523000aadcc6f',
        3563628,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KosugiMaru',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kosugi Maru font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kosugi+Maru
  static TextTheme kosugiMaruTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kosugiMaru(textStyle: textTheme.displayLarge),
      displayMedium: kosugiMaru(textStyle: textTheme.displayMedium),
      displaySmall: kosugiMaru(textStyle: textTheme.displaySmall),
      headlineLarge: kosugiMaru(textStyle: textTheme.headlineLarge),
      headlineMedium: kosugiMaru(textStyle: textTheme.headlineMedium),
      headlineSmall: kosugiMaru(textStyle: textTheme.headlineSmall),
      titleLarge: kosugiMaru(textStyle: textTheme.titleLarge),
      titleMedium: kosugiMaru(textStyle: textTheme.titleMedium),
      titleSmall: kosugiMaru(textStyle: textTheme.titleSmall),
      bodyLarge: kosugiMaru(textStyle: textTheme.bodyLarge),
      bodyMedium: kosugiMaru(textStyle: textTheme.bodyMedium),
      bodySmall: kosugiMaru(textStyle: textTheme.bodySmall),
      labelLarge: kosugiMaru(textStyle: textTheme.labelLarge),
      labelMedium: kosugiMaru(textStyle: textTheme.labelMedium),
      labelSmall: kosugiMaru(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kotta One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kotta+One
  static TextStyle kottaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0638d63efe7ee7b3e6ab4b96cc75576600f89898b5e35b7ae7ebb758b41a769a',
        34152,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KottaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kotta One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kotta+One
  static TextTheme kottaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kottaOne(textStyle: textTheme.displayLarge),
      displayMedium: kottaOne(textStyle: textTheme.displayMedium),
      displaySmall: kottaOne(textStyle: textTheme.displaySmall),
      headlineLarge: kottaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: kottaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: kottaOne(textStyle: textTheme.headlineSmall),
      titleLarge: kottaOne(textStyle: textTheme.titleLarge),
      titleMedium: kottaOne(textStyle: textTheme.titleMedium),
      titleSmall: kottaOne(textStyle: textTheme.titleSmall),
      bodyLarge: kottaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: kottaOne(textStyle: textTheme.bodyMedium),
      bodySmall: kottaOne(textStyle: textTheme.bodySmall),
      labelLarge: kottaOne(textStyle: textTheme.labelLarge),
      labelMedium: kottaOne(textStyle: textTheme.labelMedium),
      labelSmall: kottaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Koulen font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Koulen
  static TextStyle koulen({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f291a48b9c6a3a6d6456d259c15e62d3046bd19cf59dea0cb8ef62dd2300ffbb',
        31796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Koulen',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Koulen font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Koulen
  static TextTheme koulenTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: koulen(textStyle: textTheme.displayLarge),
      displayMedium: koulen(textStyle: textTheme.displayMedium),
      displaySmall: koulen(textStyle: textTheme.displaySmall),
      headlineLarge: koulen(textStyle: textTheme.headlineLarge),
      headlineMedium: koulen(textStyle: textTheme.headlineMedium),
      headlineSmall: koulen(textStyle: textTheme.headlineSmall),
      titleLarge: koulen(textStyle: textTheme.titleLarge),
      titleMedium: koulen(textStyle: textTheme.titleMedium),
      titleSmall: koulen(textStyle: textTheme.titleSmall),
      bodyLarge: koulen(textStyle: textTheme.bodyLarge),
      bodyMedium: koulen(textStyle: textTheme.bodyMedium),
      bodySmall: koulen(textStyle: textTheme.bodySmall),
      labelLarge: koulen(textStyle: textTheme.labelLarge),
      labelMedium: koulen(textStyle: textTheme.labelMedium),
      labelSmall: koulen(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kranky font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kranky
  static TextStyle kranky({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ef7ddfb48a2b839c71688627394bf3ca58ee7d98a3a4c47de327359dcf2548d1',
        197308,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kranky',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kranky font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kranky
  static TextTheme krankyTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kranky(textStyle: textTheme.displayLarge),
      displayMedium: kranky(textStyle: textTheme.displayMedium),
      displaySmall: kranky(textStyle: textTheme.displaySmall),
      headlineLarge: kranky(textStyle: textTheme.headlineLarge),
      headlineMedium: kranky(textStyle: textTheme.headlineMedium),
      headlineSmall: kranky(textStyle: textTheme.headlineSmall),
      titleLarge: kranky(textStyle: textTheme.titleLarge),
      titleMedium: kranky(textStyle: textTheme.titleMedium),
      titleSmall: kranky(textStyle: textTheme.titleSmall),
      bodyLarge: kranky(textStyle: textTheme.bodyLarge),
      bodyMedium: kranky(textStyle: textTheme.bodyMedium),
      bodySmall: kranky(textStyle: textTheme.bodySmall),
      labelLarge: kranky(textStyle: textTheme.labelLarge),
      labelMedium: kranky(textStyle: textTheme.labelMedium),
      labelSmall: kranky(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kreon font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kreon
  static TextStyle kreon({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '3b4e982e7265a4ecf5caed4cb6996fbd7792702e2f8c332fea23a45f7a872b2d',
        45264,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd4a7609da3a6a7c35dfd79bfccc74ac1889cffff28bbc2553c56dbd829f386da',
        45460,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f3a8d635b44d40bfeb38fb83de2bfd869770d25378c0a36c5789c9f19b1d3b5a',
        45472,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ceeff235bcbbc213ab3feebaca31adbe31fabca11716fb964cafc58107150d67',
        45496,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd62abc6836ac864ee023a393b09273c8e1c8daa543f48882e2562847cec22380',
        45400,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kreon',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kreon font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kreon
  static TextTheme kreonTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kreon(textStyle: textTheme.displayLarge),
      displayMedium: kreon(textStyle: textTheme.displayMedium),
      displaySmall: kreon(textStyle: textTheme.displaySmall),
      headlineLarge: kreon(textStyle: textTheme.headlineLarge),
      headlineMedium: kreon(textStyle: textTheme.headlineMedium),
      headlineSmall: kreon(textStyle: textTheme.headlineSmall),
      titleLarge: kreon(textStyle: textTheme.titleLarge),
      titleMedium: kreon(textStyle: textTheme.titleMedium),
      titleSmall: kreon(textStyle: textTheme.titleSmall),
      bodyLarge: kreon(textStyle: textTheme.bodyLarge),
      bodyMedium: kreon(textStyle: textTheme.bodyMedium),
      bodySmall: kreon(textStyle: textTheme.bodySmall),
      labelLarge: kreon(textStyle: textTheme.labelLarge),
      labelMedium: kreon(textStyle: textTheme.labelMedium),
      labelSmall: kreon(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kristi font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kristi
  static TextStyle kristi({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9d4b5335341a113d30256c58448723693130f94c8bf9374104e5b9d2d99e8b42',
        25700,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kristi',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kristi font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kristi
  static TextTheme kristiTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kristi(textStyle: textTheme.displayLarge),
      displayMedium: kristi(textStyle: textTheme.displayMedium),
      displaySmall: kristi(textStyle: textTheme.displaySmall),
      headlineLarge: kristi(textStyle: textTheme.headlineLarge),
      headlineMedium: kristi(textStyle: textTheme.headlineMedium),
      headlineSmall: kristi(textStyle: textTheme.headlineSmall),
      titleLarge: kristi(textStyle: textTheme.titleLarge),
      titleMedium: kristi(textStyle: textTheme.titleMedium),
      titleSmall: kristi(textStyle: textTheme.titleSmall),
      bodyLarge: kristi(textStyle: textTheme.bodyLarge),
      bodyMedium: kristi(textStyle: textTheme.bodyMedium),
      bodySmall: kristi(textStyle: textTheme.bodySmall),
      labelLarge: kristi(textStyle: textTheme.labelLarge),
      labelMedium: kristi(textStyle: textTheme.labelMedium),
      labelSmall: kristi(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Krona One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Krona+One
  static TextStyle kronaOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5a857bdedcd04808287e0f61434a166015905516d9b18b4588a2e56e92f93376',
        30616,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KronaOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Krona One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Krona+One
  static TextTheme kronaOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kronaOne(textStyle: textTheme.displayLarge),
      displayMedium: kronaOne(textStyle: textTheme.displayMedium),
      displaySmall: kronaOne(textStyle: textTheme.displaySmall),
      headlineLarge: kronaOne(textStyle: textTheme.headlineLarge),
      headlineMedium: kronaOne(textStyle: textTheme.headlineMedium),
      headlineSmall: kronaOne(textStyle: textTheme.headlineSmall),
      titleLarge: kronaOne(textStyle: textTheme.titleLarge),
      titleMedium: kronaOne(textStyle: textTheme.titleMedium),
      titleSmall: kronaOne(textStyle: textTheme.titleSmall),
      bodyLarge: kronaOne(textStyle: textTheme.bodyLarge),
      bodyMedium: kronaOne(textStyle: textTheme.bodyMedium),
      bodySmall: kronaOne(textStyle: textTheme.bodySmall),
      labelLarge: kronaOne(textStyle: textTheme.labelLarge),
      labelMedium: kronaOne(textStyle: textTheme.labelMedium),
      labelSmall: kronaOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Krub font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Krub
  static TextStyle krub({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '6e064bab32a21fa30c610295c91695432f7864991a4d00c1217a5b36e403cd96',
        81664,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '51506d322a16c0c02ce2cacd9fac549519d9e5258e2d1a2b4e90c5cfafdb4c2c',
        84648,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9a216e70293e43f9afee4e88c83a71529e7e6a7bbb86835d8a730f9906cfeb28',
        81100,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '66d36cdd71ff9956005efe651b7bb1757929f7ade3ef702e3c4231a134f92cf6',
        83988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9ab135ae3874fde80d4de737db0926c9904c8ccc5dc82af2b94a9857cb59a526',
        80988,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'c10304de75799db5bb814f1aa2598c3ac1433e7888a7090ec3d33bccb7f83775',
        84040,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7d578102b79ffd00517dd5dab4bf39d1815020b4056f059dd0501f93e288d66f',
        80900,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8a82e2bbf17bf8e5fc073264a2bb66567de6773557f21703fbc15711b67a068f',
        83856,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '93a6c45b34dd34dec10d6e093f4c45194b75f491b0215001c6a2045f0803c98f',
        80800,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '59450b19c8b120bd1c990983b8fe2aef06236e0ac250080980bb4e49b0e47eb1',
        83792,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b8def7bdcdabc64634f660f7a9090f16a2630225d33537da2827586e2c1a5a21',
        80756,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '8b30bf9c77979d77ca14816cbcb00e474b724e5d61320f0f412cb65b2b7bd62d',
        83796,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Krub',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Krub font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Krub
  static TextTheme krubTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: krub(textStyle: textTheme.displayLarge),
      displayMedium: krub(textStyle: textTheme.displayMedium),
      displaySmall: krub(textStyle: textTheme.displaySmall),
      headlineLarge: krub(textStyle: textTheme.headlineLarge),
      headlineMedium: krub(textStyle: textTheme.headlineMedium),
      headlineSmall: krub(textStyle: textTheme.headlineSmall),
      titleLarge: krub(textStyle: textTheme.titleLarge),
      titleMedium: krub(textStyle: textTheme.titleMedium),
      titleSmall: krub(textStyle: textTheme.titleSmall),
      bodyLarge: krub(textStyle: textTheme.bodyLarge),
      bodyMedium: krub(textStyle: textTheme.bodyMedium),
      bodySmall: krub(textStyle: textTheme.bodySmall),
      labelLarge: krub(textStyle: textTheme.labelLarge),
      labelMedium: krub(textStyle: textTheme.labelMedium),
      labelSmall: krub(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kufam font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kufam
  static TextStyle kufam({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '13981cb0d8a657bd2c6b48b400809b21c30be07513b71b4e8d16f86ee8b1799c',
        160168,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ae80b72a6c6990ef1df59df2cbd963970e3a6c47f4ae83195013b5dddcf531b5',
        160512,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'd11204165c4180b3f4709278b0e135405a3a6f9cc185394e2497ca3d51447fa6',
        160660,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'a9e6558a02b12d7955ba0a65356d505c51b86f2bd7bff883276d0f1e25b50ce4',
        160732,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'ba63d67fc06ddb4acf1254a19dd39d17ebbbe2e88cb34afd603c5e112e88d4a9',
        160656,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '124a019068a57c9a38bb2dcd504bd9b8744df66f42ccdcb6d49816f45be790d6',
        160172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '5e8ba6c30123a605c95b785fe2d358518d69e3163026214c3fe3d1b33332f3d1',
        163768,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '299af8feb6ab81e13dde4b57e8f092fb1ef57eb52ea8cbc7525d90241bb537f9',
        164304,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '978ec73c48a02ad7b2e025f7ecdb730e6dd0178d786ba24f5f99842ff52f32ad',
        164356,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '999c0477b403209b7a245242e698507b9476529bd15aeba4ca6458bde4ca6a93',
        164340,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'b370badfc3898bc2d31177ee5dc3a245b6e95d94cae0ea4a164f6871fb87d319',
        164312,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '30aa455a87be83c40c1df77ad181548bacd8b7693ffec8368adeb6d3d80d0cb7',
        163780,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kufam',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kufam font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kufam
  static TextTheme kufamTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kufam(textStyle: textTheme.displayLarge),
      displayMedium: kufam(textStyle: textTheme.displayMedium),
      displaySmall: kufam(textStyle: textTheme.displaySmall),
      headlineLarge: kufam(textStyle: textTheme.headlineLarge),
      headlineMedium: kufam(textStyle: textTheme.headlineMedium),
      headlineSmall: kufam(textStyle: textTheme.headlineSmall),
      titleLarge: kufam(textStyle: textTheme.titleLarge),
      titleMedium: kufam(textStyle: textTheme.titleMedium),
      titleSmall: kufam(textStyle: textTheme.titleSmall),
      bodyLarge: kufam(textStyle: textTheme.bodyLarge),
      bodyMedium: kufam(textStyle: textTheme.bodyMedium),
      bodySmall: kufam(textStyle: textTheme.bodySmall),
      labelLarge: kufam(textStyle: textTheme.labelLarge),
      labelMedium: kufam(textStyle: textTheme.labelMedium),
      labelSmall: kufam(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kulim Park font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kulim+Park
  static TextStyle kulimPark({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '411dd1c2a745dffc3a7ec3e3b08b5a0a7e4b64b9665af04992ab11a4088c35c5',
        43256,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        'e42aa6fe8dbce9ec161e7a43f425312f70e9d0ae889b9b87d61eb49e6e53dd9b',
        45316,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b7b666671732126b9fdcc9d0b6af69224c77410099aa68e77fd252155868ac96',
        44404,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '53c9090cffc2eb26795863357277af6e10ea7b10bccce7bc06c00f2299872695',
        46220,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'f6eb5e7ad93fe4846f2695b81674b437592f8d139eae1740df2bdb94cc1cb789',
        44392,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '65fa35863efa80888c2b40da6783a797a3708179e27d9e74f378de68f4bf34d7',
        46036,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '97d007e0de718e70539306c4d4d4070e14c09ed649be04de7400a230cb9d1223',
        44296,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '144f19f1eb5cc929255d504b6b4f8d8746ef5d4e4af83dfefdf00914d7dc6ff1',
        46032,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'eee087645cb4966df66021eb07852d61e969eb4fb1bae148d6992b8d0633abb7',
        43860,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.italic,
      ): GoogleFontsFile(
        '6ff9f4f4b4f227cf493be24aebef50836aff650e47b889e0dcac77978498031b',
        45840,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KulimPark',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kulim Park font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kulim+Park
  static TextTheme kulimParkTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kulimPark(textStyle: textTheme.displayLarge),
      displayMedium: kulimPark(textStyle: textTheme.displayMedium),
      displaySmall: kulimPark(textStyle: textTheme.displaySmall),
      headlineLarge: kulimPark(textStyle: textTheme.headlineLarge),
      headlineMedium: kulimPark(textStyle: textTheme.headlineMedium),
      headlineSmall: kulimPark(textStyle: textTheme.headlineSmall),
      titleLarge: kulimPark(textStyle: textTheme.titleLarge),
      titleMedium: kulimPark(textStyle: textTheme.titleMedium),
      titleSmall: kulimPark(textStyle: textTheme.titleSmall),
      bodyLarge: kulimPark(textStyle: textTheme.bodyLarge),
      bodyMedium: kulimPark(textStyle: textTheme.bodyMedium),
      bodySmall: kulimPark(textStyle: textTheme.bodySmall),
      labelLarge: kulimPark(textStyle: textTheme.labelLarge),
      labelMedium: kulimPark(textStyle: textTheme.labelMedium),
      labelSmall: kulimPark(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kumar One font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumar+One
  static TextStyle kumarOne({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '2a607987657b3025c7fd25657ea82ce888eecad94f4f5a692c77b828ac4d3825',
        87384,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KumarOne',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kumar One font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumar+One
  static TextTheme kumarOneTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kumarOne(textStyle: textTheme.displayLarge),
      displayMedium: kumarOne(textStyle: textTheme.displayMedium),
      displaySmall: kumarOne(textStyle: textTheme.displaySmall),
      headlineLarge: kumarOne(textStyle: textTheme.headlineLarge),
      headlineMedium: kumarOne(textStyle: textTheme.headlineMedium),
      headlineSmall: kumarOne(textStyle: textTheme.headlineSmall),
      titleLarge: kumarOne(textStyle: textTheme.titleLarge),
      titleMedium: kumarOne(textStyle: textTheme.titleMedium),
      titleSmall: kumarOne(textStyle: textTheme.titleSmall),
      bodyLarge: kumarOne(textStyle: textTheme.bodyLarge),
      bodyMedium: kumarOne(textStyle: textTheme.bodyMedium),
      bodySmall: kumarOne(textStyle: textTheme.bodySmall),
      labelLarge: kumarOne(textStyle: textTheme.labelLarge),
      labelMedium: kumarOne(textStyle: textTheme.labelMedium),
      labelSmall: kumarOne(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kumar One Outline font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumar+One+Outline
  static TextStyle kumarOneOutline({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '7611e5acc94e77b80e007061709cb79b567dac87facd97283bd7fe8184d97988',
        119368,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KumarOneOutline',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kumar One Outline font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumar+One+Outline
  static TextTheme kumarOneOutlineTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kumarOneOutline(textStyle: textTheme.displayLarge),
      displayMedium: kumarOneOutline(textStyle: textTheme.displayMedium),
      displaySmall: kumarOneOutline(textStyle: textTheme.displaySmall),
      headlineLarge: kumarOneOutline(textStyle: textTheme.headlineLarge),
      headlineMedium: kumarOneOutline(textStyle: textTheme.headlineMedium),
      headlineSmall: kumarOneOutline(textStyle: textTheme.headlineSmall),
      titleLarge: kumarOneOutline(textStyle: textTheme.titleLarge),
      titleMedium: kumarOneOutline(textStyle: textTheme.titleMedium),
      titleSmall: kumarOneOutline(textStyle: textTheme.titleSmall),
      bodyLarge: kumarOneOutline(textStyle: textTheme.bodyLarge),
      bodyMedium: kumarOneOutline(textStyle: textTheme.bodyMedium),
      bodySmall: kumarOneOutline(textStyle: textTheme.bodySmall),
      labelLarge: kumarOneOutline(textStyle: textTheme.labelLarge),
      labelMedium: kumarOneOutline(textStyle: textTheme.labelMedium),
      labelSmall: kumarOneOutline(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kumbh Sans font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumbh+Sans
  static TextStyle kumbhSans({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w100,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '11ffd1e2294a448028e843fceb9b019a80a29c1ba738d7d86392ed5d1c6753a7',
        44192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w200,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'dda379bcef09b199af783e5cb21929712446e728f033abac76e01adacf286ab7',
        44192,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w300,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '9c6685508e5548da33c05bbd80ea822f111a7eb07575c476cbf2e03dca86d4c0',
        44084,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '153dfe2d3c77604e9f4d4ea17c905e31bf8d0e99091d4967ffad0925c04906ce',
        44008,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w500,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '512cedbc8456dbec3ffeb6f2789ec46431d30f044bf170963106e4f11e48ad29',
        44048,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w600,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '5b734343aa2725e6c0da89716890a384d130acb084cafa5907f4281c9d4d2353',
        44172,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w700,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        'b4da6213d8e1e6caae198d564a8fe0c0805f61b92376989e4bb7e5c56dc42570',
        44252,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w800,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '0551d7d938bdc0c3a1e1fdc3a3eb596fc8fc6b549fe370af21831512fc490683',
        44352,
      ),
      const GoogleFontsVariant(
        fontWeight: FontWeight.w900,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '31443a18a1c949ef780abf29f5181d6eefc4d40ffb35768b882cb171e71fea2c',
        44340,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'KumbhSans',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kumbh Sans font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kumbh+Sans
  static TextTheme kumbhSansTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kumbhSans(textStyle: textTheme.displayLarge),
      displayMedium: kumbhSans(textStyle: textTheme.displayMedium),
      displaySmall: kumbhSans(textStyle: textTheme.displaySmall),
      headlineLarge: kumbhSans(textStyle: textTheme.headlineLarge),
      headlineMedium: kumbhSans(textStyle: textTheme.headlineMedium),
      headlineSmall: kumbhSans(textStyle: textTheme.headlineSmall),
      titleLarge: kumbhSans(textStyle: textTheme.titleLarge),
      titleMedium: kumbhSans(textStyle: textTheme.titleMedium),
      titleSmall: kumbhSans(textStyle: textTheme.titleSmall),
      bodyLarge: kumbhSans(textStyle: textTheme.bodyLarge),
      bodyMedium: kumbhSans(textStyle: textTheme.bodyMedium),
      bodySmall: kumbhSans(textStyle: textTheme.bodySmall),
      labelLarge: kumbhSans(textStyle: textTheme.labelLarge),
      labelMedium: kumbhSans(textStyle: textTheme.labelMedium),
      labelSmall: kumbhSans(textStyle: textTheme.labelSmall),
    );
  }

  /// Applies the Kurale font family from Google Fonts to the
  /// given [textStyle].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kurale
  static TextStyle kurale({
    TextStyle? textStyle,
    Color? color,
    Color? backgroundColor,
    double? fontSize,
    FontWeight? fontWeight,
    FontStyle? fontStyle,
    double? letterSpacing,
    double? wordSpacing,
    TextBaseline? textBaseline,
    double? height,
    Locale? locale,
    Paint? foreground,
    Paint? background,
    List<ui.Shadow>? shadows,
    List<ui.FontFeature>? fontFeatures,
    TextDecoration? decoration,
    Color? decorationColor,
    TextDecorationStyle? decorationStyle,
    double? decorationThickness,
  }) {
    final fonts = <GoogleFontsVariant, GoogleFontsFile>{
      const GoogleFontsVariant(
        fontWeight: FontWeight.w400,
        fontStyle: FontStyle.normal,
      ): GoogleFontsFile(
        '55e647f9453578dbef5cf472811e7c89657fe5b8e93eca9631e85ff5914f6539',
        137008,
      ),
    };

    return googleFontsTextStyle(
      textStyle: textStyle,
      fontFamily: 'Kurale',
      color: color,
      backgroundColor: backgroundColor,
      fontSize: fontSize,
      fontWeight: fontWeight,
      fontStyle: fontStyle,
      letterSpacing: letterSpacing,
      wordSpacing: wordSpacing,
      textBaseline: textBaseline,
      height: height,
      locale: locale,
      foreground: foreground,
      background: background,
      shadows: shadows,
      fontFeatures: fontFeatures,
      decoration: decoration,
      decorationColor: decorationColor,
      decorationStyle: decorationStyle,
      decorationThickness: decorationThickness,
      fonts: fonts,
    );
  }

  /// Applies the Kurale font family from Google Fonts to every
  /// [TextStyle] in the given [textTheme].
  ///
  /// See:
  ///  * https://fonts.google.com/specimen/Kurale
  static TextTheme kuraleTextTheme([TextTheme? textTheme]) {
    textTheme ??= ThemeData.light().textTheme;
    return TextTheme(
      displayLarge: kurale(textStyle: textTheme.displayLarge),
      displayMedium: kurale(textStyle: textTheme.displayMedium),
      displaySmall: kurale(textStyle: textTheme.displaySmall),
      headlineLarge: kurale(textStyle: textTheme.headlineLarge),
      headlineMedium: kurale(textStyle: textTheme.headlineMedium),
      headlineSmall: kurale(textStyle: textTheme.headlineSmall),
      titleLarge: kurale(textStyle: textTheme.titleLarge),
      titleMedium: kurale(textStyle: textTheme.titleMedium),
      titleSmall: kurale(textStyle: textTheme.titleSmall),
      bodyLarge: kurale(textStyle: textTheme.bodyLarge),
      bodyMedium: kurale(textStyle: textTheme.bodyMedium),
      bodySmall: kurale(textStyle: textTheme.bodySmall),
      labelLarge: kurale(textStyle: textTheme.labelLarge),
      labelMedium: kurale(textStyle: textTheme.labelMedium),
      labelSmall: kurale(textStyle: textTheme.labelSmall),
    );
  }
}
