// SPDX-License-Identifier: GPL-3.0-only

package com.best.deskclock.settings;

public class PreferencesKeys {

    // **************
    // ** SETTINGS **
    // **************

    // Settings
    public static final String KEY_PERMISSION_MESSAGE = "key_permission_message";
    public static final String KEY_ESSENTIAL_PERMISSIONS_GRANTED = "key_essential_permissions_granted";
    public static final String KEY_INTERFACE_CUSTOMIZATION = "key_interface_customization";
    public static final String KEY_CLOCK_SETTINGS = "key_clock_settings";
    public static final String KEY_ALARM_SETTINGS = "key_alarm_settings";
    public static final String KEY_TIMER_SETTINGS = "key_timer_settings";
    public static final String KEY_STOPWATCH_SETTINGS = "key_stopwatch_settings";
    public static final String KEY_SCREENSAVER_SETTINGS = "key_screensaver_settings";
    public static final String KEY_WIDGETS_SETTINGS = "key_widgets_settings";
    public static final String KEY_PERMISSIONS_MANAGEMENT = "key_permissions_management";
    public static final String KEY_BACKUP_RESTORE_PREFERENCES = "key_backup_restore_preferences";

    // About
    public static final String KEY_ABOUT_TITLE = "key_about_title";
    public static final String KEY_ABOUT_VERSION = "key_about_version";
    public static final String KEY_ABOUT_WHATS_NEW = "key_about_whats_new";
    public static final String KEY_ABOUT_FEATURES = "key_about_features";
    public static final String KEY_ABOUT_VIEW_ON_GITHUB = "key_about_view_on_github";
    public static final String KEY_ABOUT_TRANSLATE = "key_about_translate";
    public static final String KEY_ABOUT_READ_LICENCE = "key_about_read_licence";
    public static final String KEY_DISPLAY_DEBUG_SETTINGS = "key_display_debug_settings";
    public static final String KEY_DEBUG_CATEGORY = "key_debug_category";
    public static final String KEY_ENABLE_LOCAL_LOGGING = "key_enable_local_logging";

    // Interface
    public static final String KEY_THEME = "key_theme";
    public static final String KEY_DARK_MODE = "key_dark_mode";
    public static final String KEY_ACCENT_COLOR = "key_accent_color";
    public static final String KEY_AUTO_NIGHT_ACCENT_COLOR = "key_auto_night_accent_color";
    public static final String KEY_NIGHT_ACCENT_COLOR = "key_night_accent_color";
    public static final String KEY_CARD_BACKGROUND = "key_card_background";
    public static final String KEY_CARD_BORDER = "key_card_border";
    public static final String KEY_CUSTOM_LANGUAGE_CODE = "key_custom_language_code";
    public static final String KEY_TAB_TO_DISPLAY = "key_tab_to_display";
    public static final String KEY_VIBRATIONS = "key_vibrations";
    public static final String KEY_TOOLBAR_TITLE = "key_toolbar_title";
    public static final String KEY_TAB_TITLE_VISIBILITY = "key_tab_title_visibility";
    public static final String KEY_TAB_INDICATOR = "key_tab_indicator";
    public static final String KEY_FADE_TRANSITIONS = "key_fade_transitions";
    public static final String KEY_KEEP_SCREEN_ON = "key_keep_screen_on";

    // Clock
    public static final String KEY_CLOCK_STYLE = "key_clock_style";
    public static final String KEY_CLOCK_DIAL = "key_clock_dial";
    public static final String KEY_CLOCK_DIAL_MATERIAL = "key_clock_dial_material";
    public static final String KEY_DISPLAY_CLOCK_SECONDS = "key_display_clock_seconds";
    public static final String KEY_CLOCK_SECOND_HAND = "key_clock_second_hand";
    public static final String KEY_SORT_CITIES = "key_sort_cities";
    public static final String KEY_ENABLE_CITY_NOTE = "key_enable_city_note";
    public static final String KEY_CITY_NOTE = "key_city_note_";
    public static final String KEY_AUTO_HOME_CLOCK = "key_automatic_home_clock";
    public static final String KEY_HOME_TIME_ZONE = "key_home_time_zone";
    public static final String KEY_DATE_TIME = "key_date_time";

    // Alarm
    public static final String KEY_DEFAULT_ALARM_RINGTONE = "key_default_alarm_ringtone";
    public static final String KEY_AUTO_SILENCE_DURATION = "key_auto_silence_duration";
    public static final String KEY_ALARM_SNOOZE_DURATION = "key_alarm_snooze_duration";
    public static final String KEY_ALARM_VOLUME_SETTING = "key_volume_setting";
    public static final String KEY_ALARM_VOLUME_CRESCENDO_DURATION = "key_alarm_volume_crescendo_duration";
    public static final String KEY_ENABLE_PER_ALARM_VOLUME = "key_enable_per_alarm_volume";
    public static final String KEY_ADVANCED_AUDIO_PLAYBACK = "key_advanced_audio_playback";
    public static final String KEY_AUTO_ROUTING_TO_BLUETOOTH_DEVICE = "key_auto_routing_to_bluetooth_device";
    public static final String KEY_SYSTEM_MEDIA_VOLUME = "key_system_media_volume";
    public static final String KEY_BLUETOOTH_VOLUME = "key_bluetooth_volume";
    public static final String KEY_SWIPE_ACTION = "key_swipe_action";
    public static final String KEY_VOLUME_BUTTONS = "key_volume_button_setting";
    public static final String KEY_POWER_BUTTON = "key_power_button";
    public static final String KEY_FLIP_ACTION = "key_flip_action";
    public static final String KEY_SHAKE_ACTION = "key_shake_action";
    public static final String KEY_SHAKE_INTENSITY = "key_shake_intensity";
    public static final String KEY_SORT_ALARM = "key_sort_alarm";
    public static final String KEY_DISPLAY_ENABLED_ALARMS_FIRST = "key_display_enabled_alarms_first";
    public static final String KEY_WEEK_START = "key_week_start";
    public static final String KEY_ALARM_NOTIFICATION_REMINDER_TIME = "key_alarm_notification_reminder_time";
    public static final String KEY_ENABLE_ALARM_VIBRATIONS_BY_DEFAULT = "key_enable_alarm_vibrations_by_default";
    public static final String KEY_ENABLE_SNOOZED_OR_DISMISSED_ALARM_VIBRATIONS = "key_enable_snoozed_or_dismissed_alarm_vibrations";
    public static final String KEY_TURN_ON_BACK_FLASH_FOR_TRIGGERED_ALARM = "key_turn_on_back_flash_for_triggered_alarm";
    public static final String KEY_ENABLE_DELETE_OCCASIONAL_ALARM_BY_DEFAULT = "key_enable_delete_occasional_alarm_by_default";
    public static final String KEY_MATERIAL_TIME_PICKER_STYLE = "key_material_time_picker_style";
    public static final String KEY_MATERIAL_DATE_PICKER_STYLE = "key_material_date_picker_style";
    public static final String KEY_ALARM_DISPLAY_CUSTOMIZATION = "key_alarm_display_customization";

    // Alarm Display Customization
    public static final String KEY_ALARM_CLOCK_STYLE = "key_alarm_clock_style";
    public static final String KEY_ALARM_CLOCK_DIAL = "key_alarm_clock_dial";
    public static final String KEY_ALARM_CLOCK_DIAL_MATERIAL = "key_alarm_clock_dial_material";
    public static final String KEY_DISPLAY_ALARM_SECOND_HAND = "key_display_alarm_second_hand";
    public static final String KEY_ALARM_CLOCK_SECOND_HAND = "key_alarm_clock_second_hand";
    public static final String KEY_ALARM_BACKGROUND_COLOR = "key_alarm_background_color";
    public static final String KEY_ALARM_BACKGROUND_AMOLED_COLOR = "key_alarm_background_amoled_color";
    public static final String KEY_SLIDE_ZONE_COLOR = "key_slide_zone_color";
    public static final String KEY_ALARM_CLOCK_COLOR = "key_alarm_clock_color";
    public static final String KEY_ALARM_SECOND_HAND_COLOR = "key_alarm_second_hand_color";
    public static final String KEY_ALARM_TITLE_COLOR = "key_alarm_title_color";
    public static final String KEY_SNOOZE_TITLE_COLOR = "key_snooze_title_color";
    public static final String KEY_SNOOZE_BUTTON_COLOR = "key_snooze_button_color";
    public static final String KEY_DISMISS_TITLE_COLOR = "key_dismiss_title_color";
    public static final String KEY_DISMISS_BUTTON_COLOR = "key_dismiss_button_color";
    public static final String KEY_ALARM_BUTTON_COLOR = "key_alarm_button_color";
    public static final String KEY_ALARM_DIGITAL_CLOCK_FONT_SIZE = "key_alarm_digital_clock_font_size";
    public static final String KEY_ALARM_TITLE_FONT_SIZE_PREF = "key_alarm_title_font_size_pref";
    public static final String KEY_DISPLAY_RINGTONE_TITLE = "key_display_ringtone_title";
    public static final String KEY_RINGTONE_TITLE_COLOR = "key_ringtone_title_color";
    public static final String KEY_PREVIEW_ALARM = "key_preview_alarm";

    // Timer
    public static final String KEY_TIMER_CREATION_VIEW_STYLE = "key_timer_creation_view_style";
    public static final String KEY_TIMER_RINGTONE = "key_timer_ringtone";
    public static final String KEY_TIMER_AUTO_SILENCE = "key_timer_auto_silence";
    public static final String KEY_TIMER_VOLUME_CRESCENDO_DURATION = "key_timer_volume_crescendo_duration";
    public static final String KEY_TIMER_VIBRATE = "key_timer_vibrate";
    public static final String KEY_TIMER_VOLUME_BUTTONS_ACTION = "key_timer_volume_buttons_action";
    public static final String KEY_TIMER_POWER_BUTTON_ACTION = "key_timer_power_button_action";
    public static final String KEY_TIMER_FLIP_ACTION = "key_timer_flip_action";
    public static final String KEY_TIMER_SHAKE_ACTION = "key_timer_shake_action";
    public static final String KEY_TIMER_SHAKE_INTENSITY = "key_timer_shake_intensity";
    public static final String KEY_SORT_TIMER = "key_sort_timer";
    public static final String KEY_DEFAULT_TIME_TO_ADD_TO_TIMER = "key_default_time_to_add_to_timer";
    public static final String KEY_TRANSPARENT_BACKGROUND_FOR_EXPIRED_TIMER = "key_transparent_background_for_expired_timer";
    public static final String KEY_DISPLAY_WARNING_BEFORE_DELETING_TIMER = "key_display_warning_before_deleting_timer";

    // Stopwatch
    public static final String KEY_SW_VOLUME_UP_ACTION = "key_sw_volume_up_action";
    public static final String KEY_SW_VOLUME_UP_ACTION_AFTER_LONG_PRESS = "key_sw_volume_up_action_after_long_press";
    public static final String KEY_SW_VOLUME_DOWN_ACTION = "key_sw_volume_down_action";
    public static final String KEY_SW_VOLUME_DOWN_ACTION_AFTER_LONG_PRESS = "key_sw_volume_down_action_after_long_press";

    // Screensaver
    public static final String KEY_SCREENSAVER_CLOCK_STYLE = "key_screensaver_clock_style";
    public static final String KEY_SCREENSAVER_CLOCK_DIAL = "key_screensaver_clock_dial";
    public static final String KEY_SCREENSAVER_CLOCK_DIAL_MATERIAL = "key_screensaver_clock_dial_material";
    public static final String KEY_DISPLAY_SCREENSAVER_CLOCK_SECONDS = "key_display_screensaver_clock_seconds";
    public static final String KEY_SCREENSAVER_CLOCK_SECOND_HAND = "key_screensaver_clock_second_hand";
    public static final String KEY_SCREENSAVER_CLOCK_DYNAMIC_COLORS = "key_screensaver_clock_dynamic_colors";
    public static final String KEY_SCREENSAVER_CLOCK_COLOR_PICKER = "key_screensaver_clock_color_picker";
    public static final String KEY_SCREENSAVER_DATE_COLOR_PICKER = "key_screensaver_date_color_picker";
    public static final String KEY_SCREENSAVER_NEXT_ALARM_COLOR_PICKER = "key_screensaver_next_alarm_color_picker";
    public static final String KEY_SCREENSAVER_BRIGHTNESS = "key_screensaver_brightness";
    public static final String KEY_SCREENSAVER_DIGITAL_CLOCK_IN_BOLD = "key_screensaver_digital_clock_in_bold";
    public static final String KEY_SCREENSAVER_DIGITAL_CLOCK_IN_ITALIC = "key_screensaver_digital_clock_in_italic";
    public static final String KEY_SCREENSAVER_DATE_IN_BOLD = "key_screensaver_date_in_bold";
    public static final String KEY_SCREENSAVER_DATE_IN_ITALIC = "key_screensaver_date_in_italic";
    public static final String KEY_SCREENSAVER_NEXT_ALARM_IN_BOLD = "key_screensaver_next_alarm_in_bold";
    public static final String KEY_SCREENSAVER_NEXT_ALARM_IN_ITALIC = "key_screensaver_next_alarm_in_italic";
    public static final String KEY_SCREENSAVER_PREVIEW = "key_screensaver_preview";
    public static final String KEY_SCREENSAVER_DAYDREAM_SETTINGS = "key_screensaver_daydream_settings";

    // **************
    // ** WIDGETS **
    // **************

    // Widget settings
    public static final String KEY_ANALOG_WIDGET_CUSTOMIZATION = "key_analog_widget_customization";
    public static final String KEY_DIGITAL_WIDGET_CUSTOMIZATION = "key_digital_widget_customization";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_CUSTOMIZATION = "key_vertical_digital_widget_customization";
    public static final String KEY_NEXT_ALARM_WIDGET_CUSTOMIZATION = "key_next_alarm_widget_customization";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CUSTOMIZATION = "key_material_you_analog_widget_customization";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOMIZATION = "key_material_you_digital_widget_customization";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOMIZATION = "key_material_you_vertical_digital_widget_customization";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_CUSTOMIZATION = "key_material_you_next_alarm_widget_customization";

    // Analog Widget
    public static final String KEY_ANALOG_WIDGET_CLOCK_DIAL = "key_analog_widget_clock_dial";
    public static final String KEY_ANALOG_WIDGET_WITH_SECOND_HAND = "key_analog_widget_with_second_hand";
    public static final String KEY_ANALOG_WIDGET_CLOCK_SECOND_HAND = "key_analog_widget_clock_second_hand";
    public static final String KEY_ANALOG_WIDGET_DEFAULT_DIAL_COLOR = "key_analog_widget_default_dial_color";
    public static final String KEY_ANALOG_WIDGET_CUSTOM_DIAL_COLOR = "key_analog_widget_custom_dial_color";
    public static final String KEY_ANALOG_WIDGET_DEFAULT_HOUR_HAND_COLOR = "key_analog_widget_default_hour_hand_color";
    public static final String KEY_ANALOG_WIDGET_CUSTOM_HOUR_HAND_COLOR = "key_analog_widget_custom_hour_hand_color";
    public static final String KEY_ANALOG_WIDGET_DEFAULT_MINUTE_HAND_COLOR = "key_analog_widget_default_minute_hand_color";
    public static final String KEY_ANALOG_WIDGET_CUSTOM_MINUTE_HAND_COLOR = "key_analog_widget_custom_minute_hand_color";
    public static final String KEY_ANALOG_WIDGET_DEFAULT_SECOND_HAND_COLOR = "key_analog_widget_default_second_hand_color";
    public static final String KEY_ANALOG_WIDGET_CUSTOM_SECOND_HAND_COLOR = "key_analog_widget_custom_second_hand_color";

    // Digital Widget
    public static final String KEY_DIGITAL_WIDGET_DISPLAY_SECONDS = "key_digital_widget_display_seconds";
    public static final String KEY_DIGITAL_WIDGET_HIDE_AM_PM = "key_digital_widget_hide_am_pm";
    public static final String KEY_DIGITAL_WIDGET_DISPLAY_BACKGROUND = "key_digital_widget_display_background";
    public static final String KEY_DIGITAL_WIDGET_DISPLAY_DATE = "key_digital_widget_display_date";
    public static final String KEY_DIGITAL_WIDGET_DISPLAY_NEXT_ALARM = "key_digital_widget_display_next_alarm";
    public static final String KEY_DIGITAL_WIDGET_WORLD_CITIES_DISPLAYED = "key_digital_widget_world_cities_displayed";
    public static final String KEY_DIGITAL_WIDGET_APPLY_HORIZONTAL_PADDING = "key_digital_widget_apply_horizontal_padding";
    public static final String KEY_DIGITAL_WIDGET_BACKGROUND_COLOR = "key_digital_widget_background_color";
    public static final String KEY_DIGITAL_WIDGET_DEFAULT_CLOCK_COLOR = "key_digital_widget_default_clock_color";
    public static final String KEY_DIGITAL_WIDGET_CUSTOM_CLOCK_COLOR = "key_digital_widget_custom_clock_color";
    public static final String KEY_DIGITAL_WIDGET_DEFAULT_DATE_COLOR = "key_digital_widget_default_date_color";
    public static final String KEY_DIGITAL_WIDGET_CUSTOM_DATE_COLOR = "key_digital_widget_custom_date_color";
    public static final String KEY_DIGITAL_WIDGET_DEFAULT_NEXT_ALARM_COLOR = "key_digital_widget_default_next_alarm_color";
    public static final String KEY_DIGITAL_WIDGET_CUSTOM_NEXT_ALARM_COLOR = "key_digital_widget_custom_next_alarm_color";
    public static final String KEY_DIGITAL_WIDGET_DEFAULT_CITY_CLOCK_COLOR = "key_digital_widget_default_city_clock_color";
    public static final String KEY_DIGITAL_WIDGET_CUSTOM_CITY_CLOCK_COLOR = "key_digital_widget_custom_city_clock_color";
    public static final String KEY_DIGITAL_WIDGET_DEFAULT_CITY_NAME_COLOR = "key_digital_widget_default_city_name_color";
    public static final String KEY_DIGITAL_WIDGET_CUSTOM_CITY_NAME_COLOR = "key_digital_widget_custom_city_name_color";
    public static final String KEY_DIGITAL_WIDGET_MAXIMUM_CLOCK_FONT_SIZE = "key_digital_widget_maximum_clock_font_size";

    // Next Alarm Widget
    public static final String KEY_NEXT_ALARM_WIDGET_DISPLAY_BACKGROUND = "key_next_alarm_widget_display_background";
    public static final String KEY_NEXT_ALARM_WIDGET_APPLY_HORIZONTAL_PADDING = "key_next_alarm_widget_apply_horizontal_padding";
    public static final String KEY_NEXT_ALARM_WIDGET_BACKGROUND_COLOR = "key_next_alarm_widget_background_color";
    public static final String KEY_NEXT_ALARM_WIDGET_DEFAULT_TITLE_COLOR = "key_next_alarm_widget_default_title_color";
    public static final String KEY_NEXT_ALARM_WIDGET_CUSTOM_TITLE_COLOR = "key_next_alarm_widget_custom_title_color";
    public static final String KEY_NEXT_ALARM_WIDGET_DEFAULT_ALARM_TITLE_COLOR = "key_next_alarm_widget_default_alarm_title_color";
    public static final String KEY_NEXT_ALARM_WIDGET_CUSTOM_ALARM_TITLE_COLOR = "key_next_alarm_widget_custom_alarm_title_color";
    public static final String KEY_NEXT_ALARM_WIDGET_DEFAULT_ALARM_COLOR = "key_next_alarm_widget_default_alarm_color";
    public static final String KEY_NEXT_ALARM_WIDGET_CUSTOM_ALARM_COLOR = "key_next_alarm_widget_custom_alarm_color";
    public static final String KEY_NEXT_ALARM_WIDGET_MAXIMUM_FONT_SIZE = "key_next_alarm_widget_maximum_font_size";

    // Vertical Digital Widget
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DISPLAY_BACKGROUND = "key_vertical_digital_widget_display_background";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DISPLAY_DATE = "key_vertical_digital_widget_display_date";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DISPLAY_NEXT_ALARM = "key_vertical_digital_widget_display_next_alarm";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_APPLY_HORIZONTAL_PADDING = "key_vertical_digital_widget_apply_horizontal_padding";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_BACKGROUND_COLOR = "key_vertical_digital_widget_background_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DEFAULT_HOURS_COLOR = "key_vertical_digital_widget_default_hours_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_CUSTOM_HOURS_COLOR = "key_vertical_digital_widget_custom_hours_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DEFAULT_MINUTES_COLOR = "key_vertical_digital_widget_default_minutes_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_CUSTOM_MINUTES_COLOR = "key_vertical_digital_widget_custom_minutes_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DEFAULT_DATE_COLOR = "key_vertical_digital_widget_default_date_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_CUSTOM_DATE_COLOR = "key_vertical_digital_widget_custom_date_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_DEFAULT_NEXT_ALARM_COLOR = "key_vertical_digital_widget_default_next_alarm_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_CUSTOM_NEXT_ALARM_COLOR = "key_vertical_digital_widget_custom_next_alarm_color";
    public static final String KEY_VERTICAL_DIGITAL_WIDGET_MAXIMUM_CLOCK_FONT_SIZE = "key_vertical_digital_widget_maximum_clock_font_size";

    // Material You Analog Widget
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CLOCK_DIAL = "key_material_you_analog_widget_clock_dial";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_WITH_SECOND_HAND = "key_material_you_analog_widget_with_second_hand";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_DEFAULT_DIAL_COLOR = "key_material_you_analog_widget_default_dial_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CUSTOM_DIAL_COLOR = "key_material_you_analog_widget_custom_dial_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_DEFAULT_HOUR_HAND_COLOR = "key_material_you_analog_widget_default_hour_hand_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CUSTOM_HOUR_HAND_COLOR = "key_material_you_analog_widget_custom_hour_hand_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_DEFAULT_MINUTE_HAND_COLOR = "key_material_you_analog_widget_default_minute_hand_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CUSTOM_MINUTE_HAND_COLOR = "key_material_you_analog_widget_custom_minute_hand_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_DEFAULT_SECOND_HAND_COLOR = "key_material_you_analog_widget_default_second_hand_color";
    public static final String KEY_MATERIAL_YOU_ANALOG_WIDGET_CUSTOM_SECOND_HAND_COLOR = "key_material_you_analog_widget_custom_second_hand_color";

    // Material You Digital Widget
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_SECONDS_DISPLAYED = "key_material_you_digital_widget_seconds_displayed";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_HIDE_AM_PM = "key_material_you_digital_widget_hide_am_pm";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DISPLAY_BACKGROUND = "key_material_you_digital_widget_display_background";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DISPLAY_DATE = "key_material_you_digital_widget_display_date";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DISPLAY_NEXT_ALARM = "key_material_you_digital_widget_display_next_alarm";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_WORLD_CITIES_DISPLAYED = "key_material_you_digital_widget_world_cities_displayed";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_APPLY_HORIZONTAL_PADDING = "key_material_you_digital_widget_apply_horizontal_padding";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_BACKGROUND_COLOR = "key_material_you_digital_widget_default_background_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_BACKGROUND_COLOR = "key_material_you_digital_widget_custom_background_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_CLOCK_COLOR = "key_material_you_digital_widget_default_clock_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_CLOCK_COLOR = "key_material_you_digital_widget_custom_clock_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_DATE_COLOR = "key_material_you_digital_widget_default_date_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_DATE_COLOR = "key_material_you_digital_widget_custom_date_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_NEXT_ALARM_COLOR = "key_material_you_digital_widget_default_next_alarm_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_NEXT_ALARM_COLOR = "key_material_you_digital_widget_custom_next_alarm_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_CITY_CLOCK_COLOR = "key_material_you_digital_widget_default_city_clock_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_CITY_CLOCK_COLOR = "key_material_you_digital_widget_custom_city_clock_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_DEFAULT_CITY_NAME_COLOR = "key_material_you_digital_widget_default_city_name_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_CUSTOM_CITY_NAME_COLOR = "key_material_you_digital_widget_custom_city_name_color";
    public static final String KEY_MATERIAL_YOU_DIGITAL_WIDGET_MAXIMUM_CLOCK_FONT_SIZE = "key_material_you_digital_widget_maximum_clock_font_size";

    // Material You Vertical Digital Widget
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DISPLAY_BACKGROUND = "key_material_you_vertical_digital_widget_display_background";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DISPLAY_DATE = "key_material_you_vertical_digital_widget_display_date";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DISPLAY_NEXT_ALARM = "key_material_you_vertical_digital_widget_display_next_alarm";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_APPLY_HORIZONTAL_PADDING = "key_material_you_vertical_digital_widget_apply_horizontal_padding";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DEFAULT_BACKGROUND_COLOR = "key_material_you_vertical_digital_widget_default_background_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOM_BACKGROUND_COLOR = "key_material_you_vertical_digital_widget_custom_background_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DEFAULT_HOURS_COLOR = "key_material_you_vertical_digital_widget_default_hours_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOM_HOURS_COLOR = "key_material_you_vertical_digital_widget_custom_hours_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DEFAULT_MINUTES_COLOR = "key_material_you_vertical_digital_widget_default_minutes_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOM_MINUTES_COLOR = "key_material_you_vertical_digital_widget_custom_minutes_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DEFAULT_DATE_COLOR = "key_material_you_vertical_digital_widget_default_date_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOM_DATE_COLOR = "key_material_you_vertical_digital_widget_custom_date_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_DEFAULT_NEXT_ALARM_COLOR = "key_material_you_vertical_digital_widget_default_next_alarm_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_CUSTOM_NEXT_ALARM_COLOR = "key_material_you_vertical_digital_widget_custom_next_alarm_color";
    public static final String KEY_MATERIAL_YOU_VERTICAL_DIGITAL_WIDGET_MAXIMUM_CLOCK_FONT_SIZE = "key_material_you_vertical_digital_widget_maximum_clock_font_size";

    // Material You Next Alarm Widget
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_DISPLAY_BACKGROUND = "key_material_you_next_alarm_widget_display_background";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_APPLY_HORIZONTAL_PADDING = "key_material_you_next_alarm_widget_apply_horizontal_padding";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_DEFAULT_BACKGROUND_COLOR = "key_material_you_next_alarm_widget_default_background_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_CUSTOM_BACKGROUND_COLOR = "key_material_you_next_alarm_widget_custom_background_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_DEFAULT_TITLE_COLOR = "key_material_you_next_alarm_widget_default_title_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_CUSTOM_TITLE_COLOR = "key_material_you_next_alarm_widget_custom_title_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_DEFAULT_ALARM_TITLE_COLOR = "key_material_you_next_alarm_widget_default_alarm_title_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_CUSTOM_ALARM_TITLE_COLOR = "key_material_you_next_alarm_widget_custom_alarm_title_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_DEFAULT_ALARM_COLOR = "key_material_you_next_alarm_widget_default_alarm_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_CUSTOM_ALARM_COLOR = "key_material_you_next_alarm_widget_custom_alarm_color";
    public static final String KEY_MATERIAL_YOU_NEXT_ALARM_WIDGET_MAXIMUM_FONT_SIZE = "key_material_you_next_alarm_widget_maximum_font_size";

}
