# Aiyo

## Description

Aiyo is an AI chat app that allows you to chat with hundreds of models by bringing your own OpenRouter API key. It's designed to be simple, elegant and easy-to-use.

## Features

- 💬 Chat with any model of your choice
- ✨ Access to over 500 models on OpenRouter
- 🧠 Supports reasoning, web-search 🌐, and chat history 📜
- 🔒 Privacy-respectful: no data is collected by Aiyo

## Installation
<a href="https://f-droid.org/en/packages/com.beradeep.aiyo/"><img height="100" src="https://github.com/user-attachments/assets/65b70711-9d16-4334-bf3d-4b2872495c25" /></a>

### Building from Source
1. Clone the repository
2. Open the project in Android Studio
3. Sync the project with Gradle files
4. Build and run the project on your device or emulator

**Requirements:**
- Android Studio
- Android SDK API level 24 or higher
- Gradle 8.0+

## Technology Stack

- **Kotlin** - Primary programming language
- **Jetpack Compose** - Modern UI toolkit
- **MVVM Architecture** - Clean architecture pattern
- **[OpenAI Kotlin](https://github.com/aallam/openai-kotlin)** - For interacting with OpenRouter

## Contributing

Contributions are welcome! Here's how you can help:

1. Fork the repository
2. Create a new branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## Star the Project ⭐

If you like Aiyo, please consider giving it a star on GitHub to show your support and help others discover the project.

## License

This project is licensed under the Apache-2.0 License - see the [LICENSE](LICENSE) file for details.
