package com.bbzone.isitprime

import android.os.Bundle
import android.view.inputmethod.EditorInfo
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import android.widget.EditText
import android.widget.TextView

/** True if number is a prime number
 */
fun Long.isPrime() : Boolean {
    var prime = true
    for ( f : Long in 2..(this/2) ) {
        if ( this % f == 0L ) {
            prime = false
            break
        }
    }
    return prime
}

/** Return prime factors of number in an array list
 */
fun Long.primeFactors() : ArrayList<Long> {
    var pfactors = ArrayList<Long>()
    if ( !this.isPrime() ) {
        var factor : Long = 0

        for ( f in 2 .. this/2 ) {
            if ( f.isPrime() && this % f == 0L ) {
                factor = f
                break
            }
        }
        if ( factor != 0L ) {
            val remainder : Long = this / factor
            pfactors = remainder.primeFactors()
            pfactors.add(factor)
        }
    } else {
        pfactors.add(this)
    }
    return pfactors
}

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        enableEdgeToEdge()
        setContentView(R.layout.activity_main)
        ViewCompat.setOnApplyWindowInsetsListener(findViewById(R.id.main)) { v, insets ->
            val systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars())
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom)
            insets
        }

        fun EditText.onDone(callback: () -> Unit) {
            setOnEditorActionListener { _, actionId, _ ->
                if (actionId == EditorInfo.IME_ACTION_DONE) {
                    callback.invoke()
                    return@setOnEditorActionListener true
                }
                false
            }
        }

        val inputNum : EditText = findViewById(R.id.editNumber)

        inputNum.onDone {
            val textYesNo : TextView = findViewById(R.id.textYesNo)
            val viewFactors : TextView = findViewById(R.id.viewFactors)

            if ( inputNum.length() > 0 ) {
                val number = inputNum.text.toString().toLong()
                var msg: String = inputNum.text.toString() + getString(R.string.notprime)

                if (number > 1 && number.isPrime()) {
                    msg = inputNum.text.toString() + getString(R.string.isprime)
                    viewFactors.text = ""
                } else {
                    val factors =
                        inputNum.text.toString() + " = " + number.primeFactors().joinToString(" * ")
                    viewFactors.text = factors
                }
                textYesNo.text = msg
            }
        }
    }
}
