package com.baldo.bob.ui.compose.settings

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material3.Icon
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.SegmentedButton
import androidx.compose.material3.SegmentedButtonDefaults
import androidx.compose.material3.SingleChoiceSegmentedButtonRow
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.remember
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.dp
import com.baldo.bob.R
import com.baldo.bob.dataStore.AppSettings
import com.baldo.bob.ui.viewModel.AppUiState
import com.baldo.bob.ui.viewModel.BobViewModel

@Composable
fun AppearanceScreen(
    navigateBack: () -> Unit,
    bobViewModel: BobViewModel,
    appUiState: AppUiState,
) {
    Column(
        Modifier
            .fillMaxSize()
            .padding(16.dp)

    ) {
        Icon(
            Icons.AutoMirrored.Filled.ArrowBack,
            contentDescription = "back",
            modifier = Modifier
                .padding(bottom = 32.dp)
                .clickable { navigateBack() }
        )

        Text(
            stringResource(id = R.string.settings),
            fontWeight = FontWeight.Bold,
            style = MaterialTheme.typography.headlineLarge,
            color = MaterialTheme.colorScheme.primary,
            modifier = Modifier.padding(bottom = 64.dp)
        )
        ThemeSelector(bobViewModel, appUiState)
    }
}

@Composable
fun ThemeSelector(bobViewModel: BobViewModel, appUiState: AppUiState) {
    Text(stringResource(id = R.string.theme), modifier = Modifier.padding(bottom = 16.dp))
    Row(Modifier.fillMaxWidth(), horizontalArrangement = Arrangement.Center) {
        val selectedOption = remember {
            mutableStateListOf("light", "dark", "system")
        }
        val options = listOf(
            stringResource(id = R.string.light),
            stringResource(id = R.string.dark),
            stringResource(id = R.string.system)
        )
        val themeSetting: String = appUiState.themeSetting
        SingleChoiceSegmentedButtonRow {
            options.forEachIndexed { index, label ->
                SegmentedButton(
                    shape = SegmentedButtonDefaults.itemShape(
                        index = index,
                        count = options.size
                    ),
                    onClick = { bobViewModel.updateAppSettings(AppSettings(themeSetting = selectedOption[index])) },
                    selected = selectedOption[index] == themeSetting,
                    label = { Text(label) }
                )
            }
        }
    }
}

