/* Autogenerated file, do not edit manually */
package chat.delta.rpc.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

@JsonTypeInfo(use=Id.NAME, include=As.PROPERTY, property="kind")
@JsonSubTypes({@Type(value = ChatListItemFetchResult.ChatListItem.class, name="ChatListItem"), @Type(value = ChatListItemFetchResult.ArchiveLink.class, name="ArchiveLink"), @Type(value = ChatListItemFetchResult.Error.class, name="Error")})
public abstract class ChatListItemFetchResult {

  public static class ChatListItem extends ChatListItemFetchResult {
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public String avatarPath;
    public ChatType chatType;
    public String color;
    /** contact id if this is a dm chat (for view profile entry in context menu) */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer dmChatContact;
    public Integer freshMessageCounter;
    public Integer id;
    public Boolean isArchived;
    public Boolean isContactRequest;
    public Boolean isDeviceTalk;
    /**
     * True if the chat is encrypted. This means that all messages in the chat are encrypted, and all contacts in the chat are "key-contacts", i.e. identified by the PGP key fingerprint.
     * <p>
     * False if the chat is unencrypted. This means that all messages in the chat are unencrypted, and all contacts in the chat are "address-contacts", i.e. identified by the email address. The UI should mark this chat e.g. with a mail-letter icon.
     * <p>
     * Unencrypted groups are called "ad-hoc groups" and the user can't add/remove members, create a QR invite code, or set an avatar. These options should therefore be disabled in the UI.
     * <p>
     * Note that it can happen that an encrypted chat contains unencrypted messages that were received in core <= v1.159.* and vice versa.
     * <p>
     * See also `is_key_contact` on `Contact`.
     */
    public Boolean isEncrypted;
    /** deprecated 2025-07, use chat_type instead */
    public Boolean isGroup;
    public Boolean isMuted;
    public Boolean isPinned;
    public Boolean isSelfInGroup;
    public Boolean isSelfTalk;
    public Boolean isSendingLocation;
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer lastMessageId;
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Viewtype lastMessageType;
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public Integer lastUpdated;
    public String name;
    /** showing preview if last chat message is image */
    @com.fasterxml.jackson.annotation.JsonSetter(nulls = com.fasterxml.jackson.annotation.Nulls.SET)
    public String summaryPreviewImage;
    public Integer summaryStatus;
    public String summaryText1;
    public String summaryText2;
    public Boolean wasSeenRecently;
  }

  public static class ArchiveLink extends ChatListItemFetchResult {
    public Integer freshMessageCounter;
  }

  public static class Error extends ChatListItemFetchResult {
    public String error;
    public Integer id;
  }

}