/* Autogenerated file, do not edit manually */
package chat.delta.rpc.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonSubTypes.Type;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo.Id;
import com.fasterxml.jackson.annotation.JsonTypeInfo.As;

@JsonTypeInfo(use=Id.NAME, include=As.PROPERTY, property="kind")
@JsonSubTypes({@Type(value = CallState.Alerting.class, name="Alerting"), @Type(value = CallState.Active.class, name="Active"), @Type(value = CallState.Completed.class, name="Completed"), @Type(value = CallState.Missed.class, name="Missed"), @Type(value = CallState.Declined.class, name="Declined"), @Type(value = CallState.Canceled.class, name="Canceled")})
public abstract class CallState {

/**
 * Fresh incoming or outgoing call that is still ringing.
 * <p>
 * There is no separate state for outgoing call that has been dialled but not ringing on the other side yet as we don't know whether the other side received our call.
 */
  public static class Alerting extends CallState {
  }

/* Active call. */
  public static class Active extends CallState {
  }

/* Completed call that was once active and then was terminated for any reason. */
  public static class Completed extends CallState {
    /* Call duration in seconds. */
    public Integer duration;
  }

/* Incoming call that was not picked up within a timeout or was explicitly ended by the caller before we picked up. */
  public static class Missed extends CallState {
  }

/* Incoming call that was explicitly ended on our side before picking up or outgoing call that was declined before the timeout. */
  public static class Declined extends CallState {
  }

/**
 * Outgoing call that has been canceled on our side before receiving a response.
 * <p>
 * Incoming calls cannot be canceled, on the receiver side canceled calls usually result in missed calls.
 */
  public static class Canceled extends CallState {
  }

}