/* Autogenerated file, do not edit manually */
package chat.delta.rpc;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;

import chat.delta.rpc.types.*;

public class Rpc {

  public interface Transport {
    void call(String method, JsonNode... params) throws RpcException;
    <T> T callForResult(TypeReference<T> resultType, String method, JsonNode... params) throws RpcException;
    ObjectMapper getObjectMapper();
  }

  public final Transport transport;
  private final ObjectMapper mapper;

  public Rpc(Transport transport) {
    this.transport = transport;
    this.mapper = transport.getObjectMapper();
  }

  public Integer addAccount() throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "add_account");
  }

  /**
   * Set the order of accounts.
   * The provided list should contain all account IDs in the desired order.
   * If an account ID is missing from the list, it will be appended at the end.
   * If the list contains non-existent account IDs, they will be ignored.
   */
  public void setAccountsOrder(java.util.List<Integer> order) throws RpcException {
    transport.call("set_accounts_order", mapper.valueToTree(order));
  }

  /* Get the combined filesize of an account in bytes */
  public Integer getAccountFileSize(Integer accountId) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "get_account_file_size", mapper.valueToTree(accountId));
  }

  /**
   * If there was an error while the account was opened
   * and migrated to the current version,
   * then this function returns it.
   * <p>
   * This function is useful because the key-contacts migration could fail due to bugs
   * and then the account will not work properly.
   * <p>
   * After opening an account, the UI should call this function
   * and show the error string if one is returned.
   */
  public String getMigrationError(Integer accountId) throws RpcException {
    return transport.callForResult(new TypeReference<String>(){}, "get_migration_error", mapper.valueToTree(accountId));
  }

  /* Returns configuration value for the given key. */
  public String getConfig(Integer accountId, String key) throws RpcException {
    return transport.callForResult(new TypeReference<String>(){}, "get_config", mapper.valueToTree(accountId), mapper.valueToTree(key));
  }

  /**
   * Configures a new email account using the provided parameters
   * and adds it as a transport.
   * <p>
   * If the email address is the same as an existing transport,
   * then this existing account will be reconfigured instead of a new one being added.
   * <p>
   * This function stops and starts IO as needed.
   * <p>
   * Usually it will be enough to only set `addr` and `password`,
   * and all the other settings will be autoconfigured.
   * <p>
   * During configuration, ConfigureProgress events are emitted;
   * they indicate a successful configuration as well as errors
   * and may be used to create a progress bar.
   * This function will return after configuration is finished.
   * <p>
   * If configuration is successful,
   * the working server parameters will be saved
   * and used for connecting to the server.
   * The parameters entered by the user will be saved separately
   * so that they can be prefilled when the user opens the server-configuration screen again.
   * <p>
   * See also:
   * - [Self::is_configured()] to check whether there is
   * at least one working transport.
   * - [Self::add_transport_from_qr()] to add a transport
   * from a server encoded in a QR code.
   * - [Self::list_transports()] to get a list of all configured transports.
   * - [Self::delete_transport()] to remove a transport.
   */
  public void addOrUpdateTransport(Integer accountId, EnteredLoginParam param) throws RpcException {
    transport.call("add_or_update_transport", mapper.valueToTree(accountId), mapper.valueToTree(param));
  }

  /**
   * Adds a new email account as a transport
   * using the server encoded in the QR code.
   * See [Self::add_or_update_transport].
   */
  public void addTransportFromQr(Integer accountId, String qr) throws RpcException {
    transport.call("add_transport_from_qr", mapper.valueToTree(accountId), mapper.valueToTree(qr));
  }

  /**
   * Create a new unencrypted group chat.
   * <p>
   * Same as [`Self::create_group_chat`], but the chat is unencrypted and can only have
   * address-contacts.
   */
  public Integer createGroupChatUnencrypted(Integer accountId, String name) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "create_group_chat_unencrypted", mapper.valueToTree(accountId), mapper.valueToTree(name));
  }

  /**
   * Create a new **broadcast channel**
   * (called "Channel" in the UI).
   * <p>
   * Broadcast channels are similar to groups on the sending device,
   * however, recipients get the messages in a read-only chat
   * and will not see who the other members are.
   * <p>
   * Called `broadcast` here rather than `channel`,
   * because the word "channel" already appears a lot in the code,
   * which would make it hard to grep for it.
   * <p>
   * After creation, the chat contains no recipients and is in _unpromoted_ state;
   * see [`CommandApi::create_group_chat`] for more information on the unpromoted state.
   * <p>
   * Returns the created chat's id.
   */
  public Integer createBroadcast(Integer accountId, String chatName) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "create_broadcast", mapper.valueToTree(accountId), mapper.valueToTree(chatName));
  }

  /* Returns contact id of the created or existing DM chat with that contact */
  public Integer createChatByContactId(Integer accountId, Integer contactId) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "create_chat_by_contact_id", mapper.valueToTree(accountId), mapper.valueToTree(contactId));
  }

  /* Sets display name for existing contact. */
  public void changeContactName(Integer accountId, Integer contactId, String name) throws RpcException {
    transport.call("change_contact_name", mapper.valueToTree(accountId), mapper.valueToTree(contactId), mapper.valueToTree(name));
  }


  /* Parses a vCard file located at the given path. Returns contacts in their original order. */
  public java.util.List<VcardContact> parseVcard(String path) throws RpcException {
    return transport.callForResult(new TypeReference<java.util.List<VcardContact>>(){}, "parse_vcard", mapper.valueToTree(path));
  }

  /**
   * Imports contacts from a vCard file located at the given path.
   * <p>
   * Returns the ids of created/modified contacts in the order they appear in the vCard.
   */
  public java.util.List<Integer> importVcard(Integer accountId, String path) throws RpcException {
    return transport.callForResult(new TypeReference<java.util.List<Integer>>(){}, "import_vcard", mapper.valueToTree(accountId), mapper.valueToTree(path));
  }

  /* Returns a vCard containing contacts with the given ids. */
  public String makeVcard(Integer accountId, java.util.List<Integer> contacts) throws RpcException {
    return transport.callForResult(new TypeReference<String>(){}, "make_vcard", mapper.valueToTree(accountId), mapper.valueToTree(contacts));
  }

  public void sendWebxdcRealtimeData(Integer accountId, Integer instanceMsgId, java.util.List<Integer> data) throws RpcException {
    transport.call("send_webxdc_realtime_data", mapper.valueToTree(accountId), mapper.valueToTree(instanceMsgId), mapper.valueToTree(data));
  }

  public void sendWebxdcRealtimeAdvertisement(Integer accountId, Integer instanceMsgId) throws RpcException {
    transport.call("send_webxdc_realtime_advertisement", mapper.valueToTree(accountId), mapper.valueToTree(instanceMsgId));
  }

  /**
   * Leaves the gossip of the webxdc with the given message id.
   * <p>
   * NB: When this is called before closing a webxdc app in UIs, it must be guaranteed that
   * `send_webxdc_realtime_*()` functions aren't called for the given `instance_message_id`
   * anymore until the app is open again.
   */
  public void leaveWebxdcRealtime(Integer accountId, Integer instanceMessageId) throws RpcException {
    transport.call("leave_webxdc_realtime", mapper.valueToTree(accountId), mapper.valueToTree(instanceMessageId));
  }

  /* Starts an outgoing call. */
  public Integer placeOutgoingCall(Integer accountId, Integer chatId, String placeCallInfo) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "place_outgoing_call", mapper.valueToTree(accountId), mapper.valueToTree(chatId), mapper.valueToTree(placeCallInfo));
  }

  /* Accepts an incoming call. */
  public void acceptIncomingCall(Integer accountId, Integer msgId, String acceptCallInfo) throws RpcException {
    transport.call("accept_incoming_call", mapper.valueToTree(accountId), mapper.valueToTree(msgId), mapper.valueToTree(acceptCallInfo));
  }

  /* Ends incoming or outgoing call. */
  public void endCall(Integer accountId, Integer msgId) throws RpcException {
    transport.call("end_call", mapper.valueToTree(accountId), mapper.valueToTree(msgId));
  }

  /* Returns information about the call. */
  public CallInfo callInfo(Integer accountId, Integer msgId) throws RpcException {
    return transport.callForResult(new TypeReference<CallInfo>(){}, "call_info", mapper.valueToTree(accountId), mapper.valueToTree(msgId));
  }

  /* Returns JSON with ICE servers, to be used for WebRTC video calls. */
  public String iceServers(Integer accountId) throws RpcException {
    return transport.callForResult(new TypeReference<String>(){}, "ice_servers", mapper.valueToTree(accountId));
  }

  /**
   * Makes an HTTP GET request and returns a response.
   * <p>
   * `url` is the HTTP or HTTPS URL.
   */
  public HttpResponse getHttpResponse(Integer accountId, String url) throws RpcException {
    return transport.callForResult(new TypeReference<HttpResponse>(){}, "get_http_response", mapper.valueToTree(accountId), mapper.valueToTree(url));
  }

  /**
   * Send a reaction to message.
   * <p>
   * Reaction is a string of emojis separated by spaces. Reaction to a
   * single message can be sent multiple times. The last reaction
   * received overrides all previously received reactions. It is
   * possible to remove all reactions by sending an empty string.
   */
  public Integer sendReaction(Integer accountId, Integer messageId, java.util.List<String> reaction) throws RpcException {
    return transport.callForResult(new TypeReference<Integer>(){}, "send_reaction", mapper.valueToTree(accountId), mapper.valueToTree(messageId), mapper.valueToTree(reaction));
  }

  /* Returns reactions to the message. */
  public Reactions getMessageReactions(Integer accountId, Integer messageId) throws RpcException {
    return transport.callForResult(new TypeReference<Reactions>(){}, "get_message_reactions", mapper.valueToTree(accountId), mapper.valueToTree(messageId));
  }

  /* Checks if messages can be sent to a given chat. */
  public Boolean canSend(Integer accountId, Integer chatId) throws RpcException {
    return transport.callForResult(new TypeReference<Boolean>(){}, "can_send", mapper.valueToTree(accountId), mapper.valueToTree(chatId));
  }

}
