# deltachat-jsonrpc

This crate provides a [JSON-RPC 2.0](https://www.jsonrpc.org/specification) interface to DeltaChat.

The JSON-RPC API is exposed in two fashions:

* A executable `deltachat-rpc-server` that exposes the JSON-RPC API through stdio.
* The JSON-RPC API can also be called through the [C FFI](../deltachat-ffi). It exposes the functions `dc_jsonrpc_init`, `dc_jsonrpc_request`, `dc_jsonrpc_next_response` and `dc_jsonrpc_unref`. See the docs in the [header file](../deltachat-ffi/deltachat.h) for details.

We also include a JavaScript and TypeScript client for the JSON-RPC API. The source for this is in the [`typescript`](typescript) folder.

## Usage

#### Using the TypeScript/JavaScript client

The package includes a JavaScript/TypeScript client which is partially auto-generated through the JSON-RPC library used by this crate ([yerpc](https://github.com/chatmail/yerpc)). Find the source in the [`typescript`](typescript) folder. 

To use it locally, first install the dependencies and compile the TypeScript code to JavaScript:
```sh
cd typescript
npm install
npm run build
```

The JavaScript client is [published on NPM](https://www.npmjs.com/package/@deltachat/jsonrpc-client).

A script is included to build autogenerated documentation, which includes all RPC methods:
```sh
cd typescript
npm run docs
```
Then open the [`typescript/docs`](typescript/docs) folder in a web browser.

## Development

#### Running the example app

### Testing

The crate includes both a basic Rust smoke test and more featureful integration tests that use the TypeScript client.

#### Rust tests

To run the Rust test, use this command:

```
cargo test
```

#### TypeScript tests

```
cd typescript
npm run test
```

This will build the `deltachat-jsonrpc-server` binary and then run a test suite.

The test suite includes some tests that need online connectivity and a way to create test email accounts. To run these tests, set the `CHATMAIL_DOMAIN` environment variable to your testing email server domain.

```
CHATMAIL_DOMAIN=ci-chatmail.testrun.org npm run test
```

#### Test Coverage

Running `npm run test` will report test coverage. For the coverage to be accurate the online tests need to be run.

> If you are offline and want to see the coverage results anyway (even though they are inaccurate), you can bypass the errors of the online tests by setting the `COVERAGE_OFFLINE=1` environment variable.

A summary of the coverage will be reported in the terminal after the test run. Open `coverage/index.html` in a web browser for a detailed report.
