/*
 * Aurora Store
 *  Copyright (C) 2021, Rahul Kumar Patel <whyorean@gmail.com>
 *
 *  Aurora Store is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Aurora Store is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Aurora Store.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package com.aurora.store.data.model

import android.graphics.drawable.Drawable

data class Black(val packageName: String) {
    var displayName: String = String()
    var drawable: Drawable? = null
    var versionName: String = String()
    var versionCode: Long = 0

    override fun hashCode(): Int = packageName.hashCode()

    override fun equals(other: Any?): Boolean = when (other) {
        is Black -> other.packageName == packageName
        else -> false
    }
}
