/*
 * Aurora Store
 *  Copyright (C) 2021, Rahul Kumar Patel <whyorean@gmail.com>
 *
 *  Aurora Store is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  Aurora Store is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with Aurora Store.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

package com.aurora

object Constants {

    const val PARCEL_DOWNLOAD = "PARCEL_DOWNLOAD"

    const val URL_TOS = "https://play.google.com/about/play-terms/"
    const val URL_LICENSE = "https://gitlab.com/AuroraOSS/AuroraStore/blob/master/LICENSE"
    const val URL_DISCLAIMER = "https://gitlab.com/AuroraOSS/AuroraStore/blob/master/DISCLAIMER.md"
    const val URL_POLICY = "https://gitlab.com/AuroraOSS/AuroraStore/-/blob/master/POLICY.md"

    const val EXODUS_SUBMIT_PAGE = "https://reports.exodus-privacy.eu.org/analysis/submit/#"
    const val EXODUS_REPORT_URL = "https://reports.exodus-privacy.eu.org/reports/"
    const val EXODUS_SEARCH_URL = "https://reports.exodus-privacy.eu.org/api/search/"

    const val PLEXUS_API_URL = "https://plexus.techlore.tech/api/v1/apps"
    const val PLEXUS_SEARCH_URL = "https://plexus.techlore.tech/?q="

    const val SHARE_URL = "https://play.google.com/store/apps/details?id="

    const val UPDATE_URL_STABLE = "https://gitlab.com/AuroraOSS/AuroraStore/raw/master/updates.json"
    const val UPDATE_URL_NIGHTLY =
        "https://auroraoss.com/downloads/AuroraStore/Feeds/nightly_feed.json"

    const val NOTIFICATION_CHANNEL_EXPORT = "NOTIFICATION_CHANNEL_EXPORT"
    const val NOTIFICATION_CHANNEL_INSTALL = "NOTIFICATION_CHANNEL_INSTALL"
    const val NOTIFICATION_CHANNEL_DOWNLOADS = "NOTIFICATION_CHANNEL_DOWNLOADS"
    const val NOTIFICATION_CHANNEL_UPDATES = "NOTIFICATION_CHANNEL_UPDATES"
    const val NOTIFICATION_CHANNEL_ACCOUNT = "NOTIFICATION_CHANNEL_ACCOUNT"

    const val GITLAB_URL = "https://gitlab.com/AuroraOSS/AuroraStore"
    const val URL_DISPENSER = "https://auroraoss.com/api/auth"

    //ACCOUNTS
    const val ACCOUNT_SIGNED_IN = "ACCOUNT_SIGNED_IN"
    const val ACCOUNT_TYPE = "ACCOUNT_TYPE"
    const val ACCOUNT_EMAIL_PLAIN = "ACCOUNT_EMAIL_PLAIN"
    const val ACCOUNT_AAS_PLAIN = "ACCOUNT_AAS_PLAIN"
    const val ACCOUNT_AUTH_PLAIN = "ACCOUNT_AUTH_PLAIN"

    const val PAGE_TYPE = "PAGE_TYPE"
    const val TOP_CHART_TYPE = "TOP_CHART_TYPE"
    const val TOP_CHART_CATEGORY = "TOP_CHART_CATEGORY"

    const val JSON_MIME_TYPE = "application/json"

    // PACKAGE NAMES
    const val PACKAGE_NAME_GMS = "com.google.android.gms"
    const val PACKAGE_NAME_PLAY_STORE = "com.android.vending"
    const val PACKAGE_NAME_APP_GALLERY = "com.huawei.appmarket"
}
