package com.atharok.btremote.domain.entities.remoteInput.keyboard.virtualKeyboard

import com.atharok.btremote.common.utils.REMOTE_INPUT_NONE
import com.atharok.btremote.domain.entities.remoteInput.keyboard.KeyboardKey

class EnglishUKVirtualKeyboardLayout: VirtualKeyboardLayout() {

    protected override val keyboardInputs: Map<Char, ByteArray> by lazy {
        mapOf(
            ' ' to KEYBOARD_KEY_SPACE_BAR,

            '`' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_00.byte),
            '1' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_01.byte),
            '2' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_02.byte),
            '3' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_03.byte),
            '4' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_04.byte),
            '5' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_05.byte),
            '6' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_06.byte),
            '7' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_07.byte),
            '8' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_08.byte),
            '9' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_09.byte),
            '0' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_10.byte),
            '-' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_11.byte),
            '=' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_12.byte),

            'q' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_00.byte),
            'w' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_01.byte),
            'e' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_02.byte),
            'r' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_03.byte),
            't' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_04.byte),
            'y' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_05.byte),
            'u' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_06.byte),
            'i' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_07.byte),
            'o' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_08.byte),
            'p' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_09.byte),
            '[' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_10.byte),
            ']' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_11.byte),

            'a' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_00.byte),
            's' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_01.byte),
            'd' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_02.byte),
            'f' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_03.byte),
            'g' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_04.byte),
            'h' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_05.byte),
            'j' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_06.byte),
            'k' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_07.byte),
            'l' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_08.byte),
            ';' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_09.byte),
            '\'' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_10.byte),
            '#' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_11.byte),

            '\\' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_00.byte),
            'z' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_01.byte),
            'x' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_02.byte),
            'c' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_03.byte),
            'v' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_04.byte),
            'b' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_05.byte),
            'n' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_06.byte),
            'm' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_07.byte),
            ',' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_08.byte),
            '.' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_09.byte),
            '/' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_10.byte),

            // ---- Shift ----

            '¬' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_00.byte),
            '!' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_01.byte),
            '"' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_02.byte),
            '£' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_03.byte),
            '$' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_04.byte),
            '%' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_05.byte),
            '^' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_06.byte),
            '&' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_07.byte),
            '*' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_08.byte),
            '(' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_09.byte),
            ')' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_10.byte),
            '_' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_11.byte),
            '+' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_12.byte),

            'Q' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_00.byte),
            'W' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_01.byte),
            'E' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_02.byte),
            'R' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_03.byte),
            'T' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_04.byte),
            'Y' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_05.byte),
            'U' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_06.byte),
            'I' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_07.byte),
            'O' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_08.byte),
            'P' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_09.byte),
            '{' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_10.byte),
            '}' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_11.byte),

            'A' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_00.byte),
            'S' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_01.byte),
            'D' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_02.byte),
            'F' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_03.byte),
            'G' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_04.byte),
            'H' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_05.byte),
            'J' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_06.byte),
            'K' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_07.byte),
            'L' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_08.byte),
            ':' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_09.byte),
            '@' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_10.byte),
            '~' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_11.byte),

            '|' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_00.byte),
            'Z' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_01.byte),
            'X' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_02.byte),
            'C' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_03.byte),
            'V' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_04.byte),
            'B' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_05.byte),
            'N' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_06.byte),
            'M' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_07.byte),
            '<' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_08.byte),
            '>' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_09.byte),
            '?' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_10.byte),

            // ---- Alt Gr ----

            '¦' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_00.byte),
            '€' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_04.byte),

            'ẃ' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_01.byte),
            'é' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_02.byte),
            'ý' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_05.byte),
            'ú' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_06.byte),
            'í' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_07.byte),
            'ó' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_08.byte),

            'á' to byteArrayOf(0x40, KeyboardKey.ROW_3_KEY_00.byte),

            'ç' to byteArrayOf(0x40, KeyboardKey.ROW_4_KEY_03.byte),

            // ---- Shift + Alt Gr ----

            'Ẃ' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_01.byte),
            'É' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_02.byte),
            'Ý' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_05.byte),
            'Ú' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_06.byte),
            'Í' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_07.byte),
            'Ó' to byteArrayOf(0x42, KeyboardKey.ROW_2_KEY_08.byte),

            'Á' to byteArrayOf(0x42, KeyboardKey.ROW_3_KEY_00.byte),

            'Ç' to byteArrayOf(0x42, KeyboardKey.ROW_4_KEY_03.byte)
        )
    }

    protected override val extraInputs: Map<Char, ByteArray> by lazy {
        mapOf(
            '¹' to (keyboardInputs['1'] ?: REMOTE_INPUT_NONE),
            '²' to (keyboardInputs['2'] ?: REMOTE_INPUT_NONE),
            '³' to (keyboardInputs['3'] ?: REMOTE_INPUT_NONE),
            '«' to (keyboardInputs['"'] ?: REMOTE_INPUT_NONE),
            '»' to (keyboardInputs['"'] ?: REMOTE_INPUT_NONE),
            'µ' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            '¥' to (keyboardInputs['Y'] ?: REMOTE_INPUT_NONE),
            '¢' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),

            'À' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Â' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ã' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ä' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Å' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ą' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Æ' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Č' to (keyboardInputs['C'] ?: REMOTE_INPUT_NONE),
            'Ć' to (keyboardInputs['C'] ?: REMOTE_INPUT_NONE),
            'È' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ê' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ë' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ě' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ę' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ì' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Î' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Ï' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Ł' to (keyboardInputs['L'] ?: REMOTE_INPUT_NONE),
            'Ñ' to (keyboardInputs['N'] ?: REMOTE_INPUT_NONE),
            'Ń' to (keyboardInputs['N'] ?: REMOTE_INPUT_NONE),
            'Ò' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ô' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Õ' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ö' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            '×' to (keyboardInputs['x'] ?: REMOTE_INPUT_NONE),
            'Ø' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ř' to (keyboardInputs['R'] ?: REMOTE_INPUT_NONE),
            'Š' to (keyboardInputs['S'] ?: REMOTE_INPUT_NONE),
            'Ś' to (keyboardInputs['S'] ?: REMOTE_INPUT_NONE),
            'Ù' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Û' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Ü' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Ý' to (keyboardInputs['Y'] ?: REMOTE_INPUT_NONE),
            'Ž' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),
            'Ż' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),
            'Ź' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),

            'à' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'â' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ã' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ä' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'å' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ą' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'æ' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'č' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),
            'ć' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),
            'è' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ê' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ë' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ě' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ę' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ì' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'î' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'ï' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'ł' to (keyboardInputs['l'] ?: REMOTE_INPUT_NONE),
            'ñ' to (keyboardInputs['n'] ?: REMOTE_INPUT_NONE),
            'ń' to (keyboardInputs['n'] ?: REMOTE_INPUT_NONE),
            'ò' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ô' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'õ' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ö' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            '÷' to (keyboardInputs['/'] ?: REMOTE_INPUT_NONE),
            'ø' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ř' to (keyboardInputs['r'] ?: REMOTE_INPUT_NONE),
            'š' to (keyboardInputs['s'] ?: REMOTE_INPUT_NONE),
            'ś' to (keyboardInputs['s'] ?: REMOTE_INPUT_NONE),
            'ù' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'û' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'ü' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'ý' to (keyboardInputs['y'] ?: REMOTE_INPUT_NONE),
            'ÿ' to (keyboardInputs['y'] ?: REMOTE_INPUT_NONE),
            'ž' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE),
            'ż' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE),
            'ź' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE)
        )
    }
}