package com.atharok.btremote.domain.entities.remoteInput.keyboard.virtualKeyboard

import com.atharok.btremote.common.utils.REMOTE_INPUT_NONE
import com.atharok.btremote.domain.entities.remoteInput.keyboard.KeyboardKey

class GreekVirtualKeyboardLayout: VirtualKeyboardLayout() {

    protected override val keyboardInputs: Map<Char, ByteArray> by lazy {
        mapOf(
            ' ' to KEYBOARD_KEY_SPACE_BAR,

            '`' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_00.byte),
            '1' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_01.byte),
            '2' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_02.byte),
            '3' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_03.byte),
            '4' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_04.byte),
            '5' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_05.byte),
            '6' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_06.byte),
            '7' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_07.byte),
            '8' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_08.byte),
            '9' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_09.byte),
            '0' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_10.byte),
            '-' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_11.byte),
            '=' to byteArrayOf(0x00, KeyboardKey.ROW_1_KEY_12.byte),

            ';' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_00.byte),
            'ς' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_01.byte),
            'ε' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_02.byte),
            'ρ' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_03.byte),
            'τ' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_04.byte),
            'υ' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_05.byte),
            'θ' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_06.byte),
            'ι' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_07.byte),
            'ο' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_08.byte),
            'π' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_09.byte),
            '[' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_10.byte),
            ']' to byteArrayOf(0x00, KeyboardKey.ROW_2_KEY_11.byte),

            'α' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_00.byte),
            'σ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_01.byte),
            'δ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_02.byte),
            'φ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_03.byte),
            'γ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_04.byte),
            'η' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_05.byte),
            'ξ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_06.byte),
            'κ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_07.byte),
            'λ' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_08.byte),
            '´' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_09.byte),
            '\'' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_10.byte),
            '\\' to byteArrayOf(0x00, KeyboardKey.ROW_3_KEY_11.byte),

            '<' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_00.byte),
            'ζ' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_01.byte),
            'χ' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_02.byte),
            'ψ' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_03.byte),
            'ω' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_04.byte),
            'β' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_05.byte),
            'ν' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_06.byte),
            'μ' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_07.byte),
            ',' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_08.byte),
            '.' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_09.byte),
            '/' to byteArrayOf(0x00, KeyboardKey.ROW_4_KEY_10.byte),

            // ---- Shift ----

            '~' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_00.byte),
            '!' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_01.byte),
            '@' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_02.byte),
            '#' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_03.byte),
            '$' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_04.byte),
            '%' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_05.byte),
            '^' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_06.byte),
            '&' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_07.byte),
            '*' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_08.byte),
            '(' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_09.byte),
            ')' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_10.byte),
            '_' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_11.byte),
            '+' to byteArrayOf(0x02, KeyboardKey.ROW_1_KEY_12.byte),

            ':' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_00.byte),
            '΅' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_01.byte),
            'Ε' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_02.byte),
            'Ρ' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_03.byte),
            'Τ' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_04.byte),
            'Υ' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_05.byte),
            'Θ' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_06.byte),
            'Ι' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_07.byte),
            'Ο' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_08.byte),
            'Π' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_09.byte),
            '{' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_10.byte),
            '}' to byteArrayOf(0x02, KeyboardKey.ROW_2_KEY_11.byte),

            'Α' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_00.byte),
            'Σ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_01.byte),
            'Δ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_02.byte),
            'Φ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_03.byte),
            'Γ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_04.byte),
            'Η' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_05.byte),
            'Ξ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_06.byte),
            'Κ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_07.byte),
            'Λ' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_08.byte),
            '¨' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_09.byte),
            '"' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_10.byte),
            '|' to byteArrayOf(0x02, KeyboardKey.ROW_3_KEY_11.byte),

            '>' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_00.byte),
            'Ζ' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_01.byte),
            'Χ' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_02.byte),
            'Ψ' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_03.byte),
            'Ω' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_04.byte),
            'Β' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_05.byte),
            'Ν' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_06.byte),
            'Μ' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_07.byte),
            '?' to byteArrayOf(0x02, KeyboardKey.ROW_4_KEY_10.byte),

            // ---- Alt Gr ----

            '²' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_02.byte),
            '³' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_03.byte),
            '£' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_04.byte),
            '§' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_05.byte),
            '¶' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_06.byte),
            '¤' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_08.byte),
            '¦' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_09.byte),
            '°' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_10.byte),
            '±' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_11.byte),
            '½' to byteArrayOf(0x40, KeyboardKey.ROW_1_KEY_12.byte),

            '€' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_02.byte),
            '®' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_03.byte),
            '¥' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_05.byte),
            '«' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_10.byte),
            '»' to byteArrayOf(0x40, KeyboardKey.ROW_2_KEY_11.byte),

            '¬' to byteArrayOf(0x40, KeyboardKey.ROW_3_KEY_11.byte),

            '©' to byteArrayOf(0x40, KeyboardKey.ROW_4_KEY_03.byte),

            // ---- Shift + Alt Gr ----

        )
    }

    protected override val extraInputs: Map<Char, ByteArray> by lazy {
        mapOf(
            '¹' to (keyboardInputs['1'] ?: REMOTE_INPUT_NONE),
            'µ' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            '¢' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),

            'À' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Á' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Â' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ã' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ä' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Å' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ą' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Æ' to (keyboardInputs['A'] ?: REMOTE_INPUT_NONE),
            'Ç' to (keyboardInputs['C'] ?: REMOTE_INPUT_NONE),
            'Č' to (keyboardInputs['C'] ?: REMOTE_INPUT_NONE),
            'Ć' to (keyboardInputs['C'] ?: REMOTE_INPUT_NONE),
            'È' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'É' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ê' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ë' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ě' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ę' to (keyboardInputs['E'] ?: REMOTE_INPUT_NONE),
            'Ì' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Í' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Î' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Ï' to (keyboardInputs['I'] ?: REMOTE_INPUT_NONE),
            'Ł' to (keyboardInputs['L'] ?: REMOTE_INPUT_NONE),
            'Ñ' to (keyboardInputs['N'] ?: REMOTE_INPUT_NONE),
            'Ń' to (keyboardInputs['N'] ?: REMOTE_INPUT_NONE),
            'Ò' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ó' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ô' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Õ' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ö' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            '×' to (keyboardInputs['x'] ?: REMOTE_INPUT_NONE),
            'Ø' to (keyboardInputs['O'] ?: REMOTE_INPUT_NONE),
            'Ř' to (keyboardInputs['R'] ?: REMOTE_INPUT_NONE),
            'Š' to (keyboardInputs['S'] ?: REMOTE_INPUT_NONE),
            'Ś' to (keyboardInputs['S'] ?: REMOTE_INPUT_NONE),
            'Ù' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Ú' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Û' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Ü' to (keyboardInputs['U'] ?: REMOTE_INPUT_NONE),
            'Ẃ' to (keyboardInputs['W'] ?: REMOTE_INPUT_NONE),
            'Ý' to (keyboardInputs['Y'] ?: REMOTE_INPUT_NONE),
            'Ž' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),
            'Ż' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),
            'Ź' to (keyboardInputs['Z'] ?: REMOTE_INPUT_NONE),

            'à' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'á' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'â' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ã' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ä' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'å' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ą' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'æ' to (keyboardInputs['a'] ?: REMOTE_INPUT_NONE),
            'ç' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),
            'č' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),
            'ć' to (keyboardInputs['c'] ?: REMOTE_INPUT_NONE),
            'è' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'é' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ê' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ë' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ě' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ę' to (keyboardInputs['e'] ?: REMOTE_INPUT_NONE),
            'ì' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'í' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'î' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'ï' to (keyboardInputs['i'] ?: REMOTE_INPUT_NONE),
            'ł' to (keyboardInputs['l'] ?: REMOTE_INPUT_NONE),
            'ñ' to (keyboardInputs['n'] ?: REMOTE_INPUT_NONE),
            'ń' to (keyboardInputs['n'] ?: REMOTE_INPUT_NONE),
            'ò' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ó' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ô' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'õ' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ö' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            '÷' to (keyboardInputs['/'] ?: REMOTE_INPUT_NONE),
            'ø' to (keyboardInputs['o'] ?: REMOTE_INPUT_NONE),
            'ř' to (keyboardInputs['r'] ?: REMOTE_INPUT_NONE),
            'š' to (keyboardInputs['s'] ?: REMOTE_INPUT_NONE),
            'ś' to (keyboardInputs['s'] ?: REMOTE_INPUT_NONE),
            'ù' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'ú' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'û' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'ü' to (keyboardInputs['u'] ?: REMOTE_INPUT_NONE),
            'ẃ' to (keyboardInputs['w'] ?: REMOTE_INPUT_NONE),
            'ý' to (keyboardInputs['y'] ?: REMOTE_INPUT_NONE),
            'ÿ' to (keyboardInputs['y'] ?: REMOTE_INPUT_NONE),
            'ž' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE),
            'ż' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE),
            'ź' to (keyboardInputs['z'] ?: REMOTE_INPUT_NONE)
        )
    }
}