<div align="center"><img src="assets/icon_round.png" width="192" /></div>

## <div align="center">BT Remote</div>

<div align="center"><h4>An Android app that turns your smartphone into a Bluetooth remote for Android TV.</h4></div>

<div align="center">
    <a href="https://f-droid.org/packages/com.atharok.btremote/" target="_blank"><img src="assets/get-it-on-f-droid-badge.png" alt="Get it on F-Droid" height="90"></a>
    <a href="https://play.google.com/store/apps/details?id=com.atharok.btremote.gplay" target="_blank"><img src="assets/get-it-on-google-play-badge.png" alt="Get it on Google Play" height="90"></a>
</div>

You may also download the APK directly from [GitLab](https://gitlab.com/Atharok/BtRemote/-/releases).

[![License: GPLv3](https://img.shields.io/badge/License-GPLv3-blue)](https://www.gnu.org/licenses/gpl-3.0)

## Description

Turn your smartphone into a Bluetooth remote control to easily navigate and interact with your Android TV.

Features:

- Wireless control via Bluetooth connection.
- Includes all necessary buttons for remote control of your device.
- Support for integrated mouse and keyboard.
- No additional app installation required on your Android TV device thanks to HID protocol.
- Modern and responsive user interface.
- Developed with Kotlin, Jetpack Compose, and Material 3.
- Privacy-focused with no data collection (internet permission disabled).
- No advertisements.
- Open source.

## Screenshots

<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/01.png" width="192" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/02.png" width="192" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/04.png" width="192" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/05.png" width="192" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/07.png" width="384" />
<img src="fastlane/metadata/android/en-US/images/phoneScreenshots/08.png" width="384" />

## Donate

If you like BT Remote, you can support me via [Liberapay](https://liberapay.com/Atharok/donate) or [Ko-fi](https://ko-fi.com/atharok).

[![Donate](assets/liberapay-badge.png)](https://liberapay.com/Atharok/donate)
[![Donate](assets/ko-fi-badge.png)](https://ko-fi.com/atharok)

## Contribution

If you want to translate the app, please use the [Weblate on Codeberg](https://translate.codeberg.org/projects/btremote/) or submit a merge request on GitLab.
If you have any questions regarding contributions or translations, feel free to open an issue or contact me by [e-mail](mailto:atharok@duck.com).

## Checksums

To verify the authenticity and integrity of the APK, compare its signature against the certificate fingerprints shown below:

```
SHA-256: e6cf1629d462a3686aa4ba2d37e02777257fd0a3bbe5540d8c70f80e12d111cd
SHA-1: 8d66ed4b5d105f7fecce6ebd07dddc569cab29b9
MD5: ea0d7434b89110e49386132bb005bb6b
```

Notes about third-party distribution platforms:

- Google Play: The app is re-signed by Google with its own key, so the the certificate fingerprints will differ.
- F-Droid: The build is reproducible, so the certificate fingerprints listed above also apply to the release from F-Droid.

## Licences

The code is licensed under the [GPLv3](https://www.gnu.org/licenses/gpl-3.0).

Dependencies:

- [Core KTX](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Activity Compose](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Compose BOM](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Compose UI](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Compose UI Graphics](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Compose Material 3](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Compose Material Icons Extended](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Lifecycle Runtime Compose](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Navigation Compose](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [DataStore Preferences](https://github.com/androidx/androidx) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Koin AndroidX Compose](https://github.com/InsertKoinIO/koin) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
- [Kotlin Serialization](https://github.com/Kotlin/kotlinx.serialization) is licensed under [Apache License 2.0](https://www.apache.org/licenses/LICENSE-2.0)
