/*
 * Barcode Scanner
 * Copyright (C) 2021  Atharok
 *
 * This file is part of Barcode Scanner.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.atharok.barcodescanner.domain.entity.barcode

import com.atharok.barcodescanner.R

enum class CountriesEnum(val drawableResource: Int, val stringResource: Int) {
    USA(R.drawable.flag_us, R.string.country_usa),
    CANADA(R.drawable.flag_ca, R.string.country_ca),
    FRANCE(R.drawable.flag_fr, R.string.country_fr),
    BULGARIA(R.drawable.flag_bg, R.string.country_bg),
    SLOVENIA(R.drawable.flag_si, R.string.country_si),
    CROATIA(R.drawable.flag_hr, R.string.country_hr),
    BOSNIA(R.drawable.flag_ba, R.string.country_ba),
    MONTENEGRO(R.drawable.flag_me, R.string.country_me),
    KOSOVO(R.drawable.flag_xk, R.string.country_kosovo),
    GERMANY(R.drawable.flag_de, R.string.country_de),
    JAPAN(R.drawable.flag_jp, R.string.country_jp),
    RUSSIA(R.drawable.flag_ru, R.string.country_ru),
    KYRGYZSTAN(R.drawable.flag_kg, R.string.country_kg),
    TAIWAN(R.drawable.flag_tw, R.string.country_tw),
    ESTONIA(R.drawable.flag_ee, R.string.country_ee),
    LATVIA(R.drawable.flag_lv, R.string.country_lv),
    AZERBAIJAN(R.drawable.flag_az, R.string.country_az),
    LITHUANIA(R.drawable.flag_lt, R.string.country_lt),
    UZBEKISTAN(R.drawable.flag_uz, R.string.country_uz),
    SRI_LANKA(R.drawable.flag_lk, R.string.country_lk),
    PHILIPPINES(R.drawable.flag_ph, R.string.country_ph),
    BELARUS(R.drawable.flag_by, R.string.country_by),
    UKRAINE(R.drawable.flag_ua, R.string.country_ua),
    TURKMENISTAN(R.drawable.flag_tm, R.string.country_tm),
    MOLDOVA(R.drawable.flag_md, R.string.country_md),
    ARMENIA(R.drawable.flag_am, R.string.country_am),
    GEORGIA(R.drawable.flag_ge, R.string.country_ge),
    KAZAKHSTAN(R.drawable.flag_kz, R.string.country_kz),
    TAJIKISTAN(R.drawable.flag_tj, R.string.country_tj),
    HONG_KONG(R.drawable.flag_hk, R.string.country_hk),
    UNITED_KINGDOM(R.drawable.flag_gb, R.string.country_gb),
    GREECE(R.drawable.flag_gr, R.string.country_gr),
    LEBANON(R.drawable.flag_lb, R.string.country_lb),
    CYPRUS(R.drawable.flag_cy, R.string.country_cy),
    ALBANIA(R.drawable.flag_al, R.string.country_al),
    MACEDONIA(R.drawable.flag_mk, R.string.country_mk),
    MALTA(R.drawable.flag_mt, R.string.country_mt),
    IRELAND(R.drawable.flag_ie, R.string.country_ie),
    BELGIUM(R.drawable.flag_be, R.string.country_be),
    LUXEMBOURG(R.drawable.flag_lu, R.string.country_lu),
    PORTUGAL(R.drawable.flag_pt, R.string.country_pt),
    ISLAND(R.drawable.flag_is, R.string.country_is),
    DENMARK(R.drawable.flag_dk, R.string.country_dk),
    POLAND(R.drawable.flag_pl, R.string.country_pl),
    ROMANIA(R.drawable.flag_ro, R.string.country_ro),
    HUNGARY(R.drawable.flag_hu, R.string.country_hu),
    SOUTH_AFRICA(R.drawable.flag_za, R.string.country_za),
    BENIN(R.drawable.flag_bj, R.string.country_bj),
    GHANA(R.drawable.flag_gh, R.string.country_gh),
    SENEGAL(R.drawable.flag_sn, R.string.country_sn),
    BAHRAIN(R.drawable.flag_bh, R.string.country_bh),
    MAURITIUS(R.drawable.flag_mu, R.string.country_mu),
    MOROCCO(R.drawable.flag_ma, R.string.country_ma),
    ALGERIA(R.drawable.flag_dz, R.string.country_dz),
    NIGERIA(R.drawable.flag_ng, R.string.country_ng),
    KENYA(R.drawable.flag_ke, R.string.country_ke),
    CAMEROON(R.drawable.flag_cm, R.string.country_cm),
    COTE_D_IVOIRE(R.drawable.flag_ci, R.string.country_ci),
    TUNISIA(R.drawable.flag_tn, R.string.country_tn),
    TANZANIA(R.drawable.flag_tz, R.string.country_tz),
    SYRIA(R.drawable.flag_sy, R.string.country_sy),
    EGYPT(R.drawable.flag_eg, R.string.country_eg),
    BRUNEI(R.drawable.flag_bn, R.string.country_bn),
    LIBYA(R.drawable.flag_ly, R.string.country_ly),
    JORDAN(R.drawable.flag_jo, R.string.country_jo),
    IRAN(R.drawable.flag_ir, R.string.country_ir),
    KUWAIT(R.drawable.flag_kw, R.string.country_kw),
    SAUDI_ARABIA(R.drawable.flag_sa, R.string.country_sa),
    UNITED_ARAB_EMIRATES(R.drawable.flag_ae, R.string.country_ae),
    QATAR(R.drawable.flag_qa, R.string.country_qa),
    FINLAND(R.drawable.flag_fi, R.string.country_fi),
    CHINA(R.drawable.flag_cn, R.string.country_cn),
    NORWAY(R.drawable.flag_no, R.string.country_no),
    ISRAEL(R.drawable.flag_il, R.string.country_il),
    SWEDEN(R.drawable.flag_se, R.string.country_se),
    GUATEMALA(R.drawable.flag_gt, R.string.country_gt),
    EL_SALVADOR(R.drawable.flag_sv, R.string.country_sv),
    HONDURAS(R.drawable.flag_hn, R.string.country_hn),
    NICARAGUA(R.drawable.flag_ni, R.string.country_ni),
    COSTA_RICA(R.drawable.flag_cr, R.string.country_cr),
    PANAMA(R.drawable.flag_pa, R.string.country_pa),
    DOMINICAN_REPUBLIC(R.drawable.flag_do, R.string.country_do),
    MEXICO(R.drawable.flag_mx, R.string.country_mx),
    VENEZUELA(R.drawable.flag_ve, R.string.country_ve),
    SWITZERLAND(R.drawable.flag_ch, R.string.country_ch),
    LIECHTENSTEIN(R.drawable.flag_li, R.string.country_li),
    COLOMBIA(R.drawable.flag_co, R.string.country_co),
    URUGUAY(R.drawable.flag_uy, R.string.country_uy),
    PERU(R.drawable.flag_pe, R.string.country_pe),
    BOLIVIA(R.drawable.flag_bo, R.string.country_bo),
    ARGENTINA(R.drawable.flag_ar, R.string.country_ar),
    CHILE(R.drawable.flag_cl, R.string.country_cl),
    PARAGUAY(R.drawable.flag_py, R.string.country_py),
    ECUADOR(R.drawable.flag_ec, R.string.country_ec),
    BRAZIL(R.drawable.flag_br, R.string.country_br),
    ITALY(R.drawable.flag_it, R.string.country_it),
    SPAIN(R.drawable.flag_es, R.string.country_es),
    CUBA(R.drawable.flag_cu, R.string.country_cu),
    SLOVAKIA(R.drawable.flag_sk, R.string.country_sk),
    CZECH_REPUBLIC(R.drawable.flag_cz, R.string.country_cz),
    SERBIA(R.drawable.flag_rs, R.string.country_rs),
    MONGOLIA(R.drawable.flag_mn, R.string.country_mn),
    NORTH_KOREA(R.drawable.flag_kp, R.string.country_kp),
    TURKEY(R.drawable.flag_tr, R.string.country_tr),
    NETHERLANDS(R.drawable.flag_nl, R.string.country_nl),
    SOUTH_KOREA(R.drawable.flag_kr, R.string.country_kr),
    MYANMAR(R.drawable.flag_mm, R.string.country_mm),
    CAMBODIA(R.drawable.flag_kh, R.string.country_kh),
    THAILAND(R.drawable.flag_th, R.string.country_th),
    SINGAPORE(R.drawable.flag_sg, R.string.country_sg),
    INDIA(R.drawable.flag_in, R.string.country_in),
    VIETNAM(R.drawable.flag_vn, R.string.country_vn),
    PAKISTAN(R.drawable.flag_pk, R.string.country_pk),
    INDONESIA(R.drawable.flag_id, R.string.country_id),
    AUSTRIA(R.drawable.flag_at, R.string.country_at),
    AUSTRALIA(R.drawable.flag_au, R.string.country_au),
    NEW_ZEALAND(R.drawable.flag_nz, R.string.country_nz),
    MALAYSIA(R.drawable.flag_my, R.string.country_my),
    MACAU(R.drawable.flag_mo, R.string.country_mo),

    /*ISSN(R.drawable.ic_book_24, R.string.issn_label),
    ISBN(R.drawable.ic_book_24, R.string.isbn_label),
    REFUND_RECEIPTS(R.drawable.ic_book_24, R.string.refund_receipts_label),
    COMMON_CURRENCY_COUPONS(R.drawable.ic_book_24, R.string.common_currency_coupons_label),
    COUPONS(R.drawable.ic_book_24, R.string.coupons_label)*/
}