/*
 * Barcode Scanner
 * Copyright (C) 2021  Atharok
 *
 * This file is part of Barcode Scanner.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

package com.atharok.barcodescanner.data.model.openFoodFactsDependenciesResponse.commons

import androidx.annotation.Keep
import com.google.gson.annotations.Expose
import com.google.gson.annotations.SerializedName
import java.util.Locale

@Keep
data class LanguageValue(
    @SerializedName("ka")
    @Expose
    val ka: String? = null,

    @SerializedName("dz")
    @Expose
    val dz: String? = null,

    @SerializedName("rm")
    @Expose
    val rm: String? = null,

    @SerializedName("as")
    @Expose
    val as_: String? = null,

    @SerializedName("ba")
    @Expose
    val ba: String? = null,

    @SerializedName("hi")
    @Expose
    val hi: String? = null,

    @SerializedName("yi")
    @Expose
    val yi: String? = null,

    @SerializedName("cs")
    @Expose
    val cs: String? = null,

    @SerializedName("sk")
    @Expose
    val sk: String? = null,

    @SerializedName("os")
    @Expose
    val os: String? = null,

    @SerializedName("li")
    @Expose
    val li: String? = null,

    @SerializedName("gv")
    @Expose
    val gv: String? = null,

    @SerializedName("yo")
    @Expose
    val yo: String? = null,

    @SerializedName("sh")
    @Expose
    val sh: String? = null,

    @SerializedName("sm")
    @Expose
    val sm: String? = null,

    @SerializedName("ta")
    @Expose
    val ta: String? = null,

    @SerializedName("ms")
    @Expose
    val ms: String? = null,

    @SerializedName("te")
    @Expose
    val te: String? = null,

    @SerializedName("lo")
    @Expose
    val lo: String? = null,

    @SerializedName("ay")
    @Expose
    val ay: String? = null,

    @SerializedName("th")
    @Expose
    val th: String? = null,

    @SerializedName("ca")
    @Expose
    val ca: String? = null,

    @SerializedName("am")
    @Expose
    val am: String? = null,

    @SerializedName("eo")
    @Expose
    val eo: String? = null,

    @SerializedName("jv")
    @Expose
    val jv: String? = null,

    @SerializedName("bo")
    @Expose
    val bo: String? = null,

    @SerializedName("st")
    @Expose
    val st: String? = null,

    @SerializedName("ar")
    @Expose
    val ar: String? = null,

    @SerializedName("pl")
    @Expose
    val pl: String? = null,

    @SerializedName("be")
    @Expose
    val be: String? = null,

    @SerializedName("ru")
    @Expose
    val ru: String? = null,

    @SerializedName("bm")
    @Expose
    val bm: String? = null,

    @SerializedName("ln")
    @Expose
    val ln: String? = null,

    @SerializedName("ha")
    @Expose
    val ha: String? = null,

    @SerializedName("tl")
    @Expose
    val tl: String? = null,

    @SerializedName("de")
    @Expose
    val de: String? = null,

    @SerializedName("ro")
    @Expose
    val ro: String? = null,

    @SerializedName("gl")
    @Expose
    val gl: String? = null,

    @SerializedName("ia")
    @Expose
    val ia: String? = null,

    @SerializedName("eu")
    @Expose
    val eu: String? = null,

    @SerializedName("qu")
    @Expose
    val qu: String? = null,

    @SerializedName("az")
    @Expose
    val az: String? = null,

    @SerializedName("sc")
    @Expose
    val sc: String? = null,

    @SerializedName("bn")
    @Expose
    val bn: String? = null,

    @SerializedName("co")
    @Expose
    val co: String? = null,

    @SerializedName("gu")
    @Expose
    val gu: String? = null,

    @SerializedName("gd")
    @Expose
    val gd: String? = null,

    @SerializedName("sq")
    @Expose
    val sq: String? = null,

    @SerializedName("bs")
    @Expose
    val bs: String? = null,

    @SerializedName("fr")
    @Expose
    val fr: String? = null,

    @SerializedName("fa")
    @Expose
    val fa: String? = null,

    @SerializedName("zu")
    @Expose
    val zu: String? = null,

    @SerializedName("si")
    @Expose
    val si: String? = null,

    @SerializedName("ee")
    @Expose
    val ee: String? = null,

    @SerializedName("my")
    @Expose
    val my: String? = null,

    @SerializedName("ga")
    @Expose
    val ga: String? = null,

    @SerializedName("fo")
    @Expose
    val fo: String? = null,

    @SerializedName("ss")
    @Expose
    val ss: String? = null,

    @SerializedName("vo")
    @Expose
    val vo: String? = null,

    @SerializedName("hr")
    @Expose
    val hr: String? = null,

    @SerializedName("sa")
    @Expose
    val sa: String? = null,

    @SerializedName("tg")
    @Expose
    val tg: String? = null,

    @SerializedName("sr")
    @Expose
    val sr: String? = null,

    @SerializedName("vi")
    @Expose
    val vi: String? = null,

    @SerializedName("sl")
    @Expose
    val sl: String? = null,

    @SerializedName("mt")
    @Expose
    val mt: String? = null,

    @SerializedName("cv")
    @Expose
    val cv: String? = null,

    @SerializedName("mi")
    @Expose
    val mi: String? = null,

    @SerializedName("tk")
    @Expose
    val tk: String? = null,

    @SerializedName("kg")
    @Expose
    val kg: String? = null,

    @SerializedName("na")
    @Expose
    val na: String? = null,

    @SerializedName("nl")
    @Expose
    val nl: String? = null,

    @SerializedName("mr")
    @Expose
    val mr: String? = null,

    @SerializedName("gn")
    @Expose
    val gn: String? = null,

    @SerializedName("mn")
    @Expose
    val mn: String? = null,

    @SerializedName("lv")
    @Expose
    val lv: String? = null,

    @SerializedName("zh")
    @Expose
    val zh: String? = null,

    @SerializedName("ps")
    @Expose
    val ps: String? = null,

    @SerializedName("rw")
    @Expose
    val rw: String? = null,

    @SerializedName("it")
    @Expose
    val it: String? = null,

    @SerializedName("kn")
    @Expose
    val kn: String? = null,

    @SerializedName("oc")
    @Expose
    val oc: String? = null,

    @SerializedName("pt")
    @Expose
    val pt: String? = null,

    @SerializedName("la")
    @Expose
    val la: String? = null,

    @SerializedName("hu")
    @Expose
    val hu: String? = null,

    @SerializedName("br")
    @Expose
    val br: String? = null,

    @SerializedName("sw")
    @Expose
    val sw: String? = null,

    @SerializedName("hy")
    @Expose
    val hy: String? = null,

    @SerializedName("ug")
    @Expose
    val ug: String? = null,

    @SerializedName("ie")
    @Expose
    val ie: String? = null,

    @SerializedName("kk")
    @Expose
    val kk: String? = null,

    @SerializedName("pa")
    @Expose
    val pa: String? = null,

    @SerializedName("se")
    @Expose
    val se: String? = null,

    @SerializedName("ht")
    @Expose
    val ht: String? = null,

    @SerializedName("ff")
    @Expose
    val ff: String? = null,

    @SerializedName("ty")
    @Expose
    val ty: String? = null,

    @SerializedName("tt")
    @Expose
    val tt: String? = null,

    @SerializedName("ku")
    @Expose
    val ku: String? = null,

    @SerializedName("cy")
    @Expose
    val cy: String? = null,

    @SerializedName("tr")
    @Expose
    val tr: String? = null,

    @SerializedName("uz")
    @Expose
    val uz: String? = null,

    @SerializedName("nn")
    @Expose
    val nn: String? = null,

    @SerializedName("es")
    @Expose
    val es: String? = null,

    @SerializedName("kl")
    @Expose
    val kl: String? = null,

    @SerializedName("he")
    @Expose
    val he: String? = null,

    @SerializedName("id")
    @Expose
    val id: String? = null,

    @SerializedName("el")
    @Expose
    val el: String? = null,

    @SerializedName("da")
    @Expose
    val da: String? = null,

    @SerializedName("ml")
    @Expose
    val ml: String? = null,

    @SerializedName("uk")
    @Expose
    val uk: String? = null,

    @SerializedName("cu")
    @Expose
    val cu: String? = null,

    @SerializedName("kw")
    @Expose
    val kw: String? = null,

    @SerializedName("bg")
    @Expose
    val bg: String? = null,

    @SerializedName("su")
    @Expose
    val su: String? = null,

    @SerializedName("an")
    @Expose
    val an: String? = null,

    @SerializedName("bi")
    @Expose
    val bi: String? = null,

    @SerializedName("fy")
    @Expose
    val fy: String? = null,

    @SerializedName("lb")
    @Expose
    val lb: String? = null,

    @SerializedName("or")
    @Expose
    val or: String? = null,

    @SerializedName("wa")
    @Expose
    val wa: String? = null,

    @SerializedName("mg")
    @Expose
    val mg: String? = null,

    @SerializedName("is")
    @Expose
    val is_: String? = null,

    @SerializedName("et")
    @Expose
    val et: String? = null,

    @SerializedName("lt")
    @Expose
    val lt: String? = null,

    @SerializedName("af")
    @Expose
    val af: String? = null,

    @SerializedName("wo")
    @Expose
    val wo: String? = null,

    @SerializedName("ja")
    @Expose
    val ja: String? = null,

    @SerializedName("ce")
    @Expose
    val ce: String? = null,

    @SerializedName("rn")
    @Expose
    val rn: String? = null,

    @SerializedName("ak")
    @Expose
    val ak: String? = null,

    @SerializedName("io")
    @Expose
    val io: String? = null,

    @SerializedName("ky")
    @Expose
    val ky: String? = null,

    @SerializedName("km")
    @Expose
    val km: String? = null,

    @SerializedName("ur")
    @Expose
    val ur: String? = null,

    @SerializedName("sv")
    @Expose
    val sv: String? = null,

    @SerializedName("en")
    @Expose
    val en: String? = null,

    @SerializedName("fi")
    @Expose
    val fi: String? = null,

    @SerializedName("za")
    @Expose
    val za: String? = null,

    @SerializedName("nv")
    @Expose
    val nv: String? = null,

    @SerializedName("kv")
    @Expose
    val kv: String? = null,

    @SerializedName("ne")
    @Expose
    val ne: String? = null,

    @SerializedName("so")
    @Expose
    val so: String? = null,

    @SerializedName("dv")
    @Expose
    val dv: String? = null,

    @SerializedName("mk")
    @Expose
    val mk: String? = null,

    @SerializedName("nb")
    @Expose
    val nb: String? = null,

    @SerializedName("ko")
    @Expose
    val ko: String? = null
) {


    /**
     * Dans les réponses pour obtenir des informations sur les Additifs, Allergens, Traces et Countries
     * sur OpenFoodFacts, OpenBeautyFacts et OpenPetFoodFacts, il est possible d'obtenir l'information dans
     * différentes langues.
     * Cette fonction permet de récupérer le texte dans la langue du système.
     */
    fun toLocaleLanguage(): String? {
        val locale = Locale.getDefault()

        return when(locale.language){
            "en" -> en ?: fr
            "fr" -> fr ?: en
            "de" -> de ?: en ?: fr
            "es" -> es ?: en ?: fr
            "it" -> it ?: en ?: fr
            "pt" -> pt ?: en ?: fr
            "is" -> is_ ?: en ?: fr
            "pl" -> pl ?: en ?: fr
            "el" -> el ?: en ?: fr
            "da" -> da ?: en ?: fr
            "hu" -> hu ?: en ?: fr
            "bg" -> bg ?: en ?: fr
            "fa" -> fa ?: en ?: fr
            "id" -> id ?: en ?: fr
            "bs" -> bs ?: en ?: fr
            "hr" -> hr ?: en ?: fr
            "zh" -> zh ?: en ?: fr
            "sl" -> sl ?: en ?: fr
            "lv" -> lv ?: en ?: fr
            "ky" -> ky ?: en ?: fr
            "ga" -> ga ?: en ?: fr
            "lt" -> lt ?: en ?: fr
            "nb" -> nb ?: en ?: fr
            "eo" -> eo ?: en ?: fr
            "sr" -> sr ?: en ?: fr
            "et" -> et ?: en ?: fr
            "mt" -> mt ?: en ?: fr
            "ru" -> ru ?: en ?: fr
            "sh" -> sh ?: en ?: fr
            "ca" -> ca ?: en ?: fr
            "uk" -> uk ?: en ?: fr
            "he" -> he ?: en ?: fr
            "fi" -> fi ?: en ?: fr
            "cs" -> cs ?: en ?: fr
            "sv" -> sv ?: en ?: fr
            "ko" -> ko ?: en ?: fr
            "ar" -> ar ?: en ?: fr
            "tr" -> tr ?: en ?: fr
            "sk" -> sk ?: en ?: fr
            "vi" -> vi ?: en ?: fr
            "ja" -> ja ?: en ?: fr
            "nl" -> nl ?: en ?: fr
            "ro" -> ro ?: en ?: fr
            else -> en ?: fr
        }
    }
}