[![GPL Licensed](https://img.shields.io/badge/license-GPL-brightgreen.svg?style=flat-square)](LICENSE.md)
[![Total Downloads](https://img.shields.io/github/downloads/appml/neutrinote/total.svg)]()

[Official](https://appml.gitbook.io/nano/) | [FAQ](https://appml.gitbook.io/nano/readme/how-do-i...) | [Documentation](https://appml.github.io/nano/) | [Mastodon](https://mastodon.social/@neutrinote) | [XDA](https://forum.xda-developers.com/t/app-4-4-neutrinote-a-hub-of-written-thoughts-in-fast-searchable-plain-text.3182426)

<div style="display:flex" >
<!-- a href="https://play.google.com/store/apps/details?id=com.appmindlab.nano">
    <img src="https://play.google.com/intl/en_us/badges/images/generic/en_badge_web_generic.png"
         alt="Get it on Google Play" 
         height="64" />
</a -->
<a href="https://f-droid.org/packages/com.appmindlab.nano">
    <img src="https://fdroid.gitlab.io/artwork/badge/get-it-on.png"
         alt="Get it on F-Droid"
         height="64">
</a>
</div><br/>

# neutriNote (Community Edition)


## What is neutriNote?

In short, a way to engineer your plain text.

Let's say plain text is the most basic unit of written information.  Plain Text Is All You Need.

Then the boundaries between written thoughts in formatted / unformatted text, math (LaTeX), rich markdown, ASCII drawings, and so on, are artificially imposed.  neutriNote reclaims the paradigm by preserving all contents in a text-centric searchable repository. Unlike the emphasis on traditional text editing function found in most mainline writing apps, neutriNote focuses instead on the long-term searchability of information so that [cognitive load](https://github.com/zakirullin/cognitive-load) may be reduced through note-taking, with an writing experience totally open to customization.


## Community Edition

This edition is identical to [**Play Store Edition**](https://play.google.com/store/apps/details?id=com.appmindlab.nano) with zero Google related dependencies.  While already the case that almost every aspect of neutriNote can be [customized](https://appml.github.io/nano/), Community Edition opens up the possibility to customize and sustain at source code level.


## Design Philosophy

neutriNote is designed to be ultra compact so as to operate smoothly on as many aging hardwares as possible.  Features and dependencies are carefully vetted to minimize impacts on search performance and to provide highly performant long note editing, with enough customization [options](https://appml.github.io/nano/) for users to build their own sustainable tools within the app.  Its versatile search mechanism is based upon a simple, non-hierarchical data structure that provides near instant access O(1) to any piece of text stored by the app.  Think of these as cognitive shortcuts to recall anything from your writings anytime with minimal lags.


## Modern Note-Taking Features

- Everything stored in UTF8 plain text
- Support rich markdown with math support (LaTeX)
- Text reflow Markdown view
- Python support
- Basic Vue.js support
- Edit notes stored in cloud
- Inter-note linking
- Theme with color temperature and OLED support
- Built-in text expansion/shortcut support
- Offline, near instant search & replace
- In-note JavaScript evaluation (REPL)
- Built-in HTML/XML tag expansion
- Integrated tools: popup dictionary, clipboard viewer, barcode scanner, ASCII art, and more
- Diagram support
- ASCII art to SVG support
- Local storage for privacy, yet easy to add sync
- PDF/HTML export
- ZERO anti-feature


## Screenshots
![Rich Markdown](https://neutrinote.files.wordpress.com/2019/02/unnamed2.jpg)
![ASCII Drawing](https://neutrinote.files.wordpress.com/2019/02/unnamed5.png)


## How to build

Simply fork and import into Android Studio.  That's it!


## Contributions

Contributions are welcome, as long as they are able to maintain a low level of impacts on battery / memory consumption.


## Star History

<a href="https://star-history.com/#appml/neutrinote&Date">
 <picture>
   <source media="(prefers-color-scheme: dark)" srcset="https://api.star-history.com/svg?repos=appml/neutrinote&type=Date&theme=dark" />
   <source media="(prefers-color-scheme: light)" srcset="https://api.star-history.com/svg?repos=appml/neutrinote&type=Date" />
   <img alt="Star History Chart" src="https://api.star-history.com/svg?repos=appml/neutrinote&type=Date" />
 </picture>
</a>


## Licensing

The project is licensed under the [GNU General Public License version 3 or later](https://github.com/appml/neutrinote/blob/master/LICENSE).  Please attribute to [this repo](https://github.com/appml/neutrinote).

    neutriNote - Markdown + Math in Just 3 MB!
    Copyright (C) 2021 App Mind Lab

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.


