// Top-level build file where you can add configuration options common to all sub-projects/modules.
plugins {
  alias(libs.plugins.android.application) apply false
  alias(libs.plugins.android.library) apply false
  alias(libs.plugins.kotlin.android) apply false
  alias(libs.plugins.ksp) apply false
  id("com.diffplug.spotless")
  alias(libs.plugins.hilt) apply false
  alias(libs.plugins.compose.compiler) apply false
}

spotless {
  kotlin {
    target("**/*.kt")
    targetExclude("**/build/**")
    ktfmt()
    trimTrailingWhitespace()
    endWithNewline()
  }
  kotlinGradle {
    target("**/*.gradle.kts")
    ktfmt()
    trimTrailingWhitespace()
    endWithNewline()
  }
  format("markdown") {
    target("**/*.md")
    trimTrailingWhitespace()
    endWithNewline()
  }
  format("ruby") {
    target("**/*.rb", "**/Fastfile", "**/Appfile", "**/Gemfile")
    trimTrailingWhitespace()
    leadingTabsToSpaces(2)
    endWithNewline()
  }
}
