package com.anysoftkeyboard.janus.app.ui.theme

import androidx.compose.material3.Typography
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.Font
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.unit.sp
import com.anysoftkeyboard.janus.app.R

// Set of Material typography styles to start with
val Merriweather =
    FontFamily(
        Font(R.font.merriweather_regular, FontWeight.Normal),
        Font(R.font.merriweather_bold, FontWeight.Bold),
        Font(R.font.merriweather_italic, FontWeight.Normal, FontStyle.Italic),
        Font(R.font.merriweather_bold_italic, FontWeight.Bold, FontStyle.Italic))

// Set of Material typography styles to start with
val Typography =
    Typography(
        bodyLarge =
            TextStyle(
                fontFamily = FontFamily.Default,
                fontWeight = FontWeight.Normal,
                fontSize = 16.sp,
                lineHeight = 24.sp,
                letterSpacing = 0.5.sp),
        headlineLarge =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Normal,
                fontSize = 32.sp,
                lineHeight = 40.sp,
                letterSpacing = 0.sp),
        headlineMedium =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Normal,
                fontSize = 28.sp,
                lineHeight = 36.sp,
                letterSpacing = 0.sp),
        headlineSmall =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Normal,
                fontSize = 24.sp,
                lineHeight = 32.sp,
                letterSpacing = 0.sp),
        titleLarge =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Normal,
                fontSize = 22.sp,
                lineHeight = 28.sp,
                letterSpacing = 0.sp),
        titleMedium =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Medium,
                fontSize = 16.sp,
                lineHeight = 24.sp,
                letterSpacing = 0.15.sp),
        titleSmall =
            TextStyle(
                fontFamily = Merriweather,
                fontWeight = FontWeight.Medium,
                fontSize = 14.sp,
                lineHeight = 20.sp,
                letterSpacing = 0.1.sp))
