// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class AppLocalizationsRo extends AppLocalizations {
  AppLocalizationsRo([String locale = 'ro']) : super(locale);

  @override
  String get appTitle => 'Shots Studio';

  @override
  String get searchScreenshots => 'Căutare Capturi de Ecran';

  @override
  String analyzed(int count, int total) {
    return 'Analizat $count/$total';
  }

  @override
  String get developerModeDisabled => 'Setări avansate dezactivate';

  @override
  String get collections => 'Colecții';

  @override
  String get screenshots => 'Capturi de Ecran';

  @override
  String get settings => 'Setări';

  @override
  String get about => 'Despre';

  @override
  String get privacy => 'Confidențialitate';

  @override
  String get createCollection => 'Creare Colecție';

  @override
  String get editCollection => 'Editare Colecție';

  @override
  String get deleteCollection => 'Ștergere Colecție';

  @override
  String get collectionName => 'Numele Colecției';

  @override
  String get save => 'Salvare';

  @override
  String get cancel => 'Anulare';

  @override
  String get delete => 'Ștergere';

  @override
  String get confirm => 'Confirmare';

  @override
  String get yes => 'Da';

  @override
  String get no => 'Nu';

  @override
  String get ok => 'OK';

  @override
  String get search => 'Căutare';

  @override
  String get noResults => 'Nici un rezultat găsit';

  @override
  String get loading => 'Se încarcă...';

  @override
  String get error => 'Eroare';

  @override
  String get retry => 'Reîncercare';

  @override
  String get share => 'Partajare';

  @override
  String get copy => 'Copiere';

  @override
  String get paste => 'Lipire';

  @override
  String get selectAll => 'Selectare Totală';

  @override
  String get aiSettings => 'Setări AI';

  @override
  String get apiKey => 'Cheie API';

  @override
  String get modelName => 'Numele Modelului';

  @override
  String get autoProcessing => 'Procesare Automată';

  @override
  String get enabled => 'Activat';

  @override
  String get disabled => 'Dezactivat';

  @override
  String get theme => 'Temă';

  @override
  String get lightTheme => 'Luminoasă';

  @override
  String get darkTheme => 'Întunecată';

  @override
  String get systemTheme => 'Sistem';

  @override
  String get language => 'Limbă';

  @override
  String get analytics => 'Analiză';

  @override
  String get betaTesting => 'Testare Beta';

  @override
  String get writeTagsToXMP => 'Scriere Etichete în XMP';

  @override
  String get xmpMetadataWritten => 'Metadate XMP scrise în fișier';

  @override
  String get advancedSettings => 'Setări Avansate';

  @override
  String get developerMode => 'Setări Avansate';

  @override
  String get safeDelete => 'Ștergere Sigură';

  @override
  String get sourceCode => 'Cod Sursă';

  @override
  String get support => 'Suport';

  @override
  String get checkForUpdates => 'Verificare Actualizări';

  @override
  String get privacyNotice => 'Notificare Confidențialitate';

  @override
  String get analyticsAndTelemetry => 'Analiză și Telemetrie';

  @override
  String get performanceMenu => 'Meniu Performanță';

  @override
  String get serverMessages => 'Mesaje Server';

  @override
  String get maxParallelAI => 'Max AI Paralel';

  @override
  String get enableScreenshotLimit => 'Activare Limită Capturi de Ecran';

  @override
  String get tags => 'Etichete';

  @override
  String get aiDetails => 'Detalii AI';

  @override
  String get size => 'Dimensiune';

  @override
  String get addDescription => 'Adăugare descriere';

  @override
  String get addTag => 'Adăugare etichetă';

  @override
  String get amoledMode => 'Mod AMOLED';

  @override
  String get notifications => 'Notificări';

  @override
  String get permissions => 'Permisiuni';

  @override
  String get storage => 'Stocare';

  @override
  String get camera => 'Cameră';

  @override
  String get version => 'Versiune';

  @override
  String get buildNumber => 'Numărul Versiunii';

  @override
  String get ocrResults => 'Rezultate OCR';

  @override
  String get extractedText => 'Text Extras';

  @override
  String get noTextFound => 'Nu s-a găsit text în imagine';

  @override
  String get processing => 'Procesare...';

  @override
  String get selectImage => 'Selectare Imagine';

  @override
  String get takePhoto => 'Realizare Fotografie';

  @override
  String get fromGallery => 'Din Galerie';

  @override
  String get imageSelected => 'Imagine selectată';

  @override
  String get noImageSelected => 'Nici o imagine selectată';

  @override
  String get apiKeyRequired => 'Necesar pentru funcțiile AI';

  @override
  String get apiKeyValid => 'Cheia API este validă';

  @override
  String get apiKeyValidationFailed => 'Validarea cheii API a eșuat';

  @override
  String get apiKeyNotValidated => 'Cheia API este setată (nevalidată)';

  @override
  String get enterApiKey => 'Introduceți Cheia API Gemini';

  @override
  String get validateApiKey => 'Validare Cheie API';

  @override
  String get valid => 'Valid';

  @override
  String get autoProcessingDescription =>
      'Capturile de ecran vor fi procesate automat când sunt adăugate';

  @override
  String get manualProcessingOnly => 'Doar procesare manuală';

  @override
  String get amoledModeDescription =>
      'Temă întunecată optimizată pentru ecrane AMOLED';

  @override
  String get defaultDarkTheme => 'Temă întunecată implicită';

  @override
  String get getApiKey => 'Obținere cheie API';

  @override
  String get stopProcessing => 'Oprire Procesare';

  @override
  String get processWithAI => 'Procesare cu AI';

  @override
  String get createFirstCollection => 'Creați prima dvs. colecție pentru a';

  @override
  String get organizeScreenshots => 'organiza capturile de ecran';

  @override
  String get cancelSelection => 'Anulare selecție';

  @override
  String get deselectAll => 'Deselectare Totală';

  @override
  String get deleteSelected => 'Ștergere selectate';

  @override
  String get clearCorruptFiles => 'Curățare Fișiere Corupte';

  @override
  String get clearCorruptFilesConfirm => 'Curățare Fișiere Corupte?';

  @override
  String get clearCorruptFilesMessage =>
      'Sunteți sigur că doriți să eliminați toate fișierele corupte din această colecție? Această acțiune nu poate fi anulată.';

  @override
  String get corruptFilesCleared => 'Fișierele corupte au fost curățate';

  @override
  String get noCorruptFiles => 'Nu s-au găsit fișiere corupte';

  @override
  String get enableLocalAI => '🤖 Activare Model AI Local';

  @override
  String get localAIBenefits => 'Ce înseamnă aceasta:';

  @override
  String get localAIOffline =>
      '• Funcționează complet offline - fără internet necesar';

  @override
  String get localAIPrivacy => '• Datele dvs. rămân private pe dispozitiv';

  @override
  String get localAINote => 'Notă:';

  @override
  String get localAIBattery =>
      '• Utilizează mai multă baterie decât modelele cloud';

  @override
  String get localAIRAM => '• Necesită cel puțin 4GB RAM disponibil';

  @override
  String get localAIPrivacyNote =>
      'Modelul va procesa capturile de ecran local pentru confidențialitate îmbunătățită.';

  @override
  String get enableLocalAIButton => 'Activare AI Local';

  @override
  String get reminders => 'Mementouri';

  @override
  String get activeReminders => 'Active';

  @override
  String get pastReminders => 'Trecute';

  @override
  String get noActiveReminders =>
      'Nu există mementouri active.\nSetați mementouri din detaliile capturilor de ecran.';

  @override
  String get noPastReminders => 'Nu există mementouri trecute.';

  @override
  String get editReminder => 'Editare Memento';

  @override
  String get clearReminder => 'Curățare Memento';

  @override
  String get removePastReminder => 'Eliminare';

  @override
  String get pastReminderRemoved => 'Mementoul trecut a fost eliminat';

  @override
  String get supportTheProject => 'Sprijiniți proiectul';

  @override
  String get supportShotsStudio => 'Sprijiniți Shots Studio';

  @override
  String get supportDescription =>
      'Sprijinul dvs. ajută la menținerea acestui proiect în viață și ne permite să adăugăm funcții noi minunate';

  @override
  String get availableNow => 'Disponibil acum';

  @override
  String get comingSoon => 'Disponibil în curând';

  @override
  String get everyContributionMatters => 'Fiecare contribuție contează';

  @override
  String get supportFooterDescription =>
      'Vă mulțumim că luați în considerare sprijinirea acestui proiect. Contribuția dvs. ne ajută să menținem și să îmbunătățim Shots Studio. Pentru aranjamente speciale sau transferuri bancare internaționale, vă rugăm să ne contactați prin GitHub.';

  @override
  String get contactOnGitHub => 'Contact pe GitHub';

  @override
  String get noSponsorshipOptions =>
      'Nu sunt disponibile opțiuni de sponsorizare în prezent.';

  @override
  String get close => 'Închidere';

  @override
  String get quickCreateCollection => 'Creare Rapidă Colecție';

  @override
  String quickCreateCollectionMessage(String collectionName, int count) {
    return 'Doriți să creați o colecție numită \"$collectionName\" cu $count capturi de ecran?';
  }

  @override
  String get quickCreateWhatHappens => 'Ce se va întâmpla?';

  @override
  String get quickCreateExplanation =>
      'Vom crea instantaneu o colecție nouă conținând toate rezultatele căutării.';

  @override
  String get dontShowAgain => 'Nu mai afișa';

  @override
  String get create => 'Creează';

  @override
  String get createCollectionFromSearchResults =>
      'Creați colecție din rezultatele căutării';

  @override
  String noScreenshotsFoundFor(String query) {
    return 'Nu s-au găsit capturi de ecran pentru \"$query\"';
  }
}
