// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class AppLocalizationsPt extends AppLocalizations {
  AppLocalizationsPt([String locale = 'pt']) : super(locale);

  @override
  String get appTitle => 'Shots Studio';

  @override
  String get searchScreenshots => 'Pesquisar Capturas de Tela';

  @override
  String analyzed(int count, int total) {
    return 'Analisado $count/$total';
  }

  @override
  String get developerModeDisabled => 'Configurações avançadas desabilitadas';

  @override
  String get collections => 'Coleções';

  @override
  String get screenshots => 'Capturas de Tela';

  @override
  String get settings => 'Configurações';

  @override
  String get about => 'Sobre';

  @override
  String get privacy => 'Privacidade';

  @override
  String get createCollection => 'Criar Coleção';

  @override
  String get editCollection => 'Editar Coleção';

  @override
  String get deleteCollection => 'Excluir Coleção';

  @override
  String get collectionName => 'Nome da Coleção';

  @override
  String get save => 'Salvar';

  @override
  String get cancel => 'Cancelar';

  @override
  String get delete => 'Excluir';

  @override
  String get confirm => 'Confirmar';

  @override
  String get yes => 'Sim';

  @override
  String get no => 'Não';

  @override
  String get ok => 'OK';

  @override
  String get search => 'Pesquisar';

  @override
  String get noResults => 'Nenhum resultado encontrado';

  @override
  String get loading => 'Carregando...';

  @override
  String get error => 'Erro';

  @override
  String get retry => 'Tentar novamente';

  @override
  String get share => 'Compartilhar';

  @override
  String get copy => 'Copiar';

  @override
  String get paste => 'Colar';

  @override
  String get selectAll => 'Selecionar Todos';

  @override
  String get aiSettings => 'Configurações de IA';

  @override
  String get apiKey => 'Chave da API';

  @override
  String get modelName => 'Nome do Modelo';

  @override
  String get autoProcessing => 'Processamento Automático';

  @override
  String get enabled => 'Habilitado';

  @override
  String get disabled => 'Desabilitado';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Claro';

  @override
  String get darkTheme => 'Escuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get language => 'Idioma';

  @override
  String get analytics => 'Análises';

  @override
  String get betaTesting => 'Beta Testing';

  @override
  String get writeTagsToXMP => 'Escrever Tags em XMP';

  @override
  String get xmpMetadataWritten => 'Metadados XMP escritos no arquivo';

  @override
  String get advancedSettings => 'Configurações Avançadas';

  @override
  String get developerMode => 'Configurações Avançadas';

  @override
  String get safeDelete => 'Exclusão Segura';

  @override
  String get sourceCode => 'Código Fonte';

  @override
  String get support => 'Suporte';

  @override
  String get checkForUpdates => 'Verificar Atualizações';

  @override
  String get privacyNotice => 'Aviso de Privacidade';

  @override
  String get analyticsAndTelemetry => 'Análise e Telemetria';

  @override
  String get performanceMenu => 'Menu de Performance';

  @override
  String get serverMessages => 'Mensagens do Servidor';

  @override
  String get maxParallelAI => 'Máximo AI Paralelo';

  @override
  String get enableScreenshotLimit => 'Ativar Limite de Capturas';

  @override
  String get tags => 'Tags';

  @override
  String get aiDetails => 'Detalhes da IA';

  @override
  String get size => 'Tamanho';

  @override
  String get addDescription => 'Adicionar descrição';

  @override
  String get addTag => 'Adicionar tag';

  @override
  String get amoledMode => 'Modo AMOLED';

  @override
  String get notifications => 'Notificações';

  @override
  String get permissions => 'Permissões';

  @override
  String get storage => 'Armazenamento';

  @override
  String get camera => 'Câmera';

  @override
  String get version => 'Versão';

  @override
  String get buildNumber => 'Número da Build';

  @override
  String get ocrResults => 'Resultados OCR';

  @override
  String get extractedText => 'Texto Extraído';

  @override
  String get noTextFound => 'Nenhum texto encontrado na imagem';

  @override
  String get processing => 'Processando...';

  @override
  String get selectImage => 'Selecionar Imagem';

  @override
  String get takePhoto => 'Tirar Foto';

  @override
  String get fromGallery => 'Da Galeria';

  @override
  String get imageSelected => 'Imagem selecionada';

  @override
  String get noImageSelected => 'Nenhuma imagem selecionada';

  @override
  String get apiKeyRequired => 'Necessário para recursos de IA';

  @override
  String get apiKeyValid => 'Chave API é válida';

  @override
  String get apiKeyValidationFailed => 'Validação da chave API falhou';

  @override
  String get apiKeyNotValidated => 'Chave API está definida (não validada)';

  @override
  String get enterApiKey => 'Digite a chave API do Gemini';

  @override
  String get validateApiKey => 'Validar chave API';

  @override
  String get valid => 'Válido';

  @override
  String get autoProcessingDescription =>
      'Capturas de tela serão processadas automaticamente quando adicionadas';

  @override
  String get manualProcessingOnly => 'Processamento manual apenas';

  @override
  String get amoledModeDescription => 'Tema escuro otimizado para telas AMOLED';

  @override
  String get defaultDarkTheme => 'Tema escuro padrão';

  @override
  String get getApiKey => 'Obter uma chave API';

  @override
  String get stopProcessing => 'Parar processamento';

  @override
  String get processWithAI => 'Processar com IA';

  @override
  String get createFirstCollection => 'Crie sua primeira coleção para';

  @override
  String get organizeScreenshots => 'organizar suas capturas de tela';

  @override
  String get cancelSelection => 'Cancelar seleção';

  @override
  String get deselectAll => 'Desmarcar Todos';

  @override
  String get deleteSelected => 'Excluir selecionados';

  @override
  String get clearCorruptFiles => 'Limpar Arquivos Corrompidos';

  @override
  String get clearCorruptFilesConfirm => 'Limpar Arquivos Corrompidos?';

  @override
  String get clearCorruptFilesMessage =>
      'Tem certeza de que deseja remover todos os arquivos corrompidos? Esta ação não pode ser desfeita.';

  @override
  String get corruptFilesCleared => 'Arquivos corrompidos limpos';

  @override
  String get noCorruptFiles => 'Nenhum arquivo corrompido encontrado';

  @override
  String get enableLocalAI => '🤖 Ativar Modelo de IA Local';

  @override
  String get localAIBenefits => 'Benefícios da IA Local:';

  @override
  String get localAIOffline =>
      '• Funciona completamente offline - nenhuma conexão à internet necessária';

  @override
  String get localAIPrivacy =>
      '• Seus dados permanecem privados em seu dispositivo';

  @override
  String get localAINote => 'Nota:';

  @override
  String get localAIBattery => '• Usa mais bateria que modelos na nuvem';

  @override
  String get localAIRAM => '• Requer pelo menos 4GB de RAM disponível';

  @override
  String get localAIPrivacyNote =>
      'O modelo processará suas capturas de tela localmente para maior privacidade.';

  @override
  String get enableLocalAIButton => 'Ativar IA Local';

  @override
  String get reminders => 'Lembretes';

  @override
  String get activeReminders => 'Ativos';

  @override
  String get pastReminders => 'Passados';

  @override
  String get noActiveReminders =>
      'Nenhum lembrete ativo.\nDefina lembretes nos detalhes da captura de tela.';

  @override
  String get noPastReminders => 'Nenhum lembrete passado.';

  @override
  String get editReminder => 'Editar Lembrete';

  @override
  String get clearReminder => 'Limpar Lembrete';

  @override
  String get removePastReminder => 'Remover';

  @override
  String get pastReminderRemoved => 'Lembrete passado removido';

  @override
  String get supportTheProject => 'Apoiar o projeto';

  @override
  String get supportShotsStudio => 'Apoiar Shots Studio';

  @override
  String get supportDescription =>
      'Seu apoio ajuda a manter este projeto vivo e nos permite adicionar novos recursos incríveis';

  @override
  String get availableNow => 'Disponível agora';

  @override
  String get comingSoon => 'Em breve';

  @override
  String get everyContributionMatters => 'Toda contribuição importa';

  @override
  String get supportFooterDescription =>
      'Obrigado por considerar apoiar este projeto. Sua contribuição nos ajuda a manter e melhorar o Shots Studio. Para arranjos especiais ou transferências bancárias internacionais, entre em contato via GitHub.';

  @override
  String get contactOnGitHub => 'Contato no GitHub';

  @override
  String get noSponsorshipOptions =>
      'Nenhuma opção de patrocínio está disponível no momento.';

  @override
  String get close => 'Fechar';

  @override
  String get quickCreateCollection => 'Criação Rápida de Coleção';

  @override
  String quickCreateCollectionMessage(String collectionName, int count) {
    return 'Deseja criar uma coleção chamada \"$collectionName\" com $count capturas de tela?';
  }

  @override
  String get quickCreateWhatHappens => 'O que vai acontecer?';

  @override
  String get quickCreateExplanation =>
      'Criaremos instantaneamente uma nova coleção contendo todos os resultados da pesquisa.';

  @override
  String get dontShowAgain => 'Não mostrar novamente';

  @override
  String get create => 'Criar';

  @override
  String get createCollectionFromSearchResults =>
      'Criar coleção a partir dos resultados da pesquisa';

  @override
  String noScreenshotsFoundFor(String query) {
    return 'Nenhuma captura de tela encontrada para \"$query\"';
  }
}
