[![Platform](https://shields.io/badge/platform-android-green.svg)](https://github.com/AnsahMohammad/shots-studio)
[![License](https://img.shields.io/badge/license-GPL3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0.en.html)
[![Latest Release](https://img.shields.io/github/v/release/AnsahMohammad/shots-studio?label=release)](https://github.com/AnsahMohammad/shots-studio/releases/latest)
[![Chat](https://img.shields.io/badge/Discussions-Join-blue?logo=github)](https://github.com/AnsahMohammad/shots-studio/discussions)
[![Downloads](https://img.shields.io/github/downloads/AnsahMohammad/shots-studio/total)](https://github.com/AnsahMohammad/shots-studio/releases)

<div align="center">
  <img src="shots_studio/assets/icon/icon.png" width="20%" />

# Shots Studio
A Screenshot Manager to Declutter Your Gallery
</div>

Shots Studio turns your chaotic screenshot folder into an **intelligent, organized archive**.  
Now powered by **on-device AI with Gemma**, you can process screenshots **offline** — faster, private, and without internet dependency.

---

## What is Shots Studio?

Drowning in screenshots you can’t find when you need them?  
**Shots Studio** brings **AI-driven search, smart tagging, and seamless organization** to your screenshot collection.

With Shots Studio, you can:

* **Search** by content — not just file names.
* Add or generate **tags** automatically using AI.
* Group related screenshots into custom **collections**.
* **Run AI fully offline** with the latest **Gemma** on-device model for faster, privacy-first processing.

---

## Download

<div align="center">

[<img src="docs/assets/get-it-on-github.png"
    alt="Get it on GitHub" height="80">](https://github.com/AnsahMohammad/shots-studio/releases/latest)

[<img src="https://f-droid.org/badge/get-it-on.png"
    alt="Get it on F-Droid" height="80">](https://f-droid.org/en/packages/com.ansah.shots_studio/)

</div>

---

## Key Features

* **AI-Powered Search**  
  Find screenshots by **text**, **objects**, or **topics** they contain — even if never labeled.

* **Smart Tagging**  
  Let AI suggest tags or add your own to keep things tidy.

* **Collections**  
  Group related screenshots for quick navigation.

* **Choose Your AI**  
  - **Gemma On-Device AI** → Private, offline, instant results.  
  - **Gemini 2.0 Flash / Gemini 2.5 Pro** → Cloud-powered speed or deep analysis.

* **Offline AI Processing**  
  Process screenshots **without an internet connection** using the integrated Gemma model — great for privacy and speed.

* **Open Source**  
  Transparent, community-driven, and modifiable.

---

## How It Works + Privacy

By default, Shots Studio can send your screenshot data to **Google’s Gemini API** for cloud-powered analysis.  
For privacy-first use, switch to **Gemma on-device AI** — no data leaves your phone.

More details: [Gemini API Privacy Policy](https://ai.google.dev/gemini-api/terms).

---

## Why Shots Studio?

* **Declutter your gallery** — No more endless scrolling.
* **Instant access** — Search like you search your notes.
* **Customizable AI** — Cloud or offline, you choose.
* **Privacy-first** — Offline AI means no data leaves your device.
* **Community-built** — 100% open source.

---

## Getting Started

1. **Choose AI Mode**  
   - For cloud AI: Get a [Gemini API key](https://ai.google.dev/gemini-api/docs/api-key).  
   - For offline AI: Enable **Gemma On-Device** in Settings (no API key needed).

2. **Install the App**  
   - Download from [Releases](https://github.com/AnsahMohammad/shots-studio/releases/latest) or [F-Droid](https://f-droid.org/en/packages/com.ansah.shots_studio/).
   - Install the APK on your device.

3. **Grant Permissions**  
   Allow storage access to scan and process screenshots.

4. **Run AI Processing**  
   Tap the AI ⚡ button to analyze screenshots and auto-tag.

---

## Contributing

We welcome contributions — code, features, bug fixes, or docs.  
See `CONTRIBUTING.md` or open a discussion/PR.

---

## Setting Up Git Hooks

```bash
git config core.hooksPath scripts/git-hooks
```

Run this once after cloning to enable project-specific hooks.
