// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Italian (`it`).
class AppLocalizationsIt extends AppLocalizations {
  AppLocalizationsIt([String locale = 'it']) : super(locale);

  @override
  String get appTitle => 'Shots Studio';

  @override
  String get searchScreenshots => 'Cerca Screenshot';

  @override
  String analyzed(int count, int total) {
    return 'Analizzati $count/$total';
  }

  @override
  String get developerModeDisabled => 'Impostazioni avanzate disabilitate';

  @override
  String get collections => 'Collezioni';

  @override
  String get screenshots => 'Screenshot';

  @override
  String get settings => 'Impostazioni';

  @override
  String get about => 'Informazioni';

  @override
  String get privacy => 'Privacy';

  @override
  String get createCollection => 'Crea Collezione';

  @override
  String get editCollection => 'Modifica Collezione';

  @override
  String get deleteCollection => 'Elimina Collezione';

  @override
  String get collectionName => 'Nome Collezione';

  @override
  String get save => 'Salva';

  @override
  String get cancel => 'Annulla';

  @override
  String get delete => 'Elimina';

  @override
  String get confirm => 'Conferma';

  @override
  String get yes => 'Sì';

  @override
  String get no => 'No';

  @override
  String get ok => 'OK';

  @override
  String get search => 'Cerca';

  @override
  String get noResults => 'Nessun risultato trovato';

  @override
  String get loading => 'Caricamento...';

  @override
  String get error => 'Errore';

  @override
  String get retry => 'Riprova';

  @override
  String get share => 'Condividi';

  @override
  String get copy => 'Copia';

  @override
  String get paste => 'Incolla';

  @override
  String get selectAll => 'Seleziona Tutto';

  @override
  String get aiSettings => 'Impostazioni AI';

  @override
  String get apiKey => 'Chiave API';

  @override
  String get modelName => 'Modello AI';

  @override
  String get autoProcessing => 'Elaborazione Automatica';

  @override
  String get enabled => 'Abilitato';

  @override
  String get disabled => 'Disabilitato';

  @override
  String get theme => 'Tema';

  @override
  String get lightTheme => 'Chiaro';

  @override
  String get darkTheme => 'Scuro';

  @override
  String get systemTheme => 'Sistema';

  @override
  String get language => 'Lingua';

  @override
  String get analytics => 'Analisi';

  @override
  String get betaTesting => 'Test Beta';

  @override
  String get advancedSettings => 'Impostazioni Avanzate';

  @override
  String get developerMode => 'Impostazioni Avanzate';

  @override
  String get safeDelete => 'Eliminazione Sicura';

  @override
  String get sourceCode => 'Codice Sorgente';

  @override
  String get support => 'Supporto';

  @override
  String get checkForUpdates => 'Controlla Aggiornamenti';

  @override
  String get privacyNotice => 'Avviso Privacy';

  @override
  String get analyticsAndTelemetry => 'Analisi e Telemetria';

  @override
  String get performanceMenu => 'Menu Prestazioni';

  @override
  String get serverMessages => 'Messaggi Server';

  @override
  String get maxParallelAI => 'AI Parallelo Massimo';

  @override
  String get enableScreenshotLimit => 'Abilita Limite Screenshot';

  @override
  String get tags => 'Tag';

  @override
  String get aiDetails => 'Dettagli AI';

  @override
  String get size => 'Dimensione';

  @override
  String get addDescription => 'Aggiungi una descrizione';

  @override
  String get addTag => 'Aggiungi tag';

  @override
  String get amoledMode => 'Modalità AMOLED';

  @override
  String get notifications => 'Notifiche';

  @override
  String get permissions => 'Permessi';

  @override
  String get storage => 'Archivio';

  @override
  String get camera => 'Fotocamera';

  @override
  String get version => 'Versione';

  @override
  String get buildNumber => 'Numero Build';

  @override
  String get ocrResults => 'Risultati OCR';

  @override
  String get extractedText => 'Testo Estratto';

  @override
  String get noTextFound => 'Nessun testo trovato nell\'immagine';

  @override
  String get processing => 'Elaborazione...';

  @override
  String get selectImage => 'Seleziona Immagine';

  @override
  String get takePhoto => 'Scatta Foto';

  @override
  String get fromGallery => 'Dalla Galleria';

  @override
  String get imageSelected => 'Immagine selezionata';

  @override
  String get noImageSelected => 'Nessuna immagine selezionata';

  @override
  String get apiKeyRequired => 'Richiesto per funzioni AI';

  @override
  String get apiKeyValid => 'Chiave API valida';

  @override
  String get apiKeyValidationFailed => 'Validazione chiave API fallita';

  @override
  String get apiKeyNotValidated => 'Chiave API impostata (non validata)';

  @override
  String get enterApiKey => 'Inserisci Chiave API Gemini';

  @override
  String get validateApiKey => 'Valida Chiave API';

  @override
  String get valid => 'Valido';

  @override
  String get autoProcessingDescription =>
      'Gli screenshot saranno automaticamente elaborati quando aggiunti';

  @override
  String get manualProcessingOnly => 'Solo elaborazione manuale';

  @override
  String get amoledModeDescription =>
      'Tema scuro ottimizzato per schermi AMOLED';

  @override
  String get defaultDarkTheme => 'Tema scuro predefinito';

  @override
  String get getApiKey => 'Ottieni una chiave API';

  @override
  String get stopProcessing => 'Ferma Elaborazione';

  @override
  String get processWithAI => 'Elabora con AI';

  @override
  String get createFirstCollection => 'Crea la tua prima collezione per';

  @override
  String get organizeScreenshots => 'organizzare i tuoi screenshot';

  @override
  String get cancelSelection => 'Annulla Selezione';

  @override
  String get deselectAll => 'Deseleziona Tutto';

  @override
  String get deleteSelected => 'Elimina Selezionati';

  @override
  String get clearCorruptFiles => 'Cancella File Corrotti';

  @override
  String get clearCorruptFilesConfirm => 'Cancellare File Corrotti?';

  @override
  String get clearCorruptFilesMessage =>
      'Sei sicuro di voler rimuovere tutti i file corrotti? Questa azione non può essere annullata.';

  @override
  String get corruptFilesCleared => 'File corrotti cancellati';

  @override
  String get noCorruptFiles => 'Nessun file corrotto trovato';

  @override
  String get enableLocalAI => '🤖 Abilita Modello IA Locale';

  @override
  String get localAIBenefits => 'Vantaggi dell\'IA Locale:';

  @override
  String get localAIOffline =>
      '• Funziona completamente offline - nessuna connessione internet richiesta';

  @override
  String get localAIPrivacy =>
      '• I tuoi dati rimangono privati sul tuo dispositivo';

  @override
  String get localAINote => 'Nota:';

  @override
  String get localAIBattery =>
      '• Utilizza più batteria rispetto ai modelli cloud';

  @override
  String get localAIRAM => '• Richiede almeno 4GB di RAM disponibile';

  @override
  String get localAIPrivacyNote =>
      'Il modello elaborerà le tue schermate localmente per una maggiore privacy.';

  @override
  String get enableLocalAIButton => 'Abilita IA Locale';

  @override
  String get reminders => 'Promemoria';

  @override
  String get activeReminders => 'Attivi';

  @override
  String get pastReminders => 'Passati';

  @override
  String get noActiveReminders =>
      'Nessun promemoria attivo.\nImposta promemoria dai dettagli screenshot.';

  @override
  String get noPastReminders => 'Nessun promemoria passato.';

  @override
  String get editReminder => 'Modifica Promemoria';

  @override
  String get clearReminder => 'Cancella Promemoria';

  @override
  String get removePastReminder => 'Rimuovi';

  @override
  String get pastReminderRemoved => 'Promemoria passato rimosso';

  @override
  String get supportTheProject => 'Sostieni il progetto';

  @override
  String get supportShotsStudio => 'Sostieni Shots Studio';

  @override
  String get supportDescription =>
      'Il tuo supporto aiuta a mantenere vivo questo progetto e ci permette di aggiungere nuove fantastiche funzionalità';

  @override
  String get availableNow => 'Disponibile ora';

  @override
  String get comingSoon => 'Prossimamente';

  @override
  String get everyContributionMatters => 'Ogni contributo conta';

  @override
  String get supportFooterDescription =>
      'Grazie per aver considerato di sostenere questo progetto. Il tuo contributo ci aiuta a mantenere e migliorare Shots Studio. Per accordi speciali o bonifici bancari internazionali, contattaci tramite GitHub.';

  @override
  String get contactOnGitHub => 'Contatta su GitHub';

  @override
  String get noSponsorshipOptions =>
      'Attualmente non sono disponibili opzioni di sponsorizzazione.';

  @override
  String get close => 'Chiudi';
}
