// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get appTitle => 'शॉट्स स्टूडियो';

  @override
  String get searchScreenshots => 'स्क्रीनशॉट खोजें';

  @override
  String analyzed(int count, int total) {
    return 'विश्लेषित $count/$total';
  }

  @override
  String get developerModeDisabled => 'उन्नत सेटिंग्स अक्षम';

  @override
  String get collections => 'संग्रह';

  @override
  String get screenshots => 'स्क्रीनशॉट';

  @override
  String get settings => 'सेटिंग्स';

  @override
  String get about => 'के बारे में';

  @override
  String get privacy => 'गोपनीयता';

  @override
  String get createCollection => 'संग्रह बनाएं';

  @override
  String get editCollection => 'संग्रह संपादित करें';

  @override
  String get deleteCollection => 'संग्रह हटाएं';

  @override
  String get collectionName => 'संग्रह का नाम';

  @override
  String get save => 'सेव करें';

  @override
  String get cancel => 'रद्द करें';

  @override
  String get delete => 'हटाएं';

  @override
  String get confirm => 'पुष्टि करें';

  @override
  String get yes => 'हां';

  @override
  String get no => 'नहीं';

  @override
  String get ok => 'ठीक है';

  @override
  String get search => 'खोजें';

  @override
  String get noResults => 'कोई परिणाम नहीं मिला';

  @override
  String get loading => 'लोड हो रहा है...';

  @override
  String get error => 'त्रुटि';

  @override
  String get retry => 'पुनः प्रयास करें';

  @override
  String get share => 'साझा करें';

  @override
  String get copy => 'कॉपी करें';

  @override
  String get paste => 'पेस्ट करें';

  @override
  String get selectAll => 'सभी का चयन करें';

  @override
  String get aiSettings => 'AI सेटिंग्स';

  @override
  String get apiKey => 'API की';

  @override
  String get modelName => 'मॉडल नाम';

  @override
  String get autoProcessing => 'ऑटो प्रोसेसिंग';

  @override
  String get enabled => 'सक्षम';

  @override
  String get disabled => 'अक्षम';

  @override
  String get theme => 'थीम';

  @override
  String get lightTheme => 'लाइट';

  @override
  String get darkTheme => 'डार्क';

  @override
  String get systemTheme => 'सिस्टम';

  @override
  String get language => 'भाषा';

  @override
  String get analytics => 'एनालिटिक्स';

  @override
  String get betaTesting => 'Beta Testing';

  @override
  String get advancedSettings => 'उन्नत सेटिंग्स';

  @override
  String get developerMode => 'उन्नत सेटिंग्स';

  @override
  String get safeDelete => 'सुरक्षित डिलीट';

  @override
  String get sourceCode => 'सोर्स कोड';

  @override
  String get support => 'सहायता';

  @override
  String get checkForUpdates => 'अपडेट चेक करें';

  @override
  String get privacyNotice => 'गोपनीयता सूचना';

  @override
  String get analyticsAndTelemetry => 'एनालिटिक्स और टेलीमेट्री';

  @override
  String get performanceMenu => 'प्रदर्शन मेनू';

  @override
  String get serverMessages => 'सर्वर संदेश';

  @override
  String get maxParallelAI => 'अधिकतम समानांतर AI';

  @override
  String get enableScreenshotLimit => 'स्क्रीनशॉट सीमा सक्षम करें';

  @override
  String get tags => 'टैग्स';

  @override
  String get aiDetails => 'AI विवरण';

  @override
  String get size => 'आकार';

  @override
  String get addDescription => 'विवरण जोड़ें';

  @override
  String get addTag => 'टैग जोड़ें';

  @override
  String get amoledMode => 'AMOLED मोड';

  @override
  String get notifications => 'सूचनाएं';

  @override
  String get permissions => 'अनुमतियां';

  @override
  String get storage => 'स्टोरेज';

  @override
  String get camera => 'कैमरा';

  @override
  String get version => 'संस्करण';

  @override
  String get buildNumber => 'बिल्ड नंबर';

  @override
  String get ocrResults => 'OCR परिणाम';

  @override
  String get extractedText => 'निकाला गया टेक्स्ट';

  @override
  String get noTextFound => 'छवि में कोई टेक्स्ट नहीं मिला';

  @override
  String get processing => 'प्रोसेसिंग...';

  @override
  String get selectImage => 'छवि चुनें';

  @override
  String get takePhoto => 'फोटो लें';

  @override
  String get fromGallery => 'गैलरी से';

  @override
  String get imageSelected => 'छवि चयनित';

  @override
  String get noImageSelected => 'कोई छवि चयनित नहीं';

  @override
  String get apiKeyRequired => 'AI सुविधाओं के लिए आवश्यक';

  @override
  String get apiKeyValid => 'API कुंजी वैध है';

  @override
  String get apiKeyValidationFailed => 'API कुंजी सत्यापन असफल';

  @override
  String get apiKeyNotValidated => 'API कुंजी सेट है (सत्यापित नहीं)';

  @override
  String get enterApiKey => 'Gemini API कुंजी दर्ज करें';

  @override
  String get validateApiKey => 'API कुंजी सत्यापित करें';

  @override
  String get valid => 'वैध';

  @override
  String get autoProcessingDescription =>
      'स्क्रीनशॉट जोड़े जाने पर स्वचालित रूप से प्रोसेस होंगे';

  @override
  String get manualProcessingOnly => 'केवल मैन्युअल प्रोसेसिंग';

  @override
  String get amoledModeDescription =>
      'AMOLED स्क्रीन के लिए अनुकूलित डार्क थीम';

  @override
  String get defaultDarkTheme => 'डिफ़ॉल्ट डार्क थीम';

  @override
  String get getApiKey => 'API कुंजी प्राप्त करें';

  @override
  String get stopProcessing => 'प्रसंस्करण रोकें';

  @override
  String get processWithAI => 'AI के साथ प्रसंस्करण';

  @override
  String get createFirstCollection => 'अपना पहला संग्रह बनाएं';

  @override
  String get organizeScreenshots => 'अपने स्क्रीनशॉट व्यवस्थित करने के लिए';

  @override
  String get cancelSelection => 'चयन रद्द करें';

  @override
  String get deselectAll => 'सभी का चयन रद्द करें';

  @override
  String get deleteSelected => 'चयनित को हटाएं';

  @override
  String get clearCorruptFiles => 'दूषित फाइलें साफ़ करें';

  @override
  String get clearCorruptFilesConfirm => 'दूषित फाइलें साफ़ करें?';

  @override
  String get clearCorruptFilesMessage =>
      'क्या आप सुनिश्चित हैं कि आप सभी दूषित फाइलों को हटाना चाहते हैं? यह क्रिया पूर्ववत नहीं की जा सकती।';

  @override
  String get corruptFilesCleared => 'दूषित फाइलें साफ़ कर दी गईं';

  @override
  String get noCorruptFiles => 'कोई दूषित फाइल नहीं मिली';

  @override
  String get enableLocalAI => '🤖 स्थानीय AI मॉडल सक्षम करें';

  @override
  String get localAIBenefits => 'स्थानीय AI के लाभ:';

  @override
  String get localAIOffline =>
      '• पूर्णतः ऑफलाइन काम करता है - इंटरनेट की आवश्यकता नहीं';

  @override
  String get localAIPrivacy => '• आपका डेटा आपके डिवाइस पर निजी रहता है';

  @override
  String get localAINote => 'नोट:';

  @override
  String get localAIBattery => '• क्लाउड मॉडल से अधिक बैटरी का उपयोग करता है';

  @override
  String get localAIRAM => '• कम से कम 4GB उपलब्ध RAM की आवश्यकता है';

  @override
  String get localAIPrivacyNote =>
      'मॉडल बेहतर गोपनीयता के लिए आपके स्क्रीनशॉट को स्थानीय रूप से प्रोसेस करेगा।';

  @override
  String get enableLocalAIButton => 'स्थानीय AI सक्षम करें';

  @override
  String get reminders => 'रिमाइंडर';

  @override
  String get activeReminders => 'सक्रिय';

  @override
  String get pastReminders => 'पुराने';

  @override
  String get noActiveReminders =>
      'कोई सक्रिय रिमाइंडर नहीं।\nस्क्रीनशॉट विवरण से रिमाइंडर सेट करें।';

  @override
  String get noPastReminders => 'कोई पुराने रिमाइंडर नहीं।';

  @override
  String get editReminder => 'रिमाइंडर संपादित करें';

  @override
  String get clearReminder => 'रिमाइंडर साफ़ करें';

  @override
  String get removePastReminder => 'हटाएं';

  @override
  String get pastReminderRemoved => 'पुराना रिमाइंडर हटा दिया गया';

  @override
  String get supportTheProject => 'प्रोजेक्ट का समर्थन करें';

  @override
  String get supportShotsStudio => 'Shots Studio का समर्थन करें';

  @override
  String get supportDescription =>
      'आपका समर्थन इस प्रोजेक्ट को जीवित रखने में मदद करता है और हमें नई शानदार सुविधाएं जोड़ने में सक्षम बनाता है';

  @override
  String get availableNow => 'अभी उपलब्ध';

  @override
  String get comingSoon => 'जल्द आ रहा है';

  @override
  String get everyContributionMatters => 'हर योगदान मायने रखता है';

  @override
  String get supportFooterDescription =>
      'इस प्रोजेक्ट का समर्थन करने पर विचार करने के लिए धन्यवाद। आपका योगदान हमें Shots Studio को बनाए रखने और सुधारने में मदद करता है। विशेष व्यवस्था या अंतर्राष्ट्रीय वायर ट्रांसफर के लिए, कृपया GitHub के माध्यम से संपर्क करें।';

  @override
  String get contactOnGitHub => 'GitHub पर संपर्क करें';

  @override
  String get noSponsorshipOptions =>
      'वर्तमान में कोई प्रायोजन विकल्प उपलब्ध नहीं हैं।';

  @override
  String get close => 'बंद करें';
}
