// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for French (`fr`).
class AppLocalizationsFr extends AppLocalizations {
  AppLocalizationsFr([String locale = 'fr']) : super(locale);

  @override
  String get appTitle => 'Shots Studio';

  @override
  String get searchScreenshots => 'Rechercher des Captures d\'Écran';

  @override
  String analyzed(int count, int total) {
    return 'Analysé $count/$total';
  }

  @override
  String get developerModeDisabled => 'Paramètres avancés désactivés';

  @override
  String get collections => 'Collections';

  @override
  String get screenshots => 'Captures d\'Écran';

  @override
  String get settings => 'Paramètres';

  @override
  String get about => 'À propos';

  @override
  String get privacy => 'Confidentialité';

  @override
  String get createCollection => 'Créer une Collection';

  @override
  String get editCollection => 'Modifier la Collection';

  @override
  String get deleteCollection => 'Supprimer la Collection';

  @override
  String get collectionName => 'Nom de la Collection';

  @override
  String get save => 'Enregistrer';

  @override
  String get cancel => 'Annuler';

  @override
  String get delete => 'Supprimer';

  @override
  String get confirm => 'Confirmer';

  @override
  String get yes => 'Oui';

  @override
  String get no => 'Non';

  @override
  String get ok => 'OK';

  @override
  String get search => 'Rechercher';

  @override
  String get noResults => 'Aucun résultat trouvé';

  @override
  String get loading => 'Chargement...';

  @override
  String get error => 'Erreur';

  @override
  String get retry => 'Réessayer';

  @override
  String get share => 'Partager';

  @override
  String get copy => 'Copier';

  @override
  String get paste => 'Coller';

  @override
  String get selectAll => 'Tout sélectionner';

  @override
  String get aiSettings => 'Paramètres IA';

  @override
  String get apiKey => 'Clé API';

  @override
  String get modelName => 'Nom du Modèle';

  @override
  String get autoProcessing => 'Traitement Automatique';

  @override
  String get enabled => 'Activé';

  @override
  String get disabled => 'Désactivé';

  @override
  String get theme => 'Thème';

  @override
  String get lightTheme => 'Clair';

  @override
  String get darkTheme => 'Sombre';

  @override
  String get systemTheme => 'Système';

  @override
  String get language => 'Langue';

  @override
  String get analytics => 'Analyses';

  @override
  String get betaTesting => 'Beta Testing';

  @override
  String get advancedSettings => 'Paramètres Avancés';

  @override
  String get developerMode => 'Paramètres Avancés';

  @override
  String get safeDelete => 'Suppression Sécurisée';

  @override
  String get sourceCode => 'Code Source';

  @override
  String get support => 'Support';

  @override
  String get checkForUpdates => 'Vérifier les mises à jour';

  @override
  String get privacyNotice => 'Avis de confidentialité';

  @override
  String get analyticsAndTelemetry => 'Analyse et télémétrie';

  @override
  String get performanceMenu => 'Menu de performance';

  @override
  String get serverMessages => 'Messages du serveur';

  @override
  String get maxParallelAI => 'IA parallèle max';

  @override
  String get enableScreenshotLimit => 'Activer la limite de captures';

  @override
  String get tags => 'Étiquettes';

  @override
  String get aiDetails => 'Détails IA';

  @override
  String get size => 'Taille';

  @override
  String get addDescription => 'Ajouter une description';

  @override
  String get addTag => 'Ajouter une étiquette';

  @override
  String get amoledMode => 'Mode AMOLED';

  @override
  String get notifications => 'Notifications';

  @override
  String get permissions => 'Autorisations';

  @override
  String get storage => 'Stockage';

  @override
  String get camera => 'Caméra';

  @override
  String get version => 'Version';

  @override
  String get buildNumber => 'Numéro de Build';

  @override
  String get ocrResults => 'Résultats OCR';

  @override
  String get extractedText => 'Texte Extrait';

  @override
  String get noTextFound => 'Aucun texte trouvé dans l\'image';

  @override
  String get processing => 'Traitement...';

  @override
  String get selectImage => 'Sélectionner une Image';

  @override
  String get takePhoto => 'Prendre une Photo';

  @override
  String get fromGallery => 'Depuis la Galerie';

  @override
  String get imageSelected => 'Image sélectionnée';

  @override
  String get noImageSelected => 'Aucune image sélectionnée';

  @override
  String get apiKeyRequired => 'Requis pour les fonctionnalités IA';

  @override
  String get apiKeyValid => 'La clé API est valide';

  @override
  String get apiKeyValidationFailed => 'Échec de la validation de la clé API';

  @override
  String get apiKeyNotValidated => 'Clé API définie (non validée)';

  @override
  String get enterApiKey => 'Entrez la clé API Gemini';

  @override
  String get validateApiKey => 'Valider la clé API';

  @override
  String get valid => 'Valide';

  @override
  String get autoProcessingDescription =>
      'Les captures d\'écran seront automatiquement traitées lors de l\'ajout';

  @override
  String get manualProcessingOnly => 'Traitement manuel uniquement';

  @override
  String get amoledModeDescription =>
      'Thème sombre optimisé pour les écrans AMOLED';

  @override
  String get defaultDarkTheme => 'Thème sombre par défaut';

  @override
  String get getApiKey => 'Obtenir une clé API';

  @override
  String get stopProcessing => 'Arrêter le traitement';

  @override
  String get processWithAI => 'Traiter avec l\'IA';

  @override
  String get createFirstCollection => 'Créez votre première collection pour';

  @override
  String get organizeScreenshots => 'organiser vos captures d\'écran';

  @override
  String get cancelSelection => 'Annuler la sélection';

  @override
  String get deselectAll => 'Tout désélectionner';

  @override
  String get deleteSelected => 'Supprimer la sélection';

  @override
  String get clearCorruptFiles => 'Nettoyer les Fichiers Corrompus';

  @override
  String get clearCorruptFilesConfirm => 'Nettoyer les Fichiers Corrompus ?';

  @override
  String get clearCorruptFilesMessage =>
      'Êtes-vous sûr de vouloir supprimer tous les fichiers corrompus de cette collection ? Cette action ne peut pas être annulée.';

  @override
  String get corruptFilesCleared => 'Fichiers corrompus supprimés';

  @override
  String get noCorruptFiles => 'Aucun fichier corrompu trouvé';

  @override
  String get enableLocalAI => '🤖 Activer le Modèle IA Local';

  @override
  String get localAIBenefits => 'Avantages de l\'IA Locale :';

  @override
  String get localAIOffline =>
      '• Fonctionne complètement hors ligne - aucune connexion internet requise';

  @override
  String get localAIPrivacy =>
      '• Vos données restent privées sur votre appareil';

  @override
  String get localAINote => 'Note :';

  @override
  String get localAIBattery =>
      '• Utilise plus de batterie que les modèles cloud';

  @override
  String get localAIRAM => '• Nécessite au moins 4 Go de RAM disponible';

  @override
  String get localAIPrivacyNote =>
      'Le modèle traitera vos captures d\'écran localement pour une confidentialité renforcée.';

  @override
  String get enableLocalAIButton => 'Activer l\'IA Locale';

  @override
  String get reminders => 'Rappels';

  @override
  String get activeReminders => 'Actifs';

  @override
  String get pastReminders => 'Passés';

  @override
  String get noActiveReminders =>
      'Aucun rappel actif.\nDéfinissez des rappels depuis les détails de la capture.';

  @override
  String get noPastReminders => 'Aucun rappel passé.';

  @override
  String get editReminder => 'Modifier le Rappel';

  @override
  String get clearReminder => 'Effacer le Rappel';

  @override
  String get removePastReminder => 'Supprimer';

  @override
  String get pastReminderRemoved => 'Rappel passé supprimé';

  @override
  String get supportTheProject => 'Soutenir le projet';

  @override
  String get supportShotsStudio => 'Soutenir Shots Studio';

  @override
  String get supportDescription =>
      'Votre soutien aide à maintenir ce projet en vie et nous permet d\'ajouter de nouvelles fonctionnalités incroyables';

  @override
  String get availableNow => 'Disponible maintenant';

  @override
  String get comingSoon => 'Bientôt disponible';

  @override
  String get everyContributionMatters => 'Chaque contribution compte';

  @override
  String get supportFooterDescription =>
      'Merci d\'envisager de soutenir ce projet. Votre contribution nous aide à maintenir et améliorer Shots Studio. Pour des arrangements spéciaux ou des virements bancaires internationaux, contactez-nous via GitHub.';

  @override
  String get contactOnGitHub => 'Contacter sur GitHub';

  @override
  String get noSponsorshipOptions =>
      'Aucune option de parrainage n\'est actuellement disponible.';

  @override
  String get close => 'Fermer';
}
