// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get appTitle => 'Shots Studio';

  @override
  String get searchScreenshots => 'Search Screenshots';

  @override
  String analyzed(int count, int total) {
    return 'Analyzed $count/$total';
  }

  @override
  String get developerModeDisabled => 'Advanced settings disabled';

  @override
  String get collections => 'Collections';

  @override
  String get screenshots => 'Screenshots';

  @override
  String get settings => 'Settings';

  @override
  String get about => 'About';

  @override
  String get privacy => 'Privacy';

  @override
  String get createCollection => 'Create Collection';

  @override
  String get editCollection => 'Edit Collection';

  @override
  String get deleteCollection => 'Delete Collection';

  @override
  String get collectionName => 'Collection Name';

  @override
  String get save => 'Save';

  @override
  String get cancel => 'Cancel';

  @override
  String get delete => 'Delete';

  @override
  String get confirm => 'Confirm';

  @override
  String get yes => 'Yes';

  @override
  String get no => 'No';

  @override
  String get ok => 'OK';

  @override
  String get search => 'Search';

  @override
  String get noResults => 'No results found';

  @override
  String get loading => 'Loading...';

  @override
  String get error => 'Error';

  @override
  String get retry => 'Retry';

  @override
  String get share => 'Share';

  @override
  String get copy => 'Copy';

  @override
  String get paste => 'Paste';

  @override
  String get selectAll => 'Select All';

  @override
  String get aiSettings => 'AI Settings';

  @override
  String get apiKey => 'API Key';

  @override
  String get modelName => 'Model Name';

  @override
  String get autoProcessing => 'Auto Processing';

  @override
  String get enabled => 'Enabled';

  @override
  String get disabled => 'Disabled';

  @override
  String get theme => 'Theme';

  @override
  String get lightTheme => 'Light';

  @override
  String get darkTheme => 'Dark';

  @override
  String get systemTheme => 'System';

  @override
  String get language => 'Language';

  @override
  String get analytics => 'Analytics';

  @override
  String get betaTesting => 'Beta Testing';

  @override
  String get advancedSettings => 'Advanced Settings';

  @override
  String get developerMode => 'Advanced Settings';

  @override
  String get safeDelete => 'Safe Delete';

  @override
  String get sourceCode => 'Source Code';

  @override
  String get support => 'Support';

  @override
  String get checkForUpdates => 'Check for Updates';

  @override
  String get privacyNotice => 'Privacy Notice';

  @override
  String get analyticsAndTelemetry => 'Analytics and Telemetry';

  @override
  String get performanceMenu => 'Performance Menu';

  @override
  String get serverMessages => 'Server Messages';

  @override
  String get maxParallelAI => 'Max Parallel AI';

  @override
  String get enableScreenshotLimit => 'Enable Screenshot Limit';

  @override
  String get tags => 'Tags';

  @override
  String get aiDetails => 'AI Details';

  @override
  String get size => 'Size';

  @override
  String get addDescription => 'Add a description';

  @override
  String get addTag => 'Add tag';

  @override
  String get amoledMode => 'AMOLED Mode';

  @override
  String get notifications => 'Notifications';

  @override
  String get permissions => 'Permissions';

  @override
  String get storage => 'Storage';

  @override
  String get camera => 'Camera';

  @override
  String get version => 'Version';

  @override
  String get buildNumber => 'Build Number';

  @override
  String get ocrResults => 'OCR Results';

  @override
  String get extractedText => 'Extracted Text';

  @override
  String get noTextFound => 'No text found in image';

  @override
  String get processing => 'Processing...';

  @override
  String get selectImage => 'Select Image';

  @override
  String get takePhoto => 'Take Photo';

  @override
  String get fromGallery => 'From Gallery';

  @override
  String get imageSelected => 'Image selected';

  @override
  String get noImageSelected => 'No image selected';

  @override
  String get apiKeyRequired => 'Required for AI features';

  @override
  String get apiKeyValid => 'API key is valid';

  @override
  String get apiKeyValidationFailed => 'API key validation failed';

  @override
  String get apiKeyNotValidated => 'API key is set (not validated)';

  @override
  String get enterApiKey => 'Enter Gemini API Key';

  @override
  String get validateApiKey => 'Validate API Key';

  @override
  String get valid => 'Valid';

  @override
  String get autoProcessingDescription =>
      'Screenshots will be automatically processed when added';

  @override
  String get manualProcessingOnly => 'Manual processing only';

  @override
  String get amoledModeDescription => 'Dark theme optimized for AMOLED screens';

  @override
  String get defaultDarkTheme => 'Default dark theme';

  @override
  String get getApiKey => 'Get an API key';

  @override
  String get stopProcessing => 'Stop Processing';

  @override
  String get processWithAI => 'Process with AI';

  @override
  String get createFirstCollection => 'Create your first collection to';

  @override
  String get organizeScreenshots => 'organize your screenshots';

  @override
  String get cancelSelection => 'Cancel selection';

  @override
  String get deselectAll => 'Deselect All';

  @override
  String get deleteSelected => 'Delete selected';

  @override
  String get clearCorruptFiles => 'Clear Corrupt Files';

  @override
  String get clearCorruptFilesConfirm => 'Clear Corrupt Files?';

  @override
  String get clearCorruptFilesMessage =>
      'Are you sure you want to remove all corrupt files from this collection? This action cannot be undone.';

  @override
  String get corruptFilesCleared => 'Corrupt files cleared';

  @override
  String get noCorruptFiles => 'No corrupt files found';

  @override
  String get enableLocalAI => '🤖 Enable Local AI Model';

  @override
  String get localAIBenefits => 'What this means:';

  @override
  String get localAIOffline =>
      '• Works completely offline - no internet required';

  @override
  String get localAIPrivacy => '• Your data stays private on your device';

  @override
  String get localAINote => 'Note:';

  @override
  String get localAIBattery => '• Uses more battery than cloud models';

  @override
  String get localAIRAM => '• Requires at least 4GB of available RAM';

  @override
  String get localAIPrivacyNote =>
      'The model will process your screenshots locally for enhanced privacy.';

  @override
  String get enableLocalAIButton => 'Enable Local AI';

  @override
  String get reminders => 'Reminders';

  @override
  String get activeReminders => 'Active';

  @override
  String get pastReminders => 'Past';

  @override
  String get noActiveReminders =>
      'No active reminders.\nSet reminders from screenshot details.';

  @override
  String get noPastReminders => 'No past reminders.';

  @override
  String get editReminder => 'Edit Reminder';

  @override
  String get clearReminder => 'Clear Reminder';

  @override
  String get removePastReminder => 'Remove';

  @override
  String get pastReminderRemoved => 'Past reminder removed';

  @override
  String get supportTheProject => 'Support the project';

  @override
  String get supportShotsStudio => 'Support Shots Studio';

  @override
  String get supportDescription =>
      'Your support helps keep this project alive and enables us to add amazing new features';

  @override
  String get availableNow => 'Available now';

  @override
  String get comingSoon => 'Coming soon';

  @override
  String get everyContributionMatters => 'Every contribution matters';

  @override
  String get supportFooterDescription =>
      'Thank you for considering supporting this project. Your contribution helps us maintain and improve Shots Studio. For special arrangements or international wire transfers, please reach out via GitHub.';

  @override
  String get contactOnGitHub => 'Contact on GitHub';

  @override
  String get noSponsorshipOptions =>
      'No sponsorship options are currently available.';

  @override
  String get close => 'Close';
}
