#if !defined(WEBSITE_ENTRIES_H)
#define WEBSITE_ENTRIES_H

#include "we.h"

static const we_t WEBSITE_ENTRIES[] = {
	{
		.id = 0x0,
		.name = "/e/",
		.query = "e",
		.url = "https://doc.e.foundation/create-an-ecloud-account#how-can-i-delete-my-e-account-eemail",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1,
		.name = "123RF",
		.query = "123rf",
		.url = "https://www.123rf.com/support/support-answer.php?id=8817",
		.email = "mailto:frsales@123rf.com?body=I%20want%20my%20account%20to%20be%20deleted.%20My%20full%20name%20is%20XXXXXX%20and%20my%20user%20name%20is%20XXXXXX%2C%20I%20want%20my%20account%20to%20be%20deleted%20because%20of%20XXXXXX.%20I%20request%20and%20authorize%20you%20to%20remove%20my%20profile%20from%20123rf.com%20and%20delete%20all%20my%20content%20with%20you.%20I%20wish%20to%20terminate%20the%20123RF%20Contributor%20Agreement%20and%20agree%20to%20the%20Terms%20and%20Conditions%20as%20set%20in%20the%20Contributor%20Agreement%20for%20the%20termination%20process.",
		.difficulty = 0x1000
	},
	{
		.id = 0x2,
		.name = "16Personalities",
		.query = "16personalities",
		.url = "https://www.16personalities.com/profile/preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3,
		.name = "17TRACK",
		.query = "17track",
		.url = "https://help.17track.net/hc/en-us/articles/360061466432-How-to-cancel-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4,
		.name = "1984 Hosting",
		.query = "1984 hosting",
		.url = "https://1984.hosting/accounts/settings/",
		.email = "mailto:gdpr@1984.is",
		.difficulty = 0x400
	},
	{
		.id = 0x5,
		.name = "1fichier",
		.query = "1fichier",
		.url = "https://1fichier.com/contact.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6,
		.name = "1Password",
		.query = "1password",
		.url = "https://my.1password.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7,
		.name = "1Point3Acres",
		.query = "1point3acres",
		.url = "https://tools.1point3acres.com/delete-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8,
		.name = "1xBet",
		.query = "1xbet",
		.url = "https://1xbet.com",
		.email = "mailto:support@1xbet.com?subject=Delete%20my%20account&body=Please%20delete%20my%20account%20permanently%20because%20I%20don%E2%80%99t%20want%20to%20use%20the%201xBet%20services%20any%20further.%20Thank%20you.%20Username%3A%20XXX%20Email%3A%20XXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x9,
		.name = "280daily",
		.query = "280daily",
		.url = "https://280daily.com/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xa,
		.name = "2Captcha",
		.query = "2captcha",
		.url = "http://2captcha.com/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb,
		.name = "2K Games",
		.query = "2k games",
		.url = "https://support.2k.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xc,
		.name = "3D Aim Trainer",
		.query = "3d aim trainer",
		.url = "https://steelseries.com/dashboard/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd,
		.name = "404 Media",
		.query = "404 media",
		.url = "https://www.404media.co/privacy-policy/",
		.email = "mailto:emanuel@404media.co",
		.difficulty = 0x1000
	},
	{
		.id = 0xe,
		.name = "4PDA",
		.query = "4pda",
		.url = "https://4pda.to/forum/index.php?act=findpost&pid=1930277&anchor=Spoil-1930277-33",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0xf,
		.name = "4shared",
		.query = "4shared",
		.url = "https://www.4shared.com/web/account/settings#overview",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x10,
		.name = "500px",
		.query = "500px",
		.url = "https://500px.com/settings/deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x11,
		.name = "5MinuteMystery",
		.query = "5minutemystery",
		.url = "https://www.5minutemystery.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x12,
		.name = "7digital",
		.query = "7digital",
		.url = "https://help.7digital.com/hc/en-gb/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x13,
		.name = "7plus",
		.query = "7plus",
		.url = "https://support.7plus.com.au/hc/en-au/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x14,
		.name = "8tracks",
		.query = "8tracks",
		.url = "https://8tracks.com/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x15,
		.name = "99app",
		.query = "99app",
		.url = "https://99app.com/ajuda/passageiro/como-excluir-minha-conta/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x16,
		.name = "99designs",
		.query = "99designs",
		.url = "https://support.99designs.com/hc/en-us/articles/204108919-How-do-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x17,
		.name = "9GAG",
		.query = "9gag",
		.url = "https://9gag.com/member/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x18,
		.name = "A1Office",
		.query = "a1office",
		.url = "https://a1office.co/support/",
		.email = "mailto:connect@a1office.co",
		.difficulty = 0x1000
	},
	{
		.id = 0x19,
		.name = "Abacashi",
		.query = "abacashi",
		.url = "https://abacashi.com/contact",
		.email = "mailto:contato@abacashi.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x1a,
		.name = "AbeBooks",
		.query = "abebooks",
		.url = "https://support.www.abebooks.com/en_US/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1b,
		.name = "Ableton",
		.query = "ableton",
		.url = "https://www.ableton.com/en/contact-us/",
		.email = "mailto:contact@support.ableton.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20account%2C%20my%20username%20is%20XXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x1c,
		.name = "Abload",
		.query = "abload",
		.url = "https://abload.de/settings.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d,
		.name = "About you",
		.query = "about you",
		.url = "https://www.aboutyou.it/h/il-mio-account/q-360014814179",
		.email = "mailto:servizioclienti@aboutyou.it",
		.difficulty = 0x1000
	},
	{
		.id = 0x1e,
		.name = "About.me",
		.query = "aboutme",
		.url = "https://about.me/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f,
		.name = "Academia",
		.query = "academia",
		.url = "https://www.academia.edu/settings#account-removal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x20,
		.name = "Academic Torrents",
		.query = "academic torrents",
		.url = "https://academictorrents.com",
		.email = "mailto:contact@academictorrents.com?subject=Account%20Deletion",
		.difficulty = 0x1000
	},
	{
		.id = 0x21,
		.name = "Acasa",
		.query = "acasa",
		.url = "https://app.heyacasa.com/register/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22,
		.name = "Acceptd",
		.query = "acceptd",
		.url = "https://app.getacceptd.com/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x23,
		.name = "Acciobooks",
		.query = "acciobooks",
		.url = "https://acciobooks.com/users/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x24,
		.name = "Acer",
		.query = "acer",
		.url = "https://community.acer.com/en/kb/articles/115-how-to-delete-your-acer-id-account",
		.email = "mailto:privacy_officer@acer.com?subject=Acer%20Account%20Deletion",
		.difficulty = 0x1000
	},
	{
		.id = 0x25,
		.name = "Acorns",
		.query = "acorns",
		.url = "https://app.acorns.com/close-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x26,
		.name = "Acronis",
		.query = "acronis",
		.url = "https://account.acronis.com/#/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x27,
		.name = "ActBlue",
		.query = "actblue",
		.url = "https://secure.actblue.com/my-account/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x28,
		.name = "ActiveCampaign",
		.query = "activecampaign",
		.url = "https://ac.activehosted.com/f/2175",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x29,
		.name = "Activision",
		.query = "activision",
		.url = "https://support.activision.com/privacy",
		.email = "mailto:privacy@activision.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2a,
		.name = "Ada",
		.query = "ada",
		.url = "https://ada.com/help/360000319269/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2b,
		.name = "Adafruit",
		.query = "adafruit",
		.url = "https://accounts.adafruit.com/users/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c,
		.name = "Addicting Games",
		.query = "addicting games",
		.url = "https://addictinggameshelp.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2d,
		.name = "AddMeFast",
		.query = "addmefast",
		.url = "https://addmefast.com/profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2e,
		.name = "addy.io",
		.query = "addyio",
		.url = "https://app.addy.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2f,
		.name = "AdFoc.us",
		.query = "adfocus",
		.url = "https://adfoc.us/tickets/",
		.email = "mailto:support@adfoc.us?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20AdFoc.us%20account%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x30,
		.name = "AdGuard",
		.query = "adguard",
		.url = "https://my.adguard.com/en/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x31,
		.name = "Adidas US",
		.query = "adidas us",
		.url = "https://www.adidas.com/us/my-account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x32,
		.name = "ADN",
		.query = "adn",
		.url = "https://animationdigitalnetwork.com/account?view=deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x33,
		.name = "Adobe",
		.query = "adobe",
		.url = "https://account.adobe.com/privacy/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x34,
		.name = "AdsPower",
		.query = "adspower",
		.url = "https://app.adspower.com/personalSettings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x35,
		.name = "AdvCash",
		.query = "advcash",
		.url = "https://wallet.advcash.com/pages/profile#",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x36,
		.name = "Aeria Games",
		.query = "aeria games",
		.url = "https://www.aeriagames.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x37,
		.name = "Aescripts",
		.query = "aescripts",
		.url = "https://aescripts.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x38,
		.name = "Afterpay",
		.query = "afterpay",
		.url = "https://portal.afterpay.com/en-AU/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x39,
		.name = "Agence nationale des titres sécurisés",
		.query = "agence nationale des titres securises",
		.url = "https://moncompte.ants.gouv.fr/mes_donn%C3%A9es#delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a,
		.name = "Agoda",
		.query = "agoda",
		.url = "https://www.agoda.com/en-au/info/privacy.html",
		.email = "mailto:privacy@agoda.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3b,
		.name = "AgoraDesk",
		.query = "agoradesk",
		.url = "https://agoradesk.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3c,
		.name = "AI Bank Statement converter",
		.query = "ai bank statement converter",
		.url = "https://aibankstatement.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3d,
		.name = "AI Flux Krea Image Generator",
		.query = "ai flux krea image generator",
		.url = "https://aifluxkrea.com/",
		.email = "mailto:hi@aifluxkrea.com?subject=Account%20and%20Data%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x3e,
		.name = "AI Hero",
		.query = "ai hero",
		.url = "https://www.aihero.dev/faq",
		.email = "mailto:team@aihero.dev",
		.difficulty = 0x1000
	},
	{
		.id = 0x3f,
		.name = "AI Image to Image Generator",
		.query = "ai image to image generator",
		.url = "https://imgtoimggenerator.com/",
		.email = "mailto:hi@imgtoimggenerator.com?subject=Account%20and%20Data%20Deletion%20Request",
		.difficulty = 0x800
	},
	{
		.id = 0x40,
		.name = "aiqfome",
		.query = "aiqfome",
		.url = "https://aiqfome.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x41,
		.name = "airBaltic",
		.query = "airbaltic",
		.url = "https://www.airbaltic.com/en/edit-profile-new#",
		.email = "mailto:gdpr@airBalticclub.com",
		.difficulty = 0x400
	},
	{
		.id = 0x42,
		.name = "Airbnb",
		.query = "airbnb",
		.url = "https://www.airbnb.com/privacy/manage-your-data",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x43,
		.name = "Airdroid",
		.query = "airdroid",
		.url = "https://www.airdroid.com/en/deleteAccount.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x44,
		.name = "AirMeet",
		.query = "airmeet",
		.url = "https://help.airmeet.com/support/solutions/articles/82000443799-how-to-delete-airmeet-community-account-",
		.email = "mailto:support@airmeet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x45,
		.name = "Airmiles",
		.query = "airmiles",
		.url = "https://www.airmiles.ca/en/get-help.html#contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x46,
		.name = "AirMore",
		.query = "airmore",
		.url = "https://airmore.com/contact",
		.email = "mailto:support@airmore.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x47,
		.name = "airoom.chat",
		.query = "airoomchat",
		.url = "https://airoom.chat/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x48,
		.name = "AirVPN",
		.query = "airvpn",
		.url = "https://airvpn.org/contact/",
		.email = "mailto:support@airvpn.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x49,
		.name = "AKAI Professional",
		.query = "akai professional",
		.url = "https://www.akaipro.com/privacy-policy",
		.email = "mailto:privacy@inmusicbrands.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4a,
		.name = "Akinator",
		.query = "akinator",
		.url = "https://akinator.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4b,
		.name = "Albion Online",
		.query = "albion online",
		.url = "https://albiononline.com/en/profile/support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4c,
		.name = "Alchemy",
		.query = "alchemy",
		.url = "https://www.alchemy.com/",
		.email = "mailto:support@alchemy.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4d,
		.name = "ALDO",
		.query = "aldo",
		.url = "https://www.aldoshoes.com/us/en_US/legal/privacy-policy",
		.email = "mailto:dpo@aldogroup.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4e,
		.name = "Alelo",
		.query = "alelo",
		.url = "https://www.alelo.com.br/meucartao/duvidas-frequentes",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4f,
		.name = "Algolia",
		.query = "algolia",
		.url = "https://www.algolia.com/account/details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x50,
		.name = "Algor Education",
		.query = "algor education",
		.url = "https://en.algoreducation.com/contact-us",
		.email = "mailto:support@algoreducation.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x51,
		.name = "Alibaba",
		.query = "alibaba",
		.url = "https://myprivacy.alibaba.com/home#/request/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x52,
		.name = "AlienwareArena",
		.query = "alienwarearena",
		.url = "https://www.alienwarearena.com/faq-contact#Contact1",
		.email = "mailto:contact@alienwarearena.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x53,
		.name = "AliExpress",
		.query = "aliexpress",
		.url = "https://privacy.aliexpress.com/home#/request/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x54,
		.name = "AliPay",
		.query = "alipay",
		.url = "https://memberprod.alipay.com/account/close/apply.htm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x55,
		.name = "Alison",
		.query = "alison",
		.url = "https://helpcenter.alison.com/en/articles/8204957-how-do-i-delete-my-alison-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x56,
		.name = "All 4 / Channel 4",
		.query = "all 4 channel 4",
		.url = "https://4id.channel4.com/account#!/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x57,
		.name = "AllDebrid",
		.query = "alldebrid",
		.url = "https://alldebrid.com/account/#accountDelete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x58,
		.name = "AllTrails",
		.query = "alltrails",
		.url = "https://www.alltrails.com/my/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x59,
		.name = "Alternative.me",
		.query = "alternativeme",
		.url = "https://alternative.me/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a,
		.name = "AlternativeTo",
		.query = "alternativeto",
		.url = "https://alternativeto.net/user/edit/#account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b,
		.name = "Altium",
		.query = "altium",
		.url = "https://www.altium.com/privacy-policy",
		.email = "mailto:data.compliance@altium.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5c,
		.name = "AltTextGeneratorAI",
		.query = "alttextgeneratorai",
		.url = "https://alttextgeneratorai.com/terms-of-use",
		.email = "mailto:balt1794@gmail.com?subject=Account%20Deletion%20Request&body=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x5d,
		.name = "Alvanista",
		.query = "alvanista",
		.url = "https://alvanista.com/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e,
		.name = "Alza",
		.query = "alza",
		.url = "https://www.alza.cz/my-account?setlang=en-GB",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f,
		.name = "Amara",
		.query = "amara",
		.url = "https://amara.org/profiles/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x60,
		.name = "Amazon / Audible",
		.query = "amazon audible",
		.url = "https://www.amazon.com/privacy/data-deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x61,
		.name = "Amazon AWS",
		.query = "amazon aws",
		.url = "https://console.aws.amazon.com/billing/home#/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x62,
		.name = "AMD Rewards",
		.query = "amd rewards",
		.url = "https://www.amdrewards.com/my-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x63,
		.name = "Ameli",
		.query = "ameli",
		.url = "https://www.ameli.fr/assure/mentions-legales-cgu",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x64,
		.name = "American Airlines",
		.query = "american airlines",
		.url = "https://privacyportal.aa.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x65,
		.name = "AmiAmi",
		.query = "amiami",
		.url = "https://support.amiami.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x66,
		.name = "Amigo Secreto",
		.query = "amigo secreto",
		.url = "https://www.amigosecreto.com.br/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x67,
		.name = "Amplenote",
		.query = "amplenote",
		.url = "https://www.amplenote.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x68,
		.name = "Amso",
		.query = "amso",
		.url = "https://amso.eu/en/contact",
		.email = "mailto:contact@amso.eu?subject=Request%20to%20Close%20Account%20and%20Delete%20Personal%20Data&body=Dear%20AMSO%20Data%20Protection%20Team%2C%20I%20hope%20this%20message%20finds%20you%20well.%20I%20would%20like%20to%20formally%20request%20the%20closure%20of%20my%20account%20and%20the%20deletion%20of%20all%20associated%20personal%20data%20as%20per%20the%20GDPR%20guidelines.%20Below%20are%20my%20account%20details%3A%20Email%20Address%3A%20xxxxx%2C%20Account%20ID%3A%20xxxxxxx%2C%20Phone%20Number%3A%20xxxxxx%20I%20kindly%20ask%20that%20you%20process%20this%20request%20at%20your%20earliest%20convenience%20and%20confirm%20once%20the%20account%20has%20been%20closed%20and%20all%20data%20has%20been%20deleted.%20Thank%20you%20for%20your%20attention%20to%20this%20matter.%20Best%20regards%2C%20xxxxx",
		.difficulty = 0x1000
	},
	{
		.id = 0x69,
		.name = "Anaconda Nucleus",
		.query = "anaconda nucleus",
		.url = "https://anaconda.cloud/profile/privacy-security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a,
		.name = "Ancestry",
		.query = "ancestry",
		.url = "https://www.ancestry.com/account/data/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b,
		.name = "Andaman7",
		.query = "andaman7",
		.url = "https://www.andaman7.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6c,
		.name = "Android File Host (AFH)",
		.query = "android file host afh",
		.url = "https://androidfilehost.com/?w=contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6d,
		.name = "Angelist",
		.query = "angelist",
		.url = "https://angel.co/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e,
		.name = "Anghami",
		.query = "anghami",
		.url = "https://support.anghami.com/hc/en-us/articles/224890447-How-do-I-delete-deactivate-my-account-",
		.email = "mailto:support@anghami.com?subject=Account%20Deletion%20Request",
		.difficulty = 0x800
	},
	{
		.id = 0x6f,
		.name = "AniDB",
		.query = "anidb",
		.url = "https://anidb.net/perl-bin/animedb.pl?show=policies",
		.email = "mailto:info@anidb.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x70,
		.name = "AniList",
		.query = "anilist",
		.url = "https://anilist.co/settings/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x71,
		.name = "Animal Crossing Community",
		.query = "animal crossing community",
		.url = "http://www.animalcrossingcommunity.com/help_main.asp?HelpSectionID=5#Topic201",
		.email = "mailto:support@animalcrossingcommunity.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x72,
		.name = "Anime News Network",
		.query = "anime news network",
		.url = "https://www.animenewsnetwork.com/account/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x73,
		.name = "Anime-Planet",
		.query = "animeplanet",
		.url = "https://www.anime-planet.com/users/delete_account.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x74,
		.name = "Animoto",
		.query = "animoto",
		.url = "https://animoto.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x75,
		.name = "Ankama",
		.query = "ankama",
		.url = "https://support.ankama.com/hc/en-us/requests/new?ticket_form_id=625847",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x76,
		.name = "AnkiApp",
		.query = "ankiapp",
		.url = "https://www.ankiapp.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x77,
		.name = "AnkiWeb",
		.query = "ankiweb",
		.url = "https://ankiweb.net/account/remove-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78,
		.name = "Anti-Captcha",
		.query = "anticaptcha",
		.url = "https://anti-captcha.com/clients/settings/killme",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x79,
		.name = "Any.do",
		.query = "anydo",
		.url = "https://app.any.do/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a,
		.name = "AOL / Instant Messenger",
		.query = "aol instant messenger",
		.url = "https://aol.mydashboard.oath.com/#section-manage",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b,
		.name = "Aparat",
		.query = "aparat",
		.url = "https://www.aparat.com/dashboard/profile/unsubscribe",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c,
		.name = "Apex Minecraft Hosting",
		.query = "apex minecraft hosting",
		.url = "https://billing.apexminecrafthosting.com/submitticket.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7d,
		.name = "Apiary",
		.query = "apiary",
		.url = "https://apiary.io/",
		.email = "mailto:support@apiary.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x7e,
		.name = "APKPure",
		.query = "apkpure",
		.url = "https://apkpure.com/account/destroy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f,
		.name = "Apoia.se",
		.query = "apoiase",
		.url = "https://suporte.apoia.se/hc/pt-br/articles/4408681019547-Como-encerrar-meu-cadastro-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x80,
		.name = "AppJobber",
		.query = "appjobber",
		.url = "https://appjobber.com/profile/delete_account",
		.email = "mailto:datenschutz@appjobber.de",
		.difficulty = 0x400
	},
	{
		.id = 0x81,
		.name = "Apple Account / iTunes",
		.query = "apple account itunes",
		.url = "https://support.apple.com/en-us/HT208504",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x82,
		.name = "Apprentus",
		.query = "apprentus",
		.url = "https://www.apprentus.com/profile/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x83,
		.name = "AppShopper",
		.query = "appshopper",
		.url = "https://appshopper.com/about#contact-form",
		.email = "mailto:support@appshopper.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x84,
		.name = "Appypie",
		.query = "appypie",
		.url = "https://accounts.appypie.com/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x85,
		.name = "Aquaillumination",
		.query = "aquaillumination",
		.url = "https://www.aquaillumination.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x86,
		.name = "ara.cat",
		.query = "aracat",
		.url = "https://www.ara.cat/",
		.email = "mailto:home@ara.cat?subject=Delete%20ARA%20account&body=Please%20delete%20my%20ARA%20account%20which%20was%20registered%20under%20the%20e-mail%3A",
		.difficulty = 0x1000
	},
	{
		.id = 0x87,
		.name = "Arc",
		.query = "arc",
		.url = "https://resources.arc.net/hc/en-us/articles/22351623346327-Delete-My-Arc-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x88,
		.name = "Arc Games",
		.query = "arc games",
		.url = "https://support.arcgames.com/hc/en-us/requests/new",
		.email = "mailto:privacy@gearboxsf.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x89,
		.name = "Arch Linux AUR",
		.query = "arch linux aur",
		.url = "https://aur.archlinux.org/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8a,
		.name = "Arch Linux Forums",
		.query = "arch linux forums",
		.url = "https://aur.archlinux.org/",
		.email = "mailto:forum@archlinux.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x8b,
		.name = "Archipad",
		.query = "archipad",
		.url = "https://cloud.archipad.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8c,
		.name = "Archive of Our Own",
		.query = "archive of our own",
		.url = "https://archiveofourown.org/faq/your-account?language_id=en#deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8d,
		.name = "Arduino",
		.query = "arduino",
		.url = "https://id.arduino.cc/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8e,
		.name = "AREX (Airport Railway Company)",
		.query = "arex airport railway company",
		.url = "https://www.arex.or.kr/user/leaveSite.do",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f,
		.name = "Argos",
		.query = "argos",
		.url = "https://help.argos.co.uk/help/my-account/how-do-i-close-my-online-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x90,
		.name = "Arlo",
		.query = "arlo",
		.url = "https://my.arlo.com/#/settings/privacy/delete-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x91,
		.name = "ArmorGames",
		.query = "armorgames",
		.url = "https://armorgames.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x92,
		.name = "Ars Technica",
		.query = "ars technica",
		.url = "https://arstechnica.com/civis/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x93,
		.name = "Artlist",
		.query = "artlist",
		.url = "https://artlist.io/",
		.email = "mailto:help@art-list.io?subject=Account%20Deletion%20Request&body=Hi%2C%20I%20request%20to%20permanently%20remove%20all%20of%20my%20data%20from%20your%20platform.%20Please%20provide%20an%20update%20on%20the%20process%20via%20this%20email.",
		.difficulty = 0x1000
	},
	{
		.id = 0x94,
		.name = "Artsy",
		.query = "artsy",
		.url = "https://www.artsy.net/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x95,
		.name = "Asana",
		.query = "asana",
		.url = "https://app.asana.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x96,
		.name = "Asda",
		.query = "asda",
		.url = "https://www.asda.com/privacy/contact-us",
		.email = "mailto:dataprotection@asda.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x97,
		.name = "Asgardia.space",
		.query = "asgardiaspace",
		.url = "https://asgardia.space",
		.email = "mailto:support@asgardia.space",
		.difficulty = 0x2000
	},
	{
		.id = 0x98,
		.name = "Ashampoo",
		.query = "ashampoo",
		.url = "https://support.ashampoo.com/hc/en-us/requests/new?ticket_form_id=360003422900",
		.email = "mailto:privacy@ashampoo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x99,
		.name = "Ask.fm",
		.query = "askfm",
		.url = "https://ask.fm/account/settings/optout",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x9a,
		.name = "Asos",
		.query = "asos",
		.url = "https://www.asos.com/customer-care/technical/id-like-to-close-my-account-with-asos-what-should-i-do/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x9b,
		.name = "Assembla",
		.query = "assembla",
		.url = "https://www.assembla.com/user/edit/edit_account_settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x9c,
		.name = "ASUS",
		.query = "asus",
		.url = "https://privacy.asus.com/pi/global/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x9d,
		.name = "ASUS WebStorage",
		.query = "asus webstorage",
		.url = "https://service.asuswebstorage.com/contactus/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x9e,
		.name = "Atavi",
		.query = "atavi",
		.url = "http://atavi.com/user/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x9f,
		.name = "AtCoder",
		.query = "atcoder",
		.url = "https://atcoder.jp/quit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xa0,
		.name = "Aternos",
		.query = "aternos",
		.url = "https://aternos.org/close/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xa1,
		.name = "Athletic Greens",
		.query = "athletic greens",
		.url = "https://ag-privacy.relyance.ai/?mockData=false",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xa2,
		.name = "The Atlantic",
		.query = "the atlantic",
		.url = "https://support.theatlantic.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0xa3,
		.name = "Atlassian / Bitbucket",
		.query = "atlassian bitbucket",
		.url = "https://id.atlassian.com/manage/close-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xa4,
		.name = "Auchan",
		.query = "auchan",
		.url = "https://www.auchan.fr/faq/section/mon-compte-client/mon-compte-auchan-fr?parentNodeId=adf9b2fc-cd05-49df-9833-70766279aea3#anchor_3bea6236-a7b1-4c98-a754-fb04d325831c",
		.email = "mailto:relationclient@auchan.fr?subject=Suppression%20de%20mon%20compte%20Auchan&body=Bonjour%2C%20veuillez%20supprimer%20mon%20compte%20Auchan%20et%20les%20donn%C3%A9es%20personelles%20associ%C3%A9es%20avec%20cette%20adresse%20e-mail.",
		.difficulty = 0x1000
	},
	{
		.id = 0xa5,
		.name = "Audiofanzine",
		.query = "audiofanzine",
		.url = "https://fr.audiofanzine.com/fonctionnalites-audiofanzine/forums/t.759426,supprimer-son-compte.html",
		.email = "mailto:contact@audiofanzine.com",
		.difficulty = 0x800
	},
	{
		.id = 0xa6,
		.name = "Audiomack",
		.query = "audiomack",
		.url = "https://audiomack.com/dashboard#delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xa7,
		.name = "Augment",
		.query = "augment",
		.url = "https://help.augment.com/en/articles/4103227-account-deletion",
		.email = "mailto:gdpr@augment.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xa8,
		.name = "AulaFacil",
		.query = "aulafacil",
		.url = "https://usuarios.aulafacil.com/usuarios/miPerfil",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xa9,
		.name = "Auth0",
		.query = "auth0",
		.url = "https://community.auth0.com/t/how-can-i-delete-my-auth0-auth0-community-forum-account/34689",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xaa,
		.name = "Author.today",
		.query = "authortoday",
		.url = "https://help.author.today/knowledge_base/item/268554?sid=58980",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0xab,
		.name = "Authy",
		.query = "authy",
		.url = "https://authy.com/account/delete/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xac,
		.name = "Autodesk",
		.query = "autodesk",
		.url = "https://accounts.autodesk.com/Profile/Security",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xad,
		.name = "AutoScout24",
		.query = "autoscout24",
		.url = "https://accounts.autoscout24.com/Delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xae,
		.name = "AutoWebSurf",
		.query = "autowebsurf",
		.url = "https://autowebsurf.com/members/delete.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xaf,
		.name = "Autozis",
		.query = "autozis",
		.url = "https://autozis.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb0,
		.name = "AV Club",
		.query = "av club",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xb1,
		.name = "Avast!",
		.query = "avast",
		.url = "https://profile.avast.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb2,
		.name = "AVEN",
		.query = "aven",
		.url = "https://www.asexuality.org/en/topic/68514-deleting-account/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xb3,
		.name = "AVG",
		.query = "avg",
		.url = "https://profile.avg.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb4,
		.name = "Avira",
		.query = "avira",
		.url = "https://support.avira.com/hc/en-us/articles/360000753557--How-can-I-delete-my-Avira-account",
		.email = "mailto:support@avira.com",
		.difficulty = 0x400
	},
	{
		.id = 0xb5,
		.name = "Avito",
		.query = "avito",
		.url = "https://www.avito.ru/profile/settings/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb6,
		.name = "Avocadostore",
		.query = "avocadostore",
		.url = "https://support.avocadostore.de/hc/de/articles/11339106472466-Wie-kann-ich-mein-Benutzerkonto-l%C3%B6schen",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xb7,
		.name = "AwardWallet",
		.query = "awardwallet",
		.url = "https://awardwallet.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb8,
		.name = "Axent Host",
		.query = "axent host",
		.url = "https://app.axenthost.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xb9,
		.name = "Axios",
		.query = "axios",
		.url = "https://www.axios.com/legal",
		.email = "mailto:privacy@axios.com",
		.difficulty = 0x4000
	},
	{
		.id = 0xba,
		.name = "AXS",
		.query = "axs",
		.url = "https://support.axs.com/hc/en-gb/articles/360017655079-Can-you-delete-my-data-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xbb,
		.name = "AZMVDNOW",
		.query = "azmvdnow",
		.url = "https://azmvdnow.gov/customers/useraccount/disable",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0xbc,
		.name = "AZQuotes",
		.query = "azquotes",
		.url = "https://www.azquotes.com/contacts.html",
		.email = "mailto:webmaster@azquotes.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xbd,
		.name = "B&H",
		.query = "bh",
		.url = "https://www.bhphotovideo.com/find/HelpCenter/PrivacySecurity.jsp",
		.email = "mailto:privacy@bhphoto.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20B%26H%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0xbe,
		.name = "Babbel",
		.query = "babbel",
		.url = "https://home.babbel.com/user-profile/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xbf,
		.name = "Baby Names",
		.query = "baby names",
		.url = "https://babynames.com/user/close.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xc0,
		.name = "BabyCenter",
		.query = "babycenter",
		.url = "https://dsar.babycenter.com/",
		.email = "mailto:privacy_babycenter@everydayhealth.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xc1,
		.name = "back4app",
		.query = "back4app",
		.url = "https://help.back4app.com/hc/en-us/articles/4423268883597",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xc2,
		.name = "Backblaze",
		.query = "backblaze",
		.url = "https://secure.backblaze.com/account_settings.htm",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xc3,
		.name = "Badlion",
		.query = "badlion",
		.url = "https://www.badlion.net/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xc4,
		.name = "Badoo",
		.query = "badoo",
		.url = "https://badoo.com/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xc5,
		.name = "Baidu",
		.query = "baidu",
		.url = "https://passport.baidu.com/v6/cancelAccount",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xc6,
		.name = "Balance",
		.query = "balance",
		.url = "https://balanceapp.com/balance-privacy",
		.email = "mailto:privacy@balanceapp.com?subject=Account%20Information%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0xc7,
		.name = "Bambuser",
		.query = "bambuser",
		.url = "https://bambuser.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xc8,
		.name = "Bandcamp",
		.query = "bandcamp",
		.url = "https://bandcamp.com/settings?pane=fan",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xc9,
		.name = "Bangumi",
		.query = "bangumi",
		.url = "https://bgm.tv/group/forum",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xca,
		.name = "Barnes & Noble",
		.query = "barnes noble",
		.url = "https://www.barnesandnoble.com/account/manage/settings/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xcb,
		.name = "Basecamp",
		.query = "basecamp",
		.url = "https://3.basecamp-help.com/article/156-cancel-your-basecamp-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xcc,
		.name = "Basicversity",
		.query = "basicversity",
		.url = "https://basicversity.com/privacy.php#:~:text=If%20you%20have%20questions%20about%20accessing%20or%20correcting%20your%20personal%20data%20please%20send%20an%20email%20to%20simpleversity%20At%20gmail.com.",
		.email = "mailto:simpleversity@gmail.com",
		.difficulty = 0x2000
	},
	{
		.id = 0xcd,
		.name = "Basilica di San Pietro",
		.query = "basilica di san pietro",
		.url = "https://www.basilicasanpietro.va",
		.email = "mailto:privacy@fsp.va?subject=PERSONAL%20DATA.&body=Please%20delete%20the%20account%20associated%20with%20my%20e-mail%2C%20YOUR_EMAIL%2C%20and%20all%20its%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0xce,
		.name = "Basin",
		.query = "basin",
		.url = "https://usebasin.com/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xcf,
		.name = "Bato.to",
		.query = "batoto",
		.url = "https://bato.to/account/deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd0,
		.name = "Battle.net / Blizzard",
		.query = "battlenet blizzard",
		.url = "https://eu.battle.net/support/en/article/2659",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xd1,
		.name = "BBC",
		.query = "bbc",
		.url = "https://account.bbc.com/account/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd2,
		.name = "Be Welcome",
		.query = "be welcome",
		.url = "https://www.bewelcome.org/deleteprofile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd3,
		.name = "Beacons",
		.query = "beacons",
		.url = "https://account.beacons.ai/account-settings/home/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd4,
		.name = "BeamNG",
		.query = "beamng",
		.url = "https://support.beamng.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xd5,
		.name = "Bearblog",
		.query = "bearblog",
		.url = "https://bearblog.dev/accounts/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd6,
		.name = "Beatport",
		.query = "beatport",
		.url = "https://support.beatport.com/hc/en-us/articles/4412533928596-How-can-I-close-my-account-",
		.email = "mailto:support@beatport.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xd7,
		.name = "beecrowd (for talents)",
		.query = "beecrowd for talents",
		.url = "https://judge.beecrowd.com/en/users/deactivate?utm_source=judge&utm_medium=page&utm_campaign=deactivate",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xd8,
		.name = "Beeper",
		.query = "beeper",
		.url = "https://chat.beeper.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xd9,
		.name = "Behance",
		.query = "behance",
		.url = "https://help.behance.net/hc/en-us/articles/204484854-How-do-I-delete-cancel-my-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xda,
		.name = "BeMyEye",
		.query = "bemyeye",
		.url = "https://bemyeye.zendesk.com/hc/en-us/articles/360009596613-How-do-I-delete-my-account-",
		.email = "mailto:support@bemyeye.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xdb,
		.name = "Benfeitoria",
		.query = "benfeitoria",
		.url = "https://benfeitoria.com/restrito/conta/deletar-conta",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xdc,
		.name = "BeReal",
		.query = "bereal",
		.url = "https://help.bereal.com/hc/articles/7531255012381",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xdd,
		.name = "Bergzeit",
		.query = "bergzeit",
		.url = "https://www.bergzeit.de/help-contact/?folderId=15000009413&articleId=15000056460",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xde,
		.name = "BerryByte",
		.query = "berrybyte",
		.url = "https://billing.berrybyte.net/submitticket.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xdf,
		.name = "Best Buy",
		.query = "best buy",
		.url = "https://www.bestbuy.com/sentry/confirm/residency?context=ca&type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xe0,
		.name = "Best Buy Canada",
		.query = "best buy canada",
		.url = "https://cloudpage.bestbuypromotions.ca/privacy-request",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xe1,
		.name = "bet365",
		.query = "bet365",
		.url = "https://help.bet365.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xe2,
		.name = "Betano",
		.query = "betano",
		.url = "https://betano.com/myaccount/profile/protection",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xe3,
		.name = "Bethesda",
		.query = "bethesda",
		.url = "https://help.bethesda.net/app/incident10/?prod=711&cat=1220",
		.email = "mailto:privacy@support.zenimax.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xe4,
		.name = "Betnacional",
		.query = "betnacional",
		.url = "https://assets.bet6.com.br/sistemans/skins/betnacional/doc/5eef829d8f.pdf",
		.email = "mailto:contato@betnacional.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xe5,
		.name = "Betterment",
		.query = "betterment",
		.url = "https://www.betterment.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0xe6,
		.name = "BeyondMenu",
		.query = "beyondmenu",
		.url = "https://www.beyondmenu.com/manageaccount.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xe7,
		.name = "Bidoo",
		.query = "bidoo",
		.url = "https://it.bidoo.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xe8,
		.name = "Bigstock",
		.query = "bigstock",
		.url = "https://support.bigstockphoto.com/s/article/How-do-I-close-my-Bigstock-contributor-account",
		.email = "mailto:support@bigstockphoto.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xe9,
		.name = "Bikemap",
		.query = "bikemap",
		.url = "https://www.bikemap.net/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xea,
		.name = "Biletyna",
		.query = "biletyna",
		.url = "https://biletyna.pl/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xeb,
		.name = "Bilibili",
		.query = "bilibili",
		.url = "https://passport.bilibili.com/register/logout.html",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xec,
		.name = "Binance",
		.query = "binance",
		.url = "https://www.binance.com/en/my/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xed,
		.name = "Bingebase",
		.query = "bingebase",
		.url = "https://bingebase.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xee,
		.name = "BingX",
		.query = "bingx",
		.url = "https://bingx.com/removeAccount/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xef,
		.name = "BioParque Pantanal",
		.query = "bioparque pantanal",
		.url = "https://agendamentobioparquepantanal.ms.gov.br/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xf0,
		.name = "Bird",
		.query = "bird",
		.url = "https://help.bird.co/hc/en-us/articles/360044088811-I-need-to-delete-my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xf1,
		.name = "Bitdefender Central",
		.query = "bitdefender central",
		.url = "https://account.bitdefender.com/delete_account/info",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xf2,
		.name = "Bitfinex",
		.query = "bitfinex",
		.url = "https://support.bitfinex.com/hc/en-us/articles/115002403694",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0xf3,
		.name = "BitLaunch",
		.query = "bitlaunch",
		.url = "https://app.bitlaunch.io/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xf4,
		.name = "Bitly",
		.query = "bitly",
		.url = "https://app.bitly.com/settings/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xf5,
		.name = "Bitstamp",
		.query = "bitstamp",
		.url = "https://www.bitstamp.net/settings/deactivate/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xf6,
		.name = "Bittrex",
		.query = "bittrex",
		.url = "https://bittrex.zendesk.com/hc/en-us/requests/new?ticket_form_id=114093958171",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xf7,
		.name = "Bitwarden",
		.query = "bitwarden",
		.url = "https://bitwarden.com/help/article/delete-your-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xf8,
		.name = "Bkool",
		.query = "bkool",
		.url = "https://support.bkool.com/hc/en-us/articles/360024682171-Privacy-policy",
		.email = "mailto:dpo@bkool.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xf9,
		.name = "BlackBox",
		.query = "blackbox",
		.url = "https://www.blackbox.global/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xfa,
		.name = "BlackSpigot",
		.query = "blackspigot",
		.url = "https://blackspigot.com/threads/delete-account.9291/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0xfb,
		.name = "Bleep",
		.query = "bleep",
		.url = "https://bleep.com/account/show",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0xfc,
		.name = "BlendSwap",
		.query = "blendswap",
		.url = "https://blendswap.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0xfd,
		.name = "Blind",
		.query = "blind",
		.url = "https://www.teamblind.com/faqs",
		.email = "mailto:blindapp@teamblind.com",
		.difficulty = 0x1000
	},
	{
		.id = 0xfe,
		.name = "Blinkee",
		.query = "blinkee",
		.url = "https://blinkee.city/en-pl/faq",
		.email = "mailto:contact.pl@blinkee.city",
		.difficulty = 0x1000
	},
	{
		.id = 0xff,
		.name = "Blinkist",
		.query = "blinkist",
		.url = "https://www.blinkist.com/nc/settings/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x100,
		.name = "Blogger",
		.query = "blogger",
		.url = "https://support.google.com/blogger/answer/41932",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x101,
		.name = "Blooket",
		.query = "blooket",
		.url = "https://id.blooket.com/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x102,
		.name = "Bloomberg",
		.query = "bloomberg",
		.url = "https://www.bloomberg.com/notices/tos/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x103,
		.name = "Bloomingdales",
		.query = "bloomingdales",
		.url = "https://customerservice-bloomingdales.com/articles/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x104,
		.name = "Blue Apron",
		.query = "blue apron",
		.url = "https://www.blueapron.com/cancel_subscription",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x105,
		.name = "Bluebird by American Express",
		.query = "bluebird by american express",
		.url = "https://secure.bluebird.com/manage/settings/ProfileSettings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x106,
		.name = "Bluejeans",
		.query = "bluejeans",
		.url = "https://support.bluejeans.com/s/contactsupport",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x107,
		.name = "Bluesky",
		.query = "bluesky",
		.url = "https://bsky.app/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x108,
		.name = "Board Game Arena",
		.query = "board game arena",
		.url = "https://boardgamearena.com/preferences?section=account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x109,
		.name = "Board Games Online",
		.query = "board games online",
		.url = "https://boardgamesonline.net/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x10a,
		.name = "BoardGameGeek",
		.query = "boardgamegeek",
		.url = "https://boardgamegeek.com/geekaccount.php?action=requestdeletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x10b,
		.name = "bobatea",
		.query = "bobatea",
		.url = "https://git.boba.best/user/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x10c,
		.name = "BodBot",
		.query = "bodbot",
		.url = "https://www.bodbot.com/Account_Settings.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x10d,
		.name = "Bodybuilding",
		.query = "bodybuilding",
		.url = "https://www.bodybuilding.com/help?account-inquiries&deactivate-account",
		.email = "mailto:privacy@bodybuilding.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x10e,
		.name = "Boeing",
		.query = "boeing",
		.url = "https://privacyportal.onetrust.com/webform/7a02e6ee-4433-4d2d-b133-66ab66311d80/7fda90ac-fe12-4a4b-a816-4cb09137423d.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x10f,
		.name = "Bohemia Interactive",
		.query = "bohemia interactive",
		.url = "https://support.bohemia.net/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x110,
		.name = "Boingo Wireless",
		.query = "boingo wireless",
		.url = "https://support.boingo.com/s/contactsupport",
		.email = "mailto:support@boingo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x111,
		.name = "Bol.com",
		.query = "bolcom",
		.url = "https://www.bol.com/nl/rnwy/account/privacy/delete",
		.email = "mailto:dpo@aholddelhaize.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x112,
		.name = "Bolt",
		.query = "bolt",
		.url = "https://bolt.eu/en/support/articles/360000336273/",
		.email = "mailto:privacy@bolt.eu",
		.difficulty = 0x1000
	},
	{
		.id = 0x113,
		.name = "Bolt Driver",
		.query = "bolt driver",
		.url = "https://bolt.eu/en/support/articles/360000329553/",
		.email = "mailto:privacy@bolt.eu",
		.difficulty = 0x1000
	},
	{
		.id = 0x114,
		.name = "Bolt Food",
		.query = "bolt food",
		.url = "https://bolt.eu/en/support/articles/360007153180/",
		.email = "mailto:privacy@bolt.eu",
		.difficulty = 0x1000
	},
	{
		.id = 0x115,
		.name = "Bones Coffee Company",
		.query = "bones coffee company",
		.url = "https://www.bonescoffee.com/pages/contact-us",
		.email = "mailto:Support@BonesCoffee.com ",
		.difficulty = 0x1000
	},
	{
		.id = 0x116,
		.name = "BookBub",
		.query = "bookbub",
		.url = "https://www.bookbub.com/contact/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x117,
		.name = "Booking",
		.query = "booking",
		.url = "https://secure.booking.com/login.en-us.html?tmpl=profile/delete_account",
		.email = "mailto:privacyrequests@booking.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x118,
		.name = "Booklooker",
		.query = "booklooker",
		.url = "https://secure.booklooker.de/pages/contact.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x119,
		.name = "Bookmark OS",
		.query = "bookmark os",
		.url = "https://bookmarkos.com/privacy_policy",
		.email = "mailto:dave@bookmarkos.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x11a,
		.name = "Boostcamp",
		.query = "boostcamp",
		.url = "https://www.boostcamp.app/data-deletion-request",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x11b,
		.name = "BOOTH",
		.query = "booth",
		.url = "https://accounts.booth.pm/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x11c,
		.name = "Boots Viewpoint",
		.query = "boots viewpoint",
		.url = "https://www.bootsviewpoint.co.uk",
		.email = "mailto:claire@bootsviewpoint.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x11d,
		.name = "BorgBase",
		.query = "borgbase",
		.url = "https://www.borgbase.com/account?tab=profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x11e,
		.name = "Borussia Dortmund",
		.query = "borussia dortmund",
		.url = "https://account.bvb.de/s/",
		.email = "mailto:datenschutz@bvb.de?subject=Datenl%C3%B6schung%20gem%C3%A4%C3%9F%20DSGVO&body=Guten%20Tag%2C%0A%0ABitte%20l%C3%B6schen%20Sie%20gem%C3%A4%C3%9F%20DSGVO%20den%20Account%20und%20die%20Daten%20f%C3%BCr%20den%20Account%20mit%20der%20E-Mail%20Adresse%3A%20XXX%0A%0AVielen%20Dank%20und%20mit%20freundlichen%20Gr%C3%BC%C3%9Fen.",
		.difficulty = 0x1000
	},
	{
		.id = 0x11f,
		.name = "Boulanger",
		.query = "boulanger",
		.url = "https://www.boulanger.com/evenement/infos-legales#ong-private",
		.email = "mailto:cil@boulanger.com?subject=Account%20deletion%20request&body=Please%20delete%20the%20account%20associated%20with%20my%20e-mail%2C%20YOUR_EMAIL%2C%20and%20all%20its%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x120,
		.name = "Bountysource",
		.query = "bountysource",
		.url = "https://github.com/bountysource/core/issues/409",
		.email = "mailto:support@bountysource.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x121,
		.name = "Box",
		.query = "box",
		.url = "https://app.box.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x122,
		.name = "Boxcryptor",
		.query = "boxcryptor",
		.url = "https://www.boxcryptor.com/app/account/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x123,
		.name = "Braiins",
		.query = "braiins",
		.url = "https://help.braiins.com/en/support/solutions/articles/77000434063-how-can-i-delete-my-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x124,
		.name = "Brain.fm",
		.query = "brainfm",
		.url = "https://www.brain.fm/privacy",
		.email = "mailto:privacy@brain.fm?subject=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x125,
		.name = "Braintrust",
		.query = "braintrust",
		.url = "https://app.usebraintrust.com/settings/privacy_security/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x126,
		.name = "Brandpad",
		.query = "brandpad",
		.url = "https://create.brandpad.io/account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x127,
		.name = "Brevo",
		.query = "brevo",
		.url = "https://app.brevo.com/settings/advanced",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x128,
		.name = "Brilliant",
		.query = "brilliant",
		.url = "https://brilliant.org/account/settings/deactivate/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x129,
		.name = "Bring!",
		.query = "bring",
		.url = "https://go.getbring.com/?link=https%3A%2F%2Fdeeplink.getbring.com%2Fview%2Fdeleteaccount&apn=ch.publisheria.bring&isi=580669177&ibi=ch.publisheria.bring",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x12a,
		.name = "British Airways",
		.query = "british airways",
		.url = "https://naprepin.custhelp.com/app/answers/detail/a_id/770/~/cancelling-your-executive-club-membership",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x12b,
		.name = "Broadcom Support",
		.query = "broadcom support",
		.url = "https://knowledge.broadcom.com/external/article/368293/deleting-or-removing-broadcom-support-ac.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x12c,
		.name = "BrowserStack",
		.query = "browserstack",
		.url = "https://www.browserstack.com/accounts/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x12d,
		.name = "Brut",
		.query = "brut",
		.url = "https://www.brut.media/us/terms",
		.email = "mailto:support-web@brut.media",
		.difficulty = 0x1000
	},
	{
		.id = 0x12e,
		.name = "BrutX",
		.query = "brutx",
		.url = "https://help.brutx.com/hc/fr/articles/360020090299",
		.email = "mailto:bonjour@brutx.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x12f,
		.name = "Bruun-rasmussen.dk",
		.query = "bruunrasmussendk",
		.url = "https://bruun-rasmussen.dk/m/about/privacy",
		.email = "mailto:privacy@bruun-rasmussen.dk?subject=Request%20for%20the%20deletion%20of%20personal%20information&body=I%20would%20like%20to%20request%20the%20deletion%20of%20my%20personal%20information%20as%20allowed%20per%20your%20privacy%20policy.%20My%20customer%20number%20is%20XXXXXXX.%20Thank%20you",
		.difficulty = 0x1000
	},
	{
		.id = 0x130,
		.name = "Bubbl.us",
		.query = "bubblus",
		.url = "https://help.bubbl.us/article/110-remove-my-account",
		.email = "mailto:support@bubbl.us",
		.difficulty = 0x1000
	},
	{
		.id = 0x131,
		.name = "Buddy UniCredit",
		.query = "buddy unicredit",
		.url = "https://www.buddyunicredit.it",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x132,
		.name = "Buffer",
		.query = "buffer",
		.url = "https://bufferapp.com/app/account/leave",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x133,
		.name = "Builder.io",
		.query = "builderio",
		.url = "https://builder.io/spaces",
		.email = "mailto:support@builder.io?subject=Account%20Deletion%20Request%20and%20Data%20Erasure&body=Dear%20Builder.io%20Support%20Team%2C%20I%20am%20requesting%20the%20deletion%20of%20my%20account%20and%20all%20associated%20personal%20data%20in%20accordance%20with%20your%20Privacy%20Policy%20and%20GDPR.%20Below%20are%20my%20account%20details%3A%20Account%20Email%3A%20XXXX%20Account%20Name%3A%20XXXX%20Please%20ensure%20the%20permanent%20removal%20of%20my%20data%20from%20your%20systems%20and%20any%20third-party%20services.%20Kindly%20confirm%20once%20this%20has%20been%20completed.",
		.difficulty = 0x1000
	},
	{
		.id = 0x134,
		.name = "Buildspace",
		.query = "buildspace",
		.url = "https://buildspace.so",
		.email = "mailto:support@buildspace.so?subject=Account%20Delection%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x135,
		.name = "BuiltByBit",
		.query = "builtbybit",
		.url = "https://builtbybit.com/account/removal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x136,
		.name = "Bukalapak",
		.query = "bukalapak",
		.url = "https://www.bukalapak.com",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x137,
		.name = "Bukkit",
		.query = "bukkit",
		.url = "https://bukkit.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x138,
		.name = "Bungie.net",
		.query = "bungienet",
		.url = "https://help.bungie.net/hc/requests/new",
		.email = "mailto:privacyrequests@bungie.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x139,
		.name = "BurstNET",
		.query = "burstnet",
		.url = "http://burst.net",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x13a,
		.name = "Buser",
		.query = "buser",
		.url = "https://www.buser.com.br/ajuda/conta-e-dados",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x13b,
		.name = "Busuu",
		.query = "busuu",
		.url = "https://www.busuu.com/dashboard#/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x13c,
		.name = "Buy Me a Coffee",
		.query = "buy me a coffee",
		.url = "https://www.buymeacoffee.com/terms",
		.email = "mailto:support@buymeacoffee.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x13d,
		.name = "Buycott",
		.query = "buycott",
		.url = "https://www.buycott.com",
		.email = "mailto:info@buycott.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x13e,
		.name = "Buycraft",
		.query = "buycraft",
		.url = "https://server.tebex.io",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x13f,
		.name = "ByDoor",
		.query = "bydoor",
		.url = "https://portal.bydoor.com/meusdados",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x140,
		.name = "C&M News by Rеss.at",
		.query = "cm news by rеssat",
		.url = "https://ress.at/profil/profil_entfernen.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x141,
		.name = "CA Cert",
		.query = "ca cert",
		.url = "http://wiki.cacert.org/FAQ/AccountRemoval",
		.email = "mailto:support@cacert.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x142,
		.name = "Cabify",
		.query = "cabify",
		.url = "https://cabify.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x143,
		.name = "Cacoo",
		.query = "cacoo",
		.url = "https://cacoo.com/unsubscribe",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x144,
		.name = "CafePress",
		.query = "cafepress",
		.url = "https://www.cafepress.com/account/close-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x145,
		.name = "CakeReader",
		.query = "cakereader",
		.url = "https://cakereader.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x146,
		.name = "Call of Duty Mobile",
		.query = "call of duty mobile",
		.url = "https://support.activision.com/privacy",
		.email = "mailto:privacy@activision.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x147,
		.name = "Calligraphr",
		.query = "calligraphr",
		.url = "https://www.calligraphr.com/en/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x148,
		.name = "CamelCamelCamel",
		.query = "camelcamelcamel",
		.url = "https://camelcamelcamel.com/close_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x149,
		.name = "CamScanner",
		.query = "camscanner",
		.url = "https://www.camscanner.com/",
		.email = "mailto:support@camscanner.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x14a,
		.name = "Canva",
		.query = "canva",
		.url = "https://www.canva.com/settings/login-and-security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x14b,
		.name = "Capcut",
		.query = "capcut",
		.url = "https://www.capcut.com/settings?current_page=landing_page&enter_from=click_view_personal_page&from_page=personal_page&start_tab=video&settings_tab=info_page",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x14c,
		.name = "Capsule",
		.query = "capsule",
		.url = "https://www.capsule.com/privacy",
		.email = "mailto:privacy@capsule.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x14d,
		.name = "Captain.tv",
		.query = "captaintv",
		.url = "https://streamcaptain.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x14e,
		.name = "Car2Go",
		.query = "car2go",
		.url = "https://www.car2go.com/US/en/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x14f,
		.name = "Carbonmade",
		.query = "carbonmade",
		.url = "https://carbonmade.app/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x150,
		.name = "CardCastle",
		.query = "cardcastle",
		.url = "https://cardcastle.co/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x151,
		.name = "CareerBuilder.com",
		.query = "careerbuildercom",
		.url = "https://www.careerbuilder.com/User/UserConfirmation.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x152,
		.name = "Carrd.co",
		.query = "carrdco",
		.url = "https://carrd.co/dashboard/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x153,
		.name = "Cars Région Isère",
		.query = "cars region isere",
		.url = "https://carsisere.auvergnerhonealpes.fr/fr/mon-espace/159/Member/editprofile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x154,
		.name = "Cars Région Savoie / Altibus",
		.query = "cars region savoie altibus",
		.url = "https://www.cars-region-savoie.fr/suggestions-reclamations/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x155,
		.name = "Cash'em All",
		.query = "cashem all",
		.url = "https://cashemall.online/legal/v1/privacy/online.cashemall.app",
		.email = "mailto:contact@cashemall.online",
		.difficulty = 0x800
	},
	{
		.id = 0x156,
		.name = "Cash'em All Web",
		.query = "cashem all web",
		.url = "https://cashem-all.com/profile",
		.email = "mailto:contact@appstation.online",
		.difficulty = 0x800
	},
	{
		.id = 0x157,
		.name = "Castbox",
		.query = "castbox",
		.url = "https://helpcenter.castbox.fm/portal/en/kb/articles/delete-account",
		.email = "mailto:contact@castbox.fm?body=Please%20delete%20my%20account.%20I%20use%20XXX%20to%20sign%20in.%20My%20email%20address%20is%20XXX.",
		.difficulty = 0x1000
	},
	{
		.id = 0x158,
		.name = "Catappult ",
		.query = "catappult",
		.url = "https://developers.catappult.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x159,
		.name = "Catawiki",
		.query = "catawiki",
		.url = "https://www.catawiki.com/en/accounts/pre_delete_account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x15a,
		.name = "CATME",
		.query = "catme",
		.url = "https://info.catme.org/student-faq/can-i-delete-my-student-account/",
		.email = "mailto:support@catme.org",
		.difficulty = 0x2000
	},
	{
		.id = 0x15b,
		.name = "CBC",
		.query = "cbc",
		.url = "https://cbchelp.cbc.ca/hc/en-ca/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x15c,
		.name = "CCMA (TV3 i CatRàdio)",
		.query = "ccma tv3 i catradio",
		.url = "https://registreusuari.ccma.cat/usuaris/baixa",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x15d,
		.name = "cda",
		.query = "cda",
		.url = "https://www.cda.pl/kontakt",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x15e,
		.name = "CDEK Forward",
		.query = "cdek forward",
		.url = "https://global.cdek.ru",
		.email = "mailto:mf@cdek.ru?subject=%D0%A3%D0%B4%D0%B0%D0%BB%D0%B5%D0%BD%D0%B8%D0%B5%20%D0%B0%D0%BA%D0%BA%D0%B0%D1%83%D0%BD%D1%82%D0%B0&body=%D0%97%D0%B4%D1%80%D0%B0%D0%B2%D1%81%D1%82%D0%B2%D1%83%D0%B9%D1%82%D0%B5.%20%D0%9F%D0%BE%D0%B6%D0%B0%D0%BB%D1%83%D0%B9%D1%81%D1%82%D0%B0%2C%20%D1%83%D0%B4%D0%B0%D0%BB%D0%B8%D1%82%D0%B5%20%D0%BC%D0%BE%D0%B9%20%D0%B0%D0%BA%D0%BA%D0%B0%D1%83%D0%BD%D1%82%20%D0%BD%D0%B0%20CDEK%20Forward.",
		.difficulty = 0x1000
	},
	{
		.id = 0x15f,
		.name = "CDKeys",
		.query = "cdkeys",
		.url = "https://www.cdkeys.com/user/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x160,
		.name = "CDON.COM",
		.query = "cdoncom",
		.url = "https://help.cdon.com/hc/sv/articles/360022459751-Hur-tar-jag-bort-mitt-konto-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x161,
		.name = "CEEOL",
		.query = "ceeol",
		.url = "https://www.cdkeys.com/user/profile/",
		.email = "mailto:info@ceeol.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x162,
		.name = "Celcoin",
		.query = "celcoin",
		.url = "https://celcoin.com.br",
		.email = "mailto:contato@celcoin.com.br",
		.difficulty = 0x1000
	},
	{
		.id = 0x163,
		.name = "celio",
		.query = "celio",
		.url = "https://www.celio.com/fr-fr/contactus",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x164,
		.name = "Cengage",
		.query = "cengage",
		.url = "https://cengage.my.site.com/s/rtbf",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x165,
		.name = "Certiport",
		.query = "certiport",
		.url = "https://www.certiport.com/portal/Pages/ModifyProfile.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x166,
		.name = "CEX.IO",
		.query = "cexio",
		.url = "https://support.cex.io/",
		.email = "mailto:support@cex.io?subject=Delete%20Account",
		.difficulty = 0x1000
	},
	{
		.id = 0x167,
		.name = "Cfx.re",
		.query = "cfxre",
		.url = "https://support.cfx.re/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x168,
		.name = "cgtrader",
		.query = "cgtrader",
		.url = "https://help.cgtrader.com/hc/en-us/articles/4402420280081-How-can-I-delete-my-account-",
		.email = "mailto:support@cgtrader.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x169,
		.name = "Challonge",
		.query = "challonge",
		.url = "https://challonge.com/settings/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x16a,
		.name = "Chamonix Mobilité",
		.query = "chamonix mobilite",
		.url = "https://www.chamonix-mobilite.com/en/nous-contacter",
		.email = "mailto:assistance@secureticket.fr?subject=Suppression%20de%20compte&body=%20Je%20demande%20la%20suppression%20de%20mon%20compte%20Chamonix%20Mobilit%C3%A9",
		.difficulty = 0x1000
	},
	{
		.id = 0x16b,
		.name = "Change.org",
		.query = "changeorg",
		.url = "https://www.change.org/policies/privacy",
		.email = "mailto:help@change.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x16c,
		.name = "ChangeIP",
		.query = "changeip",
		.url = "https://www.changeip.com/tos.php#:~:text=Account%20Cancellation",
		.email = "mailto:support@changeip.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x16d,
		.name = "changelly",
		.query = "changelly",
		.url = "https://changelly.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x16e,
		.name = "character.ai",
		.query = "characterai",
		.url = "https://beta.character.ai/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x16f,
		.name = "ChatForma",
		.query = "chatforma",
		.url = "https://www.chatforma.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x170,
		.name = "Cheap Ass Gamer",
		.query = "cheap ass gamer",
		.url = "https://www.cheapassgamer.com/index.php?app=core&module=help&do=01&HID=15",
		.email = "mailto:cheapyd@cheapassgamer.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x171,
		.name = "Check24 Deutschland",
		.query = "check24 deutschland",
		.url = "https://kundenbereich.check24.de/user/account/data.html",
		.email = "mailto:datenloeschung@check24.de?subject=Vollst%C3%A4ndige%20L%C3%B6schung%20meiner%20Daten&body=Sehr%20geehrte%20Damen%20und%20Herren%2C%20ich%20habe%20vor%20kurzem%20mein%20CHECK24-Konto%20gel%C3%B6scht.%20Ich%20bitte%20Sie%20jedoch%2C%20sicherzustellen%2C%20dass%20alle%20meine%20Daten%20vollst%C3%A4ndig%20aus%20dem%20System%20von%20CHECK24%20sowie%20aus%20dem%20gesamten%20Verbund%20entfernt%20werden.%20Die%20betreffende%20E-Mail-Adresse%20lautet%3A%20%27your.mail%40address.tld%27%20Ich%20danke%20Ihnen%20im%20Voraus%20f%C3%BCr%20Ihre%20Unterst%C3%BCtzung%20und%20bitte%20um%20eine%20Best%C3%A4tigung%20der%20L%C3%B6schung.%20Mit%20freundlichen%20Gr%C3%BC%C3%9Fen%20%27Your%20name%27",
		.difficulty = 0x1000
	},
	{
		.id = 0x172,
		.name = "Checklist",
		.query = "checklist",
		.url = "https://api.checklist.com/account/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x173,
		.name = "Checksub",
		.query = "checksub",
		.url = "https://www.checksub.com",
		.email = "mailto:team@checksub.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x174,
		.name = "Cheezburger",
		.query = "cheezburger",
		.url = "https://cheezburgernetwork.wordpress.com/faq/#q14",
		.email = "mailto:contactus@cheezburger.com?subject=Request%20to%20delete%20account&body=Please%20delete%20my%20Cheezburger%20account%20with%20username%20XXXX%20and%20e-mail%20XXXX%2C%20the%20reason%20for%20my%20request%20is%20XXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x175,
		.name = "Chegg",
		.query = "chegg",
		.url = "https://www.chegg.com/contactus",
		.email = "mailto:closemyaccount@chegg.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x176,
		.name = "Chemaxon",
		.query = "chemaxon",
		.url = "https://account.chemaxon.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x177,
		.name = "Chess Tempo",
		.query = "chess tempo",
		.url = "https://www.chesstempo.com/privacy#",
		.email = "mailto:privacy@chesstempo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x178,
		.name = "Chess.com",
		.query = "chesscom",
		.url = "https://www.chess.com/my-data",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x179,
		.name = "Chessable",
		.query = "chessable",
		.url = "https://www.chessable.com/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17a,
		.name = "Chessbase",
		.query = "chessbase",
		.url = "https://account.chessbase.com/en/me/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17b,
		.name = "Chessfactor",
		.query = "chessfactor",
		.url = "https://www.chessfactor.com/accounts/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17c,
		.name = "Chesspuzzle.net",
		.query = "chesspuzzlenet",
		.url = "https://chesspuzzle.net/Manage/RequestDeletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17d,
		.name = "Chessvision.ai (eBook Reader)",
		.query = "chessvisionai ebook reader",
		.url = "https://ebook.chessvision.ai/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17e,
		.name = "Chessvision.ai (Scanner/Library)",
		.query = "chessvisionai scannerlibrary",
		.url = "https://my.chessvision.ai/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x17f,
		.name = "Chewy",
		.query = "chewy",
		.url = "https://www.chewy.com/app/account/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x180,
		.name = "Chick-fil-A",
		.query = "chickfila",
		.url = "https://privacyportal.onetrust.com/webform/63dc78c7-5612-4181-beae-47dead0569ee/01252c81-82df-4db5-9cb8-bf23a62a9a55",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x181,
		.name = "Chocolatey",
		.query = "chocolatey",
		.url = "https://chocolatey.org/contact/general",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x182,
		.name = "Cineplex",
		.query = "cineplex",
		.url = "https://www.cineplex.com/Global/PrivacyPolicy",
		.email = "mailto:privacy@cineplex.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x183,
		.name = "CircleCI",
		.query = "circleci",
		.url = "https://privacy.circleci.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x184,
		.name = "Cisco",
		.query = "cisco",
		.url = "https://privacyrequest.cisco.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x185,
		.name = "Citadel Servers",
		.query = "citadel servers",
		.url = "https://citadelservers.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x186,
		.name = "Clash Ninja",
		.query = "clash ninja",
		.url = "https://www.clash.ninja/my-account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x187,
		.name = "ClassCentral",
		.query = "classcentral",
		.url = "https://www.classcentral.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x188,
		.name = "Classmates",
		.query = "classmates",
		.url = "https://secure.classmates.com/auth/removemember",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x189,
		.name = "ClassPass",
		.query = "classpass",
		.url = "https://classpass.com/settings/membership",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x18a,
		.name = "Classy",
		.query = "classy",
		.url = "https://preferences.gofundme.com/form/deletion",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x18b,
		.name = "Claude",
		.query = "claude",
		.url = "https://claude.ai/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x18c,
		.name = "CleverReach",
		.query = "cleverreach",
		.url = "https://www.cleverreach.com",
		.email = "mailto:info@cleverreach.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x18d,
		.name = "ClevGuard",
		.query = "clevguard",
		.url = "https://www.clevguard.com/account-faq/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x18e,
		.name = "ClickUp",
		.query = "clickup",
		.url = "https://app.clickup.com/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x18f,
		.name = "Clipchamp",
		.query = "clipchamp",
		.url = "https://app.clipchamp.com/account/general",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x190,
		.name = "Clippings.io",
		.query = "clippingsio",
		.url = "https://my.clippings.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x191,
		.name = "Clockify",
		.query = "clockify",
		.url = "https://app.clockify.me/user/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x192,
		.name = "Cloud Convert",
		.query = "cloud convert",
		.url = "https://cloudconvert.com/delete#",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x193,
		.name = "CloudApp",
		.query = "cloudapp",
		.url = "https://share.getcloudapp.com/dashboard",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x194,
		.name = "Cloudflare",
		.query = "cloudflare",
		.url = "https://dash.cloudflare.com/profile/delete-user",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x195,
		.name = "CloudMagic",
		.query = "cloudmagic",
		.url = "https://cloudmagic.com/a/v2/preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x196,
		.name = "CNET Download",
		.query = "cnet download",
		.url = "https://cbsi.secure.force.com/CBSi/submitcase?template=template_cnet&referer=cnet.com&cfs=SFS_1",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x197,
		.name = "CNIL",
		.query = "cnil",
		.url = "https://www.cnil.fr/en/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x198,
		.name = "CNN",
		.query = "cnn",
		.url = "https://www.cnn.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x199,
		.name = "Cocoleech",
		.query = "cocoleech",
		.url = "https://members.cocoleech.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x19a,
		.name = "Coda",
		.query = "coda",
		.url = "https://coda.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x19b,
		.name = "Code Red",
		.query = "code red",
		.url = "https://cne.coderedweb.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x19c,
		.name = "Codeanywhere",
		.query = "codeanywhere",
		.url = "https://codeanywhere.com/dashboard",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x19d,
		.name = "Codeberg",
		.query = "codeberg",
		.url = "https://codeberg.org/user/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x19e,
		.name = "Codecademy",
		.query = "codecademy",
		.url = "https://www.codecademy.com/account/delete_acct",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x19f,
		.name = "CodeChef",
		.query = "codechef",
		.url = "https://discuss.codechef.com/t/how-do-i-delete-a-codechef-account/30476",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a0,
		.name = "Codecov",
		.query = "codecov",
		.url = "https://codecovpro.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1a1,
		.name = "Codeforces",
		.query = "codeforces",
		.url = "https://codeforces.com/blog/entry/69245",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1a2,
		.name = "Codeium",
		.query = "codeium",
		.url = "https://codeium.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a3,
		.name = "CodePen",
		.query = "codepen",
		.url = "https://blog.codepen.io/documentation/faq/how-do-i-delete-my-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a4,
		.name = "CodeProject",
		.query = "codeproject",
		.url = "https://www.codeproject.com/script/Membership/Modify.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a5,
		.name = "CoderByte",
		.query = "coderbyte",
		.url = "https://coderbyte.com/privacy#:~:text=You%20may%20also%20delete%20your,detailed%20in%20this%20Privacy%20Policy.",
		.email = "mailto:support@coderbyte.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x1a6,
		.name = "CodersRank",
		.query = "codersrank",
		.url = "https://profile.codersrank.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a7,
		.name = "Coderwall",
		.query = "coderwall",
		.url = "https://coderwall.com/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a8,
		.name = "CodeSignal",
		.query = "codesignal",
		.url = "https://app.codesignal.com/account/username-password",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1a9,
		.name = "Codetasty",
		.query = "codetasty",
		.url = "https://codetasty.com/settings/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1aa,
		.name = "Codewars",
		.query = "codewars",
		.url = "https://www.codewars.com/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ab,
		.name = "Codingame",
		.query = "codingame",
		.url = "https://www.codingame.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ac,
		.name = "CoffeeCup",
		.query = "coffeecup",
		.url = "https://www.coffeecup.com/contact/",
		.email = "mailto:helpme@coffeecup.com?subject=Account%20Deletion%20Request%20and%20Data%20Erasure&body=Dear%20CoffeeCup%20Support%20Team%2C%20I%20am%20requesting%20the%20deletion%20of%20my%20account%20and%20all%20associated%20personal%20data%20in%20accordance%20with%20your%20Privacy%20Policy%20and%20GDPR.%20Below%20are%20my%20account%20details%3A%20Account%20Email%3A%20XXXX%20Title%3A%20XXXX%20Please%20ensure%20the%20permanent%20removal%20of%20my%20data%20from%20your%20systems%20and%20any%20third-party%20services.%20Kindly%20confirm%20once%20this%20has%20been%20completed.",
		.difficulty = 0x1000
	},
	{
		.id = 0x1ad,
		.name = "Cohost",
		.query = "cohost",
		.url = "https://cohost.org/rc/user/settings",
		.email = "mailto:support@cohost.org",
		.difficulty = 0x400
	},
	{
		.id = 0x1ae,
		.name = "Coin",
		.query = "coin",
		.url = "https://support.coinapp.co/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1af,
		.name = "Coinbase",
		.query = "coinbase",
		.url = "https://www.coinbase.com/settings/privacy-rights",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1b0,
		.name = "CoinBR/Stratum",
		.query = "coinbrstratum",
		.url = "https://stratum.hk/support",
		.email = "mailto:support@stratum.hk?subject=%5B%20Permanently%20Account%20Deletion%20Request%20%5D&body=I%20have%20no%20further%20interest%20in%20using%20the%20services%20provided%20by%20Stratum%2C%20so%20I%20would%20like%20my%20account%20to%20be%20permanently%20deleted.",
		.difficulty = 0x1000
	},
	{
		.id = 0x1b1,
		.name = "CoinGecko",
		.query = "coingecko",
		.url = "https://support.coingecko.com/hc/en-us/articles/4537981325977-How-can-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1b2,
		.name = "CoinMarketCap",
		.query = "coinmarketcap",
		.url = "https://coinmarketcap.com/community/edit-profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1b3,
		.name = "CoinPayments",
		.query = "coinpayments",
		.url = "https://www.coinpayments.net/help-support",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1b4,
		.name = "CoinSpot",
		.query = "coinspot",
		.url = "https://coinspot.zendesk.com/hc/en-us/articles/360001328796-Closing-your-Account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1b5,
		.name = "Cointree",
		.query = "cointree",
		.url = "https://cointree.formstack.com/forms/account_closure_request",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1b6,
		.name = "Collegeboard",
		.query = "collegeboard",
		.url = "https://pages.collegeboard.org/account-help/how-do-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1b7,
		.name = "Comment ça marche",
		.query = "comment ca marche",
		.url = "https://auth.ccm.net/user/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1b8,
		.name = "commiss.io",
		.query = "commissio",
		.url = "https://commiss.io/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1b9,
		.name = "Commun",
		.query = "commun",
		.url = "https://commun.it/content/cancel_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ba,
		.name = "Compiled",
		.query = "compiled",
		.url = "https://cosoc.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1bb,
		.name = "Computeruniverse",
		.query = "computeruniverse",
		.url = "https://www.computeruniverse.net/en/page/computeruniverse-privacy-policy#hbmpp-toc-III-4",
		.email = "mailto:computeruniverse@datenschutzanfrage.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x1bc,
		.name = "Contabo",
		.query = "contabo",
		.url = "https://help.contabo.com/en/support/solutions/articles/103000269314-how-can-i-close-my-contabo-account-or-cancel-a-contabo-service-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1bd,
		.name = "Conte.it",
		.query = "conteit",
		.url = "https://www.conte.it/privacy-unsubscribe/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1be,
		.name = "Cook It",
		.query = "cook it",
		.url = "https://www.chefcookit.com/unsubscribe",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1bf,
		.name = "Cool Shirtz",
		.query = "cool shirtz",
		.url = "https://shirtz.cool/pages/store-policies",
		.email = "mailto:help@shirtz.cool",
		.difficulty = 0x1000
	},
	{
		.id = 0x1c0,
		.name = "Coolors",
		.query = "coolors",
		.url = "https://coolors.co/account/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1c1,
		.name = "Coolshop.dk",
		.query = "coolshopdk",
		.url = "https://www.coolshop.dk/my/gdpr/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c2,
		.name = "Copyleaks",
		.query = "copyleaks",
		.url = "https://id.copyleaks.com/security",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1c3,
		.name = "Copyrighted",
		.query = "copyrighted",
		.url = "https://app.copyrighted.com/users/settings/cancel",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c4,
		.name = "Corellium",
		.query = "corellium",
		.url = "https://app.corellium.com/admin/subscription",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c5,
		.name = "Correl.app",
		.query = "correlapp",
		.url = "https://correl.app/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c6,
		.name = "CoSpaces",
		.query = "cospaces",
		.url = "https://edu.cospaces.io/Studio/Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c7,
		.name = "Coub",
		.query = "coub",
		.url = "https://coub.com/account/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1c8,
		.name = "Couchsurfing",
		.query = "couchsurfing",
		.url = "https://support.couchsurfing.org/hc/en-us/articles/200640880-How-can-I-Hide-or-Delete-my-profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1c9,
		.name = "Couponut",
		.query = "couponut",
		.url = "https://couponut.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ca,
		.name = "Coursera",
		.query = "coursera",
		.url = "https://www.coursera.org/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1cb,
		.name = "Covoitéo par Karos",
		.query = "covoiteo par karos",
		.url = "https://moncompte.tisseo.fr/fr/questions-frequentes?question=comment-supprimer-mon-compte-covoiteo",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1cc,
		.name = "Cracker Barrel",
		.query = "cracker barrel",
		.url = "http://www.crackerbarrel.com/privacy",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1cd,
		.name = "Craft",
		.query = "craft",
		.url = "https://docs.craft.do/s/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ce,
		.name = "Craigslist",
		.query = "craigslist",
		.url = "https://www.craigslist.org/about/help/user_accounts",
		.email = "mailto:abuse@craigslist.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x1cf,
		.name = "CrashPlan",
		.query = "crashplan",
		.url = "https://helpdesk.code42.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1d0,
		.name = "Credit Karma",
		.query = "credit karma",
		.url = "https://www.creditkarma.com/myprofile/security/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d1,
		.name = "CreditExpert",
		.query = "creditexpert",
		.url = "https://www.creditexpert.co.uk",
		.email = "mailto:Customerservice@creditexpert.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x1d2,
		.name = "Credly",
		.query = "credly",
		.url = "https://www.credly.com/earner/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d3,
		.name = "Crevado Portfolios",
		.query = "crevado portfolios",
		.url = "https://crevado.com/admin/account/cancel",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d4,
		.name = "Cronometer",
		.query = "cronometer",
		.url = "https://support.cronometer.com/hc/en-us/articles/360018760151-Account-Settings#h_440005960211545174984655",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d5,
		.name = "Crowdcast.io",
		.query = "crowdcastio",
		.url = "https://crowdcast.notion.site/Deleting-Your-Crowdcast-Account-952b7f9ff09648f7960e7d9ecfb6a1b4",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1d6,
		.name = "Crowdfinder",
		.query = "crowdfinder",
		.url = "https://crowdfinder.be/privacy",
		.email = "mailto:info@crowdfinder.be",
		.difficulty = 0x1000
	},
	{
		.id = 0x1d7,
		.name = "Crowdfire",
		.query = "crowdfire",
		.url = "https://support.crowdfireapp.com/support/solutions/articles/5000712205-deleting-your-crowdfire-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d8,
		.name = "Crowdin",
		.query = "crowdin",
		.url = "https://crowdin.com/settings#account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1d9,
		.name = "Crowdsorsa",
		.query = "crowdsorsa",
		.url = "https://crowdsorsa.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1da,
		.name = "Crunchyroll",
		.query = "crunchyroll",
		.url = "https://privacyportal.onetrust.com/webform/d19e506f-1a64-463d-94e4-914dd635817d/35fb5149-8905-48f3-9cbf-8b651c427d0e",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1db,
		.name = "CryEngine",
		.query = "cryengine",
		.url = "https://www.cryengine.com/user/dashboard/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1dc,
		.name = "Crypton.sh",
		.query = "cryptonsh",
		.url = "https://crypton.sh/app/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1dd,
		.name = "CryptoPanic",
		.query = "cryptopanic",
		.url = "https://cryptopanic.com/accounts/delete/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1de,
		.name = "CryptoVoucher",
		.query = "cryptovoucher",
		.url = "https://cryptovoucher.io/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1df,
		.name = "CryptPad",
		.query = "cryptpad",
		.url = "https://cryptpad.fr/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1e0,
		.name = "Crytek",
		.query = "crytek",
		.url = "https://www.crytek.com/privacy-policy#:~:text=VII.%20Review%2C%20Correction%20of%20Your%20Information%2C%20Requesting%20Removal%20from%20Mailing%20Lists%20and%20Deactivating%20Your%20Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1e1,
		.name = "CTFLearn",
		.query = "ctflearn",
		.url = "https://ctflearn.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1e2,
		.name = "cTrader",
		.query = "ctrader",
		.url = "https://help.ctrader.com/ctrader-id/delete",
		.email = "mailto:community@spotware.com?subject=cTrader%20account%20deletion%20request&body=Please%20delete%20my%20cTrader%20account%20that%20uses%20the%20e-mail%20XXXXX%20and%20the%20passport%20is%20YYYYY.",
		.difficulty = 0x1000
	},
	{
		.id = 0x1e3,
		.name = "Cubeast",
		.query = "cubeast",
		.url = "https://app.cubeast.com/settings/user_settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1e4,
		.name = "CubieCloud",
		.query = "cubiecloud",
		.url = "https://sso.cubie.com.br/delacc",
		.email = "mailto:suporte@cubie.com.br",
		.difficulty = 0x1000
	},
	{
		.id = 0x1e5,
		.name = "Cultura",
		.query = "cultura",
		.url = "https://mesdroits.my.onetrust.com/webform/657f7c55-2752-4af4-b8a2-0c1c352400a9/1a5e60f4-9b49-4948-b10a-247d726aa821",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1e6,
		.name = "Curio",
		.query = "curio",
		.url = "https://curio.io/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1e7,
		.name = "Curiosity Stream",
		.query = "curiosity stream",
		.url = "https://curiositystream.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1e8,
		.name = "Curriculum",
		.query = "curriculum",
		.url = "https://www.curriculum.com.br/01_02_habilitacao1.asp",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x1e9,
		.name = "CurseForge",
		.query = "curseforge",
		.url = "https://support.curseforge.com/en/support/tickets/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1ea,
		.name = "Cursor",
		.query = "cursor",
		.url = "https://www.cursor.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1eb,
		.name = "Curve",
		.query = "curve",
		.url = "https://support.imaginecurve.com/hc/en-gb/articles/214179685-How-do-I-cancel-my-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1ec,
		.name = "Cutout",
		.query = "cutout",
		.url = "https://www.cutout.pro/user/set",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1ed,
		.name = "CV online",
		.query = "cv online",
		.url = "https://cvonline.me/en/support/accounts/removing-account",
		.email = "mailto:hello@cvonline.me",
		.difficulty = 0x1000
	},
	{
		.id = 0x1ee,
		.name = "CVS Pharmacy",
		.query = "cvs pharmacy",
		.url = "https://www.cvs.com/account/account-management.jsp",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1ef,
		.name = "Cybrary",
		.query = "cybrary",
		.url = "https://app.cybrary.it/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f0,
		.name = "CZC",
		.query = "czc",
		.url = "https://www.czc.cz/soukromi/sprava-udaju",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1f1,
		.name = "DaFONT",
		.query = "dafont",
		.url = "https://www.dafont.com/forum/read/12643/how-do-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1f2,
		.name = "DagsHub",
		.query = "dagshub",
		.url = "https://dagshub.com/user/settings/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1f3,
		.name = "The Daily Wire",
		.query = "the daily wire",
		.url = "https://privacy.dailywire.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f4,
		.name = "Dailymotion",
		.query = "dailymotion",
		.url = "https://www.dailymotion.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f5,
		.name = "Dan Murphy's",
		.query = "dan murphys",
		.url = "https://www.danmurphys.com.au/dm/home",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x1f6,
		.name = "DansTonChat",
		.query = "danstonchat",
		.url = "https://danstonchat.com/user/delete.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f7,
		.name = "danwin1210.me",
		.query = "danwin1210me",
		.url = "https://danwin1210.me/mail/manage_account.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1f8,
		.name = "Darty",
		.query = "darty",
		.url = "https://www.darty.com/services/solutions/foire_aux_questions?question=comment-supprimer-compte-client-ainsi-mes-donnees-personnelles",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1f9,
		.name = "Dashlane",
		.query = "dashlane",
		.url = "https://app.dashlane.com/#/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1fa,
		.name = "data.gouv.fr",
		.query = "datagouvfr",
		.url = "https://doc.data.gouv.fr/gestion-du-compte/supprimer-un-compte/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1fb,
		.name = "DataCamp",
		.query = "datacamp",
		.url = "https://www.datacamp.com/profile/account_settings/advanced",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1fc,
		.name = "DataQuest",
		.query = "dataquest",
		.url = "https://app.dataquest.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1fd,
		.name = "Day One",
		.query = "day one",
		.url = "https://dayone.me/user/request-account-deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x1fe,
		.name = "dbrand",
		.query = "dbrand",
		.url = "https://dbrand.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x1ff,
		.name = "Deadspin",
		.query = "deadspin",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x200,
		.name = "Decathlon",
		.query = "decathlon",
		.url = "https://account.decathlon.com/privacy/account-deletion",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x201,
		.name = "Decathlon India",
		.query = "decathlon india",
		.url = "https://decathlononline.freshdesk.com/support/tickets/new",
		.email = "mailto:care.india@decathlon.com?subject=Decathlon.in%20Account%20Deletion%20Request&body=Please%20delete%20my%20decathlon.in%20account%20and%20erase%20all%20data%20associated%20with%20it.",
		.difficulty = 0x1000
	},
	{
		.id = 0x202,
		.name = "DeepL",
		.query = "deepl",
		.url = "https://www.deepl.com/en/privacy#section_6_1",
		.email = "mailto:support@deepl.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x203,
		.name = "DeepSeek",
		.query = "deepseek",
		.url = "https://chat.deepseek.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x204,
		.name = "Deezer",
		.query = "deezer",
		.url = "https://www.deezer.com/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x205,
		.name = "Deliveroo",
		.query = "deliveroo",
		.url = "https://deliveroo.co.uk/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x206,
		.name = "Delivery Code",
		.query = "delivery code",
		.url = "https://www.deliverycode.com",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x207,
		.name = "Dell",
		.query = "dell",
		.url = "https://www.dell.com/preferences/pcrp/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x208,
		.name = "Delta Airlines (SkyMiles)",
		.query = "delta airlines skymiles",
		.url = "https://www.delta.com/contactus/pages/comment_complaint/index.jsp",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x209,
		.name = "DelugeRPG",
		.query = "delugerpg",
		.url = "https://www.delugerpg.com/faq#delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x20a,
		.name = "Demiplane",
		.query = "demiplane",
		.url = "https://support.demiplane.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x20b,
		.name = "Depop",
		.query = "depop",
		.url = "https://depophelp.zendesk.com/hc/en-gb/articles/360001772988-How-can-I-delete-my-Depop-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x20c,
		.name = "Depositphotos",
		.query = "depositphotos",
		.url = "https://depositphotos.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x20d,
		.name = "Deutsche Bahn / DB",
		.query = "deutsche bahn db",
		.url = "https://int.bahn.de/en/faq/delete-data-customer-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x20e,
		.name = "Deutsche Post",
		.query = "deutsche post",
		.url = "https://www.dhl.de/content/dpks/de/themenauswahl/kundenservice-formulare/f1b-datenschutz.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x20f,
		.name = "DEV",
		.query = "dev",
		.url = "https://dev.to/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x210,
		.name = "DeviantArt",
		.query = "deviantart",
		.url = "https://www.deviantart.com/settings/deactivation",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x211,
		.name = "DevITjobs",
		.query = "devitjobs",
		.url = "https://devitjobs.com/contact",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x212,
		.name = "Devpost",
		.query = "devpost",
		.url = "https://devpost.com/settings/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x213,
		.name = "DHL",
		.query = "dhl",
		.url = "https://www.dhl.de/de/privatkunden/kundenkonto/meine-daten.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x214,
		.name = "Dia",
		.query = "dia",
		.url = "https://diabrowser.com/help",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x215,
		.name = "DialLink",
		.query = "diallink",
		.url = "https://app.diallink.com/v1/settings/company",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x216,
		.name = "diasp.eu (Diaspora)",
		.query = "diaspeu diaspora",
		.url = "https://diasp.eu/user/edit#close_account_pane",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x217,
		.name = "Dice",
		.query = "dice",
		.url = "https://www.dice.com/dashboard/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x218,
		.name = "DiceCloud",
		.query = "dicecloud",
		.url = "https://dicecloud.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x219,
		.name = "dict.cc",
		.query = "dictcc",
		.url = "https://users.dict.cc/my-account/close-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x21a,
		.name = "Dictionary.com",
		.query = "dictionarycom",
		.url = "https://www.dictionary.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x21b,
		.name = "Didsoft",
		.query = "didsoft",
		.url = "https://didsoft.com/contact.html",
		.email = "mailto:support@didsoft.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x21c,
		.name = "Dietollemode.com",
		.query = "dietollemodecom",
		.url = "https://dietollemode.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x21d,
		.name = "Digg",
		.query = "digg",
		.url = "https://digg.com/privacy#:~:text=How%20Can%20I%20Delete%20My%20Account%3F",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x21e,
		.name = "Digio",
		.query = "digio",
		.url = "https://www.digio.com.br/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x21f,
		.name = "DigitalOcean",
		.query = "digitalocean",
		.url = "https://cloud.digitalocean.com/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x220,
		.name = "Diigo",
		.query = "diigo",
		.url = "https://www.diigo.com/setting",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x221,
		.name = "Directleaks",
		.query = "directleaks",
		.url = "https://directleaks.net/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x222,
		.name = "Discogs",
		.query = "discogs",
		.url = "https://www.discogs.com/users/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x223,
		.name = "Discord",
		.query = "discord",
		.url = "https://support.discordapp.com/hc/en-us/articles/212500837-How-do-I-permanently-delete-my-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x224,
		.name = "Discourse",
		.query = "discourse",
		.url = "https://www.discourse.org/privacy#heading--change",
		.email = "mailto:privacy@discourse.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x225,
		.name = "discovery+",
		.query = "discovery",
		.url = "https://privacyportal.onetrust.com/webform/1b21e05d-c206-4e0b-970e-2d73a23e42e8/5b504afe-dd1e-47f6-9af6-56144531eced",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x226,
		.name = "Disney",
		.query = "disney",
		.url = "https://support.disney.com/hc/en-gb/articles/115005418823-How-do-I-delete-my-Disney-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x227,
		.name = "Disney+",
		.query = "disney",
		.url = "https://help.disneyplus.com/csp?id=csp_article_content&sys_kb_id=bf6bf352db101558331d6fddd39619c7",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x228,
		.name = "Displate",
		.query = "displate",
		.url = "https://displate.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x229,
		.name = "Disqus",
		.query = "disqus",
		.url = "https://disqus.com/home/settings/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22a,
		.name = "Disroot",
		.query = "disroot",
		.url = "https://user.disroot.org/pwm/private/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22b,
		.name = "distill.io",
		.query = "distillio",
		.url = "distill.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22c,
		.name = "Divize",
		.query = "divize",
		.url = "https://divize.io/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22d,
		.name = "DJI",
		.query = "dji",
		.url = "https://account.dji.com/account/userCancel",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x22e,
		.name = "DLH",
		.query = "dlh",
		.url = "https://dlh.net/en/profile.html",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x22f,
		.name = "DLive",
		.query = "dlive",
		.url = "https://dlive.tv/s/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x230,
		.name = "Dmwithme",
		.query = "dmwithme",
		.url = "https://dmwithme.com/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x231,
		.name = "DNSimple",
		.query = "dnsimple",
		.url = "https://dnsimple.com/user/cancellation",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x232,
		.name = "Do IT",
		.query = "do it",
		.url = "https://doit.life/privacy-policy",
		.email = "mailto:data@doit.life",
		.difficulty = 0x2000
	},
	{
		.id = 0x233,
		.name = "DocHub",
		.query = "dochub",
		.url = "https://dochub.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x234,
		.name = "Docker",
		.query = "docker",
		.url = "https://hub.docker.com/settings/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x235,
		.name = "DocMorris",
		.query = "docmorris",
		.url = "https://www.docmorris.de/kontaktformular",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x236,
		.name = "Doctolib",
		.query = "doctolib",
		.url = "https://www.doctolib.de/account/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x237,
		.name = "DocuSign",
		.query = "docusign",
		.url = "https://support.docusign.com/en/articles/How-do-I-cancel-or-downgrade-my-account#steps",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x238,
		.name = "Doksure",
		.query = "doksure",
		.url = "https://doksure.com/supprimer-son-compte",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x239,
		.name = "Dollskill",
		.query = "dollskill",
		.url = "https://www.dollskill.com/pages/contact-us",
		.email = "mailto:dataprotection@dollskill.com?subject=Hello%0A%2C%20please%20delete%20the%20account%20associated%20to%20this%20email.%20My%20phone%20number%20is%20XXXXXXXX%20and%20I%20would%20like%20all%20data%20associated%20to%20my%20account%20to%20be%20removed.",
		.difficulty = 0x1000
	},
	{
		.id = 0x23a,
		.name = "DonationAlerts",
		.query = "donationalerts",
		.url = "https://www.donationalerts.com/dashboard/general-settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x23b,
		.name = "Doneo",
		.query = "doneo",
		.url = "http://www.doneo.org/2_index_membre.php?action=desinscription_membre&block=block2",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x23c,
		.name = "Doodle",
		.query = "doodle",
		.url = "https://doodle.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x23d,
		.name = "DoorDash",
		.query = "doordash",
		.url = "https://www.doordash.com/consumer/privacy/delete_account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x23e,
		.name = "Douban",
		.query = "douban",
		.url = "https://www.douban.com/accounts/suicide/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x23f,
		.name = "Douyin",
		.query = "douyin",
		.url = "https://aweme.snssdk.com/ucenter_web/app/aweme/delete-account-notice?_theme=light&hide_nav_bar=1&title=%E6%8A%96%E9%9F%B3%E6%B3%A8%E9%94%80%E9%A1%BB%E7%9F%A5&hide_status_bar=0&disable_auto_expose=1&font_scale=1.0",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x240,
		.name = "DOWN",
		.query = "down",
		.url = "https://www.downapp.com",
		.email = "mailto:feedback@downapp.com",
		.difficulty = 0x400
	},
	{
		.id = 0x241,
		.name = "Dr. Martens",
		.query = "dr martens",
		.url = "https://www.drmartens.com/us/en/faq",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x242,
		.name = "Draft",
		.query = "draft",
		.url = "https://draftin.com/draft/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x243,
		.name = "Drawabox",
		.query = "drawabox",
		.url = "https://drawabox.com",
		.email = "mailto:support@drawabox.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x244,
		.name = "Drawpile",
		.query = "drawpile",
		.url = "https://drawpile.net/accounts/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x245,
		.name = "Draxlr",
		.query = "draxlr",
		.url = "https://www.draxlr.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x246,
		.name = "DreamHost",
		.query = "dreamhost",
		.url = "https://panel.dreamhost.com/index.cgi?tree=support.msg",
		.email = "mailto:privacypolicy@dreamhost.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x247,
		.name = "Dreamstime",
		.query = "dreamstime",
		.url = "https://www.dreamstime.com/account/edit-profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x248,
		.name = "Dreamwidth",
		.query = "dreamwidth",
		.url = "https://www.dreamwidth.org/accountstatus",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x249,
		.name = "Dribbble",
		.query = "dribbble",
		.url = "https://dribbble.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x24a,
		.name = "DriveThruRPG",
		.query = "drivethrurpg",
		.url = "https://support.drivethrurpg.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x24b,
		.name = "Drivvo",
		.query = "drivvo",
		.url = "https://www.drivvo.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x24c,
		.name = "Drizly",
		.query = "drizly",
		.url = "https://privacyportal.onetrust.com/webform/d3790e60-9408-4ab8-9ac6-511ad32593a0/edb91c18-e5fd-42cb-a0ce-4b1832410687",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x24d,
		.name = "Drone.io",
		.query = "droneio",
		.url = "https://drone.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x24e,
		.name = "Dronebase",
		.query = "dronebase",
		.url = "https://dronebase.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x24f,
		.name = "Drop (Massdrop)",
		.query = "drop massdrop",
		.url = "https://helpdesk.drop.com/hc/en-us/articles/360019265073-How-do-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x250,
		.name = "Dropbox",
		.query = "dropbox",
		.url = "https://www.dropbox.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x251,
		.name = "Droplr",
		.query = "droplr",
		.url = "https://d.pr/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x252,
		.name = "Dropmark",
		.query = "dropmark",
		.url = "https://support.dropmark.com/article/92-how-do-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x253,
		.name = "DTF",
		.query = "dtf",
		.url = "https://dtf.ru",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x254,
		.name = "Duet Night Abyss",
		.query = "duet night abyss",
		.url = "https://duetnightabyss.dna-panstudio.com/#/home",
		.email = "mailto:dna_cs@dna-panstudio.com?subject=ccount%20deletion%20request&body=Hereby%20the%20request%20to%20delete%20my%20account%20associated%20with%20my%20email.",
		.difficulty = 0x1000
	},
	{
		.id = 0x255,
		.name = "Dunkindonuts",
		.query = "dunkindonuts",
		.url = "https://www.dunkindonuts.com/en/about/contact-us",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x256,
		.name = "Duo",
		.query = "duo",
		.url = "https://help.duo.com/s/article/2162",
		.email = "mailto:support@duosecurity.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x257,
		.name = "Duolicious",
		.query = "duolicious",
		.url = "https://web.duolicious.app/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x258,
		.name = "Duolingo",
		.query = "duolingo",
		.url = "https://drive-thru.duolingo.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x259,
		.name = "Duotrope",
		.query = "duotrope",
		.url = "https://duotrope.com/contact/customerservice.aspx",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x25a,
		.name = "Dwell",
		.query = "dwell",
		.url = "https://dwell.co.uk/contactus.php",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x25b,
		.name = "Dwolla",
		.query = "dwolla",
		.url = "https://www.dwolla.com",
		.email = "mailto:support@dwolla.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x25c,
		.name = "DWService",
		.query = "dwservice",
		.url = "https://www.dwservice.net/session.dw#s",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x25d,
		.name = "Dynadot",
		.query = "dynadot",
		.url = "https://www.dynadot.com/community/help/question/close-dynadot-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x25e,
		.name = "DynDNS",
		.query = "dyndns",
		.url = "https://account.dyn.com/profile/close.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x25f,
		.name = "e621",
		.query = "e621",
		.url = "https://e621.net/maintenance/user/deletion",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x260,
		.name = "EA Games / Origin / Electronic Arts",
		.query = "ea games origin electronic arts",
		.url = "https://www.ea.com/legal/privacy-portal",
		.email = "mailto:dpo@ea.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x261,
		.name = "EasyEDA",
		.query = "easyeda",
		.url = "https://easyeda.com/account/user/account/setting/advance",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x262,
		.name = "easyfundraising",
		.query = "easyfundraising",
		.url = "https://www.easyfundraising.org.uk/account/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x263,
		.name = "easyJet",
		.query = "easyjet",
		.url = "https://www.easyjet.com/en/policy/privacy-promise/request-data-form",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x264,
		.name = "EatStreet",
		.query = "eatstreet",
		.url = "https://eatstreet.com/contact",
		.email = "mailto:customer.service@eatstreet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x265,
		.name = "EBANX",
		.query = "ebanx",
		.url = "https://ebanx.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x266,
		.name = "eBay",
		.query = "ebay",
		.url = "https://accountsettings.ebay.com/uas",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x267,
		.name = "eBonus",
		.query = "ebonus",
		.url = "https://ebonus.gg/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x268,
		.name = "Economist",
		.query = "economist",
		.url = "https://myaccount.economist.com/s/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x269,
		.name = "Ecwid",
		.query = "ecwid",
		.url = "https://my.ecwid.com/cp/#profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x26a,
		.name = "Ed2Go",
		.query = "ed2go",
		.url = "https://support.ed2go.com/partners/s/contactsupport",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x26b,
		.name = "Edabit",
		.query = "edabit",
		.url = "https://edabit.com/challenges",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x26c,
		.name = "Edizioni Simone",
		.query = "edizioni simone",
		.url = "https://edizioni.simone.it/informativa-sulla-privacy/",
		.email = "mailto:privacy@simone.it",
		.difficulty = 0x1000
	},
	{
		.id = 0x26d,
		.name = "Edpuzzle",
		.query = "edpuzzle",
		.url = "https://edpuzzle.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x26e,
		.name = "Edraw Software",
		.query = "edraw software",
		.url = "https://www.edrawsoft.com/faq/#account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x26f,
		.name = "eDreams",
		.query = "edreams",
		.url = "https://www.edreams.co.uk/travel/secure/#accountpreferences/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x270,
		.name = "Educaplay",
		.query = "educaplay",
		.url = "https://www.educaplay.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x271,
		.name = "Eduonix",
		.query = "eduonix",
		.url = "https://www.eduonix.com/settings/mang_pass",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x272,
		.name = "Edureka",
		.query = "edureka",
		.url = "https://www.edureka.co/contact-us",
		.email = "mailto:support@edureka.co",
		.difficulty = 0x1000
	},
	{
		.id = 0x273,
		.name = "Edvisors/ScholarshipPoints",
		.query = "edvisorsscholarshippoints",
		.url = "https://www.edvisors.com/delete-request/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x274,
		.name = "EdX",
		.query = "edx",
		.url = "https://account.edx.org/#delete-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x275,
		.name = "Electroneum",
		.query = "electroneum",
		.url = "https://support.electroneum.com/hc/en-gb/requests/new",
		.email = "mailto:support@electroneum.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x276,
		.name = "Element",
		.query = "element",
		.url = "https://app.element.io/#/home",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x277,
		.name = "Elevate",
		.query = "elevate",
		.url = "https://elevateapp.com",
		.email = "mailto:hello@elevateapp.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x278,
		.name = "Elfster",
		.query = "elfster",
		.url = "https://www.elfster.com/settings/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x279,
		.name = "Ello",
		.query = "ello",
		.url = "https://ello.co/wtf/help/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x27a,
		.name = "elmah.io",
		.query = "elmahio",
		.url = "https://app.elmah.io/profile/#actions",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x27b,
		.name = "Elpais",
		.query = "elpais",
		.url = "https://registro.elpais.com.uy/regasistencia.asp",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x27c,
		.name = "ELSA Speak",
		.query = "elsa speak",
		.url = "https://elsaspeak.com/app/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x27d,
		.name = "Elsevier",
		.query = "elsevier",
		.url = "https://service.elsevier.com/app/answers/detail/a_id/30148/supporthub/ecommerce/~/how-do-i-request-deletion-of-my-elsevier.com-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x27e,
		.name = "Ely.by",
		.query = "elyby",
		.url = "https://account.ely.by/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x27f,
		.name = "Embark Studios",
		.query = "embark studios",
		.url = "https://id.embark.games/id/connected-platforms",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x280,
		.name = "Emby",
		.query = "emby",
		.url = "https://emby.media/community/index.php?/settings/deletemyaccount/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x281,
		.name = "Empik",
		.query = "empik",
		.url = "https://www.empik.com/polityka-prywatnosci-empik",
		.email = "mailto:obsluga.klienta@empik.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x282,
		.name = "Engadget",
		.query = "engadget",
		.url = "https://engadget.mydashboard.oath.com/#section-manage",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x283,
		.name = "Enhancv",
		.query = "enhancv",
		.url = "https://app.enhancv.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x284,
		.name = "enjin",
		.query = "enjin",
		.url = "https://www.enjin.com/dashboard/account/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x285,
		.name = "enjoei",
		.query = "enjoei",
		.url = "https://www.enjoei.com.br/perfil/alterar",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x286,
		.name = "Enphase",
		.query = "enphase",
		.url = "https://support.enphase.com/s/article/deleting-your-enphase-app-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x287,
		.name = "ENSHAN",
		.query = "enshan",
		.url = "https://www.right.com.cn/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x288,
		.name = "Envato",
		.query = "envato",
		.url = "https://help.market.envato.com/hc/en-us/articles/202500394-How-Do-I-Close-My-Account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x289,
		.name = "Epic Games",
		.query = "epic games",
		.url = "https://www.epicgames.com/help/en-US/epic-accounts-c74/general-support-c79/how-do-i-delete-my-epic-games-account-a3636",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x28a,
		.name = "Epidemic Sound",
		.query = "epidemic sound",
		.url = "https://support.epidemicsound.com/s/article/how-do-i-delete-my-account-2020-05-27-050641?language=en_US",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x28b,
		.name = "Epik",
		.query = "epik",
		.url = "https://www.epik.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x28c,
		.name = "Epoch Times",
		.query = "epoch times",
		.url = "https://help.theepochtimes.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x28d,
		.name = "eProject.me",
		.query = "eprojectme",
		.url = "https://eproject.me",
		.email = "mailto:services@eproject.me",
		.difficulty = 0x1000
	},
	{
		.id = 0x28e,
		.name = "eRepublik",
		.query = "erepublik",
		.url = "https://www.erepublik.com/en/contact/none/none",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x28f,
		.name = "ESPN",
		.query = "espn",
		.url = "https://www.espn.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x290,
		.name = "EteSync",
		.query = "etesync",
		.url = "https://dashboard.etebase.com/user/partner/account/deactivate/request/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x291,
		.name = "eToro",
		.query = "etoro",
		.url = "https://www.etoro.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x292,
		.name = "ETS Global",
		.query = "ets global",
		.url = "https://privacyportal-de.onetrust.com/webform/f194ee56-f900-441a-aca9-6a1807f9b2a5/4687a8cc-3095-439e-b369-39726e438235",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x293,
		.name = "Etsy",
		.query = "etsy",
		.url = "https://www.etsy.com/your/account/privacy",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x294,
		.name = "Europa Lehrmittel",
		.query = "europa lehrmittel",
		.url = "https://www.europa-lehrmittel.de/Datenschutz/",
		.email = "mailto:dsb@europa-lehrmittel.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x295,
		.name = "Europathek",
		.query = "europathek",
		.url = "https://www.europathek.de/de/#/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x296,
		.name = "Even",
		.query = "even",
		.url = "https://www.even.com/employees/support",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x297,
		.name = "Eventbrite",
		.query = "eventbrite",
		.url = "https://www.eventbrite.com/account-close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x298,
		.name = "Eventim",
		.query = "eventim",
		.url = "https://www.eventim.de/help/contact/?help_id=6306",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x299,
		.name = "Everand",
		.query = "everand",
		.url = "https://support.scribd.com/hc/en-us/articles/360000894843-Deleting-your-account#h_01HBVYCPRH4GEMX24PD473BHP8",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x29a,
		.name = "Everhelper",
		.query = "everhelper",
		.url = "https://www.everhelper.me/remove-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x29b,
		.name = "Evernote",
		.query = "evernote",
		.url = "https://help.evernote.com/hc/en-us/articles/360056549574-Permanently-close-your-Evernote-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x29c,
		.name = "EVGA",
		.query = "evga",
		.url = "https://www.evga.com/legal/privacy/#form",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x29d,
		.name = "Evike",
		.query = "evike",
		.url = "https://www.evike.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x29e,
		.name = "Evite",
		.query = "evite",
		.url = "https://privacyportal-cdn.onetrust.com/dsarwebform/516d7c8e-88ca-4311-b9d9-a6a1aa23be02/5eb62c40-d057-4621-93ca-9842142c3443.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x29f,
		.name = "Examine",
		.query = "examine",
		.url = "https://examine.com/contact/",
		.email = "mailto:support@examine.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2a0,
		.name = "Exclusive Car Registry",
		.query = "exclusive car registry",
		.url = "https://exclusivecarregistry.com/account/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2a1,
		.name = "Exercism",
		.query = "exercism",
		.url = "https://exercism.io/my/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2a2,
		.name = "Exophase",
		.query = "exophase",
		.url = "https://www.exophase.com/account/removal/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2a3,
		.name = "Expedia",
		.query = "expedia",
		.url = "https://www.expedia.com/helpcenter/?articleId=22910&pwaDialog=article-dialog",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2a4,
		.name = "Experian",
		.query = "experian",
		.url = "https://www.experian.com",
		.email = "mailto:support@experian.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2a5,
		.name = "Experian UK",
		.query = "experian uk",
		.url = "https://prodmove.experian.co.uk/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2a6,
		.name = "Expo",
		.query = "expo",
		.url = "https://expo.dev/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2a7,
		.name = "ExpressVPN",
		.query = "expressvpn",
		.url = "https://www.expressvpn.com/support/",
		.email = "mailto:support@expressvpn.zendesk.com?subject=Request%20to%20Delete%20my%20Account&body=To%20whom%20it%20may%20concern%2C%250D%250A%250D%250AI%20am%20reaching%20out%20to%20you%20to%20request%20the%20cancellation%20and%20deletion%20of%20the%20ExpressVPN%20account%20attached%20to%20this%20Email%20address%20and%20its%20data%20as%20I%20am%20no%20longer%20using%20the%20service.%250D%250A%250D%250ABest%20Regards",
		.difficulty = 0x1000
	},
	{
		.id = 0x2a8,
		.name = "EZsniper",
		.query = "ezsniper",
		.url = "https://www.ezsniper.com/contact.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2a9,
		.name = "F95Zone",
		.query = "f95zone",
		.url = "https://f95zone.to/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2aa,
		.name = "Facebook",
		.query = "facebook",
		.url = "https://www.facebook.com/help/delete_account?rdrhc",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2ab,
		.name = "Facebook Messenger",
		.query = "facebook messenger",
		.url = "https://www.facebook.com/help/messenger-app/458908261952384?cms_platform=android-app&helpref=platform_switcher",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ac,
		.name = "Faceit",
		.query = "faceit",
		.url = "https://support.faceit.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2ad,
		.name = "Facile.it",
		.query = "facileit",
		.url = "https://www.facile.it/cancellazione/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ae,
		.name = "Fairphone",
		.query = "fairphone",
		.url = "https://www.fairphone.com/en/legal/fairphone-privacy-policy/#yourresponsibilitiesandrights",
		.email = "mailto:privacy@fairphone.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2af,
		.name = "FamilySearch",
		.query = "familysearch",
		.url = "https://www.familysearch.org/identity/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2b0,
		.name = "Fanatical",
		.query = "fanatical",
		.url = "https://www.fanatical.com/en/account/login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2b1,
		.name = "Fandom Wikia",
		.query = "fandom wikia",
		.url = "https://community.wikia.com/wiki/Special:CloseMyAccount",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2b2,
		.name = "FanFiction",
		.query = "fanfiction",
		.url = "https://www.fanfiction.net/account/data_delete.php",
		.email = "mailto:support@fanfiction.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2b3,
		.name = "Fastcompany",
		.query = "fastcompany",
		.url = "https://fastcompany.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x2b4,
		.name = "FastWeb",
		.query = "fastweb",
		.url = "https://www.fastweb.com/login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2b5,
		.name = "FaucetPay",
		.query = "faucetpay",
		.url = "https://faq.faucetpay.io/knowledge-base/i-want-to-delete-my-account-how-can-i-do-it/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x2b6,
		.name = "Fauna",
		.query = "fauna",
		.url = "https://support.fauna.com/hc/en-us/articles/1260807007229-How-do-I-delete-my-account-entirely-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2b7,
		.name = "FC2ID",
		.query = "fc2id",
		.url = "https://secure.id.fc2.com/edit.php?mode=withdrawal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2b8,
		.name = "FDM Group",
		.query = "fdm group",
		.url = "https://www.fdmgroup.com/privacy/",
		.email = "mailto:DPO@FDMGroup.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2b9,
		.name = "Featurebase",
		.query = "featurebase",
		.url = "https://help.featurebase.app/en/articles/8033192-how-to-delete-my-featurebase-account-organization-and-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ba,
		.name = "FedEx",
		.query = "fedex",
		.url = "https://privacyportal.onetrust.com/webform/8a471a7b-6a52-49d0-bcb0-fa8bdb61598f/c121cce6-6cfb-4c3d-9b61-334f56a01b5f",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2bb,
		.name = "Fedora",
		.query = "fedora",
		.url = "https://pagure.io/fedora-pdr/new_issue",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2bc,
		.name = "FeedBin",
		.query = "feedbin",
		.url = "https://feedbin.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2bd,
		.name = "Feedly",
		.query = "feedly",
		.url = "https://feedly.com/i/erase",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2be,
		.name = "Ferox Hosting",
		.query = "ferox hosting",
		.url = "https://tickets.feroxhosting.nl/newissue",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2bf,
		.name = "Fever",
		.query = "fever",
		.url = "https://feverup.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c0,
		.name = "Fidélité TCL",
		.query = "fidelite tcl",
		.url = "https://fidelite.tcl.fr/dashboard/profile/documentation/deleteAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c1,
		.name = "Figma",
		.query = "figma",
		.url = "https://www.figma.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c2,
		.name = "Filen.io",
		.query = "filenio",
		.url = "https://drive.filen.io/#/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c3,
		.name = "Fin.do",
		.query = "findo",
		.url = "https://www.fin.do/support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2c4,
		.name = "Finanzblick",
		.query = "finanzblick",
		.url = "https://finanzblick.de/webapp",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2c5,
		.name = "FinnishPod101.com",
		.query = "finnishpod101com",
		.url = "https://www.finnishpod101.com/#privacy_policy",
		.email = "mailto:contactus@finnishpod101.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2c6,
		.name = "Finviz",
		.query = "finviz",
		.url = "https://finviz.com/contact.ashx",
		.email = "mailto:support@finviz.com?subject=Data%20Deletion%20Request&body=Please%20delete%20my%20account%20registered%20with%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x2c7,
		.name = "Firefox",
		.query = "firefox",
		.url = "https://accounts.firefox.com/settings/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c8,
		.name = "fishtank",
		.query = "fishtank",
		.url = "https://www.fishtank.live",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2c9,
		.name = "Fitbit",
		.query = "fitbit",
		.url = "https://www.fitbit.com/settings/profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2ca,
		.name = "FitnessSyncer",
		.query = "fitnesssyncer",
		.url = "https://www.fitnesssyncer.com/account#Profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2cb,
		.name = "Fitocracy",
		.query = "fitocracy",
		.url = "https://www.fitocracy.com/account/deletion/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2cc,
		.name = "Fiverr",
		.query = "fiverr",
		.url = "https://www.fiverr.com/support_tickets/account-and-security/data-and-privacy/remove-personal-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2cd,
		.name = "Fixer.io",
		.query = "fixerio",
		.url = "https://fixer.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ce,
		.name = "FixMyCar",
		.query = "fixmycar",
		.url = "https://www.whocanfixmycar.com/terms#termination-of-services",
		.email = "mailto:team@whocanfixmycar.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2cf,
		.name = "Flat",
		.query = "flat",
		.url = "https://flat.io/settings/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d0,
		.name = "Flatfox",
		.query = "flatfox",
		.url = "https://flatfox.ch/en/accounts/remove/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d1,
		.name = "Flathub",
		.query = "flathub",
		.url = "https://flathub.org/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d2,
		.name = "Flaticon",
		.query = "flaticon",
		.url = "https://www.flaticon.com/profile/me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d3,
		.name = "Flattr",
		.query = "flattr",
		.url = "https://flattr.com/settings/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d4,
		.name = "Fleek",
		.query = "fleek",
		.url = "https://fleek.xyz/support/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x2d5,
		.name = "Flickr",
		.query = "flickr",
		.url = "https://www.flickr.com/profile_delete.gne",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d6,
		.name = "Flightradar24",
		.query = "flightradar24",
		.url = "https://www.flightradar24.com/terms-and-conditions",
		.email = "mailto:support@fr24.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2d7,
		.name = "Flip",
		.query = "flip",
		.url = "https://admin.flip.com/manage/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d8,
		.name = "Flipboard",
		.query = "flipboard",
		.url = "https://accounts.flipboard.com/accounts/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2d9,
		.name = "Flixster",
		.query = "flixster",
		.url = "https://www.flixster.com",
		.email = "mailto:privacy@flixster-inc.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2da,
		.name = "Flo Health",
		.query = "flo health",
		.url = "https://help.flo.health/hc/en-us/requests/new",
		.email = "mailto:support@flo.health",
		.difficulty = 0x1000
	},
	{
		.id = 0x2db,
		.name = "Floatplane",
		.query = "floatplane",
		.url = "https://www.floatplane.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2dc,
		.name = "FlokiNET",
		.query = "flokinet",
		.url = "https://flokinet.is/privacy",
		.email = "mailto:info@flokinet.is",
		.difficulty = 0x1000
	},
	{
		.id = 0x2dd,
		.name = "Floor Plan Creator",
		.query = "floor plan creator",
		.url = "https://floorplancreator.net/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2de,
		.name = "Floorplanner.com",
		.query = "floorplannercom",
		.url = "https://floorplanner.com/home/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2df,
		.name = "Flowkey",
		.query = "flowkey",
		.url = "https://help.flowkey.com/en/articles/4466433-how-to-unsubscribe-or-delete-your-account",
		.email = "mailto:support@flowkey.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2e0,
		.name = "Fluid UI",
		.query = "fluid ui",
		.url = "https://www.fluidui.com/contact",
		.email = "mailto:support@fluidui.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2e1,
		.name = "Fly.io",
		.query = "flyio",
		.url = "https://fly.io/user/deactivate",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2e2,
		.name = "FMOD",
		.query = "fmod",
		.url = "https://fmod.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2e3,
		.name = "Fnac",
		.query = "fnac",
		.url = "https://www.fnac.com/aide?question=comment-reinitialiser-mon-mot-de-passe",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2e4,
		.name = "Foap",
		.query = "foap",
		.url = "https://www.foap.com/pages/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2e5,
		.name = "FogBugz",
		.query = "fogbugz",
		.url = "https://support.fogbugz.com/hc/en-us/articles/360011242754-Cancelling-a-FogBugz-or-Kiln-On-Demand-Subscription",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2e6,
		.name = "Follett",
		.query = "follett",
		.url = "https://www.follett.com/policies/",
		.email = "mailto:privacy@follett.com?subject=Data%20Deletion%20Request&body=Please%20delete%20my%20data%20from%20all%20Follett%20services%20under%20my%20email%20address%20XXXXXX.",
		.difficulty = 0x1000
	},
	{
		.id = 0x2e7,
		.name = "Followlike",
		.query = "followlike",
		.url = "https://www.followlike.net/settings.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2e8,
		.name = "Font Awesome",
		.query = "font awesome",
		.url = "https://fontawesome.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2e9,
		.name = "FontStruct",
		.query = "fontstruct",
		.url = "https://fontstruct.com/private/user/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ea,
		.name = "Foodmaxx",
		.query = "foodmaxx",
		.url = "https://foodmaxx.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2eb,
		.name = "Fooducate",
		.query = "fooducate",
		.url = "http://fooducate.com/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ec,
		.name = "ForeverMissed",
		.query = "forevermissed",
		.url = "https://www.forevermissed.com/contactus",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2ed,
		.name = "Form.taxi",
		.query = "formtaxi",
		.url = "https://form.taxi/panel/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2ee,
		.name = "Formula 1",
		.query = "formula 1",
		.url = "https://account.formula1.com/#/en/privacy-policy",
		.email = "mailto:general@en.formula1.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2ef,
		.name = "Forsa Omninet",
		.query = "forsa omninet",
		.url = "https://omninet.forsa.de/data-protection",
		.email = "mailto:datenschutz@forsa.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x2f0,
		.name = "Forvo",
		.query = "forvo",
		.url = "https://forvo.com/account-delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2f1,
		.name = "forward2me",
		.query = "forward2me",
		.url = "https://www.forward2me.com/terms-of-trade/",
		.email = "mailto:info@forward2me.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2f2,
		.name = "Fotka",
		.query = "fotka",
		.url = "https://www.fotka.pl/ustawienia/konto_usun",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x2f3,
		.name = "Foursquare",
		.query = "foursquare",
		.url = "https://foursquare.com/delete_me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2f4,
		.name = "Foxford (Фоксфорд)",
		.query = "foxford фоксфорд",
		.url = "https://foxford.ru",
		.email = "mailto:ask@foxford.ru",
		.difficulty = 0x1000
	},
	{
		.id = 0x2f5,
		.name = "Framer",
		.query = "framer",
		.url = "https://www.framer.com/contact/",
		.email = "mailto:support@framer.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x2f6,
		.name = "Framework",
		.query = "framework",
		.url = "https://frame.work/support#contact_support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2f7,
		.name = "France Identité",
		.query = "france identite",
		.url = "https.//idp.france-identite.gouv.fr/usager",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2f8,
		.name = "France TV",
		.query = "france tv",
		.url = "https://www.france.tv/votre-compte/supprimer-mon-compte/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2f9,
		.name = "Franz",
		.query = "franz",
		.url = "https://meetfranz.com/user/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2fa,
		.name = "FREAKHOSTING",
		.query = "freakhosting",
		.url = "https://freakhosting.com/clientarea/clientarea.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x2fb,
		.name = "FreeBitco.In",
		.query = "freebitcoin",
		.url = "https://freebitco.in",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x2fc,
		.name = "FreeCodeCamp",
		.query = "freecodecamp",
		.url = "https://www.freecodecamp.org/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2fd,
		.name = "Freecycle",
		.query = "freecycle",
		.url = "https://freecycle.org/home/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x2fe,
		.name = "FreeDNS",
		.query = "freedns",
		.url = "https://freedns.afraid.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x2ff,
		.name = "Freejam",
		.query = "freejam",
		.url = "https://account.freejamgames.com/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x300,
		.name = "Freelancer",
		.query = "freelancer",
		.url = "https://www.freelancer.in/users/settings.php#AccountSettings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x301,
		.name = "Freeletics",
		.query = "freeletics",
		.url = "https://www.freeletics.com/en/settings/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x302,
		.name = "Freenom",
		.query = "freenom",
		.url = "https://my.freenom.com/clientarea.php?action=details",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x303,
		.name = "Freesound",
		.query = "freesound",
		.url = "https://freesound.org/home/delete/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x304,
		.name = "Freshdesk",
		.query = "freshdesk",
		.url = "https://freshdesk.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x305,
		.name = "Freshping",
		.query = "freshping",
		.url = "https://freshping.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x306,
		.name = "Frontend Mentor",
		.query = "frontend mentor",
		.url = "https://www.frontendmentor.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x307,
		.name = "Fruux",
		.query = "fruux",
		.url = "https://fruux.com/account/login/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x308,
		.name = "Function of Beauty",
		.query = "function of beauty",
		.url = "https://functionofbeauty.com/pages/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x309,
		.name = "Funimation",
		.query = "funimation",
		.url = "https://help.funimation.com/hc/en-us/articles/360046541711-How-do-I-delete-or-close-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x30a,
		.name = "Fur Affinity",
		.query = "fur affinity",
		.url = "https://www.furaffinity.net/controls/delete-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x30b,
		.name = "Furbase",
		.query = "furbase",
		.url = "https://forum.furbase.de/account-management/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x30c,
		.name = "FutureLearn",
		.query = "futurelearn",
		.url = "https://www.futurelearn.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x30d,
		.name = "FXhome",
		.query = "fxhome",
		.url = "https://fxhome.com",
		.email = "mailto:support@fxhome.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x30e,
		.name = "G-Portal",
		.query = "gportal",
		.url = "https://www.g-portal.com/en/privacy",
		.email = "mailto:datenschutz@g-portal.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x30f,
		.name = "G2A",
		.query = "g2a",
		.url = "https://id.g2a.com/panel/account-details/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x310,
		.name = "G7",
		.query = "g7",
		.url = "https://aide.g7.fr/hc/fr/articles/7438978440476-Supprimer-mon-compte-G7",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x311,
		.name = "Gab Social",
		.query = "gab social",
		.url = "https://gab.com/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x312,
		.name = "Gadu-Gadu",
		.query = "gadugadu",
		.url = "https://www.gg.pl/pomoc/ustawienia-moje-konto-profil/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x313,
		.name = "Gaijin Entertainment",
		.query = "gaijin entertainment",
		.url = "https://support.gaijin.net/hc/en-us/articles/200071071-Account-Deletion-Suspension-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x314,
		.name = "GAINSFIRE",
		.query = "gainsfire",
		.url = "https://www.gainsfire.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x315,
		.name = "galaxy",
		.query = "galaxy",
		.url = "https://galaxy.click/settings#danger",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x316,
		.name = "Galaxy Play",
		.query = "galaxy play",
		.url = "https://galaxyplay.vn/account/info/delete-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x317,
		.name = "Game Tracker",
		.query = "game tracker",
		.url = "http://www.gametracker.com/account/manage/edit.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x318,
		.name = "GameFAQs",
		.query = "gamefaqs",
		.url = "https://gamefaqs.gamespot.com/user/closedel",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x319,
		.name = "Gameforge",
		.query = "gameforge",
		.url = "https://gameforge.com/support",
		.email = "mailto:support@gameforge.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x31a,
		.name = "GameFront",
		.query = "gamefront",
		.url = "https://www.gamefront.com/account/delete",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x31b,
		.name = "Gamefroot",
		.query = "gamefroot",
		.url = "https://make.gamefroot.com/privacypolicy",
		.email = "mailto:developer@gamefroot.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20GameFroot%20account%20registered%20under%20this%20email%20address%2C%20and%20opt%20me%20out%20from%20receiving%20any%20marketing%20communications.",
		.difficulty = 0x1000
	},
	{
		.id = 0x31c,
		.name = "GameGleam",
		.query = "gamegleam",
		.url = "https://www.gamegleam.com",
		.email = "mailto:support@gamegleam.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x31d,
		.name = "Gamehag",
		.query = "gamehag",
		.url = "https://www.gamehag.com/profile/edit",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x31e,
		.name = "GameJolt",
		.query = "gamejolt",
		.url = "https://gamejolt.com/account-deletion",
		.email = "mailto:contact@gamejolt.com?body=Please%20delete%20my%20GameJolt%20account%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x31f,
		.name = "Gamemaker",
		.query = "gamemaker",
		.url = "https://auth.opera.com/account/delete-profile",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x320,
		.name = "GamersGate",
		.query = "gamersgate",
		.url = "https://www.gamersgate.com/account/delete/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x321,
		.name = "Gamesplanet",
		.query = "gamesplanet",
		.url = "https://us.gamesplanet.com/support/17-account/141-delete-account",
		.email = "mailto:help@gamesplanet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x322,
		.name = "Gamespot",
		.query = "gamespot",
		.url = "https://gamespot.com",
		.email = "mailto:support@gamespot.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x323,
		.name = "Gamesradar",
		.query = "gamesradar",
		.url = "https://gamesradar.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x324,
		.name = "GameStop",
		.query = "gamestop",
		.url = "https://www.gamestop.com/PrivacyPolicy.html#section9",
		.email = "mailto:GSContentRequests@gamestop.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x325,
		.name = "Gamma",
		.query = "gamma",
		.url = "https://gamma.app/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x326,
		.name = "Garena",
		.query = "garena",
		.url = "https://www.garena.sg/support/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x327,
		.name = "Garmin",
		.query = "garmin",
		.url = "https://www.garmin.com/account/datamanagement/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x328,
		.name = "GasBuddy",
		.query = "gasbuddy",
		.url = "https://help.gasbuddy.com/hc/en-us/requests/new?ticket_form_id=360001568313",
		.email = "mailto:privacyrequest@gasbuddy.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x329,
		.name = "Gather",
		.query = "gather",
		.url = "https://www.gather.town/legal/gather-privacy-policy",
		.email = "mailto:privacy@gather.town",
		.difficulty = 0x1000
	},
	{
		.id = 0x32a,
		.name = "Gauges",
		.query = "gauges",
		.url = "https://gaug.es",
		.email = "mailto:support@gaug.es",
		.difficulty = 0x1000
	},
	{
		.id = 0x32b,
		.name = "GBAtemp",
		.query = "gbatemp",
		.url = "https://gbatemp.net/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x32c,
		.name = "Gdeposylka",
		.query = "gdeposylka",
		.url = "https://gdeposylka.ru/auth/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x32d,
		.name = "Gearbest",
		.query = "gearbest",
		.url = "https://wap-support.gearbest.com/ticket/ticket/ticket-add",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x32e,
		.name = "GeekHunter",
		.query = "geekhunter",
		.url = "https://suporte.geekhunter.com.br/support/solutions/articles/9000185709-como-faco-para-excluir-minha-conta-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x32f,
		.name = "GeeksforGeeks",
		.query = "geeksforgeeks",
		.url = "https://auth.geeksforgeeks.org/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x330,
		.name = "Gemini",
		.query = "gemini",
		.url = "https://support.gemini.com/hc/en-us/requests/new?ticket_form_id=1260809732969",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x331,
		.name = "Genesis Cloud",
		.query = "genesis cloud",
		.url = "https://id.genesiscloud.com/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x332,
		.name = "Geni",
		.query = "geni",
		.url = "https://www.geni.com/account_settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x333,
		.name = "Genius",
		.query = "genius",
		.url = "https://support.genius.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x334,
		.name = "Gentoo Forums",
		.query = "gentoo forums",
		.url = "https://wiki.gentoo.org/wiki/Project:Forums#Account_removal_requests",
		.email = "mailto:forum-mods@gentoo.org?subject=Account%20Removal%20Request&body=I%20request%20for%20my%20Gentoo%20Forums%20account%20to%20be%20deleted.%20My%20username%20is%20XXXXXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x335,
		.name = "Genymotion Cloud (SaaS)",
		.query = "genymotion cloud saas",
		.url = "https://support.genymotion.com/hc/en-us/requests/new?ticket_form_id=360000289657",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x336,
		.name = "Genymotion Desktop",
		.query = "genymotion desktop",
		.url = "https://www-v1.genymotion.com/account/#account-info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x337,
		.name = "Geocaching",
		.query = "geocaching",
		.url = "https://www.geocaching.com/account/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x338,
		.name = "GeoGebra",
		.query = "geogebra",
		.url = "https://accounts.geogebra.org/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x339,
		.name = "GeoGuessr",
		.query = "geoguessr",
		.url = "https://www.geoguessr.com/me/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x33a,
		.name = "Geotastic",
		.query = "geotastic",
		.url = "https://geotastic.net/account/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x33b,
		.name = "GermanTechJobs",
		.query = "germantechjobs",
		.url = "https://germantechjobs.de/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x33c,
		.name = "get.tech",
		.query = "gettech",
		.url = "https://get.tech/privacy-policy",
		.email = "mailto:privacy@radix.email",
		.difficulty = 0x1000
	},
	{
		.id = 0x33d,
		.name = "GetContact",
		.query = "getcontact",
		.url = "https://www.getcontact.com/manage",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x33e,
		.name = "GetCreditScore",
		.query = "getcreditscore",
		.url = "https://www.getcreditscore.com.au",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x33f,
		.name = "Gettr",
		.query = "gettr",
		.url = "https://gettr.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x340,
		.name = "GG2U",
		.query = "gg2u",
		.url = "https://www.gg2u.org/privacy.html",
		.email = "mailto:privacy@gg2u.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x341,
		.name = "GHash.IO",
		.query = "ghashio",
		.url = "https://support.cex.io/",
		.email = "mailto:support@cex.io?subject=Delete%20Account",
		.difficulty = 0x1000
	},
	{
		.id = 0x342,
		.name = "Giant Bomb",
		.query = "giant bomb",
		.url = "https://www.giantbomb.com",
		.email = "mailto:support@giantbomb.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x343,
		.name = "Giphy",
		.query = "giphy",
		.url = "https://giphy.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x344,
		.name = "GitBook",
		.query = "gitbook",
		.url = "https://app.gitbook.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x345,
		.name = "GitHub",
		.query = "github",
		.url = "https://github.com/settings/admin#:~:text=Delete%20account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x346,
		.name = "GitKraken",
		.query = "gitkraken",
		.url = "https://app.gitkraken.com/account-info/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x347,
		.name = "GitLab",
		.query = "gitlab",
		.url = "https://gitlab.com/-/profile/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x348,
		.name = "GitPod",
		.query = "gitpod",
		.url = "https://gitpod.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x349,
		.name = "Gizmodo",
		.query = "gizmodo",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x34a,
		.name = "Glassdoor",
		.query = "glassdoor",
		.url = "https://help.glassdoor.com/s/privacyrequest",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x34b,
		.name = "Gleam.io",
		.query = "gleamio",
		.url = "https://gleam.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x34c,
		.name = "Glide (UK)",
		.query = "glide uk",
		.url = "https://prearrival.glidestudent.co.uk/privacy-policy",
		.email = "mailto:dpo@glide.co.uk?subject=Data%20Deletion%20Request&body=Please%20delete%20my%20account%20and%20data%20registered%20with%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x34d,
		.name = "Glitch",
		.query = "glitch",
		.url = "https://glitch.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x34e,
		.name = "Glorious Forums",
		.query = "glorious forums",
		.url = "https://gloriousforum.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x34f,
		.name = "Glovo",
		.query = "glovo",
		.url = "https://privacyportal-de.onetrust.com/webform/823e95df-5300-421a-bd72-0c9e0180184f/ff436245-5e5d-44f9-8463-eb48c2052eb5",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x350,
		.name = "Glyph / Trion Worlds / Gamigo",
		.query = "glyph trion worlds gamigo",
		.url = "https://support.gamigo.com/hc/en-us/articles/204884188-How-do-I-delete-my-Glyph-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x351,
		.name = "Gmail",
		.query = "gmail",
		.url = "https://myaccount.google.com/deleteservices",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x352,
		.name = "GMX",
		.query = "gmx",
		.url = "https://www.gmx.net",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x353,
		.name = "GNC",
		.query = "gnc",
		.url = "https://www.gnc.com/help/contact-us.html#chat",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x354,
		.name = "GNOME",
		.query = "gnome",
		.url = "https://extensions.gnome.org/accounts/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x355,
		.name = "Gocatch",
		.query = "gocatch",
		.url = "https://gocatch.zendesk.com/hc/en-us/articles/115005902046-How-to-deactivate-or-reactivate-your-GoCatch-account",
		.email = "mailto:support@gocatch.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x356,
		.name = "GoDaddy",
		.query = "godaddy",
		.url = "https://account.godaddy.com/preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x357,
		.name = "GoFundMe",
		.query = "gofundme",
		.url = "https://www.gofundme.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x358,
		.name = "GOG",
		.query = "gog",
		.url = "https://www.gog.com/en/account/settings/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x359,
		.name = "Goggles4u",
		.query = "goggles4u",
		.url = "https://www.goggles4u.co.uk/privacy-policy",
		.email = "mailto:steve@goggles4u.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x35a,
		.name = "Gogo",
		.query = "gogo",
		.url = "https://www.gogoair.com/dsar/",
		.email = "mailto:customercare@gogoair.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x35b,
		.name = "GoJek",
		.query = "gojek",
		.url = "https://www.go-jek.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x35c,
		.name = "GoldenLine",
		.query = "goldenline",
		.url = "https://www.goldenline.pl/ustawienia/kasuj-konto/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x35d,
		.name = "Golf GameBook Scorecard & GPS",
		.query = "golf gamebook scorecard gps",
		.url = "https://golfgamebook.com/privacy-policy/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x35e,
		.name = "Good Food",
		.query = "good food",
		.url = "https://www.makegoodfood.ca/en/faq#heading-13",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x35f,
		.name = "Good Noows",
		.query = "good noows",
		.url = "https://goodnoows.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x360,
		.name = "Goodlord",
		.query = "goodlord",
		.url = "https://www.goodlord.co/privacy-policy",
		.email = "mailto:privacy@goodlord.co",
		.difficulty = 0x1000
	},
	{
		.id = 0x361,
		.name = "Goodreads",
		.query = "goodreads",
		.url = "https://www.goodreads.com/user/destroy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x362,
		.name = "Google",
		.query = "google",
		.url = "https://security.google.com/settings/security/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x363,
		.name = "Google One",
		.query = "google one",
		.url = "https://myaccount.google.com/deleteservices",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x364,
		.name = "Google Pay",
		.query = "google pay",
		.url = "https://myaccount.google.com/deleteservices",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x365,
		.name = "GoPetition",
		.query = "gopetition",
		.url = "https://www.gopetition.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x366,
		.name = "Gorila",
		.query = "gorila",
		.url = "https://app.gorila.com.br/app/configuracoes-da-conta/pessoal/preferencias",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x367,
		.name = "GoSquared",
		.query = "gosquared",
		.url = "https://www.gosquared.com/home/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x368,
		.name = "Gov.br",
		.query = "govbr",
		.url = "https://www.gov.br/governodigital/pt-br/identidade/conta-gov-br/exclusao-da-conta-gov.br",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x369,
		.name = "gPodder",
		.query = "gpodder",
		.url = "https://www.gpodder.net/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x36a,
		.name = "Grab",
		.query = "grab",
		.url = "https://www.grab.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x36b,
		.name = "Gradcracker",
		.query = "gradcracker",
		.url = "https://www.gradcracker.com/my-gradcracker/my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x36c,
		.name = "Gradescope",
		.query = "gradescope",
		.url = "https://guides.gradescope.com/hc/en-us/articles/21587242755341-Editing-Your-Account",
		.email = "mailto:help@gradescope.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x36d,
		.name = "Graduate-Jobs.com",
		.query = "graduatejobscom",
		.url = "https://www.graduate-jobs.com/sign-in/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x36e,
		.name = "Grafana",
		.query = "grafana",
		.url = "https://community.grafana.com/t/how-to-delete-account/18415",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x36f,
		.name = "Grailed",
		.query = "grailed",
		.url = "https://www.grailed.com",
		.email = "mailto:arun@grailed.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x370,
		.name = "Grammarly",
		.query = "grammarly",
		.url = "https://app.grammarly.com/profile/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x371,
		.name = "Gravatar",
		.query = "gravatar",
		.url = "https://gravatar.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x372,
		.name = "GreasyFork",
		.query = "greasyfork",
		.url = "https://greasyfork.org/en/users/delete_info",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x373,
		.name = "Green Man Gaming",
		.query = "green man gaming",
		.url = "https://corporate.greenmangaming.com/privacy-policy",
		.email = "mailto:dataprotection@greenmangaming.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x374,
		.name = "Greip",
		.query = "greip",
		.url = "https://docs.greip.io/knowledge-base/account-management/account-deletion",
		.email = "mailto:support@greip.io?subject=Greip%20Account%20Deletion%20Request&body=Hi%2C%20Please%20delete%20my%20Greip%20account%20which%20is%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x375,
		.name = "Grindr",
		.query = "grindr",
		.url = "https://help.grindr.com/hc/en-us/requests/new?ticket_form_id=24054",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x376,
		.name = "GroupMe",
		.query = "groupme",
		.url = "https://app.groupme.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x377,
		.name = "Groupon (USA)",
		.query = "groupon usa",
		.url = "https://privacy.groupon.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x378,
		.name = "Groupon (Worldwide)",
		.query = "groupon worldwide",
		.url = "https://privacy.groupon.co.uk/?modal=take-control",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x379,
		.name = "Groups.io",
		.query = "groupsio",
		.url = "https://groups.io/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x37a,
		.name = "Grover",
		.query = "grover",
		.url = "https://service.grover.com/hc/en-us/articles/20618482673554-Request-to-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x37b,
		.name = "GrubHub",
		.query = "grubhub",
		.url = "https://www.grubhub.com/help/privacy/manage-your-data",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x37c,
		.name = "Gryphline",
		.query = "gryphline",
		.url = "https://user.gryphline.com/cancellation",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x37d,
		.name = "GTmetrix",
		.query = "gtmetrix",
		.url = "https://gtmetrix.com/dashboard/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x37e,
		.name = "The Guardian",
		.query = "the guardian",
		.url = "https://profile.theguardian.com/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x37f,
		.name = "Guild Wars",
		.query = "guild wars",
		.url = "https://help.guildwars2.com/hc/de/requests/new?ticket_form_id=38933",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x380,
		.name = "Guilded",
		.query = "guilded",
		.url = "https://www.guilded.gg",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x381,
		.name = "Guildtag",
		.query = "guildtag",
		.url = "https://guildtag.com",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x382,
		.name = "Gule Sider (Norwegian Yellow Pages)",
		.query = "gule sider norwegian yellow pages",
		.url = "https://oppdater.gulesider.no/person",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x383,
		.name = "Gumroad",
		.query = "gumroad",
		.url = "https://gumroad.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x384,
		.name = "Gumtree",
		.query = "gumtree",
		.url = "https://www.gumtree.com/manage-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x385,
		.name = "guns.lol",
		.query = "gunslol",
		.url = "https://guns.lol",
		.email = "mailto:support@guns.lol?subject=Delete%20Account%20Request&body=Dear%20guns.lol%20support%20team%2C%20I%20hope%20this%20message%20finds%20you%20well.%20I%20would%20like%20to%20formally%20request%20the%20closure%20and%20the%20deletion%20of%20all%20associated%20personal%20data%20and%20account.%20Below%20are%20my%20account%20details%3A%20Email%20Address%3A%20XXXXX%40XXXXX.XXXXX%2C%20UID%3A%20XXXXX.%20I%20would%20appreciate%20it%20if%20you%20could%20process%20my%20account%20closure%20request%20as%20soon%20as%20possible.%20Please%20confirm%20once%20the%20account%20has%20been%20deleted%20and%20all%20associated%20data%20has%20been%20deleted.%20Best%20regards%2C%20XXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x386,
		.name = "gutefrage",
		.query = "gutefrage",
		.url = "https://www.gutefrage.net/datenschutz",
		.email = "mailto:info@gutefrage.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x387,
		.name = "Gyazo",
		.query = "gyazo",
		.url = "https://gyazo.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x388,
		.name = "Habbo",
		.query = "habbo",
		.url = "https://help.habbo.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x389,
		.name = "Habitica",
		.query = "habitica",
		.url = "https://habitica.com/user/settings/general",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x38a,
		.name = "Hack The Box",
		.query = "hack the box",
		.url = "https://app.hackthebox.eu/profile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x38b,
		.name = "Hack This Site",
		.query = "hack this site",
		.url = "https://www.hackthissite.org/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x38c,
		.name = "Hackaday.io",
		.query = "hackadayio",
		.url = "https://hackaday.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x38d,
		.name = "Hacker News",
		.query = "hacker news",
		.url = "https://news.ycombinator.com/item?id=23623799",
		.email = "mailto:hn@ycombinator.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x38e,
		.name = "Hacker One",
		.query = "hacker one",
		.url = "https://hackerone.com/settings/deactivate/edit",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x38f,
		.name = "Hackerearth",
		.query = "hackerearth",
		.url = "https://www.hackerearth.com/users/profile-settings/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x390,
		.name = "Hackerrank",
		.query = "hackerrank",
		.url = "https://www.hackerrank.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x391,
		.name = "Happy Scribe",
		.query = "happy scribe",
		.url = "https://www.happyscribe.co/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x392,
		.name = "Happy Wheels",
		.query = "happy wheels",
		.url = "https://totaljerkface.com/delete_account.tjf",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x393,
		.name = "Hardware webwinkel",
		.query = "hardware webwinkel",
		.url = "https://hardwarewebwinkel.nl/",
		.email = "mailto:info@hardwarewebwinkel.nl",
		.difficulty = 0x1000
	},
	{
		.id = 0x394,
		.name = "Hark Audio",
		.query = "hark audio",
		.url = "https://harkaudio.com/support",
		.email = "mailto:hello@harkaudio.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20Hark%20Audio%20account%20which%20is%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x395,
		.name = "Harney & Sons Fine Teas",
		.query = "harney sons fine teas",
		.url = "https://www.harney.com/pages/contact-us",
		.email = "mailto:customerservice@harneyteas.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x396,
		.name = "Harvard Business Publishing Education",
		.query = "harvard business publishing education",
		.url = "https://hbsp.harvard.edu/privacy-policy/#8",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x397,
		.name = "HBO Max",
		.query = "hbo max",
		.url = "https://privacyportal.onetrust.com/webform/1b21e05d-c206-4e0b-970e-2d73a23e42e8/6555225c-a911-4af8-bdb5-20158994ece0",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x398,
		.name = "hCaptcha",
		.query = "hcaptcha",
		.url = "https://www.hcaptcha.com/privacy",
		.email = "mailto:support@hcaptcha.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20hCaptcha%20account%20which%20is%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x399,
		.name = "HeadHunter",
		.query = "headhunter",
		.url = "https://hh.ru/account/delete_me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x39a,
		.name = "Headliner",
		.query = "headliner",
		.url = "https://learn.headliner.app/hc/en-us/articles/360003796513-How-do-I-delete-my-account-",
		.email = "mailto:support@headliner.app",
		.difficulty = 0x1000
	},
	{
		.id = 0x39b,
		.name = "HeadshotGenerator",
		.query = "headshotgenerator",
		.url = "https://www.headshotgenerator.io/dashboard",
		.email = "mailto:contact@headshotgenerator.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x39c,
		.name = "Headspace",
		.query = "headspace",
		.url = "https://my.headspace.com/profile/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x39d,
		.name = "HelloFax",
		.query = "hellofax",
		.url = "https://www.hellofax.com/home/myAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x39e,
		.name = "HelloFresh",
		.query = "hellofresh",
		.url = "https://privacy.hellofresh.com/data-privacy",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x39f,
		.name = "HelloWallet",
		.query = "hellowallet",
		.url = "https://my.hellowallet.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a0,
		.name = "HelpScout",
		.query = "helpscout",
		.url = "https://docs.helpscout.com/article/473-cancel-your-help-scout-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a1,
		.name = "Hemingway Editor",
		.query = "hemingway editor",
		.url = "https://hemingwayapp.com/help#more-help",
		.email = "mailto:support@hemingwayapp.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3a2,
		.name = "Hepsiburada",
		.query = "hepsiburada",
		.url = "https://www.hepsiburada.com/cozummerkezi/sikca-sorulan-sorular-detay/220",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3a3,
		.name = "Heroes and Generals",
		.query = "heroes and generals",
		.url = "https://account.heroesandgenerals.com/deleteaccount.aspx/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3a4,
		.name = "Heroku",
		.query = "heroku",
		.url = "https://dashboard.heroku.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a5,
		.name = "HeroX",
		.query = "herox",
		.url = "https://www.herox.com/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a6,
		.name = "Hetzner",
		.query = "hetzner",
		.url = "https://accounts.hetzner.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a7,
		.name = "Hi-Rez Studios",
		.query = "hirez studios",
		.url = "https://my.hirezstudios.com/security",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3a8,
		.name = "Hi5",
		.query = "hi5",
		.url = "https://www.hi5.com/account_cancel.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3a9,
		.name = "hide.me",
		.query = "hideme",
		.url = "https://member.hide.me/en/settings/delete-account/form",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3aa,
		.name = "HigherMe",
		.query = "higherme",
		.url = "https://app.higherme.com/profile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ab,
		.name = "HiiCash",
		.query = "hiicash",
		.url = "https://www.hiicash.app/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3ac,
		.name = "HiNative",
		.query = "hinative",
		.url = "https://hinative.com/users/edit?type=delete_my_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ad,
		.name = "Histats",
		.query = "histats",
		.url = "https://www.histats.com/viewstats/?act=1",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ae,
		.name = "HitBTC",
		.query = "hitbtc",
		.url = "https://support.hitbtc.com/en/support/tickets/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3af,
		.name = "HitFilm",
		.query = "hitfilm",
		.url = "https://fxhome.com/privacy",
		.email = "mailto:privacy@fxhome.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3b0,
		.name = "HITHIT",
		.query = "hithit",
		.url = "https://www.hithit.com/en/article/privacyPolicy",
		.email = "mailto:info@hithit.cz",
		.difficulty = 0x1000
	},
	{
		.id = 0x3b1,
		.name = "Hive Social",
		.query = "hive social",
		.url = "https://www.hivesocial.app/help-center/deactivation",
		.email = "mailto:support@hivesocial.app",
		.difficulty = 0x1000
	},
	{
		.id = 0x3b2,
		.name = "HOL Virtual Hogwarts",
		.query = "hol virtual hogwarts",
		.url = "https://hol.org.uk/profile.php?view=quithol",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3b3,
		.name = "Holiday Pirates",
		.query = "holiday pirates",
		.url = "http://www.holidaypirates.com/user/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3b4,
		.name = "Holland and Barrett",
		.query = "holland and barrett",
		.url = "hollandandbarrett.com/my-account/security-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3b5,
		.name = "Holopin",
		.query = "holopin",
		.url = "https://www.holopin.io/privacy.html",
		.email = "mailto:support@holopin.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x3b6,
		.name = "The Home Depot México",
		.query = "the home depot mexico",
		.url = "https://www.homedepot.com.mx/ayuda-configuracion-cuenta#:~:text=a%20tu%20correo.-,Pasos%20para%20eliminar%20tu%20cuenta%20de%20The%20Home%20Depot%20M%C3%A9xico,-Para%20eliminar%20tu",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3b7,
		.name = "Honey",
		.query = "honey",
		.url = "https://www.joinhoney.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3b8,
		.name = "Honeygain",
		.query = "honeygain",
		.url = "https://dashboard.honeygain.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3b9,
		.name = "Honeypot.io",
		.query = "honeypotio",
		.url = "https://app.honeypot.io/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ba,
		.name = "Hooked (Deals)",
		.query = "hooked deals",
		.url = "https://www.hookedapp.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3bb,
		.name = "Hoop",
		.query = "hoop",
		.url = "https://hoop.photo/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3bc,
		.name = "Hostelsclub",
		.query = "hostelsclub",
		.url = "https://www.hostelsclub.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3bd,
		.name = "Hostinger",
		.query = "hostinger",
		.url = "https://hpanel.hostinger.com/profile/personal-information",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3be,
		.name = "Hot or Not",
		.query = "hot or not",
		.url = "https://hotornot.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3bf,
		.name = "Hotels.com",
		.query = "hotelscom",
		.url = "https://www.hotels.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3c0,
		.name = "Hotspot Shield",
		.query = "hotspot shield",
		.url = "https://www.hotspotshield.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3c1,
		.name = "Hotstar",
		.query = "hotstar",
		.url = "https://help.hotstar.com/in/en/support/tickets/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3c2,
		.name = "Houzz",
		.query = "houzz",
		.url = "https://help.houzz.com/s/article/How-do-I-delete-my-account",
		.email = "mailto:EUprivacy@houzz.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3c3,
		.name = "Hover",
		.query = "hover",
		.url = "https://help.hover.com/hc/en-us/articles/222421328-Canceling-services-with-Hover",
		.email = "mailto:help@hover.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3c4,
		.name = "HowLongToBeat",
		.query = "howlongtobeat",
		.url = "https://howlongtobeat.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3c5,
		.name = "HoYoverse",
		.query = "hoyoverse",
		.url = "https://account.hoyoverse.com/?lang=en#/account/safetySettings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3c6,
		.name = "HP",
		.query = "hp",
		.url = "https://www8.hp.com/us/en/privacy/ww-privacy-form.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3c7,
		.name = "HRK Game",
		.query = "hrk game",
		.url = "https://www.hrkgame.com/en/account/settings/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3c8,
		.name = "HTC",
		.query = "htc",
		.url = "https://www.htc.com/us/terms/privacy",
		.email = "mailto:global-privacy@htc.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3c9,
		.name = "HUAWEI ID",
		.query = "huawei id",
		.url = "https://consumer.huawei.com/ph/support/content/en-us00681307/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ca,
		.name = "Huddle",
		.query = "huddle",
		.url = "https://huddle.zendesk.com/hc/en-us/articles/200124703-How-do-I-cancel-my-Huddle-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3cb,
		.name = "Huel",
		.query = "huel",
		.url = "https://discuss.huel.com/t/how-do-i-delete-my-account/17617/4",
		.email = "mailto:team@huel.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3cc,
		.name = "Huggingface",
		.query = "huggingface",
		.url = "https://huggingface.co/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3cd,
		.name = "Hulu",
		.query = "hulu",
		.url = "https://secure.hulu.com/users/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ce,
		.name = "Human Benchmark",
		.query = "human benchmark",
		.url = "https://humanbenchmark.com/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3cf,
		.name = "Humata",
		.query = "humata",
		.url = "https://app.humata.ai/settings/personal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3d0,
		.name = "Humble Bundle",
		.query = "humble bundle",
		.url = "https://dsar.humblebundle.com",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3d1,
		.name = "Hunter",
		.query = "hunter",
		.url = "https://hunter.io/users/edit?tab=delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3d2,
		.name = "hxcy",
		.query = "hxcy",
		.url = "https://hxcy.top/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3d3,
		.name = "Hype",
		.query = "hype",
		.url = "https://support.hype.it/hc/it/articles/360003556214-Come-chiudere-il-conto",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3d4,
		.name = "Hype Machine",
		.query = "hype machine",
		.url = "http://hypem.com/remove_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3d5,
		.name = "Hypixel Forums",
		.query = "hypixel forums",
		.url = "https://hypixel.net/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3d6,
		.name = "IBM Watson Media",
		.query = "ibm watson media",
		.url = "https://support.video.ibm.com/hc/en-us/articles/207851817-How-Do-I-Delete-My-IBM-Video-Streaming-Account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3d7,
		.name = "IBMid",
		.query = "ibmid",
		.url = "https://www.ibm.com/ibmid/myibm/help/us/helpdesk.html",
		.email = "mailto:ibmidsupport@ibm.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3d8,
		.name = "Ibotta",
		.query = "ibotta",
		.url = "https://help.ibotta.com/hc/en-us/articles/225528727-How-Do-I-Cancel-My-Ibotta-Account-",
		.email = "mailto:accountsupport@ibotta.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3d9,
		.name = "ICANN",
		.query = "icann",
		.url = "https://account.icann.org/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3da,
		.name = "iCasei",
		.query = "icasei",
		.url = "https://suporte.icasei.com.br/hc/pt-br/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3db,
		.name = "Icedrive",
		.query = "icedrive",
		.url = "https://icedrive.net/dashboard/#/page/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3dc,
		.name = "Iceland",
		.query = "iceland",
		.url = "https://www.iceland.co.uk/privacy-policy",
		.email = "mailto:dataprotection@iceland.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x3dd,
		.name = "iClicker",
		.query = "iclicker",
		.url = "https://mhe.my.site.com/iclicker/s/contactsupport",
		.email = "mailto:privacyisimportant@macmillan.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3de,
		.name = "Icontem",
		.query = "icontem",
		.url = "https://accounts.icontem.com/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3df,
		.name = "ICQ",
		.query = "icq",
		.url = "https://www.icq.com/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3e0,
		.name = "ID.me",
		.query = "idme",
		.url = "https://account.id.me/signin/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3e1,
		.name = "Ideone",
		.query = "ideone",
		.url = "https://ideone.com/legal-tos#:~:text=In%20order%20to%20remove%20the,and%20file%20a%20proper%20motion.",
		.email = "mailto:contact@sphere-research.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3e2,
		.name = "iFixit",
		.query = "ifixit",
		.url = "https://forms.obsecom.eu/requests/654931-678694-057240-634891",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3e3,
		.name = "IFTTT",
		.query = "ifttt",
		.url = "https://ifttt.com/settings/confirm_deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3e4,
		.name = "IGDB",
		.query = "igdb",
		.url = "https://www.igdb.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3e5,
		.name = "iGraal",
		.query = "igraal",
		.url = "https://fr.igraal.com/?showSupportChat",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3e6,
		.name = "iHeart",
		.query = "iheart",
		.url = "https://help.iheart.com/hc/en-us/articles/4424516427021-How-to-Delete-your-iHeart-Account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3e7,
		.name = "IKEA",
		.query = "ikea",
		.url = "https://www.ikea.com/gb/en/profile/dashboard/#login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3e8,
		.name = "illa / ILLA Cloud",
		.query = "illa illa cloud",
		.url = "https://www.illacloud.com/docs/privacy-policy#your-rights",
		.email = "mailto:vincent@illasoft.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x3e9,
		.name = "iLoveIMG",
		.query = "iloveimg",
		.url = "https://www.iloveimg.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3ea,
		.name = "iLovePDF",
		.query = "ilovepdf",
		.url = "https://www.ilovepdf.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3eb,
		.name = "ImageKit",
		.query = "imagekit",
		.url = "https://imagekit.io/dashboard/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ec,
		.name = "ImageShack",
		.query = "imageshack",
		.url = "https://imageshack.com/my/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ed,
		.name = "IMDb",
		.query = "imdb",
		.url = "https://www.imdb.com/registration/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3ee,
		.name = "imgBB",
		.query = "imgbb",
		.url = "https://imgbb.com/settings/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3ef,
		.name = "Imgur",
		.query = "imgur",
		.url = "https://imgur.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3f0,
		.name = "Immersive Translate",
		.query = "immersive translate",
		.url = "https://immersivetranslate.com/profile/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3f1,
		.name = "ImmiAccount (Australian Home Affairs)",
		.query = "immiaccount australian home affairs",
		.url = "https://online.immi.gov.au/usm/summary",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3f2,
		.name = "Immomio",
		.query = "immomio",
		.url = "https://tenant.immomio.com/de/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3f3,
		.name = "Immowelt",
		.query = "immowelt",
		.url = "https://www.immowelt.de/benutzerkonto/loeschen/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3f4,
		.name = "imo.im",
		.query = "imoim",
		.url = "https://imo.im",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3f5,
		.name = "iMockup",
		.query = "imockup",
		.url = "https://www.imockup.app/",
		.email = "mailto:support@imockup.app?subject=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x3f6,
		.name = "impots.gouv.fr",
		.query = "impotsgouvfr",
		.url = "https://www.impots.gouv.fr/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x3f7,
		.name = "Incogni",
		.query = "incogni",
		.url = "https://incogni.com/",
		.email = "mailto:support@incogni.com?subject=Account%20Deletion%20Request&body=Hello%2C%0A%0AI%20am%20requesting%20the%20deletion%20of%20my%20Incogni%20account%20and%20information%20associated%20with%20this%20email.%20I%20would%20also%20like%20to%20withdraw%20the%20consent%20given%20in%20the%20Authorization%20Form.%0A%0AI%20understand%20that%20by%20terminating%20my%20account%20I%20will%20lose%20any%20remaining%20time%20on%20my%20current%20subscription%20and%20I%20wish%20to%20proceed%20anyway.%0A%0AThanks.",
		.difficulty = 0x1000
	},
	{
		.id = 0x3f8,
		.name = "Indeed",
		.query = "indeed",
		.url = "https://secure.indeed.com/settings/account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3f9,
		.name = "IndieGala",
		.query = "indiegala",
		.url = "https://docs.indiegala.com/support/contacts.html#customer-support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x3fa,
		.name = "Indiegogo",
		.query = "indiegogo",
		.url = "https://www.indiegogo.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3fb,
		.name = "Infinibrowser",
		.query = "infinibrowser",
		.url = "https://infinibrowser.wiki/profile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3fc,
		.name = "Infinite Story",
		.query = "infinite story",
		.url = "https://infinite-story.com/my/settings.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x3fd,
		.name = "Infinity Free",
		.query = "infinity free",
		.url = "https://dash.infinityfree.com/users",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x3fe,
		.name = "InfoCasas",
		.query = "infocasas",
		.url = "https://www.infocasas.com.uy/dashboard",
		.email = "mailto:info@infocasas.com.uy",
		.difficulty = 0x1000
	},
	{
		.id = 0x3ff,
		.name = "InfoJobs",
		.query = "infojobs",
		.url = "https://www.infojobs.net/candidate/settings/settings-cancel-account/cancel-account.xhtml",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x400,
		.name = "Ingress",
		.query = "ingress",
		.url = "https://support.ingress.com/hc/en-us/articles/206618198-I-want-to-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x401,
		.name = "Inhotim",
		.query = "inhotim",
		.url = "https://www.inhotim.org.br/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x402,
		.name = "Inkbunny",
		.query = "inkbunny",
		.url = "https://inkbunny.net/account.php#remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x403,
		.name = "InnoGames",
		.query = "innogames",
		.url = "https://goodbye.innogames.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x404,
		.name = "Inoreader",
		.query = "inoreader",
		.url = "https://www.inoreader.com/preferences/profile/cancel_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x405,
		.name = "insights",
		.query = "insights",
		.url = "https://insights.gg/dashboard/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x406,
		.name = "Instacart",
		.query = "instacart",
		.url = "https://www.instacart.com/user_privacy/form/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x407,
		.name = "Instagram",
		.query = "instagram",
		.url = "https://accountscenter.instagram.com/personal_info/account_ownership_and_control/deletion_and_deactivation",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x408,
		.name = "Instant Gaming",
		.query = "instant gaming",
		.url = "https://www.instant-gaming.com/de/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x409,
		.name = "Instapaper",
		.query = "instapaper",
		.url = "https://www.instapaper.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x40a,
		.name = "Instructables",
		.query = "instructables",
		.url = "https://www.instructables.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x40b,
		.name = "Intel",
		.query = "intel",
		.url = "https://www.intel.com/content/www/us/en/secure/my-intel/frequently-asked-questions.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x40c,
		.name = "Intelius People Finder",
		.query = "intelius people finder",
		.url = "https://www.intelius.com/dashboard/support/contact",
		.email = "mailto:support@mailer.intelius.com?subject=Information%20Deletion%20Request",
		.difficulty = 0x2000
	},
	{
		.id = 0x40d,
		.name = "Intelligence X",
		.query = "intelligence x",
		.url = "https://intelx.io/account?tab=settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x40e,
		.name = "Interactive Brokers",
		.query = "interactive brokers",
		.url = "https://www.interactivebrokers.com/RegTemplates/PDF/closeAccount.pdf",
		.email = "mailto:accountmanagement@interactivebrokers.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x40f,
		.name = "Intercity",
		.query = "intercity",
		.url = "https://bilet.intercity.pl/login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x410,
		.name = "Internet Archive / Open Library",
		.query = "internet archive open library",
		.url = "https://help.archive.org/help/how-do-i-delete-my-account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x411,
		.name = "Internetometer",
		.query = "internetometer",
		.url = "https://internetometer.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x412,
		.name = "Interrail",
		.query = "interrail",
		.url = "https://www.interrail.eu/",
		.email = "mailto:privacy@eurail.com?body=Please%20delete%20my%20Interrail%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x413,
		.name = "Intigriti",
		.query = "intigriti",
		.url = "https://kb.intigriti.com/en/articles/6839008-privacy-statement-intigriti-researcher",
		.email = "mailto:privacy@intigriti.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x414,
		.name = "Into Real Pages",
		.query = "into real pages",
		.url = "https://intorealpages.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x415,
		.name = "Invajo",
		.query = "invajo",
		.url = "https://home.invajo.com/contact",
		.email = "mailto:support@invajo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x416,
		.name = "The Inventory",
		.query = "the inventory",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x417,
		.name = "Inventory Shield",
		.query = "inventory shield",
		.url = "https://inventoryshield.com/support_docs/user-account-details/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x418,
		.name = "Investopedia",
		.query = "investopedia",
		.url = "https://invcontent.zendesk.com/hc/en-us/articles/360017064553-Account-Deletion",
		.email = "mailto:privacy@investopedia.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x419,
		.name = "InVideo",
		.query = "invideo",
		.url = "https://help.invideo.io/articles/56692-how-do-i-delete-my-account",
		.email = "mailto:support@invideo.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x41a,
		.name = "Invidious",
		.query = "invidious",
		.url = "https://redirect.invidious.io/preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x41b,
		.name = "Invision",
		.query = "invision",
		.url = "https://support.invisionapp.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x41c,
		.name = "IO Interactive",
		.query = "io interactive",
		.url = "https://account.ioi.dk/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x41d,
		.name = "iOSGods",
		.query = "iosgods",
		.url = "https://iosgods.com/settings/account-security/#requestAccountDeletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x41e,
		.name = "ipinfo.io",
		.query = "ipinfoio",
		.url = "https://ipinfo.io/faq/article/126-deleting-ipinfo-account",
		.email = "mailto:support@ipinfo.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x41f,
		.name = "IranTalent",
		.query = "irantalent",
		.url = "https://www.irantalent.com/en/privacy-and-policy",
		.email = "mailto:info@irantalent.com?subject=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x420,
		.name = "IRCCloud",
		.query = "irccloud",
		.url = "https://www.irccloud.com/?/settings=account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x421,
		.name = "Issuu",
		.query = "issuu",
		.url = "https://issuu.com/home/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x422,
		.name = "iStudiez",
		.query = "istudiez",
		.url = "https://support.istudentpro.com/support/solutions/articles/3000068641-delete-cloud-sync-account",
		.email = "mailto:support@istudentpro.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x423,
		.name = "ITalki",
		.query = "italki",
		.url = "https://www.italki.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x424,
		.name = "itch.io",
		.query = "itchio",
		.url = "https://itch.io/user/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x425,
		.name = "ITV",
		.query = "itv",
		.url = "https://www.itv.com/watch/user/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x426,
		.name = "iubenda",
		.query = "iubenda",
		.url = "https://www.iubenda.com/en/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x427,
		.name = "iversity",
		.query = "iversity",
		.url = "https://iversity.org/de/user/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x428,
		.name = "IVPN",
		.query = "ivpn",
		.url = "https://www.ivpn.net/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x429,
		.name = "Jalopnik",
		.query = "jalopnik",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x42a,
		.name = "JavaRush",
		.query = "javarush",
		.url = "https://javarush.com/en/settings/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x42b,
		.name = "JB Hi-Fi",
		.query = "jb hifi",
		.url = "https://support.jbhifi.com.au/hc/en-au/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x42c,
		.name = "JDate.com",
		.query = "jdatecom",
		.url = "https://www.jdate.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x42d,
		.name = "JEDEC",
		.query = "jedec",
		.url = "https://www.jedec.org/user",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x42e,
		.name = "jeevansathi",
		.query = "jeevansathi",
		.url = "https://www.jeevansathi.com/",
		.email = "mailto:help@jeevansathi.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x42f,
		.name = "JetBrains",
		.query = "jetbrains",
		.url = "https://account.jetbrains.com/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x430,
		.name = "JetBrains Academy (Hyperskill)",
		.query = "jetbrains academy hyperskill",
		.url = "https://hyperskill.org/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x431,
		.name = "JetBrains Space",
		.query = "jetbrains space",
		.url = "https://space-support.jetbrains.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x432,
		.name = "Jezebel",
		.query = "jezebel",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x433,
		.name = "Jimdo",
		.query = "jimdo",
		.url = "https://help.jimdo.com/hc/en-us/articles/115005540586-How-do-I-delete-my-Jimdo-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x434,
		.name = "Jobindex.dk",
		.query = "jobindexdk",
		.url = "https://www.jobindex.dk/bruger/slet",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x435,
		.name = "Jobscan",
		.query = "jobscan",
		.url = "https://www.jobscan.co/privacy",
		.email = "mailto:support@jobscan.co?subject=Request%20for%20Permanent%20Removal%20of%20Personal%20Information&body=Hello%2C%250D%250A%250D%250AI%20would%20like%20to%20permanently%20remove%20my%20account%20and%20information%20from%20Jobscan%2C%20as%20per%20your%20Privacy%20Policy.%20My%20account%20email%20address%20is%20XXXXXXXXXXX.%250D%250A%250D%250AThank%20you",
		.difficulty = 0x1000
	},
	{
		.id = 0x436,
		.name = "Jobstreet",
		.query = "jobstreet",
		.url = "https://myjobstreet-id.jobstreet.co.id/registration/delete-account.php",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x437,
		.name = "JobToday",
		.query = "jobtoday",
		.url = "https://jobtoday.com/",
		.email = "mailto:privacy@jobtoday.com?body=I%20want%20my%20account%20to%20be%20deleted.%20My%20full%20name%20is%20XXXXXX%20and%20my%20user%20name%20is%20XXXXXX%2C%20I%20want%20my%20account%20to%20be%20deleted%20because%20of%20XXXXXX.%20I%20request%20and%20authorize%20you%20to%20remove%20my%20profile%20from%20jobtoday.com%20and%20delete%20all%20my%20content%20with%20you.%20I%20wish%20to%20terminate%20the%20JobToday%20End%20User%20Agreement%20and%20agree%20to%20the%20Terms%20and%20Conditions%20as%20set%20in%20the%20End%20User%20Agreement%20for%20the%20termination%20process.",
		.difficulty = 0x1000
	},
	{
		.id = 0x438,
		.name = "Joinrs",
		.query = "joinrs",
		.url = "https://www.joinrs.com/en/profile/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x439,
		.name = "Jolla Account",
		.query = "jolla account",
		.url = "https://account.jolla.com/profile/settings/confirm_delete_profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x43a,
		.name = "Joom",
		.query = "joom",
		.url = "https://www.joom.com/en/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x43b,
		.name = "Jottacloud",
		.query = "jottacloud",
		.url = "https://www.jottacloud.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x43c,
		.name = "Journal du geek",
		.query = "journal du geek",
		.url = "http://www.journaldugeek.com/editer-profil/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x43d,
		.name = "Journey",
		.query = "journey",
		.url = "https://journey.cloud",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x43e,
		.name = "JS Bin",
		.query = "js bin",
		.url = "https://jsbin.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x43f,
		.name = "JSFiddle",
		.query = "jsfiddle",
		.url = "https://jsfiddle.net/user/settings/remove_account/",
		.email = "mailto:support@jsfiddle.net",
		.difficulty = 0x400
	},
	{
		.id = 0x440,
		.name = "Jstris",
		.query = "jstris",
		.url = "https://jstris.jezevec10.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x441,
		.name = "juejin",
		.query = "juejin",
		.url = "https://juejin.cn/user/settings/account",
		.email = "mailto:support@keepersecurity.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x442,
		.name = "Jusbrasil",
		.query = "jusbrasil",
		.url = "https://www.jusbrasil.com.br/configuracoes",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x443,
		.name = "Just Giving",
		.query = "just giving",
		.url = "https://help.justgiving.com/hc/en-us/articles/200670321-How-do-I-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x444,
		.name = "JustinGuitar",
		.query = "justinguitar",
		.url = "https://www.justinguitar.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x445,
		.name = "Kadenze",
		.query = "kadenze",
		.url = "https://help.kadenze.com/hc/en-us/requests/new?src=www.kadenze.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x446,
		.name = "Kaggle",
		.query = "kaggle",
		.url = "https://www.kaggle.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x447,
		.name = "Kagi",
		.query = "kagi",
		.url = "https://kagi.com/settings/user_details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x448,
		.name = "Kahoot",
		.query = "kahoot",
		.url = "https://create.kahoot.it/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x449,
		.name = "Kaize",
		.query = "kaize",
		.url = "https://kaize.io/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x44a,
		.name = "Kakao",
		.query = "kakao",
		.url = "https://accounts.kakao.com/weblogin/deactivate",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x44b,
		.name = "Kaleido (remove.bg, unscreen, designify)",
		.query = "kaleido removebg unscreen designify",
		.url = "https://accounts.kaleido.ai/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x44c,
		.name = "KanbanFlow",
		.query = "kanbanflow",
		.url = "https://kanbanflow.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x44d,
		.name = "Kanji Koohii",
		.query = "kanji koohii",
		.url = "https://kanji.koohii.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x44e,
		.name = "Kaspersky",
		.query = "kaspersky",
		.url = "https://my.kaspersky.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x44f,
		.name = "Kattis",
		.query = "kattis",
		.url = "https://support.kattis.com/support/solutions/articles/79000109991-how-do-i-delete-my-kattis-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x450,
		.name = "KBDfans",
		.query = "kbdfans",
		.url = "https://kbdfans.com/pages/contact-1",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x451,
		.name = "KBin",
		.query = "kbin",
		.url = "https://kbin.social/settings/general",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x452,
		.name = "KDE Bugtracking System",
		.query = "kde bugtracking system",
		.url = "https://bugs.kde.org",
		.email = "mailto:sysadmin@kde.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x453,
		.name = "Keepa",
		.query = "keepa",
		.url = "https://keepa.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x454,
		.name = "Keeper",
		.query = "keeper",
		.url = "https://www.keepersecurity.com/privacypolicy.html?t=v#:~:text=You%20may%20deactivate%20your%20Keeper%20Security%20account%20and%20delete%20your%20personally%20identifiable%20information%20at%20any%20time%20by%20contacting%20us%20at%20support%40keepersecurity.com%20clearly%20indicating%20that%20you%20wish%20to%20deactivate%20and%20delete%20such%20information.",
		.email = "mailto:support@keepersecurity.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x455,
		.name = "Kendall County History",
		.query = "kendall county history",
		.url = "https://www.kendallcountyhistory.org/contact",
		.email = "mailto:contact@kendallcountyhistory.org?subject=Delete%20My%20Profile",
		.difficulty = 0x1000
	},
	{
		.id = 0x456,
		.name = "Keybase.io",
		.query = "keybaseio",
		.url = "https://keybase.io/account/delete_me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x457,
		.name = "KGames",
		.query = "kgames",
		.url = "https://kgames.fr/profil",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x458,
		.name = "Khan Academy",
		.query = "khan academy",
		.url = "https://www.khanacademy.org/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x459,
		.name = "Kick Streaming",
		.query = "kick streaming",
		.url = "https://kick.com/",
		.email = "mailto:support@kick.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x45a,
		.name = "Kickstarter",
		.query = "kickstarter",
		.url = "https://www.kickstarter.com/profile/destroy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x45b,
		.name = "Kijiji",
		.query = "kijiji",
		.url = "https://help.kijiji.ca/helpdesk/contact-us-step/other",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x45c,
		.name = "Kik",
		.query = "kik",
		.url = "https://ws.kik.com/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x45d,
		.name = "Killstar",
		.query = "killstar",
		.url = "https://us.killstar.com/pages/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x45e,
		.name = "Kinguin",
		.query = "kinguin",
		.url = "https://www.kinguin.net/about-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x45f,
		.name = "Kinja",
		.query = "kinja",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x460,
		.name = "Kino.dk",
		.query = "kinodk",
		.url = "https://kino.dk/user",
		.email = "mailto:kontakt@kino.dk?subject=Sletning%20af%20profil&body=Jeg%20%C3%B8nsker%20at%20slette%20min%20konto%20hos%20jer.%20Tak.",
		.difficulty = 0x1000
	},
	{
		.id = 0x461,
		.name = "Kistania",
		.query = "kistania",
		.url = "https://www.kistania.com/pages/contact-us",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x462,
		.name = "Kit.co",
		.query = "kitco",
		.url = "https://kit.co/terms#contact",
		.email = "mailto:support@kit.co",
		.difficulty = 0x1000
	},
	{
		.id = 0x463,
		.name = "Kitsu",
		.query = "kitsu",
		.url = "https://kitsu.io/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x464,
		.name = "Kixeye",
		.query = "kixeye",
		.url = "https://corp.kixeye.com/pp.html",
		.email = "mailto:privacy@kixeye.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x465,
		.name = "Klarna",
		.query = "klarna",
		.url = "https://www.klarna.com/us/customer-service/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x466,
		.name = "Kleinanzeigen",
		.query = "kleinanzeigen",
		.url = "https://themen.kleinanzeigen.de/hilfe/nutzerkonto/datenloeschung/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x467,
		.name = "Knetbooks",
		.query = "knetbooks",
		.url = "https://www.knetbooks.com/account/settings",
		.email = "mailto:privacyrequest@knetbooks.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x468,
		.name = "Ko-fi",
		.query = "kofi",
		.url = "https://ko-fi.com/Manage/DeleteAccount/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x469,
		.name = "Kogan",
		.query = "kogan",
		.url = "https://www.kogan.com/au/contact-us/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x46a,
		.name = "Koingo Software",
		.query = "koingo software",
		.url = "https://www.koingosw.com/account/delete.php",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x46b,
		.name = "Komoot",
		.query = "komoot",
		.url = "https://account.komoot.com/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x46c,
		.name = "Kongregate",
		.query = "kongregate",
		.url = "https://www.kongregate.com/en/accounts",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x46d,
		.name = "Koofr",
		.query = "koofr",
		.url = "https://app.koofr.net/app/remove-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x46e,
		.name = "Kotaku",
		.query = "kotaku",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x46f,
		.name = "Koyeb",
		.query = "koyeb",
		.url = "https://app.koyeb.com/settings?settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x470,
		.name = "Krafton",
		.query = "krafton",
		.url = "https://accounts.krafton.com/personal-info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x471,
		.name = "Kraken",
		.query = "kraken",
		.url = "https://support.kraken.com/hc/en-us/articles/203727206-How-can-I-delete-my-Kraken-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x472,
		.name = "Kucoin",
		.query = "kucoin",
		.url = "https://www.kucoin.com/support/17881088289305",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x473,
		.name = "Kununu",
		.query = "kununu",
		.url = "https://www.kununu.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x474,
		.name = "Kwai",
		.query = "kwai",
		.url = "https://www.kwai.com/legal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x475,
		.name = "Kyun!",
		.query = "kyun",
		.url = "https://kyun.host/dashboard",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x476,
		.name = "L'identité Numérique La Poste",
		.query = "lidentite numerique la poste",
		.url = "https://aide.lidentitenumerique.laposte.fr/kb/guide/fr/comment-supprimer-mon-identite-numerique-DmTz0vr4Hc/Steps/101590",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x477,
		.name = "L'VA",
		.query = "lva",
		.url = "https://www.lva-mobilite.fr/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x478,
		.name = "La Caméra Embarquée",
		.query = "la camera embarquee",
		.url = "https://www.lacameraembarquee.fr/en/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x479,
		.name = "La Poste",
		.query = "la poste",
		.url = "https://aide.laposte.fr/mesdonneespersonnelles/moncompte/suppression",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x47a,
		.name = "La Redoute",
		.query = "la redoute",
		.url = "https://www.laredoute.com/privacy_center.aspx",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x47b,
		.name = "Lampyre",
		.query = "lampyre",
		.url = "https://lampyre.io/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x47c,
		.name = "Langfuse",
		.query = "langfuse",
		.url = "https://langfuse.com/support",
		.email = "mailto:security@langfuse.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x47d,
		.name = "LanguageTool",
		.query = "languagetool",
		.url = "https://languagetool.org/editor/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x47e,
		.name = "LaptopKeyReplacements",
		.query = "laptopkeyreplacements",
		.url = "https://www.laptopkeyreplacements.com/contact-us/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x47f,
		.name = "Last.fm",
		.query = "lastfm",
		.url = "https://www.last.fm/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x480,
		.name = "LastPass",
		.query = "lastpass",
		.url = "https://lastpass.com/delete_account.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x481,
		.name = "Lattice Semiconductor",
		.query = "lattice semiconductor",
		.url = "https://www.latticesemi.com/About/ContactUs",
		.email = "mailto:webmaster@latticesemi.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x482,
		.name = "Launchpad",
		.query = "launchpad",
		.url = "https://help.launchpad.net/YourAccount/Closing",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x483,
		.name = "Lazada",
		.query = "lazada",
		.url = "https://helpcenter.lazada.co.id/s/faq/knowledge?categoryId=1000027486&m_station=faq&questionId=1000142195",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x484,
		.name = "LBRY / Odysee",
		.query = "lbry odysee",
		.url = "https://odysee.com/$/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x485,
		.name = "League of Legends",
		.query = "league of legends",
		.url = "https://support-leagueoflegends.riotgames.com/hc/en-us/articles/360050328454",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x486,
		.name = "League of Legends: Wild Rift",
		.query = "league of legends wild rift",
		.url = "https://support-leagueoflegends.riotgames.com/hc/en-us/articles/360050328454",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x487,
		.name = "Leave Me Alone",
		.query = "leave me alone",
		.url = "https://app.leavemealone.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x488,
		.name = "Leboncoin",
		.query = "leboncoin",
		.url = "https://www.leboncoin.fr/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x489,
		.name = "LeetCode",
		.query = "leetcode",
		.url = "https://leetcode.com/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x48a,
		.name = "Leetify",
		.query = "leetify",
		.url = "https://leetify.com/app/support",
		.email = "mailto:support@leetify.com?subject=Leetify%20Account%20Deletion%20Request&body=Hello%2C%0A%0AI%20request%20for%20my%20Leetify.com%20account%20and%20all%20associated%20information%20be%20permanently%20deleted.%0AMy%20account%27s%20email%20address%20is%20LEETIFYEMAILADDRESS%20and%20my%20Leetify%20ID%20is%20LEETIFYACCOUNTID.%0A%0AThank%20you.",
		.difficulty = 0x1000
	},
	{
		.id = 0x48b,
		.name = "Legends of Runeterra",
		.query = "legends of runeterra",
		.url = "https://support-legendsofruneterra.riotgames.com/hc/en-us/articles/360051089233-Deleting-Your-Riot-Account-and-All-Your-Data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x48c,
		.name = "Lego",
		.query = "lego",
		.url = "https://identity.lego.com/profile/security/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x48d,
		.name = "Lemehost",
		.query = "lemehost",
		.url = "https://lemehost.com/user/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x48e,
		.name = "Lenovo Forums",
		.query = "lenovo forums",
		.url = "https://forums.lenovo.com/user/myprofilepage/personal/closeaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x48f,
		.name = "Lenovo ID",
		.query = "lenovo id",
		.url = "https://privacyportal.onetrust.com/webform/3c884b5f-db83-4077-91c8-fbfdaaba21fe/f15f8a67-782c-48c4-bf1e-0d7e6cd9b464",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x490,
		.name = "Lensbest",
		.query = "lensbest",
		.url = "https://www.lensbest.de/INTERSHOP/web/WFS/Lensbest-LensbestShop-Site/de_DE/-/EUR/ViewProfileSettings-ViewRemoveAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x491,
		.name = "Lenstore",
		.query = "lenstore",
		.url = "https://www.lenstore.co.uk/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x492,
		.name = "Letgo",
		.query = "letgo",
		.url = "https://help.letgo.com/hc/en-001/requests/new?ticket_form_id=5285423513618",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x493,
		.name = "Letterboxd",
		.query = "letterboxd",
		.url = "https://letterboxd.com/user/disableaccount/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x494,
		.name = "Letudiant",
		.query = "letudiant",
		.url = "https://my.letudiant.fr/tableau-de-bord/parametres/supprimer-mon-compte",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x495,
		.name = "LetyShops",
		.query = "letyshops",
		.url = "https://letyshops.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x496,
		.name = "LG Account",
		.query = "lg account",
		.url = "https://us.lgaccount.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x497,
		.name = "Liberland",
		.query = "liberland",
		.url = "https://liberland.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x498,
		.name = "Liberty Lines",
		.query = "liberty lines",
		.url = "https://booking.libertylines.it/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x499,
		.name = "LibraryThing",
		.query = "librarything",
		.url = "https://www.librarything.de/editprofile/change",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x49a,
		.name = "Libre.fm",
		.query = "librefm",
		.url = "https://libre.fm/user-edit.php#",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x49b,
		.name = "Lichess",
		.query = "lichess",
		.url = "https://lichess.org/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x49c,
		.name = "lidraughts",
		.query = "lidraughts",
		.url = "https://lidraughts.org/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x49d,
		.name = "Lieferando",
		.query = "lieferando",
		.url = "https://www.lieferando.de/en/customerservice/article/how-do-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x49e,
		.name = "Life360",
		.query = "life360",
		.url = "https://support.life360.com/hc/en-us/articles/360051153713-Delete-My-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x49f,
		.name = "Lifehacker",
		.query = "lifehacker",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4a0,
		.name = "Lifesum",
		.query = "lifesum",
		.url = "https://lifesum.com/account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4a1,
		.name = "Lil'bots",
		.query = "lilbots",
		.url = "https://www.lilbots.io/pages/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4a2,
		.name = "Lime",
		.query = "lime",
		.url = "https://www.li.me/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4a3,
		.name = "Line",
		.query = "line",
		.url = "https://help.line.me/line/?contentId=20000121",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4a4,
		.name = "Lingopie",
		.query = "lingopie",
		.url = "https://lingopie.com/privacy-policy",
		.email = "mailto:info@lingopie.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4a5,
		.name = "Lingualeo",
		.query = "lingualeo",
		.url = "https://lingualeo.com/profile/edit",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4a6,
		.name = "Lingvano",
		.query = "lingvano",
		.url = "https://linking.lingvano.com/TEoq",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4a7,
		.name = "Lingvist",
		.query = "lingvist",
		.url = "https://lingvist.com/help/how-to-delete-my-account-and-download-my-data/",
		.email = "mailto:hello@lingvist.io",
		.difficulty = 0x400
	},
	{
		.id = 0x4a8,
		.name = "LinkedIn",
		.query = "linkedin",
		.url = "https://www.linkedin.com/help/linkedin/answer/63",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4a9,
		.name = "Linktree",
		.query = "linktree",
		.url = "https://linktr.ee/admin/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4aa,
		.name = "Linkvertise",
		.query = "linkvertise",
		.url = "https://linkvertise.com/imprint",
		.email = "mailto:info@linkvertise.com?subject=Linkvertise%20account%20deletion%20request",
		.difficulty = 0x1000
	},
	{
		.id = 0x4ab,
		.name = "Linode",
		.query = "linode",
		.url = "https://cloud.linode.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ac,
		.name = "Linsensuppe",
		.query = "linsensuppe",
		.url = "https://www.linsensuppe.de",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4ad,
		.name = "Linus Tech Tips Store",
		.query = "linus tech tips store",
		.url = "https://www.lttstore.com/pages/privacy-policy",
		.email = "mailto:support@lttstore.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4ae,
		.name = "Listia",
		.query = "listia",
		.url = "https://help.listia.com/hc/en-us/articles/203895428-How-do-I-delete-close-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4af,
		.name = "Litmus",
		.query = "litmus",
		.url = "https://help.litmus.com/article/420-delete-your-account",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x4b0,
		.name = "Live Nation",
		.query = "live nation",
		.url = "https://privacyportal.onetrust.com/webform/ba6f9c5b-dda5-43bd-bac4-4e06afccd928/ba7654b2-26ce-47df-8954-0884b9a0cea5",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4b1,
		.name = "LiveJournal",
		.query = "livejournal",
		.url = "https://www.livejournal.com/accountstatus.bml",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4b2,
		.name = "Livelo",
		.query = "livelo",
		.url = "https://www.livelo.com.br/profile?occsite=points&tab=tab_label_1",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4b3,
		.name = "Lnk.Bio",
		.query = "lnkbio",
		.url = "https://help.lnk.bio/en/articles/4300436-how-do-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4b4,
		.name = "Lobsters",
		.query = "lobsters",
		.url = "https://lobste.rs/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4b5,
		.name = "LOBSTR",
		.query = "lobstr",
		.url = "https://lobstr.co/settings/#profile-tab",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4b6,
		.name = "Login.gov",
		.query = "logingov",
		.url = "https://secure.login.gov/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4b7,
		.name = "Logitech",
		.query = "logitech",
		.url = "https://support.logi.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4b8,
		.name = "LogMeIn / Hamachi",
		.query = "logmein hamachi",
		.url = "https://submit-irm.trustarc.com/services/validation/818563f9-8d9c-4029-880a-bc743fb49de5",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4b9,
		.name = "Logo Maker",
		.query = "logo maker",
		.url = "https://www.logomaker.com/contact-us/",
		.email = "mailto:help@logomaker.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4ba,
		.name = "LogRocket",
		.query = "logrocket",
		.url = "https://docs.logrocket.com/docs/security",
		.email = "mailto:support@logrocket.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4bb,
		.name = "Lolja",
		.query = "lolja",
		.url = "https://lolja.com.br",
		.email = "mailto:sac@lolja.com.br",
		.difficulty = 0x1000
	},
	{
		.id = 0x4bc,
		.name = "Lookout",
		.query = "lookout",
		.url = "https://www.lookout.com/#/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4bd,
		.name = "LoseIt",
		.query = "loseit",
		.url = "https://loseit.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4be,
		.name = "Love My Credit Union Rewards",
		.query = "love my credit union rewards",
		.url = "https://rewards.lovemycreditunion.org/contact-us/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4bf,
		.name = "LowEndTalk",
		.query = "lowendtalk",
		.url = "https://lowendtalk.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4c0,
		.name = "Lucidchart",
		.query = "lucidchart",
		.url = "https://www.lucidchart.com/users/login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4c1,
		.name = "Lucky Patcher Forum",
		.query = "lucky patcher forum",
		.url = "https://www.luckypatchers.com/forum/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4c2,
		.name = "Ludum Dare",
		.query = "ludum dare",
		.url = "https://ldjam.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4c3,
		.name = "Lufthansa",
		.query = "lufthansa",
		.url = "https://www.lufthansa.com/online/myportal/lh/uk/my_account/profile/update?action=deleteProfileAction",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4c4,
		.name = "Luma",
		.query = "luma",
		.url = "https://lu.ma/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4c5,
		.name = "LuminPDF",
		.query = "luminpdf",
		.url = "https://account.luminpdf.com/profile-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4c6,
		.name = "Lumosity",
		.query = "lumosity",
		.url = "https://app.lumosity.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4c7,
		.name = "Luno",
		.query = "luno",
		.url = "https://www.luno.com/help/en/tickets/new?category_id=19",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4c8,
		.name = "Lush",
		.query = "lush",
		.url = "https://www.lush.com/us/en_us/faq/usa-contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4c9,
		.name = "Lutris",
		.query = "lutris",
		.url = "https://lutris.net/user/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ca,
		.name = "LWN.net",
		.query = "lwnnet",
		.url = "https://lwn.net/op/Privacy.lwn",
		.email = "mailto:lwn@lwn.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x4cb,
		.name = "Lyconet",
		.query = "lyconet",
		.url = "https://www.lyconet.com/",
		.email = "mailto:data.protection@lyconet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4cc,
		.name = "Lyft",
		.query = "lyft",
		.url = "https://account.lyft.com/privacy/data",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4cd,
		.name = "M Covoit Lignes+",
		.query = "m covoit lignes",
		.url = "https://mcovoitlignesplus.zendesk.com/hc/fr/articles/360015255860-Comment-supprimer-mon-compte",
		.email = "mailto:support@lignesplus-m.fr",
		.difficulty = 0x1000
	},
	{
		.id = 0x4ce,
		.name = "M Mobilités / Appli M",
		.query = "m mobilites appli m",
		.url = "https://pass.mobilites-m.fr/mypass/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4cf,
		.name = "M Réso",
		.query = "m reso",
		.url = "https://www.reso-m.fr/TPL_CODE/TPL_ECNLDASHBOARD/6-tableau-de-bord.htm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d0,
		.name = "m9snoi",
		.query = "m9snoi",
		.url = "https://m9snoi.net/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4d1,
		.name = "Macrumors",
		.query = "macrumors",
		.url = "https://macrumors.zendesk.com/hc/en-us/articles/201260797-How-do-I-cancel-my-account-",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4d2,
		.name = "MacTrade",
		.query = "mactrade",
		.url = "https://www.mactrade.de/account/profile#confirmDeleteAccountModal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d3,
		.name = "MacUpdate",
		.query = "macupdate",
		.url = "https://www.macupdate.com/member/account-preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d4,
		.name = "Magasin",
		.query = "magasin",
		.url = "https://www.magasin.dk/profilaendring/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d5,
		.name = "Magicflow",
		.query = "magicflow",
		.url = "https://magicflow.com/profile/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d6,
		.name = "MAGIX",
		.query = "magix",
		.url = "https://www.magix.com/us/support/my-service-center/",
		.email = "mailto:infoservice@magix.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x4d7,
		.name = "Magoosh",
		.query = "magoosh",
		.url = "https://magoosh.zendesk.com/hc/en-us/articles/204307485-How-do-I-delete-my-account-",
		.email = "mailto:help@magoosh.com?subject=Need%20to%20delete%20my%20account",
		.difficulty = 0x400
	},
	{
		.id = 0x4d8,
		.name = "Mail.com",
		.query = "mailcom",
		.url = "https://support.mail.com/account/managing/delete.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4d9,
		.name = "Mail.ru",
		.query = "mailru",
		.url = "https://account.mail.ru/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4da,
		.name = "mailbox.org",
		.query = "mailboxorg",
		.url = "https://mailbox.org/en/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4db,
		.name = "MailChimp",
		.query = "mailchimp",
		.url = "https://kb.mailchimp.com/article/how-do-i-close-my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4dc,
		.name = "Mailfence",
		.query = "mailfence",
		.url = "https://kb.mailfence.com/kb/how-can-i-delete-my-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4dd,
		.name = "Mailspring",
		.query = "mailspring",
		.url = "https://id.getmailspring.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4de,
		.name = "Major League Hacking (MLH)",
		.query = "major league hacking mlh",
		.url = "https://my.mlh.io",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4df,
		.name = "MakeMyTrip",
		.query = "makemytrip",
		.url = "https://www.makemytrip.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e0,
		.name = "MakerBot",
		.query = "makerbot",
		.url = "https://cloudprint.makerbot.com/settings/account/info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e1,
		.name = "Mangadex",
		.query = "mangadex",
		.url = "https://mangadex.org/settings#del",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e2,
		.name = "Mangaupdates",
		.query = "mangaupdates",
		.url = "https://www.mangaupdates.com/site/faq/2#item34",
		.email = "mailto:lambchopsil@mangaupdates.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4e3,
		.name = "Mangools",
		.query = "mangools",
		.url = "https://mangools.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e4,
		.name = "Mapbox",
		.query = "mapbox",
		.url = "https://account.mapbox.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e5,
		.name = "MapMyFitness",
		.query = "mapmyfitness",
		.url = "https://www.mapmyfitness.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e6,
		.name = "MapMyRun",
		.query = "mapmyrun",
		.url = "https://www.mapmyrun.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e7,
		.name = "MapMyWalk",
		.query = "mapmywalk",
		.url = "https://www.mapmywalk.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e8,
		.name = "Mapstr",
		.query = "mapstr",
		.url = "https://en.mapstr.com/faq",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4e9,
		.name = "MarineTraffic",
		.query = "marinetraffic",
		.url = "https://www.marinetraffic.com/en/users/my_account/users/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ea,
		.name = "Markdown Converter",
		.query = "markdown converter",
		.url = "https://mdconverter.com/account/settings/deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4eb,
		.name = "Marktplaats",
		.query = "marktplaats",
		.url = "https://www.marktplaats.nl/my-account/profile/edit.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ec,
		.name = "Marq",
		.query = "marq",
		.url = "https://help.marq.com/delete-your-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4ed,
		.name = "Marvel",
		.query = "marvel",
		.url = "https://marvelapp.com/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ee,
		.name = "Mashable",
		.query = "mashable",
		.url = "https://support.stackcommerce.com/hc/en-us/requests/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4ef,
		.name = "Masiro",
		.query = "masiro",
		.url = "https://masiro.me/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4f0,
		.name = "MasterClass",
		.query = "masterclass",
		.url = "https://privacy.masterclass.com/policies",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x4f1,
		.name = "Mastodon.social",
		.query = "mastodonsocial",
		.url = "https://mastodon.social/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4f2,
		.name = "Match",
		.query = "match",
		.url = "https://help.match.com/hc/en-us/articles/5610035266075-Delete-My-Account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4f3,
		.name = "Mathpix",
		.query = "mathpix",
		.url = "https://accounts.mathpix.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4f4,
		.name = "Mathway",
		.query = "mathway",
		.url = "https://www.mathway.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4f5,
		.name = "Mathworks",
		.query = "mathworks",
		.url = "https://se.mathworks.com/company/aboutus/data-subject-access-request-form.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4f6,
		.name = "Maxdome",
		.query = "maxdome",
		.url = "https://faq.maxdome.de/frage/mxdallgemein/mxdalleszu/was-ist-maxdome/wo-finde-ich-den-live-chat-von-maxdome",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4f7,
		.name = "Maxforlive",
		.query = "maxforlive",
		.url = "https://support.cycling74.com/hc/en-us/articles/360049932234-Account-Access-Management",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4f8,
		.name = "MaxMind",
		.query = "maxmind",
		.url = "https://support.maxmind.com/hc/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4f9,
		.name = "Mbed",
		.query = "mbed",
		.url = "https://os.mbed.com/account/edit/account-options/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4fa,
		.name = "McAfee",
		.query = "mcafee",
		.url = "https://home.mcafee.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x4fb,
		.name = "McDonald's",
		.query = "mcdonalds",
		.url = "https://www.mcdonalds.com/us/en-us/faq/how-do-i-delete-my-account.html",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x4fc,
		.name = "McVIP",
		.query = "mcvip",
		.url = "https://mcvip.mcdonalds.de/#/profil",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4fd,
		.name = "Mealpal",
		.query = "mealpal",
		.url = "https://www.mealpal.com/privacy-policy/",
		.email = "mailto:privacy@mealpal.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x4fe,
		.name = "Medal",
		.query = "medal",
		.url = "https://medal.tv/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x4ff,
		.name = "MediaFire",
		.query = "mediafire",
		.url = "https://www.mediafire.com/myaccount/accountbilling.php",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x500,
		.name = "Mediapart",
		.query = "mediapart",
		.url = "https://www.mediapart.fr/contenu/conditions-generales-d-utilisation",
		.email = "mailto:contact@mediapart.fr?body=Please%20delete%20all%20information%20and%20data%20associated%20with%20my%20account.%20My%20username%20is%20XXXXXX.",
		.difficulty = 0x1000
	},
	{
		.id = 0x501,
		.name = "Medium",
		.query = "medium",
		.url = "https://medium.com/me/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x502,
		.name = "MeetFrank",
		.query = "meetfrank",
		.url = "https://meetfrank.com",
		.email = "mailto:team@meetfrank.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x503,
		.name = "Meetup",
		.query = "meetup",
		.url = "https://help.meetup.com/hc/en-us/articles/360050018571-Request-permanent-deletion-of-your-data",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x504,
		.name = "MEGA",
		.query = "mega",
		.url = "https://mega.nz/fm/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x505,
		.name = "Megaknihy",
		.query = "megaknihy",
		.url = "https://www.megaknihy.cz/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x506,
		.name = "Megaxus",
		.query = "megaxus",
		.url = "https://megaxus.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x507,
		.name = "Melodics",
		.query = "melodics",
		.url = "https://melodics.com/support#form-header",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x508,
		.name = "MemeFast.app",
		.query = "memefastapp",
		.url = "https://memefast.app",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x509,
		.name = "Memrise",
		.query = "memrise",
		.url = "https://www.memrise.com/settings/deactivate/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x50a,
		.name = "Mendeley",
		.query = "mendeley",
		.url = "https://www.mendeley.com/settings/account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x50b,
		.name = "Mercado Libre Argentina",
		.query = "mercado libre argentina",
		.url = "https://myaccount.mercadolibre.com.ar/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x50c,
		.name = "Mercado Libre Bolivia",
		.query = "mercado libre bolivia",
		.url = "https://myaccount.mercadolibre.com.bo/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x50d,
		.name = "Mercado Libre Chile",
		.query = "mercado libre chile",
		.url = "https://myaccount.mercadolibre.cl/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x50e,
		.name = "Mercado Libre Colombia",
		.query = "mercado libre colombia",
		.url = "https://myaccount.mercadolibre.com.co/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x50f,
		.name = "Mercado Libre Costa Rica",
		.query = "mercado libre costa rica",
		.url = "https://myaccount.mercadolibre.co.cr/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x510,
		.name = "Mercado Libre Ecuador",
		.query = "mercado libre ecuador",
		.url = "https://myaccount.mercadolibre.com.ec/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x511,
		.name = "Mercado Libre El Salvador",
		.query = "mercado libre el salvador",
		.url = "https://myaccount.mercadolibre.com.sv/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x512,
		.name = "Mercado Libre Guatemala",
		.query = "mercado libre guatemala",
		.url = "https://myaccount.mercadolibre.com.gt/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x513,
		.name = "Mercado Libre Honduras",
		.query = "mercado libre honduras",
		.url = "https://myaccount.mercadolibre.com.hn/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x514,
		.name = "Mercado Libre México",
		.query = "mercado libre mexico",
		.url = "https://myaccount.mercadolibre.com.mx/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x515,
		.name = "Mercado Libre Nicaragua",
		.query = "mercado libre nicaragua",
		.url = "https://myaccount.mercadolibre.com.ni/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x516,
		.name = "Mercado Libre Panamá",
		.query = "mercado libre panama",
		.url = "https://myaccount.mercadolibre.com.pa/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x517,
		.name = "Mercado Libre Paraguay",
		.query = "mercado libre paraguay",
		.url = "https://myaccount.mercadolibre.com.py/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x518,
		.name = "Mercado Libre Perú",
		.query = "mercado libre peru",
		.url = "https://myaccount.mercadolibre.com.pe/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x519,
		.name = "Mercado Libre República Dominicana",
		.query = "mercado libre republica dominicana",
		.url = "https://myaccount.mercadolibre.com.do/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x51a,
		.name = "Mercado Libre Uruguay",
		.query = "mercado libre uruguay",
		.url = "https://myaccount.mercadolibre.com.uy/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x51b,
		.name = "Mercado Libre Venezuela",
		.query = "mercado libre venezuela",
		.url = "https://myaccount.mercadolibre.com.ve/cancelar-cuenta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x51c,
		.name = "Mercado Livre Brasil",
		.query = "mercado livre brasil",
		.url = "https://myaccount.mercadolivre.com.br/cancelar-conta",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x51d,
		.name = "Mes Services Étudiant",
		.query = "mes services etudiant",
		.url = "https://www.messervices.etudiant.gouv.fr/envole/message/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x51e,
		.name = "Metacritic",
		.query = "metacritic",
		.url = "https://metacritichelp.zendesk.com/hc/en-us/requests/new?ticket_form_id=12053246153495",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x51f,
		.name = "MetalPay",
		.query = "metalpay",
		.url = "https://help.metalpay.com/hc/en-us/articles/4409445335063-How-do-I-close-my-Metal-Pay-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x520,
		.name = "MetLife",
		.query = "metlife",
		.url = "https://metlife.com.br/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x521,
		.name = "Metropolis",
		.query = "metropolis",
		.url = "https://app.metropolis.io/profile/terms-and-privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x522,
		.name = "MEXC",
		.query = "mexc",
		.url = "https://www.mexc.com/privacypolicy#:~:text=other%20applicable%20laws.-,ACCOUNT%20DELETION,-You%20may%20delete",
		.email = "mailto:dataprotect@mexc.com?subject=I%20request%20the%20deletion%20of%20my%20MEXC%20account&body=Good%20day%2C%20MEXC%20Data%20Protection%20team%21%20I%20hereby%20request%20the%20deletion%20of%20my%20MEXC%20account%2C%20with%20UID%20%23%20%28put%20the%20UID%20here%29.%20The%20reason%20I%20request%20this%20deletion%20is%3A%20%28state%20your%20reason%20here%29.%20I%20enclose%20the%20required%20identity%20proof.%20%28Include%20a%20photo%20of%20yourself%20holding%20your%20ID%20card%20and%20a%20handwritten%20piece%20of%20paper%20with%20the%20following%20information%3A%20%22Today%20is%20%28put%20date%20here%29.%20I%20request%20the%20deletion%20of%20my%20MEXC%20account%20with%20UID%20%28put%20your%20UID%20here%29.%20I%20confirm%20and%20accept%20to%20waive%20all%20assets%20contained%20in%20this%20account.%20%28sign%20here%29%22%29%20Thanks%20in%20advance%20for%20your%20help%21%20Sincerely%2C%20%28put%20your%20name%20here%29.",
		.difficulty = 0x1000
	},
	{
		.id = 0x523,
		.name = "Mi Account",
		.query = "mi account",
		.url = "https://account.xiaomi.com/pass/del",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x524,
		.name = "Mibbit",
		.query = "mibbit",
		.url = "https://chat.mibbit.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x525,
		.name = "Microsoft Account",
		.query = "microsoft account",
		.url = "https://account.live.com/closeaccount.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x526,
		.name = "Midjourney",
		.query = "midjourney",
		.url = "https://www.midjourney.com/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x527,
		.name = "Mikan Project",
		.query = "mikan project",
		.url = "https://mikanani.me/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x528,
		.name = "Milanote",
		.query = "milanote",
		.url = "https://app.milanote.com/account/settings/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x529,
		.name = "Mimo",
		.query = "mimo",
		.url = "https://getmimo.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x52a,
		.name = "MindMeister",
		.query = "mindmeister",
		.url = "https://accounts.meister.co/close_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x52b,
		.name = "Minds",
		.query = "minds",
		.url = "https://www.minds.com/settings/other/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x52c,
		.name = "Mine",
		.query = "mine",
		.url = "https://saymineapp.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x52d,
		.name = "Minecraft",
		.query = "minecraft",
		.url = "https://help.minecraft.net/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x52e,
		.name = "Minecraft Tools",
		.query = "minecraft tools",
		.url = "https://minecraft.tools/en/contact.php",
		.email = "mailto:contact@minecraft.tools",
		.difficulty = 0x2000
	},
	{
		.id = 0x52f,
		.name = "MinecraftRating",
		.query = "minecraftrating",
		.url = "https://minecraftrating.ru/contacts.html",
		.email = "mailto:admin@minecraftrating.ru?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20account%2C%20my%20username%20is%20XXXXXX%2C%20reason%3A%20XXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x530,
		.name = "Minehut",
		.query = "minehut",
		.url = "https://app.minehut.com/support/form",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x531,
		.name = "Minha Band",
		.query = "minha band",
		.url = "https://login.band.com.br/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x532,
		.name = "Miniclip",
		.query = "miniclip",
		.url = "https://me.miniclip.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x533,
		.name = "MinID",
		.query = "minid",
		.url = "https://eid.difi.no/en/minid/blocking-minid",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x534,
		.name = "Mint",
		.query = "mint",
		.url = "https://mint.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x535,
		.name = "mintos.com",
		.query = "mintoscom",
		.url = "https://help.mintos.com/hc/en-us/requests/new?ticket_form_id=1900000292453",
		.email = "mailto:support@mintos.com?subject=Request%20to%20delete%20my%20account%20from%20Mintos&body=I%20have%20an%20account%20in%20your%20database%20associated%20with%20the%20email%20address%20XXXXXX%20%28investor%20id%3A%20XXXXXX%29.%20I%20have%20decided%20not%20to%20use%20the%20account%20again%3B%20therefore%2C%20I%20request%20that%20you%20kindly%20delete%20my%20account%20from%20your%20database%20and%20delete%20all%20the%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x536,
		.name = "Miro",
		.query = "miro",
		.url = "https://miro.com/app/settings/user-profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x537,
		.name = "MisterWong",
		.query = "misterwong",
		.url = "https://www.mister-wong.de",
		.email = "mailto:support@mister-wong.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x538,
		.name = "Mistral AI",
		.query = "mistral ai",
		.url = "https://admin.mistral.ai/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x539,
		.name = "MixCloud",
		.query = "mixcloud",
		.url = "https://www.mixcloud.com/settings/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x53a,
		.name = "Mixlr",
		.query = "mixlr",
		.url = "https://mixlr.com/settings/account/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x53b,
		.name = "MMORPG.com",
		.query = "mmorpgcom",
		.url = "https://www.mmorpg.com/notice/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x53c,
		.name = "Mobalytics",
		.query = "mobalytics",
		.url = "https://mobalytics.gg/lol/account-settings/account-information",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x53d,
		.name = "Mobify",
		.query = "mobify",
		.url = "https://www.mobify.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x53e,
		.name = "Mobills",
		.query = "mobills",
		.url = "https://web.mobillsapp.com/Configuracoes/DeletaConta",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x53f,
		.name = "Mockflow",
		.query = "mockflow",
		.url = "https://support.mockflow.com/article/10-can-i-delete-my-mockflow-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x540,
		.name = "Modrinth",
		.query = "modrinth",
		.url = "https://modrinth.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x541,
		.name = "Mojang",
		.query = "mojang",
		.url = "https://account.mojang.com/me/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x542,
		.name = "Molotov",
		.query = "molotov",
		.url = "https://www.molotov.tv/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x543,
		.name = "Momox",
		.query = "momox",
		.url = "https://www.momox.de/kleidung-verkaufen/kontaktformular/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x544,
		.name = "Momox Fashion",
		.query = "momox fashion",
		.url = "https://momoxfashion.zendesk.com/hc/de/articles/360011251419-Ich-m%C3%B6chte-mein-Konto-abmelden-Wie-geht-das",
		.email = "mailto:support@momoxfashion.com?subject=Antrag%20auf%20L%C3%B6schung%20meines%20Momox-Fashion%20Kontos%20gem%C3%A4%C3%9F%20DSGVO%20Artikel%2017&body=Sehr%20geehrte%20Damen%20und%20Herren%2C%20hiermit%20beantrage%20ich%20die%20L%C3%B6schung%20meines%20Momox-Fashion%20Kontos%2C%20das%20unter%20der%20E-Mail-Adresse%20%27your-email%40address.here%27%20registriert%20ist.%20Gem%C3%A4%C3%9F%20Artikel%2017%20der%20Datenschutz-Grundverordnung%20%28DSGVO%29%20bitte%20ich%20um%20die%20vollst%C3%A4ndige%20L%C3%B6schung%20meiner%20personenbezogenen%20Daten%2C%20da%20ich%20nicht%20mehr%20an%20der%20Nutzung%20des%20Kontos%20interessiert%20bin.%20Ich%20bitte%20um%20eine%20Best%C3%A4tigung%20der%20L%C3%B6schung%20sowie%20um%20Informationen%20dar%C3%BCber%2C%20dass%20meine%20Daten%20tats%C3%A4chlich%20entfernt%20wurden.%20Vielen%20Dank%20und%20mit%20freundlichen%20Gr%C3%BC%C3%9Fen%2C%20%27Firstname%20Lastname%27",
		.difficulty = 0x1000
	},
	{
		.id = 0x545,
		.name = "Mon Compte Formation",
		.query = "mon compte formation",
		.url = "https://www.moncompteformation.gouv.fr/espace-public/comment-me-desinscrire-de-mon-compte-formation",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x546,
		.name = "Mon Espace Santé",
		.query = "mon espace sante",
		.url = "https://www.monespacesante.fr/questions-frequentes/acceder-a-mon-espace-sante/14",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x547,
		.name = "Mon Espace STAS",
		.query = "mon espace stas",
		.url = "https://www.reseau-stas.fr/fr/mon-espace-stas/159/Member/editprofile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x548,
		.name = "Monarch Money",
		.query = "monarch money",
		.url = "https://help.monarchmoney.com/hc/en-us/articles/4412388754708-Delete-a-Monarch-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x549,
		.name = "Money Dashboard",
		.query = "money dashboard",
		.url = "https://help.moneydashboard.com/hc/requests/new",
		.email = "mailto:support@moneydashboard.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x54a,
		.name = "Money Lover",
		.query = "money lover",
		.url = "https://web.moneylover.me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x54b,
		.name = "Money Saving Expert",
		.query = "money saving expert",
		.url = "https://clubs.moneysavingexpert.com/cheapenergyclub/my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x54c,
		.name = "MongoDB Atlas",
		.query = "mongodb atlas",
		.url = "https://docs.atlas.mongodb.com/tutorial/delete-atlas-account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x54d,
		.name = "Monkeytype",
		.query = "monkeytype",
		.url = "https://monkeytype.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x54e,
		.name = "Monoprice",
		.query = "monoprice",
		.url = "https://www.monoprice.com/Help/Index?pn=contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x54f,
		.name = "Monster",
		.query = "monster",
		.url = "https://www.monster.com/privacy/emailform",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x550,
		.name = "MonTCL",
		.query = "montcl",
		.url = "https://boutique.tcl.fr/en/account/personal-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x551,
		.name = "Moodle",
		.query = "moodle",
		.url = "https://moodle.org/admin/tool/dataprivacy/createdatarequest.php?type=2",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x552,
		.name = "Moonpig",
		.query = "moonpig",
		.url = "https://support-uk.moonpig.com/hc/en-gb/articles/360007011998-How-do-I-delete-my-Account-Data-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x553,
		.name = "Moovit",
		.query = "moovit",
		.url = "https://support.moovitapp.com/hc/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x554,
		.name = "Morningstar",
		.query = "morningstar",
		.url = "https://socialize.morningstar.com/feedback/feedbackform.asp",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x555,
		.name = "Mote",
		.query = "mote",
		.url = "https://support.mote.com/hc/en-us/articles/4407299329940-How-do-I-delete-my-account-",
		.email = "mailto:support@mote.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x556,
		.name = "MouseCTRL",
		.query = "mousectrl",
		.url = "https://mousectrl.com/",
		.email = "mailto:hello@mousectrl.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x557,
		.name = "Mouser",
		.query = "mouser",
		.url = "https://www.mouser.co.uk/privacypolicy",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x558,
		.name = "Moviepilot.de",
		.query = "moviepilotde",
		.url = "https://www.moviepilot.de/users/null/edit_membership",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x559,
		.name = "Mozilla Developer Network (MDN)",
		.query = "mozilla developer network mdn",
		.url = "https://bugzilla.mozilla.org/enter_bug.cgi?product=developer.mozilla.org",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x55a,
		.name = "Mozilla Support",
		.query = "mozilla support",
		.url = "https://support.mozilla.org/en-US/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x55b,
		.name = "MSI",
		.query = "msi",
		.url = "https://account.msi.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x55c,
		.name = "MTCGAME",
		.query = "mtcgame",
		.url = "https://www.mtcgame.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x55d,
		.name = "Muambator",
		.query = "muambator",
		.url = "https://www.muambator.com.br/perfil/minha-conta/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x55e,
		.name = "Mullvad",
		.query = "mullvad",
		.url = "https://mullvad.net/en/help/faq#119",
		.email = "mailto:support@mullvadvpn.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x55f,
		.name = "MultCloud",
		.query = "multcloud",
		.url = "https://www.multcloud.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x560,
		.name = "Multiplayer Game Hacking MPGH",
		.query = "multiplayer game hacking mpgh",
		.url = "https://www.mpgh.net/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x561,
		.name = "MuniMobile (San Francisco Municipal Transportation Agency)",
		.query = "munimobile san francisco municipal transportation agency",
		.url = "https://sfmta.transitsherpa.com/rider-web/",
		.email = "mailto:munimobile@sfmta.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x562,
		.name = "Munzee",
		.query = "munzee",
		.url = "https://www.munzee.com/privacy/",
		.email = "mailto:privacy@freezetag.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x563,
		.name = "Musei Italiani",
		.query = "musei italiani",
		.url = "https://portale.museiitaliani.it/b2c/myProfile",
		.email = "mailto:rpd@cultura.gov.it?subject=Elimina%20il%20mio%20account&body=Ciao%2C%0A%0ASi%20prega%20di%20eliminare%20il%20mio%20account%20YOUR_ACCOUNT%20e%20tutti%20i%20dati%20associati%20ad%20esso%2C%20per%20favore%0A%0AGrazie%20mille%2C",
		.difficulty = 0x1000
	},
	{
		.id = 0x564,
		.name = "Musescore",
		.query = "musescore",
		.url = "https://musescore.com/user/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x565,
		.name = "Musicboard",
		.query = "musicboard",
		.url = "https://musicboard.app/settings/preferences",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x566,
		.name = "MusicBrainz",
		.query = "musicbrainz",
		.url = "https://musicbrainz.org/account/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x567,
		.name = "Musixmatch",
		.query = "musixmatch",
		.url = "https://account.musixmatch.com/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x568,
		.name = "Mutant Mail",
		.query = "mutant mail",
		.url = "https://my.mutantmail.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x569,
		.name = "MXstore",
		.query = "mxstore",
		.url = "https://www.mxstore.com.au/submit-a-request",
		.email = "mailto:enquiries@mxstore.com.au",
		.difficulty = 0x1000
	},
	{
		.id = 0x56a,
		.name = "My Calendar",
		.query = "my calendar",
		.url = "https://www.simpleinnovation.us/contact",
		.email = "mailto:feedback@period-tracker.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x56b,
		.name = "My Fitness Pal",
		.query = "my fitness pal",
		.url = "https://www.myfitnesspal.com/en/account/confirm_delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x56c,
		.name = "My Invisalign",
		.query = "my invisalign",
		.url = "https://my.invisalign.com/myprofile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x56d,
		.name = "My Lands",
		.query = "my lands",
		.url = "https://uk.mlgame.org/",
		.email = "mailto:support_uk@elyland.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x56e,
		.name = "MyAbandonware",
		.query = "myabandonware",
		.url = "https://www.myabandonware.com/account/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x56f,
		.name = "MyAnimeList",
		.query = "myanimelist",
		.url = "https://myanimelist.net/account_deletion",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x570,
		.name = "MyCreds",
		.query = "mycreds",
		.url = "https://membertrustregistry.mycreds.ca",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x571,
		.name = "myESET",
		.query = "myeset",
		.url = "https://my.eset.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x572,
		.name = "MyFigureCollection",
		.query = "myfigurecollection",
		.url = "https://myfigurecollection.net/settings/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x573,
		.name = "MyFonts",
		.query = "myfonts",
		.url = "https://www.myfonts.com/my/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x574,
		.name = "MyFRITZ!",
		.query = "myfritz",
		.url = "https://sso.myfritz.net/account/#/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x575,
		.name = "Myfxbook",
		.query = "myfxbook",
		.url = "https://www.myfxbook.com/settings#profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x576,
		.name = "MyHeritage",
		.query = "myheritage",
		.url = "https://MyHeritage.com/",
		.email = "mailto:privacy_support@myheritage.com?subject=Account%20Deletion%20Request&body=Hi%2C%20I%20request%20to%20permanently%20remove%20all%20of%20my%20data%20from%20your%20platform.%20Please%20provide%20an%20update%20on%20the%20process%20via%20this%20email.",
		.difficulty = 0x1000
	},
	{
		.id = 0x577,
		.name = "MyJDownloader",
		.query = "myjdownloader",
		.url = "https://my.jdownloader.org",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x578,
		.name = "MyMaxon",
		.query = "mymaxon",
		.url = "https://id.maxon.net/settings/deleteAccount.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x579,
		.name = "Myntra",
		.query = "myntra",
		.url = "https://www.myntra.com/my/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x57a,
		.name = "MyParcel",
		.query = "myparcel",
		.url = "https://www.myparcel.nl/en/blog/sending/prepare-your-shipping-process-optimally-for-the-end-of-year-period/?article=kA167000000Xl74CAC",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x57b,
		.name = "MyPlate",
		.query = "myplate",
		.url = "https://livestrong.zendesk.com/hc/en-us/articles/205147450-How-do-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x57c,
		.name = "MyScript",
		.query = "myscript",
		.url = "https://sso.myscript.com/v1/api/account/delete/request",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x57d,
		.name = "MySpace",
		.query = "myspace",
		.url = "https://myspace.com/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x57e,
		.name = "Myworkdayjobs.com",
		.query = "myworkdayjobscom",
		.url = "https://www.workday.com/en-us/privacy.html",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x57f,
		.name = "myWorld",
		.query = "myworld",
		.url = "https://www.myworld.com/",
		.email = "mailto:data.protection@myworld.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x580,
		.name = "Más Renfe",
		.query = "mas renfe",
		.url = "https://www.renfe.com/es/en/legal-information/renfe-operadora/privacidad-cookies/politica-privacidad",
		.email = "mailto:derechos.renfeepe@renfe.es?body=Quiero%20suprimir%20mi%20M%C3%A1s%20Renfe%20cuenta",
		.difficulty = 0x1000
	},
	{
		.id = 0x581,
		.name = "Méliuz",
		.query = "meliuz",
		.url = "https://www.meliuz.com.br/minha-conta/meus-dados/excluir-conta",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x582,
		.name = "N11",
		.query = "n11",
		.url = "https://www.n11.com/hesabim/uyelik-iptali",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x583,
		.name = "Namecheap",
		.query = "namecheap",
		.url = "https://www.namecheap.com/support/knowledgebase/article.aspx/303/44/how-do-i-cancel-or-close-my-account-with-you",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x584,
		.name = "NameMC",
		.query = "namemc",
		.url = "https://namemc.com/my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x585,
		.name = "Nandos",
		.query = "nandos",
		.url = "https://help.nandos.co.uk/hc/en-gb/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x586,
		.name = "NaNoWriMo",
		.query = "nanowrimo",
		.url = "https://nanowrimo.org/account_settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x587,
		.name = "Napster",
		.query = "napster",
		.url = "https://help.napster.com/hc/en-us/articles/218661367",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x588,
		.name = "National Express",
		.query = "national express",
		.url = "https://nationalexpress.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x589,
		.name = "NationStates",
		.query = "nationstates",
		.url = "https://www.nationstates.net/page=faq",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x58a,
		.name = "Native",
		.query = "native",
		.url = "https://www.nativecos.com/pages/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x58b,
		.name = "Native Instruments",
		.query = "native instruments",
		.url = "https://support.native-instruments.com/hc/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x58c,
		.name = "Natively",
		.query = "natively",
		.url = "https://learnnatively.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x58d,
		.name = "Natural Readers",
		.query = "natural readers",
		.url = "https://www.naturalreaders.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x58e,
		.name = "Naukri",
		.query = "naukri",
		.url = "https://www.naukri.com/mnjuser/settings/communication",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x58f,
		.name = "NAVER",
		.query = "naver",
		.url = "https://nid.naver.com/user2/help/leaveId?menu=nid",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x590,
		.name = "NCBI",
		.query = "ncbi",
		.url = "https://www.ncbi.nlm.nih.gov/books/NBK3842/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x591,
		.name = "Nearpod",
		.query = "nearpod",
		.url = "https://nearpod.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x592,
		.name = "NeoDB",
		.query = "neodb",
		.url = "https://neodb.social/account/info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x593,
		.name = "Neon Pagamentos",
		.query = "neon pagamentos",
		.url = "https://suporte.neon.com.br/hc/pt-br/articles/360050729234-Como-fa%C3%A7o-para-cancelar-a-conta-",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x594,
		.name = "Neopets",
		.query = "neopets",
		.url = "https://www.neopets.com/help_search.phtml?help_id=4",
		.email = "mailto:support@neopets.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x595,
		.name = "Nerdwallet",
		.query = "nerdwallet",
		.url = "https://support.nerdwallet.com/hc/en-us/articles/115001636783-How-can-I-close-my-NerdWallet-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x596,
		.name = "Netbela Hosting",
		.query = "netbela hosting",
		.url = "https://netbela.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x597,
		.name = "NetBird",
		.query = "netbird",
		.url = "https://docs.netbird.io/how-to/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x598,
		.name = "Netdata",
		.query = "netdata",
		.url = "https://learn.netdata.cloud/docs/cloud/data-privacy#delete-all-personal-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x599,
		.name = "Netflix",
		.query = "netflix",
		.url = "https://www.netflix.com/account/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x59a,
		.name = "Netgate",
		.query = "netgate",
		.url = "https://www.netgate.com/company/privacy-policy#right-to-erasure-right-to-be-forgotten",
		.email = "mailto:privacy@netgate.com?body=Please%20delete%20my%20account%2C%20my%20email%20address%20is%20XXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x59b,
		.name = "Netlify",
		.query = "netlify",
		.url = "https://app.netlify.com/account/settings/general#danger-zone",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x59c,
		.name = "Netology",
		.query = "netology",
		.url = "https://netology.ru",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x59d,
		.name = "NetSfere",
		.query = "netsfere",
		.url = "https://help.netsfere.com/",
		.email = "mailto:support@netsfere.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x59e,
		.name = "Netvibes",
		.query = "netvibes",
		.url = "https://www.netvibes.com/account/unsubscribe",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x59f,
		.name = "New Relic",
		.query = "new relic",
		.url = "https://docs.newrelic.com/docs/accounts/accounts-billing/account-setup/downgradecancel-account/#cancel-simple-org",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a0,
		.name = "New York Times",
		.query = "new york times",
		.url = "https://www.nytimes.com/data-subject-request",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5a1,
		.name = "Newegg",
		.query = "newegg",
		.url = "https://kb.newegg.com/knowledge-base/data-rights-request/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5a2,
		.name = "Newgrounds",
		.query = "newgrounds",
		.url = "https://www.newgrounds.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a3,
		.name = "NewsBlur",
		.query = "newsblur",
		.url = "https://www.newsblur.com/profile/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a4,
		.name = "Newspapers.com",
		.query = "newspaperscom",
		.url = "https://www.newspapers.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5a5,
		.name = "Newspipe",
		.query = "newspipe",
		.url = "https://www.newspipe.org/",
		.email = "mailto:info@newspipe.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x5a6,
		.name = "Nexo",
		.query = "nexo",
		.url = "https://platform.nexo.io/security/close-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a7,
		.name = "Nexon",
		.query = "nexon",
		.url = "https://support-maplestory.nexon.net/hc/fr/articles/360000698823-Comment-puis-je-supprimer-ou-d%C3%A9sactiver-mon-compte-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5a8,
		.name = "NextDNS",
		.query = "nextdns",
		.url = "https://my.nextdns.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5a9,
		.name = "Nextdoor",
		.query = "nextdoor",
		.url = "https://help.nextdoor.com/s/article/How-to-deactivate-or-delete-your-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5aa,
		.name = "Nexus Mods",
		.query = "nexus mods",
		.url = "https://users.nexusmods.com/account/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ab,
		.name = "Ngan Luong",
		.query = "ngan luong",
		.url = "https://account.nganluong.vn/nganluong/user-info/lock-wallet",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5ac,
		.name = "ngrok",
		.query = "ngrok",
		.url = "https://dashboard.ngrok.com/user/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ad,
		.name = "NiceHash",
		.query = "nicehash",
		.url = "https://nicehash.com/my/settings/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ae,
		.name = "NicePage",
		.query = "nicepage",
		.url = "https://nicepage.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5af,
		.name = "Nicequest",
		.query = "nicequest",
		.url = "https://www.nicequest.com/br/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b0,
		.name = "Niche",
		.query = "niche",
		.url = "https://preferences.niche.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5b1,
		.name = "Nike",
		.query = "nike",
		.url = "https://www.nike.com/pt/member/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b2,
		.name = "Nike+",
		.query = "nike",
		.url = "https://secure-nikeplus.nike.com/plus/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b3,
		.name = "Ninox",
		.query = "ninox",
		.url = "https://ninoxdb.de/de/support/contactus",
		.email = "mailto:support@ninoxdb.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x5b4,
		.name = "Nintendo",
		.query = "nintendo",
		.url = "https://accounts.nintendo.com/withdraw/confirm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b5,
		.name = "Nintendo Network ID",
		.query = "nintendo network id",
		.url = "https://en-americas-support.nintendo.com/app/answers/detail/a_id/1088/~/how-to-delete-a-nintendo-network-id",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b6,
		.name = "Nitrous Networks",
		.query = "nitrous networks",
		.url = "https://nitrous-networks.com/support/article/44/how-to-cancel-your-server",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5b7,
		.name = "Njalla",
		.query = "njalla",
		.url = "https://njal.la/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b8,
		.name = "NodeChef",
		.query = "nodechef",
		.url = "https://www.nodechef.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5b9,
		.name = "NoIP",
		.query = "noip",
		.url = "https://my.noip.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ba,
		.name = "Nomad",
		.query = "nomad",
		.url = "https://benomad.zendesk.com/hc/en-us/articles/360042473234-How-do-I-request-the-closing-of-my-Nomad-global-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x5bb,
		.name = "NordPass",
		.query = "nordpass",
		.url = "https://nordpass.com/privacy-policy/#choices-related-to-your-data",
		.email = "mailto:support@nordpass.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5bc,
		.name = "NordVPN",
		.query = "nordvpn",
		.url = "https://support.nordvpn.com/FAQ/1521982312/How-can-I-delete-my-account.htm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5bd,
		.name = "Norton",
		.query = "norton",
		.url = "https://my.norton.com/extspa/account/privacyoptions",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x5be,
		.name = "Notesnook",
		.query = "notesnook",
		.url = "https://app.notesnook.com/tags#/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5bf,
		.name = "Notion",
		.query = "notion",
		.url = "https://www.notion.so",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5c0,
		.name = "The Noun Project",
		.query = "the noun project",
		.url = "https://thenounproject.zendesk.com/hc/en-us/articles/200509678-How-can-I-deactivate-my-user-account-",
		.email = "mailto:info@thenounproject.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5c1,
		.name = "Novation Music",
		.query = "novation music",
		.url = "https://www.iubenda.com/privacy-policy/29650626/legal",
		.email = "mailto:dpo@focusrite.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5c2,
		.name = "NovelAI",
		.query = "novelai",
		.url = "https://novelai.net/stories",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x5c3,
		.name = "NovoEd",
		.query = "novoed",
		.url = "http://help.novoed.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5c4,
		.name = "NOW TV",
		.query = "now tv",
		.url = "https://privacyportal-de.onetrust.com/webform/1bca6949-81da-4e67-ac5e-a4174c2fb12d/f1b0c03e-ec61-4702-b2c1-6158fb608d1a",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5c5,
		.name = "npm",
		.query = "npm",
		.url = "https://www.npmjs.com/settings/~/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5c6,
		.name = "NS (Nederlandse Spoorwegen)",
		.query = "ns nederlandse spoorwegen",
		.url = "https://www.ns.nl/en/mijnns#/account-verwijderen",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5c7,
		.name = "NS1",
		.query = "ns1",
		.url = "https://ns1.com",
		.email = "mailto:support@ns1.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5c8,
		.name = "nTask",
		.query = "ntask",
		.url = "https://support.ntaskmanager.com/support/solutions/articles/43000545051-delete-your-ntask-account",
		.email = "mailto:support@ntaskmanager.com?subject=Account%20Deletion",
		.difficulty = 0x1000
	},
	{
		.id = 0x5c9,
		.name = "Nubank",
		.query = "nubank",
		.url = "https://blog.nubank.com.br/fechar-nuconta-e-facil/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5ca,
		.name = "Nube",
		.query = "nube",
		.url = "https://www.nube.com.br/politica-uso-privacidade",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5cb,
		.name = "Nulled",
		.query = "nulled",
		.url = "https://www.nulled.to/topic/1418075-delete-account/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5cc,
		.name = "Numista",
		.query = "numista",
		.url = "https://en.numista.com/vous/desinscription.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5cd,
		.name = "Nutaku",
		.query = "nutaku",
		.url = "https://www.nutaku.net/profile/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ce,
		.name = "NutraCheck",
		.query = "nutracheck",
		.url = "https://www.nutracheck.co.uk/",
		.email = "mailto:customercare@nutracheck.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x5cf,
		.name = "NVIDIA",
		.query = "nvidia",
		.url = "https://www.nvidia.com/en-us/account/privacy/delete-data/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d0,
		.name = "O'Reilly",
		.query = "oreilly",
		.url = "https://www.oreilly.com/",
		.email = "mailto:privacy@oreilly.com?body=I%20want%20my%20account%20linked%20to%20this%20email%20be%20deleted.%20I%20request%20and%20authorize%20you%20to%20remove%20my%20profile%20from%20oreilly.com%20and%20delete%20all%20my%20information%20with%20your%20company%20across%20all%20platforms.",
		.difficulty = 0x1000
	},
	{
		.id = 0x5d1,
		.name = "Obi",
		.query = "obi",
		.url = "https://www.obi.de/customer-account/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d2,
		.name = "Obsidian",
		.query = "obsidian",
		.url = "https://obsidian.md/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d3,
		.name = "OceanHero",
		.query = "oceanhero",
		.url = "https://oceanhero.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5d4,
		.name = "Octopus",
		.query = "octopus",
		.url = "https://octopus.do/sitemap/support/help",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d5,
		.name = "Oculus / Meta VR",
		.query = "oculus meta vr",
		.url = "https://secure.oculus.com/my/privacy/#delete-your-meta-horizon-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d6,
		.name = "Odeon",
		.query = "odeon",
		.url = "https://help.odeon.co.uk/hc/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5d7,
		.name = "The Odin Project",
		.query = "the odin project",
		.url = "https://www.theodinproject.com/privacy-policy",
		.email = "mailto:theodinprojectcontact@gmail.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5d8,
		.name = "Odnoklassniki",
		.query = "odnoklassniki",
		.url = "https://odnoklassniki.ru/regulations",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5d9,
		.name = "OfferUp",
		.query = "offerup",
		.url = "https://offerup.com/accounts/deactivate/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5da,
		.name = "Office Depot México",
		.query = "office depot mexico",
		.url = "https://www.officedepot.com.mx/",
		.email = "mailto:sclientes@officedepot.com.mx",
		.difficulty = 0x2000
	},
	{
		.id = 0x5db,
		.name = "OfficeDepot",
		.query = "officedepot",
		.url = "https://www.officedepot.com/ccpa/landing.do",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5dc,
		.name = "OGLoot",
		.query = "ogloot",
		.url = "https://ogloot.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5dd,
		.name = "OK",
		.query = "ok",
		.url = "https://ok.ru/regulations",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5de,
		.name = "OkCupid",
		.query = "okcupid",
		.url = "https://www.okcupid.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5df,
		.name = "Olo",
		.query = "olo",
		.url = "https://app.oloauth.com/Manage/delete",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x5e0,
		.name = "OLX",
		.query = "olx",
		.url = "https://www.olx.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e1,
		.name = "Olympics",
		.query = "olympics",
		.url = "https://privacyportal-eu.onetrust.com/webform/22395098-025a-4a86-b716-763ae9c9a4cf/787ca7a8-5c45-45f9-9c4d-29ef9d88bb1d",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5e2,
		.name = "OM Personal English",
		.query = "om personal english",
		.url = "https://ompersonal.com.ar/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e3,
		.name = "OmaPosti",
		.query = "omaposti",
		.url = "https://asiakastiedot.posti.fi/myaccount/details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e4,
		.name = "omegaUp",
		.query = "omegaup",
		.url = "https://omegaup.com/profile/#delete-account",
		.email = "mailto:soporte@omegaup.com",
		.difficulty = 0x400
	},
	{
		.id = 0x5e5,
		.name = "Omnipilot",
		.query = "omnipilot",
		.url = "https://omnipilot.ai/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e6,
		.name = "Ondéa Grand Lac",
		.query = "ondea grand lac",
		.url = "https://www.ondeagrandlac.fr/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e7,
		.name = "One Month",
		.query = "one month",
		.url = "https://www.iubenda.com/privacy-policy/735465",
		.email = "mailto:support@honeybadger.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x5e8,
		.name = "OneCompiler",
		.query = "onecompiler",
		.url = "https://onecompiler.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5e9,
		.name = "OneFootball",
		.query = "onefootball",
		.url = "https://onefootball.com/payments/delete-account",
		.email = "mailto:feedback@onefootball.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5ea,
		.name = "OnePlus",
		.query = "oneplus",
		.url = "https://www.oneplus.com/global/customer/info#",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x5eb,
		.name = "OneSky",
		.query = "onesky",
		.url = "https://support.oneskyapp.com/hc/en-us/articles/115005242827-How-to-Delete-your-OneSky-Account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5ec,
		.name = "Onet",
		.query = "onet",
		.url = "https://konto.onet.pl/data.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ed,
		.name = "The Onion",
		.query = "the onion",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x5ee,
		.name = "Online Judge (formerly UVa Online Judge)",
		.query = "online judge formerly uva online judge",
		.url = "https://onlinejudge.org/index.php?option=com_contact&Itemid=4",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5ef,
		.name = "Online.net",
		.query = "onlinenet",
		.url = "https://console.online.net/fr/assistance/ticket",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5f0,
		.name = "OnlineTVRecorder.com",
		.query = "onlinetvrecordercom",
		.url = "https://www.onlinetvrecorder.com/v2/index.php?go=account&do=cancel",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5f1,
		.name = "OnlyFans",
		.query = "onlyfans",
		.url = "https://onlyfans.com/my/settings/advanced",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f2,
		.name = "Onshape",
		.query = "onshape",
		.url = "https://cad.onshape.com/user/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f3,
		.name = "Open Collective",
		.query = "open collective",
		.url = "https://opencollective.com/dashboard",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f4,
		.name = "OpenAI / ChatGPT",
		.query = "openai chatgpt",
		.url = "https://chatgpt.com/#settings/Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f5,
		.name = "OpenCores",
		.query = "opencores",
		.url = "https://opencores.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x5f6,
		.name = "Opendesktop",
		.query = "opendesktop",
		.url = "https://www.opendesktop.org",
		.email = "mailto:contact@opendesktop.org?subject=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x5f7,
		.name = "OpenDNS",
		.query = "opendns",
		.url = "https://dashboard.opendns.com/myaccount/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5f8,
		.name = "OpenFoodFacts",
		.query = "openfoodfacts",
		.url = "https://blog.openfoodfacts.org/en/account-deletion",
		.email = "mailto:contact@openfoodfacts.org",
		.difficulty = 0x2000
	},
	{
		.id = 0x5f9,
		.name = "OpenGuessr",
		.query = "openguessr",
		.url = "https://openguessr.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5fa,
		.name = "OpenInvest",
		.query = "openinvest",
		.url = "https://www.openinvest.com/terms-of-service",
		.email = "mailto:support@openinvest.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x5fb,
		.name = "OpenPhone",
		.query = "openphone",
		.url = "https://support.openphone.com/hc/en-us/requests/new",
		.email = "mailto:help@openphone.co?subject=Account%20deletion%20request&body=I%20request%20a%20deletion%20of%20my%20OpenPhone%20account%20associated%20with%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x5fc,
		.name = "OpenSea",
		.query = "opensea",
		.url = "https://support.opensea.io/hc/requests/new",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x5fd,
		.name = "OpenStreetMap",
		.query = "openstreetmap",
		.url = "https://www.openstreetmap.org/account/deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5fe,
		.name = "OpenSubtitles.com",
		.query = "opensubtitlescom",
		.url = "https://www.opensubtitles.com/en/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x5ff,
		.name = "OpenTable",
		.query = "opentable",
		.url = "https://help.opentable.com",
		.email = "mailto:privacy@opentable.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x600,
		.name = "OpenWeather",
		.query = "openweather",
		.url = "https://home.openweathermap.org/privacy/notifications#del_poll_modal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x601,
		.name = "Opera",
		.query = "opera",
		.url = "https://auth.opera.com/account/delete-profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x602,
		.name = "Optum",
		.query = "optum",
		.url = "https://docasap.com/user/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x603,
		.name = "Oracle",
		.query = "oracle",
		.url = "https://www.oracle.com/legal/data-privacy-inquiry-form.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x604,
		.name = "ORCID",
		.query = "orcid",
		.url = "https://orcid.org/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x605,
		.name = "OSBuddy",
		.query = "osbuddy",
		.url = "https://rsbuddy.com/osbuddy/docs/privacy",
		.email = "mailto:support@rsbuddy.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x606,
		.name = "Osu!",
		.query = "osu",
		.url = "https://osu.ppy.sh/wiki/en/Help_centre/Account#account-deletion",
		.email = "mailto:privacy@ppy.sh",
		.difficulty = 0x1000
	},
	{
		.id = 0x607,
		.name = "otter.ai",
		.query = "otterai",
		.url = "https://otter.ai/setting",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x608,
		.name = "Otto.de",
		.query = "ottode",
		.url = "https://www.otto.de/myaccount/mydata",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x609,
		.name = "Out of Milk",
		.query = "out of milk",
		.url = "https://outofmilk.com/RemoveAccount.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x60a,
		.name = "Outdooractive",
		.query = "outdooractive",
		.url = "https://www.outdooractive.com/en/k/how-do-i-delete-my-community-account-/50323147/#:~:text=Go%20to%20your%20page%20by,then%20select%20%22Delete%20Profile%22.",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x60b,
		.name = "Outlier",
		.query = "outlier",
		.url = "https://outlier.ai/legal/privacy-policy",
		.email = "mailto:privacy@outlier.ai",
		.difficulty = 0x2000
	},
	{
		.id = 0x60c,
		.name = "OV-chipkaart",
		.query = "ovchipkaart",
		.url = "https://www.ov-chipkaart.nl/en/privacy",
		.email = "mailto:privacy@ov-chipkaart.nl",
		.difficulty = 0x1000
	},
	{
		.id = 0x60d,
		.name = "Overcast.fm",
		.query = "overcastfm",
		.url = "https://overcast.fm/account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x60e,
		.name = "Overleaf",
		.query = "overleaf",
		.url = "https://www.overleaf.com/user/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x60f,
		.name = "Overstock",
		.query = "overstock",
		.url = "https://help.overstock.com/help/s/article/Customer-Care-Contact-Information",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x610,
		.name = "overtake",
		.query = "overtake",
		.url = "https://www.overtake.gg/form/delete-my-account.6/select",
		.email = "mailto:legal@overtake.gg?subject=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x611,
		.name = "Overwolf",
		.query = "overwolf",
		.url = "https://support.overwolf.com/en/support/solutions/articles/9000178281-deleting-your-overwolf-account-and-related-data",
		.email = "mailto:support@overwolf.com",
		.difficulty = 0x400
	},
	{
		.id = 0x612,
		.name = "OVHcloud UK",
		.query = "ovhcloud uk",
		.url = "https://www.ovh.co.uk/personal-data-protection/exercise-your-rights?lsdDoc=exercising-your-rights",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x613,
		.name = "Oxford Dictionaries API",
		.query = "oxford dictionaries api",
		.url = "https://developer.oxforddictionaries.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x614,
		.name = "Oùra - Auvergne-Rhône-Alpes",
		.query = "oura auvergnerhonealpes",
		.url = "https://oura.com/contact-et-reclamation",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x615,
		.name = "Packagist",
		.query = "packagist",
		.url = "https://packagist.org/profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x616,
		.name = "Packetshare",
		.query = "packetshare",
		.url = "https://www.packetshare.io/dashboard/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x617,
		.name = "Packt",
		.query = "packt",
		.url = "https://www.packtpub.com/",
		.email = "mailto:subscription.support@packtpub.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x618,
		.name = "Padlet",
		.query = "padlet",
		.url = "https://padlet.com/dashboard/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x619,
		.name = "PAGBET",
		.query = "pagbet",
		.url = "https://assets.bet6.com.br/sistemans/skins/pagbet/doc/ba98aa02a1.pdf",
		.email = "mailto:contato@pagbet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x61a,
		.name = "Palia",
		.query = "palia",
		.url = "https://support.palia.com/hc/en-us/articles/37965096889620--Understanding-the-Difference-Between-Account-Deletion-Character-Deletion-and-Device-Unlinking#h_01JWF9WW8ZB24FJS5PZFZ9KS9R",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x61b,
		.name = "Panda-Plush",
		.query = "pandaplush",
		.url = "https://panda-plush.com/account/register",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x61c,
		.name = "Pandora",
		.query = "pandora",
		.url = "https://www.pandora.com/settings/info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x61d,
		.name = "Pantheon",
		.query = "pantheon",
		.url = "https://dashboard.pantheon.io/#account/delete/Delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x61e,
		.name = "Papara",
		.query = "papara",
		.url = "https://www.papara.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x61f,
		.name = "PaperKarma",
		.query = "paperkarma",
		.url = "https://www.paperkarma.com/faq",
		.email = "mailto:human@paperkarma.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x620,
		.name = "Paperless Post",
		.query = "paperless post",
		.url = "https://paperlesspost.zendesk.com/hc/en-us/articles/207330096-Closing-and-Deletion-of-Your-Paperless-Post-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x621,
		.name = "PaperNodes",
		.query = "papernodes",
		.url = "https://papernodes.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x622,
		.name = "Paperspace",
		.query = "paperspace",
		.url = "https://console.paperspace.com/account/settings/profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x623,
		.name = "Paradox Plaza",
		.query = "paradox plaza",
		.url = "https://support.paradoxplaza.com/hc/en-us/requests/new?ticket_form_id=360000086974",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x624,
		.name = "Parallels",
		.query = "parallels",
		.url = "https://my.parallels.com/profile/personal/general",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x625,
		.name = "Paramount Plus",
		.query = "paramount plus",
		.url = "https://privacyportal.onetrust.com/webform/869be997-c257-4071-b658-a5427317b5c6/bda9b2b4-9be6-4f30-9d55-94b308f9af4d",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x626,
		.name = "Parcello",
		.query = "parcello",
		.url = "https://www.parcello.org/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x627,
		.name = "Parkmobile",
		.query = "parkmobile",
		.url = "https://parkmobile.zendesk.com/hc/en-us/articles/203299300-How-do-I-cancel-my-account-",
		.email = "mailto:helpdesk@parkmobileglobal.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x628,
		.name = "Parsec",
		.query = "parsec",
		.url = "https://parsec.app/settings/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x629,
		.name = "pass Culture",
		.query = "pass culture",
		.url = "https://passculture.app/profil/suppression",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62a,
		.name = "PassDock",
		.query = "passdock",
		.url = "https://api.passdock.net/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62b,
		.name = "Passpack",
		.query = "passpack",
		.url = "https://support.passpack.com/hc/en-us/articles/200749084-How-to-Delete-Your-Passpack-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62c,
		.name = "Pastebin",
		.query = "pastebin",
		.url = "https://pastebin.com/user/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62d,
		.name = "Patreon",
		.query = "patreon",
		.url = "https://privacy.patreon.com/policies?modal=take-control",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62e,
		.name = "Patrick Krempf Reminder",
		.query = "patrick krempf reminder",
		.url = "https://reminder.patrickkempf.de/manage.php?do=delaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x62f,
		.name = "Payback",
		.query = "payback",
		.url = "https://www.payback.de/info/mein-payback/kontakt",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x630,
		.name = "PayByPhone",
		.query = "paybyphone",
		.url = "https://support.paybyphone.com/hc/en-001/articles/13258687569553-How-do-I-delete-my-Account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x631,
		.name = "Payoneer",
		.query = "payoneer",
		.url = "https://payoneer.custhelp.com/app/ask/l_id/1/c/3753",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x632,
		.name = "PayPal",
		.query = "paypal",
		.url = "https://www.paypal.com/myaccount/privacy/data/deletion",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x633,
		.name = "PaySafeCard",
		.query = "paysafecard",
		.url = "https://login.paysafecard.com/customer-auth/?client_id=mypinsPR&theme=mypins&locale=en_US&redirect_uri=https%3A%2F%2Fmy.paysafecard.com%2Fmypins-psc%2FtokenExchange.xhtml",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x634,
		.name = "PaySera",
		.query = "paysera",
		.url = "https://bank.paysera.com/l.php?tmpl_into=middle&tmpl_name=m_helpdesk_ask_your_question",
		.email = "mailto:support@paysera.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x635,
		.name = "PCBWay",
		.query = "pcbway",
		.url = "https://www.pcbway.com/helpcenter/accountsettings/Account_Settings.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x636,
		.name = "PCem Forum",
		.query = "pcem forum",
		.url = "https://pcem-emulator.co.uk/phpBB3/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x637,
		.name = "pCloud",
		.query = "pcloud",
		.url = "https://my.pcloud.com/#page=settings&settings=tab-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x638,
		.name = "PCPartPicker",
		.query = "pcpartpicker",
		.url = "https://pcpartpicker.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x639,
		.name = "PCS Mastercard",
		.query = "pcs mastercard",
		.url = "https://www.mypcs.com/besoin-daide/supprimer-mon-compte/#faq-comment-supprimer-mon-compte-?",
		.email = "mailto:dpo@creacard.net?body=I%20want%20to%20delete%20my%20PCS%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x63a,
		.name = "PDF Editify",
		.query = "pdf editify",
		.url = "https://pdfeditify.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x63b,
		.name = "pdfFiller",
		.query = "pdffiller",
		.url = "https://www.pdffiller.com/en/login/signin?ref=%2Fen%2Faccount%2Fsettings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x63c,
		.name = "Peacock",
		.query = "peacock",
		.url = "https://privacyportal.onetrust.com/webform/17e5cb00-ad90-47f5-a58d-77597d9d2c16/2aa79e13-e7d2-4d45-b928-7df9a72bec32",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x63d,
		.name = "Peak",
		.query = "peak",
		.url = "https://peak.net",
		.email = "mailto:support@peak.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x63e,
		.name = "Pearson",
		.query = "pearson",
		.url = "https://www.pearson.com/privacy-center/privacy-notices/full-privacy-notice.html#12",
		.email = "mailto:dataprivacy@pearson.com",
		.difficulty = 0x4000
	},
	{
		.id = 0x63f,
		.name = "Peloton",
		.query = "peloton",
		.url = "https://privacyportal.onetrust.com/webform/18f92a28-d2ae-4a6a-8f99-85b4455e22c0/cfbaf35a-5e06-4010-a6b6-1ad61ba414f1",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x640,
		.name = "Pennsylvania Turnpike (Toll By Plate)",
		.query = "pennsylvania turnpike toll by plate",
		.url = "https://www.paturnpike.com/help-center#contact-form",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x641,
		.name = "PenPal World",
		.query = "penpal world",
		.url = "https://penpalworld.com/deleteAccount.asp",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x642,
		.name = "Penpot",
		.query = "penpot",
		.url = "https://design.penpot.app/#/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x643,
		.name = "Penzu",
		.query = "penzu",
		.url = "https://penzu.com/app/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x644,
		.name = "peopleperhour",
		.query = "peopleperhour",
		.url = "https://www.peopleperhour.com/settings/general",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x645,
		.name = "The Perfect Shave",
		.query = "the perfect shave",
		.url = "https://www.perfect-shave.de/einstellungen",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x646,
		.name = "Perplexity",
		.query = "perplexity",
		.url = "https://www.perplexity.ai/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x647,
		.name = "Personal Capital",
		.query = "personal capital",
		.url = "https://home.personalcapital.com/page/login/app#/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x648,
		.name = "Personello Germany",
		.query = "personello germany",
		.url = "https://de.personello.com/service",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x649,
		.name = "Pexels",
		.query = "pexels",
		.url = "https://help.pexels.com/hc/en-us/articles/360042822033-How-can-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x64a,
		.name = "Phare",
		.query = "phare",
		.url = "https://app.phare.io/organization/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x64b,
		.name = "Philips Hue",
		.query = "philips hue",
		.url = "https://account.meethue.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x64c,
		.name = "Phind",
		.query = "phind",
		.url = "https://www.phind.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x64d,
		.name = "PhishTank",
		.query = "phishtank",
		.url = "https://privacyrequest.cisco.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x64e,
		.name = "Pholder",
		.query = "pholder",
		.url = "https://pholder.com/policies/#Terms",
		.email = "mailto:abuse@pholder.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x64f,
		.name = "Photobucket",
		.query = "photobucket",
		.url = "https://support.photobucket.com/hc/en-us/articles/360039780614",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x650,
		.name = "Photomath",
		.query = "photomath",
		.url = "https://photomath.com/en/help/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x651,
		.name = "phpBB Forum",
		.query = "phpbb forum",
		.url = "https://www.phpbb.com/community/viewtopic.php?t=2425241#:~:text=we%20generally%20do%20not%20delete%20accounts",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x652,
		.name = "phplist",
		.query = "phplist",
		.url = "https://www.phplist.com/privacy",
		.email = "mailto:info@phplist.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x653,
		.name = "Piazza",
		.query = "piazza",
		.url = "https://support.piazza.com/support/solutions/articles/48000616709-student-delete-your-account",
		.email = "mailto:help@piazza.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x654,
		.name = "picoCTF",
		.query = "picoctf",
		.url = "https://play.picoctf.org/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x655,
		.name = "PicPay",
		.query = "picpay",
		.url = "https://meajuda.picpay.com/hc/pt-br/articles/4407302956819-Como-encerro-minha-conta-do-PicPay-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x656,
		.name = "Pillpack",
		.query = "pillpack",
		.url = "https://help.pillpack.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x657,
		.name = "Pinboard",
		.query = "pinboard",
		.url = "https://pinboard.in/faq/#close_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x658,
		.name = "Pingdom",
		.query = "pingdom",
		.url = "https://my.pingdom.com/account/cancel/confirm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x659,
		.name = "Pinterest",
		.query = "pinterest",
		.url = "https://pinterest.com/settings/account-settings/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x65a,
		.name = "Pionex",
		.query = "pionex",
		.url = "https://www.pionex.com/en/my-account/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x65b,
		.name = "Pivot Interactives",
		.query = "pivot interactives",
		.url = "https://www.pivotinteractives.com",
		.email = "mailto:info@pivotinteractives.com?subject=Privacy%20Rights%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x65c,
		.name = "PivotalTracker",
		.query = "pivotaltracker",
		.url = "https://www.pivotaltracker.com",
		.email = "mailto:tracker@pivotal.io",
		.difficulty = 0x800
	},
	{
		.id = 0x65d,
		.name = "Pix",
		.query = "pix",
		.url = "https://support.pix.org/en/support/tickets/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x65e,
		.name = "Pix fr",
		.query = "pix fr",
		.url = "https://pix.fr/politique-protection-donnees-personnelles-app#:~:text=Exercice%20des%20droits",
		.email = "mailto:dpd@pix.fr?subject=Demande%20de%20suppression%20de%20compte&body=Bonjour%2C%20Je%20souhaiterai%20faire%20valoir%20mes%20droits%20et%20faire%20supprimer%20mon%20compte%20XXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x65f,
		.name = "Pixabay",
		.query = "pixabay",
		.url = "https://pixabay.com/de/accounts/settings/?tab=account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x660,
		.name = "Pixel Starships",
		.query = "pixel starships",
		.url = "https://www.pixelstarships.com/privacypolicy",
		.email = "mailto:mail@savysoda.com?subject=ACCESS%20AND%20CORRECT%20INFORMATION&body=Please%20delete%20my%20Pixel%20Starships%20account%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x661,
		.name = "Pixilart",
		.query = "pixilart",
		.url = "https://www.pixilart.com/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x662,
		.name = "pixiv",
		.query = "pixiv",
		.url = "https://www.pixiv.net/leave_pixiv.php",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x663,
		.name = "Pixlr",
		.query = "pixlr",
		.url = "https://pixlr.com/myaccount/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x664,
		.name = "Pixum",
		.query = "pixum",
		.url = "https://int.pixum.com/service/delete-account",
		.email = "mailto:service@pixum.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x665,
		.name = "PixVerse",
		.query = "pixverse",
		.url = "https://app.pixverse.ai/home",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x666,
		.name = "Pizza Hut",
		.query = "pizza hut",
		.url = "https://pizzahut.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x667,
		.name = "Placeit",
		.query = "placeit",
		.url = "https://placeit.net/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x668,
		.name = "PlanetMinecraft",
		.query = "planetminecraft",
		.url = "https://www.planetminecraft.com/account/settings/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x669,
		.name = "PlantSnap",
		.query = "plantsnap",
		.url = "https://www.plantsnap.com/support-center/get-in-touch/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x66a,
		.name = "Player FM",
		.query = "player fm",
		.url = "https://player.fm/will-miss-you",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x66b,
		.name = "Playit.gg",
		.query = "playitgg",
		.url = "https://playit.gg/account/settings/account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x66c,
		.name = "PlayPosit",
		.query = "playposit",
		.url = "https://go.playposit.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x66d,
		.name = "PlayStation Network",
		.query = "playstation network",
		.url = "https://www.playstation.com/en-us/support/account/close-account-for-psn/",
		.email = "mailto:siee.dpo@sony.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x66e,
		.name = "Plenty of Fish",
		.query = "plenty of fish",
		.url = "https://www.pof.com/deleteaccount.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x66f,
		.name = "Plex.tv",
		.query = "plextv",
		.url = "https://plex.tv/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x670,
		.name = "Plexus",
		.query = "plexus",
		.url = "https://plexus.techlore.tech/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x671,
		.name = "Ploonk (coquedetelephone.fr)",
		.query = "ploonk coquedetelephonefr",
		.url = "https://www.ploonk.fr/service/declaration-de-confidentialite/",
		.email = "mailto:serviceclients@ploonk.fr?subject=Demande%20de%20suppression%20de%20compte&body=Bonjour%2C%20Je%20souhaiterai%20faire%20valoir%20mes%20droits%20et%20faire%20supprimer%20mon%20compte%20XXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x672,
		.name = "Plugin Boutique",
		.query = "plugin boutique",
		.url = "https://help.pluginboutique.com/hc/en-us/requests/new?ticket_form_id=8801812364052",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x673,
		.name = "Pluralsight",
		.query = "pluralsight",
		.url = "https://help.pluralsight.com/help/how-do-i-delete-my-account",
		.email = "mailto:support@pluralsight.com",
		.difficulty = 0x400
	},
	{
		.id = 0x674,
		.name = "Plus500",
		.query = "plus500",
		.url = "https://www.plus500.com/en-CY/MyInfo/PersonalDataRequests/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x675,
		.name = "Plushiies",
		.query = "plushiies",
		.url = "https://plushiies.com/account/register",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x676,
		.name = "Pocket",
		.query = "pocket",
		.url = "https://getpocket.com/account_deletion/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x677,
		.name = "Pocket Casts",
		.query = "pocket casts",
		.url = "https://support.pocketcasts.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x678,
		.name = "Pocketbook",
		.query = "pocketbook",
		.url = "https://getpocketbook.com/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x679,
		.name = "Pockyt Shop",
		.query = "pockyt shop",
		.url = "https://shop.pockyt.io/",
		.email = "mailto:privacy@pockyt.io",
		.difficulty = 0x2000
	},
	{
		.id = 0x67a,
		.name = "Pocoyo Club",
		.query = "pocoyo club",
		.url = "https://www.pocoyo.com/en/club/account-cancellation",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x67b,
		.name = "Podchaser",
		.query = "podchaser",
		.url = "https://podchaser.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x67c,
		.name = "Podio",
		.query = "podio",
		.url = "https://podio.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x67d,
		.name = "Points.com",
		.query = "pointscom",
		.url = "https://www.points.com/pdccontent/salesforce/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x67e,
		.name = "PokeMMO",
		.query = "pokemmo",
		.url = "https://support.pokemmo.com/knowledgebase/article/account-deletion",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x67f,
		.name = "Pokémon GO",
		.query = "pokemon go",
		.url = "https://niantic.helpshift.com/hc/en/6-pokemon-go/faq/3518-how-do-i-delete-my-pokemon-go-account-1656453288/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x680,
		.name = "Pokémon Trainer Club",
		.query = "pokemon trainer club",
		.url = "https://support.pokemon.com/hc/en-us/articles/360000965826-How-do-I-delete-my-Pok%C3%A9mon-Trainer-Club-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x681,
		.name = "Polar",
		.query = "polar",
		.url = "https://account.polar.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x682,
		.name = "PolyBuzz",
		.query = "polybuzz",
		.url = "https://www.polybuzz.ai",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x683,
		.name = "pon",
		.query = "pon",
		.url = "https://my.ponlist.de/de/legal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x684,
		.name = "Porkbun",
		.query = "porkbun",
		.url = "https://porkbun.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x685,
		.name = "PornHub",
		.query = "pornhub",
		.url = "https://help.pornhub.com/hc/en-us/articles/4419877487635-How-do-I-delete-my-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x686,
		.name = "postale.io",
		.query = "postaleio",
		.url = "https://postale.io/admin/my/show",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x687,
		.name = "Postcrossing",
		.query = "postcrossing",
		.url = "https://www.postcrossing.com/removal",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x688,
		.name = "postimage",
		.query = "postimage",
		.url = "https://postimg.cc/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x689,
		.name = "Postman",
		.query = "postman",
		.url = "https://app.getpostman.com/dashboard/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x68a,
		.name = "Postmates",
		.query = "postmates",
		.url = "https://support.postmates.com/buyer/contact-us/delete-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x68b,
		.name = "Potion",
		.query = "potion",
		.url = "https://potion.so/",
		.email = "mailto:help@potion.so",
		.difficulty = 0x1000
	},
	{
		.id = 0x68c,
		.name = "Pottermore",
		.query = "pottermore",
		.url = "https://privacyportal.onetrust.com/webform/1b21e05d-c206-4e0b-970e-2d73a23e42e8/780a7716-f409-47f4-afdf-fbe274737e6f",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x68d,
		.name = "The Powder Toy",
		.query = "the powder toy",
		.url = "https://powdertoy.co.uk/Profile/Delete.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x68e,
		.name = "PowToon",
		.query = "powtoon",
		.url = "https://support.powtoon.com/en/article/deleting-your-powtoon-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x68f,
		.name = "Poznaj.to",
		.query = "poznajto",
		.url = "https://poznaj.to/konto-panelisty/usun-konto",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x690,
		.name = "Premera",
		.query = "premera",
		.url = "https://www.premera.com/wa/visitor/",
		.email = "mailto:support@premera.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x691,
		.name = "Premier League",
		.query = "premier league",
		.url = "https://www.premierleague.com/news/844577",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x692,
		.name = "Premiumize.me",
		.query = "premiumizeme",
		.url = "https://www.premiumize.me/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x693,
		.name = "Presearch",
		.query = "presearch",
		.url = "https://account.presearch.com/privacy-policy",
		.email = "mailto:privacy@presearch.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x694,
		.name = "PrestaShop",
		.query = "prestashop",
		.url = "https://accounts.distribution.prestashop.net/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x695,
		.name = "Previewed",
		.query = "previewed",
		.url = "https://previewed.app/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x696,
		.name = "Prey",
		.query = "prey",
		.url = "https://panel.preyproject.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x697,
		.name = "Prezi",
		.query = "prezi",
		.url = "https://prezi.com/settings/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x698,
		.name = "Printful",
		.query = "printful",
		.url = "https://printful.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x699,
		.name = "Privacy",
		.query = "privacy",
		.url = "https://support.privacy.com/hc/en-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x69a,
		.name = "ProductHunt",
		.query = "producthunt",
		.url = "https://www.producthunt.com/my/settings/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x69b,
		.name = "Progate",
		.query = "progate",
		.url = "https://progate.com/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x69c,
		.name = "Programiz PRO",
		.query = "programiz pro",
		.url = "https://programiz.pro",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x69d,
		.name = "ProMods",
		.query = "promods",
		.url = "https://promods.net/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x69e,
		.name = "Proofwiki",
		.query = "proofwiki",
		.url = "https://proofwiki.org/wiki/ProofWiki:Privacy_policy#Removal_of_user_accounts",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x69f,
		.name = "PropertyListingsAI",
		.query = "propertylistingsai",
		.url = "https://propertylistingsai.com/terms-of-use",
		.email = "mailto:balt1794@gmail.com?subject=Account%20Deletion%20Request&body=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x6a0,
		.name = "PROS",
		.query = "pros",
		.url = "https://prismray.io/account?section=profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6a1,
		.name = "Prosper",
		.query = "prosper",
		.url = "https://www.prosper.com/secure/account/borrower/close_account.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a2,
		.name = "Proto.io",
		.query = "protoio",
		.url = "https://support.proto.io/hc/en-us/articles/222733628-Dashboard-basics-Billing-Settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a3,
		.name = "Proton",
		.query = "proton",
		.url = "https://account.proton.me/u/0/mail/account-password",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a4,
		.name = "Prott",
		.query = "prott",
		.url = "https://prottapp.com/app/#/users/edit/general",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a5,
		.name = "ProWritingAid",
		.query = "prowritingaid",
		.url = "https://prowritingaid.com/en/Account/Manage",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a6,
		.name = "Proxer",
		.query = "proxer",
		.url = "https://proxer.me/ucp?s=deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a7,
		.name = "Prusa",
		.query = "prusa",
		.url = "https://account.prusa3d.com/extra-login/?next=/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6a8,
		.name = "PTC (MathCad, Vuforia Chalk Community)",
		.query = "ptc mathcad vuforia chalk community",
		.url = "https://www.ptc.com/en/support/article/CS115856",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6a9,
		.name = "Pulse.red",
		.query = "pulsered",
		.url = "https://pulse.red/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6aa,
		.name = "Pulseway",
		.query = "pulseway",
		.url = "https://my.pulseway.com/main/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6ab,
		.name = "Pushlink",
		.query = "pushlink",
		.url = "https://adm.pushlink.com/delete-account.xhtml",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ac,
		.name = "Pushover",
		.query = "pushover",
		.url = "https://pushover.net/settings/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ad,
		.name = "Put.io",
		.query = "putio",
		.url = "https://app.put.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ae,
		.name = "PxHere",
		.query = "pxhere",
		.url = "https://pxhere.com/my/settings",
		.email = "mailto:pxhere.com@gmail.com?subject=Account%20Deletion%20Request&body=Please%20delete%20my%20PxHere%20account%20registered%20under%20this%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x6af,
		.name = "Python Morsels",
		.query = "python morsels",
		.url = "https://www.pythonmorsels.com/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b0,
		.name = "Python Package Index (PyPI)",
		.query = "python package index pypi",
		.url = "https://pypi.org/manage/account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6b1,
		.name = "PythonAnywhere",
		.query = "pythonanywhere",
		.url = "https://help.pythonanywhere.com/pages/DeleteAccount/",
		.email = "mailto:usercare@anaconda.com?subject=Delete%20account%20%27your-username%27&body=I%20request%20to%20permanently%20delete%20my%20PythonAnywhere%20account%20%27your-username%27%20with%20all%20its%20files%20and%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x6b2,
		.name = "QIWI Wallet",
		.query = "qiwi wallet",
		.url = "https://qiwi.com/support/security/subject21/udalit-qiwi-koshelek",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6b3,
		.name = "Qoala",
		.query = "qoala",
		.url = "https://www.joinqoala.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b4,
		.name = "Qobuz",
		.query = "qobuz",
		.url = "https://www.qobuz.com/profile/delete/confirmation/email",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b5,
		.name = "QooApp",
		.query = "qooapp",
		.url = "https://www.qoo-app.com/",
		.email = "mailto:mr@qoo-app.com?subject=Account%20and%20Data%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x6b6,
		.name = "QQ",
		.query = "qq",
		.url = "https://kf.qq.com/faq/1803146n2yMr180314MbIfER.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b7,
		.name = "QQTube",
		.query = "qqtube",
		.url = "https://www.qqtube.com/identity",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b8,
		.name = "Qt",
		.query = "qt",
		.url = "https://my.qt.io/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6b9,
		.name = "Quantic Foundry",
		.query = "quantic foundry",
		.url = "https://quanticfoundry.com/",
		.email = "mailto:team@quanticfoundry.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x6ba,
		.name = "QuillBot",
		.query = "quillbot",
		.url = "https://help.quillbot.com/hc/en-us/requests/new?ticket_form_id=13656193734039",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6bb,
		.name = "QuintoAndar",
		.query = "quintoandar",
		.url = "https://help.quintoandar.com.br/hc/pt-br/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6bc,
		.name = "Quip",
		.query = "quip",
		.url = "https://www.quipsupport.com/entries/25079898-How-do-I-delete-my-account-",
		.email = "mailto:support@quip.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x6bd,
		.name = "Quire",
		.query = "quire",
		.url = "https://quire.io/r/setting?tab=options#additional",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6be,
		.name = "Quizlet",
		.query = "quizlet",
		.url = "https://quizlet.com/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6bf,
		.name = "Quora",
		.query = "quora",
		.url = "https://help.quora.com/hc/en-us/articles/115004250866-How-do-I-delete-my-Quora-account-?",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6c0,
		.name = "Quotev",
		.query = "quotev",
		.url = "https://www.quotev.com/help/q/23",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6c1,
		.name = "RackNerd",
		.query = "racknerd",
		.url = "https://my.racknerd.com/submitticket.php",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x6c2,
		.name = "radio.fr",
		.query = "radiofr",
		.url = "https://www.radio.fr/#%2Fkonto_loeschen.jsf",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6c3,
		.name = "Radiooooo",
		.query = "radiooooo",
		.url = "https://radiooooo.com/",
		.email = "mailto:support@radiooooo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x6c4,
		.name = "RaiDrive",
		.query = "raidrive",
		.url = "https://www.raidrive.com/identify/account/manage/personaldata",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6c5,
		.name = "Rail Europe",
		.query = "rail europe",
		.url = "https://www.raileurope.com/account/settings",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6c6,
		.name = "Raindrop.io",
		.query = "raindropio",
		.url = "https://api.raindrop.io/v1/user/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6c7,
		.name = "Rainforest QA",
		.query = "rainforest qa",
		.url = "https://app.rainforestqa.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6c8,
		.name = "Rakuten",
		.query = "rakuten",
		.url = "https://www.rakuten.com/privacy-preferences.htm",
		.email = "mailto:memberservices@rakuten.com?subject=Request%20to%20Delete%20Rakuten%20Account",
		.difficulty = 0x4000
	},
	{
		.id = 0x6c9,
		.name = "RapidAPI",
		.query = "rapidapi",
		.url = "https://rapidapi.com/auth/user/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ca,
		.name = "RateYourMusic",
		.query = "rateyourmusic",
		.url = "https://rateyourmusic.com/account/delete",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x6cb,
		.name = "RayWenderlich",
		.query = "raywenderlich",
		.url = "https://accounts.raywenderlich.com/profile",
		.email = "mailto:support@razeware.com?subject=Account%20deletion%20request",
		.difficulty = 0x1000
	},
	{
		.id = 0x6cc,
		.name = "Razer",
		.query = "razer",
		.url = "https://razer-id.razerzone.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6cd,
		.name = "RD Saúde (Droga Raia and Drogasil)",
		.query = "rd saude droga raia and drogasil",
		.url = "https://privacyportal-br.onetrust.com/webform/ece1e280-13aa-4d10-984a-bda9a79f64d7/c973a872-1b90-4b71-8284-e75ce6928857",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6ce,
		.name = "Read the Docs",
		.query = "read the docs",
		.url = "https://readthedocs.org/accounts/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6cf,
		.name = "Readernaut",
		.query = "readernaut",
		.url = "https://readernaut.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d0,
		.name = "RealDebrid",
		.query = "realdebrid",
		.url = "https://real-debrid.com/support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6d1,
		.name = "RealPython",
		.query = "realpython",
		.url = "https://realpython.com/account/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d2,
		.name = "RealVNC",
		.query = "realvnc",
		.url = "https://manage.realvnc.com/en/close_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d3,
		.name = "Rebelsmarket",
		.query = "rebelsmarket",
		.url = "https://www.rebelsmarket.com/my",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d4,
		.name = "Rebrickable",
		.query = "rebrickable",
		.url = "https://rebrickable.com/login/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d5,
		.name = "rebuy",
		.query = "rebuy",
		.url = "https://www.rebuy.de/my/personal-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d6,
		.name = "Recall AI",
		.query = "recall ai",
		.url = "https://app.getrecall.ai/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d7,
		.name = "RecargaPay",
		.query = "recargapay",
		.url = "https://recargapay.com.br/user/close-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x6d8,
		.name = "Recreation.gov",
		.query = "recreationgov",
		.url = "https://www.recreation.gov/account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6d9,
		.name = "Red Hat",
		.query = "red hat",
		.url = "https://www.redhat.com/en/about/personal-data-request",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6da,
		.name = "Red Robin",
		.query = "red robin",
		.url = "https://dsr.redrobin.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6db,
		.name = "Redacteur.com",
		.query = "redacteurcom",
		.url = "https://www.redacteur.com/identities/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6dc,
		.name = "Redbooth",
		.query = "redbooth",
		.url = "https://redbooth.com/a/#!/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6dd,
		.name = "Redbubble",
		.query = "redbubble",
		.url = "https://www.redbubble.com/account/settings/cancel",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6de,
		.name = "Reddit",
		.query = "reddit",
		.url = "https://www.reddit.com/prefs/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6df,
		.name = "redesignr.ai",
		.query = "redesignrai",
		.url = "https://redesignr.ai/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x6e0,
		.name = "Redfin",
		.query = "redfin",
		.url = "https://www.redfin.com/myredfin/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e1,
		.name = "Rediff",
		.query = "rediff",
		.url = "https://m.rediff.com/w3c/policy.html#:~:text=If%20your%20personally%20identifiable%20information%20or%20email%20address%20change,or%20postal%20mail%20at%20the%20contact%20information%20listed%20below.",
		.email = "mailto:customersupport@rediff.co.in",
		.difficulty = 0x1000
	},
	{
		.id = 0x6e2,
		.name = "Redirect.ing",
		.query = "redirecting",
		.url = "https://redirect.ing/account/settings/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e3,
		.name = "redirect.pizza",
		.query = "redirectpizza",
		.url = "https://redirect.pizza/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e4,
		.name = "RedPen.io",
		.query = "redpenio",
		.url = "https://redpen.io/account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6e5,
		.name = "RedShelf",
		.query = "redshelf",
		.url = "https://solve.redshelf.com/hc/requests/new?ticket_form_id=1260804993770",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6e6,
		.name = "Reg.ru",
		.query = "regru",
		.url = "https://help.reg.ru/support/#request",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6e7,
		.name = "Remember The Milk",
		.query = "remember the milk",
		.url = "https://www.rememberthemilk.com/login/delete.rtm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e8,
		.name = "Remind",
		.query = "remind",
		.url = "https://www.remind.com/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6e9,
		.name = "Remitly",
		.query = "remitly",
		.url = "https://www.remitly.com/fr/en/help/article/138e6277-84e5-43d1-9034-382f58e5eff1",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6ea,
		.name = "RemNote",
		.query = "remnote",
		.url = "https://help.remnote.com/en/articles/8033036-deleting-your-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6eb,
		.name = "Render",
		.query = "render",
		.url = "https://render.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ec,
		.name = "Renderforest",
		.query = "renderforest",
		.url = "https://www.renderforest.com/profile/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ed,
		.name = "Replay Poker",
		.query = "replay poker",
		.url = "https://www.replaypoker.com/settings/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ee,
		.name = "Replit",
		.query = "replit",
		.url = "https://replit.com/account/additional-billing-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6ef,
		.name = "Report URI",
		.query = "report uri",
		.url = "https://report-uri.com/account/settings/#deleteData",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f0,
		.name = "RescueTime",
		.query = "rescuetime",
		.url = "https://www.rescuetime.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f1,
		.name = "Reservio",
		.query = "reservio",
		.url = "https://app.reservio.com/#/business/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6f2,
		.name = "ResumeBoostAI",
		.query = "resumeboostai",
		.url = "https://resumeboostai.com/privacy",
		.email = "mailto:balt1794@gmail.com?subject=Account%20Deletion%20Request&body=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x6f3,
		.name = "ResumeGenius",
		.query = "resumegenius",
		.url = "https://app.resumegenius.com/data-access/personal-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f4,
		.name = "Resy",
		.query = "resy",
		.url = "https://resy.com/terms",
		.email = "mailto:help@resy.com?body=Please%20delete%20my%20Resy%20account%20as%20I%20do%20not%20wish%20to%20use%20it%20any%20further.",
		.difficulty = 0x1000
	},
	{
		.id = 0x6f5,
		.name = "RetroAchievements",
		.query = "retroachievements",
		.url = "https://retroachievements.org/controlpanel.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f6,
		.name = "Retroroms",
		.query = "retroroms",
		.url = "https://www.retroroms.info/unregister.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f7,
		.name = "Retrospring",
		.query = "retrospring",
		.url = "https://retrospring.net/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f8,
		.name = "Rev",
		.query = "rev",
		.url = "https://www.rev.com/account/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6f9,
		.name = "RevenueHits",
		.query = "revenuehits",
		.url = "https://www.revenuehits.com/privacy/",
		.email = "mailto:privacy@intango.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x6fa,
		.name = "Reverso",
		.query = "reverso",
		.url = "https://www.reverso.net/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x6fb,
		.name = "Revolt",
		.query = "revolt",
		.url = "https://revolt.chat/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6fc,
		.name = "Revolut",
		.query = "revolut",
		.url = "https://help.revolut.com/en-US/help/profile-and-plan/closing-account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x6fd,
		.name = "Rhonexpress",
		.query = "rhonexpress",
		.url = "https://www.rhonexpress.fr/en_GB/account/profile/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x6fe,
		.name = "Rideindego",
		.query = "rideindego",
		.url = "https://www.rideindego.com/faq/#how-do-i-cancel-my-pass",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x6ff,
		.name = "Riffle",
		.query = "riffle",
		.url = "https://help.realnames.com/hc/en-us/articles/202814089-Deactivate-your-Email-Address",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x700,
		.name = "Ring",
		.query = "ring",
		.url = "https://account.ring.com/account/data-requests",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x701,
		.name = "Riot Games",
		.query = "riot games",
		.url = "https://support-valorant.riotgames.com/hc/en-us/requests/new?ticket_form_id=360004036693",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x702,
		.name = "Ripe NCC",
		.query = "ripe ncc",
		.url = "https://www.ripe.net",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x703,
		.name = "RiseUp",
		.query = "riseup",
		.url = "https://account.riseup.net",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x704,
		.name = "Rituals.com",
		.query = "ritualscom",
		.url = "https://service.rituals.com/s/contact?topic=a2L4L0000008xwDUAQ&language=de&country=DE",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x705,
		.name = "RLV e-boutique",
		.query = "rlv eboutique",
		.url = "https://eboutique-rlv.airwebpass.com/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x706,
		.name = "Roadie",
		.query = "roadie",
		.url = "https://send.roadie.com/profile/settings",
		.email = "mailto:privacy@roadie.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x707,
		.name = "Robinhood",
		.query = "robinhood",
		.url = "https://robinhood.com/contact",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x708,
		.name = "Roblox",
		.query = "roblox",
		.url = "https://en.help.roblox.com/hc/en-us/articles/203313050-How-Do-I-Delete-My-Account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x709,
		.name = "RoboForm",
		.query = "roboform",
		.url = "https://online.roboform.com/site/account/manage?type=profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x70a,
		.name = "Rockstar Games Social Club",
		.query = "rockstar games social club",
		.url = "https://support.rockstargames.com/account/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x70b,
		.name = "Roku",
		.query = "roku",
		.url = "https://my.roku.com/account/close",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x70c,
		.name = "Roland",
		.query = "roland",
		.url = "https://www.roland.com/us/privacy/",
		.email = "mailto:privacy@rolandus.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x70d,
		.name = "Roll20",
		.query = "roll20",
		.url = "https://app.roll20.net/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x70e,
		.name = "The Root",
		.query = "the root",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x70f,
		.name = "Rosetta Stone",
		.query = "rosetta stone",
		.url = "https://privacyportal-cdn.onetrust.com/dsarwebform/27aac3ab-c36e-4457-81d4-9773ba27887e/f1e6ce28-8f84-4cae-9bdd-bc40113d5ee0.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x710,
		.name = "Rotten Tomatoes",
		.query = "rotten tomatoes",
		.url = "https://support.fandango.com/contact/contact-us-fandango-rkksORSDO",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x711,
		.name = "Rscipts",
		.query = "rscipts",
		.url = "https://rscripts.net",
		.email = "mailto:hello@rscripts.net?subject=Delete%20Account%20Request&body=Dear%20Rscripts%20support%20team%2C%20I%20hope%20this%20message%20finds%20you%20well.%20I%20would%20like%20to%20formally%20request%20the%20closure%20and%20the%20deletion%20of%20all%20associated%20personal%20data%20and%20account.%20Below%20are%20my%20account%20details%3A%20Email%20Address%3A%20XXXXX%40XXXXX.XXXXX%2C%20Username%3A%20XXXXX.%20I%20would%20appreciate%20it%20if%20you%20could%20process%20my%20account%20closure%20request%20as%20soon%20as%20possible.%20Please%20confirm%20once%20the%20account%20has%20been%20deleted%20and%20all%20associated%20data%20has%20been%20deleted.%20Best%20regards%2C%20XXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x712,
		.name = "RSS.app",
		.query = "rssapp",
		.url = "https://rss.app/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x713,
		.name = "Rue du Commerce",
		.query = "rue du commerce",
		.url = "https://www.rueducommerce.fr",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x714,
		.name = "Rumble",
		.query = "rumble",
		.url = "https://rumble.com/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x715,
		.name = "Runescape",
		.query = "runescape",
		.url = "https://www.runescape.com/zendesk/support-form?form=360000041149",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x716,
		.name = "RunKeeper",
		.query = "runkeeper",
		.url = "https://runkeeper.com/delete-account?confirm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x717,
		.name = "Runtastic",
		.query = "runtastic",
		.url = "https://help.runtastic.com/hc/en-us/articles/200370082-Delete-Account-Cancel-Membership",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x718,
		.name = "Ryanair",
		.query = "ryanair",
		.url = "https://m.marketing.ryanairemail.com/webApp/dataerasure",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x719,
		.name = "Rytr",
		.query = "rytr",
		.url = "https://rytr.me/blog/resources#how-to-delete-my-account",
		.email = "mailto:support@rytr.me",
		.difficulty = 0x1000
	},
	{
		.id = 0x71a,
		.name = "SadlyUnfriended",
		.query = "sadlyunfriended",
		.url = "https://www.sadlyunfriended.com/close_account.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x71b,
		.name = "Sahibinden",
		.query = "sahibinden",
		.url = "https://banaozel.sahibinden.com/bilgilerim/uyelik-iptali",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x71c,
		.name = "Salad",
		.query = "salad",
		.url = "https://support.salad.com/article/45-how-can-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x71d,
		.name = "SamMobile",
		.query = "sammobile",
		.url = "https://www.sammobile.com/remove-account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x71e,
		.name = "Samsung Account",
		.query = "samsung account",
		.url = "https://account.samsung.com/membership/contents/profile/delete-samsung-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x71f,
		.name = "SamyGO Forum",
		.query = "samygo forum",
		.url = "https://forum.samygo.tv/memberlist.php?mode=contactadmin",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x720,
		.name = "Sankaku",
		.query = "sankaku",
		.url = "https://sankaku.app/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x721,
		.name = "Sapinet",
		.query = "sapinet",
		.url = "https://my.sapinet.fr/submitticket.php",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x722,
		.name = "Satispay",
		.query = "satispay",
		.url = "https://disattivazione-account-satispay.paperform.co/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x723,
		.name = "Satori Reader",
		.query = "satori reader",
		.url = "https://www.satorireader.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x724,
		.name = "SaxoInvestor/SaxoTrader",
		.query = "saxoinvestorsaxotrader",
		.url = "https://www.saxoinvestor.com/investor/close-my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x725,
		.name = "Scaleway",
		.query = "scaleway",
		.url = "https://console.scaleway.com/#/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x726,
		.name = "Scammer.info",
		.query = "scammerinfo",
		.url = "https://scammer.info/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x727,
		.name = "Scavify",
		.query = "scavify",
		.url = "https://www.scavify.com/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x728,
		.name = "Scene+",
		.query = "scene",
		.url = "https://scenesupport.zendesk.com/hc/en-ca/p/contactUs",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x729,
		.name = "Scentbird",
		.query = "scentbird",
		.url = "https://scentbird.zendesk.com/hc/en-us/articles/115004536388-How-do-I-cancel-my-subscription-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x72a,
		.name = "Scholly",
		.query = "scholly",
		.url = "https://search.myscholly.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x72b,
		.name = "School of Chaos Online MMORPG",
		.query = "school of chaos online mmorpg",
		.url = "https://vnlentertainment.com/soc-html-privacy-policy-english.html",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x72c,
		.name = "SchoolCashOnline",
		.query = "schoolcashonline",
		.url = "https://schoolcashonline.com/MyAccount/EditProfile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x72d,
		.name = "SchoolFinder",
		.query = "schoolfinder",
		.url = "https://www.schoolfinder.com/About/SchoolFinder-Privacy-Policy.pdf",
		.email = "mailto:info@SchoolFinder.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x72e,
		.name = "Schoology",
		.query = "schoology",
		.url = "https://app.schoology.com/settings/account/action?delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x72f,
		.name = "scite_",
		.query = "scite",
		.url = "https://scite.ai/policy#your-privacy-choices",
		.email = "mailto:hi@scite.ai",
		.difficulty = 0x1000
	},
	{
		.id = 0x730,
		.name = "Score",
		.query = "score",
		.url = "https://getscore.app",
		.email = "mailto:hello@getscore.app",
		.difficulty = 0x1000
	},
	{
		.id = 0x731,
		.name = "Scratch",
		.query = "scratch",
		.url = "https://scratch.mit.edu/accounts/settings/delete_account_confirmation/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x732,
		.name = "Screenshot to Code",
		.query = "screenshot to code",
		.url = "https://screenshottocode.com/",
		.email = "mailto:support@picoapps.xyz",
		.difficulty = 0x1000
	},
	{
		.id = 0x733,
		.name = "Scribd",
		.query = "scribd",
		.url = "https://support.scribd.com/hc/en-us/articles/360000894843-Deleting-your-account#h_01HBVYCPRH4GEMX24PD473BHP8",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x734,
		.name = "Sdc.com",
		.query = "sdccom",
		.url = "http://www.sdc.com/react/#/settings2",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x735,
		.name = "Seagate",
		.query = "seagate",
		.url = "https://myportal.seagate.com/consumer-identity/profile/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x736,
		.name = "SEAGM",
		.query = "seagm",
		.url = "https://member.seagm.com/ucp/account/info",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x737,
		.name = "Second Life",
		.query = "second life",
		.url = "https://secondlife.com/my/account/cancel.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x738,
		.name = "Sedo",
		.query = "sedo",
		.url = "https://sedo.com/us/about-us/policies/protecting-your-privacy/",
		.email = "mailto:contact@sedo.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x739,
		.name = "Seedbox",
		.query = "seedbox",
		.url = "https://wiki.seedbox.fr/index.php/Comment_R%C3%A9silier_son_abonnement",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x73a,
		.name = "seedr.cc",
		.query = "seedrcc",
		.url = "https://www.seedr.cc/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x73b,
		.name = "Sega",
		.query = "sega",
		.url = "https://privacy.sega.com/en/your-rights",
		.email = "mailto:dataprivacy@sega.com?subject=I%20want%20to%20delete%20all%20my%20data%20from%20Sega&body=Data%20erasure.",
		.difficulty = 0x1000
	},
	{
		.id = 0x73c,
		.name = "SelfWealth",
		.query = "selfwealth",
		.url = "https://www.selfwealth.com.au/",
		.email = "mailto:support@selfwealth.com.au",
		.difficulty = 0x1000
	},
	{
		.id = 0x73d,
		.name = "Sellfy",
		.query = "sellfy",
		.url = "https://sellfy.com/user/settings/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x73e,
		.name = "Semrush",
		.query = "semrush",
		.url = "https://www.semrush.com/kb/support/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x73f,
		.name = "Send.now",
		.query = "sendnow",
		.url = "https://send.now/?op=my_account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x740,
		.name = "SendGrid",
		.query = "sendgrid",
		.url = "https://support.sendgrid.com/hc/en-us/articles/4410760485403-Data-Retention-and-Deletion-in-Twilio-Products",
		.email = "mailto:datasubjectrequests@sendgrid.com?subject=SendGrid%20account%20deletion%20request&body=Please%20delete%20my%20SendGrid%20account%20under%20my%20email%20address.",
		.difficulty = 0x1000
	},
	{
		.id = 0x741,
		.name = "Sendspace",
		.query = "sendspace",
		.url = "https://www.sendspace.com/mysendspace/prefs.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x742,
		.name = "SensCritique",
		.query = "senscritique",
		.url = "https://www.senscritique.com/parametres/compte-suppression",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x743,
		.name = "Sentry",
		.query = "sentry",
		.url = "https://sentry.io/settings/account/close-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x744,
		.name = "Serpstat",
		.query = "serpstat",
		.url = "https://serpstat.com/users/profile/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x745,
		.name = "Server.pro",
		.query = "serverpro",
		.url = "https://server.pro/",
		.email = "mailto:support@server.pro",
		.difficulty = 0x1000
	},
	{
		.id = 0x746,
		.name = "Serverless",
		.query = "serverless",
		.url = "https://app.serverless.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x747,
		.name = "Service-Public.fr",
		.query = "servicepublicfr",
		.url = "https://www.service-public.fr/compte/parametres",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x748,
		.name = "Session",
		.query = "session",
		.url = "https://sessionapp.zendesk.com/hc/en-us/articles/7726435197849-How-can-I-delete-my-Session-account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x749,
		.name = "SetApp",
		.query = "setapp",
		.url = "https://my.setapp.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x74a,
		.name = "Seznam.cz",
		.query = "seznamcz",
		.url = "https://profil.seznam.cz/gdpr",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x74b,
		.name = "Sfimg",
		.query = "sfimg",
		.url = "https://www.sfimg.com/MyAccount/Remove",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x74c,
		.name = "Shaadi.com",
		.query = "shaadicom",
		.url = "https://my.shaadi.com/my-shaadi/my-account/hide-delete-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x74d,
		.name = "Shadow",
		.query = "shadow",
		.url = "https://account.shadow.tech/home/security",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x74e,
		.name = "Sharesome",
		.query = "sharesome",
		.url = "https://sharesome.com/settings/privacy/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x74f,
		.name = "Shazam",
		.query = "shazam",
		.url = "https://www.shazam.com/privacy/login/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x750,
		.name = "SHEEPIT",
		.query = "sheepit",
		.url = "https://www.sheepit-renderfarm.com/user/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x751,
		.name = "Shein",
		.query = "shein",
		.url = "https://shein.com/robot",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x752,
		.name = "Shell.ca",
		.query = "shellca",
		.url = "https://www.shell.ca/en_ca/privacy.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x753,
		.name = "Shikimori",
		.query = "shikimori",
		.url = "https://shikimori.one/clubs/1093-faq-chasto-zadavaemye-voprosy",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x754,
		.name = "Shinden",
		.query = "shinden",
		.url = "https://shinden.pl",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x755,
		.name = "Shipito",
		.query = "shipito",
		.url = "https://www.shipito.com/es/help/faq/account-navigation",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x756,
		.name = "Shodan",
		.query = "shodan",
		.url = "https://static.shodan.io/legal/terms.html",
		.email = "mailto:support@shodan.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x757,
		.name = "Shop",
		.query = "shop",
		.url = "https://help.shop.app/hc/en-us/articles/360058842072-Delete-your-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x758,
		.name = "Shop Your Way",
		.query = "shop your way",
		.url = "https://privacyportal.onetrust.com/webform/cc9a8230-03c2-46ab-afe1-51ced9dc71c0/30774a09-e2e1-4f85-9d3d-fc51a7530f05",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x759,
		.name = "Shopee",
		.query = "shopee",
		.url = "https://www.sharelatex.com/user/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x75a,
		.name = "Shopify",
		.query = "shopify",
		.url = "https://privacy.shopify.com/dsr_submission/subject_types?selected=erasure",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x75b,
		.name = "Shopper+",
		.query = "shopper",
		.url = "https://www.shopperplus.ca/policies/Shopper+%20Account%20Removal%20Policy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x75c,
		.name = "Shorte.st",
		.query = "shortest",
		.url = "https://shorte.st/profile/remove-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x75d,
		.name = "Shotgun.live",
		.query = "shotgunlive",
		.url = "https://support.shotgun.live/hc/en-us/articles/360016912580--I-want-to-delete-my-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x75e,
		.name = "showRSS",
		.query = "showrss",
		.url = "https://showrss.info/edit/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x75f,
		.name = "Shpock",
		.query = "shpock",
		.url = "https://en.shpock.com",
		.email = "mailto:support@shpock.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x760,
		.name = "Shutterfly",
		.query = "shutterfly",
		.url = "https://www.shutterfly.com/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x761,
		.name = "Shutterstock",
		.query = "shutterstock",
		.url = "https://www.shutterstock.com/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x762,
		.name = "Sibra",
		.query = "sibra",
		.url = "https://boutique.sibra.fr/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x763,
		.name = "SigFig",
		.query = "sigfig",
		.url = "https://support.sigfig.com/hc/en-us/articles/202586434-How-do-I-completely-delete-my-account-",
		.email = "mailto:support@sigfig.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x764,
		.name = "Signal",
		.query = "signal",
		.url = "https://support.signal.org/hc/en-us/articles/360007061192-Delete-Account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x765,
		.name = "SignalRGB",
		.query = "signalrgb",
		.url = "https://signalrgb.com/account/delete-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x766,
		.name = "Similarweb",
		.query = "similarweb",
		.url = "https://account.similarweb.com/user-details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x767,
		.name = "Simple",
		.query = "simple",
		.url = "https://help.simple.life/en/articles/9887975-how-to-delete-your-account-or-request-data-deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x768,
		.name = "Simple Machines",
		.query = "simple machines",
		.url = "https://simplemachines.org/community/index.php?action=profile;area=deleteaccount",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x769,
		.name = "SimpleLogin",
		.query = "simplelogin",
		.url = "https://app.simplelogin.io/dashboard/setting",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76a,
		.name = "Simplenote",
		.query = "simplenote",
		.url = "https://app.simplenote.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76b,
		.name = "SimplePlanes",
		.query = "simpleplanes",
		.url = "https://www.simpleplanes.com/Account/DeleteAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76c,
		.name = "Simplified",
		.query = "simplified",
		.url = "https://app.simplified.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76d,
		.name = "Simply Plural",
		.query = "simply plural",
		.url = "https://app.apparyllis.com/#/Settings/Account/UserSettings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76e,
		.name = "SimplyPrint",
		.query = "simplyprint",
		.url = "https://simplyprint.io/panel/user_settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x76f,
		.name = "The Sims Resource",
		.query = "the sims resource",
		.url = "https://help.thesimsresource.com/article/14-how-do-i-delete-my-account",
		.email = "mailto:support@thesimsresource.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x770,
		.name = "SINAC serviciosenlinea",
		.query = "sinac serviciosenlinea",
		.url = "https://serviciosenlinea.sinac.go.cra",
		.email = "mailto:reservaciones.sinac@sinac.go.cr?subject=Solicitaci%C3%B3n%20de%20borrar%20cuenta&body=Tengo%20una%20cuenta%20en%20https%3A//serviciosenlinea.sinac.go.cr/%20utilizando%20el%20usuario%20XXXXXX%20y%20me%20gustaria%20de%20eliminar%20esta%20cuenta.",
		.difficulty = 0x1000
	},
	{
		.id = 0x771,
		.name = "SitePoint",
		.query = "sitepoint",
		.url = "https://www.sitepoint.com/community/faq/#leaving",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x772,
		.name = "Sketchfab",
		.query = "sketchfab",
		.url = "https://sketchfab.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x773,
		.name = "SketchUp",
		.query = "sketchup",
		.url = "https://privacy.sketchup.com/email-form",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x774,
		.name = "Skiddle",
		.query = "skiddle",
		.url = "https://www.skiddle.com/skiddlepeople/removeaccount.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x775,
		.name = "Skillshare",
		.query = "skillshare",
		.url = "https://preferences.skillshare.com/privacy",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x776,
		.name = "Skinbaron",
		.query = "skinbaron",
		.url = "https://skinbaron.de/en/profile/tickets",
		.email = "mailto:info@skinbaron.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x777,
		.name = "SKlauncher",
		.query = "sklauncher",
		.url = "https://skmedix.pl/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x778,
		.name = "Skoob",
		.query = "skoob",
		.url = "https://www.skoob.com.br/usuario/excluir/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x779,
		.name = "Skool",
		.query = "skool",
		.url = "https://www.skool.com/privacy?rt=udt",
		.email = "mailto:help@skool.com",
		.difficulty = 0x800
	},
	{
		.id = 0x77a,
		.name = "SkySilk",
		.query = "skysilk",
		.url = "https://help.skysilk.com/support/solutions/articles/9000106317-how-do-i-deactivate-my-account-",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x77b,
		.name = "Slack",
		.query = "slack",
		.url = "https://my.slack.com/account/settings",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x77c,
		.name = "Slashdot",
		.query = "slashdot",
		.url = "https://slashdot.org/faq",
		.email = "mailto:feedback@slashdot.org?subject=Delete%20Account&body=I%20want%20to%20permanently%20delete%20my%20account%20from%20Slashdot",
		.difficulty = 0x1000
	},
	{
		.id = 0x77d,
		.name = "SleeveYourGames",
		.query = "sleeveyourgames",
		.url = "https://www.sleeveyourgames.com/feedback",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x77e,
		.name = "Slideshare",
		.query = "slideshare",
		.url = "https://support.scribd.com/hc/en-us/articles/360000894843-Deleting-your-account#h_01HBVYCPRH4GEMX24PD473BHP8",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x77f,
		.name = "Slowly",
		.query = "slowly",
		.url = "https://help.slowly.app/hc/en-us/articles/115001828351-How-do-I-delete-my-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x780,
		.name = "SmallPDF",
		.query = "smallpdf",
		.url = "https://smallpdf.com/profile",
		.email = "mailto:support@smallpdf.com?subject=Delete%20Account&body=Hi%2C%20I%20want%20to%20permanently%20delete%20my%20account%20from%20SmallPDF%2C%20thanks",
		.difficulty = 0x1000
	},
	{
		.id = 0x781,
		.name = "SmartRecruiters",
		.query = "smartrecruiters",
		.url = "https://help.smartrecruiters.com/Getting_Started/User_settings/How_do_I_close_my_user_account%3F",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x782,
		.name = "Smartsheet",
		.query = "smartsheet",
		.url = "https://app.smartsheet.com/b/form/599b304161d34e29baa9c5fb985c4333",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x783,
		.name = "SmartyPig",
		.query = "smartypig",
		.url = "https://www.smartypig.com/faqs",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x784,
		.name = "Smodin",
		.query = "smodin",
		.url = "https://smodin.io/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x785,
		.name = "Smoothcomp",
		.query = "smoothcomp",
		.url = "https://support.smoothcomp.com/article/193-please-remove-delete-hide-my-account-gdpr",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x786,
		.name = "SMSPool",
		.query = "smspool",
		.url = "https://www.smspool.net/my/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x787,
		.name = "Smule",
		.query = "smule",
		.url = "https://smule.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x788,
		.name = "Snapchat",
		.query = "snapchat",
		.url = "https://accounts.snapchat.com/accounts/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x789,
		.name = "Snapfish",
		.query = "snapfish",
		.url = "https://support.snapfish.com/hc/en-us/articles/360008146353-Delete-your-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x78a,
		.name = "Snappa",
		.query = "snappa",
		.url = "https://snappa.com/app/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78b,
		.name = "SNCF",
		.query = "sncf",
		.url = "https://www.sncf-connect.com/en-en/help/your-customer-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78c,
		.name = "Snov.io",
		.query = "snovio",
		.url = "https://app.snov.io/account#/security-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78d,
		.name = "Social Blade",
		.query = "social blade",
		.url = "https://socialblade.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78e,
		.name = "socialoomph",
		.query = "socialoomph",
		.url = "https://www.socialoomph.com/settings/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x78f,
		.name = "Sofascore",
		.query = "sofascore",
		.url = "https://sofascore.helpscoutdocs.com/article/55-how-to-delete-account?lng=en",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x790,
		.name = "SoftCreatR Media",
		.query = "softcreatr media",
		.url = "https://www.softcreatr.com/account-management/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x791,
		.name = "solo.to",
		.query = "soloto",
		.url = "https://solo.to/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x792,
		.name = "SoloLearn",
		.query = "sololearn",
		.url = "https://www.sololearn.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x793,
		.name = "Sonder",
		.query = "sonder",
		.url = "https://www.sonder.com/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x794,
		.name = "Songkick",
		.query = "songkick",
		.url = "https://www.songkick.com/settings/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x795,
		.name = "Sonix",
		.query = "sonix",
		.url = "https://my.sonix.ai/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x796,
		.name = "Sonos",
		.query = "sonos",
		.url = "https://www.sonos.com/en-us/legal/privacy#legal-privacy-contact",
		.email = "mailto:privacy@sonos.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x797,
		.name = "Sony",
		.query = "sony",
		.url = "https://www.sony-europe.com/mysony/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x798,
		.name = "Soulseek",
		.query = "soulseek",
		.url = "https://www.slsknet.org/news/node/748",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x799,
		.name = "SoundCloud",
		.query = "soundcloud",
		.url = "https://soundcloud.com/settings/account#delete-user",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x79a,
		.name = "Soundtrap",
		.query = "soundtrap",
		.url = "https://support.soundtrap.com/hc/en-us/articles/360033406534-Delete-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x79b,
		.name = "SourceForge",
		.query = "sourceforge",
		.url = "https://sourceforge.net/auth/disable/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x79c,
		.name = "Sourcegraph",
		.query = "sourcegraph",
		.url = "https://sourcegraph.com/docs/sourcegraph-accounts#how-to-delete-accounts-or-unlink-social-sign-ins",
		.email = "mailto:support@sourcegraph.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x79d,
		.name = "Sourcery.ai",
		.query = "sourceryai",
		.url = "https://sourcery.ai/privacy/",
		.email = "mailto:info@sourcery.ai",
		.difficulty = 0x1000
	},
	{
		.id = 0x79e,
		.name = "South Plus",
		.query = "south plus",
		.url = "https://south-plus.net/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x79f,
		.name = "SpaceHey",
		.query = "spacehey",
		.url = "https://spacehey.com/deleteaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a0,
		.name = "SPC",
		.query = "spc",
		.url = "https://www.spccard.ca/privacy-policy",
		.email = "mailto:privacy@spccard.ca",
		.difficulty = 0x2000
	},
	{
		.id = 0x7a1,
		.name = "Speaker Deck",
		.query = "speaker deck",
		.url = "https://speakerdeck.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a2,
		.name = "speedrun.com",
		.query = "speedruncom",
		.url = "https://www.speedrun.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a3,
		.name = "Speedtest",
		.query = "speedtest",
		.url = "https://help.speedtest.net/hc/en-us/articles/360035679994-How-do-I-delete-my-data-GDPR-",
		.email = "mailto:support@speedtest.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x7a4,
		.name = "Sphere Online Judge (SPOJ)",
		.query = "sphere online judge spoj",
		.url = "https://www.spoj.com/legal-tos/#:~:text=In%20order%20to%20remove%20the,and%20file%20a%20proper%20motion.",
		.email = "mailto:contact@sphere-research.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x7a5,
		.name = "SpielerPlus",
		.query = "spielerplus",
		.url = "https://support.spielerplus.de/hc/en-us/articles/4402733049105-How-can-I-delete-my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a6,
		.name = "Spieletipps",
		.query = "spieletipps",
		.url = "https://www.spieletipps.de/m/resign/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a7,
		.name = "SpigotMC",
		.query = "spigotmc",
		.url = "https://www.spigotmc.org/threads/account-removal-information.392153/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7a8,
		.name = "Splice",
		.query = "splice",
		.url = "https://splice.com/profile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7a9,
		.name = "Splitser",
		.query = "splitser",
		.url = "https://app.splitser.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7aa,
		.name = "Splitwise",
		.query = "splitwise",
		.url = "https://secure.splitwise.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ab,
		.name = "Spond",
		.query = "spond",
		.url = "https://spond.com/landing/deleteAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ac,
		.name = "Sporcle",
		.query = "sporcle",
		.url = "https://www.sporcle.com/settings/account-info/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ad,
		.name = "Sportsbet",
		.query = "sportsbet",
		.url = "https://helpcentre.sportsbet.com.au/hc/en-us/articles/115007208487-How-do-I-close-my-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7ae,
		.name = "Sportsbet.io",
		.query = "sportsbetio",
		.url = "https://sportsbet.io/help-centre/help-getting-started/help-account/how-do-i-close-my-account",
		.email = "mailto:hello@sportsbet.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x7af,
		.name = "SpotAngels",
		.query = "spotangels",
		.url = "https://spotangels.notion.site/How-can-I-delete-my-account-a0066146a3c04c6f8262c1bbc366838c",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b0,
		.name = "Spotify",
		.query = "spotify",
		.url = "https://support.spotify.com/close-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7b1,
		.name = "Spreadshirt",
		.query = "spreadshirt",
		.url = "https://my.spreadshirt.com/account/contact",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b2,
		.name = "spusu",
		.query = "spusu",
		.url = "https://www.spusu.co.uk/contact",
		.email = "mailto:office@spusu.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x7b3,
		.name = "SquadJobs",
		.query = "squadjobs",
		.url = "https://squadjobs.com/help",
		.email = "mailto:support@squadjobs.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x7b4,
		.name = "Square",
		.query = "square",
		.url = "https://app.squareup.com/dashboard/shifts/settings/clock-in-out",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b5,
		.name = "Square Cash",
		.query = "square cash",
		.url = "https://cash.me/login?return_to=support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7b6,
		.name = "Squarespace",
		.query = "squarespace",
		.url = "https://account.squarespace.com/settings/security/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b7,
		.name = "Stack Overflow / Stack Exchange Accounts",
		.query = "stack overflow stack exchange accounts",
		.url = "https://stackoverflow.com/help/deleting-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7b8,
		.name = "StackBlitz",
		.query = "stackblitz",
		.url = "https://stackblitz.com/settings/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7b9,
		.name = "Stackhero",
		.query = "stackhero",
		.url = "https://www.stackhero.io/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7ba,
		.name = "Stake",
		.query = "stake",
		.url = "https://trading.hellostake.com/platform/update-profile/close-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7bb,
		.name = "Stan",
		.query = "stan",
		.url = "https://help.stan.com.au/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7bc,
		.name = "Standard Notes",
		.query = "standard notes",
		.url = "https://standardnotes.com/reset",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7bd,
		.name = "Star't",
		.query = "start",
		.url = "https://www.star-t.fr/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7be,
		.name = "Starbucks",
		.query = "starbucks",
		.url = "https://www.starbucks.com/terms/privacy-policy/#contact_us",
		.email = "mailto:privacy@starbucks.com?subject=Account%20Deletion%20Request&body=I%20request%20deletion%20of%20my%20Starbucks%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x7bf,
		.name = "Stardock",
		.query = "stardock",
		.url = "https://stardock.atlassian.net/servicedesk/customer/portal/4/group/14/create/10143",
		.email = "mailto:support@stardock.com?subject=Right%20to%20Erasure%20Request&body=I%20wish%20to%20exercise%20my%20right%20to%20erasure%20under%20data%20protection%20law.%0A%0A%5BGive%20details%20of%20what%20personal%20data%20you%20want%20erased/deleted.%5D",
		.difficulty = 0x1000
	},
	{
		.id = 0x7c0,
		.name = "Startnext",
		.query = "startnext",
		.url = "https://www.startnext.com/help/FAQ.html#q74",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c1,
		.name = "STAS - Agence en Ligne",
		.query = "stas agence en ligne",
		.url = "https://www.reseau-stas.fr/fr/nous-contacter/14/Contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7c2,
		.name = "statcounter",
		.query = "statcounter",
		.url = "https://statcounter.com/close_account.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c3,
		.name = "Statista",
		.query = "statista",
		.url = "https://www.statista.com/profile/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c4,
		.name = "StatusCake",
		.query = "statuscake",
		.url = "https://app.statuscake.com/User.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c5,
		.name = "StatusInvest",
		.query = "statusinvest",
		.url = "https://statusinvest.com.br/usuario/configuracao",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c6,
		.name = "Steam",
		.query = "steam",
		.url = "https://help.steampowered.com/en/wizard/HelpDeleteAccount",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7c7,
		.name = "SteamDB",
		.query = "steamdb",
		.url = "https://steamdb.info/signout/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7c8,
		.name = "SteamHistory",
		.query = "steamhistory",
		.url = "https://steamhistory.net/newbeta/terms-of-service",
		.email = "mailto:privacy@steamhistory.net",
		.difficulty = 0x1000
	},
	{
		.id = 0x7c9,
		.name = "SteelSeries",
		.query = "steelseries",
		.url = "https://steelseries.com/dashboard/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ca,
		.name = "StepMap",
		.query = "stepmap",
		.url = "https://www.stepmap.de/profile.html#profile_delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7cb,
		.name = "StickK",
		.query = "stickk",
		.url = "https://stickk.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7cc,
		.name = "Stocard",
		.query = "stocard",
		.url = "https://stocardapp.com/privacy",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7cd,
		.name = "Stock Informer",
		.query = "stock informer",
		.url = "https://www.stockinformer.com/myprofile.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ce,
		.name = "Storenvy",
		.query = "storenvy",
		.url = "https://www.storenvy.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7cf,
		.name = "Storj",
		.query = "storj",
		.url = "https://docs.storj.io/dcs/billing-payment-and-accounts-1/closing-an-account/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7d0,
		.name = "The StoryGraph",
		.query = "the storygraph",
		.url = "https://app.thestorygraph.com/profile/edit/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7d1,
		.name = "Strava",
		.query = "strava",
		.url = "https://www.strava.com/athlete/delete_your_account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7d2,
		.name = "Strawpoll",
		.query = "strawpoll",
		.url = "https://strawpoll.com/account/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7d3,
		.name = "Streamable",
		.query = "streamable",
		.url = "https://support.streamable.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7d4,
		.name = "StreamLabs",
		.query = "streamlabs",
		.url = "https://getonstream.com/how-to-delete-a-streamlabs-account-easy-guide/",
		.email = "mailto:support@streamlabs.com?subject=REQUEST%20TO%20DELETE%20MY%20ACCOUNT",
		.difficulty = 0x1000
	},
	{
		.id = 0x7d5,
		.name = "StreamYard",
		.query = "streamyard",
		.url = "https://streamyard.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7d6,
		.name = "Stripe",
		.query = "stripe",
		.url = "https://dashboard.stripe.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7d7,
		.name = "Stronghold Kingdoms",
		.query = "stronghold kingdoms",
		.url = "https://login.strongholdkingdoms.com/ajaxphp/main_ajax.php?event=ChangeGDPR&status=0",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7d8,
		.name = "StudentBeans",
		.query = "studentbeans",
		.url = "https://accounts.studentbeans.com/us/my/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7d9,
		.name = "Studio",
		.query = "studio",
		.url = "https://studio.com/settings?page=advanced",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7da,
		.name = "Studios New York",
		.query = "studios new york",
		.url = "https://www.studiosnewyork.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7db,
		.name = "StudyClix",
		.query = "studyclix",
		.url = "https://www.studyclix.ie/FAQs#Contact_Us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7dc,
		.name = "StudyMode",
		.query = "studymode",
		.url = "https://www.studymode.com/about-us/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7dd,
		.name = "StumbleUpon",
		.query = "stumbleupon",
		.url = "https://www.stumbleupon.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7de,
		.name = "Subaru Maps",
		.query = "subaru maps",
		.url = "https://subaru-maps.com/#/users/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7df,
		.name = "SubMeNow",
		.query = "submenow",
		.url = "https://www.submenow.com/account.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7e0,
		.name = "Substack",
		.query = "substack",
		.url = "https://substack.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7e1,
		.name = "SulAmérica",
		.query = "sulamerica",
		.url = "https://saude.sulamericaseguros.com.br/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x7e2,
		.name = "Suno",
		.query = "suno",
		.url = "https://help.suno.com/en/articles/3480577",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7e3,
		.name = "Super Domínios",
		.query = "super dominios",
		.url = "https://superdominios.org/contato/",
		.email = "mailto:suporte@superdominios.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x7e4,
		.name = "Super Tux Kart",
		.query = "super tux kart",
		.url = "https://online.supertuxkart.net/users.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7e5,
		.name = "Supercell ID",
		.query = "supercell id",
		.url = "https://help.supercellsupport.com/clash-of-clans/en/articles/gdpr-request-deletion-of-your-personal-data.html",
		.email = "mailto:legal-requests@supercell.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x7e6,
		.name = "SurfEasy",
		.query = "surfeasy",
		.url = "https://support.surfeasy.com/hc/en-us/articles/360000937226-What-can-I-request-under-the-GDPR-",
		.email = "mailto:gdpr@surfeasy.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x7e7,
		.name = "Surfshark",
		.query = "surfshark",
		.url = "https://my.surfshark.com/account/delete",
		.email = "mailto:support@surfshark.com",
		.difficulty = 0x400
	},
	{
		.id = 0x7e8,
		.name = "SurveyMonkey",
		.query = "surveymonkey",
		.url = "https://www.surveymonkey.com/user/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7e9,
		.name = "Surveytime",
		.query = "surveytime",
		.url = "https://surveytime.io/privacy-policy",
		.email = "mailto:tommy@surveytime.io",
		.difficulty = 0x800
	},
	{
		.id = 0x7ea,
		.name = "Svbtle",
		.query = "svbtle",
		.url = "https://svbtle.com/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7eb,
		.name = "Swagbucks",
		.query = "swagbucks",
		.url = "https://www.swagbucks.com/account/settings#tab=account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ec,
		.name = "Swappa.com",
		.query = "swappacom",
		.url = "https://swappa.com/my/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7ed,
		.name = "Swift",
		.query = "swift",
		.url = " https://privacyportal.onetrust.com/webform/068883cc-1dae-4395-abfe-6eba2f29de47/d962e88c-edab-4c51-8428-9030bbaf552f",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x7ee,
		.name = "Swiggy",
		.query = "swiggy",
		.url = "https://swiggy.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x7ef,
		.name = "SwissPass / SBB CFF FFS",
		.query = "swisspass sbb cff ffs",
		.url = "https://www.swisspass.ch/kunde/logindaten?lang=en#kontoLoeschen",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f0,
		.name = "Sync.com",
		.query = "synccom",
		.url = "https://cp.sync.com/account/info",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f1,
		.name = "Syncfusion",
		.query = "syncfusion",
		.url = "https://www.syncfusion.com/account/my-profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f2,
		.name = "Synchro Mobilités",
		.query = "synchro mobilites",
		.url = "https://start.synchro.grandchambery.fr/fr/compte/informations",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f3,
		.name = "Synology",
		.query = "synology",
		.url = "https://account.synology.com/en-us/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f4,
		.name = "System76",
		.query = "system76",
		.url = "https://system76.com/privacy",
		.email = "mailto:privacy@system76.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x7f5,
		.name = "T-Mobile",
		.query = "tmobile",
		.url = "https://privacyportal-t-mobile.my.onetrust.com/webform/d4a925f0-4ebf-40ba-817b-bccc309e602f/7831d667-1ebc-4b1e-a941-e545cb0d0523",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7f6,
		.name = "T2C Alertes",
		.query = "t2c alertes",
		.url = "https://www.t2c.fr/formulaire/nous-contacter",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7f7,
		.name = "T2C Boutique",
		.query = "t2c boutique",
		.url = "https://eboutique.smtc-clermont.fr/en/account/informations",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f8,
		.name = "Tablondeanuncios.com",
		.query = "tablondeanuncioscom",
		.url = "https://www.tablondeanuncios.com/mis-anuncios/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7f9,
		.name = "Tabnine",
		.query = "tabnine",
		.url = "https://tabnine.com",
		.email = "mailto:support@tabnine.com?subject=Account%20Deletion&body=Hello.%20Please%20delete%20my%20Tabnine%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x7fa,
		.name = "TAC Mobilités",
		.query = "tac mobilites",
		.url = "https://www.tac-mobilites.fr/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7fb,
		.name = "Tagged",
		.query = "tagged",
		.url = "https://tagged.com/account_cancel.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7fc,
		.name = "Taiga",
		.query = "taiga",
		.url = "https://tree.taiga.io/user-settings/user-profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x7fd,
		.name = "Tailscale",
		.query = "tailscale",
		.url = "https://tailscale.com/kb/1237/delete-tailnet",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x7fe,
		.name = "The Takeout",
		.query = "the takeout",
		.url = "https://notice.sp-prod.net/sar/index.html?message_id=539278&account_id=1195&ccpa_type=delete",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x7ff,
		.name = "Tandoor",
		.query = "tandoor",
		.url = "https://tandoor.dev/privacy/",
		.email = "mailto:info@tandoor.dev",
		.difficulty = 0x1000
	},
	{
		.id = 0x800,
		.name = "Tanga",
		.query = "tanga",
		.url = "https://www.tanga.com/support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x801,
		.name = "Tango",
		.query = "tango",
		.url = "https://help.tango.me/en/articles/2985296-how-do-i-delete-my-tango-account",
		.email = "mailto:support@tango.me",
		.difficulty = 0x400
	},
	{
		.id = 0x802,
		.name = "Tanki Online",
		.query = "tanki online",
		.url = "https://tankionline.com",
		.email = "mailto:help@tankionline.com?subject=Account%20Deletion%20Request&body=Hi%20there%2C%20I%20request%20to%20remove%20all%20of%20my%20personal%20data%20associated%20with%20my%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x803,
		.name = "Tapas",
		.query = "tapas",
		.url = "https://tapas.io/profile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x804,
		.name = "TapTap",
		.query = "taptap",
		.url = "https://accounts.taptap.io/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x805,
		.name = "Target",
		.query = "target",
		.url = "https://www.target.com/ccpa-intake-form",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x806,
		.name = "targetjobs",
		.query = "targetjobs",
		.url = "https://targetjobs.co.uk/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x807,
		.name = "TargetProcess",
		.query = "targetprocess",
		.url = "https://www.targetprocess.com",
		.email = "mailto:support@targetprocess.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x808,
		.name = "Taskade",
		.query = "taskade",
		.url = "https://www.taskade.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x809,
		.name = "Tastebuds",
		.query = "tastebuds",
		.url = "https://tastebuds.fm/user_deletions/confirm_delete_reason",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x80a,
		.name = "TastyWorks",
		.query = "tastyworks",
		.url = "https://support.tastyworks.com/support/solutions/articles/43000435334-close-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x80b,
		.name = "TCL",
		.query = "tcl",
		.url = "https://www.tcl.com/deleteaccount/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x80c,
		.name = "TCL à la demande",
		.query = "tcl a la demande",
		.url = "https://tad.tcl.fr/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x80d,
		.name = "Teachable",
		.query = "teachable",
		.url = "https://support.teachable.com/hc/en-us/articles/5540634496525-Delete-Your-School-or-Account#Deleteyouruseraccount",
		.email = "mailto:privacy@teachable.com?subject=Account%20Deletion&body=Hello.%20Please%20delete%20my%20Teachable%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x80e,
		.name = "Teachoo",
		.query = "teachoo",
		.url = "https://www.teachoo.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x80f,
		.name = "TeamGantt",
		.query = "teamgantt",
		.url = "https://app.teamgantt.com/admin/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x810,
		.name = "Teams",
		.query = "teams",
		.url = "https://account.live.com/closeaccount.aspx",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x811,
		.name = "TeamSpeak",
		.query = "teamspeak",
		.url = "https://support.teamspeak.com/hc/en-us/articles/4408933645201-I-can-t-find-the-option-to-delete-myTeamSpeak-account-How-do-I-do-this-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x812,
		.name = "TeamViewer",
		.query = "teamviewer",
		.url = "https://login.teamviewer.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x813,
		.name = "Tebex",
		.query = "tebex",
		.url = "https://server.tebex.io",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x814,
		.name = "Technic Platform & Technic Forums",
		.query = "technic platform technic forums",
		.url = "https://forums.technicpack.net/topic/322688-platform-forum-account-deletion-requests",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x815,
		.name = "TED",
		.query = "ted",
		.url = "https://help.ted.com/hc/en-us/articles/360005310614-How-do-I-create-TED-Ed-Accounts#:~:text=How%20can%20I%20delete%20my%20TED%2DEd%20account",
		.email = "mailto:contact@ted.com?subject=Account%20deletion%20request&body=Please%20delete%20the%20account%20associated%20with%20my%20e-mail%2C%20YOUR_EMAIL%2C%20and%20all%20its%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x816,
		.name = "Teespring",
		.query = "teespring",
		.url = "https://forms.gle/T8LQEYdQrwRoTa469 ",
		.email = "mailto:privacy@spri.ng",
		.difficulty = 0x1000
	},
	{
		.id = 0x817,
		.name = "Teladoc",
		.query = "teladoc",
		.url = "https://member.teladoc.com/help/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x818,
		.name = "Telegram",
		.query = "telegram",
		.url = "https://telegram.org/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x819,
		.name = "Telltale",
		.query = "telltale",
		.url = "https://account.telltale.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x81a,
		.name = "TEMPO",
		.query = "tempo",
		.url = "https://tempo.eu.com",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x81b,
		.name = "Temu",
		.query = "temu",
		.url = "https://www.temu.com/bgp_close_account.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x81c,
		.name = "Ten Percent Happier",
		.query = "ten percent happier",
		.url = "https://support.tenpercent.com/article/22-how-do-i-delete-my-account",
		.email = "mailto:support@tenpercent.com?subject=Account%20Deletion%20Request&body=I%20would%20like%20to%20delete%20my%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x81d,
		.name = "Tenor",
		.query = "tenor",
		.url = "https://support.google.com/tenor/answer/10455265?hl=en#zippy=%2Chow-can-i-terminate-my-tenor-account",
		.email = "mailto:support@tenor.com?subject=Account%20Deletion%20Request&body=I%20would%20like%20to%20delete%20my%20account%2C%20with%20login%20XXXXXX%20and%20e-mail%20YYYYYY.",
		.difficulty = 0x1000
	},
	{
		.id = 0x81e,
		.name = "Tenso",
		.query = "tenso",
		.url = "https://www.tenso.com/en/inquiry",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x81f,
		.name = "Termius",
		.query = "termius",
		.url = "https://account.termius.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x820,
		.name = "Terms of Service; Didn't Read",
		.query = "terms of service didnt read",
		.url = "https://edit.tosdr.org/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x821,
		.name = "TerraCycle",
		.query = "terracycle",
		.url = "https://help.us.terracycle.com/hc/en-us/articles/360060676652-How-can-I-delete-my-account-",
		.email = "mailto:customersupport@terracycle.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x822,
		.name = "Terraform Cloud",
		.query = "terraform cloud",
		.url = "https://support.hashicorp.com/hc/en-us/articles/1500002617421-Deleting-Terraform-Cloud-Accounts",
		.email = "mailto:tf-cloud@hashicorp.support",
		.difficulty = 0x1000
	},
	{
		.id = 0x823,
		.name = "Tesla",
		.query = "tesla",
		.url = "https://www.tesla.com/support/how-create-or-delete-tesla-account#deleting-your-tesla-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x824,
		.name = "Testbirds",
		.query = "testbirds",
		.url = "https://nest.testbirds.com/faq/category/list#accordion_faq-167",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x825,
		.name = "Teuxdeux",
		.query = "teuxdeux",
		.url = "https://teuxdeux.com/account/request-delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x826,
		.name = "Text.ru",
		.query = "textru",
		.url = "https://text.ru/user/profile/settings/secure",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x827,
		.name = "TextNow",
		.query = "textnow",
		.url = "https://www.textnow.com/account/new#requestDataDeletionDisclosure",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x828,
		.name = "textPlus",
		.query = "textplus",
		.url = "https://help.textplus.com/portal/en/kb/articles/how-can-i-delete-my-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x829,
		.name = "Textures.com",
		.query = "texturescom",
		.url = "https://www.textures.com/my-account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x82a,
		.name = "TheHub",
		.query = "thehub",
		.url = "https://thehub.io/contact",
		.email = "mailto:info@thehub.io",
		.difficulty = 0x1000
	},
	{
		.id = 0x82b,
		.name = "Themeplaza",
		.query = "themeplaza",
		.url = "https://themeplaza.art/contact",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x82c,
		.name = "TheMovieDB",
		.query = "themoviedb",
		.url = "https://www.themoviedb.org/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x82d,
		.name = "Theta TV",
		.query = "theta tv",
		.url = "https://community.theta.tv/general-data-protection-gdpr-data-deletion-requests/",
		.email = NULL,
		.difficulty = 0x4000
	},
	{
		.id = 0x82e,
		.name = "TheTVDB",
		.query = "thetvdb",
		.url = "https://thetvdb.com/dashboard/account/editinfo",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x82f,
		.name = "Thingiverse",
		.query = "thingiverse",
		.url = "https://support.makerbot.com/s/article/MakerBot-Account-Information",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x830,
		.name = "Things",
		.query = "things",
		.url = "https://support.culturedcode.com/customer/en/portal/articles/2803591-deleting-your-account-data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x831,
		.name = "Threads",
		.query = "threads",
		.url = "https://www.threads.net/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x832,
		.name = "Threema",
		.query = "threema",
		.url = "https://myid.threema.ch/revoke",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x833,
		.name = "Thrive Market",
		.query = "thrive market",
		.url = "https://thrivemarket.com/privacy-policy",
		.email = "mailto:help@thrivemarket.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x834,
		.name = "Ticketcorner",
		.query = "ticketcorner",
		.url = "https://www.ticketcorner.ch/helpcenter/en/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x835,
		.name = "Ticketmaster",
		.query = "ticketmaster",
		.url = "https://privacyportal.onetrust.com/webform/ba6f9c5b-dda5-43bd-bac4-4e06afccd928/968ed217-e724-4a6b-8bc0-7cb2a2c10c47",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x836,
		.name = "TicketWeb",
		.query = "ticketweb",
		.url = "https://help.ticketweb.co.uk/hc/en-gb/articles/360007874593-How-do-I-close-my-Ticketweb-account-",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x837,
		.name = "TickTick",
		.query = "ticktick",
		.url = "https://help.ticktick.com/articles/7136181511681736704",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x838,
		.name = "TIDAL",
		.query = "tidal",
		.url = "https://account.tidal.com/account-deletion",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x839,
		.name = "TikTok",
		.query = "tiktok",
		.url = "https://www.tiktok.com",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x83a,
		.name = "TikTok Developer",
		.query = "tiktok developer",
		.url = "https://developers.tiktok.com/support/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x83b,
		.name = "TikVPN",
		.query = "tikvpn",
		.url = "https://www.tikvpn.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x83c,
		.name = "Time and Date",
		.query = "time and date",
		.url = "https://www.timeanddate.com/custom/modify.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x83d,
		.name = "Timus Online Judge (TOJ)",
		.query = "timus online judge toj",
		.url = "https://acm.timus.ru/",
		.email = "mailto:timus_support@acm.timus.ru",
		.difficulty = 0x2000
	},
	{
		.id = 0x83e,
		.name = "Tinder",
		.query = "tinder",
		.url = "https://tinder.com/app/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x83f,
		.name = "TinyLetter",
		.query = "tinyletter",
		.url = "https://app.tinyletter.com/#!/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x840,
		.name = "Tisséo",
		.query = "tisseo",
		.url = "https://moncompte.tisseo.fr/fr/questions-frequentes?question=comment-supprimer-mon-compte",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x841,
		.name = "TKirch.dev",
		.query = "tkirchdev",
		.url = "https://tkirch.dev/account-management/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x842,
		.name = "TLauncher",
		.query = "tlauncher",
		.url = "https://tlauncher.org/en/how-remove-tl-account.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x843,
		.name = "Today's Wordle",
		.query = "todays wordle",
		.url = "https://todayswordle.net/account/settings/deletion",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x844,
		.name = "Todo Cloud",
		.query = "todo cloud",
		.url = "https://support.appigo.com/support/solutions/articles/4000180942-how-to-delete-my-todo-cloud-account",
		.email = "mailto:support@appigo.com?body=Please%20delete%20my%20account%20and%20the%20data%20associated%20with%20it.",
		.difficulty = 0x1000
	},
	{
		.id = 0x845,
		.name = "Todoist",
		.query = "todoist",
		.url = "https://todoist.com/app/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x846,
		.name = "Toggl Track",
		.query = "toggl track",
		.url = "https://track.toggl.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x847,
		.name = "Tois Bet",
		.query = "tois bet",
		.url = "https://toisbet.com/ptb/contents/self-exclusion",
		.email = "mailto:suporte@toisbet.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x848,
		.name = "Tokopedia",
		.query = "tokopedia",
		.url = "https://www.tokopedia.com/help/article/apakah-saya-dapat-menghapus-akun-tokopedia",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x849,
		.name = "Toluna",
		.query = "toluna",
		.url = "https://us.toluna.com/contactus",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x84a,
		.name = "TomTom GO",
		.query = "tomtom go",
		.url = "https://help.tomtom.com/hc/en-gb/requests/new?ticket_form_id=360000697820",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x84b,
		.name = "Tonton Outdoor",
		.query = "tonton outdoor",
		.url = "https://www.tonton-outdoor.com/fr_FR/supprimer-mon-compte",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x84c,
		.name = "Too Good To Go",
		.query = "too good to go",
		.url = "https://space.toogoodtogo.com/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x84d,
		.name = "ToolsForImage",
		.query = "toolsforimage",
		.url = "https://www.toolsforimage.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x84e,
		.name = "Top Universities",
		.query = "top universities",
		.url = "https://www.topuniversities.com/user/account-details#accountSettings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x84f,
		.name = "Topcoder",
		.query = "topcoder",
		.url = "https://www.topcoder.com",
		.email = "mailto:support@topcoder.com",
		.difficulty = 0x2000
	},
	{
		.id = 0x850,
		.name = "Topface",
		.query = "topface",
		.url = "https://topface.com/delete-profile/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x851,
		.name = "Tor Project",
		.query = "tor project",
		.url = "https://trac.torproject.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x852,
		.name = "TorBox",
		.query = "torbox",
		.url = "https://torbox.app/settings?section=account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x853,
		.name = "Torn",
		.query = "torn",
		.url = "https://www.torn.com/preferences.php#tab=accountClosure",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x854,
		.name = "Toronto Star",
		.query = "toronto star",
		.url = "https://www.thestar.com/about/privacy-anti-spam-notice-with-privacy-policy-and-terms-of-use-for-google-play-store.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x855,
		.name = "Toyota.de",
		.query = "toyotade",
		.url = "https://www.toyota.de/apps/customerportal#/publish/customer_portal_profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x856,
		.name = "TP-Link Cloud",
		.query = "tplink cloud",
		.url = "https://account-delete.tplinkcloud.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x857,
		.name = "Trabalha Brasil",
		.query = "trabalha brasil",
		.url = "https://www.trabalhabrasil.com.br/fale-conosco",
		.email = "mailto:atendimento@trabalhabrasil.com.br",
		.difficulty = 0x1000
	},
	{
		.id = 0x858,
		.name = "The Tracktor",
		.query = "the tracktor",
		.url = "https://thetracktor.com/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x859,
		.name = "TradeMe",
		.query = "trademe",
		.url = "https://help.trademe.co.nz/hc/en-us/articles/360007000092#h_01GBNRBS8NG0QNNRWXCV7RVWDS",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x85a,
		.name = "Trading 212",
		.query = "trading 212",
		.url = "https://app.trading212.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x85b,
		.name = "TradingView",
		.query = "tradingview",
		.url = "https://www.tradingview.com/u/account/#settings-profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x85c,
		.name = "Traduc.com",
		.query = "traduccom",
		.url = "https://traduc.com/users/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x85d,
		.name = "Tragicbeautiful",
		.query = "tragicbeautiful",
		.url = "https://tragicbeautiful.com",
		.email = "mailto:support@tragicbeautiful.com?subject=Hello%0A%2C%20please%20delete%20the%20account%20associated%20to%20this%20email.%20My%20phone%20number%20is%20XXXXXXXX%20and%20I%20would%20like%20all%20data%20associated%20to%20my%20account%20to%20be%20removed.",
		.difficulty = 0x1000
	},
	{
		.id = 0x85e,
		.name = "Trakt",
		.query = "trakt",
		.url = "https://trakt.tv/settings/advanced",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x85f,
		.name = "TransferXL",
		.query = "transferxl",
		.url = "https://transferxl.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x860,
		.name = "Transifex",
		.query = "transifex",
		.url = "https://app.transifex.com/user/settings/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x861,
		.name = "Transpocket",
		.query = "transpocket",
		.url = "https://transpocket.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x862,
		.name = "TrashMail",
		.query = "trashmail",
		.url = "https://trashmail.com/?lang=en&cmd=manager",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x863,
		.name = "tree-nation",
		.query = "treenation",
		.url = "https://tree-nation.com/userProfile/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x864,
		.name = "Trello",
		.query = "trello",
		.url = "https://trello.com/your/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x865,
		.name = "Trenitalia",
		.query = "trenitalia",
		.url = "https://www.trenitalia.com/en/info_contacts/delete-account.html",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x866,
		.name = "Trenitalia France",
		.query = "trenitalia france",
		.url = "https://www.trenitalia.com/trenitalia-france/information-and-contacts/comment-supprimer-un-espace-reserve.html",
		.email = "mailto:dpo@trenitalia.fr?subject=Demande%20de%20suppression%20de%20compte",
		.difficulty = 0x1000
	},
	{
		.id = 0x867,
		.name = "Tresorit",
		.query = "tresorit",
		.url = "https://web.tresorit.com/account/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x868,
		.name = "Trillian",
		.query = "trillian",
		.url = "https://trillian.im/account/#delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x869,
		.name = "TripAdvisor",
		.query = "tripadvisor",
		.url = "https://www.tripadvisorsupport.com/hc/en-us/articles/200615117",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x86a,
		.name = "TripIt",
		.query = "tripit",
		.url = "https://www.tripit.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x86b,
		.name = "Triptipedia",
		.query = "triptipedia",
		.url = "https://www.triptipedia.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x86c,
		.name = "Troll and Toad",
		.query = "troll and toad",
		.url = "https://www.trollandtoad.com/contact.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x86d,
		.name = "TruckersMP",
		.query = "truckersmp",
		.url = "https://truckersmp.com/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x86e,
		.name = "TrueNAS Forums",
		.query = "truenas forums",
		.url = "https://forums.truenas.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x86f,
		.name = "TrueNAS Forums (old)",
		.query = "truenas forums old",
		.url = "https://www.truenas.com/community/help/privacy-policy/",
		.email = "mailto:compliance@ixsystems.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x870,
		.name = "Trustpilot",
		.query = "trustpilot",
		.url = "https://www.trustpilot.com/users/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x871,
		.name = "TruthFinder",
		.query = "truthfinder",
		.url = "https://www.truthfinder.com/privacy-center",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x872,
		.name = "TryHackMe",
		.query = "tryhackme",
		.url = "https://tryhackme.com/manage-account/account-details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x873,
		.name = "TubeBuddy",
		.query = "tubebuddy",
		.url = "https://www.tubebuddy.com/account/deleteuser",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x874,
		.name = "Tubi",
		.query = "tubi",
		.url = "https://tubitv.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x875,
		.name = "Tumblr",
		.query = "tumblr",
		.url = "https://www.tumblr.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x876,
		.name = "Tunecore",
		.query = "tunecore",
		.url = "https://support.tunecore.com/hc/en-us/articles/115006687268-How-do-I-close-my-account",
		.email = "mailto:support@tunecore.zendesk.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x877,
		.name = "TuneMyMusic",
		.query = "tunemymusic",
		.url = "https://app.tunemymusic.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x878,
		.name = "TunnelBear",
		.query = "tunnelbear",
		.url = "https://www.tunnelbear.com/account/remove",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x879,
		.name = "TurboScribe",
		.query = "turboscribe",
		.url = "https://turboscribe.ai/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x87a,
		.name = "TurboSquid",
		.query = "turbosquid",
		.url = "https://resources.turbosquid.com/how-do-i-close-my-account/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x87b,
		.name = "Turing",
		.query = "turing",
		.url = "https://developers.turing.com/dashboard/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x87c,
		.name = "Turismo Itaipu",
		.query = "turismo itaipu",
		.url = "https://ingressos.turismoitaipu.com.br",
		.email = "mailto:atendimento@turismoitaipu.com.br",
		.difficulty = 0x1000
	},
	{
		.id = 0x87d,
		.name = "Turo",
		.query = "turo",
		.url = "https://support.turo.com/hc/en-us/articles/203991030-How-to-close-your-account",
		.email = "mailto:accountclosure@turo.com?subject=Account%20Deletion%20Request&body=Please%20delete%20the%20data%20associated%20with%20my%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x87e,
		.name = "Turtl",
		.query = "turtl",
		.url = "https://turtlapp.com/users/delete/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x87f,
		.name = "Tutamail",
		.query = "tutamail",
		.url = "https://app.tuta.com/settings/global",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x880,
		.name = "TV 2",
		.query = "tv 2",
		.url = "https://mit.tv2.dk/konto/luk",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x881,
		.name = "TV Tropes",
		.query = "tv tropes",
		.url = "https://tvtropes.org/pmwiki/profile.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x882,
		.name = "Tweek",
		.query = "tweek",
		.url = "https://tweek.so/calendar/help",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x883,
		.name = "Twilio",
		.query = "twilio",
		.url = "https://support.twilio.com/hc/en-us/requests/new",
		.email = "mailto:support@twilio.com?subject=Twilio%20user%20account%20deletion%20request&body=Please%20delete%20my%20Twilio%20user%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x884,
		.name = "Twitch",
		.query = "twitch",
		.url = "https://www.twitch.tv/user/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x885,
		.name = "twoseven",
		.query = "twoseven",
		.url = "https://twoseven.xyz/help/faq",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x886,
		.name = "Typeform",
		.query = "typeform",
		.url = "https://help.typeform.com/hc/en-us/articles/360029631211-The-right-to-be-forgotten",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x887,
		.name = "TypePad",
		.query = "typepad",
		.url = "https://www.typepad.com/secure/account/cancel-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x888,
		.name = "TypeRacer",
		.query = "typeracer",
		.url = "https://data.typeracer.com/pit/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x889,
		.name = "Typing.com",
		.query = "typingcom",
		.url = "https://www.typing.com/student/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x88a,
		.name = "TypingClub / EdClub",
		.query = "typingclub edclub",
		.url = "https://www.edclub.com/sportal/profile.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x88b,
		.name = "Uber",
		.query = "uber",
		.url = "https://myprivacy.uber.com/privacy/deleteyouraccount",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x88c,
		.name = "Ubiquiti",
		.query = "ubiquiti",
		.url = "https://www.ui.com/global-request/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x88d,
		.name = "Ubisoft",
		.query = "ubisoft",
		.url = "https://account.ubisoft.com/en-US/account-information/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x88e,
		.name = "Ubuntu One",
		.query = "ubuntu one",
		.url = "https://login.ubuntu.com/+faq#can-i-delete-my-ubuntu-one-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x88f,
		.name = "Udacity",
		.query = "udacity",
		.url = "https://udacity.trsnd.co/policies?action=ERASURE&modal=take-control",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x890,
		.name = "Udemy",
		.query = "udemy",
		.url = "https://www.udemy.com/user/close-account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x891,
		.name = "UFC Fight Pass",
		.query = "ufc fight pass",
		.url = "https://www.ufc.com/faq-ufctv-ufcfightpass",
		.email = "mailto:support@ufc.tv",
		.difficulty = 0x1000
	},
	{
		.id = 0x892,
		.name = "UGC",
		.query = "ugc",
		.url = "https://www.ugc.fr/aide.html?question=supprimer-compte-ugc",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x893,
		.name = "Ultimate Guitar",
		.query = "ultimate guitar",
		.url = "https://www.ultimate-guitar.com/forum/profile/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x894,
		.name = "umami",
		.query = "umami",
		.url = "https://cloud.umami.is/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x895,
		.name = "Uncubed",
		.query = "uncubed",
		.url = "https://uncubed.com/learn/users/edit",
		.email = "mailto:team@uncubed.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x896,
		.name = "Uncyclopedia",
		.query = "uncyclopedia",
		.url = "https://en.uncyclopedia.co/wiki/Uncyclopedia:Delete_my_account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x897,
		.name = "Unfuddle Ten",
		.query = "unfuddle ten",
		.url = "https://unfuddle.io/app",
		.email = "mailto:support@unfuddle.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x898,
		.name = "Unidays",
		.query = "unidays",
		.url = "https://www.myunidays.com/US/en-US/account/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x899,
		.name = "Uniqlo",
		.query = "uniqlo",
		.url = "https://www.uniqlo.com/us/en/member/details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x89a,
		.name = "United Domains",
		.query = "united domains",
		.url = "https://www.united-domains.de/support/kontakt-formular/close//",
		.email = "mailto:support@united-domains.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x89b,
		.name = "Unity ID",
		.query = "unity id",
		.url = "https://id.unity.com/en/account/edit",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x89c,
		.name = "UnKnoWnCheaTs",
		.query = "unknowncheats",
		.url = "https://www.unknowncheats.me/forum/showgroups.php",
		.email = "mailto:siteadmin@unknowncheats.me",
		.difficulty = 0x4000
	},
	{
		.id = 0x89d,
		.name = "Unroll.me",
		.query = "unrollme",
		.url = "https://unroll.me/user/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x89e,
		.name = "Unsplash",
		.query = "unsplash",
		.url = "https://unsplash.com/account/close",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x89f,
		.name = "Uphold",
		.query = "uphold",
		.url = "https://wallet.uphold.com/close-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8a0,
		.name = "UPS",
		.query = "ups",
		.url = "https://wwwapps.ups.com/ppc/ppc.html?loc=en_US#/informationPage/deleteProfile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8a1,
		.name = "Uptime Observer",
		.query = "uptime observer",
		.url = "https://uptimeobserver.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8a2,
		.name = "Uptime Robot",
		.query = "uptime robot",
		.url = "https://uptimerobot.com/dashboard#mySettings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8a3,
		.name = "Upwork",
		.query = "upwork",
		.url = "https://www.upwork.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8a4,
		.name = "Urcdkey",
		.query = "urcdkey",
		.url = "https://www.urcdkey.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8a5,
		.name = "Usersnap",
		.query = "usersnap",
		.url = "https://usersnap.com/contact",
		.email = "mailto:help@usersnap.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x8a6,
		.name = "Usmobile",
		.query = "usmobile",
		.url = "https://www.usmobile.com/about-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8a7,
		.name = "Uswitch",
		.query = "uswitch",
		.url = "https://www.uswitch.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8a8,
		.name = "Utry.me",
		.query = "utryme",
		.url = "https://shop.utryme.com/kontaktformular",
		.email = "mailto:service@utryme.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x8a9,
		.name = "uVPN",
		.query = "uvpn",
		.url = "https://uvpn.me/support/#contactus",
		.email = "mailto:support@uvpn.me",
		.difficulty = 0x1000
	},
	{
		.id = 0x8aa,
		.name = "Uxcel",
		.query = "uxcel",
		.url = "https://app.uxcel.com/settings/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ab,
		.name = "UXPin",
		.query = "uxpin",
		.url = "https://www.uxpin.com/docs/account/closing-your-account/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8ac,
		.name = "V.PS Hosting",
		.query = "vps hosting",
		.url = "https://vps.hosting/clientarea/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ad,
		.name = "Valence Romans Mobilités",
		.query = "valence romans mobilites",
		.url = "https://start.valenceromansmobilites.fr/fr/compte/informations",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ae,
		.name = "Valorant",
		.query = "valorant",
		.url = "https://support-valorant.riotgames.com/hc/en-us/articles/360050328414-Deleting-Your-Riot-Account-and-All-Your-Data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8af,
		.name = "Vans.com",
		.query = "vanscom",
		.url = "https://www.vans.com/en-us/help/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8b0,
		.name = "VCRDB / Valorant Crosshair Database",
		.query = "vcrdb valorant crosshair database",
		.url = "https://www.vcrdb.net/profile",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8b1,
		.name = "VCV Rack",
		.query = "vcv rack",
		.url = "https://vcvrack.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8b2,
		.name = "Veduca",
		.query = "veduca",
		.url = "https://veduca.org",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8b3,
		.name = "Velo Hero",
		.query = "velo hero",
		.url = "https://app.velohero.com/settings/terminate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8b4,
		.name = "Velo'v",
		.query = "velov",
		.url = "https://velov.grandlyon.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8b5,
		.name = "Venmo",
		.query = "venmo",
		.url = "https://account.venmo.com/settings/profile/cancel/confirm",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8b6,
		.name = "Vercel",
		.query = "vercel",
		.url = "https://vercel.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8b7,
		.name = "Verkkokauppa.com",
		.query = "verkkokauppacom",
		.url = "https://asiakaspalvelu.verkkokauppa.com/hc/fi/articles/360000242527-Asiakastili",
		.email = "mailto:asiakaspalvelu@verkkokauppa.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x8b8,
		.name = "vgy.me",
		.query = "vgyme",
		.url = "https://vgy.me",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8b9,
		.name = "ViaBox",
		.query = "viabox",
		.url = "https://viabox.zendesk.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8ba,
		.name = "Viadeo",
		.query = "viadeo",
		.url = "https://www.viadeo.com/settings/account/?ga_from=Fu:%2Fsettings%2Faccount%2F;Fb%3Amenu_box_right%3BFe%3AL1-account-settings%3B",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8bb,
		.name = "viainvest",
		.query = "viainvest",
		.url = "https://viainvest.com/en/faq",
		.email = "mailto:support@viainvest.com?subject=Request%20to%20delete%20my%20account%20from%20ViaInvest&body=I%20have%20an%20account%20in%20your%20database%20associated%20with%20the%20name%20XXXXXX%20and%20the%20email%20address%20XXXXXX.%20I%20have%20decided%20not%20to%20use%20the%20account%20again%3B%20therefore%2C%20I%20request%20that%20you%20kindly%20delete%20my%20account%20from%20your%20database%20and%20delete%20all%20the%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x8bc,
		.name = "Viber",
		.query = "viber",
		.url = "https://help.viber.com/hc/en-us/articles/9174583112861",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8bd,
		.name = "VideosGeneratorAI",
		.query = "videosgeneratorai",
		.url = "https://videosgeneratorai.com/terms-of-use",
		.email = "mailto:balt1794@gmail.com?subject=Account%20Deletion%20Request&body=Account%20Deletion%20Request",
		.difficulty = 0x1000
	},
	{
		.id = 0x8be,
		.name = "Vidio",
		.query = "vidio",
		.url = "https://support.vidio.com/support/solutions/articles/43000060322--delete-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8bf,
		.name = "VidIQ",
		.query = "vidiq",
		.url = "https://app.vidiq.com/account/settings/my-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8c0,
		.name = "VidLii",
		.query = "vidlii",
		.url = "https://www.vidlii.com/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8c1,
		.name = "Vidyard",
		.query = "vidyard",
		.url = "https://knowledge.vidyard.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8c2,
		.name = "VikACG",
		.query = "vikacg",
		.url = "https://www.vikacg.com/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8c3,
		.name = "Vimeo",
		.query = "vimeo",
		.url = "https://vimeo.com/settings/goodbye/forever",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8c4,
		.name = "Vinted",
		.query = "vinted",
		.url = "https://www.vinted.com/member/general/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8c5,
		.name = "Virmach",
		.query = "virmach",
		.url = "https://billing.virmach.com/submitticket.php",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8c6,
		.name = "VirtCloud",
		.query = "virtcloud",
		.url = "https://virtcloud.net",
		.email = "mailto:info@virtcloud.net?subject=Account%20Deletion%20Request&body=Hi%2C%20please%20delete%20the%20account%20associated%20with%20my%20FULL_NAME%20and%20EMAIL_ADDRESS.%20Thanks.",
		.difficulty = 0x1000
	},
	{
		.id = 0x8c7,
		.name = "Virtualmaster",
		.query = "virtualmaster",
		.url = "https://www.virtualmaster.com/virtualmaster/en/issues",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8c8,
		.name = "VirusTotal",
		.query = "virustotal",
		.url = "https://www.virustotal.com/gui/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8c9,
		.name = "Visit Japan Web (Japanese Customs)",
		.query = "visit japan web japanese customs",
		.url = "https://www.vjw.digital.go.jp/main/#/vjwpco005",
		.email = "mailto:ciq@digital.go.jp?body=Please%20delete%20my%20Visit%20Japan%20Web%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x8ca,
		.name = "Visme",
		.query = "visme",
		.url = "https://dashboard.visme.co/v2/account-settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8cb,
		.name = "Visualping",
		.query = "visualping",
		.url = "https://visualping.io/account/profile/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8cc,
		.name = "VitalSource",
		.query = "vitalsource",
		.url = "https://support.vitalsource.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8cd,
		.name = "Viva o Linux (VOL)",
		.query = "viva o linux vol",
		.url = "https://www.vivaolinux.com.br/minhaConta.php",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ce,
		.name = "Vivaldi",
		.query = "vivaldi",
		.url = "https://help.vivaldi.com/services/account/delete-account-on-vivaldi-net/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8cf,
		.name = "Vive La Mode",
		.query = "vive la mode",
		.url = "https://vive-lamode.com",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8d0,
		.name = "ViVo",
		.query = "vivo",
		.url = "https://passport.vivo.com/in/#/personalCenter",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8d1,
		.name = "VK/ВКонтакте",
		.query = "vkвконтакте",
		.url = "https://vk.com/settings?act=deactivate",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x8d2,
		.name = "Voi",
		.query = "voi",
		.url = "https://help.voi.com/en_gb/i-want-to-delete-my-voi-account-S1TgkzhO_",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8d3,
		.name = "Voicemod",
		.query = "voicemod",
		.url = "https://www.voicemod.net/support/?letstalk=Account%20and%20Login&issue",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8d4,
		.name = "Volcano Hosting",
		.query = "volcano hosting",
		.url = "https://www.volcanohosting.net",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8d5,
		.name = "Volcengine",
		.query = "volcengine",
		.url = "https://console.volcengine.com/user/logout/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8d6,
		.name = "Volet",
		.query = "volet",
		.url = "https://support.volet.com/hc/en-us/articles/360021927159-Closing-your-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8d7,
		.name = "VoucherCodes",
		.query = "vouchercodes",
		.url = "https://support.vouchercodes.co.uk/hc/en-us/articles/360000349566-How-do-I-delete-my-Account-",
		.email = "mailto:privacy@vouchercodes.co.uk",
		.difficulty = 0x1000
	},
	{
		.id = 0x8d8,
		.name = "Vox Media",
		.query = "vox media",
		.url = "https://www.voxmedia.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8d9,
		.name = "Voxer",
		.query = "voxer",
		.url = "https://support.voxer.com/hc/en-us/articles/204330173-How-do-I-delete-my-Voxer-account-",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8da,
		.name = "Voxtelesys",
		.query = "voxtelesys",
		.url = "https://voxtelesys.com/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8db,
		.name = "Vrbo",
		.query = "vrbo",
		.url = "https://www.vrbo.com/user/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8dc,
		.name = "VRChat",
		.query = "vrchat",
		.url = "https://help.vrchat.com/hc/en-us/articles/1500002379282-I-want-to-delete-my-VRChat-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8dd,
		.name = "VSCO",
		.query = "vsco",
		.url = "https://support.vsco.co/hc/en-us/articles/360004196352-How-do-I-delete-my-VSCO-Account-",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8de,
		.name = "VSTBuzz",
		.query = "vstbuzz",
		.url = "https://vstbuzz.com/contact/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8df,
		.name = "VTech",
		.query = "vtech",
		.url = "https://www.vtechkids.com/support/support_form/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8e0,
		.name = "Vueling",
		.query = "vueling",
		.url = "https://tickets.vueling.com/DeleteUser.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8e1,
		.name = "Vuforia Chalk",
		.query = "vuforia chalk",
		.url = "https://support.ptc.com/help/vuforia/chalk_app_center/index.html#page/Vuforia_Chalk_Admin_Center/common/delete_account.html",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8e2,
		.name = "Vuforia Developer Account",
		.query = "vuforia developer account",
		.url = "https://developer.vuforia.com/support/contact/login",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8e3,
		.name = "Vultr",
		.query = "vultr",
		.url = "https://my.vultr.com/support",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8e4,
		.name = "W3Schools",
		.query = "w3schools",
		.url = "https://pathfinder.w3schools.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8e5,
		.name = "Wacom Cloud",
		.query = "wacom cloud",
		.url = "https://account.wacom.com/en-us/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8e6,
		.name = "Wahoo Fitness",
		.query = "wahoo fitness",
		.url = "https://privacyportal.onetrust.com/webform/b2b76ae8-d622-4165-97c7-8896261e24b7/b43eda4f-3724-4303-879c-e65dbcfced1d",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8e7,
		.name = "Waifudex",
		.query = "waifudex",
		.url = "https://waifudex.com/home",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8e8,
		.name = "Wakanim",
		.query = "wakanim",
		.url = "https://www.wakanim.tv/sc/v2/static/contactus",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8e9,
		.name = "wallabag",
		.query = "wallabag",
		.url = "https://app.wallabag.it/subscription/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ea,
		.name = "Wallhaven",
		.query = "wallhaven",
		.url = "https://wallhaven.cc/team",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8eb,
		.name = "wallpiece",
		.query = "wallpiece",
		.url = "https://wallpiece.io/account/register/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ec,
		.name = "Walmart",
		.query = "walmart",
		.url = "https://www.walmart.com/account/api/ccpa-intake?native=false&app=gm&type=access",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8ed,
		.name = "Walmart Canada",
		.query = "walmart canada",
		.url = "https://www.walmart.ca/en/account/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ee,
		.name = "WaniKani",
		.query = "wanikani",
		.url = "https://www.wanikani.com/settings/danger_zone",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ef,
		.name = "Wappalyzer",
		.query = "wappalyzer",
		.url = "https://www.wappalyzer.com/account/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f0,
		.name = "Wargaming.net",
		.query = "wargamingnet",
		.url = "https://eu.wargaming.net/personal/suspend_account/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8f1,
		.name = "Warmshowers",
		.query = "warmshowers",
		.url = "https://www.warmshowers.org/privacy",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f2,
		.name = "Warner Bros. Games",
		.query = "warner bros games",
		.url = "https://account.wbgames.com/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8f3,
		.name = "Wasabi Hosting",
		.query = "wasabi hosting",
		.url = "https://wasabihosting.com/clientarea.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8f4,
		.name = "The Washington Post",
		.query = "the washington post",
		.url = "https://helpcenter.washingtonpost.com/hc/en-us/requests/new",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x8f5,
		.name = "Watch2Gether",
		.query = "watch2gether",
		.url = "https://w2g.tv/users/current_user",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f6,
		.name = "Wattpad",
		.query = "wattpad",
		.url = "https://www.wattpad.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f7,
		.name = "WayFi Wireless",
		.query = "wayfi wireless",
		.url = "https://wayfiwireless.com/contact",
		.email = "mailto:privacy@wayfiwireless.com?body=I%20want%20my%20account%20to%20be%20deleted.%20My%20full%20name%20is%20XXXXXX%20and%20my%20user%20name%20is%20XXXXXX.%20Please%20remove%20my%20profile%20from%20WayFi%20Wireless%20and%20delete%20all%20associated%20data.",
		.difficulty = 0x1000
	},
	{
		.id = 0x8f8,
		.name = "WAYN",
		.query = "wayn",
		.url = "https://www.wayn.com/wayn.html?wci=unregister",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8f9,
		.name = "Waze",
		.query = "waze",
		.url = "https://www.waze.com/dashboard/delete_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8fa,
		.name = "Weather API",
		.query = "weather api",
		.url = "https://www.weatherapi.com/my/close-account.aspx",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8fb,
		.name = "The Weather Network",
		.query = "the weather network",
		.url = "https://www.theweathernetwork.com/my-account/?intcmp=twn_supernav_settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x8fc,
		.name = "Weather.com",
		.query = "weathercom",
		.url = "https://registration.weather.com/ursa/profile/unsubscribe",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8fd,
		.name = "WEB.DE",
		.query = "webde",
		.url = "https://kundencenter.web.de",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8fe,
		.name = "Webex - Free Account",
		.query = "webex free account",
		.url = "https://help.webex.com/en-us/5m4i4y/Delete-Your-Free-Webex-Account#id_111643",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x8ff,
		.name = "Webflow",
		.query = "webflow",
		.url = "https://support.webflow.com/resources/delete-account",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x900,
		.name = "Webhosting.dk",
		.query = "webhostingdk",
		.url = "https://www.webhosting.dk/DKK/deleteaccount.php",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x901,
		.name = "Weblate",
		.query = "weblate",
		.url = "https://hosted.weblate.org/accounts/remove/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x902,
		.name = "Webtickets",
		.query = "webtickets",
		.url = "https://www.webtickets.co.za/v2/FAQ.aspx?itemid=1505441537",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x903,
		.name = "WEBTOON",
		.query = "webtoon",
		.url = "https://www.webtoons.com/en/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x904,
		.name = "Webull",
		.query = "webull",
		.url = "https://www.webull.com/hc/categories/fq125-How-do-I-delete-my-Webull-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x905,
		.name = "WeChat",
		.query = "wechat",
		.url = "https://help.wechat.com/cgi-bin/micromsg-bin/oshelpcenter?opcode=2&id=1706083AnYFb170608VF3Ur2",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x906,
		.name = "Weebly",
		.query = "weebly",
		.url = "https://www.weebly.com/home/account/data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x907,
		.name = "WeHeartIt",
		.query = "weheartit",
		.url = "https://weheartit.com/settings/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x908,
		.name = "Weibo",
		.query = "weibo",
		.url = "https://kefu.weibo.com/faqdetail?id=20690",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x909,
		.name = "Weights",
		.query = "weights",
		.url = "https://www.weights.com/settings",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x90a,
		.name = "WeirdGloop",
		.query = "weirdgloop",
		.url = "https://weirdgloop.org/",
		.email = "mailto:support@weirdgloop.org",
		.difficulty = 0x2000
	},
	{
		.id = 0x90b,
		.name = "WeMod",
		.query = "wemod",
		.url = "https://support.wemod.com/docs/how-do-i-delete-my-account",
		.email = "mailto:support@wemod.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x90c,
		.name = "Western Union",
		.query = "western union",
		.url = "https://wucare.westernunion.com/s/article/How-do-I-log-in-at-westernunion-com?language=en_US#delete",
		.email = "mailto:customercare@westernunion.com?body=My%20name%20is%20XXXXXX%250AMy%20registered%20phone%20number%20is%20XXXXXX%250AMy%20WU%20number%20is%20XXXXXX%250AI%20would%20like%20to%20delete%20my%20WU%20profile%20because%20XXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x90d,
		.name = "Westfield",
		.query = "westfield",
		.url = "https://www.westfield.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x90e,
		.name = "WeTransfer",
		.query = "wetransfer",
		.url = "https://wetransfer.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x90f,
		.name = "WG-Gesucht.de",
		.query = "wggesuchtde",
		.url = "https://www.wg-gesucht.de/hilfe.html#collapse-account-4",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x910,
		.name = "WhatPulse",
		.query = "whatpulse",
		.url = "https://whatpulse.org/my/#home",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x911,
		.name = "WhatsApp",
		.query = "whatsapp",
		.url = "https://faq.whatsapp.com/2138577903196467/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x912,
		.name = "When I Work",
		.query = "when i work",
		.url = "https://help.wheniwork.com/articles/request-profile-deletion-ios/",
		.email = "mailto:support@wheniwork.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x913,
		.name = "Where Am I?",
		.query = "where am i",
		.url = "https://whereamigame.app/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x914,
		.name = "Which?",
		.query = "which",
		.url = "https://www.which.co.uk/terms-and-conditions/your-which-membership/",
		.email = "mailto:which@which.co.uk?body=My%20membership%20number%20is%20XXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x915,
		.name = "Whimsical",
		.query = "whimsical",
		.url = "https://whimsical.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x916,
		.name = "Whirlpool",
		.query = "whirlpool",
		.url = "http://whirlpool.net.au/wiki/wp_deleteaccount",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x917,
		.name = "Whizlabs",
		.query = "whizlabs",
		.url = "https://www.whizlabs.com/contact-us/",
		.email = "mailto:support@whizlabs.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x918,
		.name = "WhoSay.com",
		.query = "whosaycom",
		.url = "https://www.whosay.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x919,
		.name = "Wifi Map",
		.query = "wifi map",
		.url = "https://www.wifimap.io/accountDeleting",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x91a,
		.name = "WiGLE",
		.query = "wigle",
		.url = "https://wigle.net/deleteAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x91b,
		.name = "Wikidot",
		.query = "wikidot",
		.url = "https://www.wikidot.com/account/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x91c,
		.name = "wikiHow",
		.query = "wikihow",
		.url = "wikihow.com/Special:Preferences#mw-prefsection-personal",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x91d,
		.name = "Wikimedia Commons",
		.query = "wikimedia commons",
		.url = "https://commons.wikimedia.org/wiki/Commons:Username_policy#Deleting_your_account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x91e,
		.name = "Wikipedia",
		.query = "wikipedia",
		.url = "https://en.wikipedia.org/wiki/Wikipedia:FAQ/Main#How_do_I_change_my_username%2Fdelete_my_account?",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x91f,
		.name = "Wilds.io",
		.query = "wildsio",
		.url = "http://wilds.io",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x920,
		.name = "Wilson epark",
		.query = "wilson epark",
		.url = "http://myaccount.epark.com.au/ContactUs.aspx",
		.email = "mailto:info@epark.com.au",
		.difficulty = 0x1000
	},
	{
		.id = 0x921,
		.name = "Wilson Parking",
		.query = "wilson parking",
		.url = "https://www.wilsonparking.com.au",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x922,
		.name = "Windscribe",
		.query = "windscribe",
		.url = "https://windscribe.com/cancel/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x923,
		.name = "Windy",
		.query = "windy",
		.url = "https://account.windy.com/profile/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x924,
		.name = "Wine HQ",
		.query = "wine hq",
		.url = "https://forum.winehq.org/",
		.email = "mailto:web-admin@winehq.org",
		.difficulty = 0x1000
	},
	{
		.id = 0x925,
		.name = "Wire",
		.query = "wire",
		.url = "https://support.wire.com/hc/en-us/articles/207555795-Delete-a-Wire-Personal-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x926,
		.name = "Wise",
		.query = "wise",
		.url = "https://wise.com/settings/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x927,
		.name = "WiseMapping",
		.query = "wisemapping",
		.url = "https://app.wisemapping.com/c/maps/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x928,
		.name = "Wish",
		.query = "wish",
		.url = "https://www.wish.com/settings/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x929,
		.name = "WishSimply",
		.query = "wishsimply",
		.url = "https://wishsimply.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x92a,
		.name = "Withings",
		.query = "withings",
		.url = "https://account.withings.com/account/account_delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x92b,
		.name = "Wix",
		.query = "wix",
		.url = "https://manage.wix.com/account/close-account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x92c,
		.name = "Wizarding World",
		.query = "wizarding world",
		.url = "https://www.wizardingworld.com/profile/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x92d,
		.name = "Wizards of the Coast",
		.query = "wizards of the coast",
		.url = "https://support.wizards.com/hc/en-us/requests/new?ticket_form_id=360000108786",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x92e,
		.name = "WolframAlpha.com",
		.query = "wolframalphacom",
		.url = "https://www.wolframalpha.com/fbfaqs.html",
		.email = "mailto:info@wolframalpha.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x92f,
		.name = "Woltlab",
		.query = "woltlab",
		.url = "https://www.woltlab.com/account-management/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x930,
		.name = "Woolworths",
		.query = "woolworths",
		.url = "https://www.woolworths.com.au/shop/discover/about-us/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x931,
		.name = "Woot",
		.query = "woot",
		.url = "https://account.woot.com/support/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x932,
		.name = "Wordfeud",
		.query = "wordfeud",
		.url = "https://wordfeud.com/",
		.email = "mailto:support@wordfeud.com",
		.difficulty = 0x400
	},
	{
		.id = 0x933,
		.name = "WordPress.com",
		.query = "wordpresscom",
		.url = "https://wordpress.com/me/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x934,
		.name = "WordPress.org",
		.query = "wordpressorg",
		.url = "https://wordpress.org/about/privacy/data-erasure-request/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x935,
		.name = "workupload",
		.query = "workupload",
		.url = "https://workupload.com/contact",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x936,
		.name = "Workwise.io",
		.query = "workwiseio",
		.url = "https://www.workwise.io/en/einstellungen",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x937,
		.name = "WorkZilla",
		.query = "workzilla",
		.url = "https://client.work-zilla.com/settings/delete-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x938,
		.name = "World Market",
		.query = "world market",
		.url = "https://www.worldmarket.com/category/customer-service/world-market-rewards-faqs.do",
		.email = "mailto:customercare@worldmarket.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x939,
		.name = "WorldAnvil",
		.query = "worldanvil",
		.url = "https://www.worldanvil.com/dashboard/user/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x93a,
		.name = "WOT (Web Of Trust)",
		.query = "wot web of trust",
		.url = "https://support.mywot.com/hc/en-us/articles/115002805334-How-can-I-delete-my-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x93b,
		.name = "WP",
		.query = "wp",
		.url = "https://1login.wp.pl/profil/dane",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x93c,
		.name = "Writefull",
		.query = "writefull",
		.url = "https://my.writefull.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x93d,
		.name = "WT.Social",
		.query = "wtsocial",
		.url = "https://wt.social/myaccount/deactivate-account",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x93e,
		.name = "X",
		.query = "x",
		.url = "https://x.com/settings/deactivate",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x93f,
		.name = "XDA Developers",
		.query = "xda developers",
		.url = "https://docs.google.com/forms/d/e/1FAIpQLSdxxyNAowYtLZ0Thrzjdrw_hME_mdQW5mU5JJG1tXwZuraang/viewform",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x940,
		.name = "XenForo Italia",
		.query = "xenforo italia",
		.url = "https://www.xfitalia.it/community/account/account-details",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x941,
		.name = "Xing",
		.query = "xing",
		.url = "https://www.xing.com/preferences/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x942,
		.name = "XREAL",
		.query = "xreal",
		.url = "https://us.shop.xreal.com/",
		.email = "mailto:support@xreal.com?subject=XREAL%20Account%20Deletion%20Request&body=Please%20delete%20my%20XREAL%20account.",
		.difficulty = 0x1000
	},
	{
		.id = 0x943,
		.name = "XSplit",
		.query = "xsplit",
		.url = "https://www.xsplit.com/dashboard/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x944,
		.name = "XVideos",
		.query = "xvideos",
		.url = "https://info.xvideos.com/faq/question/73-everyone-how_can_i_delete_my_account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x945,
		.name = "Yahoo!",
		.query = "yahoo",
		.url = "https://edit.yahoo.com/config/delete_user",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x946,
		.name = "Yammer",
		.query = "yammer",
		.url = "https://www.yammer.com/mozillians/account/display_options",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x947,
		.name = "Yandex",
		.query = "yandex",
		.url = "https://passport.yandex.com/profile/delete?origin=passport_profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x948,
		.name = "Yannik",
		.query = "yannik",
		.url = "https://yannik.biz/",
		.email = "mailto:support@yannik.biz",
		.difficulty = 0x1000
	},
	{
		.id = 0x949,
		.name = "Yelp",
		.query = "yelp",
		.url = "https://www.yelp.com/support/contact/account_closure",
		.email = "mailto:dataprotection@yelp.com?subject=Account%20Data%20Deletion%20Request&body=Please%20delete%20my%20account%20and%20all%20data%20associated%20with%20it.%20My%20username%20is%20XXXXXX",
		.difficulty = 0x1000
	},
	{
		.id = 0x94a,
		.name = "YNAB (You Need A Budget)",
		.query = "ynab you need a budget",
		.url = "https://app.youneedabudget.com/users/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x94b,
		.name = "Yoast",
		.query = "yoast",
		.url = "https://yoast.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x94c,
		.name = "You.com",
		.query = "youcom",
		.url = "https://you.com/profile",
		.email = "mailto:legal@you.com",
		.difficulty = 0x400
	},
	{
		.id = 0x94d,
		.name = "youlookfab",
		.query = "youlookfab",
		.url = "https://youlookfab.com",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x94e,
		.name = "YouSee.dk",
		.query = "youseedk",
		.url = "https://etray.yousee.dk/Privat/N/Portal/Master.html?token=Jhzav0yLEx1=1x/hWwg2lMi0OYiUyMQ4HsKy",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x94f,
		.name = "Yousician",
		.query = "yousician",
		.url = "https://account.yousician.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x950,
		.name = "YouTrack",
		.query = "youtrack",
		.url = "https://hub.jetbrains.com/users/me",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x951,
		.name = "YouTube",
		.query = "youtube",
		.url = "https://myaccount.google.com/deleteservices",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x952,
		.name = "YoYo Games",
		.query = "yoyo games",
		.url = "https://help.yoyogames.com/hc/en-us/articles/360025895752-How-can-I-delete-my-data-",
		.email = "mailto:datacontroller@yoyogames.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x953,
		.name = "YRIS",
		.query = "yris",
		.url = "https://www.yris.eu/en/frequently-asked-questions/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x954,
		.name = "Yuka",
		.query = "yuka",
		.url = "https://app.yuka.io/deleteAccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x955,
		.name = "Yummly",
		.query = "yummly",
		.url = "https://www.yummly.com/settings",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x956,
		.name = "YUR",
		.query = "yur",
		.url = "https://docs.google.com/forms/d/e/1FAIpQLSca2oePqdnrJWKh4U2LvnwSBZCi5FRTCDdoi0pjU21u9kBFLQ/viewform",
		.email = "mailto:hi@yur.fit",
		.difficulty = 0x1000
	},
	{
		.id = 0x957,
		.name = "Z-Library",
		.query = "zlibrary",
		.url = "https://z-library.se",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x958,
		.name = "Zalando",
		.query = "zalando",
		.url = "https://www.zalando.co.uk/myaccount/privacy/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x959,
		.name = "Zamnesia",
		.query = "zamnesia",
		.url = "https://www.zamnesia.com/contact-us",
		.email = "mailto:support@zamnesia.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x95a,
		.name = "Zanichelli",
		.query = "zanichelli",
		.url = "https://my.zanichelli.it/registrazione/profilo",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x95b,
		.name = "Zap Imóveis",
		.query = "zap imoveis",
		.url = "https://privacidade.zapimoveis.com.br/?itl_id=1000129&itl_name=zap_-_link-footer_portal-de-privacidade_to_zap_login",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x95c,
		.name = "Zapier",
		.query = "zapier",
		.url = "https://zapier.com/app/settings/advanced/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x95d,
		.name = "Zappos",
		.query = "zappos",
		.url = "https://www.zappos.com/c/contact-us",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x95e,
		.name = "Zattoo",
		.query = "zattoo",
		.url = "https://zattoo.com/account/delete",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x95f,
		.name = "Zave it",
		.query = "zave it",
		.url = "https://www.stuttgarter-nachrichten.de/inhalt.zave-it-account-loeschen-mhsd.6a51e46c-5c2b-4faf-9942-22056e1f9dc4.html",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x960,
		.name = "Zaxby's",
		.query = "zaxbys",
		.url = "https://www.zaxbys.com/",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x961,
		.name = "Zazzle",
		.query = "zazzle",
		.url = "https://www.zazzle.com/about/ask",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x962,
		.name = "ZDNet",
		.query = "zdnet",
		.url = "https://dsar.ziffdavis.com/",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x963,
		.name = "Zeet",
		.query = "zeet",
		.url = "https://zeet.co/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x964,
		.name = "Zeit Online",
		.query = "zeit online",
		.url = "https://zeit.de",
		.email = "mailto:community@zeit.de",
		.difficulty = 0x1000
	},
	{
		.id = 0x965,
		.name = "Zello",
		.query = "zello",
		.url = "https://my.zello.com/user/home/#remove-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x966,
		.name = "Zenamu",
		.query = "zenamu",
		.url = "https://zenamu.com/contact/",
		.email = "mailto:support@zenamu.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x967,
		.name = "Zendesk",
		.query = "zendesk",
		.url = "https://support.zendesk.com/hc/en-us/articles/223774027-Canceling-your-Support-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x968,
		.name = "Zenkit",
		.query = "zenkit",
		.url = "https://zenkit.com/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x969,
		.name = "ZenMarket",
		.query = "zenmarket",
		.url = "https://zenmarket.jp/en/help.aspx",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x96a,
		.name = "Zenni Optical",
		.query = "zenni optical",
		.url = "https://www.zennioptical.com/help/contactsupport",
		.email = NULL,
		.difficulty = 0x1000
	},
	{
		.id = 0x96b,
		.name = "Zeplin",
		.query = "zeplin",
		.url = "https://app.zeplin.io/profile/account",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x96c,
		.name = "Zero",
		.query = "zero",
		.url = "https://zerofasting.zendesk.com/hc/en-us/articles/4402526167067-How-to-Delete-Your-Account-and-Data",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x96d,
		.name = "ZeroSSL",
		.query = "zerossl",
		.url = "https://app.zerossl.com/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x96e,
		.name = "ZeroTier",
		.query = "zerotier",
		.url = "https://docs.zerotier.com/central-billing/#how-to-delete-your-whole-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x96f,
		.name = "Zhihu",
		.query = "zhihu",
		.url = "https://www.zhihu.com/unregister",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x970,
		.name = "Zoho",
		.query = "zoho",
		.url = "https://accounts.zoho.com/u/h#setting/closeaccount",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x971,
		.name = "ZombieLink",
		.query = "zombielink",
		.url = "https://zombiesrungame.com/zombielink/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x972,
		.name = "ZoogVPN",
		.query = "zoogvpn",
		.url = "https://app.zoogvpn.net/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x973,
		.name = "Zoológico de São Paulo",
		.query = "zoologico de sao paulo",
		.url = "https://zoologico.com.br/",
		.email = NULL,
		.difficulty = 0x2000
	},
	{
		.id = 0x974,
		.name = "Zoom",
		.query = "zoom",
		.url = "https://zoom.us/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x975,
		.name = "Zotero",
		.query = "zotero",
		.url = "https://www.zotero.org/settings/account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x976,
		.name = "Zulip",
		.query = "zulip",
		.url = "https://zulipchat.com/help/deactivate-your-account",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x977,
		.name = "zyBooks",
		.query = "zybooks",
		.url = "https://www.zybooks.com/privacy-policy",
		.email = "mailto:support@zybooks.com",
		.difficulty = 0x1000
	},
	{
		.id = 0x978,
		.name = "Zynga",
		.query = "zynga",
		.url = "https://privacy.zynga.com/portal/#/",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x979,
		.name = "Zzo.ai",
		.query = "zzoai",
		.url = "https://zzo.ai/profile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x97a,
		.name = "Zé Delivery",
		.query = "ze delivery",
		.url = "https://faq-consumidor-zedelivery.sprinklr.com/articles/conta-e-privacidade/como-deletar-minha-conta/621889ac3df9251d7ed0da18",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x97b,
		.name = "ÇiçekSepeti",
		.query = "ciceksepeti",
		.url = "https://www.ciceksepeti.com/gizlilik-sozlesmesi",
		.email = "mailto:kvkk@ciceksepeti.com?subject=Hesap%20Silme%20Talebi&body=Hesab%C4%B1m%C4%B1n%20silinmesini%20talep%20ediyorum.%20Ekte%20KVKK%20formum%20bulunmaktad%C4%B1r.",
		.difficulty = 0x1000
	},
	{
		.id = 0x97c,
		.name = "Île-de-France Mobilités Connect",
		.query = "iledefrance mobilites connect",
		.url = "https://www.iledefrance-mobilites.fr/en/aide-et-contacts/iledefrance-mobilites-connect/desactiver-mon-compte-idfm-connect",
		.email = NULL,
		.difficulty = 0x800
	},
	{
		.id = 0x97d,
		.name = "ÖBB",
		.query = "obb",
		.url = "https://www.oebb.at/en/fragen-und-antworten/tickets-kaufen/online-mobile-ticketing/registrierung",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x97e,
		.name = "Мій Клас",
		.query = "міи клас",
		.url = "https://www.miyklas.com.ua/Account/DeleteProfile",
		.email = NULL,
		.difficulty = 0x400
	},
	{
		.id = 0x97f,
		.name = "РешуОГЭ/РешуЕГЭ/СдамГИА",
		.query = "решуогэрешуегэсдамгиа",
		.url = "https://chem-ege.sdamgia.ru/profile",
		.email = NULL,
		.difficulty = 0x400
	},

};

#endif
