# Translation Reference

This is a reference guide for translating, so that one can see where each key fits in the website.

## Header

- `title`: Website title and tagline
- `name`: Language name
- `tagline`: The slogan of the website
- `about`: Button that skips to the end of the page until the credits
- `extension_browser`: Button that takes to the Chrome/Firefox browser extensions
- `contribute`: Button to go to the GitHub repository
- `twitter`: Button to tweet about JDM
- `jgmd`: Invitation to visit the sibling website "Just Get My Data"

## Body

- `popular`: Button to filter by popular websites
- `difficulty`: Button to filter by a chosen difficulty
- `reset`: Button to reset filtering
- `noresults`: Description used when the filtering conditions lead to no results
- `noresultshelp`: Description of hyperlink that takes to the JDM repository
- `difficulty_easy`: Word for "easy" difficulty
- `difficulty_medium`: Word for "medium" difficulty
- `difficulty_hard`: Word for "hard" difficulty
- `difficulty_limited`: Word for "limited availability" difficulty
- `difficulty_impossible`: Word for "impossible" difficulty
- `search`: Placeholder text for the general search field
- `sendmail`: Text for hyperlink that opens up the new mail to be composed
- `showinfo`: Text for button that shows notes of an entry
- `hideinfo`: Text for button that hides notes of an entry
- `noinfo`: Text shown when entry has no notes
- `defaultnote_easy`: Text shown when entry has no notes and deletion is accomplished by going to the linked URL
- `defaultnote_email`: Text shown when entry has no notes and deletion is accomplished by emailing a company representative

## Footer

- `whatisthis`: Title of the section with the explanation about the website
- `whatisthis[1-3]`: Phrase that describes the website, pieced together as "`whatisthis1` `whatisthis2` `whatisthis3`".
  `whatisthis2` is the "dark patterns" hyperlink text
- `whatisthis4`: Second paragraph explaining the website
- `pullrequest`: Text for the hyperlink that takes to the JDM GitHub webpage
- `guide`: Title for the section explaining how difficulties work
- `guideexplanations`: Sentence introducing the guide
- `guideeasy`: Short sentence explaining what "easy" means
- `guidemedium`: Short sentence explaining what "medium" means
- `guidehard`: Short sentence explaining what "hard" means
- `guidelimited`: Short sentence explaining what "limited availability" means
- `guideimpossible`: Short sentence explaining what "impossible" means
- `extension_browser`: Title for the section explaining about the Chrome/Firefox browser extensions
- `extensionguide`: Sentence introducing the extension section
- `extensionp1`: Explains what the extensions do
- `extensionp[2-5]`: Last paragraph showing how to install the extensions. It is written as "`extensionp2` +
  `extensionp3`/`extensionp4` + `extensionp5`" where `extensionp3` and `extensionp4` are the texts for the hyperlinks of
  the Chrome Web Store and Firefox Add-ons, respectively. `extensionp5` is expected to either be an empty string, or
  include leading space (as needed) between the prior link and a trailing period.
- `footercredits`: Text to introduce creators
