#if !defined(UNACCENTS_H)
#define UNACCENTS_H

char* unaccent(char* s);

struct Accent {
	char pattern[8];
	char replacement[8];
};

static const struct Accent ACCENTS[] = {
	{
		.pattern = {0xc3, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc3, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc6, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc6, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc6, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc6, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xba, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0xbb, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd8, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x8e, 0xe2, 0x80, 0x8e, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0x90, 0xe2, 0x80, 0x8e, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xba, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xba, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xba, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd9, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xda, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdb, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8a, 0xd0, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xaa, 0xd0, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8a, 0xd0, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xaa, 0xd0, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8b, 0xd0, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xab, 0xd0, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xab, 0xd0, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8b, 0xd0, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc8, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc8, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc8, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc8, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd4, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0xb8, 0xd6, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x88, 0xd5, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x88, 0xd6, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd5, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd6, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x65, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe1, 0x83, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xde, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xcf, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xce, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0xa2, 0xd1, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x82, 0xd1, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc5, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd0, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd2, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd1, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xd2, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc2, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc2, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xdf, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe0, 0xa7, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe0, 0xab, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe0, 0xb8, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x82, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xb9, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xbf, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xbf, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xef, 0xbf, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x90, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x91, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x92, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x93, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x94, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x95, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x96, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x97, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x98, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x99, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x71, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x75, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x77, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9a, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x62, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9b, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9c, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9d, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x76, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x64, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x7a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x74, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x79, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9e, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x73, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x65, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x69, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x6b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x72, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x8a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x8b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x61, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x62, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x63, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x64, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x66, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x67, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x68, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x69, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6b, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6c, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6d, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6e, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6f, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x70, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x71, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x72, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x73, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x74, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x75, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x76, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x77, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x78, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x79, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x7a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x41, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x42, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x43, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x44, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x45, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x46, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x47, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x48, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x49, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x4a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x4b, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x4c, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x4e, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x4f, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x50, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x51, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x52, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x53, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x54, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x55, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x56, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x57, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x58, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x59, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x5a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x61, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x62, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x62, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x63, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x65, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x66, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x67, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x68, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x69, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6b, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6c, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6d, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6e, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x6f, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0x9f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x70, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x71, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x72, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x73, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x74, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x75, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x76, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x77, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x78, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x79, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x28, 0x7a, 0x29, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x63, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x67, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xc4, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x8f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x90, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x92, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x93, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x94, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x95, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x96, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x97, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xad, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xae, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xbe, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9d, 0x9f, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xa9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x91, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x81, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x82, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x83, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x84, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x85, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x87, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x88, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8c, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8d, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8e, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x8f, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x91, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x92, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x31, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x93, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x32, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x94, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x33, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x95, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x34, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x96, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x35, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x97, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x36, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x98, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x37, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x99, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x38, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9a, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x39, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x92, 0x9b, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x30, 0x2e, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xaa, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xab, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xac, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xad, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xae, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb0, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb1, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb2, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb3, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb4, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb5, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb6, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb7, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb8, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xba, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xbb, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xbc, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xbe, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x93, 0xbf, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x26, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xe2, 0x80, 0xbd, 0x00, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x3f, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x3f, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x3f, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x3f, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x2f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x99, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0xa9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9c, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x66, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xa7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xa8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xaa, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xab, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xac, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x9d, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x33, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x92, 0xaf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x99, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x42, 0x41, 0x43, 0x4b, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9a, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x4e, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9b, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4f, 0x4e, 0x21, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9c, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x4f, 0x4f, 0x4e, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9d, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x4f, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0xa4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x62, 0x63, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0xa0, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x42, 0x43, 0x44, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0xa1, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x61, 0x62, 0x63, 0x64, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0xa2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x32, 0x33, 0x34, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0xa3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x26, 0x40, 0x25, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x23, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x23, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x2a, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x2a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x30, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x31, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x32, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x32, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x33, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x34, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x35, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x35, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x36, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x37, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x37, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x38, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0x39, 0xef, 0xb8, 0x8f, 0xe2, 0x83, 0xa3, 0x00},
		.replacement = {0x39, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x94, 0x9f, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x31, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb0, 0xef, 0xb8, 0x8f, 0x00},
		.replacement = {0x41, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb1, 0xef, 0xb8, 0x8f, 0x00},
		.replacement = {0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x8e, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x41, 0x42, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x91, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xbe, 0xef, 0xb8, 0x8f, 0x00},
		.replacement = {0x4f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xbf, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x98, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x4f, 0x53, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb2, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x43, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb3, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb4, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb5, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x46, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb6, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x47, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb7, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb8, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x49, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xb9, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xba, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xbb, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xbc, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x85, 0xbd, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x4e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x80, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x81, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x52, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x82, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x53, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x83, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x84, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x55, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x85, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x56, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x86, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x57, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x87, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x88, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	},
	{
		.pattern = {0xf0, 0x9f, 0x86, 0x89, 0x00, 0x00, 0x00, 0x00},
		.replacement = {0x5a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}
	}
};

#endif
