"use strict";

import { View, TextInput, StyleSheet, Platform } from 'react-native';
import { useTheme, TouchableRipple } from 'react-native-paper';
import Color from 'color';
import { inputTypes, useInputColors } from './timeUtils';
import { forwardRef, useEffect, useState } from 'react';
import React from 'react';
import { sharedStyles } from '../shared/styles';
import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
function TimeInput({
  value,
  clockType,
  pressed,
  onPress,
  onChanged,
  inputType,
  inputFontSize = 57,
  ...rest
}, ref) {
  const theme = useTheme();
  const [inputFocused, setInputFocused] = useState(false);
  const [controlledValue, setControlledValue] = useState(`${value}`);
  const highlighted = inputType === inputTypes.picker ? pressed : inputFocused;
  const {
    color,
    backgroundColor
  } = useInputColors(highlighted);
  useEffect(() => {
    setControlledValue(`${value}`);
  }, [value]);
  const onInnerChange = number => {
    setControlledValue(`${number}`);
    if (number >= 0) {
      onChanged(Number(number));
    }
  };
  let formattedValue = controlledValue;
  if (!inputFocused) {
    formattedValue = controlledValue.length === 1 ? `0${controlledValue}` : `${controlledValue}`;
  }
  return /*#__PURE__*/_jsxs(View, {
    style: [styles.root,
    // eslint-disable-next-line react-native/no-inline-styles
    {
      backgroundColor,
      borderRadius: theme.roundness * 2,
      borderColor: theme.isV3 && highlighted ? theme.colors.onPrimaryContainer : undefined,
      borderWidth: theme.isV3 && highlighted ? 2 : 0,
      height: inputType === inputTypes.keyboard ? 72 : 80
    }],
    children: [/*#__PURE__*/_jsx(TextInput, {
      ref: ref,
      textAlign: "center",
      style: [
      // eslint-disable-next-line react-native/no-inline-styles
      {
        color,
        fontFamily: theme?.isV3 ? theme.fonts.titleMedium.fontFamily : theme.fonts.medium.fontFamily,
        fontSize: inputFontSize,
        lineHeight: Platform.OS === 'android' ? Math.max(inputFontSize, 48) : undefined,
        paddingTop: Platform.OS === 'android' ? 10 : undefined,
        paddingBottom: Platform.OS === 'android' ? 0 : undefined
      }],
      maxFontSizeMultiplier: 1.5,
      value: formattedValue,
      maxLength: 2,
      onFocus: () => setInputFocused(true),
      onBlur: () => setInputFocused(false),
      keyboardAppearance: theme.dark ? 'dark' : 'default',
      keyboardType: "number-pad",
      onChangeText: e => onInnerChange(Number(e)),
      ...rest
    }), onPress && inputType === inputTypes.picker ? /*#__PURE__*/_jsx(TouchableRipple, {
      style: [StyleSheet.absoluteFill, sharedStyles.overflowHidden, {
        borderRadius: theme.roundness
      }],
      rippleColor: Platform.OS !== 'ios' ? Color(theme.colors.onSurface).fade(0.7).hex() : undefined,
      onPress: () => onPress(clockType),
      borderless: true,
      children: /*#__PURE__*/_jsx(View, {})
    }) : null]
  });
}
const styles = StyleSheet.create({
  root: {
    alignItems: 'center',
    justifyContent: 'center',
    width: 96
  }
});
export default /*#__PURE__*/forwardRef(TimeInput);
//# sourceMappingURL=TimeInput.js.map