"use strict";

import { ScrollView, StyleSheet, View } from 'react-native';
import { getHorizontalMonthOffset, getIndexFromVerticalOffset, getMonthHeight, getVerticalMonthsOffset, montHeaderHeight } from './Month';
import { useYearChange } from './SwiperUtils';
import { beginOffset, estimatedMonthHeight, totalMonths } from './dateUtils';
import AutoSizer from './AutoSizer';
import { memo, useCallback, useRef, useState } from 'react';
import React from 'react';
import { sharedStyles } from '../shared/styles';
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
function getVisibleArray(i, {
  isHorizontal,
  height
}) {
  if (isHorizontal || height < 700) {
    return [i - 1, i, i + 1];
  }
  return [i - 2, i - 1, i, i + 1, i + 2];
}
function Swiper(props) {
  return /*#__PURE__*/_jsx(AutoSizer, {
    children: ({
      width,
      height
    }) => /*#__PURE__*/_jsx(SwiperInner, {
      ...props,
      width: width,
      height: height
    })
  });
}
function SwiperInner({
  scrollMode,
  renderItem,
  renderHeader,
  renderFooter,
  selectedYear,
  initialIndex,
  width,
  height,
  startWeekOnMonday
}) {
  const idx = useRef(initialIndex);
  const isHorizontal = scrollMode === 'horizontal';
  const [visibleIndexes, setVisibleIndexes] = useState(getVisibleArray(initialIndex, {
    isHorizontal,
    height
  }));
  const parentRef = useRef(null);
  const scrollTo = useCallback((index, animated) => {
    idx.current = index;
    setVisibleIndexes(getVisibleArray(index, {
      isHorizontal,
      height
    }));
    if (!parentRef.current) {
      return;
    }
    const offset = isHorizontal ? getHorizontalMonthOffset(index, width) : getVerticalMonthsOffset(index, startWeekOnMonday) - montHeaderHeight;
    if (isHorizontal) {
      parentRef.current.scrollTo({
        y: 0,
        x: offset,
        animated
      });
    } else {
      parentRef.current.scrollTo({
        y: offset,
        x: 0,
        animated
      });
    }
  }, [parentRef, isHorizontal, width, height, startWeekOnMonday]);
  const onPrev = useCallback(() => {
    scrollTo(idx.current - 1, true);
  }, [scrollTo, idx]);
  const onNext = useCallback(() => {
    scrollTo(idx.current + 1, true);
  }, [scrollTo, idx]);
  const scrollToInitial = useCallback(() => {
    scrollTo(idx.current, false);
  }, [scrollTo]);
  const onMomentumScrollEnd = useCallback(e => {
    const contentOffset = e.nativeEvent.contentOffset;
    const viewSize = e.nativeEvent.layoutMeasurement;
    const newIndex = isHorizontal ? Math.floor(contentOffset.x / viewSize.width) : getIndexFromVerticalOffset(contentOffset.y - beginOffset, startWeekOnMonday);
    if (newIndex === 0) {
      return;
    }
    if (idx.current !== newIndex) {
      idx.current = newIndex;
      setVisibleIndexes(getVisibleArray(newIndex, {
        isHorizontal,
        height
      }));
    }
  }, [idx, height, isHorizontal, startWeekOnMonday]);
  const renderProps = {
    index: 0,
    onPrev,
    onNext
  };
  useYearChange(newIndex => {
    if (newIndex) {
      scrollTo(newIndex, false);
    }
  }, {
    selectedYear,
    currentIndexRef: idx
  });
  return /*#__PURE__*/_jsxs(_Fragment, {
    children: [/*#__PURE__*/_jsx(ScrollView, {
      scrollsToTop: false,
      ref: parentRef,
      horizontal: isHorizontal,
      pagingEnabled: isHorizontal,
      style: sharedStyles.root,
      onMomentumScrollEnd: onMomentumScrollEnd,
      onScrollEndDrag: onMomentumScrollEnd,
      onLayout: scrollToInitial,
      showsHorizontalScrollIndicator: false,
      showsVerticalScrollIndicator: false,
      decelerationRate: "fast",
      scrollEventThrottle: 10,
      children: /*#__PURE__*/_jsx(View, {
        style: [styles.inner, {
          height: isHorizontal ? height : estimatedMonthHeight * totalMonths,
          width: isHorizontal ? width * totalMonths : width
        }],
        children: visibleIndexes ? new Array(visibleIndexes.length).fill(undefined).map((_, vi) => /*#__PURE__*/_jsx(View, {
          // eslint-disable-next-line react-native/no-inline-styles
          style: {
            top: isHorizontal ? 0 : getVerticalMonthsOffset(visibleIndexes[vi], startWeekOnMonday),
            left: isHorizontal ? getHorizontalMonthOffset(visibleIndexes[vi], width) : 0,
            right: isHorizontal ? undefined : 0,
            bottom: isHorizontal ? 0 : undefined,
            position: 'absolute',
            width: isHorizontal ? width : undefined,
            height: isHorizontal ? undefined : getMonthHeight(scrollMode, visibleIndexes[vi], startWeekOnMonday)
          },
          children: renderItem({
            index: visibleIndexes[vi],
            onPrev: onPrev,
            onNext: onNext
          })
        }, vi)) : null
      })
    }), renderHeader && renderHeader(renderProps), renderFooter && renderFooter(renderProps)]
  });
}
const styles = StyleSheet.create({
  inner: {
    position: 'relative'
  }
});
export default /*#__PURE__*/memo(Swiper);
//# sourceMappingURL=Swiper.native.js.map