"use strict";

import { View } from 'react-native';
import { getIndexFromVerticalOffset, getMonthHeight, getVerticalMonthsOffset, montHeaderHeight } from './Month';
import { beginOffset, estimatedMonthHeight, totalMonths } from './dateUtils';
import { useLatest } from '../shared/utils';
import { useYearChange } from './SwiperUtils';
import AutoSizer from './AutoSizer';
import React, { memo, useCallback, useEffect, useLayoutEffect, useRef, useState } from 'react';
import { sharedStyles } from '../shared/styles';
import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
const useIsomorphicLayoutEffect = typeof window !== 'undefined' ? useLayoutEffect : useEffect;
function Swiper({
  scrollMode,
  renderItem,
  renderHeader,
  renderFooter,
  selectedYear,
  initialIndex,
  startWeekOnMonday
}) {
  const isHorizontal = scrollMode === 'horizontal';
  const [index, setIndex] = useState(initialIndex);
  const onPrev = useCallback(() => {
    setIndex(prev => prev - 1);
  }, [setIndex]);
  const onNext = useCallback(() => {
    setIndex(prev => prev + 1);
  }, [setIndex]);
  const renderProps = {
    index,
    onPrev,
    onNext
  };
  const indexRef = useLatest(index);
  useYearChange(newIndex => {
    if (newIndex) {
      setIndex(newIndex);
    }
  }, {
    selectedYear,
    currentIndexRef: indexRef
  });
  return /*#__PURE__*/_jsxs(_Fragment, {
    children: [renderHeader && renderHeader(renderProps), isHorizontal ? /*#__PURE__*/_jsx(View, {
      style: sharedStyles.root,
      children: renderItem({
        index,
        onPrev,
        onNext
      })
    }) : /*#__PURE__*/_jsx(AutoSizer, {
      children: ({
        width,
        height
      }) => /*#__PURE__*/_jsx(VerticalScroller, {
        width: width,
        height: height,
        initialIndex: initialIndex,
        estimatedHeight: estimatedMonthHeight,
        renderItem: renderItem,
        startWeekOnMonday: startWeekOnMonday
      })
    }), renderFooter && renderFooter(renderProps)]
  });
}
const visibleArray = i => [i - 2, i - 1, i, i + 1, i + 2];
function VerticalScroller({
  width,
  height,
  initialIndex,
  estimatedHeight,
  renderItem,
  startWeekOnMonday
}) {
  const [visibleIndexes, setVisibleIndexes] = useState(visibleArray(initialIndex));
  const idx = useRef(initialIndex);
  const parentRef = useRef(null);
  useIsomorphicLayoutEffect(() => {
    const element = parentRef.current;
    if (!element) {
      return;
    }
    const top = getVerticalMonthsOffset(idx.current, startWeekOnMonday) - montHeaderHeight;
    element.scrollTo({
      top
    });
  }, [parentRef, idx]);
  const setVisibleIndexesThrottled = useDebouncedCallback(setVisibleIndexes);
  const onScroll = useCallback(e => {
    const top = e.currentTarget?.scrollTop;
    if (top === 0) {
      return;
    }
    const offset = top - beginOffset;
    const index = getIndexFromVerticalOffset(offset, startWeekOnMonday);
    if (idx.current !== index) {
      idx.current = index;
      setVisibleIndexesThrottled(visibleArray(index));
    }
  }, [setVisibleIndexesThrottled, startWeekOnMonday]);
  return /*#__PURE__*/_jsx("div", {
    ref: parentRef
    // eslint-disable-next-line react-native/no-inline-styles
    ,
    style: {
      height,
      width,
      overflow: 'auto'
    },
    onScroll: onScroll,
    children: /*#__PURE__*/_jsx("div", {
      // eslint-disable-next-line react-native/no-inline-styles
      style: {
        height: estimatedHeight * totalMonths,
        position: 'relative'
      },
      children: [0, 1, 2, 3, 4].map(vi => /*#__PURE__*/_jsx("div", {
        // eslint-disable-next-line react-native/no-inline-styles
        style: {
          willChange: 'transform',
          transform: `translateY(${getVerticalMonthsOffset(visibleIndexes[vi], startWeekOnMonday)}px)`,
          left: 0,
          right: 0,
          position: 'absolute',
          height: getMonthHeight('vertical', visibleIndexes[vi], startWeekOnMonday)
        },
        children: renderItem({
          index: visibleIndexes[vi],
          onPrev: empty,
          onNext: empty
        })
      }, vi))
    })
  });
}
const empty = () => null;
export function useDebouncedCallback(callback) {
  const mounted = useRef(true);
  const timerId = useRef(null);
  const latest = useLatest(callback);
  useEffect(() => {
    return () => {
      mounted.current = false;
      if (timerId.current) {
        window.cancelAnimationFrame(timerId.current);
      }
    };
  }, [mounted, timerId]);
  return useCallback(args => {
    if (timerId.current) {
      window.cancelAnimationFrame(timerId.current);
    }
    timerId.current = window.requestAnimationFrame(function () {
      if (mounted.current) {
        latest.current(args);
      }
    });
  }, [mounted, timerId, latest]);
}
export default /*#__PURE__*/memo(Swiper);
//# sourceMappingURL=Swiper.js.map