"use strict";

import React from 'react';
import { Animated, StyleSheet } from 'react-native';
import { useHeaderBackgroundColor } from '../shared/utils';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import { jsx as _jsx } from "react/jsx-runtime";
export default function DatePickerModalHeaderBackground({
  children
}) {
  const backgroundColor = useHeaderBackgroundColor();
  const insets = useSafeAreaInsets();
  return /*#__PURE__*/_jsx(Animated.View, {
    style: [styles.animated, {
      backgroundColor,
      paddingLeft: insets.left,
      paddingRight: insets.right
    }],
    children: children
  });
}
const styles = StyleSheet.create({
  animated: {
    elevation: 4
  }
});
//# sourceMappingURL=DatePickerModalHeaderBackground.js.map