"use strict";

import React from 'react';
import { Animated, StyleSheet } from 'react-native';
import { Appbar, Button, useTheme } from 'react-native-paper';
import { useHeaderTextColor } from '../shared/utils';
import { getTranslation } from '../translations/utils';
import { useSafeAreaInsets } from 'react-native-safe-area-context';
import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
export default function DatePickerModalHeader(props) {
  const {
    locale,
    closeIcon = 'close'
  } = props;
  const saveLabel = props.saveLabel || getTranslation(locale, 'save');
  const color = useHeaderTextColor();
  const insets = useSafeAreaInsets();
  const theme = useTheme();
  return /*#__PURE__*/_jsx(_Fragment, {
    children: /*#__PURE__*/_jsx(Animated.View, {
      style: [styles.animated, {
        paddingLeft: insets.left,
        paddingRight: insets.right
      }],
      children: /*#__PURE__*/_jsxs(Appbar, {
        style: styles.appbarHeader,
        children: [/*#__PURE__*/_jsx(Appbar.Action, {
          icon: closeIcon,
          accessibilityLabel: getTranslation(locale, 'close'),
          onPress: props.onDismiss,
          color: color,
          testID: "react-native-paper-dates-close"
        }), /*#__PURE__*/_jsx(Appbar.Content, {
          title: ""
        }), /*#__PURE__*/_jsx(Button, {
          textColor: theme.isV3 ? theme.colors.primary : color,
          onPress: props.onSave,
          disabled: props.saveLabelDisabled ?? false,
          uppercase: props.uppercase ?? true,
          contentStyle: styles.buttonStyle,
          testID: "react-native-paper-dates-save",
          children: saveLabel
        })]
      })
    })
  });
}
const styles = StyleSheet.create({
  animated: {
    elevation: 4
  },
  appbarHeader: {
    elevation: 0,
    backgroundColor: 'transparent'
  },
  buttonStyle: {
    paddingHorizontal: 8
  }
});
//# sourceMappingURL=DatePickerModalHeader.js.map