"use strict";

import { TextInput } from 'react-native-paper';
import DatePickerModal from './DatePickerModal';
import { useLatest } from '../shared/utils';
import DatePickerInputWithoutModal from './DatePickerInputWithoutModal';
import { Platform } from 'react-native';
import { forwardRef, useCallback, useState } from 'react';
import React from 'react';
import { jsx as _jsx } from "react/jsx-runtime";
function DatePickerInput({
  withModal = true,
  calendarIcon = 'calendar',
  animationType = Platform.select({
    web: 'none',
    default: 'slide'
  }),
  presentationStyle = 'overFullScreen',
  ...rest
}, ref) {
  const [visible, setVisible] = useState(false);
  const onChangeRef = useLatest(rest.onChange);
  const onDismiss = useCallback(() => {
    setVisible(false);
  }, [setVisible]);
  const onInnerConfirm = useCallback(({
    date
  }) => {
    setVisible(false);
    onChangeRef.current(date);
  }, [setVisible, onChangeRef]);
  return /*#__PURE__*/_jsx(DatePickerInputWithoutModal, {
    ref: ref,
    ...rest,
    inputButton: withModal ? /*#__PURE__*/_jsx(TextInput.Icon, {
      size: rest.iconSize ?? 24,
      icon: calendarIcon,
      color: rest.iconColor ?? undefined,
      forceTextInputFocus: false,
      disabled: rest.disabled,
      onPress: () => setVisible(true),
      style: rest.iconStyle,
      testID: `${rest.testID || 'date-picker'}-icon-button`
    }) : null
    // eslint-disable-next-line react/no-unstable-nested-components
    ,
    modal: ({
      value,
      locale,
      inputMode,
      validRange,
      saveLabel,
      saveLabelDisabled,
      uppercase,
      startYear,
      endYear,
      inputEnabled,
      disableStatusBarPadding,
      startWeekOnMonday
    }) => withModal ? /*#__PURE__*/_jsx(DatePickerModal, {
      date: value,
      mode: "single",
      visible: visible,
      onDismiss: onDismiss,
      onConfirm: onInnerConfirm,
      locale: locale,
      dateMode: inputMode,
      validRange: validRange,
      saveLabel: saveLabel,
      saveLabelDisabled: saveLabelDisabled ?? false,
      uppercase: uppercase,
      startYear: startYear ?? 1800,
      endYear: endYear ?? 2200,
      inputEnabled: inputEnabled,
      disableStatusBarPadding: disableStatusBarPadding ?? false,
      animationType: animationType,
      presentationStyle: presentationStyle,
      label: rest.label,
      startWeekOnMonday: startWeekOnMonday,
      withDateFormatInLabel: rest.withDateFormatInLabel,
      placeholder: rest.placeholder
    }) : null
  });
}
export default /*#__PURE__*/forwardRef(DatePickerInput);
//# sourceMappingURL=DatePickerInput.js.map